# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ResourceSkuCapacity(Model):
    """Describes scaling information of a SKU.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar minimum: The minimum capacity.
    :vartype minimum: int
    :ivar maximum: The maximum capacity that can be set.
    :vartype maximum: int
    :ivar default: The default capacity.
    :vartype default: int
    :ivar scale_type: The scale type applicable to the sku. Possible values
     include: 'automatic', 'manual', 'none'
    :vartype scale_type: str or
     ~azure.mgmt.apimanagement.models.ResourceSkuCapacityScaleType
    """

    _validation = {
        'minimum': {'readonly': True},
        'maximum': {'readonly': True},
        'default': {'readonly': True},
        'scale_type': {'readonly': True},
    }

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResourceSkuCapacity, self).__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default = None
        self.scale_type = None
