# PySNMP SMI module. Autogenerated from smidump -f python DOT3-EPON-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:38:53 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Counter64, Integer32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Counter64", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( MacAddress, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "MacAddress", "TruthValue")

# Objects

dot3EponMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 155)).setRevisions(("2007-03-29 00:00",))
if mibBuilder.loadTexts: dot3EponMIB.setOrganization("IETF Ethernet Interfaces and Hub MIB Working\nGroup")
if mibBuilder.loadTexts: dot3EponMIB.setContactInfo("WG charter:\nhttp://www.ietf.org/html.charters/hubmib-charter.html\n    Mailing Lists:\n      General Discussion: hubmib@ietf.org\n      To Subscribe: hubmib-request@ietf.org\n\n\n\n      In Body: subscribe your_email_address\n      Chair: Bert Wijnen\n      Postal: Lucent Technologies\n              Schagen 33\n              3461 GL Linschoten\n              Netherlands\n      Tel: +31-348-407-775\n      E-mail: bwijnen@lucent.com\n\n      Editor: Lior Khermosh\n      Postal: PMC-SIERRA\n              Kohav Hertzelia bldg,\n              4 Hasadnaot St.\n              Hertzliya Pituach 46120,\n              ISRAEL\n              P.O.Box 2089 Hertzliya Pituach 46120 Israel\n      Tel: +972-9-9628000 Ext: 302\n      E-mail: lior_khermosh@pmc-sierra.com")
if mibBuilder.loadTexts: dot3EponMIB.setDescription("The objects in this MIB module are used to manage the\nEthernet in the First Mile (EFM) Ethernet Passive Optical\nNetwork (EPON) Interfaces as defined in IEEE P802.3ah\nclauses 60, 64, and 65.\nThe following reference is used throughout this MIB module:\n[802.3ah] refers to:\nInformation technology - Telecommunications and\ninformation exchange between systems - Local and\nmetropolitan area networks - Specific requirements -\nPart 3: Carrier sense multiple access with collision\ndetection (CSMA/CD) access method and physical layer\nspecifications - Media Access Control Parameters,\nPhysical Layers and Management Parameters for subscriber\naccess networks.  IEEE Std 802.3ah-2004, October 2004.\n\nOf particular interest are clause 64 (Multi-Point Control\nProtocol - MPCP), clause 65 (Point-to-Multipoint\nReconciliation Sublayer - P2MP RS), clause 60 (Ethernet\nPassive Optical Network Physical Medium Dependent - EPON\nPMDs), clause 30, 'Management', and clause 45, 'Management\nData Input/Output (MDIO) Interface'.\n\nCopyright (C) The IETF Trust (2007).  This version\nof this MIB module is part of 4837; see the RFC itself for\nfull legal notices.\n\nKey abbreviations:\nBER - Bit Error Rate\nBW - bandwidth\n\n\n\nCRC - Cyclic Redundancy Check\nEFM - Ethernet First Mile\nEPON - Ethernet Passive Optical Network\nFEC  - Forward Error Correction\nLLID - Logical Link Identifier\nMAC - Media Access Control\nMbps - Megabit per second\nMDIO - Management Data Input/Output\nMPCP - Multi-Point Control Protocol\nOLT - Optical Line Terminal (Server unit of the EPON)\nOMP - Optical Multi-Point\nONU - Optical Network Unit (Client unit of the EPON)\nP2MP - Point-to-Multipoint\nPHY - Physical Layer\nPMD - Physical Medium Dependent\nPON - Passive Optical Network\nRTT - Round Trip Time\nSLD - Start of LLID Delimiter\nTQ - Time Quanta")
dot3EponObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 155, 1))
dot3EponMpcpObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 155, 1, 1))
dot3MpcpControlTable = MibTable((1, 3, 6, 1, 2, 1, 155, 1, 1, 1))
if mibBuilder.loadTexts: dot3MpcpControlTable.setDescription("A Table of dot3 Multi-Point Control Protocol (MPCP)\nMIB objects.  The entries in the table are control and\nstatus objects of the MPCP.\nEach object has a row for every virtual link denoted by\nthe corresponding ifIndex.\nThe LLID field, as defined in the [802.3ah], is a 2-byte\nregister (15-bit field and a broadcast bit) limiting the\nnumber of virtual links to 32768.  Typically the number\n\n\n\nof expected virtual links in a PON is like the number of\nONUs, which is 32-64, plus an additional entry for\nbroadcast LLID (with a value of 0xffff).")
dot3MpcpControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dot3MpcpControlEntry.setDescription("An entry in the dot3 MPCP Control table.\nRows exist for an OLT interface and an ONU interface.\nA row in the table is denoted by the ifIndex of the link\nand it is created when the ifIndex is created.\nThe rows in the table for an ONU interface are created\nat system initialization.\nThe row in the table corresponding to the OLT ifIndex\nand the row corresponding to the broadcast virtual link\nare created at system initialization.\nA row in the table corresponding to the ifIndex of a\nvirtual links is created when a virtual link is\nestablished (ONU registers) and deleted when the virtual\nlink is deleted (ONU deregisters).")
dot3MpcpOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 1), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpOperStatus.setDescription("This object reflects the operational state of the\nMulti-Point MAC Control sublayer as defined in\n\n\n\n[802.3ah], clause 64.  When the value is true(1), the\ninterface will act as if the Multi-Point Control Protocol\nis enabled.  When the value is false(2), the interface\nwill act as if the Multi-Point Control Protocol is\ndisabled.  The operational state can be changed using the\ndot3MpcpAdminState object.\nThis object is applicable for an OLT, with the same\nvalue for all virtual interfaces, and for an ONU.")
dot3MpcpAdminState = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 2), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3MpcpAdminState.setDescription("This object is used to define the admin state of the\nMulti-Point MAC Control sublayer, as defined in\n[802.3ah], clause 64, and to reflect its state.\nWhen selecting the value as true(1), the Multi-Point\nControl Protocol of the interface is enabled.\nWhen selecting the value as false(2), the Multi-Point\nControl Protocol of the interface is disabled.\nThis object reflects the administrative state of the\nMulti-Point Control Protocol of the interface.\nThe write operation is not restricted in this document\nand can be done at any time.  Changing\ndot3MpcpAdminState state can lead to disabling the\nMulti-Point Control Protocol on the respective interface,\nleading to the interruption of service for the users\nconnected to the respective EPON interface.\nThis object is applicable for an OLT, with the same\nvalue for all virtual interfaces, and for an ONU.")
dot3MpcpMode = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("olt", 1), ("onu", 2), )).clone(1)).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpMode.setDescription("This object is used to identify the operational\nstate of the Multi-Point MAC Control sublayer as\ndefined in [802.3ah], clause 64.  Reading olt(1) for an\n\n\n\nOLT (server) mode and onu(2) for an ONU (client) mode.\nThis object is used to identify the operational mode\nfor the MPCP tables.\nThis object is applicable for an OLT, with the same\nvalue for all virtual interfaces, and for an ONU.")
dot3MpcpSyncTime = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpSyncTime.setDescription("An object that reports the 'sync lock time' of the\nOLT receiver in increments of Time Quanta (TQ)-16ns\nas defined in [802.3ah], clauses 60, 64, and 65.  The\nvalue returned shall be (sync lock time ns)/16.  If\nthis value exceeds (2^32-1), the value (2^32-1) shall\nbe returned.  This object is applicable for an OLT,\nwith the same value for all virtual interfaces, and\nfor an ONU.")
dot3MpcpLinkID = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpLinkID.setDescription("An object that identifies the Logical Link\nIdentifier (LLID) associated with the MAC of the virtual\nlink as specified in [802.3ah], clause 65.1.3.2.2.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nThe ONU and the corresponding virtual MAC of the OLT,\nfor the same virtual link, have the same value.\nValue is assigned when the ONU registers.\nValue is freed when the ONU deregisters.")
dot3MpcpRemoteMACAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 6), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpRemoteMACAddress.setDescription("An object that identifies the source_address\nparameter of the last MPCPDUs passed to the MAC Control.\nThis value is updated on reception of a valid frame with\n1) a destination Field equal to the reserved multicast\naddress for MAC Control as specified in [802.3], Annex\n31A; 2) the lengthOrType field value equal to the reserved\nType for MAC Control as specified in [802.3], Annex\n31A; 3) an MPCP subtype value equal to the subtype\nreserved for MPCP as specified in [802.3ah], Annex 31A.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nThe value reflects the MAC address of the remote entity\nand therefore the OLT holds a value for each LLID, which\nis the MAC address of the ONU; the ONU has a single\nvalue that is the OLT MAC address.")
dot3MpcpRegistrationState = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,2,)).subtype(namedValues=NamedValues(("unregistered", 1), ("registering", 2), ("registered", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpRegistrationState.setDescription("An object that identifies the registration state\nof the Multi-Point MAC Control sublayer as defined in\n[802.3ah], clause 64.  When this object has the\nenumeration unregistered(1), the interface is\nunregistered and may be used for registering a link\npartner.  When this object has the enumeration\nregistering(2), the interface is in the process of\nregistering a link-partner.  When this object has the\nenumeration registered(3), the interface has an\nestablished link-partner.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.")
dot3MpcpTransmitElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpTransmitElapsed.setDescription("An object that reports the interval from the last\nMPCP frame transmission in increments of Time Quanta\n(TQ)-16ns.  The value returned shall be (interval from\nlast MPCP frame transmission in ns)/16.  If this value\nexceeds (2^32-1), the value (2^32-1) shall be returned.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.")
dot3MpcpReceiveElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 9), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpReceiveElapsed.setDescription("An object that reports the interval from last MPCP frame\nreception in increments of Time Quanta (TQ)-16ns.  The\nvalue returned shall be (interval from last MPCP frame\nreception in ns)/16.  If this value exceeds (2^32-1), the\nvalue (2^32-1) shall be returned.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.")
dot3MpcpRoundTripTime = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 10), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpRoundTripTime.setDescription("An object that reports the MPCP round trip time in\nincrements of Time Quanta (TQ)-16ns.  The value returned\nshall be (round trip time in ns)/16.  If this value\nexceeds (2^16-1), the value (2^16-1) shall be returned.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.")
dot3MpcpMaximumPendingGrants = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 1, 1, 11), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpMaximumPendingGrants.setDescription("An object that reports the maximum number of grants\nthat an ONU can store for handling.  The maximum number\n\n\n\nof grants that an ONU can store for handling has a\nrange of 0 to 255.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nAt the OLT, the value should be zero.")
dot3MpcpStatTable = MibTable((1, 3, 6, 1, 2, 1, 155, 1, 1, 2))
if mibBuilder.loadTexts: dot3MpcpStatTable.setDescription("This table defines the list of statistics counters of\nan interface implementing the [802.3ah], clause 64 MPCP.\nEach object has a row for every virtual link denoted by\nthe corresponding ifIndex.\nThe LLID field, as defined in the [802.3ah], is a 2-byte\nregister (15-bit field and a broadcast bit) limiting the\nnumber of virtual links to 32768.  Typically the number\nof expected virtual links in a PON is like the number of\nONUs, which is 32-64, plus an additional entry for\nbroadcast LLID (with a value of 0xffff).")
dot3MpcpStatEntry = MibTableRow((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dot3MpcpStatEntry.setDescription("An entry in the table of statistics counters of the\n[802.3ah], clause 64, MPCP interface.\nRows exist for an OLT interface and an ONU interface.\nA row in the table is denoted by the ifIndex of the link\nand it is created when the ifIndex is created.\nThe rows in the table for an ONU interface are created\nat system initialization.\nThe row in the table corresponding to the OLT ifIndex\nand the row corresponding to the broadcast virtual link\nare created at system initialization.\nA row in the table corresponding to the ifIndex of a\nvirtual link is created when a virtual link is\nestablished (ONU registers) and deleted when the virtual\nlink is deleted (ONU deregisters).")
dot3MpcpMACCtrlFramesTransmitted = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 1), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpMACCtrlFramesTransmitted.setDescription("A count of MPCP frames passed to the MAC sublayer for\ntransmission.  This counter is incremented when a\nMA_CONTROL.request service primitive is generated within\nthe MAC control sublayer with an opcode indicating an\nMPCP frame.\nThis object is applicable for an OLT and an ONU.  At the\nOLT it has a distinct value for each virtual interface.\nDiscontinuities of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3MpcpMACCtrlFramesReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 2), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpMACCtrlFramesReceived.setDescription("A count of MPCP frames passed by the MAC sublayer to the\nMAC Control sublayer.  This counter is incremented when a\nReceiveFrame function call returns a valid frame with\n1) a lengthOrType field value equal to the reserved\n\n\n\nType for 802.3_MAC_Control as specified in clause 31.4.1.3,\nand\n2) an opcode indicating an MPCP frame.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3MpcpDiscoveryWindowsSent = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpDiscoveryWindowsSent.setDescription("A count of discovery windows generated.  The counter is\nincremented by one for each generated discovery window.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nAt the ONU, the value should be zero.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3MpcpDiscoveryTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpDiscoveryTimeout.setDescription("A count of the number of times a discovery timeout\noccurs.  Increment the counter by one for each discovery\nprocessing state-machine reset resulting from timeout\nwaiting for message arrival.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3MpcpTxRegRequest = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 5), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpTxRegRequest.setDescription("A count of the number of times a REGISTER_REQ MPCP\nframe transmission occurs.  Increment the counter by one\nfor each REGISTER_REQ MPCP frame transmitted as defined\nin [802.3ah], clause 64.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nAt the OLT, the value should be zero.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3MpcpRxRegRequest = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 6), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpRxRegRequest.setDescription("A count of the number of times a REGISTER_REQ MPCP\nframe reception occurs.\nIncrement the counter by one for each REGISTER_REQ MPCP\nframe received as defined in [802.3ah], clause 64.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nAt the ONU, the value should be zero.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3MpcpTxRegAck = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 7), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpTxRegAck.setDescription("A count of the number of times a REGISTER_ACK MPCP\nframe transmission occurs.  Increment the counter by one\nfor each REGISTER_ACK MPCP frame transmitted as defined\nin [802.3ah], clause 64.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nAt the OLT, the value should be zero.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3MpcpRxRegAck = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 8), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpRxRegAck.setDescription("A count of the number of times a REGISTER_ACK MPCP\nframe reception occurs.\nIncrement the counter by one for each REGISTER_ACK MPCP\nframe received as defined in [802.3ah], clause 64.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nAt the ONU, the value should be zero.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3MpcpTxReport = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 9), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpTxReport.setDescription("A count of the number of times a REPORT MPCP frame\ntransmission occurs.  Increment the counter by one for\neach REPORT MPCP frame transmitted as defined in\n[802.3ah], clause 64.\n\n\n\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nAt the OLT, the value should be zero.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3MpcpRxReport = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 10), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpRxReport.setDescription("A count of the number of times a REPORT MPCP frame\nreception occurs.\nIncrement the counter by one for each REPORT MPCP frame\nreceived as defined in [802.3ah], clause 64.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nAt the ONU, the value should be zero.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3MpcpTxGate = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 11), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpTxGate.setDescription("A count of the number of times a GATE MPCP frame\ntransmission occurs.\nIncrement the counter by one for each GATE MPCP frame\ntransmitted as defined in [802.3ah], clause 64.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nAt the ONU, the value should be zero.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\n\n\n\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3MpcpRxGate = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 12), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpRxGate.setDescription("A count of the number of times a GATE MPCP frame\nreception occurs.\nIncrement the counter by one for each GATE MPCP frame\nreceived as defined in [802.3ah], clause 64.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nAt the OLT, the value should be zero.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3MpcpTxRegister = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 13), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpTxRegister.setDescription("A count of the number of times a REGISTER MPCP frame\ntransmission occurs.\nIncrement the counter by one for each REGISTER MPCP\nframe transmitted as defined in [802.3ah], clause 64.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nAt the ONU, the value should be zero.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3MpcpRxRegister = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 1, 2, 1, 14), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3MpcpRxRegister.setDescription("A count of the number of times a REGISTER MPCP frame\nreception occurs.\nIncrement the counter by one for each REGISTER MPCP\nframe received as defined in [802.3ah], clause 64.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nAt the OLT, the value should be zero.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3OmpEmulationObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 155, 1, 2))
dot3OmpEmulationTable = MibTable((1, 3, 6, 1, 2, 1, 155, 1, 2, 1))
if mibBuilder.loadTexts: dot3OmpEmulationTable.setDescription("A table of dot3 OmpEmulation MIB objects.  The table\ncontain objects for the management of the OMPEmulation\nsublayer.\nEach object has a row for every virtual link denoted by\nthe corresponding ifIndex.\nThe LLID field, as defined in the [802.3ah], is a 2-byte\nregister (15-bit field and a broadcast bit) limiting the\nnumber of virtual links to 32768.  Typically the number\nof expected virtual links in a PON is like the number of\nONUs, which is 32-64, plus an additional entry for\nbroadcast LLID (with a value of 0xffff).")
dot3OmpEmulationEntry = MibTableRow((1, 3, 6, 1, 2, 1, 155, 1, 2, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dot3OmpEmulationEntry.setDescription("An entry in the dot3 OmpEmulation table.\nRows exist for an OLT interface and an ONU interface.\nA row in the table is denoted by the ifIndex of the link\nand it is created when the ifIndex is created.\nThe rows in the table for an ONU interface are created\nat system initialization.\nThe row in the table corresponding to the OLT ifIndex\nand the row corresponding to the broadcast virtual link\nare created at system initialization.\nA row in the table corresponding to the ifIndex of a\nvirtual links is created when a virtual link is\nestablished (ONU registers) and deleted when the virtual\nlink is deleted (ONU deregisters).")
dot3OmpEmulationType = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 1, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,2,)).subtype(namedValues=NamedValues(("unknown", 1), ("olt", 2), ("onu", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationType.setDescription("An object that indicates the mode of operation\nof the Reconciliation Sublayer for Point-to-Point\nEmulation (see [802.3ah], clause 65.1).  unknown(1) value\nis assigned in initialization; true state or type is not\nyet known.  olt(2) value is assigned when the sublayer is\noperating in OLT mode.  onu(3) value is assigned when the\nsublayer is operating in ONU mode.\nThis object is applicable for an OLT, with the same\nvalue for all virtual interfaces, and for an ONU.")
dot3OmpEmulationStatTable = MibTable((1, 3, 6, 1, 2, 1, 155, 1, 2, 2))
if mibBuilder.loadTexts: dot3OmpEmulationStatTable.setDescription("This table defines the list of statistics counters of\n\n\n\n[802.3ah], clause 65, OMPEmulation sublayer.\nEach object has a row for every virtual link denoted by\nthe corresponding ifIndex.\nThe LLID field, as defined in the [802.3ah], is a 2-byte\nregister (15-bit field and a broadcast bit) limiting the\nnumber of virtual links to 32768.  Typically the number\nof expected virtual links in a PON is like the number of\nONUs, which is 32-64, plus an additional entry for\nbroadcast LLID (with a value of 0xffff).")
dot3OmpEmulationStatEntry = MibTableRow((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dot3OmpEmulationStatEntry.setDescription("An entry in the table of statistics counters of\n[802.3ah], clause 65, OMPEmulation sublayer.\nRows exist for an OLT interface and an ONU interface.\nA row in the table is denoted by the ifIndex of the link\nand it is created when the ifIndex is created.\nThe rows in the table for an ONU interface are created\nat system initialization.\nThe row in the table corresponding to the OLT ifIndex\nand the row corresponding to the broadcast virtual link\nare created at system initialization.\nA row in the table corresponding to the ifIndex of a\nvirtual links is created when a virtual link is\nestablished (ONU registers) and deleted when the virtual\nlink is deleted (ONU deregisters).")
dot3OmpEmulationSLDErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1, 1), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationSLDErrors.setDescription("A count of frames received that do not contain a valid\nSLD field as defined in [802.3ah], clause 65.1.3.3.1.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3OmpEmulationCRC8Errors = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1, 2), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationCRC8Errors.setDescription("A count of frames received that contain a valid SLD\nfield, as defined in [802.3ah], clause 65.1.3.3.1, but do\nnot pass the CRC-8 check as defined in [802.3ah], clause\n65.1.3.3.3.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3OmpEmulationBadLLID = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1, 3), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationBadLLID.setDescription("A count of frames received that contain a valid SLD\nfield, as defined in [802.3ah], clause 65.1.3.3.1, and\npass the CRC-8 check, as defined in [802.3ah], clause\n65.1.3.3.3, but are discarded due to the LLID check as\ndefined in [802.3ah], clause 65.1.3.3.2.\n\n\n\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3OmpEmulationGoodLLID = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1, 4), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationGoodLLID.setDescription("A count of frames received that contain a valid SLD\nfield, as defined in [802.3ah], clause 65.1.3.3.1, and\npass the CRC-8 check as defined in [802.3ah], clause\n65.1.3.3.3.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3OmpEmulationOnuPonCastLLID = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1, 5), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationOnuPonCastLLID.setDescription("A count of frames received that contain a valid SLD\nfield, as defined in [802.3ah], clause 65.1.3.3.1,\npass the CRC-8 check, as defined in [802.3ah], clause\n65.1.3.3.3, and meet the rules of acceptance for an\nONU defined in [802.3ah], clause 65.1.3.3.2.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nAt the OLT, the value should be zero.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\n\n\n\nmodule.")
dot3OmpEmulationOltPonCastLLID = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1, 6), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationOltPonCastLLID.setDescription("A count of frames received that contain a valid SLD\nfield, as defined in [802.3ah], clause 65.1.3.3.1,\npass the CRC-8 check, as defined in [802.3ah], clause\n65.1.3.3.3, and meet the rules of acceptance for an\nOLT defined in [802.3ah], 65.1.3.3.2.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nAt the ONU, the value should be zero.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3OmpEmulationBroadcastBitNotOnuLlid = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1, 7), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationBroadcastBitNotOnuLlid.setDescription("A count of frames received that contain a valid SLD\nfield, as defined in [802.3ah], clause\n65.1.3.3.1, pass the CRC-8 check, as defined in\n[802.3ah], clause 65.1.3.3.3, and contain the broadcast\nbit in the LLID and not the ONU's LLID (frame accepted)\nas defined in [802.3ah], clause 65.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nAt the OLT, the value should be zero.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3OmpEmulationOnuLLIDNotBroadcast = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1, 8), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationOnuLLIDNotBroadcast.setDescription("A count of frames received that contain a valid SLD\nfield, as defined in [802.3ah], clause\n65.1.3.3.1, pass the CRC-8 check, as defined in\n[802.3ah], clause 65.1.3.3.3, and contain the ONU's LLID\nas defined in [802.3ah], clause 65.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nAt the OLT, the value should be zero.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3OmpEmulationBroadcastBitPlusOnuLlid = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1, 9), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationBroadcastBitPlusOnuLlid.setDescription("A count of frames received that contain a valid SLD\nfield, as defined in [802.3ah], clause\n65.1.3.3.1, pass the CRC-8 check, as defined in\n[802.3ah], clause 65.1.3.3.3, and contain the broadcast\nbit in the LLID and match the ONU's LLID (frame\nreflected) as defined in [802.3ah], clause 65.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nAt the OLT, the value should be zero.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3OmpEmulationNotBroadcastBitNotOnuLlid = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 2, 2, 1, 10), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OmpEmulationNotBroadcastBitNotOnuLlid.setDescription("A count of frames received that contain a valid SLD\nfield, as defined in [802.3ah], clause\n65.1.3.3.1, pass the CRC-8 check, as defined in\n[802.3ah], clause 65.1.3.3.3, and do not contain\nthe ONU's LLID as defined in [802.3ah], clause 65.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nAt the OLT, the value should be zero.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3EponFecObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 155, 1, 3))
dot3EponFecTable = MibTable((1, 3, 6, 1, 2, 1, 155, 1, 3, 1))
if mibBuilder.loadTexts: dot3EponFecTable.setDescription("A table of dot3 EPON FEC management objects.\nThe entries in the table are control and status objects\nand statistic counters for the FEC layer.\nEach object has a row for every virtual link denoted by\nthe corresponding ifIndex.\nThe LLID field, as defined in the [802.3ah], is a 2-byte\nregister (15-bit field and a broadcast bit) limiting the\nnumber of virtual links to 32768.  Typically the number\nof expected virtual links in a PON is like the number of\nONUs, which is 32-64, plus an additional entry for\nbroadcast LLID (with a value of 0xffff).")
dot3EponFecEntry = MibTableRow((1, 3, 6, 1, 2, 1, 155, 1, 3, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dot3EponFecEntry.setDescription("An entry in the dot3 EPON FEC table.\nRows exist for an OLT interface and an ONU interface.\nA row in the table is denoted by the ifIndex of the link\nand it is created when the ifIndex is created.\nThe rows in the table for an ONU interface are created\n\n\n\nat system initialization.\nThe row in the table corresponding to the OLT ifIndex\nand the row corresponding to the broadcast virtual link\nare created at system initialization.\nA row in the table corresponding to the ifIndex of a\nvirtual links is created when a virtual link is\nestablished (ONU registers) and deleted when the virtual\nlink is deleted (ONU deregisters).")
dot3EponFecPCSCodingViolation = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 3, 1, 1, 1), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3EponFecPCSCodingViolation.setDescription("For a 100 Mbps operation, it is a count of the number of\ntimes an invalid code-group is received, other than the\n/H/ code-group.  For a 1000 Mbps operation, it is a count\nof the number of times an invalid codegroup is received,\nother than the /V/ code-group.  /H/ denotes a special\n4b5b codeword of [802.3] 100 Mbps PCS layer (clause 24),\nand /V/ denotes a special 8b10b codeword of the [802.3]\n1000 Mbps PCS layer (clause 36).\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3EponFecAbility = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 3, 1, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,3,)).subtype(namedValues=NamedValues(("unknown", 1), ("supported", 2), ("unsupported", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3EponFecAbility.setDescription("An object that indicates the support of operation of the\noptional FEC sublayer of the 1000BASE-PX PHY specified\nin [802.3ah], clause 65.2.\nunknown(1) value is assigned in the initialization, for non\nFEC support state or type not yet known.  unsupported(3)\nvalue is assigned when the sublayer is not supported.\nsupported(2) value is assigned when the sublayer is\nsupported.\nThis object is applicable for an OLT, with the same\nvalue for all virtual interfaces, and for an ONU.\nThe FEC counters will have a zero value when the\ninterface is not supporting FEC.\nThe counters:\n dot3EponFecPCSCodingViolation - not affected by FEC\n ability.\n dot3EponFecCorrectedBlocks    - has a zero value when\n  dot3EponFecAbility is unknown(1) and unsupported(3).\n dot3EponFecUncorrectableBlocks  - has a zero value when\n  dot3EponFecAbility is unknown(1) and unsupported(3).\n dot3EponFecBufferHeadCodingViolation - has a zero value\n  when dot3EponFecAbility is unknown(1) and\n  unsupported(3).")
dot3EponFecMode = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 3, 1, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,3,)).subtype(namedValues=NamedValues(("unknown", 1), ("disabled", 2), ("enabled", 3), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3EponFecMode.setDescription("An object that defines the mode of operation of the\noptional FEC sublayer of the 1000BASE-PX PHY, specified\nin [802.3ah], clause 65.2, and reflects its state.\nA GET operation returns the current mode of operation\nof the PHY.  A SET operation changes the mode of\noperation of the PHY to the indicated value.\nunknown(1) value is assigned in the initialization for non\n  FEC support state or type not yet known.\n\n\n\ndisabled(2) value is assigned when the FEC sublayer is\n  operating in disabled mode.\nenabled(3) value is assigned when the FEC sublayer is\n  operating in FEC mode.\nThe write operation is not restricted in this document\nand can be done at any time.  Changing dot3EponFecMode\nstate can lead to disabling the Forward Error Correction\non the respective interface, which can lead to a\ndegradation of the optical link, and therefore may lead\nto an interruption of service for the users connected to\nthe respective EPON interface.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nThe counting of\nthe FEC counters will stop when the FEC of the interface\nis disabled.\nThe counters:\n dot3EponFecPCSCodingViolation - not affected by FEC\n mode.\n dot3EponFecCorrectedBlocks - stops counting when\n Rx_FEC is not enabled.  (unknown(1) and disabled(2)).\n dot3EponFecUncorrectableBlocks - stops counting when\n Rx_FEC is not enabled (unknown(1) and disabled(2)).\n dot3EponFecBufferHeadCodingViolation - stops counting\n when Rx_FEC is not enabled (unknown(1) and\n disabled(2)).\nThe object:\n dot3EponFecAbility - indicates the FEC ability and\n is not affected by the dot3EponFecMode object.")
dot3EponFecCorrectedBlocks = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 3, 1, 1, 4), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3EponFecCorrectedBlocks.setDescription("For 10PASS-TS, 2BASE-TL, and 1000BASE-PX PHYs, it is a\ncount of corrected FEC blocks.  This counter will not\nincrement for other PHY Types.  Increment the counter by\none for each received block that is corrected by the FEC\nfunction in the PHY.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\n\n\n\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3EponFecUncorrectableBlocks = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 3, 1, 1, 5), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3EponFecUncorrectableBlocks.setDescription("For 10PASS-TS, 2BASE-TL, and 1000BASE-PX PHYs, it is a\ncount of uncorrectable FEC blocks.  This counter will not\nincrement for other PHY Types.  Increment the counter by\none for each FEC block that is determined to be\nuncorrectable by the FEC function in the PHY.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3EponFecBufferHeadCodingViolation = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 3, 1, 1, 6), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3EponFecBufferHeadCodingViolation.setDescription("For a 1000 Mbps operation, it is a count of the number of\ninvalid code-group received directly from the link.  The\nvalue has a meaning only in 1000 Mbps mode and it is\nzero otherwise.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3ExtPkgObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 155, 1, 4))
dot3ExtPkgControlObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 155, 1, 4, 1))
dot3ExtPkgControlTable = MibTable((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 1))
if mibBuilder.loadTexts: dot3ExtPkgControlTable.setDescription("A table of Extended package Control management\nobjects.  Entries in the table are control and status\nindication objects of an EPON interface, which are\ngathered in an extended package as an addition to the\nobjects based on the [802.3ah], clause 30, attributes.\nEach object has a row for every virtual link denoted by\nthe corresponding ifIndex.\nThe LLID field, as defined in the [802.3ah], is a 2-byte\nregister (15-bit field and a broadcast bit) limiting the\nnumber of virtual links to 32768.  Typically the number\nof expected virtual links in a PON is like the number of\nONUs, which is 32-64, plus an additional entry for\nbroadcast LLID (with a value of 0xffff).")
dot3ExtPkgControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dot3ExtPkgControlEntry.setDescription("An entry in the Extended package Control table.\nRows exist for an OLT interface and an ONU interface.\nA row in the table is denoted by the ifIndex of the link\nand it is created when the ifIndex is created.\nThe rows in the table for an ONU interface are created\nat system initialization.\nThe row in the table corresponding to the OLT ifIndex\nand the row corresponding to the broadcast virtual link\nare created at system initialization.\nA row in the table corresponding to the ifIndex of a\nvirtual links is created when a virtual link is\nestablished (ONU registers) and deleted when the virtual\nlink is deleted (ONU deregisters).")
dot3ExtPkgObjectReset = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 1, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("running", 1), ("reset", 2), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgObjectReset.setDescription("This object is used to reset the EPON interface.  The\ninterface may be unavailable while the reset occurs and\ndata may be lost.\nSetting this object to running(1) will cause the\ninterface to enter into running mode.  Setting this\nobject to reset(2) will cause the interface to go into\nreset mode.  When getting running(1), the interface is in\nrunning mode.  When getting reset(2), the interface is in\nreset mode.\nThe write operation is not restricted in this document\nand can be done at any time.  Changing\ndot3ExtPkgObjectReset state can lead to a reset of the\nrespective interface, leading to an interruption of\nservice for the users connected to the respective EPON\ninterface.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nA reset for a specific virtual interface resets only\nthis virtual interface and not the physical interface.\nThus, a virtual link that is malfunctioning can be\nreset without affecting the operation of other virtual\ninterfaces.\nThe reset can cause Discontinuities in the values of the\ncounters of the interface, similar to re-initialization\nof the management system.  Discontinuity should be\nindicated by the ifCounterDiscontinuityTime object of\nthe Interface MIB module.")
dot3ExtPkgObjectPowerDown = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 1, 1, 2), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgObjectPowerDown.setDescription("This object is used to power down the EPON interface.\nThe interface may be unavailable while the power down\noccurs and data may be lost.\nSetting this object to true(1) will cause the interface\nto enter into power down mode.  Setting this object to\nfalse(2) will cause the interface to go out of power\ndown mode.  When getting true(1), the interface is in\npower down mode.  When getting false(2), the interface is\nnot in power down mode.\nThe write operation is not restricted in this document\nand can be done at any time.  Changing\ndot3ExtPkgObjectPowerDown state can lead to a power down\nof the respective interface, leading to an interruption\nof service of the users connected to the respective EPON\ninterface.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nA power down/up of a specific virtual interface affects\nonly the virtual interface and not the physical\ninterface.  Hence a virtual link, which needs a certain\nhandling, can be powered down and then powered up without\ndisrupting the operation of other virtual interfaces.\nThe object is relevant when the admin state of the\ninterface is active as set by the dot3MpcpAdminState.")
dot3ExtPkgObjectNumberOfLLIDs = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 1, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgObjectNumberOfLLIDs.setDescription("A read only object that indicates the number of\nregistered LLIDs.  The initialization value is 0.\nThis object is applicable for an OLT with the same\nvalue for all virtual interfaces and for an ONU.\nThe LLID field, as defined in the [802.3ah], is a 2-byte\nregister (15-bit field and a broadcast bit) limiting the\nnumber of virtual links to 32768.  Typically the number\nof expected virtual links in a PON is like the number of\nONUs, which is 32-64, plus an additional entry for\nbroadcast LLID (with a value of 0xffff).  At the ONU the\nnumber of LLIDs for an interface is one.")
dot3ExtPkgObjectFecEnabled = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 1, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(4,3,1,2,)).subtype(namedValues=NamedValues(("noFecEnabled", 1), ("fecTxEnabled", 2), ("fecRxEnabled", 3), ("fecTxRxEnabled", 4), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgObjectFecEnabled.setDescription("An object defining the FEC mode of operation of the\ninterface, and indicating its state.  The modes defined in\nthis object are extensions to the FEC modes defined in\nthe dot3EponFecMode object.\nWhen noFECEnabled(1), the interface does not enable FEC\nmode.\nWhen fecTxEnabled(2), the interface enables the FEC\ntransmit mode.\nWhen fecRxEnabled(3), the interface enables the FEC\nreceive mode.\nWhen fecTxRxEnabled(4), the interface enables the FEC\ntransmit and receive mode.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.\nThe FEC counters are referring to the receive path.  The\nFEC counters will stop when the FEC receive mode of the\ninterface is disabled, as defined by fecRxEnabled(3)\nand fecTxRxEnabled(4) values.\nThe counters:\n dot3EponFecPCSCodingViolation - not affected by FEC\n mode.\n dot3EponFecCorrectedBlocks - stops counting when\n Rx_FEC is not enabled (noFecEnabled(1) and\n fecTxEnabled(2)).\n dot3EponFecUncorrectableBlocks - stops counting when\n Rx_FEC is not enabled (noFecEnabled(1) and\n fecTxEnabled(2)).\n dot3EponFecBufferHeadCodingViolation - stops counting\n when Rx_FEC is not enabled (noFecEnabled(1) and\n fecTxEnabled(2)).\nThe objects:\n dot3EponFecAbility - indicates the FEC ability and is\n not affected by the FEC mode.\n dot3EponFecMode - indicates the FEC mode for combined RX\n and TX.\nThe write operation is not restricted in this document\nand can be done at any time.  Changing\ndot3ExtPkgObjectFecEnabled state can lead to disabling\nthe Forward Error Correction on the respective interface,\nwhich can lead to a degradation of the optical link, and\ntherefore may lead to an interruption of service for the\n\n\n\nusers connected to the respective EPON interface.")
dot3ExtPkgObjectReportMaximumNumQueues = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 1, 1, 5), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 7)).clone(0)).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgObjectReportMaximumNumQueues.setDescription("An object, that defines the maximal number of queues in\nthe REPORT message as defined in [802.3ah], clause 64.  For\nfurther information please see the description of the\nqueue table.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.")
dot3ExtPkgObjectRegisterAction = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 1, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,4,)).subtype(namedValues=NamedValues(("none", 1), ("register", 2), ("deregister", 3), ("reregister", 4), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgObjectRegisterAction.setDescription("An object configuring the registration state of an\ninterface, and indicating its registration state.\n Write operation changes the registration state to its new\n value.\n Read operation returns the value of the state.\n The registration state is reflected in this object and in\n the dot3MpcpRegistrationState object.\n none(1) indicates an unknown state,\n register(2) indicates a registered LLID,\n deregister(3) indicates a deregistered LLID,\n reregister(4) indicates an LLID that is reregistering.\n The following list describes the operation of the\n interface, as specified in the [802.3ah], when a write\n operation is setting a value.\n  none(1) - not doing any action.\n  register(2) - registering an LLID that has been requested\n  for registration (The LLID is in registering mode.\n    dot3MpcpRegistrationState - registering(2) ).\n    deregister(3) - deregisters an LLID that is registered\n      (dot3MpcpRegistrationState - registered(3) ).\n\n\n\n    reregister(4) - reregister an LLID that is registered\n      (dot3MpcpRegistrationState - registered(3) ).\n    The behavior of an ONU and OLT interfaces, at each one\n    of the detailed operation at each state, is described in\n    the registration state machine of figure 64-22,\n    [802.3ah].\n   This object is applicable for an OLT and an ONU.  At the\n   OLT, it has a distinct value for each virtual interface.\n   The write operation is not restricted in this document\n   and can be done at any time.  Changing\n   dot3ExtPkgObjectRegisterAction state can lead to a change\n   in the registration state of the respective interface\n   leading to a deregistration and an interruption of\n   service of the users connected to the respective EPON\n   interface.")
dot3ExtPkgQueueTable = MibTable((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 2))
if mibBuilder.loadTexts: dot3ExtPkgQueueTable.setDescription("A table of the extended package objects for queue\nmanagement.  The [802.3ah] MPCP defines a report message\nof the occupancy of the transmit queues for the feedback\nBW request from the ONUs.  These queues serve the uplink\ntransmission of the ONU and data is gathered there until\nthe ONU is granted for transmission.\nThe management table of the queues is added here mainly\nto control the reporting and to gather some statistics\nof their operation.  This table is not duplicating\nexisting management objects of bridging queues,\nspecified in [802.1d], since the existence of a\ndedicated transmit queuing mechanism is implied in the\n[802.3ah], and the ONU may be a device that is not a\nbridge with embedded bridging queues.\nThe format of the REPORT message, as specified\nin [802.3], is presented below:\n+-----------------------------------+\n|          Destination Address      |\n+-----------------------------------+\n|          Source Address           |\n+-----------------------------------+\n|          Length/Type              |\n+-----------------------------------+\n|          OpCode                   |\n+-----------------------------------+\n\n\n\n|          TimeStamp                |\n+-----------------------------------+\n|          Number of queue Sets     |\n+-----------------------------------+   /||          Report bitmap            |    |\n+-----------------------------------+    |\n|          Queue 0 report           |    |\n+-----------------------------------+    | repeated for\n|          Queue 1 report           |    | every\n+-----------------------------------+    | queue_set\n|          Queue 2 report           |    |\n+-----------------------------------+    |\n|          Queue 3 report           |    |\n+-----------------------------------+    |\n|          Queue 4 report           |    |\n+-----------------------------------+    |\n|          Queue 5 report           |    |\n+-----------------------------------+    |\n|          Queue 6 report           |    |\n+-----------------------------------+    |\n|          Queue 7 report           |    |\n+-----------------------------------+   \|/\n|          Pad/reserved             |\n+-----------------------------------+\n|          FCS                      |\n+-----------------------------------+\n\nThe 'Queue report' field reports the occupancy of each\nuplink transmission queue.\nThe number of queue sets defines the number of the\nreported sets, as would be explained in the description\nof the dot3ExtPkgQueueSetsTable table.  For each set the\nreport bitmap defines which queue is present in the\nreport, meaning that although the MPCP REPORT message\ncan report up to 8 queues in a REPORT message, the\nactual number is flexible.  The Queue table has a\nvariable size that is limited by the\ndot3ExtPkgObjectReportMaximumNumQueues object, as an\nONU can have fewer queues to report.\nThe entries in the table are control and status\nindication objects for managing the queues of an EPON\ninterface that are gathered in an extended package as\nan addition to the objects that are based on the\n[802.3ah] attributes.\nEach object has a row for every virtual link and for\nevery queue in the report.\nThe LLID field, as defined in the [802.3ah], is a 2-byte\nregister (15-bit field and a broadcast bit) limiting the\n\n\n\nnumber of virtual links to 32768.  Typically the number\nof expected virtual links in a PON is like the number of\nONUs, which is 32-64, plus an additional entry for\nbroadcast LLID (with a value of 0xffff).\nThe number of queues is between 0 and 7 and limited by\ndot3ExtPkgObjectReportMaximumNumQueues.")
dot3ExtPkgQueueEntry = MibTableRow((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOT3-EPON-MIB", "dot3QueueIndex"))
if mibBuilder.loadTexts: dot3ExtPkgQueueEntry.setDescription("An entry in the Extended package Queue table.  At the\nOLT, the rows exist for each ifIndex and dot3QueueIndex.\nAt the ONU, rows exist for the single ifIndex for each\ndot3QueueIndex.\nRows in the table are created when the ifIndex of the\nlink is created.  A set of rows per queue are added for\neach ifIndex, denoted by the dot3QueueIndex.\nA set of rows per queue in the table, for an ONU\ninterface, are created at the system initialization.\nA set of rows per queue in the table, corresponding to\nthe OLT ifIndex and a set of rows per queue\ncorresponding to the broadcast virtual link, are\ncreated at the system initialization.\nA set of rows per queue in the table, corresponding to\nthe ifIndex of a virtual link, are created when the\nvirtual link is established (ONU registers), and deleted\nwhen the virtual link is deleted (ONU deregisters).")
dot3QueueIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 2, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 7))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dot3QueueIndex.setDescription("An object that identifies an index for the queue table\nreflecting the queue index of the queues that are\nreported in the MPCP REPORT message as defined in\n[802.3ah], clause 64.\nThe number of queues is between 0 and 7, and limited by\ndot3ExtPkgObjectReportMaximumNumQueues.")
dot3ExtPkgObjectReportNumThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 2, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 7)).clone(0)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgObjectReportNumThreshold.setDescription("An object that defines the number of thresholds for each\nqueue in the REPORT message as defined in [802.3ah],\nclause 64.\nEach queue_set reporting will provide information on the\nqueue occupancy of frames below the matching Threshold.\nRead operation reflects the number of thresholds.\nWrite operation sets the number of thresholds for each\nqueue.\nThe write operation is not restricted in this document\nand can be done at any time.  Value cannot exceed the\nmaximal value defined by the\ndot3ExtPkgObjectReportMaximumNumThreshold object.\nChanging dot3ExtPkgObjectReportNumThreshold can lead to\na change in the reporting of the ONU interface and\ntherefore to a change in the bandwidth allocation of the\nrespective interface.  This change may lead a degradation\nor an interruption of service of the users connected to\nthe respective EPON interface.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface\nand for each queue.  At the ONU, it has a distinct value\nfor each queue.")
dot3ExtPkgObjectReportMaximumNumThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 2, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 7)).clone(0)).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgObjectReportMaximumNumThreshold.setDescription("An object, that defines the maximal number of thresholds\nfor each queue in the REPORT message as defined in\n[802.3ah], clause 64.  Each queue_set reporting will\nprovide information on the queue occupancy of frames\nbelow the matching Threshold.\n\n\n\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface\nand for each queue.  At the ONU, it has a distinct value\nfor each queue.")
dot3ExtPkgStatTxFramesQueue = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 2, 1, 4), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgStatTxFramesQueue.setDescription("A count of the number of times a frame transmission\noccurs from the corresponding 'Queue'.\nIncrement the counter by one for each frame transmitted,\nwhich is an output of the 'Queue'.\nThe 'Queue' marking matches the REPORT MPCP message\nQueue field as defined in [802.3ah], clause 64.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface\nand for each queue.  At the ONU, it has a distinct value\nfor each queue.\nAt the OLT the value should be zero.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3ExtPkgStatRxFramesQueue = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 2, 1, 5), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgStatRxFramesQueue.setDescription("A count of the number of times a frame reception\noccurs from the corresponding 'Queue'.\nIncrement the counter by one for each frame received,\nwhich is an input to the corresponding 'Queue'.\nThe 'Queue' marking matches the REPORT MPCP message\nQueue field as defined in [802.3ah], clause 64.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface\nand for each queue.  At the ONU, it has a distinct value\nfor each queue.\nDiscontinuities of this counter can occur at\n\n\n\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3ExtPkgStatDroppedFramesQueue = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 2, 1, 6), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgStatDroppedFramesQueue.setDescription("A count of the number of times a frame drop\noccurs from the corresponding 'Queue'.\nIncrement the counter by one for each frame dropped\nfrom the corresponding 'Queue'.\nThe 'Queue' marking matches the REPORT MPCP message\nQueue field as defined in [802.3ah], clause 64.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface\nand for each queue.  At the ONU, it has a distinct value\nfor each queue.\nAt the OLT, the value should be zero.\nDiscontinuities of this counter can occur at\nre-initialization of the management system and at other\ntimes, as indicated by the value of the\nifCounterDiscontinuityTime object of the Interface MIB\nmodule.")
dot3ExtPkgQueueSetsTable = MibTable((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 3))
if mibBuilder.loadTexts: dot3ExtPkgQueueSetsTable.setDescription("A table of Extended package objects used for the\nmanagement of the queue_sets.  Entries are control and\nstatus indication objects of an EPON interface, which\nare gathered in an extended package as an addition to\nthe objects based on the [802.3ah] attributes.  The\nobjects in this table are specific for the queue_sets,\nwhich are reported in the MPCP REPORT message as defined\nin [802.3ah], clause 64.\nThe [802.3ah] MPCP defines a report message of the\noccupancy of the transmit queues for the feedback BW\nrequest from the ONUs.  These queues serve the uplink\ntransmission of the ONU and data is gathered there until\nthe ONU is granted for transmission.\n\n\n\nThe management table of the queues_sets is added here\nmainly to control the reporting and to gather some\nstatistics of their operation.  This table is not\nduplicating existing management objects of bridging\nqueues, specified in [802.1d], since the existence of a\ndedicated transmit queuing mechanism is implied in the\n[802.3ah], and the ONU may be a device that is not a\nbridge with embedded bridging queues.\nThe format of the REPORT message, as specified\nin [802.3], is presented below:\n+-----------------------------------+\n|          Destination Address      |\n+-----------------------------------+\n|          Source Address           |\n+-----------------------------------+\n|          Length/Type              |\n+-----------------------------------+\n|          OpCode                   |\n+-----------------------------------+\n|          TimeStamp                |\n+-----------------------------------+\n|          Number of queue Sets     |\n+-----------------------------------+   /||          Report bitmap            |    |\n+-----------------------------------+    |\n|          Queue 0 report           |    |\n+-----------------------------------+    | repeated for\n|          Queue 1 report           |    | every\n+-----------------------------------+    | queue_set\n|          Queue 2 report           |    |\n+-----------------------------------+    |\n|          Queue 3 report           |    |\n+-----------------------------------+    |\n|          Queue 4 report           |    |\n+-----------------------------------+    |\n|          Queue 5 report           |    |\n+-----------------------------------+    |\n|          Queue 6 report           |    |\n+-----------------------------------+    |\n|          Queue 7 report           |    |\n+-----------------------------------+   \|/\n|          Pad/reserved             |\n+-----------------------------------+\n|          FCS                      |\n+-----------------------------------+\n\nAs can be seen from the message format, the ONU\ninterface reports of the status of up to 8 queues\n\n\n\nand it can report in a single MPCP REPORT message\nof a few sets of queues.\nThe number of queue_sets defines the number of the\nreported sets, and it can reach a value of up to 8.\nIt means that an ONU can hold a variable number of\nsets between 0 and 7.\nThe dot3ExtPkgQueueSetsTable table has a variable\nqueue_set size that is limited by the\ndot3ExtPkgObjectReportMaximumNumThreshold object as an\nONU can have fewer queue_sets to report.\nThe 'Queue report' field reports the occupancy of each\nuplink transmission queue.  The queue_sets can be used to\nreport the occupancy of the queues in a few levels as to\nallow granting, in an accurate manner, of only part of\nthe data available in the queues.  A Threshold is\ndefined for each queue_set to define the level of the\nqueue that is counted for the report of the occupancy.\nThe threshold is reflected in the queue_set table by the\ndot3ExtPkgObjectReportThreshold object.\nFor each queue set, the report bitmap defines which\nqueues are present in the report, meaning that\nalthough the MPCP REPORT message can report of up to 8\nqueues in a REPORT message, the actual number is\nflexible.\nThe dot3ExtPkgQueueSetsTable table has a variable queue\nsize that is limited by the\ndot3ExtPkgObjectReportMaximumNumQueues object as an ONU\ncan have fewer queues to report.\nEach object has a row for every virtual link, for each\nqueue in the report and for each queue_set in the queue.\nThe LLID field, as defined in the [802.3ah], is a 2-byte\nregister (15-bit field and a broadcast bit) limiting the\nnumber of virtual links to 32768.  Typically the number\nof expected virtual links in a PON is like the number of\nONUs, which is 32-64, plus an additional entry for\nbroadcast LLID (with a value of 0xffff).\nThe number of queues is between 0 and 7 and limited by\ndot3ExtPkgObjectReportMaximumNumQueues.\nThe number of queues_sets is between 0 and 7 and limited\nby dot3ExtPkgObjectReportMaximumNumThreshold.")
dot3ExtPkgQueueSetsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 3, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOT3-EPON-MIB", "dot3QueueSetQueueIndex"), (0, "DOT3-EPON-MIB", "dot3QueueSetIndex"))
if mibBuilder.loadTexts: dot3ExtPkgQueueSetsEntry.setDescription("An entry in the Extended package queue_set table.  At\n\n\n\nthe OLT, the rows exist for each ifIndex,\ndot3QueueSetQueueIndex and dot3QueueSetIndex.  At the\nONU, rows exist for the single ifIndex, for each\ndot3QueueSetQueueIndex and dot3QueueSetIndex.\nRows in the table are created when the ifIndex of the\nlink is created.  A set of rows per queue and per\nqueue_set are added for each ifIndex, denoted by\ndot3QueueSetIndex and dot3QueueSetQueueIndex.\nA set of rows per queue and per queue_set in the table,\nfor an ONU interface are created at system\ninitialization.\nA set of rows per queue and per queue_Set in the table,\ncorresponding to the OLT ifIndex and a set of rows per\nqueue and per queue_set, corresponding to the broadcast\nvirtual link, are created at system initialization.\nA set of rows per queue and per queue_set in the table,\ncorresponding to the ifIndex of a virtual link are\ncreated when the virtual link is established (ONU\nregisters) and deleted when the virtual link is deleted\n(ONU deregisters).")
dot3QueueSetQueueIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 3, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 7))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dot3QueueSetQueueIndex.setDescription("An object that identifies the queue index for the\ndot3ExtPkgQueueSetsTable table.  The queues are reported\nin the MPCP REPORT message as defined in [802.3ah],\nclause 64.\nThe number of queues is between 0 and 7, and limited by\ndot3ExtPkgObjectReportMaximumNumQueues.\nValue corresponds to the dot3QueueIndex of the queue\ntable.")
dot3QueueSetIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 3, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 7))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dot3QueueSetIndex.setDescription("An object that identifies the queue_set index for the\ndot3ExtPkgQueueSetsTable table.  The queues are reported\nin the MPCP REPORT message as defined in [802.3ah],\nclause 64.\nThe number of queues_sets is between 0 and 7, and\nlimited by dot3ExtPkgObjectReportMaximumNumThreshold.")
dot3ExtPkgObjectReportThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 3, 1, 3), Unsigned32().clone(0)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgObjectReportThreshold.setDescription("An object that defines the value of a threshold report\nfor each queue_set in the REPORT message as defined in\n[802.3ah], clause 64.  The number of sets for each queue\nis dot3ExtPkgObjectReportNumThreshold.\nIn the REPORT message, each queue_set reporting will\nprovide information on the occupancy of the queues for\nframes below the matching Threshold.\nThe value returned shall be in Time quanta (TQ), which\nis 16nsec or 2 octets increments.\nRead operation provides the threshold value.  Write\noperation sets the value of the threshold.\nThe write operation is not restricted in this document\nand can be done at any time.  Changing\ndot3ExtPkgObjectReportThreshold can lead to a change in\nthe reporting of the ONU interface and therefore to a\nchange in the bandwidth allocation of the respective\ninterface.  This change may lead a degradation or an\ninterruption of service for the users connected to the\nrespective EPON interface.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface,\nfor each queue and for each queue_set.  At the ONU, it has\na distinct value for each queue and for each queue_set.")
dot3ExtPkgOptIfTable = MibTable((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5))
if mibBuilder.loadTexts: dot3ExtPkgOptIfTable.setDescription("This table defines the control and status indication\nobjects for the optical interface of the EPON interface.\nEach object has a row for every virtual link denoted by\nthe corresponding ifIndex.\nThe LLID field, as defined in the [802.3ah], is a 2-byte\nregister (15-bit field and a broadcast bit) limiting the\nnumber of virtual links to 32768.  Typically the number\nof expected virtual links in a PON is like the number of\nONUs, which is 32-64, plus an additional entry for\nbroadcast LLID (with a value of 0xffff).\nAlthough the optical interface is a physical interface,\nthere is a row in the table for each virtual interface.\nThe reason for having a separate row for each virtual\nlink is that the OLT has a separate link for each one of\nthe ONUs.  For instance, ONUs could be in different\ndistances with different link budgets and different\nreceive powers, therefore having different power alarms.\nIt is quite similar to a case of different physical\ninterfaces.")
dot3ExtPkgOptIfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dot3ExtPkgOptIfEntry.setDescription("An entry in the optical interface table of the EPON\ninterface.\nRows exist for an OLT interface and an ONU interface.\nA row in the table is denoted by the ifIndex of the link\nand it is created when the ifIndex is created.\nThe rows in the table for an ONU interface are created\nat system initialization.\nThe row in the table corresponding to the OLT ifIndex\nand the row corresponding to the broadcast virtual link\nare created at system initialization.\nA row in the table corresponding to the ifIndex of a\nvirtual links is created when a virtual link is\nestablished (ONU registers) and deleted when the virtual\nlink is deleted (ONU deregisters).")
dot3ExtPkgOptIfSuspectedFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 1), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgOptIfSuspectedFlag.setDescription("This object is a reliability indication.\nIf true, the data in this entry may be unreliable.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.")
dot3ExtPkgOptIfInputPower = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 2), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgOptIfInputPower.setDescription("The optical power monitored at the input.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.")
dot3ExtPkgOptIfLowInputPower = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 3), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgOptIfLowInputPower.setDescription("The lowest optical power monitored at the input during the\ncurrent 15-minute interval.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.")
dot3ExtPkgOptIfHighInputPower = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgOptIfHighInputPower.setDescription("The highest optical power monitored at the input during the\ncurrent 15-minute interval.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.")
dot3ExtPkgOptIfLowerInputPowerThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 5), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgOptIfLowerInputPowerThreshold.setDescription("The lower limit threshold on input power.  If\ndot3ExtPkgOptIfInputPower drops to this value or below,\na Threshold Crossing Alert (TCA) should be sent.\nReading will present the threshold value.  Writing will\nset the value of the threshold.\nThe write operation is not restricted in this document\nand can be done at any time.  Changing\ndot3ExtPkgOptIfLowerInputPowerThreshold can lead to a Threshold\nCrossing Alert (TCA) being sent for the respective interface.\nThis alert may be leading to an interruption of service for the\nusers connected to the respective EPON interface, depending on\nthe system action on such an alert.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.")
dot3ExtPkgOptIfUpperInputPowerThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 6), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgOptIfUpperInputPowerThreshold.setDescription("The upper limit threshold on input power.  If\ndot3ExtPkgOptIfInputPower reaches or exceeds this value,\na Threshold Crossing Alert (TCA) should be sent.\nReading will present the threshold value.  Writing will\nset the value of the threshold.\nThe write operation is not restricted in this document\nand can be done at any time.  Changing\ndot3ExtPkgOptIfUpperInputPowerThreshold can lead to a Threshold\n\n\n\nCrossing Alert (TCA) being sent for the respective interface.\nThis alert may be leading to an interruption of service for the\nusers connected to the respective EPON interface, depending on\nthe system action on such an alert.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.")
dot3ExtPkgOptIfOutputPower = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgOptIfOutputPower.setDescription("The optical power monitored at the output.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.")
dot3ExtPkgOptIfLowOutputPower = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 8), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgOptIfLowOutputPower.setDescription("The lowest optical power monitored at the output during the\ncurrent 15-minute interval.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.")
dot3ExtPkgOptIfHighOutputPower = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 9), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgOptIfHighOutputPower.setDescription("The highest optical power monitored at the output during the\ncurrent 15-minute interval.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.")
dot3ExtPkgOptIfLowerOutputPowerThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 10), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgOptIfLowerOutputPowerThreshold.setDescription("The lower limit threshold on output power.  If\ndot3ExtPkgOptIfOutputPower drops to this value or below,\na Threshold Crossing Alert (TCA) should be sent.\nReading will present the threshold value.  Writing will\nset the value of the threshold.\nThe write operation is not restricted in this document\nand can be done at any time.  Changing\ndot3ExtPkgOptIfLowerOutputPowerThreshold can lead to a Threshold\nCrossing Alert (TCA) being sent for the respective interface.\nThis alert may be leading to an interruption of service for the\nusers connected to the respective EPON interface, depending on\nthe system action on such an alert.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.")
dot3ExtPkgOptIfUpperOutputPowerThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 11), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgOptIfUpperOutputPowerThreshold.setDescription("The upper limit threshold on output power.  If\ndot3ExtPkgOptIfOutputPower reaches or exceeds this value,\na Threshold Crossing Alert (TCA) should be sent.\nReading will present the threshold value.  Writing will\nset the value of the threshold.\nThe write operation is not restricted in this document\nand can be done at any time.  Changing\ndot3ExtPkgOptIfUpperOutputPowerThreshold can lead to a Threshold\nCrossing Alert (TCA) being sent for the respective interface.\nThis alert may be leading to an interruption of service of the\nusers connected to the respective EPON interface, depending on\nthe system action on such an alert.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.")
dot3ExtPkgOptIfSignalDetect = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 12), TruthValue().clone('false')).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgOptIfSignalDetect.setDescription("When getting true(1), there is a valid optical signal at\nthe receive that is above the optical power level for\nsignal detection.  When getting false(2) the optical\nsignal at the receive is below the optical power level\n\n\n\nfor signal detection.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.")
dot3ExtPkgOptIfTransmitAlarm = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 13), TruthValue().clone('false')).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3ExtPkgOptIfTransmitAlarm.setDescription("When getting true(1) there is a non-valid optical signal\nat the transmit of the interface, either a higher level\nor lower level than expected.  When getting false(2) the\noptical signal at the transmit is valid and in the\nrequired range.\nThis object is applicable for an OLT and an ONU.  At the\nOLT, it has a distinct value for each virtual interface.")
dot3ExtPkgOptIfTransmitEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 155, 1, 4, 1, 5, 1, 14), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3ExtPkgOptIfTransmitEnable.setDescription("Setting this object to true(1) will cause the optical\ninterface to start transmission (according to the\ncontrol protocol specified for the logical interface).\nSetting this object to false(2) will cause the\ninterface to stop the optical transmission.\nWhen getting true(1), the optical interface is in\ntransmitting mode (obeying to the logical control\nprotocol).\nWhen getting false(2), the optical interface is not in\ntransmitting mode.\nThe write operation is not restricted in this document\nand can be done at any time.  Changing\ndot3ExtPkgOptIfTransmitEnable state can lead to a halt\nin the optical transmission of the respective interface\nleading to an interruption of service of the users\nconnected to the respective EPON interface.\nThe object is relevant when the admin state of the\ninterface is active as set by the dot3MpcpAdminState.\nThis object is applicable for an OLT and an ONU.  At the\nOLT it, has a distinct value for each virtual interface.")
dot3EponConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 155, 2))
dot3EponGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 155, 2, 1))
dot3EponCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 155, 2, 2))

# Augmentions

# Groups

dot3MpcpGroupBase = ObjectGroup((1, 3, 6, 1, 2, 1, 155, 2, 1, 1)).setObjects(*(("DOT3-EPON-MIB", "dot3MpcpMaximumPendingGrants"), ("DOT3-EPON-MIB", "dot3MpcpReceiveElapsed"), ("DOT3-EPON-MIB", "dot3MpcpOperStatus"), ("DOT3-EPON-MIB", "dot3MpcpRegistrationState"), ("DOT3-EPON-MIB", "dot3MpcpSyncTime"), ("DOT3-EPON-MIB", "dot3MpcpRemoteMACAddress"), ("DOT3-EPON-MIB", "dot3MpcpTransmitElapsed"), ("DOT3-EPON-MIB", "dot3MpcpRoundTripTime"), ("DOT3-EPON-MIB", "dot3MpcpMode"), ("DOT3-EPON-MIB", "dot3MpcpAdminState"), ("DOT3-EPON-MIB", "dot3MpcpLinkID"), ) )
if mibBuilder.loadTexts: dot3MpcpGroupBase.setDescription("A collection of objects of dot3 Mpcp Control entity state\ndefinition.  Objects are per LLID.")
dot3MpcpGroupStat = ObjectGroup((1, 3, 6, 1, 2, 1, 155, 2, 1, 2)).setObjects(*(("DOT3-EPON-MIB", "dot3MpcpMACCtrlFramesReceived"), ("DOT3-EPON-MIB", "dot3MpcpRxRegAck"), ("DOT3-EPON-MIB", "dot3MpcpRxRegRequest"), ("DOT3-EPON-MIB", "dot3MpcpTxReport"), ("DOT3-EPON-MIB", "dot3MpcpTxGate"), ("DOT3-EPON-MIB", "dot3MpcpRxReport"), ("DOT3-EPON-MIB", "dot3MpcpTxRegAck"), ("DOT3-EPON-MIB", "dot3MpcpDiscoveryWindowsSent"), ("DOT3-EPON-MIB", "dot3MpcpMACCtrlFramesTransmitted"), ("DOT3-EPON-MIB", "dot3MpcpTxRegRequest"), ("DOT3-EPON-MIB", "dot3MpcpDiscoveryTimeout"), ("DOT3-EPON-MIB", "dot3MpcpTxRegister"), ("DOT3-EPON-MIB", "dot3MpcpRxRegister"), ("DOT3-EPON-MIB", "dot3MpcpRxGate"), ) )
if mibBuilder.loadTexts: dot3MpcpGroupStat.setDescription("A collection of objects of dot3 Mpcp Statistics.\nObjects are per LLID.")
dot3OmpeGroupID = ObjectGroup((1, 3, 6, 1, 2, 1, 155, 2, 1, 3)).setObjects(*(("DOT3-EPON-MIB", "dot3OmpEmulationType"), ) )
if mibBuilder.loadTexts: dot3OmpeGroupID.setDescription("A collection of objects of dot3 OMP emulation entity\nstate definition.  Objects are per LLID.")
dot3OmpeGroupStat = ObjectGroup((1, 3, 6, 1, 2, 1, 155, 2, 1, 4)).setObjects(*(("DOT3-EPON-MIB", "dot3OmpEmulationGoodLLID"), ("DOT3-EPON-MIB", "dot3OmpEmulationBroadcastBitNotOnuLlid"), ("DOT3-EPON-MIB", "dot3OmpEmulationOltPonCastLLID"), ("DOT3-EPON-MIB", "dot3OmpEmulationBadLLID"), ("DOT3-EPON-MIB", "dot3OmpEmulationNotBroadcastBitNotOnuLlid"), ("DOT3-EPON-MIB", "dot3OmpEmulationSLDErrors"), ("DOT3-EPON-MIB", "dot3OmpEmulationOnuLLIDNotBroadcast"), ("DOT3-EPON-MIB", "dot3OmpEmulationBroadcastBitPlusOnuLlid"), ("DOT3-EPON-MIB", "dot3OmpEmulationOnuPonCastLLID"), ("DOT3-EPON-MIB", "dot3OmpEmulationCRC8Errors"), ) )
if mibBuilder.loadTexts: dot3OmpeGroupStat.setDescription("A collection of objects of dot3 OMP emulation\nStatistics.  Objects are per LLID.")
dot3EponFecGroupAll = ObjectGroup((1, 3, 6, 1, 2, 1, 155, 2, 1, 5)).setObjects(*(("DOT3-EPON-MIB", "dot3EponFecUncorrectableBlocks"), ("DOT3-EPON-MIB", "dot3EponFecCorrectedBlocks"), ("DOT3-EPON-MIB", "dot3EponFecBufferHeadCodingViolation"), ("DOT3-EPON-MIB", "dot3EponFecAbility"), ("DOT3-EPON-MIB", "dot3EponFecMode"), ("DOT3-EPON-MIB", "dot3EponFecPCSCodingViolation"), ) )
if mibBuilder.loadTexts: dot3EponFecGroupAll.setDescription("A collection of objects of dot3 FEC group control and\nstatistics.  Objects are per LLID.")
dot3ExtPkgGroupControl = ObjectGroup((1, 3, 6, 1, 2, 1, 155, 2, 1, 6)).setObjects(*(("DOT3-EPON-MIB", "dot3ExtPkgObjectRegisterAction"), ("DOT3-EPON-MIB", "dot3ExtPkgObjectReset"), ("DOT3-EPON-MIB", "dot3ExtPkgObjectPowerDown"), ("DOT3-EPON-MIB", "dot3ExtPkgObjectReportMaximumNumQueues"), ("DOT3-EPON-MIB", "dot3ExtPkgObjectFecEnabled"), ("DOT3-EPON-MIB", "dot3ExtPkgObjectNumberOfLLIDs"), ) )
if mibBuilder.loadTexts: dot3ExtPkgGroupControl.setDescription("A collection of objects of dot3ExtPkg control\ndefinition.  Objects are per LLID.")
dot3ExtPkgGroupQueue = ObjectGroup((1, 3, 6, 1, 2, 1, 155, 2, 1, 7)).setObjects(*(("DOT3-EPON-MIB", "dot3ExtPkgObjectReportMaximumNumThreshold"), ("DOT3-EPON-MIB", "dot3ExtPkgObjectReportNumThreshold"), ("DOT3-EPON-MIB", "dot3ExtPkgStatDroppedFramesQueue"), ("DOT3-EPON-MIB", "dot3ExtPkgStatRxFramesQueue"), ("DOT3-EPON-MIB", "dot3ExtPkgStatTxFramesQueue"), ) )
if mibBuilder.loadTexts: dot3ExtPkgGroupQueue.setDescription("A collection of objects of dot3ExtPkg Queue\ncontrol.  Objects are per LLID, per queue.")
dot3ExtPkgGroupQueueSets = ObjectGroup((1, 3, 6, 1, 2, 1, 155, 2, 1, 8)).setObjects(*(("DOT3-EPON-MIB", "dot3ExtPkgObjectReportThreshold"), ) )
if mibBuilder.loadTexts: dot3ExtPkgGroupQueueSets.setDescription("A collection of objects of dot3ExtPkg queue_set\ncontrol.  Objects are per LLID, per queue, per\nqueue_set.")
dot3ExtPkgGroupOptIf = ObjectGroup((1, 3, 6, 1, 2, 1, 155, 2, 1, 9)).setObjects(*(("DOT3-EPON-MIB", "dot3ExtPkgOptIfLowerInputPowerThreshold"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfLowInputPower"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfLowerOutputPowerThreshold"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfOutputPower"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfUpperOutputPowerThreshold"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfHighInputPower"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfSuspectedFlag"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfSignalDetect"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfHighOutputPower"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfTransmitEnable"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfUpperInputPowerThreshold"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfTransmitAlarm"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfLowOutputPower"), ("DOT3-EPON-MIB", "dot3ExtPkgOptIfInputPower"), ) )
if mibBuilder.loadTexts: dot3ExtPkgGroupOptIf.setDescription("A collection of objects of control and status indication\nof the optical interface.\nObjects are per LLID.")

# Compliances

dot3MPCPCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 155, 2, 2, 1)).setObjects(*(("DOT3-EPON-MIB", "dot3MpcpGroupBase"), ("DOT3-EPON-MIB", "dot3MpcpGroupStat"), ) )
if mibBuilder.loadTexts: dot3MPCPCompliance.setDescription("The compliance statement for Multi-Point\nControl Protocol interfaces.")
dot3OmpeCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 155, 2, 2, 2)).setObjects(*(("DOT3-EPON-MIB", "dot3OmpeGroupStat"), ("DOT3-EPON-MIB", "dot3OmpeGroupID"), ) )
if mibBuilder.loadTexts: dot3OmpeCompliance.setDescription("The compliance statement for OMPEmulation\ninterfaces.")
dot3EponFecCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 155, 2, 2, 3)).setObjects(*(("DOT3-EPON-MIB", "dot3EponFecGroupAll"), ) )
if mibBuilder.loadTexts: dot3EponFecCompliance.setDescription("The compliance statement for FEC EPON interfaces.\n\n\n\nThis group is mandatory for all FEC supporting\ninterfaces for control and statistics collection.")
dot3ExtPkgCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 155, 2, 2, 4)).setObjects(*(("DOT3-EPON-MIB", "dot3ExtPkgGroupOptIf"), ("DOT3-EPON-MIB", "dot3ExtPkgGroupQueue"), ("DOT3-EPON-MIB", "dot3ExtPkgGroupQueueSets"), ("DOT3-EPON-MIB", "dot3ExtPkgGroupControl"), ) )
if mibBuilder.loadTexts: dot3ExtPkgCompliance.setDescription("The compliance statement for EPON Interfaces\nusing the extended package.")

# Exports

# Module identity
mibBuilder.exportSymbols("DOT3-EPON-MIB", PYSNMP_MODULE_ID=dot3EponMIB)

# Objects
mibBuilder.exportSymbols("DOT3-EPON-MIB", dot3EponMIB=dot3EponMIB, dot3EponObjects=dot3EponObjects, dot3EponMpcpObjects=dot3EponMpcpObjects, dot3MpcpControlTable=dot3MpcpControlTable, dot3MpcpControlEntry=dot3MpcpControlEntry, dot3MpcpOperStatus=dot3MpcpOperStatus, dot3MpcpAdminState=dot3MpcpAdminState, dot3MpcpMode=dot3MpcpMode, dot3MpcpSyncTime=dot3MpcpSyncTime, dot3MpcpLinkID=dot3MpcpLinkID, dot3MpcpRemoteMACAddress=dot3MpcpRemoteMACAddress, dot3MpcpRegistrationState=dot3MpcpRegistrationState, dot3MpcpTransmitElapsed=dot3MpcpTransmitElapsed, dot3MpcpReceiveElapsed=dot3MpcpReceiveElapsed, dot3MpcpRoundTripTime=dot3MpcpRoundTripTime, dot3MpcpMaximumPendingGrants=dot3MpcpMaximumPendingGrants, dot3MpcpStatTable=dot3MpcpStatTable, dot3MpcpStatEntry=dot3MpcpStatEntry, dot3MpcpMACCtrlFramesTransmitted=dot3MpcpMACCtrlFramesTransmitted, dot3MpcpMACCtrlFramesReceived=dot3MpcpMACCtrlFramesReceived, dot3MpcpDiscoveryWindowsSent=dot3MpcpDiscoveryWindowsSent, dot3MpcpDiscoveryTimeout=dot3MpcpDiscoveryTimeout, dot3MpcpTxRegRequest=dot3MpcpTxRegRequest, dot3MpcpRxRegRequest=dot3MpcpRxRegRequest, dot3MpcpTxRegAck=dot3MpcpTxRegAck, dot3MpcpRxRegAck=dot3MpcpRxRegAck, dot3MpcpTxReport=dot3MpcpTxReport, dot3MpcpRxReport=dot3MpcpRxReport, dot3MpcpTxGate=dot3MpcpTxGate, dot3MpcpRxGate=dot3MpcpRxGate, dot3MpcpTxRegister=dot3MpcpTxRegister, dot3MpcpRxRegister=dot3MpcpRxRegister, dot3OmpEmulationObjects=dot3OmpEmulationObjects, dot3OmpEmulationTable=dot3OmpEmulationTable, dot3OmpEmulationEntry=dot3OmpEmulationEntry, dot3OmpEmulationType=dot3OmpEmulationType, dot3OmpEmulationStatTable=dot3OmpEmulationStatTable, dot3OmpEmulationStatEntry=dot3OmpEmulationStatEntry, dot3OmpEmulationSLDErrors=dot3OmpEmulationSLDErrors, dot3OmpEmulationCRC8Errors=dot3OmpEmulationCRC8Errors, dot3OmpEmulationBadLLID=dot3OmpEmulationBadLLID, dot3OmpEmulationGoodLLID=dot3OmpEmulationGoodLLID, dot3OmpEmulationOnuPonCastLLID=dot3OmpEmulationOnuPonCastLLID, dot3OmpEmulationOltPonCastLLID=dot3OmpEmulationOltPonCastLLID, dot3OmpEmulationBroadcastBitNotOnuLlid=dot3OmpEmulationBroadcastBitNotOnuLlid, dot3OmpEmulationOnuLLIDNotBroadcast=dot3OmpEmulationOnuLLIDNotBroadcast, dot3OmpEmulationBroadcastBitPlusOnuLlid=dot3OmpEmulationBroadcastBitPlusOnuLlid, dot3OmpEmulationNotBroadcastBitNotOnuLlid=dot3OmpEmulationNotBroadcastBitNotOnuLlid, dot3EponFecObjects=dot3EponFecObjects, dot3EponFecTable=dot3EponFecTable, dot3EponFecEntry=dot3EponFecEntry, dot3EponFecPCSCodingViolation=dot3EponFecPCSCodingViolation, dot3EponFecAbility=dot3EponFecAbility, dot3EponFecMode=dot3EponFecMode, dot3EponFecCorrectedBlocks=dot3EponFecCorrectedBlocks, dot3EponFecUncorrectableBlocks=dot3EponFecUncorrectableBlocks, dot3EponFecBufferHeadCodingViolation=dot3EponFecBufferHeadCodingViolation, dot3ExtPkgObjects=dot3ExtPkgObjects, dot3ExtPkgControlObjects=dot3ExtPkgControlObjects, dot3ExtPkgControlTable=dot3ExtPkgControlTable, dot3ExtPkgControlEntry=dot3ExtPkgControlEntry, dot3ExtPkgObjectReset=dot3ExtPkgObjectReset, dot3ExtPkgObjectPowerDown=dot3ExtPkgObjectPowerDown, dot3ExtPkgObjectNumberOfLLIDs=dot3ExtPkgObjectNumberOfLLIDs, dot3ExtPkgObjectFecEnabled=dot3ExtPkgObjectFecEnabled, dot3ExtPkgObjectReportMaximumNumQueues=dot3ExtPkgObjectReportMaximumNumQueues, dot3ExtPkgObjectRegisterAction=dot3ExtPkgObjectRegisterAction, dot3ExtPkgQueueTable=dot3ExtPkgQueueTable, dot3ExtPkgQueueEntry=dot3ExtPkgQueueEntry, dot3QueueIndex=dot3QueueIndex, dot3ExtPkgObjectReportNumThreshold=dot3ExtPkgObjectReportNumThreshold, dot3ExtPkgObjectReportMaximumNumThreshold=dot3ExtPkgObjectReportMaximumNumThreshold, dot3ExtPkgStatTxFramesQueue=dot3ExtPkgStatTxFramesQueue, dot3ExtPkgStatRxFramesQueue=dot3ExtPkgStatRxFramesQueue, dot3ExtPkgStatDroppedFramesQueue=dot3ExtPkgStatDroppedFramesQueue, dot3ExtPkgQueueSetsTable=dot3ExtPkgQueueSetsTable, dot3ExtPkgQueueSetsEntry=dot3ExtPkgQueueSetsEntry, dot3QueueSetQueueIndex=dot3QueueSetQueueIndex, dot3QueueSetIndex=dot3QueueSetIndex, dot3ExtPkgObjectReportThreshold=dot3ExtPkgObjectReportThreshold, dot3ExtPkgOptIfTable=dot3ExtPkgOptIfTable, dot3ExtPkgOptIfEntry=dot3ExtPkgOptIfEntry, dot3ExtPkgOptIfSuspectedFlag=dot3ExtPkgOptIfSuspectedFlag, dot3ExtPkgOptIfInputPower=dot3ExtPkgOptIfInputPower, dot3ExtPkgOptIfLowInputPower=dot3ExtPkgOptIfLowInputPower, dot3ExtPkgOptIfHighInputPower=dot3ExtPkgOptIfHighInputPower, dot3ExtPkgOptIfLowerInputPowerThreshold=dot3ExtPkgOptIfLowerInputPowerThreshold, dot3ExtPkgOptIfUpperInputPowerThreshold=dot3ExtPkgOptIfUpperInputPowerThreshold, dot3ExtPkgOptIfOutputPower=dot3ExtPkgOptIfOutputPower, dot3ExtPkgOptIfLowOutputPower=dot3ExtPkgOptIfLowOutputPower, dot3ExtPkgOptIfHighOutputPower=dot3ExtPkgOptIfHighOutputPower, dot3ExtPkgOptIfLowerOutputPowerThreshold=dot3ExtPkgOptIfLowerOutputPowerThreshold, dot3ExtPkgOptIfUpperOutputPowerThreshold=dot3ExtPkgOptIfUpperOutputPowerThreshold, dot3ExtPkgOptIfSignalDetect=dot3ExtPkgOptIfSignalDetect, dot3ExtPkgOptIfTransmitAlarm=dot3ExtPkgOptIfTransmitAlarm, dot3ExtPkgOptIfTransmitEnable=dot3ExtPkgOptIfTransmitEnable, dot3EponConformance=dot3EponConformance, dot3EponGroups=dot3EponGroups, dot3EponCompliances=dot3EponCompliances)

# Groups
mibBuilder.exportSymbols("DOT3-EPON-MIB", dot3MpcpGroupBase=dot3MpcpGroupBase, dot3MpcpGroupStat=dot3MpcpGroupStat, dot3OmpeGroupID=dot3OmpeGroupID, dot3OmpeGroupStat=dot3OmpeGroupStat, dot3EponFecGroupAll=dot3EponFecGroupAll, dot3ExtPkgGroupControl=dot3ExtPkgGroupControl, dot3ExtPkgGroupQueue=dot3ExtPkgGroupQueue, dot3ExtPkgGroupQueueSets=dot3ExtPkgGroupQueueSets, dot3ExtPkgGroupOptIf=dot3ExtPkgGroupOptIf)

# Compliances
mibBuilder.exportSymbols("DOT3-EPON-MIB", dot3MPCPCompliance=dot3MPCPCompliance, dot3OmpeCompliance=dot3OmpeCompliance, dot3EponFecCompliance=dot3EponFecCompliance, dot3ExtPkgCompliance=dot3ExtPkgCompliance)
