# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class BillingPeriodTestCase(IntegrationTestCase):

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.supersim.v1.sims("HSXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                   .billing_periods.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://supersim.twilio.com/v1/Sims/HSXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/BillingPeriods',
        ))

    def test_read_empty_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "billing_periods": [],
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://supersim.twilio.com/v1/Sims/HSaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/BillingPeriods?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://supersim.twilio.com/v1/Sims/HSaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/BillingPeriods?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "billing_periods"
                }
            }
            '''
        ))

        actual = self.client.supersim.v1.sims("HSXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                        .billing_periods.list()

        self.assertIsNotNone(actual)

    def test_read_full_active_period_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "billing_periods": [
                    {
                        "sid": "HBaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "sim_sid": "HSaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "period_type": "active",
                        "start_time": "2021-06-09T13:18:15Z",
                        "end_time": "2021-07-09T13:18:15Z",
                        "date_created": "2021-06-09T13:18:16Z",
                        "date_updated": "2021-06-09T13:18:16Z"
                    }
                ],
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://supersim.twilio.com/v1/Sims/HSaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/BillingPeriods?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://supersim.twilio.com/v1/Sims/HSaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/BillingPeriods?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "billing_periods"
                }
            }
            '''
        ))

        actual = self.client.supersim.v1.sims("HSXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                        .billing_periods.list()

        self.assertIsNotNone(actual)

    def test_read_full_ready_period_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "billing_periods": [
                    {
                        "sid": "HBaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "sim_sid": "HSaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "period_type": "ready",
                        "start_time": "2021-06-09T13:18:15Z",
                        "end_time": "2021-07-09T13:18:15Z",
                        "date_created": "2021-06-09T13:18:16Z",
                        "date_updated": "2021-06-09T13:18:16Z"
                    }
                ],
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://supersim.twilio.com/v1/Sims/HSaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/BillingPeriods?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://supersim.twilio.com/v1/Sims/HSaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/BillingPeriods?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "billing_periods"
                }
            }
            '''
        ))

        actual = self.client.supersim.v1.sims("HSXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                        .billing_periods.list()

        self.assertIsNotNone(actual)
