#=========================
#
#   PyNotify for GTK
#  drop-in replacement
#
#    Copyright 2010
#     Nathan Osman
#
#=========================

import pygtk
import gtk
import gobject

# We also have an init() method that does absolutely nothing
def init(unused_param):
	pass

# We have a queue here that we store the notifications
# in. When someone calls 'notification::show' then the
# notification is either appended to the queue or shown.
notifications_queue = []

class Notification:
	
	def __init__ (self, title, message, icon):
		
		# Start by creating a window that we will use
		# to display the information.
		self.window = gtk.Window(gtk.WINDOW_POPUP)
		
		# Set a few properties on the window,
		# including background color.
		self.window.set_border_width(10)
		self.window.set_opacity(0.8)
		self.window.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse('#000000'))
		
		# Create two labels to insert into the window
		self.title   = gtk.Label()
		self.message = gtk.Label()
		
		self.title.set_markup("<b>" + title + "</b>")
		self.message.set_label(message)
		
		self.title.set_alignment(0,0)
		self.message.set_alignment(0,0)
		self.title.show()
		self.message.show()
		
		# Set some properties on the labels
		self.title.modify_fg(gtk.STATE_NORMAL, gtk.gdk.color_parse('#ffffff'))
		self.message.modify_fg(gtk.STATE_NORMAL, gtk.gdk.color_parse('#ffffff'))
		
		# Create the image
		self.image = gtk.Image()
		pixbuf = gtk.gdk.pixbuf_new_from_file(icon)
		scaled_buf = pixbuf.scale_simple(48, 48, gtk.gdk.INTERP_BILINEAR)
		self.image.set_from_pixbuf(scaled_buf)
		
		self.image.set_size_request(48, 48)
		self.image.set_alignment(0,0)
		self.image.show()
		
		# Now create the layout for the control
		vbox = gtk.VBox()
		vbox.add(self.title)
		vbox.add(self.message)
		vbox.show()
		
		hbox = gtk.HBox()
		hbox.set_spacing(8)
		hbox.add(self.image)
		hbox.add(vbox)
		hbox.show()
		
		self.window.add(hbox)
		
		# Now we need to position the window
		screen = gtk.gdk.Screen()
		rect = screen.get_monitor_geometry(0)
		
		xpos = (rect.x + rect.width) - self.window.get_size()[0] - 32
		ypos = rect.y + 64
		
		self.window.move(xpos, ypos)
		
	def show(self):
		
		global notifications_queue
		
		# If there is nothing in the queue, then
		# do nothing. Otherwise, display this window.
		if not len(notifications_queue):
			
			# Done will be called when the notification is done
			self.display_window()
		
		# Append this item to the queue
		notifications_queue.append(self)
	
	def display_window(self):
		
		self.window.show()
		gobject.timeout_add(10000, self.done)
	
	def done(self):
		
		# Hide this window
		self.window.hide()
		
		global notifications_queue
		
		# Pop the item being displayed
		notifications_queue.remove(self)
		
		# See if there are any others in the queue
		if len(notifications_queue):
			
			# Pop and display that item
			next = notifications_queue[0]
			next.display_window()
