

Manuel de l'utilisateur d'aptitude


Version 0.6.8.2


Daniel Burrows

<dburrows@debian.org>

Copyright © 2004-2008 Daniel Burrows

This manual is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This manual is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this manual; if not, write to the Free Software Foundation, Inc., 59 Temple
Place, Suite 330, Boston, MA 02111-1307 USA

--------------------------------------------------------------------------------
Table des matières



  Introduction


        Qu'est-ce qu'aptitude, au fait ?

        Qu'est-ce qu'un gestionnaire de paquets ?

        Qu'est-ce que le système apt ?

        Comment se procure-t-on aptitude ?


              Paquets précompilés d'aptitude, ou « ce que 99% des utilisateurs
              devraient utiliser »

              Construire aptitude depuis les sources

              Assurer le suivi, et participer au développement d'aptitude



  1. Démarrage rapide


        Utiliser aptitude


              Les notions de base d'aptitude

              Naviguer dans la liste des paquets d'aptitude

              Rechercher des paquets par leur nom

              Gérer les paquets

              Mettre à jour la liste des paquets et installer des paquets


        Utiliser aptitude depuis la ligne de commande


  2. Guide de référence d'aptitude


        L'interface utilisateur d'aptitude depuis le terminal


              Utiliser les menus

              Commandes du menu

              Travailler avec plusieurs vues

              Devenir administrateur (« root »)


        Gérer les paquets


              Gérer la liste des paquets

              Accéder aux informations des paquets

              Modifier l'état d'un paquet

              Télécharger, installer et supprimer des paquets

              Qu'est-ce que la confiance en matière de gestion des paquets ?

              Gérer les paquets automatiquement installés


        Résoudre les dépendances de paquets


              Résolution des dépendances dans aptitude

              Résolution immédiate des dépendances

              Résolution interactive des dépendances

              Coûts dans la résolution interactive de dépendances

              Configuration de la résolution de dépendances interactive


        Motifs de recherche


              Recherche de chaînes de caractères

              Raccourcis pour les termes de recherche

              Recherches et versions

              Cibles de recherche explicites

              Référence pour les termes de recherche


        Personnalisation d'aptitude


              Personnaliser la liste des paquets

              Personnaliser les raccourcis clavier

              Personnaliser la couleur du texte et les styles

              Personnaliser la disposition de l'affichage

              Référence du fichier de configuration

              Thèmes


        Jouer au démineur


  3. Foire aux questions sur aptitude

  4. Crédits

  I. Référence de l'interface en ligne de commande


        aptitude — interface évoluée pour le gestionnaire de paquets

        aptitude-create-state-bundle — archiver l'état actuel d'aptitude

        aptitude-run-state-bundle — désarchiver une archive d'état d'aptitude et
        appeler aptitude sur celle-ci


Liste des illustrations



  2.1. Commandes disponibles dans le menu Actions

  2.2. Commandes disponibles dans le menu Annuler

  2.3. Commandes disponibles dans le menu Paquet

  2.4. Commandes disponibles dans le menu Solutions

  2.5. Commandes disponibles dans le menu Rechercher

  2.6. Commandes disponibles dans le menu Options

  2.7. Commandes disponibles dans le menu Vues

  2.8. Commandes disponibles dans le menu Aide

  2.9. Valeurs de l'indicateur de « l'état courant »

  2.10. Valeurs de l'indicateur « d'action »

  2.11. Syntaxe des composantes de coût composées

  2.12. Niveaux de coût de sécurité

  2.13. Syntaxe pour le terme ?for

  2.14. Styles personnalisables dans aptitude

Liste des tableaux



  2.1. Composantes de coût élémentaires

  2.2. Niveaux de coût de sécurité par défaut

  2.3. Guide rapide des termes de recherche

Liste des exemples



  2.1. Exemples de coût pour le solveur

  2.2. Utilisation du terme ?=.

  2.3. Utilisation du terme ?bind.

  2.4. Utilisation du terme ?exact-name

  2.5. Utilisation du terme ?for

  2.6. Utilisation du terme ?term-prefix

  2.7. Utilisation de pattern pour grouper les paquets par responsable

  2.8. Utilisation de pattern avec quelques paquets placés à la racine

  2.9. Utilisation de la politique de regroupement pattern avec des sous-
  politiques

  10. Utilisation de --show-summary



Introduction

Table des matières



  Qu'est-ce qu'aptitude, au fait ?

  Qu'est-ce qu'un gestionnaire de paquets ?

  Qu'est-ce que le système apt ?

  Comment se procure-t-on aptitude ?


        Paquets précompilés d'aptitude, ou « ce que 99% des utilisateurs
        devraient utiliser »

        Construire aptitude depuis les sources

        Assurer le suivi, et participer au développement d'aptitude



  « Maître, Emacs connaît-il la nature du Bouddha ? » demanda le novice.             

   « Pourquoi en serait-il autrement ? », répondit le maître. « Il fait sacrément bien tout
   le reste ». Quelques années plus tard, le novice reçut l'illumination.

                                                                                -- John Fouhy


Voici le manuel de l'utilisateur d'aptitude ! Cette introduction explique ce
qu'est aptitude et à quoi il sert. Pour accéder aux informations sur la manière
de l'utiliser, allez directement au Chapitre 1, Démarrage_rapide.


Qu'est-ce qu'aptitude, au fait ?

aptitude est un gestionnaire de paquets très complet pour les systèmes Debian
GNU/Linux ; il est basé sur la fameuse infrastructure de gestion de paquets apt.
aptitude fournit les fonctionnalités de dselect et d'apt-get, ainsi que beaucoup
d'autres, introuvables dans ces programmes.


Qu'est-ce qu'un gestionnaire de paquets ?

Un gestionnaire de paquets garde la trace des programmes installés sur votre
ordinateur. Il facilite l'installation de nouveaux programmes, la mise à jour ou
la suppression de ceux que vous aviez précédemment installés. Comme le nom le
suggère, un gestionnaire de paquets traite des paquets : un paquet est un
ensemble de fichiers liés et qui peuvent être installés ou supprimés en bloc.

Généralement, un paquet fournit un programme particulier. Par exemple, le client
de messagerie instantanée gaim est contenu dans le paquet Debian du même nom.
D'un autre côté, il est fréquent qu'un programme se compose de plusieurs paquets
apparentés. Par exemple, l'éditeur d'image gimp n'est pas constitué que du
paquet gimp, mais aussi du paquet gimp-data ; de plus plusieurs paquets
optionnels supplémentaires (contenant des données diverses, de la documentation,
etc.) sont aussi disponibles. Il arrive aussi que plusieurs petits programmes
apparentés soient fournis dans un unique paquet. Par exemple, le paquet
fileutils contient plusieurs commandes Unix usuelles telles que ls, cp, etc.

Certains paquets requièrent d'autres paquets pour fonctionner. À l'intérieur de
Debian, les paquets peuvent dépendre, recommander, suggérer, casser,ou être en
conflit (« conflict ») avec d'autres paquets.


* Si un paquet A dépend d'un paquet B, alors B est nécessaire au bon
  fonctionnement de A. Par exemple, le paquet gimp dépend du paquet gimp-data
  pour s'assurer que l'éditeur de graphismes GIMP aura accès à ses fichiers de
  données.

* Si un paquet A recommande un autre paquet B, alors B ajoute au paquet A une
  fonctionnalité importante qui sera appréciée dans la plupart des cas. Par
  exemple, le paquet mozilla-browser recommande le paquet mozilla-psm qui ajoute
  la gestion des transferts de données sécurisés au navigateur web Mozilla. Bien
  que mozilla-psm ne soit pas absolument nécessaire pour que Mozilla fonctionne,
  la plupart des utilisateurs veulent que Mozilla gère la transmission sécurisée
  de données confidentielles (tel que leur numéro de carte bancaire).

* Si un paquet A suggère un autre paquet B, alors le paquet B fournit une
  fonctionnalité qui peut améliorer A sans qu'elle ne soit généralement
  nécessaire. Par exemple, le paquet kmail suggère le paquet gnupg qui contient
  un logiciel de chiffrement que KMail peut utiliser.

* Si un paquet A est en conflit avec un autre paquet B, alors les deux paquets
  ne peuvent pas être installés au même moment. Par exemple, fb-music-hi est en
  conflit avec fb-music-low car ils fournissent tous deux des jeux de musiques
  de remplacement pour le jeu Frozen Bubble.


Le travail du gestionnaire de paquets est de présenter une interface qui aide
l'utilisateur à gérer l'ensemble des paquets installés sur son système. aptitude
fournit une telle interface en tirant parti du système de gestion de paquets
apt.


Qu'est-ce que le système apt ?

Pouvoir installer et supprimer des paquets, c'est formidable, mais le programme
basique chargé de faire cela (connu sous le nom de dpkg) ne fait que cela et
rien de plus. C'est très bien si vous téléchargez un ou deux paquets « à la
main », mais cela devient vite fatiguant quand vous essayez de gérer un grand
nombre de paquets. De plus, si un nouveau paquet intéressant nécessite des
programmes que vous n'avez pas encore installés, vous devez télécharger vous-
même les nouveaux paquets requis. Enfin, si vous décidez par la suite de
supprimer ce paquet, les paquets additionnels vont rester sur votre système et
occuper de la place sur vos disques à moins que vous ne les supprimiez vous-
même.

Toutes ces opérations sont fastidieuses et la plupart des systèmes de gestion de
paquets sont accompagnés de programmes qui se chargent de tout cela à votre
place. apt est la base commune sur laquelle sont construits ces programmes : en
plus d'aptitude, des programmes comme synaptic et apt-watch utilisent apt.

apt fonctionne grâce à une liste des paquets qui peuvent être téléchargés depuis
Debian sur votre ordinateur. Cette liste est utilisée pour trouver les paquets
qui ont besoin d'être mis à jour et pour installer de nouveaux paquets. apt peut
aussi résoudre automatiquement de nombreux problèmes de dépendances : par
exemple, quand vous choisissez d'installer un paquet, il recherche tous les
paquets supplémentaires requis et les installe en même temps.

Avec un gestionnaire de paquets basé sur apt, tel qu'aptitude, vous avez trois
opérations fondamentales : mettre à jour la liste des paquets disponibles en
téléchargeant de nouvelles listes depuis les serveurs Debian, sélectionner quels
paquets doivent être installés, mis à jour ou supprimés, et enfin mettre à
exécution votre sélection en procédant réellement aux installations,
suppressions, etc.

Les gestionnaires de paquets basés sur apt lisent la liste des « sources »
(dépôt de paquets Debian) dans le fichier /etc/apt/sources.list. La présentation
du format et du contenu de ce fichier n'entre pas dans le cadre de ce document,
mais ils sont décrits dans la page de manuel sources.list(5).


 Comment se procure-t-on aptitude ?

Si vous lisez ce document sans avoir installé aptitude sur votre système, cette
section explique comment vous sortir de cette mauvaise passe. Vous devriez aller
directement à la partie sur les paquets binaires.


Paquets précompilés d'aptitude, ou « ce que 99% des utilisateurs devraient
utiliser »

Un paquet précompilé, ou « binaire », est le moyen le plus courant et le plus
facile d'installer aptitude. Vous devriez uniquement tenter d'installer depuis
les sources si aucun paquet binaire n'est disponible pour une raison ou une
autre, ou si vous avez des besoins particuliers qui ne sont pas satisfaits par
les paquets binaires.

Si vous êtes en train d'utiliser un système Debian, exécutez la commande
suivante en tant que root : apt-get install aptitude. Sinon, le fournisseur de
votre système a dû créer un paquet pour aptitude. Dans le doute, vous pouvez le
contacter pour davantage de conseils.


Construire aptitude depuis les sources

Vous pouvez aussi construire aptitude depuis les sources. Néanmoins, il est
probable que ce ne soit pas utile si apt est déjà installé sur votre système. Si
ce n'est pas le cas, vous pouvez installer aptitude depuis les sources en
suivant les étapes :


  1. Installer les programmes suivants :


     o Un compilateur C++, comme g++.

     o Les fichiers de développement d'apt, habituellement disponibles dans le
       paquet nommé libapt-pkg-dev.

     o La bibliothèque libsigc++-2.0, disponible dans le paquet libsigc++-2.0-
       dev ou depuis http://libsigc.sourceforge.net.

     o La bibliothèque cwidget, disponible dans le paquet libcwidget-dev ou
       depuis http://cwidget.alioth.debian.org.

     o Le programme gettext, qui devrait être inclus dans votre distribution
       Linux.

     o Un outil make, tel que GNU make.


  2. Enfin, télécharger le code source le plus récent d'aptitude, disponible sur
     http://packages.debian.org/unstable/admin/aptitude (faites défiler l'écran
     jusqu'en bas et téléchargez le fichier « .orig.tar.gz »).


Une fois tous ces composants réunis, ouvrez un terminal et exécutez la
commande : tar zxf aptitude-0.6.8.2.tar.gz pour décompresser le code source. Une
fois les sources décompressées, tapez cd aptitude-0.6.8.2 &amp;&amp; ./configure
&amp;&amp; make pour compiler aptitude. Si cela réussit, vérifiez que vous êtes
sous l'utilisateur root (en utilisant, par exemple, su), tapez alors make
install pour installer aptitude sur votre ordinateur. Une fois aptitude
correctement installé, taper aptitude à l'invite de la ligne de commande devrait
lancer le programme.


Assurer le suivi, et participer au développement d'aptitude


Récupérer l'arborescence des sources d'aptitude

Si vous souhaitez tester le tout dernier code source en date d'aptitude, vous
pouvez télécharger le code source non encore publié d'aptitude en utilisant Git.
Installez Git (disponible à http://www.git-scm.com/) et exécutez la commande git
clone git://git.debian.org/git/aptitude/aptitude.git afin de récupérer le code
source le plus récent.


IMG.alt.suffix = Avertissement
       \
[Avertissement]] Le dépôt Git d'aptitude est un arbre de développement actif ; il est modifié au fur
                 et à mesure des corrections de bogues et des ajouts de fonctionnalités, sans qu'il
                 ne soit absolument garanti qu'il se compile, encore moins qu'il fonctionne
                 correctement ! Les rapports de bogues sont les bienvenus, mais soyez conscient que
                 vous utilisez du code de développement à vos risques et périls ![1]



Liste de diffusion

<aptitude-devel@lists.alioth.debian.org> est la principale liste de diffusion
concernant le developpement d'aptitude. Les archives de cette liste sont
accessibles ici http://lists.alioth.debian.org/pipermail/aptitude-devel/. Pour
s'y abonner, consultez la page Web http://lists.alioth.debian.org/mailman/
listinfo/aptitude-devel.


Proposer des correctifs (patches).

Dans l'absolu, les correctifs devraient être soumis à la liste de diffusion
d'aptitude <aptitude-devel@lists.alioth.debian.org>. Mais si vous préférez les
envoyer en privé, vous pouvez utiliser l'adresse de courriel
<aptitude@packages.debian.org> ou <dburrows@debian.org>. Une rapide description
des raisons qui ont motivé ce correctif ainsi qu'une explication de son mode de
fonctionnement sont grandement appréciées.


Suivre les modifications dans l'arborescence de sources d'aptitude

L'arborescence des sources d'aptitude est régulièrement mise à jour avec de
nouvelles fonctionnalités, des corrections de bogues, et de nouveaux bogues. Dès
que le code source est disponible sur votre machine (voir la section
précédente), vous pouvez vous déplacer dans le répertoire (cd) et taper git pull
afin de le mettre à jour avec les changements apparus sur le dépôt principal.

Pour être averti automatiquement lorsque des modifications ont été faites sur le
code de base d'aptitude inscrivez-vous au fil Atom disponible à l'adresse http:/
/anonscm.debian.org/gitweb/?p=aptitude/aptitude.git;a=atom ou au fil RSS
disponible à l'adresse http://anonscm.debian.org/gitweb/?p=aptitude/
aptitude.git;a=rss.


Construire aptitude à partir de l'arborescence de développement.

Pour construire aptitude depuis le dépôt Git, vous devez avoir installé les
programmes autoconf et automake. Tapez sh ./autogen.sh &amp;&amp; ./configure
pour générer les fichiers nécessaires à la compilation d'aptitude, puis exécutez
make et make install.



--------------------------------------------------------------------------------
[1]Bien sûr, vous utilisez tous les logiciels libres à vos propres risques, mais
le risque induit par l'utilisation d'un arbre de développement actif est encore
plus grand.



Chapitre 1. Démarrage rapide

Table des matières



  Utiliser aptitude


        Les notions de base d'aptitude

        Naviguer dans la liste des paquets d'aptitude

        Rechercher des paquets par leur nom

        Gérer les paquets

        Mettre à jour la liste des paquets et installer des paquets


  Utiliser aptitude depuis la ligne de commande


  Un voyage de mille lieues commence toujours par un premier pas.  

                                                          -- Lao Tsu


aptitude est un programme assez gros avec de nombreuses fonctionnalités et il
peut être un peu lourd pour les nouveaux utilisateurs qui veulent l'aborder. Ce
chapitre ne décrit pas de façon exhaustive les fonctionnalités d'aptitude
(consultez Chapitre 2, Guide_de_référence_d'aptitude pour cela), mais il fournit
un aperçu des fonctionnalités de base les plus utilisées de ce programme.


Utiliser aptitude

Cette section décrit comment utiliser l'interface graphique d'aptitude. Pour des
informations sur l'utilisation de l'interface d'aptitude en ligne de commande,
consultez la section intitulée « Utiliser aptitude depuis la ligne de
commande ».


Les notions de base d'aptitude

Pour lancer aptitude, ouvrez votre terminal préféré et tapez sur la ligne de
commande :

toto$ aptitude

Une fois que le cache est chargé (ce qui peut prendre un peu de temps sur les
machines les plus lentes), l'écran principal d'aptitude apparaît :

 Actions  Annuler  Paquet  Solutions  Rechercher  Options  Vues  Aide
C-T : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
aptitude 0.4.1
--- Paquets installés
--- Paquets non installés
--- Paquets obsolètes ou créés localement
--- Paquets virtuels
--- Tâches






Ces paquets sont actuellement installés sur votre ordinateur.







Comme vous pouvez le voir, l'écran principal d'aptitude est divisé en plusieurs
parties. La ligne bleue en haut du terminal est la barre de menu, et les lignes
bleues juste au-dessous contiennent des informations sur quelques commandes
importantes. La zone noire qui les suit contient la liste de tous les paquets
disponibles, classés par groupes de paquets. Le groupe actuellement sélectionné
(« Paquets installés ») est mis en évidence et sa description est indiquée dans
l'espace noir du bas.

Comme le suggèrent les lignes en haut de l'écran, vous pouvez accéder au menu
d'aptitude avec le raccourci clavier Contrôle+t ; vous pouvez aussi cliquer avec
la souris sur un onglet du menu si votre système gère ce mécanisme. Utiliser le
raccourci Contrôle+t va ouvrir le menu Actions :

 Actions  Annuler  Paquet  Solutions  Rechercher  Options  Vues  Aide
+------------------------------------------------+Téléch./Inst./Suppr. Pqts
|Installer/enlever des paquets                  g|
|Mettre à jour les listes de paquets            u|
|Oublier quels paquets sont nouveaux            f|
|Nettoyer le cache des paquets                   |
|Enlever les fichiers périmés                    |
|Marquer comme étant susceptible de mise à jour U|
|Jouer au démineur                               |
|Devenir administrateur                          |
+------------------------------------------------+
|Quitter                                        Q|
+------------------------------------------------+
Ces paquets sont actuellement installés sur votre ordinateur.









Effectuer toutes les actions d'installation ou de suppression demandées

Utilisez les flèches et Entrée pour sélectionner un onglet du menu (ou, si votre
système le permet, cliquez sur celui-ci avec la souris) ; pour fermer le menu
sans rien sélectionner, utilisez à nouveau le raccourci clavier Contrôle+t. Le
menu actuellement en surbrillance est expliqué en bas de l'écran. Si une option
du menu peut être utilisée à l'aide d'un raccourci clavier, celui-ci est affiché
dans le menu : par exemple, la commande « Mettre à jour les listes de paquets »
peut être lancée en appuyant sur u.

À tout moment, appuyer sur ? vous permet d'afficher une liste des principaux
raccourcis clavier disponibles.


Naviguer dans la liste des paquets d'aptitude

La liste des paquets est l'interface principale d'aptitude. Quand aptitude
démarre, la liste est organisée suivant un certain nombre de groupes comme on
peut le voir sur la capture suivante :

 Actions  Annuler  Paquet  Solutions  Rechercher  Options  Vues  Aide
C-T : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
aptitude 0.4.1
--- Paquets installés
--- Paquets non installés
--- Paquets obsolètes ou créés localement
--- Paquets virtuels
--- Tâches






Ces paquets sont actuellement installés sur votre ordinateur.








IMG.alt.suffix Note
  = \[Note]]
               Les groupes de paquets vides sont automatiquement cachés par aptitude, donc
               vous pourriez voir plus ou moins de groupes que ceux présents sur cette
               capture.


Sur la capture précédente, le premier groupe (« Paquets installés ») est en
surbrillance pour indiquer qu'il est actuellement sélectionné. Vous pouvez
modifier la sélection avec les flèches haut et bas. Notez que la description
affichée en bas change en conséquence. Pour « déployer » un groupe, appuyez sur
Entrée quand le groupe est sélectionné :

 Actions  Annuler  Paquet  Solutions  Rechercher  Options  Vues  Aide
C-T : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
aptitude 0.4.1
--\ Paquets installés
  --- admin - Utilitaires d'administration (installation de logiciels, gestion d
  --- base - Le système de base Debian
  --- comm - Programmes pour modem-fax et autres appareils de communication
  --- devel - Utilitaires et logiciels pour le développement de programmes
  --- doc - Documentation et programmes pour l'affichage de la documentation
  --- editors - Éditeurs de texte et traitement de texte
  --- games - Jeux, jouets et programmes de divertissement
  --- gnome - L'environnement GNOME
  --- graphics - Utilitaires pour créer, afficher et éditer les images

Ces paquets sont actuellement installés sur votre ordinateur.








Comme vous pouvez le voir, le groupe « Paquets installés » a été déployé pour
faire apparaître son contenu : il contient un certain nombre de sous-groupes
sommairement définis par le type de programmes qu'ils contiennent. Déployer la
section « admin » en la sélectionnant et en appuyant sur Entrée affiche :

 Actions  Annuler  Paquet  Solutions  Rechercher  Options  Vues  Aide
C-T : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
aptitude 0.4.1
--\ Paquets installés
  --\ admin - Utilitaires d'administration (installation de logiciels, gestion d
    --- main - L'archive principale de Debian
  --- base - Le système de base Debian
  --- comm - Programmes pour modem-fax et autres appareils de communication
  --- devel - Utilitaires et logiciels pour le développement de programmes
  --- doc - Documentation et programmes pour l'affichage de la documentation
  --- editors - Éditeurs de texte et traitement de texte
  --- games - Jeux, jouets et programmes de divertissement
  --- gnome - L'environnement GNOME

Les paquets dans la section « admin » vous permettent d'effectuer des tâches
d'administration telles que l'installation de logiciels, la gestion des
utilisateurs, la configuration et la surveillance de votre système, l'examen du
trafic du réseau ainsi que d'autres tâches du même genre.






Le groupe « admin » contient un unique sous-groupe, l'archive Debian « main ».
Déployer ce groupe révèle quelques paquets !


IMG.alt.suffix Astuce
 = \[Astuce]]
               Pour aller plus vite, vous pouvez utiliser la touche [ pour déployer d'un seul
               coup tous les sous-groupes d'un groupe donné. Sélectionner « Paquets installés »
               et appuyer sur [ fait immédiatement apparaître les paquets sur la capture
               suivante.


 Actions  Annuler  Paquet  Solutions  Rechercher  Options  Vues  Aide
C-T : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
aptitude 0.4.1
--\ Paquets installés
  --\ admin - Utilitaires d'administration (installation de logiciels, gestion d
    --\ main - L'archive principale de Debian
i     acpid                                                1.0.4-5    1.0.4-5
i     alien                                                8.61       8.61
i     anacron                                              2.3-11     2.3-11
i     apt                                                  0.6.43.2   0.6.43.2
i     apt-show-versions                                    0.09       0.09
i A   apt-utils                                            0.6.43.2   0.6.43.2
i     aptitude                                             0.4.1-1    0.4.1-1

La distribution Debian est constituée des paquets de la section « main ».
Chaque paquet de « main » est un logiciel libre.

Pour plus d'information sur ce que Debian considère comme étant un logiciel
libre, voir http://www.debian.org/social_contract#guidelines




En plus des touches de flèches, vous pouvez naviguer à travers la liste de
paquets, page à page, en utilisant les touches Page précédente et Page suivante.


IMG.alt.suffix Astuce
 = \[Astuce]]
               Quand toutes les informations ne peuvent être affichées dans la moitié basse de
               l'écran, les touches a et z peuvent être utilisées pour faire défiler cette zone.



Rechercher des paquets par leur nom

Pour trouver rapidement un paquet dont vous connaissez le nom, appuyez sur /
pour ouvrir une boîte de recherche :

Actions  Annuler  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
aptitude 0.2.15.2
i     frozen-bubble                                        1.0.0-5    1.0.0-5
i A   frozen-bubble-data                                   1.0.0-5    1.0.0-5
i     geekcode                                             1.7.3-1    1.7.3-1
i     gfpoken                                              0.25-3     0.25-3
i     ggz-gnome-client                                     0.0.7-2    0.0.7-2
i     ggz-gtk-client                                       0.0.7-1    0.0.7-1
i     ggz-gtk-game-data                                    0.0.7-2    0.0.7-2
i +-------------------------------------------------------------------------+
i |Recherche de :                                                           |
i |froz                                                                     |
Po|                        [ Continuer ]                         [ Abandon ]|
Fr+-------------------------------------------------------------------------+
attempt to shoot bubbles into groups of the same color to cause them to pop.
It features 100 single-player levels, a two-player mode, music and striking
graphics.

This game is widely rumored to be responsible for delaying the Woody release.

URL: http://www.frozen-bubble.org/

Comme vous pouvez le voir sur la capture précédente, une recherche de froz
trouve le paquet frozen-bubble. Avec le langage de recherche évolué d'aptitude,
décrit dans la section intitulée « Motifs de recherche », il est possible de
trouver des paquets en utilisant des critères plus ou moins complexes.


IMG.alt.suffix Astuce
 = \[Astuce]]
               Vous pouvez rechercher en arrière dans la liste des paquets en appuyant sur \
               et vous pouvez répéter la dernière recherche en appuyant sur n après avoir
               fermé la boîte de recherche.


Parfois il est plus pratique de cacher tous les paquets à l'exception de ceux
qui correspondent à quelques critères particuliers. Pour ce faire, appuyez sur
l :

Actions  Annuler  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
aptitude 0.2.15.2
--- Paquets installés
--- Paquets non installés
--- Paquets obsolètes ou créés localement
--- Paquets virtuels
--- Tâches


  +-------------------------------------------------------------------------+
  |Entrer la profondeur de l'arborescence des nouveaux paquets :            |
  |apti                                                                     |
  |                        [ Continuer ]                         [ Abandon ]|
Ce+-------------------------------------------------------------------------+








Cette boîte de dialogue fonctionne exactement comme la boîte de recherche, sauf
qu'au lieu de mettre en évidence le paquet suivant qui correspond à ce que vous
tapez dans la boîte de dialogue, il cache tous les paquets qui ne correspondent
pas. Par exemple, taper apti dans cette boîte de dialogue et appuyer sur Entrée
va cacher tous les paquets sauf ceux dont le nom contient « apti » :

Actions  Annuler  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
aptitude 0.2.15.2
--\ Paquets installés
  --\ admin - Utilitaires d'administration (installation de logiciels, gestion d
    --\ main - L'archive principale de Debian
i     aptitude                                            0.2.15.2-1 0.2.15.2-1
i A   synaptic                                            0.51-1     0.51-1
  --\ x11 - Le système X window et les logiciels s'y rapportant
    --\ main - L'archive principale de Debian
i     xfree86-driver-synaptics                            0.13.3-1   0.13.3-1
--- Paquets non installés
--- Paquets virtuels



Ces paquets ne sont pas installés sur votre ordinateur.









Gérer les paquets

Maintenant que vous savez vous déplacer dans la liste des paquets, il est temps
de commencer à utiliser aptitude pour installer ou supprimer des paquets. Dans
cette section, vous allez apprendre à sélectionner les paquets à installer, à
supprimer ou à mettre à jour.


IMG.alt.suffix Astuce
 = \[Astuce]]
               Vous ne pouvez changer la configuration globale de votre système que sous
               l'utilisateur root. Si vous voulez vous familiariser avec aptitude, vous
               pouvez, sans danger, le lancer en tant qu'utilisateur normal avec l'assurance
               de ne pas pouvoir endommager votre système. aptitude vous informera quand vous
               essaierez de faire quelque chose que seul l'utilisateur root peut faire ; si
               vous souhaitez continuer, il vous faudra donner le mot de passe de root.


Tout changement apporté à un paquet se fait en sélectionnant d'abord le paquet
dans la liste des paquets, puis en appuyant sur la touche correspondant à
l'action à exécuter. Les touches d'action de base sont[2] + pour installer ou
mettre à jour un paquet, - pour supprimer un paquet et = pour empêcher un paquet
d'être automatiquement mis à jour (on appelle cela figer un paquet). Ces actions
ne sont pas exécutées immédiatement. aptitude va uniquement mettre à jour la
liste des paquets pour montrer les changements qui ont été demandés.

Par exemple, dans la capture ci-dessous, le paquet kaffeine-mozilla a été
sélectionné et la touche + pressée. Le paquet est maintenant mis en surbrillance
en vert et la lettre « i » est apparue à gauche de son nom pour indiquer qu'il
sera installé. De plus, une estimation de l'espace qu'il va utiliser est
affichée.

 Actions  Annuler  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
aptitude 0.2.15.2
  --\ kde - L'environnement KDE
    --\ main - L'archive principale de Debian
p     bibletime-i18n                                       <aucun>     1.4.1-1
p     education-desktop-kde                                <aucun>     0.771
p     junior-kde                                           <aucun>     1.4
piA   kaffeine                                     +2843kB <aucun>     0.4.3-1
pi    kaffeine-mozilla                             +81.9kB <aucun>     0.4.3-1
p     karamba                                              <aucun>     0.17-5
p     kde-devel                                            <aucun>     4:3.1.2
p     kde-devel-extras                                     <aucun>     4:3.1.2
The K Desktop Environment (development files)
A metapackage containing dependencies for the core development suite of KDE
including kdesdk, qt3-designer, and all core KDE -dev packages.








IMG.alt.suffix Astuce
 = \[Astuce]]
               À tout moment vous pouvez utiliser Annuler → Annuler (Contrôle+u) pour « annuler »
               les changements faits sur un ou plusieurs paquets. C'est très utile si une action a
               des conséquences imprévues, et que vous souhaitez « revenir en arrière ».


En plus des actions qui affectent des paquets individuels, une autre action
importante est disponible : taper U va tenter de mettre à jour tous les paquets
qui peuvent l'être. Vous devriez utiliser cette commande régulièrement pour
maintenir votre système à jour.


Gérer les paquets cassés

Parfois, changer l'état d'un paquet fait apparaître ses relations de dépendances
comme non satisfaites. Des paquets avec des dépendances non satisfaites sont
dits cassés. aptitude vous avertira quand cela arrive en expliquant pourquoi
cela est arrivé. Par exemple voici ce qui arrive si vous tentez de supprimer
sound-juicer :

 Actions  Annuler  Paquet  Solutions  Rechercher  Options  Vues  Aide
C-T : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
aptitude 0.4.1       #Cassé : 2   Libérera 2298ko d'espace disqu
i     nautilus-cd-burner                                   2.12.2-3   2.12.2-3
i A   nautilus-data                                        2.12.2-2   2.12.2-2
i     netspeed                                             0.13-1     0.13-1
i A   oaf                                                  0.6.10-6   0.6.10-6
i A   planner                                              0.13-4     0.13-4
i     pybliographer                                        1.2.8-1    1.2.8-1
i     rhythmbox                                            0.9.2-3    0.9.2-3
i     shermans-aquarium                                    3.0.1-1    3.0.1-1
idA   sound-juicer                                 -2171kB 2.12.3-3   2.12.3-3
GNOME 2 CD Ripper
sound-juicer sera enlevé.


Les paquets suivants dépendent de sound-juicer et seront cassés par sa
suppression :


  * gnome-desktop-environment  dépend de sound-juicer (>= 2.12.3)

[1(1)/...] Suggère :  2 à conserver
e : Examiner  ! : Appliquer  . : Suivant  , : Précédent

Comme vous pouvez le voir, aptitude affiche trois indicateurs qui montrent que
quelque chose s'est mal passé : premièrement, le nombre de paquets cassés est
affiché dans la zone bleue en haut ; deuxièmement, la seconde moitié de l'écran
a changé pour montrer les paquets cassés qui sont liés au paquet actuellement en
surbrillance ; troisièmement, une barre est apparue en bas de l'écran avec une
suggestion pour résoudre le problème. Pour trouver rapidement les paquets cassés
à travers la liste des paquets, vous pouvez appuyer sur b ou effectuer une
recherche sur ?broken.


IMG.alt.suffix Note
  = \[Note]]
               Le texte [1(1)/...] indique l'avancement du solveur de dépendance d'aptitude. Le
               premier nombre est la solution que vous avez actuellement sélectionnée, et le
               second est le nombre de solutions qu'aptitude a déjà trouvées. La présence du
               texte « ... » indique qu'il pourrait y avoir d'autres solutions que celles déjà
               trouvées. Si aptitude a l'assurance qu'il a trouvé toutes les solutions
               possibles, le texte affiché est alors [1/1].


Pour voir les autres solutions qui, selon aptitude, peuvent résoudre ce
problème, appuyez sur e. Un écran similaire au suivant apparaîtra :

 Actions  Annuler  Paquet  Solutions  Rechercher  Options  Vues  Aide
C-T : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
                Paquets                        Résolution des dépendances
  --\ Les paquets suivants seront conservés dans leur version actuelle :
    gstreamer0.8-cdparanoia                           [0.8.11-6 (unstable, now)]
    sound-juicer                                      [2.12.3-3 (unstable, now)]
















[1(1)/...] Suggère :  2 à conserver
e : Examiner  ! : Appliquer  . : Suivant  , : Précédent

Ici, vous pouvez voir une autre solution en appuyant sur . ou retourner voir les
solutions que vous examiniez précédemment en appuyant sur ,. Pour appliquer la
solution courante et retourner à la liste des paquets, appuyez sur !. Par
exemple, appuyer sur . pendant l'écran précédent passe à la solution suivante :

 Actions  Annuler  Paquet  Solutions  Rechercher  Options  Vues  Aide
C-T : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
                Paquets                        Résolution des dépendances
  --\ Les paquets suivants seront conservés dans leur version actuelle :
    sound-juicer                                      [2.12.3-3 (unstable, now)]
  --\ Réinstaller à une version antérieure les paquets suivants :
    gstreamer0.8-cdparanoia         [0.8.11-6 unstable, now -> 0.8.11-2 testing]















[2(2)/...] Suggère : 1 à conserver,1 vers version antérieure
e : Examiner  ! : Appliquer  . : Suivant  , : Précédent

En plus des commandes de navigation, vous pouvez « rejeter » une solution en
appuyant sur r. Par exemple, la première solution annule la suppression de
sound-juicer qui est justement l'action que nous tentions de faire ! En appuyant
sur r pendant la sélection de l'item correspondant à cette action, on peut alors
faire en sorte qu'aptitude ne tente plus d'annuler la suppression de sound-
juicer.

Actions  Annuler  Paquet  Solutions  Rechercher  Options  Vues  Aide
C-T : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
                Paquets                        Résolution des dépendances
  --\ Les paquets suivants seront conservés dans leur version actuelle :
    gstreamer0.8-cdparanoia                           [0.8.11-6 (unstable, now)]
R   sound-juicer                                      [2.12.3-3 (unstable, now)]






GNOME 2 CD Ripper
gnome-desktop-environment dépend de sound-juicer (>= 2.12.3)
--\ Les actions suivantes permettront de résoudre cette dépendance :
  -> Réinstaller gnome-desktop-environment à une version antérieure [1:2.12.2.2
  -> Supprimer gnome-desktop-environment [1:2.12.2.2 (unstable, now)]
R -> Abandonner la suppression de sound-juicer




[1(1)/...] Suggère :  2 à conserver
e : Examiner  ! : Appliquer  . : Suivant  , : Précédent

Comme vous pouvez le voir, le choix correspondant à conserver sound-juicer dans
sa version actuelle est devenu rouge et a été marqué avec « R » ce qui indique
qu'il a été rejeté. Les solutions qui seront générées après cela (c.-à-d.,
toutes les solutions que vous n'avez pas encore vues) excluront cette action.
Cependant les solutions qui incluent cette action et qui ont déjà été vues
resteront disponibles.


IMG.alt.suffix Note
  = \[Note]]
               Dans la capture d'écran ci-dessus, la description de sound-juicer est affichée
               au milieu de l'écran ; en-dessous, les dépendances, qui ont imposé de garder
               sound-juicer dans sa version actuelle, sont affichées, suivies de toutes les
               solutions connues par aptitude pour résoudre cette dépendance.


Par exemple, si ce rejet est mis en œuvre immédiatement après la suppression de
sound-juicer, appuyer sur . affichera la solution suivante, en passant la
solution qui annulait l'installation de sound-juicer et l'installation de
gstreamer0.8-cdparanoia dans une version antérieure.

 Actions  Annuler  Paquet  Solutions  Rechercher  Options  Vues  Aide
C-T : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
                Paquets                        Résolution des dépendances
  --\ Supprimer les paquets suivants :
    gnome-desktop-environment              [1:2.10.2.3 (unstable, testing, now)]

















[2(2)/...] Suggère : 1 à supprimer
e : Examiner  ! : Appliquer  . : Suivant  , : Précédent

Les rejets sont appliqués uniquement aux nouvelles solutions, c'est-à-dire à
celles qui sont générées quand vous appuyez sur . lorsque la dernière solution
générée est affichée. Les solutions déjà générées contiendront toujours ces
rejets. Vous pouvez annuler un rejet à tout moment en sélectionnant l'action
rejetée, puis en appuyant sur r ; des solutions contenant cette action pourront
être à nouveau générées, ainsi que celles qui avaient été précédemment
« oubliées ».

L'inverse du rejet d'une action est son approbation. Pour cela, il suffit de
sélectionner cette action et d'appuyer sur a. Cela force le solveur à choisir,
autant que possible, cette action[3]. Les actions approuvées sont alors
indiquées en vert et seront marquées avec un « A », comme dans la capture
d'écran suivante :

 Actions  Annuler  Paquet  Solutions  Rechercher  Options  Vues  Aide
C-T : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
                Paquets                        Résolution des dépendances
  --\ Supprimer les paquets suivants :
A   gnome-desktop-environment                       [1:2.12.2.2 (unstable, now)]

















[2(2)/...] Suggère : 1 à supprimer
e : Examiner  ! : Appliquer  . : Suivant  , : Précédent


IMG.alt.suffix Important
     = \
 [Important]]  Si vous ne résolvez pas toutes les dépendances, aptitude utilisera automatiquement
               sa suggestion courante, lorsque vous validerez votre sélection avec g. Néanmoins,
               il est difficile de résoudre automatiquement des problèmes de dépendances, et vous
               pourriez ne pas être satisfait du résultat, si bien qu'il est généralement
               préférable de vérifier les suggestions d'aptitude avant de mettre à exécution votre
               sélection.



Mettre à jour la liste des paquets et installer des paquets

Arrivé ici, vous connaissez assez aptitude pour réellement faire des
modifications sur votre système.

Vous devriez périodiquement mettre à jour la liste des paquets disponibles
depuis les serveurs Debian, afin d'avoir connaissance des nouveaux paquets et
des nouvelles versions des paquets. Pour ce faire, appuyez sur u. À tout moment
pendant le téléchargement, presser q vous permettra de l'abandonner.

Une fois que vous avez une liste de paquets récente, vous pouvez choisir les
paquets à mettre à jour, à installer ou à supprimer comme cela est décrit dans
la section précédente. Pour passer en revue les actions que vous avez demandées,
appuyez sur g une seule fois. Si vous installez le paquet kaffeine-mozilla
(comme dans l'exemple précédent), l'écran suivant apparaît :

Actions  Annuler  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
aptitude 0.2.15.2                  Utilisera 2925ko d'espace disq 1375ko à
téléch
--\ Paquets ajoutés automatiquement pour satisfaire des dépendances
piA kaffeine                                       +2843kB <aucun>     0.4.3-1
--\ Paquets à installer
pi  kaffeine-mozilla                               +81.9kB <aucun>     0.4.3-1






Ces paquets ont été installés parce qu'ils sont nécessaires à un nouveau
paquet dont vous avez demandé l'installation.

Si vous sélectionnez un paquet, une explication de son état courant apparaîtra
à cet endroit.

Comme vous pouvez le voir, aptitude a décidé d'installer automatiquement
kaffeine car kaffeine-mozilla le requiert. À ce moment, vous avez le choix entre
continuer l'installation en appuyant sur g ou l'abandonner en appuyant sur q.


Utiliser aptitude depuis la ligne de commande

En plus de son interface « visuelle » décrite dans la section précédente,
aptitude peut être utilisé pour gérer les paquets directement depuis la ligne de
commande de la même manière que vous utiliseriez apt-get. Cette section couvre
les actions en ligne de commande les plus courantes d'aptitude. Pour plus
d'informations, consultez la référence pour la ligne de commande d'aptitude.

En général, une invocation d'aptitude sur la ligne de commande ressemble à
ceci :

aptitude action [arguments...]

action indique à aptitude l'action qu'il doit effectuer et les arguments
restants sont utilisés de façon spécifique à chaque action. Typiquement, ils
vont être constitués de noms de paquets et d'options courtes[4].

Les actions les plus importantes sont :



  aptitude update

      Cette commande met à jour la liste des paquets comme si vous étiez entré
      dans l'interface graphique et aviez appuyé sur u.


  aptitude safe-upgrade

      Cette commande met à jour autant de paquets que possible, sans supprimer
      de paquets existants.

      Il est parfois nécessaire de supprimer ou d'installer un paquet afin de
      pouvoir en mettre un autre à jour. Cette commande ne peut donc pas gérer
      ce genre de situations. Utilisez la commande full-upgrade pour mettre
      autant de paquets à jour que possible.


  aptitude full-upgrade

      Comme safe-upgrade, cette commande tente elle aussi de mettre à jour les
      paquets, mais elle est plus agressive au niveau de la résolution des
      problèmes de dépendances : elle installe et supprime les paquets jusqu'à
      ce que toutes les dépendances soient satisfaites. De par la nature de
      cette commande, il est possible qu'elle fasse des choses indésirables et
      vous devez être prudent lorsque vous l'utilisez.


      IMG.alt.suffix Note
        = \[Note]]
                     Pour des raisons historiques, cette commande s'appelait à l'origine dist-
                     upgrade, et ce nom est toujours reconnu par aptitude.



  aptitude [ install | remove | purge ] paquet1 [paquet2...]

      Ces commandes installent, suppriment ou purgent[5] le paquet indiqué.
      « Installer » un paquet qui est déjà installé mais qui peut être mis à
      jour entraînera sa mise à jour.


  aptitude search motif1 [motif2...]

      Cette commande recherche les paquets dont le nom contient un ou plusieurs
      motifs donnés et affiche le résultat dans le terminal. Au-delà d'une
      simple chaîne de texte, chaque motif peut être un motif de recherche comme
      ceux décrits dans la section intitulée « Motifs de recherche »[6]. Par
      exemple, « aptitude search gnome kde » affichera la liste de tous les
      paquets dont le nom contient « gnome » ou « kde ».


  aptitude show paquet1 [paquet2...]

      Afficher les informations sur chaque paquet sur le terminal.


Les commandes qui installent, mettent à jour ou suppriment des paquets acceptent
toutes le paramètre « -s », qui signifie « simuler ». Quand « -s » est passé sur
la ligne de commande, le programme exécute les actions qu'il devrait normalement
effectuer sans réellement télécharger ou installer/supprimer aucun fichier.

aptitude présentera parfois une invite comme celle-ci :

Les NOUVEAUX paquets suivants vont être automatiquement installés :
  space-orbit-common
Les NOUVEAUX paquets suivants vont être installés :
  space-orbit space-orbit-common
0 paquets mis à jour, 2 nouvellement installés, 0 à enlever et 0 non mis à jour.
Il est nécessaire de télécharger 3200ko d'archives. Après dépaquetage, 8413ko
seront utilisés.
Voulez-vous continuer ? [O/n/?]

En plus des options « Oui » et « Non » qui sont évidentes, un certain nombre de
commandes sont disponibles et peuvent être utilisées pour modifier les
informations affichées à l'invite ou pour spécifier des options supplémentaires.
Par exemple, taper s affichera ou cachera l'information sur l'espace disque que
chaque paquet va utiliser :

Voulez-vous continuer ? [O/n/?] s

Les changements de taille seront affichés.

Les NOUVEAUX paquets suivants vont être automatiquement installés :
  space-orbit-common <+8020kB>
Les NOUVEAUX paquets suivants vont être installés :
  space-orbit <+393kB> space-orbit-common <+8020kB>
0 paquets mis à jour, 2 nouvellement installés, 0 à enlever et 0 non mis à jour.
Il est nécessaire de télécharger 3200ko d'archives. Après dépaquetage, 8413ko
seront utilisés.
Voulez-vous continuer ? [O/n/?]

De manière analogue, taper d affichera des informations sur les paquets
automatiquement installés ou supprimés :

Les NOUVEAUX paquets suivants vont être automatiquement installés :
  space-orbit-common (D: space-orbit)
Les NOUVEAUX paquets suivants vont être installés :
  space-orbit space-orbit-common
0 paquets mis à jour, 2 nouvellement installés, 0 à enlever et 0 non mis à jour.
Il est nécessaire de télécharger 3200ko d'archives. Après dépaquetage, 8413ko
seront utilisés.

Cela indique que space-orbit-common est sur le point d'être installé parce que
space-orbit en dépend. Vous pouvez voir la liste complète des options possibles
en entrant ? à l'invite.

Si votre demande casse une dépendance d'une manière qui ne peut pas être résolue
simplement, aptitude vous demandera quoi faire :

Les paquets suivants sont CASSÉS :
  libsdl1.2debian
Les paquets suivants seront ENLEVÉS :
  libsdl1.2debian-all
.
.
.
Les actions suivantes permettront de résoudre ces dépendances :

Installer les paquets suivants :
libsdl1.2debian-all [1.2.12-1 (unstable)]

Le score est de 41

Accepter cette solution ? [Y/n/q/?]

Taper y (ou simplement sur entrée) validera la solution proposée. Taper n
affichera la « meilleure » solution suivante :

Accepter cette solution ? [Y/n/q/?] n
Les actions suivantes permettront de résoudre ces dépendances :

Installer les paquets suivants :
libsdl1.2debian-alsa [1.2.12 (unstable)]

Le score est de 19

Accepter cette solution ? [Y/n/q/?]

Comme dans l'invite principale de la ligne de commande, vous pouvez effectuer
des actions supplémentaires, comme par exemple la modification de l'état d'un
paquet depuis l'invite de résolution des dépendances. Tapez ? pour afficher la
liste complète.

Taper q fera abandonner le solveur automatique et vous permettra de résoudre les
dépendances manuellement :

Accepter cette solution ? [Y/n/q/?] q
Il n'a pas été possible de résoudre ces dépendances. Vous pouvez les résoudre
vous-même ou taper « n » pour quitter.
Les paquets suivants ont des dépendances non satisfaites :
  libsdl1.2debian : Dépend: libsdl1.2debian-alsa (= 1.2.12-1) mais il n'est pas
installable ou
                            libsdl1.2debian-all (= 1.2.12-1) mais il n'est pas
installable ou
                            libsdl1.2debian-esd (= 1.2.12-1) mais il n'est pas
installable ou
                            libsdl1.2debian-arts (= 1.2.12-1) mais il n'est pas
installable ou
                            libsdl1.2debian-oss (= 1.2.12-1) mais il n'est pas
installable ou
                            libsdl1.2debian-nas (= 1.2.12-1) mais il n'est pas
installable ou
                            libsdl1.2debian-pulseaudio (= 1.2.12-1) mais il
n'est pas installable ou
Faut-il résoudre ces dépendances manuellement ? [N/+/-/_/:/?]

Vous pouvez utiliser toutes les commandes de manipulation de paquets pour
résoudre les dépendances cassées (tapez ? pour la liste complète des actions
disponibles). Tapez n ou appuyez sur entrée pour quitter aptitude :

Résoudre les dépendances manuellement ? [N/+/-/_/:/?] n
Abandon

Pour une documentation complète des caractéristiques de la ligne de commande
d'aptitude, consultez la Référence de l'interface en ligne de commande.



--------------------------------------------------------------------------------
[2] Vous pouvez aussi utiliser le menu Paquet pour modifier l'état d'un paquet.
Consultez la section intitulée « Le menu « Paquet » » pour plus de détails.

[3] Approuver une action est un peu différent de simplement imposer que toute
solution contienne l'action ; cela signifie qu'à choisir entre une action
approuvée et une qui ne l'est pas, il prendra la première. S'il y a plusieurs
actions approuvées, elles seront toutes susceptibles d'être proposées dans la
solution.

[4]Une « option courte » est une lettre précédée d'un tiret, par exemple, « -
a », « -v », etc.

[5]Purger un paquet supprime le paquet ainsi que tous ses fichiers de
configuration.

[6] En fait, c'est aussi vrai pour les commandes qui prennent des paquets en
argument, comme install ou show.



Chapitre 2. Guide de référence d'aptitude

Table des matières



  L'interface utilisateur d'aptitude depuis le terminal


        Utiliser les menus

        Commandes du menu

        Travailler avec plusieurs vues

        Devenir administrateur (« root »)


  Gérer les paquets


        Gérer la liste des paquets

        Accéder aux informations des paquets

        Modifier l'état d'un paquet

        Télécharger, installer et supprimer des paquets

        Qu'est-ce que la confiance en matière de gestion des paquets ?

        Gérer les paquets automatiquement installés


  Résoudre les dépendances de paquets


        Résolution des dépendances dans aptitude

        Résolution immédiate des dépendances

        Résolution interactive des dépendances

        Coûts dans la résolution interactive de dépendances

        Configuration de la résolution de dépendances interactive


  Motifs de recherche


        Recherche de chaînes de caractères

        Raccourcis pour les termes de recherche

        Recherches et versions

        Cibles de recherche explicites

        Référence pour les termes de recherche


  Personnalisation d'aptitude


        Personnaliser la liste des paquets

        Personnaliser les raccourcis clavier

        Personnaliser la couleur du texte et les styles

        Personnaliser la disposition de l'affichage

        Référence du fichier de configuration

        Thèmes


  Jouer au démineur


  Le Lapin Blanc mit ses lunettes. « Où dois-je commencer votre Majesté ? » demand t-
   il.

   « Commence au commencement », répondit gravement le Roi, « et continue jusqu'à ce que
   tu arrives à la fin, alors arrête-toi. »

                                              -- Lewis Carrol, Alice au pays des merveilles


aptitude est un programme imposant aux nombreuses possibilités et il est parfois
difficile de se rappeler comment faire telle chose ou même de se rappeler si une
chose est possible. En effet, l'auteur reçoit de nombreuses demandes d'ajout de
fonctionnalités qui sont déjà présentes mais difficiles à trouver[7].

Dans une tentative pour combattre cette opacité, ce guide de référence décrit
toutes les fonctionnalités et les paramètres de configuration d'aptitude. Pour
un guide plus abordable sur les fonctionnalités les plus importantes d'aptitude,
consultez Chapitre 1, Démarrage_rapide.


IMG.alt.suffix Note
  = \[Note]]
               Le comportement et l'apparence d'aptitude peuvent être configurés de nombreuses
               façons. Ce manuel décrit comment le programme fonctionne avec la configuration
               par défaut. La description de la manière dont différentes configurations
               affectent son comportement est donnée dans la section intitulée
               « Personnalisation d'aptitude ».



L'interface utilisateur d'aptitude depuis le terminal

Cette section décrit la partie de l'interface utilisateur depuis un terminal
d'aptitude qui ne s'occupe pas de la gestion des paquets.


Utiliser les menus

La barre de menu en haut de l'écran liste les commandes les plus importantes
d'aptitude. Pour activer la barre de menu, utilisez le raccourci clavier
Control+T, vous pouvez alors vous y déplacer avec les touches de flèches et
sélectionner une entrée du menu avec Entrée.

Certaines entrées du menu ont aussi des « clés d'accès rapide » : lettres ou
chiffres qui peuvent être utilisés pour sélectionner une entrée alors que le
menu est actif. Ces clés d'accès rapide sont affichées avec une nuance de blanc
plus clair que le reste du menu.

En plus, certaines entrées du menu ont des « raccourcis clavier » qui effectuent
la même action que l'entrée du menu même lorsque le menu n'est pas actif. Ces
raccourcis sont indiqués à droite des entrées du menu.

Dans le reste du guide, les commandes du menu seront écrites comme ceci : Menu →
Entrée (touche). Cela indique que vous devez utiliser l'Entrée du menu Menu et
que la touche est le raccourci pour cette commande.


Commandes du menu


Le menu « Actions »

Figure 2.1. Commandes disponibles dans le menu Actions

 __________________________________________________________________________________________________________________________________________________
|Commande                                                        |Description                                                                     |
|________________________________________________________________|_________________________________________________________________________________|
|                                                                |Afficher un aperçu d'installation, s'il n'y en a pas de visible. Sinon lancer un|
|Actions → Installer/enlever des paquets (g)                   |processus d'installation, décrit dans la section intitulée « Télécharger,  |
|                                                                |installer et supprimer des paquets ».                                          |
|________________________________________________________________|_________________________________________________________________________________|
|Actions → Mettre à jour les listes de paquets (u)            |Mettre à jour la liste des paquets.                                             |
|________________________________________________________________|_________________________________________________________________________________|
|Actions → Marquer comme étant susceptible de mise à jour (U)|Marquer tous les paquets susceptibles de l'être comme devant être mis à jour, |
|                                                                |l'exception de ceux qui sont gelés ou interdits de mise à jour.                |
|________________________________________________________________|_________________________________________________________________________________|
|Actions → Oublier quels paquets sont nouveaux (f)             |Oublier quels paquets sont « nouveaux » (c'est-à-dire vider l'arborescence  |
|                                                                |« Nouveaux paquets »).                                                       |
|________________________________________________________________|_________________________________________________________________________________|
|                                                                |Annuler toutes les installations, les suppressions et les gels de paquets en     |
|Actions → Annuler les actions en attente                      |attente. Cela revient à exécuter sur l'ensemble des paquets la commande pour le|
|                                                                |garder dans leur état actuel.                                                   |
|________________________________________________________________|_________________________________________________________________________________|
|Actions → Nettoyer le cache des paquets                       |Supprimer toutes les archives de paquets qui ont été téléchargées par aptitu|e
|                                                                |[a].                                                                             |
|________________________________________________________________|_________________________________________________________________________________|
|                                                                |Supprimer toutes les archives de paquets qui ont été téléchargées par aptitu|e[a]
|Actions → Enlever les fichiers périmés                      |et qui ne sont plus disponibles dans les archives Debian. On peut supposer que ce|
|                                                                |sont des paquets obsolètes et qui peuvent être supprimés pour libérer de l'es|ace
|                                                                |disque sans que cela ne nécessite de téléchargements inutiles par ailleurs.   |
|________________________________________________________________|_________________________________________________________________________________|
|Actions → Jouer au démineur                                  |Lancer le démineur, comme cela est décrit dans la section intitulée « Jouer |u
|                                                                |démineur ».                                                                   |
|________________________________________________________________|_________________________________________________________________________________|
|Actions → Devenir administrateur                              |Continuer à travailler en tant qu'utilisateur root. Voir la section intitulée  |
|                                                                |« Devenir administrateur (« root ») ».                                   |
|________________________________________________________________|_________________________________________________________________________________|
|Actions → Quitter (Q)                                         |Quitter aptitude et enregistrer les modifications des états des paquets.        |
|________________________________________________________________|_________________________________________________________________________________|
|[a] ou tout autre utilitaire apt.                                                                                                                 |
|__________________________________________________________________________________________________________________________________________________|




Le menu « Annuler »

Figure 2.2. Commandes disponibles dans le menu Annuler

 _____________________________________________________________________________________________________________________
|Commande                         |Description                                                                       |
|_________________________________|___________________________________________________________________________________|
|                                 |Annuler, un à un, les effets du dernier changement effectué sur l'état d'un paqu|t
|Annuler → Annuler (Contrôle+u)|avec la possibilité de remonter jusqu'à la dernière fois que le programme a ét|
|                                 |démarré, que la liste des paquets a été mise à jour ou qu'un processus        |
|                                 |d'installation a été lancé.                                                     |
|_________________________________|___________________________________________________________________________________|




Le menu « Paquet »

Figure 2.3. Commandes disponibles dans le menu Paquet

 _________________________________________________________________________________________________________________________________________________________
|Commande                                                               |Description                                                                     |
|_______________________________________________________________________|_________________________________________________________________________________|
|Paquet → Installer (+)                                               |Marquer le paquet actuellement sélectionné pour installation.                  |
|_______________________________________________________________________|_________________________________________________________________________________|
|Paquet → Supprimer (-)                                               |Marquer le paquet actuellement sélectionné pour suppression.                   |
|_______________________________________________________________________|_________________________________________________________________________________|
|Paquet → Purger (_)                                                  |Marquer le paquet actuellement sélectionné pour purge.                         |
|_______________________________________________________________________|_________________________________________________________________________________|
|Paquet → Garder (:)                                                  |Annuler toute installation, mise à jour ou suppression prévue pour le paquet   |
|                                                                       |actuellement sélectionné et retirer tout gel qui aurait été mis sur le paquet|
|_______________________________________________________________________|_________________________________________________________________________________|
|Paquet → Geler (=)                                                   |Geler le paquet actuellement sélectionné.                                      |
|_______________________________________________________________________|_________________________________________________________________________________|
|                                                                       |Marquer le paquet actuellement sélectionné comme étant un paquet « installé|
|Paquet → Marquer automatiquement (M)                                 |automatiquement ». Pour plus d'informations sur les paquets installés         |
|                                                                       |manuellement et automatiquement, consultez la section intitulée « Gérer les  |
|                                                                       |paquets automatiquement installés ».                                          |
|_______________________________________________________________________|_________________________________________________________________________________|
|                                                                       |Marquer le paquet actuellement sélectionné comme étant un paquet « installé|
|Paquet → Marquer manuellement (m)                                    |manuellement ». Pour plus d'informations sur les paquets installés manuellemen|
|                                                                       |et automatiquement, consultez la section intitulée « Gérer les paquets       |
|                                                                       |automatiquement installés ».                                                  |
|_______________________________________________________________________|_________________________________________________________________________________|
|                                                                       |Si un paquet qui peut être mis à jour est sélectionné, cela interdit sa mise |
|Paquet → Interdire la version (F)                                    |jour vers la version actuellement disponible uniquement. Si une version du paquet|
|                                                                       |est sélectionnée, cela interdit au paquet d'être mis à jour vers cette versio|.
|_______________________________________________________________________|_________________________________________________________________________________|
|                                                                       |Afficher un écran contenant des informations sur le paquet actuellement         |
|Paquet → Informations (entrée)                                      |sélectionné, comme les paquets dont il dépend, les paquets qui en dépendent, |t
|                                                                       |ses versions disponibles.                                                        |
|_______________________________________________________________________|_________________________________________________________________________________|
|                                                                       |Lors du parcours de la liste des paquets, les informations peuvent être affiché|s
|                                                                       |cycliquement dans la zone d'informations (la moitié inférieure de l'écran). Ce|te
|Paquet → Circuler cycliquement dans l'information sur les paquets (i)|zone d'information peut afficher la description longue des paquets sélectionnés|
|                                                                       |(c'est le comportement par défaut), un résumé des dépendances liées à ce pa|uet,
|                                                                       |ou une analyse des paquets qui nécessitent ou suggèrent le paquet sélectionné|
|_______________________________________________________________________|_________________________________________________________________________________|
|                                                                       |Affiche la liste des modifications du paquet Debian actuellement sélectionné.  |
|Paquet → Liste des modifications (C)                                 |Pour voir les modifications d'une version particulière, sélectionnez cette     |
|                                                                       |version avant d'exécuter cette commande.                                        |
|_______________________________________________________________________|_________________________________________________________________________________|




Le menu « Solutions »

Figure 2.4. Commandes disponibles dans le menu Solutions

 ____________________________________________________________________________________________________________________________________
|Commande                                          |Description                                                                     |
|__________________________________________________|_________________________________________________________________________________|
|Solutions → Examiner la solution (e)            |Afficher une description détaillée de la suggestion actuelle (consultez la     |
|                                                  |section intitulée « Résolution interactive des dépendances »).            |
|__________________________________________________|_________________________________________________________________________________|
|Solutions → Appliquer la solution (!)           |Exécuter les actions actuellement suggérées.                                  |
|__________________________________________________|_________________________________________________________________________________|
|Solutions → Solution suivante (.)               |Sélectionner la suggestion suivante.                                            |
|__________________________________________________|_________________________________________________________________________________|
|Solutions → Solution précédente (,)           |Sélectionner la suggestion précédente.                                        |
|__________________________________________________|_________________________________________________________________________________|
|Solutions → Première solution (<)              |Sélectionner la première suggestion.                                           |
|__________________________________________________|_________________________________________________________________________________|
|Solutions → Dernière solution (>)              |Sélectionner la suggestion la plus récente (voir la section intitulée         |
|                                                  |« Résolution interactive des dépendances »).                               |
|__________________________________________________|_________________________________________________________________________________|
|                                                  |Lors de l'examen d'une solution, rejeter l'action actuellement sélectionnée et |
|Solutions → Marquer comme rejeté (r)           |passer à l'action suivante (voir la section intitulée « Résolution interacti|e
|                                                  |des dépendances »). Si l'action était dans l'état approuvé, son approbation|est
|                                                  |annulée.                                                                        |
|__________________________________________________|_________________________________________________________________________________|
|                                                  |Lors de l'examen d'une solution, approuver l'action actuellement sélectionnée e|
|Solutions → Marquer comme retenu (a)            |passer à l'action suivante (voir la section intitulée « Résolution interacti|e
|                                                  |des dépendances »). Si l'action était dans l'état rejeté, son rejet est ann|lé.
|__________________________________________________|_________________________________________________________________________________|
|                                                  |Lors de l'examen d'une solution, afficher des informations détaillées sur le   |
|Solutions → Afficher la cible (entrée)         |paquet touché par l'action actuellement sélectionnée (voir la section intitul|e
|                                                  |« Résolution interactive des dépendances »).                               |
|__________________________________________________|_________________________________________________________________________________|
|                                                  |Rejeter (comme avec Solutions → Marquer comme rejeté (r)) toutes les actions q|i
|                                                  |pourraient casser le figeage d'un paquet ou installer une version interdite. Ces |
|Solutions → Rejeter les non-respects de figeages|actions sont rejetées par défaut, sauf si Aptitude::ProblemResolver::Allow-Brea|-
|                                                  |Holds est positionnée à true, mais cette entrée de menu vous permet de les    |
|                                                  |rejeter manuellement à tout moment.                                             |
|__________________________________________________|_________________________________________________________________________________|




Le menu « Rechercher »

Figure 2.5. Commandes disponibles dans le menu Rechercher

 _______________________________________________________________________________________________________________________
|Commande                                 |Description                                                                 |
|_________________________________________|_____________________________________________________________________________|
|Rechercher → Rechercher (/)            |Rechercher le paquet suivant dans la liste des paquets qui correspond au     |
|                                         |motif de recherche (voir la section intitulée « Motifs de recherche »). |
|_________________________________________|_____________________________________________________________________________|
|Rechercher → Rechercher en arrière (\)|Rechercher le paquet précédent dans la liste des paquets qui correspond au |
|                                         |motif de recherche (voir la section intitulée « Motifs de recherche »). |
|_________________________________________|_____________________________________________________________________________|
|Rechercher → Rechercher à nouveau (n) |Répéter la dernière recherche.                                            |
|_________________________________________|_____________________________________________________________________________|
|                                         |Répéter la dernière commande, mais dans le sens inverse. Si la dernière  |
|Rechercher → Rechercher en arrière (N)|commande Rechercher était Rechercher vers le haut, alors cela exécutera un |
|                                         |Rechercher vers le bas, et vice versa.                                       |
|_________________________________________|_____________________________________________________________________________|
|                                         |Filtrer la liste de paquets en omettant tous les paquets qui ne correspondent|
|Rechercher → Affichage restreint (l)   |pas au motif de recherche (voir la section intitulée « Motifs de          |
|                                         |recherche »).                                                              |
|_________________________________________|_____________________________________________________________________________|
|Rechercher → Affichage complet         |Retirer le filtrage de la liste de paquets (tous les paquets sont affichés).|
|_________________________________________|_____________________________________________________________________________|
|Rechercher → Rechercher les cassés (b)|Rechercher le paquet cassé suivant. Cela revient à rechercher ?broken.     |
|_________________________________________|_____________________________________________________________________________|




Le menu « Options »

Figure 2.6. Commandes disponibles dans le menu Options

 ______________________________________________________________________________________________________________________________
|Commande                                   |Description                                                                      |
|___________________________________________|__________________________________________________________________________________|
|                                           |Ouvrir une nouvelle vue dans laquelle les paramètres d'aptitude peuvent être    |
|                                           |modifiés. Les options de configuration sont affichées dans un arbre similaire à|
|Options → Préférences                  |celui des paquets. Pour activer ou désactiver une option, sélectionnez-la et    |
|                                           |appuyez sur Espace ou Entrée. Les options de configuration sont sauvegardées dan|
|                                           |le fichier ~/.aptitude/config immédiatement après avoir été sélectionnées.  |
|___________________________________________|__________________________________________________________________________________|
|Options → Revenir aux options par défaut|Revenir aux options de configuration par défaut.                                 |
|___________________________________________|__________________________________________________________________________________|




Le menu « Vues »


IMG.alt.suffix Note
  = \[Note]]
               Pour un aperçu du fonctionnement des vues, consultez la section intitulée
               « Travailler avec plusieurs vues ».


Figure 2.7. Commandes disponibles dans le menu Vues

 ________________________________________________________________________________________________________________________
|Commande                                 |Description                                                                  |
|_________________________________________|______________________________________________________________________________|
|Vues → Suivant (F6)                    |Aller à la vue active suivante.                                              |
|_________________________________________|______________________________________________________________________________|
|Vues → Précédent (F7)                |Aller à la vue active précédente.                                          |
|_________________________________________|______________________________________________________________________________|
|Vues → Fermer (q)                      |Fermer la vue actuelle.                                                       |
|_________________________________________|______________________________________________________________________________|
|Vues → Nouvelle vue des paquets        |Créer une nouvelle vue de la liste des paquets.                              |
|_________________________________________|______________________________________________________________________________|
|Vues → Voir les recommandations        |Créer une vue qui affiche les paquets qui ne sont pas installés et qu'un    |
|                                         |paquet installé sur votre système recommande.                               |
|_________________________________________|______________________________________________________________________________|
|Vues → Nouvelle liste des paquets      |Créer une nouvelle vue de la liste des paquets dans laquelle les paquets ne  |
|                                         |sont pas triés.                                                              |
|_________________________________________|______________________________________________________________________________|
|Vues → Consultation par « Debtags »|Créer une nouvelle vue de la liste des paquets dans laquelle les paquets sont|
|                                         |rangés en fonction de leur entrée debtags.                                  |
|_________________________________________|______________________________________________________________________________|
|Vues → Consultation par catégories    |Afficher la liste des paquets, organisée par catégorie.                     |
|_________________________________________|______________________________________________________________________________|
|Entrées supplémentaires                |D'autres entrées du menu apparaissent. Il s'agit des vues actuellement       |
|                                         |actives. Pour atteindre directement une vue, sélectionnez-la dans ce menu.   |
|_________________________________________|______________________________________________________________________________|




Le menu « Aide »

Figure 2.8. Commandes disponibles dans le menu Aide

 ________________________________________________________________________________________________________
|Commande                        |Description                                                           |
|________________________________|_______________________________________________________________________|
|Aide → À propos              |Afficher des informations de copyright.                                |
|________________________________|_______________________________________________________________________|
|Aide → Aide (?)               |Afficher l'aide en ligne.                                              |
|________________________________|_______________________________________________________________________|
|Aide → Manuel Utilisateur     |Afficher le manuel de l'utilisateur (ce document).                     |
|________________________________|_______________________________________________________________________|
|Aide → FAQ                    |Afficher la FAQ d'aptitude.                                            |
|________________________________|_______________________________________________________________________|
|Aide → Liste des modifications|Afficher la liste des principales modifications apportées à aptitude.|
|________________________________|_______________________________________________________________________|
|Aide → Licence                |Afficher les termes de la licence sous laquelle vous pouvez copier,    |
|                                |modifier et distribuer aptitude.                                       |
|________________________________|_______________________________________________________________________|




Travailler avec plusieurs vues

aptitude vous permet de travailler avec plusieurs « vues » à la fois. Une
« vue » (parfois appelée « écran ») est simplement quelque chose qui apparaît
dans une zone de l'écran en dessous de la barre de menu. La vue la plus courante
est la liste des paquets, la vue des téléchargements est aussi assez courante.

Quand plusieurs vues sont ouvertes en même temps, une barre listant l'ensemble
des vues actives apparaît en haut de l'écran. Par exemple, si on examine apt en
appuyant sur entrée, puis qu'on examine libc6, l'écran ressemblera à ceci :

 Actions  Annuler  Paquet  Solutions  Rechercher  Options  Vues  Aide
C-T : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
         Paquets                  apt : info                libc6 : info
aptitude 0.4.1
i    --\ libc6                                             2.3.5-12   2.3.5-12
  Description : GNU C Library: Shared libraries and Timezone data
    Contains the standard libraries that are used by nearly all programs on the
    system. This package includes shared versions of the standard C library and
    the standard math library, as well as many others. Timezone data is also
    included.

  Marqueurs: devel::library, langdevel::c, made-of::lang:c, protocol::ipv6,
             role::sw:shlib
  Priorité : nécessaire
  Section : libs
  Responsable : GNU Libc Maintainers <debian-glibc@lists.debian.org>
  Taille compressée : 5029k
  Taille décompressée : 17,1M
  Paquet source : glibc
  --\ Suggère
    --- glibc-doc
    --- locales
  --\ Est en conflit avec
GNU C Library: Shared libraries and Timezone data

Vous pouvez fermer la vue courante avec Vues → Fermer (q). Pour atteindre les
vues précédentes et suivantes, utilisez Vues → Suivant (F6) et Vues → Précédent
(F7) ou cliquez sur le nom de la vue en haut de l'écran. Vous pouvez aussi
trouver une liste de toutes les vues actives dans le menu Vues.

Comme ci-dessus, certaines commandes (par exemple, voir les informations d'un
paquet) vont créer automatiquement de nouvelles vues. Vous pouvez aussi demander
la création d'une nouvelle vue avec Vues → Nouvelle vue des paquets ou Vues →
Consultation par catégories.


Devenir administrateur (« root »)

Certaines actions, telles que la mise à jour de la liste des paquets, ne peuvent
être réalisées qu'en tant que root. Si vous n'êtes pas root au moment de mettre
à jour la liste des paquets, aptitude va vous demander de le devenir :

 Actions  Annuler  Paquet  Solutions  Rechercher  Options  Vues  Aide
C-T : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
aptitude 0.4.1
--- Paquets installés
--- Paquets non installés
--- Paquets obsolètes ou créés localement
--- Paquets virtuels
--- Tâches


+------------------------------------------------------------------------------+
|La mise à jour des listes de paquets exige des privilèges d'administration que|
|vous n'avez pas pour le moment. Voulez-vous devenir administrateur ?          |
|     [ Devenir administrateur ]         [ Ne pas devenir administrateur ]     |
+------------------------------------------------------------------------------+








Si vous sélectionnez « Devenir administrateur », aptitude va vous demander de
saisir le mot de passe de root. Une fois que vous l'aurez correctement saisi,
aptitude effectuera les actions qui ont nécessité les droits d'administration.
Vous resterez root après la fin de l'action.

Vous pouvez passer sous le compte root à tout moment en utilisant la commande
Actions → Devenir administrateur. Tous les changements que vous avez apportés à
l'état des paquets sont préservés (mais ils ne seront sauvegardés qu'à la
fermeture d'aptitude).

Par défaut, aptitude utilisera la commande su pour obtenir les droits du
superutilisateur (« root »). Si vous souhaitez utiliser une autre commande
(comme par exemple sudo), définissez l'option de configuration Aptitude::Get-
Root-Command.


Gérer les paquets

Cette section décrit comment manipuler la liste des paquets, comment installer
de nouveaux paquets sur votre système et comment supprimer de vieux paquets.


Gérer la liste des paquets

Pour garder la liste des paquets à jour, il est recommandé de la mettre à jour
régulièrement. Vous pouvez le faire grâce à la commande Actions → Mettre à jour
les listes de paquets (u).


Accéder aux informations des paquets

Les informations sur les paquets sont présentes à plusieurs endroits : la liste
des paquets donne un aperçu rapide de l'état de chaque paquet et d'autres vues
sont aussi disponibles avec des informations détaillées sur chaque paquet.


La liste des paquets

La liste des paquets montre un résumé succinct de l'état d'un paquet. Par
exemple, le paquet webmin pourrait avoir le résumé suivant :

piAU  webmin                                        +5837kB <aucun>    1.160-2

Les quatre caractères sur la gauche indiquent que le paquet n'est pas installé
(« p »), qu'il est sur le point d'être installé (« i »), qu'il a été installé
automatiquement (« A »), et qu'il ne provient pas d'une source fiable (« U »). À
droite, on peut lire la version actuelle et la version la plus récente
disponible, ainsi qu'une indication de l'espace supplémentaire que
l'installation va utiliser.


IMG.alt.suffix Astuce
 = \[Astuce]]
               Vous pouvez personnaliser la manière d'afficher ce résumé. Consultez la section
               intitulée « Personnaliser la manière d'afficher les paquets » pour plus de
               détails.


Les quatre indicateurs d'état sur la gauche de l'écran donnent les informations
de base sur l'état d'un paquet. Le premier caractère indique l'état courant du
paquet. Le second indique l'action qui sera entreprise sur le paquet. Le
troisième indique si le paquet a été automatiquement installé (voir la section
intitulée « Gérer les paquets automatiquement installés »). Enfin, le quatrième
indique si le paquet est fiable (voir la section intitulée « Qu'est-ce que la
confiance en matière de gestion des paquets ? »).

Les valeurs possibles pour l'indicateur de « l'état courant » sont données dans
Figure 2.9, « Valeurs de l'indicateur de « l'état courant » » et les valeurs
possibles de l'indicateur « d'action » sont données dans Figure 2.10, « Valeurs
de l'indicateur « d'action » ».

Figure 2.9. Valeurs de l'indicateur de « l'état courant »


i - le paquet est installé et toutes ses dépendances sont satisfaites.

c - le paquet a été supprimé mais ses fichiers de configuration sont toujours
    présents sur le système.

p - le paquet et tous ses fichiers de configuration ont été supprimés, ou le
    paquet n'a jamais été installé.

v - le paquet est virtuel.

B - le paquet a des dépendances cassées.

u - le paquet a été dépaqueté mais pas configuré.

C - à moitié configuré : la configuration du paquet a été interrompue.

H - à moitié installé : l'installation du paquet a été interrompue.




Figure 2.10. Valeurs de l'indicateur « d'action »


i - le paquet va être installé.

u - le paquet va être mis à jour.

d - le paquet va être supprimé : il sera supprimé mais ses fichiers de
    configuration resteront sur le système.

p - le paquet va être purgé : lui et ses fichiers de configuration seront
    supprimés.

h - le paquet est gelé : il sera gardé dans sa version actuelle, même si une
    version plus récente est disponible, jusqu'à ce que le gel soit retiré.

F - Toute mise à jour du paquet est interdite.

r - le paquet va être réinstallé.

    le paquet est « cassé » : certaines de ses dépendances ne sont pas satisfaites.
B - aptitude ne vous permettra pas d'installer, supprimer ou mettre à jour quoique
    ce soit tant que des paquets sont cassés.




De plus, si le terminal le permet, aptitude utilise des couleurs pour indiquer
l'état d'un paquet. La distinction entre les états se fait principalement grâce
à la couleur de l'arrière-plan :



  Noir
      Le paquet ne peut pas être mis à jour (ou il ne sera pas installé) et il
      n'a pas de problème de dépendance. Si le paquet est déjà installé, son nom
      est en surbrillance.


  Vert
      Le paquet est sur le point d'être installé.


  Bleu
      Le paquet est actuellement installé et il va être mis à jour.


  Magenta
      Le paquet est actuellement installé, mais il va être supprimé.


  Blanc
      Le paquet est actuellement installé et il est « gelé » dans sa version
      courante : les mises à jour automatiques l'ignoreront.


  Rouge
      Le paquet est cassé : certaines de ces dépendances ne sont pas
      satisfaites.


Enfin, la moitié inférieure de l'écran affiche la description longue. aptitude
tentera de détecter si le paquet est impliqué dans des problèmes de dépendances.
Si c'est le cas, des informations concernant ces problèmes de dépendances y
seront affichées. Pour passer des informations de dépendances à la description
du paquet, et inversement, appuyez sur i.


Informations détaillées sur un paquet

Appuyer sur Entrée pendant qu'un paquet est en surbrillance affichera un écran
contenant les informations sur ce paquet :

Actions  Annuler  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
aptitude 0.2.15.6
i A --\ apt                                                0.5.26     0.5.26
  Description : Advanced front-end for dpkg
    This is Debian's next generation front-end for the dpkg package manager. It
    provides the apt-get utility and APT dselect method that provides a simpler,
    safer way to install and upgrade packages.

    APT features complete installation ordering, multiple source capability and
    several other unique features, see the Users Guide in apt-doc.
  Essentiel : oui
  Priorité : important
  Section : base
  Responsable : APT Development Team <deity@lists.debian.org>
  Taille compressée : 1094k
  Taille décompressée : 3420k
  Paquet source : apt
  --\ Dépend
    --- libc6 (>= 2.3.2.ds1-4)
    --- libgcc1 (>= 1:3.4.1-3)
    --- libstdc++5 (>= 1:3.3.4-1)
  --\ Suggère
    --- aptitude | synaptic | gnome-apt | wajig
    --- dpkg-dev
    --\ apt-doc (NON SATISFAITE)
p     0.5.27
p     0.5.26
  --\ Remplace
    --- libapt-pkg-doc (< 0.3.7)
    --- libapt-pkg-dev (< 0.3.7)
  --- Noms de paquet fournis par apt
  --- Paquets dépendants de apt
  --\ Versions
p A 0.5.27
i A 0.5.26

On peut naviguer dans cet écran de manière similaire à la liste des paquets :
par exemple, dans la capture précédente, l'arbre des dépendances sur apt-doc
fait apparaître les versions disponibles d'apt-doc qui peuvent satisfaire la
dépendance. Ces versions peuvent être manipulées de la même manière que les
paquets : par exemple, pour installer la version 0.5.25 de apt-doc, il vous
suffit de la mettre en surbrillance et d'appuyer sur +.


IMG.alt.suffix Astuce
 = \[Astuce]]
               Pour satisfaire rapidement une dépendance, sélectionnez-la et appuyez sur +.
               aptitude tentera automatiquement de la satisfaire.


En plus des dépendances d'un paquet, vous pouvez voir le nom des paquets qu'il
fournit, les paquets qui dépendent de lui, ainsi que les versions disponibles du
paquet (en incluant tous les paquets qui le fournissent).

Comme d'habitude, vous pouvez quitter cet écran et retourner à la vue principale
en appuyant sur q. Par commodité, quelques autres écrans d'information (qui
n'affichent que quelques informations courantes et cachent le reste) sont
disponibles : appuyez sur v pour voir les versions d'un paquet, d pour voir les
dépendances d'un paquet et r pour voir les « dépendances inverses » d'un paquet
(c'est-à-dire les paquets qui dépendent de ce paquet).


Modifier l'état d'un paquet

Les commandes suivantes sont disponibles pour modifier l'état des paquets. Ces
commandes prennent effet au prochain lancement d'un processus d'installation.
Jusque-là, toutes ces commandes peuvent être annulées en utilisant Annuler →
Annuler (Contrôle+u).

Pour appliquer une commande à un paquet, il suffit de le sélectionner dans une
liste de paquets et d'exécuter la commande. Ces commandes peuvent aussi être
appliquées à un groupe de paquets en sélectionnant l'en-tête du groupe (par
exemple : « Paquets pouvant être mis à jour ») et en exécutant la commande.

 ________________________________________________________________________________________________________________________________________________________________
|Commande                                                                   |Description                                                                        |
|___________________________________________________________________________|____________________________________________________________________________________|
|                                                                           |Marque le paquet courant pour installation.                                         |
|                                                                           |                                                                                    |
|Installation : Paquet → Installer (+)                                   |Si le paquet n'est pas installé, il le sera. S'il est déjà installé, il sera mis|à
|                                                                           |jour, si possible, et les éventuels marquages empêchant sa mise à jour (p. ex. Ge|)
|                                                                           |seront annulés.                                                                    |
|___________________________________________________________________________|____________________________________________________________________________________|
|                                                                           |Marquer le paquet courant pour suppression.                                         |
|Suppression : Paquet → Supprimer (-)                                    |                                                                                    |
|                                                                           |Si le paquet est installé, il sera supprimé.                                      |
|___________________________________________________________________________|____________________________________________________________________________________|
|                                                                           |Marquer le paquet courant pour être purger.                                        |
|                                                                           |                                                                                    |
|Purger : Paquet → Purger (_)                                            |Si le paquet est installé, il sera supprimé. De plus, s'il est déjà supprimé, t|ut
|                                                                           |fichier restant (comme les fichiers de configuration) lié à ce paquet sera supprim|
|                                                                           |du système.                                                                        |
|___________________________________________________________________________|____________________________________________________________________________________|
|                                                                           |Marquer le paquet courant pour qu'il soit gardé dans sa version actuelle.          |
|Conserver : Paquet → Garder (:)                                         |                                                                                    |
|                                                                           |Toute action qui était prévue sur le paquet (installation, suppression ou mise à |
|                                                                           |jour) est annulée et tout gel persistant sur le paquet est retiré.                |
|___________________________________________________________________________|____________________________________________________________________________________|
|                                                                           |Placer un gel persistant sur le paquet.                                             |
|                                                                           |                                                                                    |
|Figer : Paquet → Geler (=)                                              |Comme avec Conserver, toute action prévue sur le paquet est annulée. De plus, le  |
|                                                                           |paquet ne sera pas mis automatiquement à jour[a] tant que le figeage n'est pas     |
|                                                                           |retiré. Vous pouvez annuler un figeage en exécutant une action Installer.         |
|___________________________________________________________________________|____________________________________________________________________________________|
|                                                                           |Le paquet ne sera pas automatiquement mis à jour[a] vers la version vers laquelle i|
|                                                                           |peut actuellement l'être. S'il est sur le point d'être installé, sa mise à jour |era
|                                                                           |annulée.                                                                           |
|                                                                           |                                                                                    |
|                                                                           |Si vous lancez cette commande sur une version particulière d'un paquet, le paquet n|
|Paquet → Interdire la version (F)                                        |sera pas mis à jour vers la version sélectionnée. Remarquez qu'on ne peut interdi|e
|                                                                           |qu'une seule version à la fois.                                                    |
|                                                                           |                                                                                    |
|                                                                           |Cette fonction est principalement fournie pour faciliter la vie des utilisateurs de |
|                                                                           |la distribution « unstable », afin qu'ils puissent éviter certaines versions de|
|                                                                           |paquet connues comme étant défectueuses.                                          |
|___________________________________________________________________________|____________________________________________________________________________________|
|                                                                           |Réinstaller le paquet.                                                             |
|                                                                           |                                                                                    |
|Réinstaller : appuyer sur L                                              |Remarquez que la marque de réinstallation ne sera pas sauvegardée quand vous      |
|                                                                           |quitterez aptitude ou lancerez un processus d'installation pour des raisons         |
|                                                                           |techniques (brièvement, les couches logicielles sous-jacentes — dpkg et apt —|ne
|                                                                           |fournissent aucun moyen de savoir si une réinstallation a réussi ou non).         |
|___________________________________________________________________________|____________________________________________________________________________________|
|                                                                           |Indiquer si le paquet doit être traité comme ayant été automatiquement installé| Les
|Paquet → Marquer automatiquement (M), Paquet → Marquer manuellement (m)|paquets automatiquement installés sont supprimés quand plus aucun paquet ne les   |
|                                                                           |requiert. Pour plus d'informations, consultez la section intitulée « Gérer les  |
|                                                                           |paquets automatiquement installés ».                                             |
|___________________________________________________________________________|____________________________________________________________________________________|
|[a] Plus précisément, il ne sera pas affecté par la commande Actions → Marquer comme étant susceptible de mise à jour (U) ou par les actions en ligne de |
|commande full-upgrade et safe-upgrade.                                                                                                                          |
|________________________________________________________________________________________________________________________________________________________________|

En plus de ces commandes qui affectent le paquet sélectionné, il y a deux
commandes qui affectent un grand nombre de paquets d'un seul coup quel que soit
ce qui est sélectionné. Actions → Oublier quels paquets sont nouveaux (f) enlève
l'état « nouveau » de tous les paquets de la liste de paquets et Actions →
Marquer comme étant susceptible de mise à jour (U) marque tous les paquets qui
peuvent l'être pour mise à jour, à l'exception des paquets qui sont gelés ou qui
seraient mis à jour vers une version interdite.


IMG.alt.suffix Note
  = \[Note]]
               Tout changement de l'état des paquets est enregistré quand vous quittez
               aptitude, mettez à jour la liste des paquets ou lancez un processus
               d'installation. Si vous ne voulez pas enregistrer vos changements, vous
               pouvez toujours abandonner aptitude en pressant Ctrl-C.



Télécharger, installer et supprimer des paquets

Changer l'état des paquets de la façon décrite dans la section précédente
n'affecte pas réellement ce qui est installé sur votre système. De cette manière
vous pouvez ajuster l'état des paquets sans affecter votre système jusqu'à ce
que vous soyez satisfait. Une fois que vous l'êtes, vous pouvez les
« appliquer » pour vraiment installer et supprimer les paquets[8].

Pour appliquer vos changements, utilisez la commande Actions → Installer/enlever
des paquets (g). Sélectionner cette commande va afficher un aperçu décrivant les
changements qui seront effectués. Cet écran n'est qu'une liste de paquets et
vous pouvez manipuler les paquets (par exemple, annuler des suppressions non
désirées) de la même manière que vous le feriez dans la liste principale.

Quand vous êtes prêt, utilisez Vues → Fermer (q) pour annuler l'installation ou
Actions → Installer/enlever des paquets (g) pour la lancer. aptitude
téléchargera tous les fichiers nécessaires, puis vous demandera s'il faut
continuer le processus. Si vous validez par « Continuer », les installations et
suppressions vont débuter.

Les paquets qui sont téléchargés par aptitude sont placés dans un répertoire de
cache (habituellement /var/cache/apt/archives). Normalement, ils y sont laissés
ad infinitum. Pour supprimer tous les fichiers de ce répertoire, utilisez
Actions → Nettoyer le cache des paquets, pour ne supprimer que les fichiers qui
ne peuvent plus être téléchargés (c'est-à-dire les paquets obsolètes), utilisez
Actions → Enlever les fichiers périmés.


Qu'est-ce que la confiance en matière de gestion des paquets ?

La possibilité pour apt d'accéder à de nombreuses sources de paquets conduit à
un risque potentiel en matière de sécurité. Supposons que vous ajoutiez une
archive publiée par Jean-Kevin Lepirate à votre fichier sources.list afin
d'installer le paquet ubersuper de Jean-Kevin. Il est possible que l'archive de
Jean-Kevin contienne aussi ses propres versions « personnalisées » de paquets
comme libc6 ou ssh... et ces versions vont voler vos informations personnelles
ou ouvrir des portes dérobées sur votre système ! Si ces paquets ont un numéro
de version supérieur à ceux des paquets Debian légitimes, apt les installera sur
votre système à la prochaine mise à jour, sans se soucier de rien, permettant à
Jean-Kevin de faire sa sale besogne dans votre dos. Jean-Kevin pourrait aussi
modifier votre miroir des archives Debian et remplacer les logiciels légitimes
par ses versions corrompues.

Heureusement, les nouvelles versions d'apt et d'aptitude, comme celle qui est
documentée dans ce manuel, intègrent des mécanismes de protection pour contrer
ce genre d'attaque. apt utilise de puissants mécanismes de sécurité basés sur le
célèbre logiciel de chiffrement GPG pour vérifier que les paquets qui sont
distribués depuis les miroirs officiels Debian sont bien les mêmes que ceux qui
ont été envoyés par les responsables de paquets Debian. aptitude vous avertira
alors si vous tentez d'installer un paquet depuis une source non-Debian, ou si
vous tentez de mettre à jour un paquet provenant d'une source Debian vers une
version qui ne vient pas d'une source Debian.


IMG.alt.suffix = Avertissement
       \
[Avertissement]] Les mécanismes de sécurité d'apt fournissent une garantie presque totale que le
                 contenu de votre miroir est identique au contenu de l'archive Debian principale.
                 Néanmoins, ce n'est pas une panacée. Par exemple, il existe théoriquement de
                 nombreuses façons de mettre un paquet corrompu dans l'archive Debian principale.

                 S'assurer que vous n'installez des logiciels que depuis des sources fiables vous
                 apportera un degré important de protection contre les paquets malveillants, mais
                 ça ne peut pas éliminer tous les risques inhérents à l'installation de logiciels.



Comprendre la confiance

apt permet à l'administrateur d'une archive de fournir une signature de l'index
de l'archive. Cette signature, qui (pour des raisons pratiques) ne peut pas être
falsifiée, indique que les fichiers indiqués dans l'index sont bien ceux que
l'administrateur avait l'intention de mettre dans l'archive : c'est-à-dire que
le contenu de l'archive n'a pas été corrompue depuis sa création[9]. La
signature peut être vérifiée en s'assurant qu'elle correspond à la clé publique
de l'administrateur. La clé publique de l'archive Debian est distribuée avec
apt, typiquement sur votre CD Debian.

Quand aptitude télécharge l'index d'une archive, il vérifie si l'index est bien
signé. S'il ne l'est pas, aptitude ne fera pas confiance aux paquets de cette
archive (voir plus bas pour savoir ce que cela signifie). S'il a une signature
mais que celle-ci est incorrecte ou ne peut être vérifiée, un avertissement sera
affiché et aptitude refusera de faire confiance aux paquets de cette archive.

Plus tard, quand vous lancerez un processus d'installation, aptitude vérifiera
si les paquets viennent de sources fiables. Si un paquet douteux est sur le
point d'être installé, ou si un paquet est mis à jour d'une version fiable vers
une version non fiable, un avertissement est affiché et vous avez la possibilité
d'interrompre le téléchargement :

 Actions  Annuler  Paquet  Solutions  Rechercher  Options  Vues  Aide
C-T : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
aptitude 0.4.1                    Libérera 315ko d'espace disque 16,8Mo à téléch
--\ Paquets à mettre à jour
iu U wesnoth                                       +41,0kB 0.9.4-1    0.9.5-1
iuAU wesnoth-data                                  -410kB  0.9.4-1    0.9.5-1
+------------------------------------------------------------------------------+
|ATTENTION : des versions non certifiées des paquets qui suivent vont être     |
|installées.                                                                   |
|                                                                              |
|Des paquets non certifiés peuvent compromettre la sécurité de votre système.  |
|Vous ne devez poursuivre leur installation que si vous êtes certain de ce que |
|vous faites.                                                                  |
|  * wesnoth [version 0.9.5-1]                                                 |
|  * wesnoth-data [version 0.9.5-1]                                            |
|  * wesnoth-ei [version 0.9.4-1]                                              |
|      [ Continuer malgré tout ]            [ Abandon de l'installation ]      |
+------------------------------------------------------------------------------+
                                                                               #
                                                                               #
                                                                               #
                                                                               #
                                                                               #
                                                                               #


Faire confiance à d'autres clés

Il peut être pratique de faire en sorte qu'apt fasse confiance à d'autres
archives, en plus de l'archive Debian principale. Pour chaque archive à laquelle
vous voulez faire confiance, vous devez récupérer la clé publique utilisée pour
signer l'index des paquets de cette archive. C'est habituellement un fichier
texte dont le nom finit par .asc. Il doit être fourni par l'administrateur du
serveur ou téléchargeable depuis un serveur de clés publiques. Pour plus
d'information sur ce que sont les clés publiques et comment les récupérer,
consultez la page web de GPG.

La liste des clés auxquelles apt fait confiance est stockée dans le fichier
porte-clés /etc/apt/trusted.gpg. Une fois que vous avez la clé GPG, vous pouvez
l'ajouter à ce fichier en exécutant la commande gpg --no-default-keyring --
keyring /etc/apt/trusted.gpg --import nouvelleclef.asc. aptitude fera alors
confiance à toutes les archives signées avec la clé contenue dans
nouvelleclef.asc.


IMG.alt.suffix = Avertissement
       \
[Avertissement]] Une fois que la clé d'une archive a été ajoutée au porte-clés d'apt, il lui sera
                 accordé autant de confiance qu'aux miroirs Debian eux-mêmes ! Vous ne devriez
                 faire cela que si vous êtes absolument sûr que la clé que vous ajoutez est la
                 bonne et que la personne qui détient cette clé est à la fois fiable et
                 compétente.



Gérer les paquets automatiquement installés

Pour installer un paquet, il est souvent nécessaire d'en installer plusieurs
autres (pour satisfaire ses dépendances). Par exemple, si vous voulez installer
le paquet clanbomber, vous devez aussi installer le paquet libclanlib2. Lorsque
vous supprimez clanbomber, vous n'avez probablement plus besoin du paquet
libclanlib2. aptitude tentera de le détecter et de supprimer automatiquement le
paquet libclanlib2.

Cela fonctionne ainsi : quand vous installez un paquet, aptitude va
automatiquement installer tout autre paquet dont il dépend. Ces paquets sont
marqués comme ayant été « automatiquement installés ». aptitude va les
surveiller et les supprimer quand plus aucun paquet manuellement installé n'en
dépendra[10]. Ils apparaîtront dans la prévisualisation comme des « paquets qui
vont être supprimés parce qu'ils ne sont plus utilisés ».

Comme pour tout procédé automatique, les choses peuvent potentiellement mal
tourner. Par exemple, même si un paquet a été installé automatiquement pour
commencer, il peut s'avérer utile par lui-même. Vous pouvez retirer la marque
« automatique » à tout moment en appuyant sur m et, si le paquet est déjà marqué
à supprimer, vous pouvez annuler la suppression et retirer la marque
« automatique » avec Paquet → Installer (+).


Résoudre les dépendances de paquets


Résolution des dépendances dans aptitude

Il y a deux algorithmes principaux de résolution des dépendances dans aptitude

Le premier algorithme, dénommé ici « résolution immédiate », est aussi utilisé
par des programmes tels qu'apt-get et synaptic. Il est invoqué dès qu'un paquet
est sélectionné pour l'installation de manière interactive, ainsi que juste
après qu'un ou plusieurs paquets sont marqués pour l'installation depuis la
ligne de commande. La résolution immédiate est rapide et résoudra la majorité
des problèmes de dépendances, mais il est parfois incapable de trouver une
solution.

Le deuxième algorithme, dénommé ici « résolution interactive », est invoquée
lorsque des paquets ont des dépendances cassées même après résolution immédiate
[11]. Il peut résoudre plus de dépendances, permet de valider la solution avant
de l'appliquer, et permet d'interagir avec le solveur, pour le guider vers une
meilleure solution.


Résolution immédiate des dépendances

Dès que vous choisissez d'installer ou de mettre à jour un paquet avec aptitude,
aptitude essaie immédiatement de résoudre toutes les dépendances qui ne sont pas
satisfaites. Pour chaque dépendance non satisfaite (qu'elle soit du type
« Depends », « Recommends » ou « Conflicts »), il effectue les étapes
suivantes :


  1. Si la dépendance est une recommandation (« Recommends »), aptitude essaie
     de deviner s'il s'agit d'une « nouvelle » recommandation, ou si elle était
     déjà « satisfaite précédemment ». aptitude considère une recommandation
     comme étant « nouvelle » si le paquet qui la déclare n'est pas actuellement
     installé, ou si la version installée ne recommande pas de paquet du même
     nom. Au contraire, une recommandation est considérée comme étant
     « satisfaite précédemment » si le paquet déclarant cette recommandation est
     installé, que la version actuelle recommande un paquet du même nom, et que
     cette recommandation est actuellement satisfaite.

     Par exemple, supposons que la version 1.0 de prog recommande la version 4.0
     de libcool1, mais que la version 2.0 de prog recommande la version 5.0 de
     libcool1, ainsi que le paquet apache. Si vous choisissez de mettre à jour
     prog de la version 1.0 vers la version 2.0, la recommandation d'apache sera
     considérée comme « nouvelle » car la version 1.0 de prog ne recommandait
     pas apache. D'autre part, la recommandation de libcool1 n'est pas
     « nouvelle », puisque la version 1.0 de prog recommandait libcool1, même
     s'il s'agissait d'une version différente. Si libcool1 est installée, cette
     recommandation sera considérée comme étant « satisfaite précédemment ».

     Si l'option de configuration Apt::Install-Recommends est vraie (« true »),
     aptitude essaiera toujours de satisfaire les « nouvelles » recommandations,
     ainsi que celles qui étaient « satisfaites précédemment ». Toutes les
     autres seront ignorées par la résolution immédiate. Si cette option est
     fausse (« false »), la résolution immédiate ignorera toutes les
     recommandations.

  2. Si la dépendance porte sur plusieurs paquets, combinés avec un OU, examiner
     chaque alternative dans l'ordre donné. Par exemple, si un paquet dépend de
     « exim | mail-transport-agent », aptitude traitera d'abord exim, puis mail-
     transport-agent.

  3. Pour chaque alternative, essayer de résoudre la dépendance. Si la
     dépendance est un conflit, supprimer l'alternative examinée si elle est
     installée (et pour un conflit sans indication de version, supprimer aussi
     tout paquet fournissant la cible du conflit). Sinon, installer la version
     candidate de l'alternative examinée si elle satisfait la dépendance. Si
     elle ne la satisfait pas, ou s'il n'y a pas de version candidate (par
     exemple, si l'alternative examinée est un paquet virtuel), et si la
     dépendance n'indique pas de version, essayer d'installer le paquet avec la
     plus haute priorité[12] dont la version candidate fournit la cible de
     l'alternative examinée.

     Par exemple, si la dépendance à résoudre est « Depends: exim | mail-
     transport-agent », aptitude essaiera d'abord d'installer le paquet exim. Si
     exim n'est pas disponible, aptitude essaiera alors d'installer le paquet
     avec la plus haute priorité dont la version candidate fournit exim. S'il
     n'y a pas de tel paquet, aptitude installera le paquet avec la plus haute
     priorité dont la version candidate fournit le paquet virtuel mail-
     transport-agent. Si maintenant, la dépendance examinée est « Depends: exim
     (>= 2.0.0) | mail-transport-agent », et que seule la version 1.0 d'exim est
     disponible, aptitude dans ce cas n'installera pas exim (car la version ne
     correspond pas), et n'essaiera pas non plus d'installer un paquet
     fournissant exim (car les paquets virtuels ne peuvent pas correspondre à
     une dépendance avec une restriction de version). Donc, aptitude installera
     le paquet avec la plus haute priorité dont la version candidate fournit
     mail-transport-agent.

  4. Si un paquet a été installé à l'étape précédente, résoudre ses dépendances
     avec cet algorithme, puis arrêter.


Bien que cette technique résolve très souvent la totalité des dépendances entre
paquets en jeu, elle peut échouer dans un certain nombre de cas communs.


* Des conflits peuvent être résolus en supprimant le paquet qui est la cible du
  conflit. Mais les autres paquets qui dépendent de ce paquet ont maintenant des
  dépendances non satisfaites. La résolution immédiate n'essaie pas de les
  satisfaire.

* Une dépendance peut ne pas être satisfaite à cause d'une restriction de
  version, ou de la limitation que seules les versions candidates sont
  envisagées. Par exemple, supposons que les versions 1.0 et 2.0 de fileutils
  sont disponibles, que la version candidate est la 1.0 et que le paquet octopus
  déclare une dépendance « Depends: fileutils (>= 2.0) ». La résolution
  immédiate est incapable de résoudre cette dépendance : elle ne considérera
  jamais la version 2.0 du paquet, puisqu'elle n'est pas candidate.


Le solveur interactif de dépendances peut résoudre ces situations, et bien
d'autres. Lorsqu'il y a des dépendances cassées restantes, ou que la résolution
immédiate est désactivée, le solveur interactif commence automatiquement à
chercher une solution. La section suivante décrit comment utiliser le solveur
interactif.


Résolution interactive des dépendances

Si un problème de dépendances survient qui ne peut être pris en charge par la
résolution immédiate, aptitude peut vous aider à le résoudre. Dès qu'un problème
arrive, une barre rouge apparaît en bas de l'écran avec un résumé des
suggestions d'aptitude pour le résoudre. Par exemple, dans la capture d'écran
suivante, aptitude indique qu'il est possible de résoudre le problème en gardant
deux paquets dans leur version actuelle.

 Actions  Annuler  Paquet  Solutions  Rechercher  Options  Vues  Aide
C-T : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
aptitude 0.4.1       #Cassé : 2   Libérera 2298ko d'espace disqu
i     nautilus-cd-burner                                   2.12.2-3   2.12.2-3
i A   nautilus-data                                        2.12.2-2   2.12.2-2
i     netspeed                                             0.13-1     0.13-1
i A   oaf                                                  0.6.10-6   0.6.10-6
i A   planner                                              0.13-4     0.13-4
i     pybliographer                                        1.2.8-1    1.2.8-1
i     rhythmbox                                            0.9.2-3    0.9.2-3
i     shermans-aquarium                                    3.0.1-1    3.0.1-1
idA   sound-juicer                                 -2171kB 2.12.3-3   2.12.3-3
GNOME 2 CD Ripper
sound-juicer sera enlevé.


Les paquets suivants dépendent de sound-juicer et seront cassés par sa
suppression :


  * gnome-desktop-environment  dépend de sound-juicer (>= 2.12.3)

[1(1)/...] Suggère :  2 à conserver
e : Examiner  ! : Appliquer  . : Suivant  , : Précédent

Comme il est indiqué en bas de l'écran, vous pouvez voir d'autres solutions en
appuyant sur . et ,, appliquer la solution courante en appuyant sur ! et
examiner la solution plus en détail en appuyant sur e. Quand vous examinez la
solution courante, un écran semblable au suivant apparaît.

 Actions  Annuler  Paquet  Solutions  Rechercher  Options  Vues  Aide
C-T : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
                Paquets                        Résolution des dépendances
  --\ Les paquets suivants seront conservés dans leur version actuelle :
    gstreamer0.8-cdparanoia                           [0.8.11-6 (unstable, now)]
    sound-juicer                                      [2.12.3-3 (unstable, now)]
















[1(1)/...] Suggère :  2 à conserver
e : Examiner  ! : Appliquer  . : Suivant  , : Précédent

Vous pouvez accéder aux informations sur le paquet affecté par une action en
appuyant simplement sur entrée lorsque le paquet est sélectionné. Pour obtenir
une explication détaillée sur les raisons d'un choix particulier, il suffit de
sélectionner l'élément dans la liste. Dans la moitié basse de l'écran,
s'afficheront la dépendance qui a été résolue par aptitude et tous les moyens
par lesquels la dépendance aurait pu être résolue.

 Actions  Annuler  Paquet  Solutions  Rechercher  Options  Vues  Aide
C-T : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
                Paquets                        Résolution des dépendances
  --\ Les paquets suivants seront conservés dans leur version actuelle :
    gstreamer0.8-cdparanoia                           [0.8.11-6 (unstable, now)]
    sound-juicer                                      [2.12.3-3 (unstable, now)]






cdparanoia plugin for GStreamer
gnome-media dépend de gstreamer0.8-cdparanoia
--\ Les actions suivantes permettront de résoudre cette dépendance :
  -> Réinstaller gnome-media à une version antérieure [2.12.0-3 (unstable, now)
  -> Supprimer gnome-media [2.12.0-3 (unstable, now)]
  -> Abandonner la suppression de gstreamer0.8-cdparanoia
  -> Réinstaller gstreamer0.8-cdparanoia à une version antérieure [0.8.11-6 (uns



[1(1)/...] Suggère :  2 à conserver
e : Examiner  ! : Appliquer  . : Suivant  , : Précédent

Vous pouvez guider la résolution de dépendances vers la solution de votre choix
en approuvant ou rejetant les actions élémentaires d'une solution. Si vous
approuvez une action, le solveur choisira, autant que possible, cette action en
ignorant les alternatives (s'il y a plusieurs actions approuvées, elles seront
toutes choisies). À l'inverse, si vous rejetez une action, le solveur ne
choisira jamais cette action.

Pour rejeter une solution, sélectionnez-la et appuyez sur r ; appuyez à nouveau
sur r pour annuler ce rejet. De même, pour approuver une action, appuyez sur a.
Dans l'écran des solutions, vous pouvez annuler vos actions à tout moment en
utilisant Annuler → Annuler (Contrôle+u). Si vous annulez un rejet ou une
approbation, toute solution qui aurait été ignorée sera à nouveau considérée dès
la prochaine génération d'une solution.


IMG.alt.suffix Note
  = \[Note]]
               Par défaut, le solveur rejette toute action qui changerait l'état de paquets
               figés, ou qui installerait une version interdite de paquets. Vous pouvez
               contourner ces rejets, et donc permettre le figeage ou l'interdiction d'être
               automatiquement contournée, de la même manière que vous contourneriez un autre
               rejet. Positionner l'option de configuration Aptitude::ProblemResolver::Allow-
               Break-Holds à la valeur vrai désactivera ce comportement, ce qui signifie que le
               solveur cassera toujours les figeages (avec cependant une pénalité, voir
               Aptitude::ProblemResolver::BreakHoldScore).


Les actions rejetées sont mises en rouge et marquées avec un « R », et celles
approuvées sont mises en vert et marquées avec un « A ». Comme vous pouvez le
voir dans la capture suivante où l'action de « conserver gstreamer0.8-cdparanoia
dans sa version actuelle » a été rejetée et l'action de « conserver sound-juicer
dans sa version actuelle » approuvée.

Actions  Annuler  Paquet  Solutions  Rechercher  Options  Vues  Aide
C-T : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
                Paquets                        Résolution des dépendances
  --\ Les paquets suivants seront conservés dans leur version actuelle :
R   gstreamer0.8-cdparanoia                           [0.8.11-6 (unstable, now)]
A   sound-juicer                                      [2.12.3-3 (unstable, now)]
















[1(1)/...] Suggère :  2 à conserver
e : Examiner  ! : Appliquer  . : Suivant  , : Précédent

Les rejets et les approbations n'affectent que les solutions nouvellement
générées. Il est possible de savoir si une nouvelle solution va être générée en
regardant l'indicateur en bas à gauche de l'écran. S'il y a un nombre entre
parenthèses, celui-ci indique le nombre de solutions générées. Et donc, si le
nombre hors des parenthèses et celui à l'intérieur sont égaux (comme ci-dessus),
appuyer sur . va générer une nouvelle solution. S'il n'y a pas de nombre entre
parenthèses (l'indicateur affiche, par exemple, [1/5]), alors il n'y a pas
d'autre solution à générer. À tout moment, vous pouvez sélectionner la dernière
solution générée en appuyant sur > et la première avec <.


IMG.alt.suffix Important
     = \
 [Important]]  L'état du système de résolution des problèmes est mis à zéro quand vous
               modifiez l'état d'un paquet. Si vous marquez un paquet pour installation, pour
               mise à jour, pour suppression, etc., aptitude oubliera tous vos rejets et
               approbations, ainsi que toutes les solutions générées jusque là.


En plus de la sélection des actions dans la liste en haut de l'écran, vous
pouvez sélectionner ces actions dans la liste du bas. Pour avoir accès à cette
seconde liste, vous pouvez soit cliquer dessus avec votre souris, soit appuyer
sur Tab. Enfin, en appuyant sur o, vous afficherez les décisions triées. Cela
consiste en une liste des dépendances qui ont été résolues et des actions qui
ont amené ce résultat, comme le montre la capture suivante .

 Actions  Annuler  Paquet  Solutions  Rechercher    Aide
C-T : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
                Paquets                        Résolution des dépendances
  --\ gnome-desktop-environment dépend de sound-juicer (>= 2.12.3)
    -> Abandonner la suppression de sound-juicer
  --\ gnome-media dépend de gstreamer0.8-cdparanoia
    -> Abandonner la suppression de gstreamer0.8-cdparanoia





GNOME 2 CD Ripper
gnome-desktop-environment dépend de sound-juicer (>= 2.12.3)
--\ Les actions suivantes permettront de résoudre cette dépendance :
  -> Réinstaller gnome-desktop-environment à une version antérieure [1:2.12.2.2
  -> Supprimer gnome-desktop-environment [1:2.12.2.2 (unstable, now)]
  -> Abandonner la suppression de sound-juicer




[1(1)/...] Suggère :  2 à conserver
e : Examiner  ! : Appliquer  . : Suivant  , : Précédent

Appuyer à nouveau sur o quitte ce mode d'affichage.


Coûts dans la résolution interactive de dépendances


Coûts et composantes de coût

Le coût d'une solution produite par la résolution interactive est une valeur
qu'aptitude utilise pour mesurer la « mauvaise qualité » de la solution. Les
solutions les « meilleures » sont toujours affichées en premier. Le coût d'une
solution est défini dans l'option de configuration Aptitude::ProblemResolver::
SolutionCost.

Quelques coûts typiques sont donnés dans Exemple 2.1, « Exemples de coût pour le
solveur ».

Exemple 2.1. Exemples de coût pour le solveur

Le coût par défaut, pour lequel les solutions sont classées suivant leur coût de
sécurité, puis par leur priorité d'épinglage apt :

safety, priority

Retirer le moins de paquets possible, puis annuler le moins d'actions possible :

removals, canceled-actions

Classer les solutions en fonction d'un score donné par le nombre de paquets
qu'elles suppriment (« removals ») plus deux fois le nombre d'actions qu'elles
annulent (« cancelled-actions »).

removals + 2 * canceled-actions



Comme dans les exemples précédent, un coût n'est pas nécessairement un simple
nombre. En fait, un coût consiste en une ou plusieurs composantes de coût,
chacune étant un nombre associé à une solution. Lors du classement des
solutions, le solveur examine les composantes de coût dans l'ordre, en passant
aux composantes suivantes seulement si les précédentes sont égales. Par exemple,
dans le coût « removals, canceled-actions », les solutions avec le moins de
suppressions apparaissent toujours avant les autres, indépendamment du nombre
d'actions qu'elles annuleraient. Cependant, des solutions avec le même nombre de
suppressions sont classées dans l'ordre croissant du nombre d'actions annulées.

Les composantes de coût sont de deux types : les élémentaires et les composées.

Les composantes élémentaires nomment simplement une propriété de la solution,
telle que le nombre de mises à jour (« upgrades ») ou le nombre de suppressions
(« removals »). La liste des composantes élémentaires intégrées dans aptitude
peut être trouvée dans Tableau 2.1, « Composantes de coût élémentaires ». Vous
pouvez aussi créer vos propres composantes de coût en utilisant les indicateurs
add-to-cost-component et raise-cost-component. Consultez la section intitulée
« Configuration des indicateurs du solveur » pour les détails.

Chaque composante de coût élémentaire est soit un compteur, soit un niveau. Les
compteurs comptent combien de conditions d'un certain type sont satisfaites par
les actions d'une solution (telles que l'installation ou la suppression de
paquets), alors que les niveaux associent un nombre à chaque action et renvoient
le plus grand de ces nombres attachés à chaque action de la solution.

Tableau 2.1. Composantes de coût élémentaires

 ____________________________________________________________________________________________________________
|Nom      |Type    |Description                                                                             |
|_________|________|_________________________________________________________________________________________|
|broken-  |Compteur|Compte le nombre de figeages que la solution casse, si le solveur est autorisé à le fai|e
|holds    |        |(Aptitude::ProblemResolver::Allow-Break-Holds).                                          |
|_________|________|_________________________________________________________________________________________|
|canceled-|Compteur|Compte le nombre d'actions en attente que la solution annule (en gardant des paquets dans|
|actions  |        |leur version actuelle).                                                                  |
|_________|________|_________________________________________________________________________________________|
|installs |Compteur|Compte le nombre de paquets que la solution installe.                                    |
|_________|________|_________________________________________________________________________________________|
|non-     |        |Compte le nombre de versions que la solution installe ou met à jour depuis des sources  |
|default- |Compteur|qui ne sont pas celles par défaut.                                                      |
|versions |        |                                                                                         |
|_________|________|_________________________________________________________________________________________|
|         |        |Une valeur qui augmente lorsque la priorité d'épinglage apt d'une version diminue.     |
|priority |Niveau  |Précisément, elle est calculée en prenant l'opposée de la priorité d'épinglage (par|
|         |        |exemple, si la priorité d'épinglage vaut 500, cette composante vaut -500).             |
|_________|________|_________________________________________________________________________________________|
|removals |Compteur|Compte le nombre de paquets que la solution supprime.                                    |
|_________|________|_________________________________________________________________________________________|
|removals-|Compteur|Compte le nombre de paquets installés manuellement que la solution supprime.            |
|of-manual|        |                                                                                         |
|_________|________|_________________________________________________________________________________________|
|safety   |Niveau  |Une valeur heuristique qui augmente lorsqu'une action devient moins « sûre » ; cons|ltez
|         |        |la section intitulée « Coût de sécurité » pour plus de détails.                 |
|_________|________|_________________________________________________________________________________________|
|upgrades |Compteur|Compte le nombre de paquets que la solution met à jour.                                 |
|_________|________|_________________________________________________________________________________________|



Les composantes composées sont construites en combinant les valeurs des
composantes élémentaires. Par exemple, removals + canceled-actions fait la somme
des composantes élémentaires removal et canceled-actions, pour aboutir à une
composante qui compte le nombre de suppressions et d'actions annulées. Les
composantes composées combinent les compteurs en les ajoutant et les niveaux en
prenant leur maximum, comme dans Figure 2.11, « Syntaxe des composantes de coût
composées ».


IMG.alt.suffix Note
  = \[Note]]
               Ajouter deux niveaux, prendre le maximum de deux compteurs ou combiner des niveaux
               et des compteurs de quelque manière que ce soit est considéré comme une erreur.
               Par exemple, les coûts removals + safety et max(u(upgrades, installs) seront
               considérés comme erronés et ignorés par le solveur.[13]


Figure 2.11. Syntaxe des composantes de coût composées

Ajouter deux (ou plus) composantes élémentaires :

                [facteur1 *]coût1 + [facteur2 *]coût2 + ...

Prendre le maximum de deux (ou plus) composantes de coûts élémentaires :

                max([facteur1] *coût1, [facteur2 *]coût2, ...)



Remarquez que chaque composante élémentaire peut être multipliée par un facteur
avant d'être combinée avec d'autres composantes. Cela peut être utilisé pour
contrôler les compromis que le solveur fait entre les coûts. Par exemple, un
coût de 2*removals + 3*upgrades signifie que trois suppressions sont exactement
aussi mauvaises que deux mises à jour. Une solution contenant quatre
suppressions et une mise à jour sera considérée comme étant équivalente à une
contenant une suppression et trois mises à jour, puisque qu'elles ont toutes les
deux un coût égal à 11.


Coût de sécurité

Figure 2.12. Niveaux de coût de sécurité

IMG.alt.suffix = \Niveaux de coût de sécurité]



La composante de coût safety (« sécurité ») est une estimation heuristique du
fait qu'une solution est plus ou moins « sûre ». Les coûts de sécurité peuvent
être pensés comme une façon de diviser les solutions en différents « niveaux »
étiquetés par des nombres, les niveaux les « moins sûrs » ayant les nombres les
plus grands. Figure 2.12, « Niveaux de coût de sécurité » montre comment cela
fonctionne avec les réglages par défaut d'aptitude.


IMG.alt.suffix Astuce
 = \[Astuce]]
               Les niveaux de coût de sécurité sont juste une façon de contrôler l'ordre dans lequel
               les solutions aux problèmes de dépendances sont proposées. Consultez la section
               intitulée « Coûts dans la résolution interactive de dépendances » pour une description
               complète sur la façon dont aptitude classe les solutions.


Par défaut, aptitude initialise le solveur avec un ensemble « raisonnable » de
niveaux de coût de sécurité. Ceux-ci sont :

Tableau 2.2. Niveaux de coût de sécurité par défaut

 __________________________________________________________________________________________________________________
|Niveau de coût|Description                                                                    |Option de        |
|               |                                                                                |configuration    |
|_______________|________________________________________________________________________________|_________________|
|               |                                                                                |Aptitude::       |
|               |Solutions qui contiennent uniquement des actions « sûres » (installation de|ProblemResolver::|
|10 000        |version candidate d'un paquet ou conservation d'un paquet dans sa version       |Safe-Level,      |
|               |actuelle) et des suppressions de paquets.                                       |Aptitude::       |
|               |                                                                                |ProblemResolver::|
|               |                                                                                |Remove-Level     |
|_______________|________________________________________________________________________________|_________________|
|               |                                                                                |Aptitude::       |
|20 000        |Les solutions qui annulent toutes les actions de l'utilisateur.                 |ProblemResolver::|
|               |                                                                                |Keep-All-Level   |
|_______________|________________________________________________________________________________|_________________|
|               |Solutions qui cassent les figeages créés par l'utilisateur ou installent des  |Aptitude::       |
|40 000        |versions interdites.                                                            |ProblemResolver::|
|               |                                                                                |Break-Hold-Level |
|_______________|________________________________________________________________________________|_________________|
|               |Solutions qui installent des paquets depuis des sources autres que celles par   |Aptitude::       |
|50 000        |défaut (comme depuis « experimental » par exemple).                        |ProblemResolver::|
|               |                                                                                |Non-Default-Level|
|_______________|________________________________________________________________________________|_________________|
|               |                                                                                |Aptitude::       |
|60 000        |Solutions qui suppriment des paquets essentiels.                                |ProblemResolver::|
|               |                                                                                |Remove-Essential-|
|               |                                                                                |Level            |
|_______________|________________________________________________________________________________|_________________|



Si une solution peut être classée dans plusieurs niveaux, elle sera placée dans
le plus élevé, c'est-à-dire celui qui sera affiché en dernier. Par exemple, une
solution qui met à jour un paquet à sa version candidate, et qui casse un
figeage sur un autre paquet sera placée au niveau 40 000. Vous pouvez ajuster
les niveaux des versions individuelles en utilisant des indications du solveur.
Consultez la section intitulée « Configuration des indicateurs du solveur » pour
les détails. Les niveaux par défaut sont illustrés dans Figure 2.12, « Niveaux
de coût de sécurité ».


Configuration de la résolution de dépendances interactive


Configuration des indicateurs du solveur

Pour améliorer la qualité des solutions aux problèmes de dépendances que vous
recevez, vous pouvez fournir des indicateurs au solveur interactif. Ces
indicateurs peuvent modifier les priorités du solveur, en biaisant plus
fortement en faveur d'une version ou d'un paquet. Ils peuvent aussi être
utilisés pour fournir à l'avance des rejets et des approbations, comme si vous
étiez entré dans le solveur et aviez rejeté ou accepté manuellement différentes
versions.

Les indicateurs sont stockés dans le fichier de configuration d'apt, /etc/apt/
apt.conf, dans le groupe de configuration « Aptitude::ProblemResolver::Hints »
(consultez la section intitulée « Référence du fichier de configuration » pour
les détails sur le fichier de configuration).

Chaque indicateur du solveur consiste en une action, une cible et une version
optionnelle. Un indicateur est écrit comme ceci : "action cible [version]". Pour
appliquer un indicateur du solveur, aptitude localise un ou plusieurs paquets
utilisant la valeur de la cible, choisit une ou plusieurs versions de ces
paquets en utilisant la valeur de version, puis effectue l'action indiquée.

Le champ action de l'indicateur du solveur peut prendre les valeurs suivantes :


  1. « approve » : approuver la version, comme si la commande Solutions →
     Marquer comme retenu (a) avait été utilisée sur elle.

  2. « reject » : rejeter la version, comme si la commande Solutions → Marquer
     comme rejeté (r) avait été utilisée sur elle.

  3.  « discard » : ignorer toutes les solutions contenant cette version. Cette
     action diffère de « reject » par le fait qu'elle n'est pas visible par
     l'utilisateur et ne peut pas être modifiée de manière interactive.

  4. « increase-safety-cost-to nombre » : augmenter le coût de sécurité de
     toutes les solutions contenant la version à la valeur nombre. Si le coût de
     sécurité est déjà supérieur à nombre, cet indicateur n'a aucun effet. Le
     coût de sécurité peut être utilisé (et est utilisé par défaut) pour
     contrôler l'ordre d'apparition des solutions. Consultez la section
     intitulée « Coûts et composantes de coût » et la section intitulée « Coût
     de sécurité » pour les détails.

     Plusieurs niveaux de coûts particuliers peuvent être désignés par leur
     nom :


       a. conflict, discard : au lieu de changer le coût de sécurité, ignorer
          les solutions contenant les versions comme si l'indicateur « discard »
          avait été utilisé.

       b. maximum : le coût de sécurité le plus élevé.

       c. minimum : le coût de sécurité le plus bas. Toutes les recherches
          commencent avec ce coût, donc « augmenter » une version à cette valeur
          n'a aucun effet. Cependant, cette valeur peut aussi être utilisée lors
          de l'ajustement des niveaux de coût prédéfinis : par exemple, régler
          Aptitude::ProblemResolver::Remove-Level à la valeur « minimum »
          impliquera que la suppression de paquets n'aura aucun effet sur le
          coût de sécurité d'une solution.



     IMG.alt.suffix Note
       = \[Note]]
                    L'indicateur increase-safety-cost-to est appliqué en plus de n'importe quel
                    autre coût de sécurité provenant de l'action sélectionnée. Par exemple, un
                    indicateur qui augmente le coût de sécurité d'« install hal from
                    experimental » à 15 000 n'aura aucun effet, car l'action a déjà un coût de
                    50 000 (en supposant que cette version de hal n'est pas la version candidate
                    par défaut).


  5. « nombre » : ajouter le nombre donné au score de la version, ce qui biaise
     le solveur en sa faveur ou (si le nombre est négatif) en sa défaveur. Par
     exemple, un indicateur 200 emacs ajoute 200 au score d'emacs, alors que
     l'indicateur -10 emacs soustrait 10 de son score.


Si le champ cible de l'indicateur du solveur contient un point d'interrogation
(« ? ») ou un tilde (« ~ »), il est interprété comme étant un motif de recherche
et toutes les versions de paquets correspondant à ce motif sont prises en
compte. Sinon, il est interprété comme le nom d'un paquet à sélectionner. Donc
la cible « g++ » sélectionnera uniquement le paquet g++, mais la cible
« ?section(non-free) » sélectionnera tous les paquets de la section non-free.
Consultez la section intitulée « Motifs de recherche » pour plus d'informations
sur les motifs de recherche.

Si le champ version est absent, toutes les versions du paquet sont concernées
par l'indicateur. S'il est présent, il peut avoir l'une des formes suivantes :


  1. « /archive » : l'indicateur n'affecte que les versions disponibles dans
     l'archive donnée.

  2. « <version » : l'indicateur n'affecte que les versions dont le numéro est
     strictement inférieur à version.

  3. « <=version » : l'indicateur n'affecte que les versions dont le numéro est
     inférieur ou égal à version.

  4. « =version » : l'indicateur n'affecte que les versions dont le numéro est
     égal à version.

  5. « <>version » : l'indicateur n'affecte que les versions dont le numéro est
     différent de version.

  6. « >=version » : l'indicateur n'affecte que les versions dont le numéro est
     supérieur ou égal à version.

  7. « >version » : l'indicateur n'affecte que les versions dont le numéro est
     strictement supérieur à version.

  8. « :UNINST » : au lieu d'affecter l'une des versions de cible, l'indicateur
     affecte la décision de supprimer cible. Par exemple « reject aptitude :
     UNINST » empêchera toute tentative du solveur de supprimer aptitude.

  9. « version » : l'indicateur n'affecte que les versions dont le numéro de
     version est version.



Motifs de recherche

Quand vous recherchez un paquet ou restreignez l'affichage dans aptitude, la
chaîne que vous entrez est appelée « motif de recherche ». Bien que
l'utilisation première des motifs de recherche soit de chercher le nom exact des
paquets, aptitude permet de créer des recherches bien plus élaborées. En plus de
l'interface visuelle, des opérations en ligne de commandes peuvent aussi
utiliser des motifs de recherche. Consultez Référence de l'interface en ligne de
commande pour plus de détails.

Un motif de recherche consiste en une ou plusieurs conditions (parfois appelées
« termes »). Un paquet correspond à un motif s'il correspond à tous ses mots.
Les termes commencent généralement par un point d'interrogation (« ? ») suivi
par le mot correspondant au type de recherche à faire : par exemple, le terme
?name correspondra à une recherche sur les noms de paquets, alors que le terme
?version correspondra à une recherche sur les versions de paquets. Tout
paramètre additionnel pour un terme de recherche est placé entre parenthèses
(consultez la documentation de chaque terme pour plus de détails sur la
signification de ses paramètres).


IMG.alt.suffix Note
  = \[Note]]
               Du texte ne commençant pas par un point d'interrogation correspond aussi à un
               motif de recherche : aptitude traitera alors chaque mot (ou chaîne de
               caractères entre guillemets) comme un argument pour le motif ?name qui cherche
               un paquet dont le nom correspond au texte, interprété comme une expression
               rationnelle.



IMG.alt.suffix = Avertissement
       \
[Avertissement]] Le comportement d'aptitude vis-à-vis des motifs de recherche ne commençant pas par
                 un point d'interrogation (ou par un « ~ ») est fourni par commodité pour un usage
                 interactif, et changera dans les versions futures. Les scripts qui appellent
                 aptitude devraient explicitement nommer la stratégie de recherche qu'ils veulent
                 utiliser. Ils doivent donc utiliser le motif de recherche « ?name(coq) » plutôt que
                 « coq ».



Recherche de chaînes de caractères

De nombreux termes de recherche peuvent prendre une chaîne de caractères comme
paramètre et la faire correspondre avec un ou plusieurs champs d'un paquet. Les
chaînes peuvent être ou non données entre guillemets (« " »), de sorte que
« ?name(scorch) » et « ?name("scorch") » effectueront la même recherche. Si vous
entrez une chaîne de recherche avec des guillemets, vous pouvez inclure le
caractère guillemet dans la chaîne en le faisant précéder par une barre oblique
inverse (« \ ») : par exemple, « ?description("\"easy\"") » sélectionnera tous
les paquets dont la description contient la chaîne « "easy" ».

Si vous entrez une chaîne « nue », c'est-à-dire sans guillemets, alors aptitude
considérera que la chaîne sera terminée lorsqu'il rencontrera une parenthèse
fermante ou la virgule précédant le second argument du terme de recherche[14].
Pour retirer la signification particulière à ces caractères, faites-les précéder
d'un tilde (« ~ »). Par exemple « ?description(etc)) » est une erreur de
syntaxe, car la première parenthèse fermante « ) » termine le terme ?description
et la deuxième ne correspond à aucune parenthèse ouvrante. En revanche,
« ?description(etc~)) » sélectionne tous les paquets dont la description
contient le texte « etc) ». Il y a des considérations supplémentaires si vous
utilisez la forme courte d'un terme. Consultez la section intitulée « Raccourcis
pour les termes de recherche » pour les détails.

La plupart des recherches de texte (pour les noms de paquets, les
descriptions, etc.) sont des expressions rationnelles insensibles à la casse.
Une expression rationnelle sera en correspondance avec un champ dès que
n'importe quelle portion du texte correspond à l'expression rationnelle. Par
exemple, « ogg[0-9] » sera en correspondance avec « libogg5 », « ogg123 » et
« theogg4u ». Certains caractères ont une signification particulière à
l'intérieur d'une expression rationnelle [15], donc si vous voulez les utiliser
dans des recherches, vous devez les protéger avec une barre oblique inverse :
par exemple, pour trouver « g++ », vous devrez utiliser le motif « g\+\+ ».

Les caractères « ! » et « | » ont une signification particulière à l'intérieur
des motifs de recherche. Afin d'inclure ces caractères dans une chaîne sans
guillemets, vous pouvez les faire précéder par un tilde (« ~ »). Par exemple,
pour faire correspondre les paquets dont la description contient « grand » ou
« oblique », utilisez le motif « ?description(grand~|oblique) ». Vous trouverez
cependant plus pratique peut-être d'utiliser simplement une chaîne de caractères
entre guillemets : « ?description("grand|oblique") ».


Raccourcis pour les termes de recherche

Certains termes de recherche ont une forme « courte », qui consiste en un tilde
(« ~ ») suivi par un unique caractère qui identifie le terme, puis
éventuellement par les arguments du terme, si besoin. Par exemple, la forme
courte de ?name(aptitude) est ~n aptitude.

En écrivant un terme sous sa forme courte, les caractères tilde et les
« espaces » (c'est-à-dire le caractère espace, les tabulations, etc.) séparent
les termes et en commencent de nouveaux. Par exemple, « ~mDaniel Burrows » fera
correspondre tous les paquets dont le nom du responsable contient « Daniel » et
dont le nom contient « Burrows », alors que « ~i~napt » fera correspondre tous
les paquets installés dont le nom contient apt. Pour inclure des espaces (ou
tout autre caractère spécial) dans un motif, vous pouvez soit le faire précéder
d'un tilde (comme dans Daniel~ Burrows), soit l'entourer de guillemets (comme
dans "Debian Project" ou même Debian" "Project). Dans une chaîne entre
guillemets, la barre oblique inverse (« \ ») peut être utilisée pour
contrecarrer la signification spéciale du guillemet : par exemple ~d"\"email"
correspondra à tout paquet dont la description contient un guillemet
immédiatement suivi de email[16].


IMG.alt.suffix Note
  = \[Note]]
               Un point d'interrogation (« ? ») ne termine pas la forme courte d'un terme, même
               s'il est suivi par le nom d'un terme de recherche. Par exemple, « ~napt?priority
               (required) » sélectionnera tous les paquets dont le nom correspond à l'expression
               rationnelle « apt?priority(required) ». Pour combiner une forme courte d'un terme
               avec un terme de recherche précisé par son nom, ajoutez une ou plusieurs espaces
               entre les deux termes, comme dans « ~napt ?priority(required) », ou bien placez le
               texte suivant la forme courte (s'il y en a un) entre guillemets, comme dans
               « ~n"apt"?priority(required) ».


Le Tableau 2.3, « Guide rapide des termes de recherche » donne la liste de la
forme courte de chacun des termes de recherche.


Recherches et versions

Par défaut, un motif sélectionne un paquet dès qu'une version du paquet
correspond au motif. Cependant, certains motifs vont contraindre les sous-motifs
à ne chercher des correspondances que dans certaines versions d'un paquet. Par
exemple, le terme de recherche ?depends(motif) ne sélectionnera que les paquets
qui dépendent d'un paquet correspondant au motif. Cependant, le motif ne sera
testé que dans les versions du paquet qui satisfont effectivement une
dépendance. Cela signifie que si foo dépend de bar (>= 3.0) et que les versions
2.0, 3.0 et 4.0 de bar sont disponibles, alors avec le motif de recherche
?depends(?version(2\.0)), seules les versions 3.0 et 4.0 seront testées avec
?version(2\.0), et donc foo ne sera pas sélectionné par cette recherche.

Cela dépend des versions qui sont vérifiées car, comme dans l'exemple précédent,
certains motifs vont correspondre à une version, mais pas à une autre. Par
exemple, le motif ?installed ne correspondra qu'à la version du paquet qui est
actuellement installée (s'il y en a effectivement une). De même, le motif
?maintainer(responsable) ne correspondra qu'aux versions maintenues par ce
responsable. Normalement, toutes les versions d'un même paquet ont le même
responsable, mais ce n'est pas toujours le cas. En fait, chaque motif de
recherche qui examine les champs d'un paquet (autres que son nom, bien sûr) vont
se comporter de cette façon, car les champs d'un paquet peuvent changer d'une
version à l'autre.

Pour tester un motif contre toutes les versions d'un paquet, même si ce motif
serait normalement testé seulement dans certaines versions, utilisez le terme
?widen. Par exemple, ?depends(?widen(?version(2\.0))) correspondra à tout paquet
A qui dépend d'un paquet B, dont une version correspond à l'expression 2.0,
indépendamment du fait que ce soit celle qui satisfait la dépendance de A ou
non. D'autre part, le terme ?narrow restreint les versions pour lesquelles les
sous-motifs sont testés : ?narrow(?installed, ?depends(?version(ubuntu)))
sélectionnera les paquets dont la version installée a une dépendance qui peut
être satisfaite par un paquet dont le numéro de version contient la chaîne
« ubuntu ».


IMG.alt.suffix Note
  = \[Note]]
               Il y a une distinction subtile mais importante entre tester un motif dans un
               paquet, et le tester dans toutes les versions de ce paquet. Lorsqu'un motif est
               testé dans un paquet, chacun de ses termes est testé dans le paquet, et il y
               aura correspondance dès que pour chaque terme il y aura une version du paquet
               qui correspondra. En revanche, pour un motif testé dans toutes les versions d'un
               paquet, il y aura correspondance si tous les termes correspondent avec la même
               version du paquet.

               Supposons par exemple que la version 3.0-1 du paquet aardvark est installée,
               mais que la version 4.0-1 est disponible. Alors le motif de recherche ?version
               (4\.0-1)?installed sélectionnera aardvark, car ?version(4\.0-1) fait
               correspondre la version 4.0-1 d'aardvark, alors qu'?installed fait correspondre
               3.0-1. D'autre part, ce motif ne donne pas de correspondance s'il est testé sur
               toutes les versions d'aardvark, car il n'y a pas de version installée qui ait
               aussi un numéro de version 4.0-1.



Cibles de recherche explicites

Quelques recherches particulièrement complexes avec aptitude peuvent être
exprimées en utilisant les cibles explicites. Dans une expression de recherche
normale, il n'y a pas de façon de se référer au paquet ou à la version qui est
en train d'être testé. Par exemple, supposons que l'on cherche tous les paquets
P qui dépendent d'un second paquet Q, tel que Q recommande P. Clairement,
l'expression de recherche doit commencer par ?depends(...). Mais le terme à
mettre entre les parenthèses doit en quelque sorte sélectionner les paquets qui
sont identiques à ceux sélectionnés par ?depends. Dans la description de
l'objectif ci-dessus, cela a été fait en donnant explicitement des noms P et Q
aux paquets. Les termes avec des cibles explicites font exactement la même
chose.[17]

Une cible explicite est introduite par le terme ?for :

Figure 2.13. Syntaxe pour le terme ?for

?for variable: motif



Cela se comporte exactement comme motif, mais la variable peut être utilisée à
l'intérieur du motif pour faire référence au paquet ou à la version que ce motif
est en train de tester. Vous pouvez utiliser la variable de deux manières :


  1. Le terme ?= sélectionnera les paquets ou les versions indiquées par la
     variable donnée. Précisément, si le terme ?for est limité à une version
     précise, alors ?= sélectionnera soit cette version (si ?= est limité) soit
     le paquet entier. Sinon, il sélectionnera toutes les versions du paquet.

     Consultez l'Exemple 2.2, «  Utilisation du terme ?=.  » pour un exemple
     d'utilisation d'?=

  2. Le terme ?bind(variable,motif) fera correspondre tout paquet ou version si
     la valeur de la variable est en correspondance avec le motif.

     Pour les termes de la forme ?, une forme courte est disponible.
     L'expression ?bind(variable, ?terme[(arguments)]) peut être remplacée par
     ?variable:terme[(arguments)]).

     Consultez l'Exemple 2.3, « Utilisation du terme ?bind. » pour un exemple
     d'utilisation de ?bind.



Référence pour les termes de recherche

Le Tableau 2.3, « Guide rapide des termes de recherche » fournit un résumé
rapide de tous les termes de recherches disponibles avec aptitude. Une
description complète de chaque terme peut être trouvée plus bas.

Tableau 2.3. Guide rapide des termes de recherche

 _____________________________________________________________________________________________________________________________________
|Forme longue                   |Forme courte       |Description                                                                     |
|_______________________________|___________________|_________________________________________________________________________________|
|?=variable                     |                  |Sélectionner le paquet attaché à la variable. Consultez la section intitulée |
|                               |                   |« Cibles de recherche explicites ».                                          |
|_______________________________|___________________|_________________________________________________________________________________|
|?not(motif)                    |!motif             |Sélectionner les paquets qui ne correspondent pas au motif.                     |
|_______________________________|___________________|_________________________________________________________________________________|
|?action(action)                |~aaction           |Sélectionner les paquets marqués pour subir l'action (par exemple « install | ou
|                               |                   |« upgrade »).                                                                |
|_______________________________|___________________|_________________________________________________________________________________|
|?all-versions(motif)           |                  |Sélectionner les paquets dont toutes les versions correspondent au motif.       |
|_______________________________|___________________|_________________________________________________________________________________|
|?and(motif1, motif2)           |motif1 motif2      |Sélectionner tous les paquets qui correspondent à la fois à motif1 et à motif|.
|_______________________________|___________________|_________________________________________________________________________________|
|?any-version(motif)            |                  |Sélectionnez les paquets pour lesquels au moins une version correspond au motif.|
|_______________________________|___________________|_________________________________________________________________________________|
|?architecture(architecture)    |~rarchitecture     |Sélectionner les paquets pour l'architecture donnée (telle que « amd64 » ou|
|                               |                   |« all »). Valeurs particulières : native et foreign.                       |
|_______________________________|___________________|_________________________________________________________________________________|
|?archive(archive)              |~Aarchive          |Sélectionner les paquets d'une archive donnée (telle que « unstable »).    |
|_______________________________|___________________|_________________________________________________________________________________|
|?automatic                     |~M                 |Sélectionner les paquets qui ont été automatiquement installés.              |
|_______________________________|___________________|_________________________________________________________________________________|
|?bind(variable, motif)         |?variable:term-name|Sélectionner tout si la variable correspond au motif. Consultez la section      |
|                               |[(args)]           |intitulée « Cibles de recherche explicites ».                               |
|_______________________________|___________________|_________________________________________________________________________________|
|?broken                        |~b                 |Sélectionner les paquets qui ont des dépendances cassées.                     |
|_______________________________|___________________|_________________________________________________________________________________|
|?broken-typeDép               |~BtypeDép         |Sélectionner les paquets qui ont une dépendance cassée du type typeDép.      |
|_______________________________|___________________|_________________________________________________________________________________|
|?broken-typeDép(motif)        |~DB[typeDép:]motif|Sélectionner les paquets qui ont une dépendance cassée du type typeDép qui   |
|                               |                   |correspond au motif.                                                             |
|_______________________________|___________________|_________________________________________________________________________________|
|?broken-reverse-typeDép(motif)|~RBtypeDép:motif  |Sélectionner les paquets qui correspondent au motif et ont une dépendance cass|e
|                               |                   |de type typeDép.                                                                |
|_______________________________|___________________|_________________________________________________________________________________|
|?conflicts(pattern)            |~Cmotif            |Sélectionner les paquets qui sont en conflit avec un paquet correspondant au    |
|                               |                   |motif.                                                                           |
|_______________________________|___________________|_________________________________________________________________________________|
|?config-files                  |~c                 |Sélectionner les paquets qui ont été supprimés, mais pas purgés.            |
|_______________________________|___________________|_________________________________________________________________________________|
|?typeDép(motif)               |~D[typeDép:]motif |Sélectionner les paquets qui déclarent une dépendance de type typeDép sur un |
|                               |                   |paquet qui correspond au motif.                                                  |
|_______________________________|___________________|_________________________________________________________________________________|
|?description(description)      |~ddescription      |Sélectionner les paquets dont la description correspond à description.         |
|_______________________________|___________________|_________________________________________________________________________________|
|?essential                     |~E                 |Sélectionner les paquets essentiels, c'est-à-dire ceux dont le fichier de      |
|                               |                   |contrôle contient le champ Essential: yes.                                      |
|_______________________________|___________________|_________________________________________________________________________________|
|?exact-name(nom)               |                  |Sélectionner les paquets nommés nom.                                           |
|_______________________________|___________________|_________________________________________________________________________________|
|?false                         |~F                 |Ne sélectionner aucun paquet.                                                   |
|_______________________________|___________________|_________________________________________________________________________________|
|                               |                   |Sélectionner les paquets qui correspondent au motif en attachant la variable au |
|?for variable: motif           |                  |paquet en correspondance. Consultez la section intitulée « Cibles de recherche|
|                               |                   |explicites ».                                                                  |
|_______________________________|___________________|_________________________________________________________________________________|
|?garbage                       |~g                 |Sélectionner les paquets qui ne sont requis par aucun paquet installé          |
|                               |                   |manuellement.                                                                    |
|_______________________________|___________________|_________________________________________________________________________________|
|?installed                     |~i                 |Sélectionner les paquets installés.                                            |
|_______________________________|___________________|_________________________________________________________________________________|
|?maintainer(responsable)       |~mresponsable      |Sélectionner les paquets maintenus par ce responsable.                          |
|_______________________________|___________________|_________________________________________________________________________________|
|?multiarch(multiarch)          |                  |Sélectionner les paquets ayant la capacité multiarchitecture multiarch, qui peu|
|                               |                   |valoir « foreign », « same », « allowed » ou « none ».           |
|_______________________________|___________________|_________________________________________________________________________________|
|?narrow(filtre, motif)         |~S filtre motif    |Sélectionner les paquets dont une version correspond à la fois au filtre et au |
|                               |                   |motif.                                                                           |
|_______________________________|___________________|_________________________________________________________________________________|
|?name(nom)                     |~nnom, nom         |Sélectionner les paquets avec ce nom.                                           |
|_______________________________|___________________|_________________________________________________________________________________|
|?new                           |~N                 |Sélectionner les nouveaux paquets                                               |
|_______________________________|___________________|_________________________________________________________________________________|
|?obsolete                      |~o                 |Sélectionner les paquets installés qui ne peuvent pas être téléchargés.    |
|_______________________________|___________________|_________________________________________________________________________________|
|?or(motif1, motif2)            |motif1 | motif2    |Sélectionner les paquets qui correspondent au motif1, au motif2, ou aux deux.   |
|_______________________________|___________________|_________________________________________________________________________________|
|?origin(origine)               |~Oorigine          |Sélectionner les paquets avec cette origine.                                    |
|_______________________________|___________________|_________________________________________________________________________________|
|?provides(motif)               |~Pmotif            |Sélectionner les paquets qui fournissent un paquet correspondant au motif.      |
|_______________________________|___________________|_________________________________________________________________________________|
|?priority(priorité)           |~ppriorité        |Sélectionner les paquets avec cette priorité.                                  |
|_______________________________|___________________|_________________________________________________________________________________|
|?reverse-typeDép(motif)       |~R[typeDép:]motif |Sélectionner les paquets qui sont la cible d'une dépendance de type typeDép   |
|                               |                   |déclarée par un paquet correspondant au motif.                                 |
|_______________________________|___________________|_________________________________________________________________________________|
|?reverse-broken-typeDép(motif)|~RBtypeDép:motif  |Sélectionner les paquets qui sont la cible d'une dépendance cassée de type    |
|                               |                   |typeDép déclarée par un paquet correspondant au motif.                        |
|_______________________________|___________________|_________________________________________________________________________________|
|?section(section)              |~ssection          |Sélectionner les paquets appartenant à cette section.                          |
|_______________________________|___________________|_________________________________________________________________________________|
|?source-package(nom)           |                  |Sélectionne les paquets dont le nom du paquet source correspond à l'expression |
|                               |                   |régulière nom.                                                                 |
|_______________________________|___________________|_________________________________________________________________________________|
|?source-version(version)       |                  |Sélectionner les paquets dont la version source correspond à l'expression      |
|                               |                   |rationnelle version.                                                             |
|_______________________________|___________________|_________________________________________________________________________________|
|?tag(étiquette)               |~Gétiquette       |Sélectionner les paquets qui ont les étiquettes debtags données.              |
|_______________________________|___________________|_________________________________________________________________________________|
|?term(mot-clef)                |                  |Sélectionner les paquets dont n'importe quel champ texte contient le mot-clef   |
|                               |                   |donné.                                                                          |
|_______________________________|___________________|_________________________________________________________________________________|
|?term-prefix(mot-clef)         |                  |Sélectionner les paquets dont n'importe quel champ texte commence par le mot-cle|
|                               |                   |donné.                                                                          |
|_______________________________|___________________|_________________________________________________________________________________|
|?true                          |~T                 |Sélectionner tous les paquets.                                                  |
|_______________________________|___________________|_________________________________________________________________________________|
|?task(tâche)                  |~ttâche           |Sélectionner les paquets qui appartiennent à une tâche donnée.               |
|_______________________________|___________________|_________________________________________________________________________________|
|?upgradable                    |~U                 |Sélectionner les paquets qui sont installés et qui peuvent être mis à jour.  |
|_______________________________|___________________|_________________________________________________________________________________|
|?user-tag                      |                  |Sélectionner tous les paquets avec une étiquette utilisateur correspondant à  |
|                               |                   |l'expression rationnelle étiquette.                                             |
|_______________________________|___________________|_________________________________________________________________________________|
|?version(version)              |~Vversion          |Sélectionner les paquets dont la version correspond à version. Valeurs         |
|                               |                   |particulières : CURRENT (actuelle), CANDIDATE (candidate) et TARGET (cible).   |
|_______________________________|___________________|_________________________________________________________________________________|
|?virtual                       |~v                 |Sélectionner les paquets virtuels.                                              |
|_______________________________|___________________|_________________________________________________________________________________|
|                               |                   |Sélectionner les versions pour lesquelles l'expression motif fait correspondre  |
|?widen(motif)                  |~Wmotif            |n'importe quelle version du paquet, en ignorant les restrictions de version      |
|                               |                   |locales.                                                                         |
|_______________________________|___________________|_________________________________________________________________________________|





  nom
      Sélectionner les paquets dont le nom correspond à l'expression rationnelle
      nom. C'est le mode de recherche par « défaut », utilisé pour les motifs
      qui ne commencent pas par ~.


      IMG.alt.suffix Note
        = \[Note]]
                     Pour sélectionner les paquets dont le nom contient plusieurs sous-chaînes
                     différentes, utilisez le terme (décrit ci-dessous) ?name. Par exemple,
                     « ?name(apti)?name(tude) » fera correspondre tous les paquets dont le nom
                     contient à la fois « apti » et « tude ».



  ?=variable
      Sélectionner les paquets qui correspondent à la valeur de la variable, qui
      doit être accolée avec un terme?for. Par exemple, ?for x: ?depends
      (?recommends( ?=x ) ) fera correspondre tous les paquets x qui dépendent
      d'un paquet qui recommande x.

      Par exemple, l'expression de recherche suivante fait correspondre les
      paquets qui sont en conflit avec eux-mêmes :

      Exemple 2.2.  Utilisation du terme ?=.

      ?for x: ?conflicts(?=x)


      Consultez la section intitulée « Cibles de recherche explicites » pour
      plus d'informations.


  ?not(motif), !motif
      Sélectionner les paquets qui ne correspondent pas au motif. Par exemple,
      « ?not(?broken) » sélectionnera les paquets qui ne sont pas « cassés ».


      IMG.alt.suffix Note
        = \[Note]]
                     Pour inclure un point d'exclamation « ! » dans une chaîne de recherche, il doit être
                     « protégé » en le faisant précéder d'un tilde « ~ ». Sinon, aptitude considérera
                     qu'il fait partie d'un terme ?not. Par exemple, pour sélectionner les paquets dont la
                     description contient « extra ! », utiliser « ?description(extra ~!) ».



  ?and(motif1, motif2), motif1 motif2
      Sélectionner les paquets qui correspondent à la fois à motif1 et motif2.


  ?or(motif1, motif2), motf1 | motif2
      Sélectionner les paquets qui correspondent à motif1 ou à motif2.


      IMG.alt.suffix Note
        = \[Note]]
                     Pour inclure un « | » dans une expression rationnelle, il doit être « protégé »
                     pour éviter qu'aptitude ne fasse un OU logique sur les mots. Pour ce faire,
                     écrivez « ~| ».



  (motif)
      Sélectionner le motif. Par exemple, « opengl (perl|python) » sélectionnera
      les paquets dont le nom contient opengl, et aussi soit perl, soit python.


  ?action(action), ~aaction
      Sélectionner les paquets sur lesquels l'action donnée va être effectuée.
      L'action peut être « install », « upgrade », « downgrade », « remove »,
      « purge », « hold » (si le paquet a été marqué à conserver), ou « keep »
      (si un paquet n'est pas modifié).

      Veuillez noter que cela ne teste que les actions qui sont actuellement
      prévues sur un paquet et non celles qui pourraient être effectuées. Par
      exemple, ?action(upgrade) ne correspond qu'aux paquets dont vous avez
      décidé de la mise à jour et non aux paquets qui pourraient être mis à jour
      (pour cela, il y a ?upgradable).


  ?all-versions(motif)
      Sélectionner les paquets dont toutes les versions correspondent au motif.
      Chaque version du paquet sera testée séparément avec le motif, et un
      paquet sera sélectionné si toutes ses versions correspondent. Les paquets
      sans version, comme par exemple les paquets virtuels, seront toujours
      sélectionnés par ce terme de recherche.

      Ce terme ne peut être utilisé dans un contexte dans lequel l'ensemble des
      versions à tester a déjà été réduit, par exemple avec ?depends ou ?narrow.
      Cependant, il peut toujours être utilisé avec ?widen.


  ?any-version(motif)
      Sélectionner les paquets dont au moins une version correspond au motif.
      C'est le terme dual de ?all-versions.

      Ce terme ne peut être utilisé dans un contexte dans lequel l'ensemble des
      versions à tester a déjà été réduit, par exemple avec ?depends ou ?narrow.
      Cependant, il peut toujours être utilisé avec ?widen.


      IMG.alt.suffix Note
        = \[Note]]
                     Ce terme est intimement lié à ?narrow. En fait, ?any-version(motif1
                     motif2) est exactement la même chose que ?narrow(motif1, motif2).



  ?architecture(architecture), ~rarchitecture
      Sélectionner les versions de paquets pour l'architecture donnée. Par
      exemple, « ?architecture(amd64) » fait correspondre les paquets pour
      amd64, alors que « ?architecture(all) » fera correspondre les paquets
      indépendants de l'architecture. Ce terme accepte aussi les valeurs
      spéciales native et foreign.


  ?archive(archive), ~Aarchive
      Sélectionner les versions de paquets qui sont disponibles dans une archive
      qui correspond à l'expression rationnelle archive. Par exemple,
      « ?archive;(testing) » fait correspondre tous les paquets disponibles dans
      l'archive testing.


  ?automatic, ~M
      Sélectionner les paquets qui ont été automatiquement installés.


   ?bind(variable, motif), ?variable:nom_terme[(arguments)]
      Sélectionner les paquets ou versions si le motif donné correspond au
      paquet ou à la version liée à la variable, qui doit être utilisée avec un
      terme ?for.

      Exemple 2.3. Utilisation du terme ?bind.

      ?for x: ?depends(?depends(?for z: ?bind(x, ?depends(?=z))))

      ?for x: ?depends(?depends(?for z: ?x:depends(?=z)))


      Les deux motifs de recherche de l'exemple ci-dessus font correspondre tous
      les paquets x dépendant d'un paquet y, qui lui-même dépend d'un paquet z,
      dont dépend aussi directement x. Le premier motif utilise ?bind
      directement, alors que le second utilise une syntaxe raccourcie
      équivalente.

      Consultez la section intitulée « Cibles de recherche explicites » pour
      plus d'informations.


  ?broken, ~b
      Sélectionner les paquets qui sont « cassés » : ils ont une dépendance, une
      pré-dépendance, ou un conflit non satisfait.


  ?broken-typeDép, ~BtypeDép
      Sélectionner les paquets qui ont des dépendances non satisfaites
      (« cassées ») du type typeDép. typeDép peut être « depends »,
      « predepends », « recommends », « suggests »,« breaks », « conflicts » ou
      « replaces ».


  ?broken-typeDép(motif), ~DB[typeDép:]motif
      Sélectionner les paquets qui ont une dépendance non satisfaite du type
      typeDép pour un paquet correspondant au motif. typeDép peut être n'importe
      quel type de dépendance présent dans la documentation de ?broken-typeDép.


  ?conflicts(motif), ~Cmotif
      Sélectionner les paquets qui entrent en conflit avec un paquet
      correspondant au motif donné. Par exemple, « ?conflicts(?maintainer
      (dburrows@debian.org)) » correspond à tous les paquets qui entrent en
      conflit avec un paquet que je maintiens.


  ?config-files, ~c
      Sélectionner les paquets qui ont été supprimés mais dont les fichiers de
      configuration restent sur le système (c'est-à-dire qu'ils ont été
      supprimés, mais pas purgés).


  ?typeDép(motif), ~D[typeDép:]motif
      typeDép peut être soit provides, soit l'un des types de dépendances donnés
      dans la documentation de ?broken-typeDép. Par exemple, ?depends(libpng3)
      fera correspondre tous les paquets qui dépendent de libpng3. Si la forme
      courte (~D) est utilisée et typeDép n'est pas présent, il prend sa valeur
      par défaut : depends.

      Si typeDép est « provides », sélectionner les paquets qui fournissent un
      paquet correspondant au motif (équivalent à ?provides). Sinon,
      sélectionner les paquets qui déclarent une dépendance du type typeDép sur
      un paquet qui correspond au motif.


  ?description(description), ~ddescription
      Sélectionner les paquets dont la description correspond à l'expression
      rationnelle description.


  ?essential, ~E
      Sélectionner les paquets essentiels (« Essential »).


  ?exact-name(nom)
      Sélectionner les paquets nommés nom. C'est similaire à ?name mais le nom
      doit correspondre exactement. Par exemple, le motif suivant ne fera
      correspondre que le paquet apt. Avec ?name, il aurait aussi fait
      correspondre aptitude, uvccapture, etc.

      Exemple 2.4. Utilisation du terme ?exact-name

      ?exact-name(apt)



  ?false, ~F
      Ne sélectionner aucun paquet[18].


  ?for variable: motif
      Sélectionner les paquets correspondant au motif, mais la variable donnée
      peut être utilisée à l'intérieur du motif pour faire référence au paquet
      ou à la version du paquet.

      Vous pouvez utiliser la variable de deux manières. Pour appliquer un terme
      du type ?, écrivez variable:nom-terme(arguments). Par exemple, ?x:depends
      (apt). En plus, le terme ?=variable sélectionnera tous les paquets ou
      versions qui correspondent à la valeur de la variable donnée.

      Par exemple, le terme suivant fera correspondre tous les paquets x qui à
      la fois dépendent et recommandent un second paquet y.

      Exemple 2.5. Utilisation du terme ?for

      ?for x: ?depends( ?for y: ?x:recommends( ?=y ) )


      Consultez la section intitulée « Cibles de recherche explicites » pour
      plus d'informations.


  ?garbage, ~g
      Sélectionner les paquets qui ne sont pas installés, ou qui ont été
      installés automatiquement mais desquels aucun paquet installé ne dépend.


  ?installed, ~i
      Sélectionner les paquets qui sont actuellement installés.

      Bien que par défaut toutes les versions soient testées, ceci n'entre en
      correspondance qu'avec les paquets installés.


  ?maintainer(responsable), ~mresponsable
      Sélectionner les paquets dont le champ Responsable (du paquet Debian)
      correspond à l'expression rationnelle responsable. Par exemple,
      « ?maintainerjoeyh » va rechercher tous les paquets maintenus par Joey
      Hess.


  ?multiarch(multiarch)
      Sélectionner les paquets avec une capacité multiarchitecture indiquée par
      multiarch. Par exemple, « ?multiarch(foreign) » sélectionnera tous les
      paquets qui peuvent satisfaire des dépendances de paquets pour une autre
      architecture. « ?multiarch(none) » sélectionnera ceux sans aucune capacité
      multiarchitecture.


   ?narrow(filtre, motif), ~S filtre motif
      Ce motif restreint la recherche aux versions de paquets correspondant au
      filtre. En particulier, il correspond à toute version de paquet
      correspondant à la fois à filtre et motif. La chaîne de recherche est la
      valeur de chaîne du motif.


  ?name(nom), ~nnom
      Sélectionner les paquets dont le nom correspond à l'expression rationnelle
      nom. Par exemple, la plupart des paquets qui correspondent à « ?name
      (^lib) » sont des bibliothèques (« libraries ») sous une forme quelconque.


  ?new, ~N
      Sélectionner les paquets qui sont « nouveaux », c'est-à-dire ceux qui ont
      été ajoutés à l'archive depuis la dernière fois où cette liste de paquets
      a été réinitialisée en utilisant Actions → Oublier quels paquets sont
      nouveaux (f) ou l'action en ligne de commande forget-new.


   ?obsolete, ~o
      Sélectionner tous les paquets installés, mais dont aucune version n'est
      disponible dans les archives. Ces paquets apparaissent dans l'interface
      visuelle en tant que « Obsolète ou installé localement »


  ?origin(origine), ~Oorigine
      Sélectionner les paquets dont l'origine correspond à l'expression
      rationnelle origine. Par exemple, « !?origin(debian) » va rechercher tous
      les paquets non officiels sur votre système (paquets qui ne proviennent
      pas de l'archive Debian).


  ?provides(motif), ~Pmotif
      Sélectionner les paquets qui fournissent un paquet qui correspond à motif.
      Par exemple, « ?provides(mail-transport-agent) » correspondra à tous les
      paquets qui fournissent « mail-transport-agent ».


  ?priority(priorité), ~ppriorité
      Sélectionner les paquets dont la priorité est priorité. La priorité doit
      être extra, important, optional, required ou standard. Par exemple,
      « ?priority(prequired) » correspond aux paquets dont la priorité est
      « required ».


  ?reverse-typeDép(motif), ~R[typeDép:]motif
      typeDép peut être soit « provides », soit un des champs de dépendances
      donnés dans la documentation de ?broken-typeDép. Si typeDép n'est pas
      présent, il prend sa valeur par défaut : depends.

      Si typeDép est « provides », sélectionner les paquets dont le nom est
      fourni par un paquet correspondant au motif. Sinon, sélectionner les
      paquets sur lesquels un paquet correspondant au motif déclare une
      dépendance du type typeDép.


  ?reverse-broken-typeDép(motif), ?broken-reverse-typeDép(motif), ~RB[typeDép:
  ]motif
      typeDép peut être soit « provides », soit un des champs de dépendances
      donnés dans la documentation de ?broken-typeDép. Si typeDép n'est pas
      présent, il prend sa valeur par défaut : depends.

      Sélectionner les paquets pour lesquels un paquet correspondant au motif
      déclare une dépendance de type typeDép non satisfaite.


   ?section(section), ~ssection
      Sélectionner les paquets dont la section correspond à l'expression
      rationnelle section.


   ?source-package(nom)
      Sélectionner les paquets dont le paquet source correspond à l'expression
      rationnelle nom.


   ?source-version(version)
      Sélectionner les paquets dont la version source correspond à l'expression
      rationnelle version.


  ?tag(étiquette), ~Gétiquette
      Sélectionner les paquets dont le champ Étiquettes (« Tags ») correspond à
      l'expression rationnelle étiquette. Par exemple, le motif « ?tag(game::
      strategy) » fera correspondre tous les jeux de stratégie.

      Pour plus d'informations sur l'étiquetage et debtags, consultez http://
      debtags.alioth.debian.org.


   ?task(tâche), ~ttâche
      Sélectionner les paquets qui font partie d'une tâche dont le nom
      correspond à l'expression rationnelle tâche.


   ?term(mot-clef)
      Ce terme réalise une recherche dans tout le texte pour le mot-clef dans le
      cache des paquets d'apt. Lorsqu'il est utilisé avec « aptitude search »,
      Rechercher → Affichage restreint (l) dans l'interface texte, ou tapé dans
      la boîte de dialogue pour la recherche de paquet dans l'interface GTK+, ce
      terme permettra à aptitude d'accélérer la recherche en utilisant un index
      Xapian.


   ?term-prefix(préfixe-clef)
      Ce terme recherche dans tout le texte tout mot-clef commençant par
      préfixe-clef dans le cache des paquets d'apt. Lorsqu'il est utilisé avec
      « aptitude search », Rechercher → Affichage restreint (l) dans l'interface
      texte, ou tapé dans la boîte de dialogue pour la recherche de paquet dans
      l'interface GTK+, ce terme permettra à aptitude d'accélerer la recherche
      en utilisant un index Xapian.

      Ce terme est similaire à ?term mais fait correspondre les extensions de
      préfixe-clef. Par exemple, le motif de recherche suivant fera correspondre
      tous les paquets indexés avec les mots-clefs hour, hourglass, hourly, et
      ainsi de suite :

      Exemple 2.6. Utilisation du terme ?term-prefix

      ?term-prefix(hour)



   ?true, ~T
      Ce mot correspond à n'importe quel paquet. Par exemple,
      « ?installed?provides(?true) » correspond aux paquets installés qui sont
      fournis par un paquet quelconque.


   ?upgradable, ~U
      Ce terme correspond à tout paquet installé qui peut être mis à jour.


   ?user-tag(étiquette)
      Ce terme sélectionne les paquets qui sont marqués par une étiquette
      utilisateur correspondant à l'expression rationnelle étiquette.


   ?version(version), ~Vversion
      Sélectionner tous les paquets dont le numéro de version correspond à
      l'expression rationnelle version, à l'exception des valeurs ci-dessous.
      Par exemple, « ?version(debian) » correspond à tous les paquets dont le
      numéro de version contient « debian ».

      Les valeurs suivantes de version sont traitées spécialement. Pour
      rechercher une version contenant ces valeurs, faites-les précéder d'une
      barre oblique inverse ; par exemple, pour rechercher des paquets dont le
      numéro de version contient « CURRENT », rechercher « \CURRENT ».


      * CURRENT correspond à la version actuellement installée d'un paquet, s'il
        y en a une.

      * CANDIDATE correspond à la version, si elle existe, du paquet qui sera
        installée si vous appuyez sur + quand le paquet est sélectionné ou si
        vous lancez aptitude install avec son nom.

      * TARGET correspond à la version d'un paquet dont l'installation est
        prévue, si elle existe.



   ?virtual, ~v
      Sélectionner tout paquet qui est uniquement virtuel : son nom est fourni
      ou mentionné par un paquet comme dépendance, mais aucun paquet de ce nom
      n'existe. Par exemple, « ?virtual?provides(?true) » correspond aux paquets
      qui sont virtuels et qui ne sont fournis par aucun paquet, c'est-à-dire
      les paquets sur lesquels il y a une dépendance mais qui n'existent pas.


   ?widen(motif), ~Wmotif
      Étendre la recherche : si les versions à faire correspondre ont été
      limitées par un motif enveloppant (comme ?depends), ces limites sont
      oubliées. Donc, ?widen(motif) sélectionne une version d'un paquet si le
      motif correspond à une quelconque version de ce paquet.



Personnalisation d'aptitude


Personnaliser la liste des paquets

La liste de paquets peut être énormément personnalisée : la manière d'afficher
les paquets, de les ranger, de les trier et même l'organisation de l'affichage
sont toutes modifiables.


Personnaliser la manière d'afficher les paquets

Cette section décrit la manière de configurer le contenu et le formatage de la
liste des paquets, de la ligne d'état, de la ligne d'en-tête, ainsi que
l'affichage de la commande aptitude search.

Le format de chacune de ces zones est défini par une « chaîne de format ». Une
chaîne de format est une chaîne de texte contenant des commandes de format
débutant par % comme %p, %S, etc. L'affichage correspondant est créé en
remplaçant les commandes débutant par % en fonction de leur signification
(donnée ci-dessous).

Une commande de format (commençant par %) peut soit avoir une taille fixe et
dans ce cas elle est toujours remplacée par la même quantité de texte (avec
l'ajout d'espaces pour le compléter si nécessaire), soit elle est « étirable »
ce qui signifie qu'elle prend tout l'espace laissé libre par les colonnes de
texte à taille fixe. S'il y a plusieurs colonnes étirables, l'espace
supplémentaire est divisé équitablement entre les colonnes.

Toutes les commandes de format possèdent une taille fixe et/ou étirable par
défaut. La taille d'une commande de format peut être modifiée en insérant la
valeur de la taille voulue entre le signe pourcentage (%) et le caractère
identifiant le format. Par exemple, %20V produit une colonne version installable
des paquets d'une largeur de 20 caractères. Placer un point d'interrogation (?)
entre le signe % et le caractère identifiant la commande de format entraîne la
variation de la largeur de base de la colonne en fonction de son contenu.
Remarquez, néanmoins, que les colonnes de ce type risque de ne plus s'aligner
verticalement.

Si vous souhaitez qu'une commande de format soit étirable, même si elle possède
normalement une largeur fixe, placez un signe dièse (« # ») immédiatement après
elle. Par exemple, pour afficher la version installable d'un paquet sans vous
soucier de sa longueur, utilisez la commande de format %V#. Vous pouvez aussi
mettre un # après autre chose qu'une commande de format ; aptitude va alors
« étirer » le texte qui précède le # en insérant des espaces additionnelles
après lui.

En résumé, la syntaxe des commandes de format est :

%[largeur][?]code[#]

Les variables de configuration Aptitude::UI::Package-Display-Format, Aptitude::
UI::Package-Status-Format et Aptitude::UI::Package-Header-Format définissent les
formats par défaut de la liste de paquets, de l'en-tête au-dessus de la liste de
paquets et de la ligne d'état en dessous de la liste de paquets. Pour changer la
manière dont les résultats de la commande aptitude search sont affichés,
utilisez l'option -F.

Les commandes de format (débutant par %) suivantes sont disponibles :


IMG.alt.suffix Note
  = \[Note]]
               Certaines descriptions ci-dessous font référence au « paquet ». Avec
               l'interface graphique, c'est soit le paquet qui est affiché, soit le paquet
               actuellement sélectionné. Dans la recherche avec l'interface en ligne de
               commande, c'est le paquet qui est affiché.



Commande Nom                                Taille par défaut          Étirable Description 

%%       % littéral                        1                           Non       Ce n'est pas vraiment une commande de format. Cela insère simplement un signe
                                                                                  pourcentage dans l'affichage à l'endroit où elle est placée.

                                                                                  Dans certaines circonstances, une chaîne de format d'affichage comportera des
%#nombre Remplacement de paramètre         Variable                    Non       « paramètres » : par exemple, dans la ligne de commande search, les groupes
                                                                                  correspondants à la recherche sont utilisés comme paramètres lors de l'affichage du
                                                                                  résultat. Le code de format sera remplacé par le paramètre indiqué par nombre.

%a       Marque d'action                    1                           Non       Caractère unique résumant l'action à exécuter sur le paquet, comme décrit dans la
                                                                                  Figure 2.10, « Valeurs de l'indicateur « d'action » ».

%A       Action                             10                          Non       Description plus lisible de l'action à exécuter sur le paquet.

%B       Comptage des cassés               12                          Non       S'il n'y a pas de paquet cassé, ne rien afficher. Sinon, afficher une chaîne telle
                                                                                  que « Cassé : 10 » indiquant le nombre de paquets cassés.

%c       Marqueur d'état actuel            1                           Non       Caractère unique résumant l'état actuel du paquet, comme décrit dans la Figure 2.9,
                                                                                  « Valeurs de l'indicateur de « l'état courant » ».

%C       État actuel                       11                          Non       Description plus lisible de l'état actuel du paquet.

%d       Description                       40                          Oui       Description courte du paquet.

%D       Taille du paquet                   8                           Non       Taille de l'archive contenant le paquet.

%H       Nom d'hôte                        15                          Non       Nom d'hôte de l'ordinateur sur lequel aptitude fonctionne.

                                                                                  Priorité maximale assignée à la version du paquet. Pour les paquets, cela affiche
%i       Priorité (Pin priority)           4                           Non       la priorité de la version dans laquelle le paquet est forcé d'être installé (s'il y
                                                                                  en a une).

%I       Taille installée                  8                           Non       Espace disque (estimé) occupé par le paquet.

%m       Responsable                        30                          Oui       Responsable du paquet.

%M       Marquage automatique               1                           Non       Si le paquet a été installé automatiquement, afficher « A », sinon ne rien
                                                                                  afficher.

%n       Version du programme               Longueur de « 0.6.8.2 » Non       Version d'aptitude en cours de fonctionnement, actuellement « 0.6.8.2 ».

%N       Nom du programme                   Longueur du nom.            Non       Nom du programme, généralement « aptitude ».

                                                                                  Si aucun paquet ne doit être installé, ne rien afficher. Sinon, afficher une chaîne
%o       Taille à télécharger            17                          Non       indiquant la taille totale prise par les paquets à installer (c'est-à-dire une
                                                                                  estimation de ce qu'il faut télécharger) ; par exemple, « 28,5 ko à télécharger ».

%p       Nom du paquet                      30                          Oui       Afficher le nom du paquet. Quand un paquet est affiché dans une arborescence, le
                                                                                  nom sera indenté, si possible, en fonction de la profondeur de l'arbre.

%P       Priorité                          9                           Non       Afficher la priorité du paquet.

%r       Compteur des dépendances inverses 2                           Non       Afficher le nombre approximatif de paquets installés qui dépendent du paquet.

%R       Abréviation de la priorité       3                           Non       Afficher la description abrégée de la priorité du paquet : par exemple,
                                                                                  « Important » devient « Imp ».

%s       Section                            10                          Non       Afficher la section du paquet.

%S       Niveau de confiance                1                           Non       Si le paquet n'est pas certifié par une source de confiance, affiche la lettre "U".

%t       Archive                            10                          Oui       Archive dans laquelle se trouve le paquet.

%T       Étiqueté                         1                           Non       Afficher « * » si le paquet est étiqueté, rien sinon[19].

%u       Modification de l'utilisation du   30                          Non       Si l'action prévue doit modifier l'espace disque utilisé, cela indique le
         disque                                                                   changement, par exemple, « Utilisera 100,0Mo d'espace disque. »

%v       Version actuelle                   14                          Non       Afficher la version actuellement installée du paquet, ou <aucun> si le paquet n'est
                                                                                  pas actuellement installé.

%V       Version installable                14                          Non       Affiche la version du paquet qui serait installée si Paquet → Installer (+) était
                                                                                  exécuté sur le paquet, ou <aucun> si le paquet n'est pas actuellement installé.

%Z       Changement de taille               9                           Non       Affiche l'espace supplémentaire utilisé ou l'espace libéré par l'installation, la
                                                                                  mise à jour ou la suppression du paquet.



Personnaliser la hiérarchie des paquets

La hiérarchie des paquets est produite par une politique de regroupement,
décrivant la manière de construire la hiérarchie. La politique de regroupement
décrit une « succession » de règles. Chaque règle peut retirer des paquets,
créer une sous-hiérarchie dans laquelle on place des paquets ou encore manipuler
l'arborescence. Les variables de configuration Aptitude::UI::Default-Grouping et
Aptitude::UI::Default-Preview-Grouping définissent les politiques de
regroupement lors de la création, respectivement, de nouvelles listes de paquets
et de nouveaux écrans de prévisualisation. Vous pouvez définir la politique de
regroupement pour la liste de paquets actuelle en appuyant sur G.

La politique de regroupement est décrite par une liste de règles séparées par
des virgules : règle1,règle2,.... Chaque règle est constituée de son nom,
éventuellement suivi d'arguments : par exemple, versions ou section(subdir). Le
fait que des arguments soient requis et le nombre d'arguments requis (ou permis)
dépend du type de la règle.

Une règle peut être non terminale ou terminale. Une règle non terminale va
traiter un paquet en produisant une partie de la hiérarchie, puis en le passant
à la règle suivante. Une règle terminale, au contraire, va aussi traiter une
partie de l'arborescence (typiquement les entrées correspondant au paquet), mais
ne passera pas le paquet à la règle qui suit. Si aucune règle terminale n'est
spécifiée, aptitude va utiliser la règle par défaut qui crée les « entrées de
paquet » standard.



  action

      Regrouper les paquets suivant l'action prévue sur ceux-ci. Les paquets qui
      ne peuvent être mis à jour ou qui sont inchangés sont ignorés. C'est le
      regroupement qui est utilisé dans l'arborescence d'aperçu d'installation.


  architecture

      Regrouper les paquets en fonction de leur architecture.


  deps

      C'est une règle terminale.

      Créer les entrées de paquets standard qui peuvent être dépliées pour
      laisser apparaître les dépendances d'un paquet.


  filter(motif)

      N'inclure que les paquets dont au moins une version correspond au motif.

      Si le motif est manquant, aucun paquet n'est écarté. Ceci est une
      fonctionnalité de compatibilité ascendante et peut être supprimée dans le
      futur.


  firstchar

      Regrouper les paquets en fonction de la première lettre de leur nom.


  hier

      Regrouper les paquets en fonction d'un fichier de données annexe qui
      décrit une « hiérarchie » de paquets.


  pattern(motif [=> titre] [{ politique }] [, ...])

      Une politique de regroupement personnalisable. Chaque version de chaque
      paquet est mise en correspondance avec les motifs donnés. La première
      correspondance trouvée est utilisée pour attribuer un titre au paquet ;
      les paquets sont alors triés selon leur titre. Les chaînes de la forme \N
      qui apparaissent dans le titre seront remplacées par le Nième résultat de
      la recherche. Si le titre est absent, sa valeur par défaut est alors \1.
      Remarquez que les paquets qui ne correspondent à aucun motif
      n'apparaîtront pas du tout dans l'arborescence.

      Exemple 2.7. Utilisation de pattern pour grouper les paquets par
      responsable

      pattern(?maintainer() => \1)


      L'exemple ci-dessus groupera les paquets selon leur champ Responsable. La
      politique pattern(?maintainer()) fera la même chose, car l'absence de
      titre équivaut à avoir mis \1.

      Plutôt qu'un => titre, une saisie peut se terminer par ||. Cela indique
      que les paquets qui correspondent au motif seront insérés dans
      l'arborescence au même niveau que le regroupement de motifs, au lieu
      d'être placés dans des sous-arbres.

      Exemple 2.8.  Utilisation de pattern avec quelques paquets placés à la
      racine

      pattern(?action(remove) => Paquets qui vont être supprimés, ?true ||)


      L'exemple ci-dessus placera les paquets qui seront supprimés dans un sous-
      arbre et placera tous les autres paquets dans le niveau actuel, groupés en
      fonction des politiques qui suivent le motif.

      Par défaut, tous les paquets qui correspondent à chaque motif sont groupés
      selon les règles qui suivent la politique pattern. Pour indiquer une
      politique différente pour certains paquets, écrivez celle-ci entre
      accolades ({}) après le titre du groupe, après la double barre ||, ou
      après le motif si les deux autres sont absents. Par exemple :

      Exemple 2.9.  Utilisation de la politique de regroupement pattern avec des
      sous-politiques

      pattern(?action(remove) => Paquets à supprimer {}, ?action(install) =>
      Paquets à installer, ?true || {status})


      La politique dans l'exemple ci-dessus a les effets suivants :


      * Les paquets à supprimer sont placés dans un sous-arbre étiqueté
        « Paquets à supprimer ». La politique de regroupement pour ce sous-arbre
        est vide, de sorte que les paquets y sont placés dans une liste plate.

      * Les paquets à installer sont placés dans un sous-arbre étiqueté Paquets
        à installer et sont regroupés en fonction des politiques qui suivent
        pattern.

      * Tous les autres paquets sont placés à la racine de l'arborescence, et
        regroupés selon leur état.


      Consultez la section la section intitulée « Motifs de recherche » pour
      plus d'information sur le format du motif.


  priority

      Regrouper les paquets en fonction de leur priorité.


  section[(mode[,passthrough])]

      Regrouper les paquets en fonction de leur champ Section.

      mode peut prendre les valeurs suivantes :



        none
            Regrouper en fonction de la totalité du champ Section, si bien que
            des catégories comme « non-free/games » seront créées. C'est le
            comportement par défaut si aucun mode n'est indiqué.


        topdir
            Regrouper en fonction de la partie du champ Section précédant la
            première barre oblique « / ». S'il n'y en a pas ou si cette partie
            du champ Section n'est pas identifiée, la première entrée dans la
            liste Aptitude::Sections::Top-Sections sera utilisée à la place.


        subdir
            Regrouper en fonction de la partie du champ Section suivant la
            première barre oblique « / », si elle est contenue dans la liste
            Aptitude::Sections::Top-Sections. Sinon, ou s'il n'y a pas de barre
            oblique, regrouper en fonction du champ Section entier.


        subdirs
            Regrouper en fonction de la partie du champ Section après la
            première barre oblique « / », si la portion du champ qui précède
            apparaît dans la liste Aptitude::Sections::Top-Sections. Sinon, ou
            s'il n'y a pas de barre oblique, le champ Section entier sera
            utilisé. S'il y a plusieurs caractères « / » dans la portion du
            champ qui est utilisé, une hiérarchie de groupes va être créée. Par
            exemple, si « games » n'appartient pas à la liste Aptitude::
            Sections::Top-Sections, un paquet de la section « games/arcade »
            sera placé dans le groupe intitulé « games », dans un sous-arbre
            appelé « arcade ».


      Si passthrough est présent, les paquets qui, pour une raison ou une autre,
      ne possèdent pas de véritable Section (par exemple, les paquets virtuels)
      sont passés directement au niveau de regroupement suivant sans être placés
      en premier dans une sous-catégorie.


  status

      Regrouper les paquets dans les catégories suivantes :


      * Mise à jour de sécurité

      * Pouvant être mis à jour

      * Nouveaux

      * Installés

      * Non installés

      * Obsolètes ou créés localement

      * Virtuels



  source

      Regrouper les paquets en fonction du nom de leur paquet source.


  tag[(aspect)]

      Regrouper les paquets en fonction de l'information du champ Marqueur
      contenu dans les fichiers de paquets Debian. Si un aspect est fourni,
      alors seuls les marqueurs correspondants à cet aspect seront affichés.
      Sinon, tous les paquets seront affichés au moins une fois (les paquets
      sans marqueur seront placés dans une liste séparée de ceux qui en ont).

      Pour plus d'informations sur debtags, consultez le site http://
      debtags.alioth.debian.org.


  task

      Crée une arborescence appelée « Tâches » qui contient les tâches
      disponibles (les informations sur les tâches sont lues depuis debian-
      tasks.desc du paquet tasksel). La règle suivant task va créer ses
      catégories comme des enfants de Tâches.


  versions

      C'est une règle terminale.

      Créer des entrées de paquets standard qui peuvent être dépliées pour
      laisser apparaître les versions du paquet.



Personnaliser la manière de trier les paquets

Par défaut, les paquets, dans la liste de paquets ou dans la sortie de la
commande aptitude search, sont triés dans l'ordre alphabétique de leur nom.
Néanmoins, il est souvent utile de les trier suivant d'autres critères (par
exemple, la taille du paquet), et aptitude vous autorise à le faire en modifiant
la politique de tri.

Comme la politique de regroupement décrite dans la section précédente, la
politique de tri est une liste séparée par des virgules. Chaque entrée de la
liste est une règle de tri ; si les paquets sont identiques selon la première
règle, la seconde tente de les trier, et ainsi de suite. Placer un caractère
tilde (~) avant la règle inverse la signification habituelle de celle-ci. Par
exemple, priority,~name va trier les paquets par priorité, et les paquets de
même priorité seront placés dans l'ordre alphabétique inverse.

Pour modifier la politique de tri pour une liste active de paquets, appuyez sur
S. Pour changer l'ordre par défaut pour toutes les listes de paquets, définissez
l'option de configuration Aptitude::UI::Default-Sorting. Pour modifier la
politique de tri pour la commande aptitude search, utilisez l'option en ligne de
commande --sort.

Les règles disponibles sont :



  installsize
      Trier les paquets selon l'estimation de la taille nécessaire à
      l'installation.


  name
      Trier les paquets selon leur nom.


  priority
      Trier les paquets selon leur priorité.


  version
      Trier les paquets selon leur version.



Personnaliser les raccourcis clavier

Les touches utilisées pour lancer des commandes d'aptitude peuvent être
personnalisées dans le fichier de configuration. Chaque commande possède une
variable de configuration associée sous Aptitude::UI::Keybindings. Pour changer
la séquence de touches liée à une commande, il suffit de modifier la variable
correspondant à la séquence de touches. Par exemple, pour associer la touche s à
une recherche, attribuez à Aptitude::UI::Keybindings::Search la valeur « s ».
Vous pouvez demander à ce que la touche Contrôle soit aussi enfoncée en faisant
précéder la touche par « C- » : par exemple mettre « C-s » à la place de « s »
va lier la recherche à la recherche à Contrôle+s au lieu de s. Enfin, vous
pouvez lier une commande à plusieurs séquences de touches en une seule fois en
les séparant par des virgules : par exemple utiliser « s,C-s » aura pour
conséquence que s et Contrôle+s lanceront une recherche.

Les commandes suivantes peuvent être liées à une séquence de touches en
configurant les variables Aptitude::UI::Keybindings::commande, où commande est
le nom de la commande à lier :

 _____________________________________________________________________________________________________________________________
|Commande              |Valeur par défaut |Description                                                                     |
|______________________|____________________|_________________________________________________________________________________|
|ApplySolution         |!                   |Si des paquets sont cassés et aptitude a suggéré une solution au problème,   |
|                      |                    |appliquer immédiatement la solution.                                            |
|______________________|____________________|_________________________________________________________________________________|
|Begin                 |home,C-a            |Se déplacer au début de l'affichage courant : au début de la liste ou à gauc|e
|                      |                    |d'un champ de saisie de texte.                                                   |
|______________________|____________________|_________________________________________________________________________________|
|BugReport             |B                   |Envoyer un rapport de bogue contre le paquet couramment sélectionné, en utilisa|t
|                      |                    |reportbug.                                                                       |
|______________________|____________________|_________________________________________________________________________________|
|Cancel                |C-g,escape,C-[      |Annuler l'interaction courante. Par exemple, sortir d'une boîte de dialogue ou d|
|                      |                    |menu.                                                                            |
|______________________|____________________|_________________________________________________________________________________|
|Changelog             |C                   |Afficher le fichier changelog.Debian du paquet actuellement sélectionné ou de l|
|                      |                    |version du paquet.                                                               |
|______________________|____________________|_________________________________________________________________________________|
|ChangePkgTreeGrouping |G                   |Changer la politique de regroupement de la liste de paquets actuellement active. |
|______________________|____________________|_________________________________________________________________________________|
|ChangePkgTreeLimit    |l                   |Changer la restriction d'affichage de la liste de paquets actuellement active.   |
|______________________|____________________|_________________________________________________________________________________|
|ChangePkgTreeSorting  |S                   |Changer la politique de tri de la liste de paquets actuellement active.          |
|______________________|____________________|_________________________________________________________________________________|
|ClearAuto             |m                   |Marquer le paquet actuellement sélectionné comme ayant été installé manuelle|ent.
|______________________|____________________|_________________________________________________________________________________|
|CollapseAll           |]                   |Replier toute l'arborescence sélectionnée dans une liste hiérarchique.        |
|______________________|____________________|_________________________________________________________________________________|
|CollapseTree          |Aucune séquence    |Replier la racine de l'arborescence sélectionnée dans une liste hiérarchique. |
|______________________|____________________|_________________________________________________________________________________|
|Commit                |N                   |Dans l'éditeur de hiérarchie, garder en mémoire l'emplacement hiérarchique du|
|                      |                    |paquet actuel et passer au paquet suivant.                                       |
|______________________|____________________|_________________________________________________________________________________|
|                      |                    |Dans les boîtes de dialogue, cela est équivalent à « Ok ». Lors d'une inte|action
|Confirm               |enter               |en ligne de commande avec une question à choix multiples, cela choisit l'option |
|                      |                    |par défaut.                                                                     |
|______________________|____________________|_________________________________________________________________________________|
|Cycle                 |tab                 |Changer le focus clavier vers le « widget » suivant.                         |
|______________________|____________________|_________________________________________________________________________________|
|CycleNext             |f6                  |Changer vers la vue active suivante.                                             |
|______________________|____________________|_________________________________________________________________________________|
|CycleOrder            |o                   |Circuler parmi des éléments prédéfinis de l'affichage.                       |
|______________________|____________________|_________________________________________________________________________________|
|CyclePrev             |f7                  |Changer vers la vue active précédente.                                         |
|______________________|____________________|_________________________________________________________________________________|
|DelBOL                |C-u                 |Supprimer tout le texte entre le curseur et le début de la ligne.               |
|______________________|____________________|_________________________________________________________________________________|
|DelBack               |backspace,C-h       |Supprimer le caractère précédent lors de la saisie de texte.                  |
|______________________|____________________|_________________________________________________________________________________|
|DelEOL                |C-k                 |Supprimer tout le texte depuis le curseur jusqu'à la fin de la ligne.           |
|______________________|____________________|_________________________________________________________________________________|
|DelForward            |delete,C-d          |Supprimer le caractère sous le curseur lors de la saisie de texte.              |
|______________________|____________________|_________________________________________________________________________________|
|Dependencies          |d                   |Afficher les dépendances du paquet actuellement sélectionné.                  |
|______________________|____________________|_________________________________________________________________________________|
|DescriptionCycle      |i                   |Dans la liste de paquets, circuler parmi les vues disponibles dans la zone       |
|                      |                    |d'information.                                                                   |
|______________________|____________________|_________________________________________________________________________________|
|DescriptionDown       |z                   |Dans la liste de paquets, descendre d'une ligne dans la zone d'information.      |
|______________________|____________________|_________________________________________________________________________________|
|DescriptionUp         |a                   |Dans la liste de paquets, monter d'une ligne dans la zone d'information.         |
|______________________|____________________|_________________________________________________________________________________|
|DoInstallRun          |g                   |Afficher un aperçu d'installation si ce n'est pas le cas[a]. Dans un aperçu    |
|                      |                    |d'installation, lancer un processus d'installation.                              |
|______________________|____________________|_________________________________________________________________________________|
|Down                  |down,j              |Descendre : par exemple, descendre dans un affichage de texte, ou sélectionner |
|                      |                    |l'entrée suivante dans une liste.                                               |
|______________________|____________________|_________________________________________________________________________________|
|DpkgReconfigure       |R                   |Lancer « dpkg-reconfigure » sur le paquet actuellement sélectionné.        |
|______________________|____________________|_________________________________________________________________________________|
|DumpResolver          |*                   |Si des paquets sont cassés, écrire l'état actuel du solveur de dépendances da|s
|                      |                    |un fichier (pour des raisons de débogage).                                      |
|______________________|____________________|_________________________________________________________________________________|
|EditHier              |E                   |Ouvrir l'éditeur de hiérarchie.                                                |
|______________________|____________________|_________________________________________________________________________________|
|End                   |end,C-e             |Se déplacer à la fin de l'affichage courant : à la fin de la liste ou à droi|e
|                      |                    |d'un champ de saisie de texte.                                                   |
|______________________|____________________|_________________________________________________________________________________|
|                      |                    |Si des paquets sont cassés et qu'aptitude a suggéré une solution au problème,|
|ExamineSolution       |e                   |afficher une boîte de dialogue contenant une description détaillée de la      |
|                      |                    |solution.                                                                        |
|______________________|____________________|_________________________________________________________________________________|
|ExpandAll             |[                   |Déployer toute l'arborescence sélectionnée dans une liste hiérarchique.      |
|______________________|____________________|_________________________________________________________________________________|
|ExpandTree            |Aucune séquence    |Déployer la racine de l'arborescence sélectionnée dans une liste hiérarchique|
|______________________|____________________|_________________________________________________________________________________|
|FirstSolution         |<                   |Sélectionner la première solution générée par le solveur de dépendances.   |
|______________________|____________________|_________________________________________________________________________________|
|ForbidUpgrade         |F                   |Interdire à un paquet d'être mis à jour vers la version actuelle d'un paquet (|u
|                      |                    |une version particulière).                                                      |
|______________________|____________________|_________________________________________________________________________________|
|ForgetNewPackages     |f                   |Oublier quels paquets sont « nouveaux » (ce qui implique que la liste des    |
|                      |                    |« nouveaux » paquets devienne vide).                                         |
|______________________|____________________|_________________________________________________________________________________|
|Help                  |?                   |Afficher l'aide en ligne à l'écran.                                            |
|______________________|____________________|_________________________________________________________________________________|
|HistoryNext           |down,C-n            |Dans un éditeur comportant un historique, descendre dans l'historique.          |
|______________________|____________________|_________________________________________________________________________________|
|HistoryPrev           |up,C-p              |Dans un éditeur comportant un historique, remonter dans l'historique.           |
|______________________|____________________|_________________________________________________________________________________|
|Hold                  |=                   |Figer un paquet.                                                                 |
|______________________|____________________|_________________________________________________________________________________|
|Install               |+                   |Marquer un paquet pour installation.                                             |
|______________________|____________________|_________________________________________________________________________________|
|InstallSingle         |I                   |Marquer un unique paquet pour installation. Tous les autres paquets sont gardés |
|                      |                    |dans leur version actuelle.                                                      |
|______________________|____________________|_________________________________________________________________________________|
|Keep                  |:                   |Annuler toute demande d'installation ou de suppression d'un paquet.              |
|______________________|____________________|_________________________________________________________________________________|
|LastSolution          |<                   |Sélectionne la dernière solution générée par le solveur de dépendances.    |
|______________________|____________________|_________________________________________________________________________________|
|Left                  |left,h              |Se déplacer vers la gauche : par exemple, se déplacer vers la gauche dans la  |
|                      |                    |barre de menu, ou déplacer le curseur vers la gauche lors de la saisie de texte.|
|______________________|____________________|_________________________________________________________________________________|
|LevelDown             |J                   |Dans une liste hiérarchique, sélectionner l'enfant suivant l'entrée actuelleme|t
|                      |                    |sélectionnée (l'entrée suivante au même niveau avec le même parent).        |
|______________________|____________________|_________________________________________________________________________________|
|                      |                    |Dans une liste hiérarchique, sélectionner l'enfant précédant l'entrée       |
|LevelUp               |K                   |actuellement sélectionnée (l'entrée précédente au même niveau avec le même|
|                      |                    |parent).                                                                         |
|______________________|____________________|_________________________________________________________________________________|
|MarkUpgradable        |U                   |Tenter de mettre à jour tous les paquets qui ne sont pas bloqués ou interdits d|
|                      |                    |mise à jour.                                                                    |
|______________________|____________________|_________________________________________________________________________________|
|MineFlagSquare        |f                   |Dans le démineur, placer ou enlever le drapeau d'une case.                      |
|______________________|____________________|_________________________________________________________________________________|
|MineLoadGame          |L                   |Charger une partie de démineur.                                                 |
|______________________|____________________|_________________________________________________________________________________|
|MineSaveGame          |S                   |Sauvegarder une partie de démineur.                                             |
|______________________|____________________|_________________________________________________________________________________|
|MineSweepSquare       |Aucune séquence    |Faire le ménage autour de la case actuelle dans le démineur.                   |
|______________________|____________________|_________________________________________________________________________________|
|MineUncoverSquare     |Aucune séquence    |Découvrir la case actuelle dans le démineur                                    |
|______________________|____________________|_________________________________________________________________________________|
|MineUncoverSweepSquare|enter               |Découvrir la case actuelle dans le démineur si elle est couverte, sinon faire l|
|                      |                    |ménage autour d'elle.                                                           |
|______________________|____________________|_________________________________________________________________________________|
|NextPage              |pagedown,C-f        |Aller à la page suivante de l'affichage courant.                                |
|______________________|____________________|_________________________________________________________________________________|
|NextSolution          |.                   |Aller à la solution suivante du solveur de dépendances.                        |
|______________________|____________________|_________________________________________________________________________________|
|No                    |n[b]                |Sélectionner la réponse « non » dans une boîte de dialogue oui/non.       |
|______________________|____________________|_________________________________________________________________________________|
|Parent                |^                   |Sélectionner le parent de l'entrée sélectionnée dans une liste hiérarchique.|
|______________________|____________________|_________________________________________________________________________________|
|PrevPage              |pageup,C-b          |Aller à la page précédente de l'affichage courant.                            |
|______________________|____________________|_________________________________________________________________________________|
|PrevSolution          |,                   |Revenir à la solution précédente du solveur de dépendances.                  |
|______________________|____________________|_________________________________________________________________________________|
|Purge                 |_                   |Marquer le paquet actuellement sélectionné pour purge.                         |
|______________________|____________________|_________________________________________________________________________________|
|PushButton            |space,enter         |Activer le bouton actuellement sélectionné, ou modifier l'état d'une boîte à|
|                      |                    |cocher.                                                                          |
|______________________|____________________|_________________________________________________________________________________|
|Quit                  |q                   |Fermer la vue actuelle.                                                          |
|______________________|____________________|_________________________________________________________________________________|
|QuitProgram           |Q                   |Quitter le programme.                                                            |
|______________________|____________________|_________________________________________________________________________________|
|RejectBreakHolds      |                   |Rejeter toutes les actions du solveur qui pourraient casser un figeage. Cette    |
|                      |                    |action est équivalent à Solutions → Rejeter les non-respects de figeages.    |
|______________________|____________________|_________________________________________________________________________________|
|Refresh               |C-l                 |Redessiner la totalité de l'écran.                                             |
|______________________|____________________|_________________________________________________________________________________|
|Remove                |-                   |Marquer un paquet pour suppression.                                              |
|______________________|____________________|_________________________________________________________________________________|
|ReInstall             |L                   |Marquer le paquet actuellement sélectionné pour réinstallation.               |
|______________________|____________________|_________________________________________________________________________________|
|RepeatSearchBack      |N                   |Répéter la dernière recherche, mais dans la direction opposée.               |
|______________________|____________________|_________________________________________________________________________________|
|ReSearch              |n                   |Répéter la dernière recherche.                                                |
|______________________|____________________|_________________________________________________________________________________|
|ReverseDependencies   |r                   |Afficher les paquets qui dépendent du paquet actuellement sélectionné.        |
|______________________|____________________|_________________________________________________________________________________|
|Right                 |right,l             |Se déplacer vers la droite : par exemple, se déplacer vers la droite dans la  |
|                      |                    |barre de menu, ou déplacer le curseur vers la droite lors de la saisie de texte.|
|______________________|____________________|_________________________________________________________________________________|
|SaveHier              |S                   |Dans l'éditeur de hiérarchie, sauvegarder la hiérarchie actuelle.             |
|______________________|____________________|_________________________________________________________________________________|
|Search                |/                   |Activer la fonction de « recherche » sur l'élément de l'interface actuellem|nt
|                      |                    |actif.                                                                           |
|______________________|____________________|_________________________________________________________________________________|
|SearchBack            |\                   |Activer la fonction de « recherche arrière » sur l'élément de l'interface |
|                      |                    |actuellement actif.                                                              |
|______________________|____________________|_________________________________________________________________________________|
|SearchBroken          |b                   |Dans une arborescence de paquets, rechercher le paquet cassé suivant.           |
|______________________|____________________|_________________________________________________________________________________|
|SetAuto               |M                   |Marquer le paquet actuel comme ayant été automatiquement installé.            |
|______________________|____________________|_________________________________________________________________________________|
|ShowHideDescription   |D                   |Dans une liste de paquets, définir si la zone d'information est visible ou non. |
|______________________|____________________|_________________________________________________________________________________|
|                      |                    |Lors de l'affichage d'une solution, marquer l'action actuellement sélectionnée |
|SolutionActionApprove |a                   |comme « approuvée » (elle sera, autant que possible, incluse dans les procha|nes
|                      |                    |solutions).                                                                      |
|______________________|____________________|_________________________________________________________________________________|
|SolutionActionReject  |r                   |Lors de l'affichage d'une solution, marquer l'action actuellement sélectionnée |
|                      |                    |comme « rejetée » (les prochaines solutions ne la contiendront pas).        |
|______________________|____________________|_________________________________________________________________________________|
|ToggleExpanded        |enter               |Déployer ou réduire l'arborescence actuellement sélectionnée dans une liste  |
|                      |                    |hiérarchique.                                                                   |
|______________________|____________________|_________________________________________________________________________________|
|ToggleMenuActive      |C-m,f10,C-space     |Activer ou désactiver le menu principal.                                        |
|______________________|____________________|_________________________________________________________________________________|
|Undo                  |C-_,C-u             |Annuler la dernière action, en pouvant remonter jusqu'au démarrage d'aptitude O|
|                      |                    |à la dernière mise à jour de la liste de paquets ou installation.             |
|______________________|____________________|_________________________________________________________________________________|
|Up                    |up,k                |Monter : par exemple, dans un écran de sélection, aller au texte précédent, |u
|                      |                    |dans une liste, aller à l'entrée précédente.                                 |
|______________________|____________________|_________________________________________________________________________________|
|UpdatePackageList     |u                   |Mettre à jour la liste de paquets en téléchargeant de nouvelles listes depuis |
|                      |                    |Internet si nécessaire.                                                         |
|______________________|____________________|_________________________________________________________________________________|
|Versions              |v                   |Afficher les versions disponibles du paquet actuellement sélectionné.          |
|______________________|____________________|_________________________________________________________________________________|
|Yes                   |y [b]               |Sélectionner le bouton « Oui » dans les boîtes de dialogue oui/non.        |
|______________________|____________________|_________________________________________________________________________________|
|[a] à moins que Aptitude::Display-Planned-Action soit « false » (faux).                                                 |
|                                                                                                                             |
|[b] Cette valeur par défaut peut varier suivant la locale (c'est-à-dire la langue du système).                            |
|_____________________________________________________________________________________________________________________________|

En plus des touches de lettres, chiffres et ponctuations, les touches
« spéciales » suivantes peuvent être liées dans une séquence :

 ________________________________________________________________________________________
|Nom de la  |Description                                                                |
|touche     |                                                                            |
|___________|____________________________________________________________________________|
|a1         |Touche A1.                                                                  |
|___________|____________________________________________________________________________|
|a3         |Touche A3.                                                                  |
|___________|____________________________________________________________________________|
|b2         |Touche B2.                                                                  |
|___________|____________________________________________________________________________|
|backspace  |Touche Retour Arrière.                                                     |
|___________|____________________________________________________________________________|
|backtab    |Touche Tabulation Arrière.                                                 |
|___________|____________________________________________________________________________|
|begin      |Touche Begin (pas Origine, c'est-à-dire « Home »).                     |
|___________|____________________________________________________________________________|
|break      |Touche « break ».                                                       |
|___________|____________________________________________________________________________|
|c1         |Touche C1.                                                                  |
|___________|____________________________________________________________________________|
|c3         |Touche C3.                                                                  |
|___________|____________________________________________________________________________|
|cancel     |Touche Annuler (« Cancel »).                                            |
|___________|____________________________________________________________________________|
|create     |Touche Création (« Create »).                                          |
|___________|____________________________________________________________________________|
|           |Virgule (,) -- notez que, comme les virgules sont utilisées pour lister les|
|comma      |séquences, c'est l'unique moyen de lier une virgule dans une séquence de  |
|           |touches.                                                                    |
|___________|____________________________________________________________________________|
|command    |Touche Retour Arrière.                                                     |
|___________|____________________________________________________________________________|
|copy       |Touche Copier.                                                              |
|___________|____________________________________________________________________________|
|delete     |Touche Supprime.                                                            |
|___________|____________________________________________________________________________|
|delete_line|Touche « delete line ».                                                 |
|___________|____________________________________________________________________________|
|down       |Touche flèche « bas ».                                                 |
|___________|____________________________________________________________________________|
|end        |Touche Fin.                                                                 |
|___________|____________________________________________________________________________|
|entry      |Touche Entrée.                                                             |
|___________|____________________________________________________________________________|
|exit       |Touche Sortie (« Exit »).                                               |
|___________|____________________________________________________________________________|
|f1, f2,    |Les touches F1 à F10.                                                      |
|..., f10   |                                                                            |
|___________|____________________________________________________________________________|
|find       |Touche Recherche.                                                           |
|___________|____________________________________________________________________________|
|home       |Touche Origine.                                                             |
|___________|____________________________________________________________________________|
|insert     |Touche Insérer.                                                            |
|___________|____________________________________________________________________________|
|insert_exit|Touche « insert exit ».                                                 |
|___________|____________________________________________________________________________|
|clear      |Touche « clear ».                                                       |
|___________|____________________________________________________________________________|
|clear_eol  |Touche « clear to end of line ».                                        |
|___________|____________________________________________________________________________|
|clear_eos  |Touche « clear to end of screen ».                                      |
|___________|____________________________________________________________________________|
|insert_line|Touche « insert line ».                                                 |
|___________|____________________________________________________________________________|
|left       |Touche flèche « gauche ».                                              |
|___________|____________________________________________________________________________|
|mark       |Touche Mark.                                                                |
|___________|____________________________________________________________________________|
|message    |Touche Message.                                                             |
|___________|____________________________________________________________________________|
|move       |Touche Move.                                                                |
|___________|____________________________________________________________________________|
|next       |Touche Suivant.                                                             |
|___________|____________________________________________________________________________|
|open       |Touche Ouvrir (« Open »).                                               |
|___________|____________________________________________________________________________|
|previous   |Touche Précédent.                                                         |
|___________|____________________________________________________________________________|
|print      |Touche Imprimer.                                                            |
|___________|____________________________________________________________________________|
|redo       |Touche Refaire.                                                             |
|___________|____________________________________________________________________________|
|reference  |Touche Référence.                                                         |
|___________|____________________________________________________________________________|
|refresh    |Touche Rafraîchir.                                                         |
|___________|____________________________________________________________________________|
|replace    |Touche Remplacement.                                                        |
|___________|____________________________________________________________________________|
|restart    |Touche redémarrage (« Restart »).                                      |
|___________|____________________________________________________________________________|
|resume     |Touche sortie de veille (« Resume »).                                   |
|___________|____________________________________________________________________________|
|return     |Touche Retour.                                                              |
|___________|____________________________________________________________________________|
|right      |Touche flèche « droite ».                                              |
|___________|____________________________________________________________________________|
|save       |Touche Sauvegarde (« Save »).                                           |
|___________|____________________________________________________________________________|
|scrollf    |Touche défilement (« scroll forward »).                                |
|___________|____________________________________________________________________________|
|scrollr    |Touche défilement arrière (« scroll backward »).                      |
|___________|____________________________________________________________________________|
|select     |Touche de sélection (« Select »).                                      |
|___________|____________________________________________________________________________|
|suspend    |Touche de mise en veille (« Suspend »).                                 |
|___________|____________________________________________________________________________|
|pagedown   |Touche « Page Suivante ».                                               |
|___________|____________________________________________________________________________|
|pageup     |Touche « Page Précédente ».                                           |
|___________|____________________________________________________________________________|
|space      |Touche Espace.                                                              |
|___________|____________________________________________________________________________|
|tab        |Touche Tabulation.                                                          |
|___________|____________________________________________________________________________|
|undo       |Touche Annuler.                                                             |
|___________|____________________________________________________________________________|
|up         |Touche flèche « haut ».                                                |
|___________|____________________________________________________________________________|

En plus des séquences de touches globales, il est possible de changer les
séquences de touches pour une partie particulière (ou domaine) d'aptitude : par
exemple, pour faire de Tabulation un équivalent de la touche flèche droite dans
les barres de menu, donner la valeur « tab,right » à Aptitude::UI::Keybindings::
Menubar::Right. Les domaines suivants sont disponibles :

 ______________________________________________________________________________________________
|Domaine      |Description                                                                    |
|_____________|________________________________________________________________________________|
|EditLine     |Utilisé par les boîtes de saisie de texte, comme le champ de saisie de la boî|e
|             |de dialogue de « recherche ».                                               |
|_____________|________________________________________________________________________________|
|Menu         |Utilisé par les onglets de menus.                                              |
|_____________|________________________________________________________________________________|
|Menubar      |Utilisé par la barre de menu du haut de l'écran.                              |
|_____________|________________________________________________________________________________|
|Minesweeper  |Utilisé par le mode démineur.                                                 |
|_____________|________________________________________________________________________________|
|MinibufChoice|Utilisé par les questions à choix multiples qui apparaissent si vous avez choi|i
|             |de voir des questions apparaître dans la ligne d'état.                        |
|_____________|________________________________________________________________________________|
|Pager        |Utilisé pour afficher un fichier présent sur le disque (par exemple, le fichie|
|             |texte d'aide).                                                                  |
|_____________|________________________________________________________________________________|
|PkgNode      |Utilisé par les paquets, les arborescences de paquets, les versions et les     |
|             |dépendances de paquets quand ils apparaissent dans des listes de paquets.      |
|_____________|________________________________________________________________________________|
|PkgTree      |Utilisé par les listes de paquets.                                             |
|_____________|________________________________________________________________________________|
|Table        |Utilisé par les présentations d'objets graphiques (par exemple, les boîtes de|
|             |dialogue).                                                                      |
|_____________|________________________________________________________________________________|
|TextLayout   |Utilisé par les affichages formatés de texte, tels que les descriptions de    |
|             |paquets.                                                                        |
|_____________|________________________________________________________________________________|
|Tree         |Utilisé par tous les affichages d'arborescence (dont les listes de paquets pour|
|             |lesquelles PkgTree reste prépondérant).                                       |
|_____________|________________________________________________________________________________|


Personnaliser la couleur du texte et les styles

Les couleurs et les styles visuels utilisés par aptitude pour l'affichage
peuvent être personnalisés. Chaque élément visuel a un « style » associé qui
décrit les couleurs et caractéristiques visuelles particulières qui sont
utilisées pour l'afficher. Les styles prennent la forme d'une liste des
paramètres de couleurs et de caractéristiques. Cette liste n'est pas
nécessairement exhaustive, si des couleurs ou caractéristiques ne sont pas
spécifiées explicitement, leur valeur est prise du contexte d'affichage
environnant. En fait, la plupart des éléments visuels possèdent un style
« vide » par défaut.

Vous pouvez changer le contenu d'un style en créant un groupe de configuration
du même nom dans le fichier de configuration d'apt ou d'aptitude. Par exemple,
le style « MenuBorder » est utilisé pour dessiner la bordure autour des menus
déroulants. Par défaut, cette bordure est bleue sur blanc en gras. Mettre le
texte suivant dans le fichier de configuration va le changer en blanc sur cyan :

Aptitude::UI::Styles {
  MenuBorder {fg white; bg cyan; set bold;};
};

Comme vous pouvez le voir, un groupe de configuration de style consiste en une
séquence d'instructions. Les catégories générales des instructions sont :



  fg couleur
      Utilise la couleur donnée pour le texte. Une liste des couleurs acceptées
      par aptitude est disponible ci-dessous.


  bg couleur
      Utilise la couleur donnée pour l'arrière-plan. Une liste des couleurs
      acceptées par aptitude est disponible ci-dessous.


  set attribut
      Active l'attribut de texte donné. Une liste des attributs de texte
      acceptés par aptitude est disponible ci-dessous.


  clear attribut
      Désactive l'attribut de texte donné. Une liste des attributs de texte
      acceptés par aptitude est disponible ci-dessous.


  flip attribut
      Inverse l'état de l'attribut de texte donné : s'il est activé dans
      l'élément environnant, il sera désactivé et inversement. Une liste des
      attributs de texte acceptés par aptitude est disponible ci-dessous.


Les couleurs reconnues par aptitude sont le noir (black), le bleu (blue), le
cyan (cyan), le vert (green), le magenta (magenta), le rouge (red), le blanc
(white) et le jaune (yellow)[20]. De plus vous pouvez indiquer default à la
place d'une couleur d'arrière-plan pour utiliser la couleur par défaut du
terminal. Cela peut être la couleur par défaut, une image, ou même la
« transparence ». Les styles qu'aptitude reconnaît sont :



  blink
      Active le clignotement du texte.


  bold
      Rend la couleur du texte du premier plan (ou d'arrière plan si la vidéo
      inverse est activée) plus claire.


  dim
      Peut entraîner le texte à être plus estompé sur certains terminaux. Aucun
      effet n'a été observé sur les terminaux Linux usuels.


  reverse
      Inverse les couleurs d'avant et arrière plan. Beaucoup d'éléments visuels
      utilisent cet attribut pour faire des effets de surbrillance.


  standout
      Active le « meilleur mode de surbrillance du terminal ». Dans les xterms,
      c'est comparable, mais pas totalement identique à la vidéo inverse. Le
      comportement des autres terminaux peut varier.


  underline
      Active le soulignement du texte.


Vous pouvez sélectionner plusieurs de ces attributs en une fois en les séparant
par des virgules. Par exemple, vous pourriez utiliser set bold,standout;.


IMG.alt.suffix Note
  = \[Note]]
               Comme signalé ci-dessus, l'interprétation des styles et des attributs de texte
               est hautement dépendant du terminal. Il vous faudra certainement expérimenter un
               peu pour trouver ce que certains paramétrages font dans votre terminal.


Les styles suivants peuvent être personnalisés dans aptitude :

Figure 2.14. Styles personnalisables dans aptitude

 __________________________________________________________________________________________________________________________________
|Style                     |Valeur par défaut |Description                                                                      |
|__________________________|____________________|__________________________________________________________________________________|
|Bullet                    |fg yellow; set bold;|Style des puces dans les listes à puces.                                         |
|__________________________|____________________|__________________________________________________________________________________|
|                          |                    |Style des nouvelles versions du paquet dans la vue affichant la liste de          |
|ChangelogNewerVersion     |set bold;           |modification du paquet. aptitude ne mettra en surbrillance les nouvelles versions |
|                          |                    |du paquet que si vous avez le paquet libparse-debianchangelog-perl installé.     |
|__________________________|____________________|__________________________________________________________________________________|
|Default                   |fg white; bg black; |Style de base de l'écran.                                                        |
|__________________________|____________________|__________________________________________________________________________________|
|DepBroken                 |fg black; bg red;   |Style des dépendances non satisfaites.                                           |
|__________________________|____________________|__________________________________________________________________________________|
|DisabledMenuEntry         |fg black; bg blue;  |Style des entrées de menu qui sont désactivées et qui ne peuvent pas être     |
|                          |set dim;            |utilisées.                                                                       |
|__________________________|____________________|__________________________________________________________________________________|
|DownloadHit               |fg black; bg green; |Style utilisé pour indiquer qu'un fichier a été « atteint », c'est-à-dire,|qu'il
|                          |                    |n'a pas changé depuis la dernière fois qu'il a été téléchargé.             |
|__________________________|____________________|__________________________________________________________________________________|
|DownloadProgress          |fg blue; bg yellow; |Style de la barre de progression d'un téléchargement.                           |
|__________________________|____________________|__________________________________________________________________________________|
|EditLine                  |fg white; bg black; |Style d'une ligne éditable (par exemple la zone d'entrée dans la boîte de dialo|ue
|                          |clear reverse;      |de recherche).                                                                    |
|__________________________|____________________|__________________________________________________________________________________|
|Error                     |fg white; bg red;   |Style des messages d'erreur.                                                      |
|                          |set bold;           |                                                                                  |
|__________________________|____________________|__________________________________________________________________________________|
|Header                    |fg white; bg blue;  |Style du haut de l'écran.                                                        |
|                          |set bold;           |                                                                                  |
|__________________________|____________________|__________________________________________________________________________________|
|HighlightedMenuBar        |fg white; bg blue;  |Style du nom du menu actuellement sélectionné dans la barre de menu.            |
|                          |set bold,reverse;   |                                                                                  |
|__________________________|____________________|__________________________________________________________________________________|
|HighlightedMenuEntry      |fg white; bg blue;  |Style de choix actuellement sélectionné dans un menu.                           |
|                          |set bold,reverse;   |                                                                                  |
|__________________________|____________________|__________________________________________________________________________________|
|MediaChange               |fg yellow; bg red;  |Style de la boîte de dialogue utilisée pour demander à l'utilisateur d'insérer|un
|                          |set bold;           |autre CD.                                                                         |
|__________________________|____________________|__________________________________________________________________________________|
|MenuBar                   |fg white; bg blue;  |Style de la barre de menu.                                                        |
|                          |set bold;           |                                                                                  |
|__________________________|____________________|__________________________________________________________________________________|
|MenuBorder                |fg white; bg blue;  |Style de la bordure entourant un menu déroulant.                                 |
|                          |set bold;           |                                                                                  |
|__________________________|____________________|__________________________________________________________________________________|
|MenuEntry                 |fg white; bg blue;  |Style de chaque entrée d'un menu déroulant.                                     |
|__________________________|____________________|__________________________________________________________________________________|
|MineBomb                  |fg red; set bold;   |Style des bombes dans le démineur.                                               |
|__________________________|____________________|__________________________________________________________________________________|
|MineBorder                |set bold;           |Style de la bordure d'un tableau du démineur.                                    |
|__________________________|____________________|__________________________________________________________________________________|
|MineFlag                  |fg red; set bold;   |Style des drapeaux dans le démineur.                                             |
|__________________________|____________________|__________________________________________________________________________________|
|MineNumberN               |Variés             |Style du nombre N dans le démineur. N est entre 0 et 8.                          |
|__________________________|____________________|__________________________________________________________________________________|
|MultiplexTab              |fg white; bg blue;  |Couleur utilisée pour afficher les « onglets » autres que celui actuellement |
|                          |                    |sélectionné.                                                                    |
|__________________________|____________________|__________________________________________________________________________________|
|MultiplexTabHighlighted   |fg blue; bg white;  |Couleur utilisée pour afficher l'« onglet » actuellement sélectionné.      |
|__________________________|____________________|__________________________________________________________________________________|
|PkgBroken                 |fg red; flip        |Dans la liste des paquets, style des paquets qui ont des dépendances non         |
|                          |reverse;            |satisfaites.                                                                      |
|__________________________|____________________|__________________________________________________________________________________|
|PkgBrokenHighlighted      |fg red;             |Dans la liste des paquets, style des paquets en surbrillance qui ont des          |
|                          |                    |dépendances non satisfaites.                                                     |
|__________________________|____________________|__________________________________________________________________________________|
|PkgNotInstalled           |                   |Style des paquets qui ne sont pas actuellement installés et qu'il n'est pas prév|
|                          |                    |d'installer.                                                                      |
|__________________________|____________________|__________________________________________________________________________________|
|PkgNotInstalledHighlighted|                   |Style des paquets en surbrillance qui ne sont pas actuellement installés et qu'il|
|                          |                    |n'est pas prévu d'installer.                                                     |
|__________________________|____________________|__________________________________________________________________________________|
|PkgIsInstalled            |set bold;           |Style des paquets qui sont actuellement installés et sur lesquels aucune action  |
|                          |                    |n'est prévu.                                                                     |
|__________________________|____________________|__________________________________________________________________________________|
|PkgIsInstalledHighlighted |set bold; flip      |Style des paquets en surbrillance qui sont actuellement installés et sur lesquels|
|                          |reverse;            |aucune action n'est prévu.                                                       |
|__________________________|____________________|__________________________________________________________________________________|
|PkgToDowngrade            |set bold;           |Dans la liste des paquets, style des paquets qu'il est prévu de mettre à jour.  |
|__________________________|____________________|__________________________________________________________________________________|
|PkgToDowngradeHighlighted |set bold; flip      |Dans la liste des paquets, style des paquets en surbrillance qu'il est prévu de  |
|                          |reverse             |mettre à une version antérieure.                                                |
|__________________________|____________________|__________________________________________________________________________________|
|PkgToHold                 |fg white; flip      |Dans la liste des paquets, style des paquets qui sont gelés.                     |
|                          |reverse;            |                                                                                  |
|__________________________|____________________|__________________________________________________________________________________|
|PkgToHoldHighlighted      |fg white;           |Dans la liste des paquets, style des paquets en surbrillance qui sont gelés.     |
|__________________________|____________________|__________________________________________________________________________________|
|PkgToInstall              |fg green; flip      |Dans la liste des paquets, style des paquets qu'il est prévu d'installer (pas de |
|                          |reverse;            |mettre à jour) ou de réinstaller.                                               |
|__________________________|____________________|__________________________________________________________________________________|
|PkgToInstallHighlighted   |fg green;           |Dans la liste des paquets, style des paquets en surbrillance qu'il est prévu     |
|                          |                    |d'installer (pas de mettre à jour) ou de réinstaller.                           |
|__________________________|____________________|__________________________________________________________________________________|
|PkgToRemove               |fg magenta; flip    |Dans la liste des paquets, style des paquets qu'il est prévu de supprimer ou de  |
|                          |reverse;            |purger.                                                                           |
|__________________________|____________________|__________________________________________________________________________________|
|PkgToRemoveHighlighted    |fg magenta;         |Dans la liste des paquets, style des paquets en surbrillance qu'il est prévu de  |
|                          |                    |supprimer ou de purger.                                                           |
|__________________________|____________________|__________________________________________________________________________________|
|PkgToUpgrade              |fg cyan; flip       |Dans la liste des paquets, style des paquets qu'il est prévu de mettre à jour.  |
|                          |reverse;            |                                                                                  |
|__________________________|____________________|__________________________________________________________________________________|
|PkgToUpgradeHighlighted   |fg cyan;            |Dans la liste des paquets, style des paquets qu'il est prévu de mettre à jour.  |
|__________________________|____________________|__________________________________________________________________________________|
|Progress                  |fg blue; bg yellow; |Style de l'indicateur d'avancement tel que celui qui apparaît lors du chargement |
|                          |                    |du cache des paquets.                                                             |
|__________________________|____________________|__________________________________________________________________________________|
|SolutionActionApproved    |bg green;           |Style des solutions approuvées dans une solution.                                |
|__________________________|____________________|__________________________________________________________________________________|
|SolutionActionRejected    |bg red;             |Style des solutions rejetées dans une solution.                                  |
|__________________________|____________________|__________________________________________________________________________________|
|Status                    |fg white; bg blue;  |Style de la ligne d'état en bas de l'écran.                                     |
|                          |set bold;           |                                                                                  |
|__________________________|____________________|__________________________________________________________________________________|
|TreeBackground            |                   |Couleur de base de toutes les listes et arbres visuels.                           |
|__________________________|____________________|__________________________________________________________________________________|
|TrustWarning              |fg red; bg black;   |Couleur utilisée pour afficher les avertissements concernant les paquets de      |
|                          |set bold;           |confiance.                                                                        |
|__________________________|____________________|__________________________________________________________________________________|




Personnaliser la disposition de l'affichage

Il est possible de réordonner la liste des paquets d'aptitude en apportant les
modifications appropriées au fichier de configuration.


Éléments d'affichage

La disposition est conservée dans le groupe de configuration Aptitude::UI::
Default-Package-View et consiste en une liste d'éléments d'affichage :

Nom Type {
  Row ligne;
  Column colonne;
  Width largeur;
  Height hauteur;

  options supplémentaires...
};

Cela crée un élément d'affichage nommé Nom dont le type est donné par Type. Les
options Row, Column, Width et Height doivent être présentes. Elles déterminent
où l'élément d'affichage est situé. Voyez ci-dessous pour une explication
détaillée sur la manière dont les éléments d'affichage sont disposés.

Vous trouverez des exemples concernant la manière de modifier la disposition de
l'affichage en consultant la définition du thème par défaut dans le fichier /
usr/share/aptitude/aptitude-defaults.

Les types d'éléments d'affichage suivants sont disponibles :



  Description
      Cet élément d'affichage contient la « zone d'information » (typiquement
      une description du paquet actuellement sélectionné).

      L'option PopUpDownKey donne le nom d'une commande clavier qui va montrer
      ou cacher l'élément d'affichage. Par exemple, mettre cette option à
      ShowHideDescription va donner à l'élément d'affichage actuel le même
      comportement que celui par défaut pour la zone d'information. L'option
      PopUpDownLinked donne le nom d'un autre élément d'affichage ; l'élément
      courant sera montré ou caché à chaque fois que l'autre élément le sera.


  MainWidget
      C'est une référence à l'élément d'affichage « principal » : typiquement
      c'est une liste de paquets. Une disposition d'affichage doit contenir
      exactement un élément MainWidget : pas un de plus, pas un de moins.


  Static
      Zone de l'écran qui affiche du texte ; elle peut contenir du code formaté
      décrit dans la section intitulée « Personnaliser la manière d'afficher les
      paquets ». Le texte à afficher peut être donné dans l'option Columns, ou
      être stocké dans la variable spécifiée par l'option ColumnsCfg. La couleur
      du texte est déterminée par le nom de la couleur passé à l'option Color.

      Les objets Static peuvent être affichés et cachés de la même manière que
      les objets Description en utilisant les options PopUpDownKey et
      PopUpDownLinked.



Placement des éléments d'affichage

Les éléments d'affichage sont disposés dans une « table ». Le coin supérieur
gauche d'un élément est dans la cellule donnée par les options Row et Column
(commençant habituellement à la ligne 0 et la colonne 0 bien que ce ne soit pas
obligatoire). La largeur d'un élément en cellule est donnée par son option
Width, et sa hauteur est donnée par son option Height.

Une fois que l'élément d'affichage est disposé et qu'il a reçu une étendue
initiale à l'écran, il est possible qu'il reste de l'espace. S'il y a de
l'espace libre verticalement chaque ligne contenant un élément d'affichage dont
l'option RowExpand est à true se verra allouer une partie de l'espace libre. De
façon analogue, s'il y a de l'espace libre horizontalement, chaque colonne
contenant un élément d'affichage dont l'option ColExpand est à true se verra
allouer une partie de l'espace libre.

Dans le cas où il n'y a pas assez d'espace, chaque ligne ou colonne dont tous
les objets ont leurs options RowShrink ou ColShrink à true sera rétrécie. S'il
n'y en a pas assez, toutes les lignes et colonnes sont réduites pour s'ajuster à
l'espace disponible.

Si un élément d'affichage n'est pas agrandi, mais ses lignes ou colonnes le
sont, son alignement est déterminé par les options RowAlign et ColAlign. Les
configurer à Left (gauche), Right (droite), Top (haut), Bottom (bas), ou Center
(centré) va indiquer à aptitude où placer l'élément verticalement et
horizontalement.

Par exemple, le groupe de configuration suivant crée un élément statique nommé
« Header » qui est large de trois cellules et qui s'agrandit horizontalement
mais pas verticalement. Il a la même couleur que les autres lignes d'en-tête et
utilise le format standard des lignes d'en-tête :

Header Static {
  Row 0;
  Column 0;
  Width 3;
  Height 1;

  ColExpand true;
  ColAlign Center;

  RowAlign Center;

  Color ScreenHeaderColor;
  ColumnsCfg HEADER;
};


Référence des options de la disposition de l'affichage

Les options suivantes sont disponibles pour les éléments d'affichage :



  ColAlign alignement;
      Alignement doit être Left (gauche), Right (droite), ou Center (centré). Si
      la ligne contenant l'élément d'affichage courant est plus large que
      l'élément lui-même et que ColExpand est false, l'élément sera placé dans
      la ligne selon la valeur alignement.

      Si cette option est absente, la valeur par défaut est Left.


  ColExpand true|false;
      Si cette option est mise à true (vrai), la colonne contenant l'élément
      d'affichage se verra allouer une partie de l'espace horizontal libre qui
      serait disponible.

      Si cette option est absente, la valeur par défaut est false (faux).


  Color couleur;
      Cette option s'applique à l'élément Static. Couleur est le nom d'une
      couleur (par exemple, ScreenStatusColor) qui devrait être utilisée comme
      couleur par défaut pour afficher l'élément d'affichage.

      Si cette option est absente, la valeur par défaut est
      DefaultWidgetBackground.


  ColShrink true|false;
      Si cette option est mise à true sur chaque élément d'une colonne et qu'il
      n'y a pas assez d'espace horizontal, la colonne sera rétrécie autant qu'il
      faut pour rentrer dans l'espace disponible. Remarquez qu'une colonne peut
      être rétrécie même si ColShrink est false ; cela indique simplement
      qu'aptitude devrait essayer de réduire une colonne particulière avant les
      autres.

      Si cette option est absente, la valeur par défaut est false (faux).


  Column colonne;
      Précise la colonne la plus à gauche pouvant contenir cet élément
      d'affichage.


  Columns format;
      Cette option s'applique aux éléments d'affichage Static pour lesquels
      l'option ColumnsCfg n'est pas configurée. Elle configure le contenu de
      l'affichage de la ligne d'état. C'est une chaîne de format du type décrit
      dans la section intitulée « Personnaliser la manière d'afficher les
      paquets ».


  ColumnsCfg HEADER|STATUS|nom;
      Cette option s'applique aux éléments d'affichage Static. Elle configure le
      format d'affichage de l'élément courant à la valeur d'une autre variable
      de configuration. Si c'est HEADER ou STATUS, les options, respectivement,
      Aptitude::UI::Package-Header-Format et Aptitude::UI::Package-Status-
      Format, sont utilisées. Sinon l'option nom est utilisée.

      Si cette option est absente, la valeur de l'option Columns est utilisée
      pour contrôler le contenu de l'élément statique.


  Height hauteur;
      Précise la hauteur de l'élément d'affichage courant.


  PopUpDownKey commande;
      Cette option s'applique aux éléments d'affichage Description et Static.

      commande est le nom d'une commande clavier (par exemple,
      ShowHideDescription). Quand cette séquence de touches est pressée,
      l'élément d'affichage est caché s'il est visible et affiché s'il est
      caché.


  PopUpDownLinked élément;
      Cette option s'applique aux éléments d'affichage Description et Static.

      élément est le nom d'un élément d'affichage. Quand élément est affiché,
      l'élément courant sera affiché lui aussi et quand élément est caché,
      l'élément courant sera caché lui aussi.


  Row ligne;
      Précise la ligne la plus haute pouvant contenir cet élément d'affichage.


  RowAlign alignement;
      alignement doit être Top (haut), Bottom (bas) ou Center (centré). Si la
      ligne contenant l'élément d'affichage courant est plus haute que l'élément
      lui-même et que RowExpand est false, l'élément sera placé dans la ligne
      selon la valeur alignement.

      Si cette option est absente, la valeur de l'option est Top.


  RowExpand true|false;
      Si la valeur de cette option est true (vrai), la ligne contenant l'élément
      d'affichage se verra allouer une partie de l'espace horizontal libre qui
      serait disponible.

      Si cette option est absente, la valeur par défaut est false (faux).


  RowShrink true|false;
      Si la valeur de cette option est true sur chaque élément d'une ligne, et
      s'il n'y a pas assez d'espace horizontal, la ligne sera rétrécie autant
      qu'il faut pour rentrer dans l'espace disponible. Remarquez qu'une ligne
      peut être rétrécie même si RowShrink est false ; cela indique simplement
      qu'aptitude devrait essayer de réduire une ligne particulière avant les
      autres.

      Si cette option est absente, la valeur par défaut est false (faux).


  Visible true|false;
      Si la valeur de cette option est false (faux), cet élément d'affichage
      sera initialement caché. Ce n'est probablement utile que combiné avec
      PopUpDownKey et/ou PopUpDownLinked.

      Si cette option est absente, la valeur de l'option est true.


  Width largeur;
      Précise la largeur de l'élément d'affichage courant.



Référence du fichier de configuration


Format du fichier de configuration

Dans sa forme la plus simple, le fichier de configuration d'aptitude est une
liste de couples d'options et de leurs valeurs. Chaque ligne du fichier devrait
avoir la forme « Option Valeur; » : par exemple, dans le fichier de
configuration, la ligne suivante attribue à l'option Aptitude::Theme la valeur
« Dselect ».

Aptitude::Theme "Dselect";

Une option peut « contenir » d'autres options si elles sont écrites entre
accolades placées entre l'option et le point-virgule qui la suit, comme ceci :

Aptitude::UI {
  Package-Status-Format "";
  Package-Display-Format "";
};

Une option qui contient d'autres options est parfois appelée groupe. En fait, le
deux-points doublé, qui apparaît dans les noms d'options est une manière
simplifiée pour indiquer l'inclusion : l'option Aptitude::UI::Default-Grouping
est contenu dans le groupe Aptitude::UI, qui est lui-même dans le groupe
Aptitude. Ainsi, si vous le souhaitez, vous pourriez configurer cette option à
"" comme cela :

Aptitude {
  UI {
    Default-Grouping "";
  };
};

Pour plus d'informations sur le format du fichier de configuration, consultez la
page de manuel apt.conf(5).


Emplacement des fichiers de configuration

La configuration d'aptitude est lue, dans l'ordre, depuis les sources
suivantes :


  1. options du fichier de configuration indiquées sur la ligne de commande ;

  2. le fichier de configuration de l'utilisateur, ~/.aptitude/config. Ce
     fichier est écrasé lorsque l'utilisateur modifie la configuration dans le
     menu Options ;

  3. le fichier de configuration du système, /etc/apt/apt.conf ;

  4. les fichiers fragments de configuration du système, /etc/apt/apt.conf.d/* ;

  5. le fichier précisé par la variable d'environnement APT_CONFIG (si elle est
     définie) ;

  6. les valeurs par défaut conservées dans /usr/share/aptitude/aptitude-
     defaults ;

  7. les valeurs par défaut contenues dans aptitude.


Quand une option est évaluée, ces sources sont consultées dans l'ordre, et la
première qui fournit une valeur pour l'option est utilisée. Par exemple,
configurer une option dans /etc/apt/apt.conf va écraser la valeur par défaut
d'aptitude pour cette option, mais cela n'écrasera pas la configuration de
l'utilisateur dans ~/.aptitude/config.


Options de configuration disponibles

Les options de configuration suivantes sont utilisées par aptitude. Notez que ce
ne sont pas les seules options de configuration disponibles. Les options
utilisées par le système apt sous-jacent ne sont pas listées ici. Consultez les
pages de manuel apt(8) et apt.conf(5) pour les informations sur les options
d'apt.

Option :Apt::AutoRemove::RecommendsImportant

Valeur par défaut :true

Description : Si cette option vaut true, aptitude ne considérera pas les paquets
comme inutilisés (et donc ne les retirera pas automatiquement) aussi longtemps
qu'un paquet installé les recommande, même si Aptitude::Recommends-Important a
la valeur false. Pour plus d'information, consultez la section intitulée « Gérer
les paquets automatiquement installés ».

Option :Apt::AutoRemove::SuggestsImportant

Valeur par défaut :true

Description : Si cette option prend la valeur true, aptitude ne considérera pas
les paquets comme inutilisés (et donc ne les retirera pas automatiquement) tant
qu'un paquet installé les suggère. Pour plus d'informations, consultez la
section intitulée « Gérer les paquets automatiquement installés ».

Option :Apt::Get::List-Cleanup

Valeur par défaut :true

Description : Synonyme de Apt::List-Cleanup. Si l'une de ces deux options vaut
faux (« false »), aptitude ne supprimera pas les anciens fichiers de listes de
paquets après avoir téléchargé de nouvelles listes.

Option :Apt::List-Cleanup

Valeur par défaut :true

Description : Synonyme de Apt::Get::List-Cleanup. Si l'une de ces deux options
vaut faux (« false »), aptitude ne supprimera pas les anciens fichiers de listes
de paquets après avoir téléchargé de nouvelles listes.

Option :Apt::Install-Recommends

Valeur par défaut :true

Description : Si cette option vaut true et si Aptitude::Auto-Install vaut aussi
true, l'installation d'un nouveau paquet induira l'installation de tous les
paquets qu'il recommande. De plus, si cette option a la valeur true, alors
aptitude ne considérera pas les paquets comme inutilisés (et donc ne le retirera
pas automatiquement) tant qu'un paquet les recommande. Pour plus d'information,
consultez la section intitulée « Gérer les paquets automatiquement installés »
et la section intitulée « Résolution immédiate des dépendances ».

Option :Aptitude::Allow-Null-Upgrade

Valeur par défaut :false

Description : Normalement, si vous essayez de démarrer un processus
d'installation alors qu'aucune action n'est prévue, aptitude affiche un
avertissement et revient à la liste des paquets. Si cette option vaut true,
aptitude affichera l'aperçu d'installation, même s'il y a des paquets pouvant
être mis à jour, plutôt qu'afficher un rappel concernant la commande Actions →
Marquer comme étant susceptible de mise à jour (U).

Option :Aptitude::Always-Use-Safe-Resolver

Valeur par défaut :false

Description : Si cette option vaut true, les actions en ligne de commande
d'aptitude utiliseront toujours un solveur de dépendances « sûr », comme si
l'option --safe-resolver avait été passée sur la ligne de commande.

Option :Aptitude::Autoclean-After-Update

Valeur par défaut :false

Description : Si cette option vaut true, aptitude fera le ménage parmi les
fichiers obsolètes (consultez Actions → Enlever les fichiers périmés) à chaque
mise à jour de la liste des paquets.

Option :Aptitude::Auto-Fix-Broken

Valeur par défaut :true

Description : Si cette option vaut false, aptitude demandera la permission avant
de tenter de corriger un paquet cassé.

Option :Aptitude::Auto-Install

Valeur par défaut :true

Description : Si cette option vaut true, aptitude essaiera automatiquement de
satisfaire les dépendances d'un paquet quand vous le sélectionnez pour
installation.

Option :Aptitude::Auto-Install-Remove-Ok

Valeur par défaut :false

Description : Si cette option vaut true, aptitude supprimera automatiquement les
paquets en conflit losqu'un paquet est marqué pour l'installation ou la mise à
jour. Normalement, ces conflits sont signalés et vous devez les résoudre
manuellement.

Option :Aptitude::Auto-Upgrade

Valeur par défaut :false

Description : Si cette option vaut true, aptitude marquera automatiquement tous
les paquets pouvant être mis à jour pour qu'ils le soient au démarrage du
programme, comme si vous aviez exécuté la commande Actions → Marquer comme étant
susceptible de mise à jour (U).

Option :Aptitude::CmdLine::Always-Prompt

Valeur par défaut :false

Description : En mode ligne de commande, si cette option vaut true, aptitude
demandera toujours confirmation avant de commencer à installer ou supprimer des
paquets, même si la confirmation aurait normalement été sautée. C'est équivalent
à l'option -P de la ligne de commande.

Option :Aptitude::CmdLine::Assume-Yes

Valeur par défaut :false

Description : En mode ligne de commande, si cette option vaut true, aptitude
agira comme si l'utilisateur répondait « oui » à chaque invite, causant le saut
de la plupart des questions. C'est équivalent à l'option -y de la ligne de
commande.

Option :Aptitude::CmdLine::Disable-Columns

Valeur par défaut :false

Description : Si cette option est activée, les résultats des recherches depuis
la ligne de commande (effectuées avec aptitude search) ne seront ni formatées
pour utiliser un nombre fixe de colonnes, ni tronquées à la largeur de l'écran.
C'est un équivalent de l'option en ligne de commande --disable-columns.

Option :Aptitude::CmdLine::Download-Only

Valeur par défaut :false

Description : En mode ligne de commande, si cette option vaut true, aptitude
téléchargera les paquets sans les installer. C'est équivalent à l'option -d de
la ligne de commande.

Option :Aptitude::CmdLine::Fix-Broken

Valeur par défaut :false

Description : En mode ligne de commande, si cette option vaut true, aptitude
sera plus agressif lorsqu'il tentera de corriger les dépendances de paquets
cassés. C'est équivalent à l'option -f de la ligne de commande.

Option :Aptitude::CmdLine::Versions-Group-By

Valeur par défaut : Donnez la valeur auto, none, package ou source-package pour
contrôler si et comment la sortie de la commande aptitude versions est
regroupée. Cela est équivalent à l'option en ligne de commande --group-by
(consultez sa documentation pour plus d'informations sur la signification de ces
valeurs).

Option :Aptitude::CmdLine::Ignore-Trust-Violations

Valeur par défaut :false

Description : En mode ligne de commande, cette option forcera aptitude à ignorer
l'installation des paquets non sûrs. C'est un synonyme de Apt::Get::
AllowUnauthenticated.

Option :Aptitude::CmdLine::Package-Display-Format

Valeur par défaut :%c%a%M %p# - %d#

Description : C'est une chaîne de format, comme celles décrites dans la section
intitulée « Personnaliser la manière d'afficher les paquets », qui est utilisée
pour afficher le résultat d'une recherche en ligne de commande. C'est équivalent
à l'option -F de la ligne de commande.

Option :Aptitude::CmdLine::Package-Display-Width

Valeur par défaut :

Description : Cette option donne la largeur en caractères avec laquelle les
résultats des recherches en ligne de commande doivent être formatées. Une chaîne
vide (la valeur par défaut, c'est-à-dire "") indique que les résultats des
recherches sont formatés pour la taille du terminal actuel ou pour un affichage
de 80 colonnes si la taille ne peut pas être déterminée.

Option :Aptitude::CmdLine::Progress::Percent-On-Right

Valeur par défaut :false

Description : Cette option contrôle si les indicateurs de progression en ligne
de commande affichent le pourcentage à gauche de l'écran, comme apt-get, ou à
droite (comportement par défaut). Cette option n'influe pas sur les indicateurs
de progression de téléchargement.

Option :Aptitude::CmdLine::Progress::Retain-Completed

Valeur par défaut :false

Description : Si cette variable a la valeur false, alors les indicateurs de
progression en ligne de commande seront effacés et recouverts une fois que la
tâche qu'ils représentent est terminée. Si la valeur est true, ils resteront
affichés sur le terminal. Cette option n'influe pas sur les indicateurs de
progression de téléchargement.

Option :Aptitude::CmdLine::Request-Strictness

Valeur par défaut :10000

Description : En mode ligne de commande, si des problèmes de dépendances sont
rencontrés, aptitude ajoutera cette valeur au score, donné par le solveur de
dépendances, de toute action que vous demandez explicitement.

Option :Aptitude::CmdLine::Resolver-Debug

Valeur par défaut :false

Description : En mode ligne de commande, si cette option vaut true, aptitude
affichera énormément d'informations pendant les tentatives de résolutions de
dépendances cassées. Comme le nom le suggère, cette option est principalement
destinée à aider au débogage du solveur de dépendances.

Option :Aptitude::CmdLine::Resolver-Dump

Valeur par défaut :

Description : En mode ligne de commande, s'il est nécessaire de résoudre des
dépendances cassées et que cette option contient le nom d'un fichier dans lequel
il est possible d'écrire, l'état du solveur est écrit dans ce fichier avant
d'entreprendre toute résolution.

Option :Aptitude::CmdLine::Resolver-Show-Steps

Valeur par défaut :false

Description : Quand cette option vaut true, une solution au problème de
dépendances sera affichée comme une suite de dépendances individuelles. Par
exemple, « wesnoth depends upon wesnoth-data (= 1.2.4-1) -> installing wesnoth-
data 1.2.4-1 (unstable) ».

Option :Aptitude::CmdLine::Show-Deps

Valeur par défaut :false

Description : En mode ligne de commande, si cette option vaut true, aptitude
affichera un résumé des dépendances (s'il y en a) liées à l'état d'un paquet.
C'est équivalent à l'option -D de la ligne de commande.

Option :Aptitude::CmdLine::Show-Size-Changes

Valeur par défaut :false

Description : En mode ligne de commande, si cette option vaut true, aptitude
affichera les changements attendus de l'espace disque utilisé par chaque paquet.
C'est équivalent à l'option -Z de la ligne de commande.

Option :Aptitude::CmdLine::Why-Display-Mode

Valeur par défaut :no-summary

Description : Cette option détermine la valeur par défaut de l'argument en ligne
de commande --show-summary. Consultez la documentation de --show-summary pour
une liste des valeurs permises pour cette option et leur signification.

Option :Aptitude::CmdLine::Show-Versions

Valeur par défaut :false

Description : En mode ligne de commande, si cette option vaut true, aptitude
affichera la version d'un paquet qui est sur le point d'être installé ou
supprimé. C'est équivalent à l'option -V de la ligne de commande.

Option :Aptitude::CmdLine::Show-Why

Valeur par défaut :false

Description : En mode ligne de commande, si cette option vaut true, aptitude
affichera les paquets installés manuellement qui dépendent de chaque paquet
installé automatiquement, ou bien les paquets installés manuellement qui sont en
conflit avec chaque paquet automatiquement supprimé. Cela est équivalent à
l'option en ligne de commande -W, et affiche la même information que celle à
laquelle vous avez accès par la commande aptitude why ou en appuyant sur i dans
la liste des paquets.

Option :Aptitude::CmdLine::Version-Display-Format

Valeur par défaut :%c%a%M %p# %t %i

Description : C'est une chaîne de format, comme celles décrites dans la section
intitulée « Personnaliser la manière d'afficher les paquets », qui est utilisée
pour afficher la sortie de la commande aptitude versions. C'est équivalent à
l'option -F de la ligne de commande.

Option :Aptitude::CmdLine::Versions-Show-Package-Names

Valeur par défaut : Cette variable peut prendre les valeurs always, auto, ou
never pour contrôler lorsque les noms de paquets sont affichés dans la sortie de
la commande aptitude versions. C'est équivalent à l'option en ligne de commande
--show-package-names. Consultez sa documentation pour plus d'informations sur la
signification de ces valeurs.

Option :Aptitude::Safe-Resolver::Show-Resolver-Actions

Valeur par défaut :false

Description : Si cette option est activée, alors lorsque le solveur de
dépendances « sûr » a été activé avec --safe-resolver ou parce que l'action en
ligne de commande est safe-upgrade, un résumé des actions entreprises par le
solveur sera affiché avant l'aperçu d'installation. C'est équivalent à l'option
en ligne de commande --show-resolver-actions.

Option :Aptitude::Screenshot::IncrementalLoadLimit

Valeur par défaut :16384

Description : Taille minimale en octet à partir de laquelle aptitude commencera
à afficher des captures d'écran de manière incrémentale. En dessous de cette
taille, les captures d'écran n'apparaîtront pas avant d'avoir été chargées
complètement.

Option :Aptitude::Screenshot::Cache-Max

Valeur par défaut :4194304

Description : Nombre maximal d'octets de données de capture d'écran qu'aptitude
stockera en mémoire pour les captures d'écran qui ne sont pas actuellement
affichées. La valeur par défaut est 4 mégaoctets.

Option :Aptitude::CmdLine::Simulate

Valeur par défaut :false

Description : Cette option est désuète. Utilisez Aptitude::Simulate à la place.
En mode ligne de commande, si cette option est activée, aptitude affiche
uniquement les actions qui seraient effectuées sur les paquets (plutôt que de
les effectuer réellement). Dans l'interface visuelle, si cette option est
activée, aptitude démarre en mode lecture seule, indépendamment du fait que vous
avez ou non les droits du superutilisateur. C'est équivalent à l'option -s de la
ligne de commande.

Option :Aptitude::CmdLine::Verbose

Valeur par défaut :0

Description : Cette option contrôle le niveau de verbosité du mode ligne de
commande d'aptitude. Chaque occurrence de l'option -v sur la ligne de commande
ajoute 1 à cette valeur.

Option :Aptitude::CmdLine::Visual-Preview

Valeur par défaut :false

Description : Si cette option vaut true, aptitude va entrer dans le mode
graphique pour afficher l'aperçu du processus d'installation et pour télécharger
les paquets.

Option :Aptitude::Delete-Unused

Valeur par défaut :true

Description : Si cette option vaut true, les paquets automatiquement installés
qui ne sont plus nécessaires seront automatiquement supprimés. Pour plus
d'informations, consultez la section intitulée « Gérer les paquets
automatiquement installés ».

Option :Aptitude::Delete-Unused-Pattern

Valeur par défaut :

Description : Synonyme désuet pour Aptitude::Keep-Unused-Pattern. Si Aptitude::
Keep-Unused-Pattern n'est pas paramétrée ou paramétrée avec une chaîne vide, la
valeur de cette option de configuration va la supplanter. Sinon Aptitude::
Delete-Unused-Pattern est ignorée.

Option :Aptitude::Display-Planned-Action

Valeur par défaut :true

Description : Si cette option vaut true, aptitude affichera un aperçu
d'installation avant d'exécuter réellement les actions que vous avez demandées.

Option :Aptitude::Forget-New-On-Install

Valeur par défaut :false

Description : Si cette option vaut true, aptitude videra la liste des nouveaux
paquets à chaque fois que vous installez, mettez à jour ou supprimez des
paquets, comme si vous aviez exécuté la commande Actions → Oublier quels paquets
sont nouveaux (f).

Option :Aptitude::Forget-New-On-Update

Valeur par défaut :false

Description : Si cette option est mise à true, aptitude videra la liste des
nouveaux paquets à chaque fois que la liste des paquets est mise à jour, comme
si vous aviez exécuté la commande Actions → Oublier quels paquets sont nouveaux
(f).

Option :Aptitude::Get-Root-Command

Valeur par défaut :su:/bin/su

Description : Cette option définit la commande externe qu'aptitude utilisera
pour devenir superutilisateur (consultez la section intitulée « Devenir
administrateur (« root ») »). Cette option est de la forme protocole:commande.
protocole doit être soit su ou sudo. Elle détermine comment aptitude utilise le
programme quand il veut obtenir les droits du superutilisateur. Si le protocole
est su, alors commande -c arguments sera utilisée pour devenir superutilisateur.
Dans le cas contraire, aptitude utilise commande arguments. Le premier mot de
commande est le nom du programme qui doit être utilisé, les mots restants sont
traités comme étant les arguments de ce programme.

Option :Aptitude::Ignore-Old-Tmp

Valeur par défaut :false

Description : Les anciennes versions d'aptitude créaient un répertoire
~/.aptitude/.tmp qui n'est plus nécessaire. Si ce répertoire existe et
Aptitude::Ignore-Old-Tmp a la valeur true, aptitude vous demandera s'il faut le
supprimer. Cette option a automatiquement la valeur true une fois que vous avez
répondu. D'autre part, si ce répertoire n'existe pas, cette option prend la
valeur false et vous seriez averti si ce répertoire venait à réapparaître.

Option :Aptitude::Ignore-Recommends-Important

Valeur par défaut :false

Description : Dans les versions précédentes d'aptitude, le réglage Aptitude::
Recommends-Important entraînait l'installation automatique des recommandations,
de la même façon que Apt::Install-Recommends le fait aujourd'hui. Si la valeur
false est affectée à cette option, ainsi qu'à Aptitude::Recommends-Important,
aptitude attribuera à Apt::Install-Recommends la valeur false et à Aptitude::
Ignore-Recommends-Important la valeur true au démarrage.

Option :Aptitude::Keep-Recommends

Valeur par défaut :false

Description : Cette option est obsolète. Utilisez Apt::AutoRemove::
RecommendsImportant à la place. Attribuer à cette option la valeur true a le
même effet qu'attribuer à Apt::AutoRemove::RecommendsImportant la valeur true.

Option :Aptitude::Keep-Suggests

Valeur par défaut :false

Description : Cette option est obsolète. Utilisez Apt::AutoRemove::
SuggestsImportant à la place. Attribuer à cette option la valeur true a le même
effet qu'attribuer à Apt::AutoRemove::SuggestsImportant la valeur true.

Option :Aptitude::Keep-Unused-Pattern

Valeur par défaut :

Description : Si Aptitude::Delete-Unused est à true, seuls les paquets
inutilisés qui ne correspondent pas à ce motif (voir la section intitulée
« Motifs de recherche ») seront supprimés. Si cette option est configurée avec
une chaîne vide (valeur par défaut), tous les paquets inutilisés sont supprimés.

Option :Aptitude::LockFile

Valeur par défaut :/var/lock/aptitude

Description : Un fichier qui sera verrouillé pour assurer qu'au plus une seule
instance d'aptitude ne modifie le cache à la fois. Normalement, vous ne devriez
jamais modifier cette option ; cela peut être utile pour le débogage. Note : si
aptitude affiche un avertissement disant qu'il ne peut obtenir le verrou, ce
n'est pas parce que le fichier verrou a besoin d'être supprimé. Le type de
verrou utilisé (« fcntl ») est géré par le noyau et est retiré un fois que le
programme s'arrête. L'impossibilité d'obtenir le verrou signifie donc qu'un
autre programme l'utilise actuellement.

Option :Aptitude::Log

Valeur par défaut :/var/log/aptitude

Description : Si cette option est une chaîne non vide, aptitude journalisera les
installations, suppressions et mises à jour de paquets qu'il effectue. Si la
valeur de Aptitude::Log commence par le caractère « | », le reste de cette
valeur est utilisé comme nom d'une commande à travers laquelle le journal est
envoyé : par exemple, |mail -s 'Aptitude install run' root enverra le journal au
compte root. Pour journaliser dans plusieurs fichiers ou commandes, vous pouvez
configurer cette option sous la forme d'une liste de cibles pour la
journalisation.

Option :Aptitude::Logging::File

Valeur par défaut :

Description : Si la valeur est une chaîne non vide, aptitude écrira les messages
de journalisation dans un fichier dont le nom correspond à cette chaîne. Si la
valeur de la chaîne est « - », les messages seront affichés sur la sortie
standard. Cela diffère du réglage Aptitude::Log : le fichier utilisé par ce
dernier contient les messages de journalisation pour les installations et les
suppressions, alors que celui-ci est utilisé pour les messages d'événements,
erreurs et débogages (si activé) d'aptitude. Cette option est équivalente au
paramètre en ligne de commande --log-file. Consultez aussi Aptitude::Logging::
Levels.

Option :Aptitude::Logging::Levels

Valeur par défaut :(vide)

Description : Cette option est un groupe dont les éléments contrôlent quels sont
les messages de journalisation à afficher. Chaque entrée est soit un « niveau »,
pour sélectionner le niveau global de journalisation (le niveau de
journalisation du journal racine) à ce niveau, soit de la forme « catégorie:
niveau », où catégorie est une catégorie des messages à modifier (comme
aptitude.resolver.hints.match) et niveau est le niveau de journalisation le plus
bas de cette catégorie à afficher. Les niveaux de journalisation licites sont
« fatal », « error », « warn », « info », « debug » et « trace ». L'option en
ligne de commande --log-level peut être utilisée pour définir ou redéfinir
n'importe quel niveau de journalisation.

Option :Aptitude::Parse-Description-Bullets

Valeur par défaut :true

Description : Si cette option est activée, aptitude essaiera de détecter
automatiquement les listes dans les descriptions de paquets. Cela améliore
généralement l'affichage des descriptions, mais le formatage des descriptions
d'anciens paquets pourrait être moins bon quand cette option a la valeur true
plutôt que false.

Option :Aptitude::Pkg-Display-Limit

Valeur par défaut :

Description : Filtre par défaut s'appliquant à la liste des paquets. Consultez
la section intitulée « Motifs de recherche » pour plus de détails sur son
format.

Option :Aptitude::ProblemResolver::Allow-Break-Holds

Valeur par défaut :false

Description : Si cette option vaut true, le solveur considérera la possibilité
de casser le figeage de paquets ou d'installer des versions interdites afin de
résoudre une dépendance. Si la valeur est false, ces actions seront rejetées par
défaut, bien qu'il soit possible de les sélectionner manuellement (consultez la
section intitulée « Résolution interactive des dépendances »).

Option :Aptitude::ProblemResolver::BreakHoldScore

Valeur par défaut :-300

Description : Nombre de points ajoutés ou retranchés aux solutions qui changent
l'état d'un paquet figé ou qui installent une version interdite. Notez qu'à
moins que l'option Aptitude::ProblemResolver::Allow-Break-Holds prenne la valeur
true, le solveur ne changera pas l'état d'un paquet figé et n'installera pas de
versions interdites sans l'autorisation explicite de l'utilisateur.

Option :Aptitude::ProblemResolver::Break-Hold-Level

Valeur par défaut :50000

Description : Coût de sécurité assigné aux actions qui cassent un figeage défini
par l'utilisateur (en mettant à jour un paquet figé ou en installant une version
interdite d'un paquet). Consultez la section intitulée « Coût de sécurité » pour
une description des coûts de sécurité.

Option :Aptitude::ProblemResolver::BrokenScore

Valeur par défaut :-100

Description : Nombre de points ajoutés ou retranchés aux solutions potentielles
en se basant sur le nombre de dépendances qu'ils cassent. Pour chaque dépendance
cassée par une solution possible, ce nombre de points est ajouté à son score.
Généralement, il s'agit de points négatifs.

Option :Aptitude::ProblemResolver::DefaultResolutionScore

Valeur par défaut :400

Description : Nombre de points à ajouter ou à enlever au score des propositions
de solutions en fonction du nombre de résolutions « par défaut » qu'elles
installent pour les dépendances actuellement non satisfaites. Une résolution par
défaut est une résolution que la commande « apt-get install » ou le « solveur
immédiat de dépendances » choisiraient. Le score n'est appliqué que pour les
dépendances et les recommandations dont les cibles ne sont pas encore
installées.

Option :Aptitude::ProblemResolver::Discard-Null-Solution

Valeur par défaut :true

Description : Si cette option vaut true, aptitude ne suggérera jamais d'annuler
toutes les actions que vous aviez prévues pour résoudre un problème de
dépendances.

Option :Aptitude::ProblemResolver::EssentialRemoveScore

Valeur par défaut :-100000

Description : Nombre de points ajoutés ou retirés au score des solutions
supprimant un paquet « essentiel ».

Option :Aptitude::ProblemResolver::Remove-Essential-Level

Valeur par défaut :60000

Description : Coût de sécurité attribué aux actions qui suppriment des paquets
essentiels. Consultez la section intitulée « Coût de sécurité » pour une
description des coûts de sécurité.

Option :Aptitude::ProblemResolver::ExtraScore

Valeur par défaut :-1

Description : Ce nombre de points sera ajouté au score de toute version d'un
paquet dont la priorité est « extra ».

Option :Aptitude::ProblemResolver::FullReplacementScore

Valeur par défaut :500

Description : Nombre de points associé à l'action de supprimer un paquet et en
installer un autre qui le remplace complètement (c'est-à-dire qui est conflit,
remplace et fournit celui-ci).

Option :Aptitude::ProblemResolver::FutureHorizon

Valeur par défaut :50

Description : Nombre d'« étapes » que le solveur doit effectuer après avoir
trouvé la première solution. Bien qu'aptitude tente de générer d'abord les
meilleures solutions, il échoue parfois dans cette tâche. Ce réglage force le
solveur à continuer brièvement à chercher une meilleure solution avant
d'afficher ses résultats, plutôt que de s'arrêter immédiatement après la
première solution trouvée.

Option :Aptitude::ProblemResolver::Hints

Valeur par défaut :(vide)

Description : Cette option est un groupe dont les éléments sont des indicateurs
utilisés pour configurer le solveur de dépendances. Chaque élément du groupe est
une chaîne de caractères décrivant une action qui doit être appliquée à un ou
plusieurs paquets. La syntaxe pour chaque indicateur ainsi que l'effet d'un tel
indicateur sont décrits dans la section intitulée « Configuration des
indicateurs du solveur ».

Option :Aptitude::ProblemResolver::ImportantScore

Valeur par défaut :5

Description : Ce nombre de points sera ajouté au score de toute version d'un
paquet dont la priorité est « important ».

Option :Aptitude::ProblemResolver::Infinity

Valeur par défaut :1000000

Description : Score « maximum », surnommé infini, pour les solutions
potentielles : si un ensemble d'actions à un score pire que -infini, il sera
écarté immédiatement.

Option :Aptitude::ProblemResolver::InstallScore

Valeur par défaut :-20

Description : Nombre de points que le solveur de dépendances devrait donner à
l'installation d'un paquet, s'il n'est pas déjà prévu de l'installer.

Option :Aptitude::ProblemResolver::Keep-All-Level

Valeur par défaut :20000

Description : Coût de sécurité attribué à la solution qui annule toutes les
actions sélectionnées par l'utilisateur. Consultez la section intitulée « Coût
de sécurité » pour une description des coûts de sécurité.

Option :Aptitude::ProblemResolver::KeepScore

Valeur par défaut :0

Description : Nombre de points que le solveur devrait donner pour garder un
paquet dans son état actuel, s'il n'est pas déjà prévu de garder ce paquet dans
son état courant.

Option :Aptitude::ProblemResolver::NonDefaultScore

Valeur par défaut :-40

Description : Nombre de points que le solveur de dépendances devrait donner à
l'installation d'une version d'un paquet autre que celle par défaut (une qui
n'est ni la version actuelle, ni la « version candidate »).

Option :Aptitude::ProblemResolver::Non-Default-Level

Valeur par défaut :50000

Description : Coût de sécurité attribué aux actions qui installent des versions
d'un paquet autres que celle par défaut. Par exemple, si la version 5 d'un
paquet est installée, que les versions 6, 7 et 8 sont disponibles, et que la
version 7 est la version par défaut, l'installation des versions 6 et 8 auront
un coût de sécurité qui sera au moins égal à cette quantité. Consultez la
section intitulée « Coût de sécurité » pour une description des coûts de
sécurité.

Option :Aptitude::ProblemResolver::OptionalScore

Valeur par défaut :1

Description : Ce nombre de points sera ajouté au score de toute version d'un
paquet dont la priorité est « optionnel ».

Option :Aptitude::ProblemResolver::PreserveAutoScore

Valeur par défaut :0

Description : Nombre de points que le solveur de dépendances devrait donner à la
préservation des installations et suppressions automatiques.

Option :Aptitude::ProblemResolver::PreserveManualScore

Valeur par défaut :60

Description : Nombre de points que le solveur de dépendances devrait donner à la
préservation des actions explicitement sélectionnées par l'utilisateur.

Option :Aptitude::ProblemResolver::RemoveScore

Valeur par défaut :-300

Description : Nombre de points que le solveur de problème devrait donner à la
suppression d'un paquet s'il n'est pas déjà marqué pour suppression.

Option :Aptitude::ProblemResolver::Remove-Level

Valeur par défaut :10000

Description : Coût de sécurité attribué aux actions qui suppriment un paquet.
Consultez la section intitulée « Coût de sécurité » pour une description des
coûts de sécurité.

Option :Aptitude::ProblemResolver::RequiredScore

Valeur par défaut :4

Description : Nombre de points ajouté au score de toute version d'un paquet dont
la priorité est « requis ».

Option :Aptitude::ProblemResolver::ResolutionScore

Valeur par défaut :50

Description : Bonus récompensant, en dehors de tout autre facteur, les solutions
potentielles qui résolvent toutes les dépendances non satisfaites.

Option :Aptitude::ProblemResolver::Safe-Level

Valeur par défaut :10000

Description : Coût de sécurité attribué aux actions qui installent la version
par défaut, mettent à jour un paquet à sa version par défaut, ou annulent
l'installation ou la mise à jour d'un paquet. Les solutions avec ce coût peuvent
être engendrées par aptitude safe-upgrade. Consultez la section intitulée « Coût
de sécurité » pour une description des coûts de sécurité.

Option :Aptitude::ProblemResolver::SolutionCost

Valeur par défaut :safety,priority

Description : Description de la façon dont le coût d'une solution est déterminé.
Consultez la section intitulée « Coûts dans la résolution interactive de
dépendances » pour une description de ce que sont les coûts des solutions, leurs
effets et la syntaxe utilisée pour les préciser. Si la valeur de cette option ne
peut être analysée, une erreur est déclenchée et le coût par défaut est utilisé
à la place.

Option :Aptitude::ProblemResolver::StandardScore

Valeur par défaut :3

Description : Nombre de points ajouté au score de toute version d'un paquet dont
la priorité est « standard ».

Option :Aptitude::ProblemResolver::StepLimit

Valeur par défaut :5000

Description : Nombre maximum d'« étapes » qui peuvent être accomplies par le
solveur de dépendances à chaque tentative de recherche d'une solution à un
problème de dépendances. Diminuer ce nombre va faire qu'aptitude « abandonnera »
plus rapidement. L'augmenter permettra aux recherches de solution de prendre
plus de temps et de mémoire avant d'abandonner. Donner à StepLimit la valeur 0
désactivera complètement le solveur. La valeur par défaut est assez grande pour
faire face aux situations courantes, tout en évitant que le programme
« n'explose » face à un problème trop complexe. Veuillez noter que cela
n'affecte que la recherche en ligne de commande ; dans l'interface visuelle, le
solveur continuera à fonctionner jusqu'à ce qu'il trouve une solution.

Option :Aptitude::ProblemResolver::StepScore

Valeur par défaut :70

Description : Nombre de points ajouté ou retranché aux solutions potentielles en
se basant sur leur longueur. Ce nombre de points est ajouté au score de chaque
action comprise dans une solution. Plus cette valeur est grande, plus
l'algorithme essaie de favoriser le premier choix plutôt que de s'orienter vers
une alternative. Cela permettra d'obtenir plus rapidement une solution, mais qui
risque d'être de qualité moindre à ce qu'elle aurait pu être.

Option :Aptitude::ProblemResolver::Trace-Directory

Valeur par défaut :

Description : Si cette variable est définie, à chaque fois que le solveur
produit une solution, une version minimale du fichier de l'état des paquets
suffisante pour reproduire la solution est écrite dans le fichier indiqué. Si
Aptitude::ProblemResolver::Trace-File est aussi définie, la même information
sera aussi écrite dans le fichier de trace. Les répertoires de trace sont plus
transparents que les fichiers de trace, et conviennent mieux pour par exemple
l'inclusion dans des tests dans l'arborescence source.

Option :Aptitude::ProblemResolver::Trace-File

Valeur par défaut :

Description : Si cette variable est définie, à chaque fois que le solveur
produit une solution, une version minimale du fichier de l'état des paquets
suffisante pour reproduire la solution est écrite dans le fichier indiqué. Si
Aptitude::ProblemResolver::Trace-Directory est aussi définie, la même
information sera aussi écrite dans le répertoire de trace. Un fichier de trace
est simplement une archive compressée d'un répertoire de trace : il prendra
moins de place qu'un répertoire de trace et convient pour la transmission par le
réseau.

Option :Aptitude::ProblemResolver::UndoFullReplacementScore

Valeur par défaut :-500

Description : Nombre de points attribué à l'installation d'un paquet et la
suppression d'un paquet qui le remplace complètement (c'est-à-dire qui est en
conflit avec, remplace et fournit celui-ci).

Option :Aptitude::ProblemResolver::UnfixedSoftScore

Valeur par défaut :-200

Description : Nombre de points ajouté ou retranché aux solutions potentielles
qui laissent une recommandation (champ « Recommande ») non satisfaite. Il est
généralement plus petit que « RemoveScore », car sinon aptitude pourrait
supprimer des paquets plutôt que de laisser leurs recommandations non
satisfaites. Consultez la section intitulée « Résolution interactive des
dépendances » pour plus de détails.

Option :Aptitude::ProblemResolver::UpgradeScore

Valeur par défaut :0

Description : Nombre de points attribué par la mise à jour à la version
candidate (ultérieure ou antérieure à la version actuelle) d'un paquet si celui-
ci n'est pas déjà sélectionné pour une mise à jour.

Option :Aptitude::Purge-Unused

Valeur par défaut :false

Description : Si cette option vaut true et si Aptitude::Delete-Unused a aussi la
valeur true, les paquets qui ne sont plus utilisés seront purgés du système, en
supprimant leurs fichiers de configuration et peut-être des données importantes.
Pour plus d'informations sur les paquets considérés comme « inutilisés »,
consultez la section intitulée « Gérer les paquets automatiquement installés ».
CETTE OPTION PEUT ENTRAÎNER DES PERTES DE DONNÉES ! NE L'ACTIVEZ QUE SI VOUS
SAVEZ CE QUE VOUS FAITES !

Option :Aptitude::Recommends-Important

Valeur par défaut :true

Description : Option de configuration obsolète remplacée par Apt::Install-
Recommends. Au démarrage, aptitude copiera Aptitude::Recommends-Important (si
elle est définie) vers Apt::Install-Recommends et effacera Aptitude::Recommends-
Important du fichier de configuration de l'utilisateur.

Option :Aptitude::Safe-Resolver::No-New-Installs

Valeur par défaut :false

Description : Si la valeur true est affectée à cette option, alors lorsque le
solveur de dépendances « sûr » sera activé avec l'option --safe-resolver ou en
utilisant l'action en ligne de commande safe-upgrade, le solveur ne sera pas
autorisé à installer des paquets qui ne le sont pas encore.

Option :Aptitude::Safe-Resolver::No-New-Upgrades

Valeur par défaut :false

Description : Si la valeur true est affectée à cette option, alors lorsque le
solveur de dépendances « sûr » sera activé avec l'option --safe-resolver ou en
utilisant l'action en ligne de commande safe-upgrade, le solveur ne sera pas
autorisé à résoudre des dépendances en mettant à jour des paquets.

Option :Aptitude::Sections::Descriptions

Valeur par défaut :Consultez $prefix/share/aptitude/section-descriptions

Description : Cette option est un groupe dont les éléments définissent les
descriptions affichées pour chaque section lorsque la politique de regroupement
de paquet « section » est utilisée. Les descriptions sont attribuées aux arbres
de sections en se basant sur la dernière composante du nom : par exemple, un
élément de ce groupe nommé « games » sera utilisé pour décrire les sections
« games », « non-free/games » et « non-free/desktop/games ». Au sein du texte
des descriptions de sections, la chaîne « \n » sera remplacée par un saut de
ligne et la chaîne « '' » sera remplacé par le caractère de guillemets doubles.

Option :Aptitude::Sections::Top-Sections

Valeur par défaut :"main"; "contrib"; "non-free"; "non-US";

Description : Un groupe de configuration dont les éléments sont les noms des
sections de plus bas niveau de l'archive. Les politiques de regroupement
« topdir », « subdir » et « subdirs » utilisent cette liste pour interpréter les
champs Section : si le premier élément du chemin du champ Section d'un paquet
n'est pas contenu dans cette liste, ou si son champ Section ne comporte qu'un
seul élément, alors le paquet sera regroupé en utilisant le premier élément de
cette liste comme premier élément du chemin. Par exemple, si le premier élément
de Top-Sections est « main », alors un paquet dont le champ Section est « games/
arcade » sera traité comme si son champ Section était « main/games/arcade ».

Option :Aptitude::Simulate

Valeur par défaut :false

Description : En mode ligne de commande, afficher la liste des actions qui
seraient réalisées, plutôt que de les exécuter réellement. Dans l'interface
visuelle, démarrer aptitude en mode lecture seule, que l'on ait les droits du
superutilisateur ou non. C'est équivalent à l'option -s de la ligne de commande.

Option :Aptitude::Spin-Interval

Valeur par défaut :500

Description : Nombre de millisecondes d'attente entre la mise à jour de la
« roue » qui apparaît pendant le fonctionnement du solveur.

Option :Aptitude::Suggests-Important

Valeur par défaut :false

Description : Cette option est obsolète. Utilisez Apt::AutoRemove::
SuggestsImportant à la place. Attribuer à cette option la valeur true a le même
effet qu'attribuer à Apt::AutoRemove::SuggestsImportant la valeur true.

Option :Aptitude::Suppress-Read-Only-Warning

Valeur par défaut :false

Description : Si la valeur false est attribuée à cette option, aptitude
affichera un avertissement la première fois que vous essayez de modifier l'état
des paquets alors qu'aptitude est en mode lecture seule.

Option :Aptitude::Theme

Valeur par défaut :

Description : Thème qu'aptitude doit utiliser. Consultez la section intitulée
« Thèmes » pour plus d'informations.

Option :Aptitude::Track-Dselect-State

Valeur par défaut :true

Description : Si cette option vaut true, aptitude essaiera de détecter si un
changement a été apporté à l'état du paquet par l'utilisation de dselect ou
dpkg : par exemple, si vous supprimez un paquet avec dpkg, aptitude n'essaiera
pas de le réinstaller. Notez que cela peut ne pas toujours fonctionner
parfaitement.

Option :Aptitude::UI::Advance-On-Action

Valeur par défaut :false

Description : Si cette option vaut true, changer l'état d'un paquet (par
exemple, le marquer pour installation) basculera la mise en surbrillance vers le
prochain paquet du groupe actuel.

Option :Aptitude::UI::Auto-Show-Reasons

Valeur par défaut :true

Description : Si cette option vaut true, sélectionner un paquet qui est cassé,
ou qui semble avoir cassé d'autres paquets, va entraîner l'affichage dans la
zone d'information des raisons expliquant pourquoi ce paquet est cassé.

Option :Aptitude::UI::Default-Grouping

Valeur par défaut :filter(missing),status,section(subdirs,passthrough),section
(topdir)

Description : Configuration de la politique de regroupement par défaut utilisée
pour la liste des paquets. Consultez la section intitulée « Personnaliser la
hiérarchie des paquets » pour des informations supplémentaires sur les
politiques de regroupement.

Option :Aptitude::UI::Default-Package-View

Valeur par défaut :

Description : Cette option est un groupe dont les membres définissent
l'apparence par défaut de l'affichage d'aptitude. Consultez la section intitulée
« Personnaliser la disposition de l'affichage » pour plus d'informations.

Option :Aptitude::UI::Default-Preview-Grouping

Valeur par défaut :action

Description : Configuration de la politique de regroupement par défaut utilisée
pour les écrans d'aperçu. Consultez la section intitulée « Personnaliser la
hiérarchie des paquets » pour des informations supplémentaires sur les
politiques de regroupement.

Option :Aptitude::UI::Default-Sorting

Valeur par défaut :name

Description : Configure la politique de tri par défaut des vues de paquets.
Consultez la section intitulée « Personnaliser la manière de trier les paquets »
pour plus d'informations.

Option :Aptitude::UI::Description-Visible-By-Default

Valeur par défaut :true

Description : Quand une liste de paquets est affichée pour la première fois, la
zone d'information (qui contient généralement la description longue du paquet
courant) sera visible si cette option vaut true et cachée si elle vaut false.

Option :Aptitude::UI::Exit-On-Last-Close

Valeur par défaut :true

Description : Si cette option vaut true, fermer toutes les vues actives quittera
aptitude. Sinon, aptitude ne quittera pas avant que vous exécutiez la commande
Actions → Quitter (Q). Consultez la section intitulée « Travailler avec
plusieurs vues » pour plus d'informations.

Option :Aptitude::UI::Fill-Text

Valeur par défaut :false

Description : Si cette option vaut true, aptitude formatera les lignes pour
qu'elles occupent exactement la largeur de l'écran.

Option :Aptitude::UI::Flat-View-As-First-View

Valeur par défaut :false

Description : Si cette option prend la valeur true, aptitude affichera une vue
plate au démarrage au lieu de la vue par défaut.

Option :Aptitude::UI::HelpBar

Valeur par défaut :true

Description : Si cette option prend la valeur true, une ligne d'information sur
les raccourcis clavier importants est affichée en haut de l'écran.

Option :Aptitude::UI::Incremental-Search

Valeur par défaut :true

Description : Si cette option prend la valeur true, aptitude effectuera des
recherches « incrémentales » : pendant que vous tapez le motif de recherche, il
cherchera le paquet suivant qui correspond à ce que vous avez tapé jusque là.

Option :Aptitude::UI::InfoAreaTabs

Valeur par défaut :false

Description : Si cette option prend la valeur true, aptitude affichera des
onglets en haut de la zone d'informations (le panneau en bas de l'écran)
décrivant les différents modes dans lesquels peut être cette zone.

Option :Aptitude::UI::Keybindings

Valeur par défaut :

Description : C'est un groupe de configuration dont les membres définissent les
relations entre séquences de touches et commandes dans aptitude. Pour plus
d'informations, consultez la section intitulée « Personnaliser les raccourcis
clavier ».

Option :Aptitude::UI::Menubar-Autohide

Valeur par défaut :false

Description : Si cette option prend la valeur true, la barre de menu sera cachée
lorsqu'elle ne sera pas utilisée.

Option :Aptitude::UI::Minibuf-Download-Bar

Valeur par défaut :false

Description : Si cette option prend la valeur true, aptitude utilisera un
mécanisme plus discret pour afficher l'avancement des téléchargements : une
barre en bas de l'écran apparaîtra pour afficher l'état actuel du
téléchargement. Lorsqu'un téléchargement est actif, appuyer sur q l'annulera.

Option :Aptitude::UI::Minibuf-Prompts

Valeur par défaut :false

Description : Si cette option prend la valeur true, certaines questions (comme
les questions oui/non ou à choix multiples) seront affichées en bas de l'écran
plutôt que dans une boîte de dialogue.

Option :Aptitude::UI::New-Package-Commands

Valeur par défaut :true

Description : Si cette option prend la valeur false, des commandes comme Paquet
→ Installer (+) auront le comportement obsolète qu'elles avaient dans
d'anciennes versions d'aptitude.

Option :Aptitude::UI::Package-Display-Format

Valeur par défaut :%c%a%M %p %Z %v %V

Description : Cette option contrôle la chaîne de format utilisée pour afficher
les paquets dans les listes de paquets. Pour plus d'informations sur les chaînes
de format, consultez la section intitulée « Personnaliser la manière d'afficher
les paquets ».

Option :Aptitude::UI::Package-Header-Format

Valeur par défaut :%N %n #%B %u %o

Description : Cette option contrôle la chaîne de format utilisée pour afficher
la ligne d'en-tête de la liste des paquets (c'est-à-dire la ligne qui apparaît
entre la liste de paquets et la barre de menu). Pour plus d'informations sur les
chaînes de format, consultez la section intitulée « Personnaliser la manière
d'afficher les paquets ».

Option :Aptitude::UI::Package-Status-Format

Valeur par défaut :%d

Description : Cette option contrôle la chaîne de format utilisée pour afficher
la ligne d'état de la liste des paquets (c'est-à-dire la ligne qui apparaît
entre la liste de paquets et la zone d'information). Pour plus d'informations
sur les chaînes de format, consultez la section intitulée « Personnaliser la
manière d'afficher les paquets ».

Option :Aptitude::UI::Pause-After-Download

Valeur par défaut :OnlyIfError

Description : Si cette option prend la valeur true, après avoir fini de
télécharger les paquets, aptitude affichera un message demandant si vous
souhaitez continuer l'installation. Si cette option est à OnlyIfError, un
message ne sera affiché qu'en cas d'échec du téléchargement. Si cette option
vaut false, aptitude enchaînera immédiatement avec l'écran suivant à la fin du
téléchargement.

Option :Aptitude::UI::Preview-Limit

Valeur par défaut :

Description : Filtre par défaut appliqué à l'écran de prévisualisation.
Consultez la section intitulée « Motifs de recherche » pour des détails sur son
format.

Option :Aptitude::UI::Prompt-On-Exit

Valeur par défaut :true

Description : Si cette option vaut true, aptitude affichera une demande de
confirmation avant de quitter.

Option :Aptitude::UI::Styles

Valeur par défaut :

Description : Groupe de configuration dont le contenu définit les styles
textuels utilisés par aptitude pour afficher l'information. Pour plus
d'informations, consultez la section intitulée « Personnaliser la couleur du
texte et les styles ».

Option :Aptitude::UI::ViewTabs

Valeur par défaut :true

Description : Si cette option vaut false, aptitude n'affichera pas le bandeau
listant les vues actuellement actives en haut de l'écran.

Option :Aptitude::Warn-Not-Root

Valeur par défaut :true

Description : Si cette option vaut true, aptitude détectera quand vous avez
besoin des privilèges d'administration et vous demandera si vous souhaitez
passer sous le compte administrateur (root) si vous ne l'êtes pas déjà.
Consultez la section intitulée « Devenir administrateur (« root ») » pour plus
d'informations.

Option :DebTags::Vocabulary

Valeur par défaut :/usr/share/debtags/vocabulary

Description : Emplacement du fichier de vocabulaire de debtags utilisé pour
charger les métadonnées des marqueurs du paquet.

Option :Dir::Aptitude::state

Valeur par défaut :/var/lib/aptitude

Description : Répertoire dans lequel les informations d'état persistant
d'aptitude sont conservées.

Option :Quiet

Valeur par défaut :0

Description : Cette option contrôle le niveau de silence de la ligne de
commande. La paramétrer à un niveau plus important désactive davantage les
indicateurs d'avancement.


Thèmes

Dans aptitude, un thème est juste un ensemble d'options de configuration. Les
thèmes sont utilisés pour venir recouvrir les valeurs par défaut de certaines
options. Si une option n'est pas configurée dans le fichier de configuration du
système ou dans votre fichier de configuration personnel, aptitude utilisera les
valeurs des options provenant du thème actuel, s'il y en a un de disponible,
avant d'utiliser les valeurs par défaut standard.

Un thème est simplement un groupe nommé sous Aptitude::Themes dont chacune des
options de configuration recouvrira l'option correspondante de la configuration
globale. Par exemple, si le thème Dselect est sélectionné, l'option Aptitude::
Themes::Dselect::Aptitude::UI::Package-Display-Format recouvrira la valeur par
défaut de l'option Aptitude::UI::Package-Display-Format.

Pour sélectionner un thème, donnez le nom du thème comme valeur de l'option de
configuration d'Aptitude::Theme. Par exemple :

Aptitude::Theme Vertical-Split;

Les thèmes suivants sont fournis avec aptitude dans /usr/share/aptitude/
aptitude-defaults :



  Dselect
      Ce thème donne à aptitude une apparence et un comportement proche du
      vénérable gestionnaire de paquet dselect :

      Actions  Annuler  Paquet  Rechercher  Options  Vues  Aide
      f10 : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr.
      Pqts
      --\ Paquets installés
        --\ Priorité : nécessaire
          --\ base - Le système de base Debian
      c   base  base-file 3.1         3.1         Debian base system
      miscellaneous fil
      c   base  base-pass 3.5.7       3.5.7       Debian base system master
      password a
      c   base  bash      3.0-5       3.0-5       The GNU Bourne Again SHell
      c   base  bsdutils  1:2.12-7    1:2.12-7    Basic utilities from 4.4BSD-
      Lite
      c   base  coreutils 5.2.1-2     5.2.1-2     The GNU core utilities
      c   base  debianuti 2.8.4       2.8.4       Miscellaneous utilities
      specific to
      c   base  diff      2.8.1-6     2.8.1-6     File comparison utilities
      base-files                      installé  ; aucun
      nécessair
      This package contains the basic filesystem hierarchy of a Debian system,
      and
      several important miscellaneous files, such as /etc/debian_version,
      /etc/host.conf, /etc/issue, /etc/motd, /etc/profile, /etc/nsswitch.conf,
      and
      others, and the text of several common licenses in use on Debian systems.







  Vertical-Split
      Ce thème arrange l'affichage de manière à ce que la description du paquet
      actuel s'affiche à droite de la liste des paquets plutôt qu'en-dessous de
      cette liste. Ce thème est utile avec des terminaux très larges, et peut-
      être aussi lors de l'édition de la hiérarchie des paquets intégrée.

       Actions  Annuler  Paquet  Rechercher  Options  Vues  Aide
      f10 : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr.
      Pqts
      aptitude 0.2.15.6
      --\ Paquets installés                   Modern computers support the
      Advanced  #
        --\ admin - Utilitaires d'administrat Configuration and Power Interface
          --\ main - L'archive principale de  (ACPI) to allow intelligent power
      i   acpid         1.0.3-19   1.0.3-19   management on your system and to
      query
      i   alien         8.44       8.44       battery and configuration status.
      i   anacron       2.3-9      2.3-9
      i   apt-show-vers 0.07       0.07       ACPID is a completely flexible,
      totally
      i A apt-utils     0.5.25     0.5.25     extensible daemon for delivering
      ACPI
      i   apt-watch     0.3.2-2    0.3.2-2    events. It listens on a file
      i   aptitude      0.2.14.1-2 0.2.14.1-2 (/proc/acpi/event) and when an
      event
      i   at            3.1.8-11   3.1.8-11   occurs, executes programs to
      handle the
      i   auto-apt      0.3.20     0.3.20     event. The programs it executes
      are
      i   cron          3.0pl1-83  3.0pl1-83  configured through a set of
      i   debconf       1.4.29     1.4.29     configuration files, which can be
      i   debconf-i18n  1.4.29     1.4.29     dropped into place by packages or
      by
      i A debootstrap   0.2.39     0.2.39     the admin.
      i A deborphan     1.7.3      1.7.3
      i   debtags       0.16       0.16       In order to use this package you
      need a
      i A defoma        0.11.8     0.11.8     recent Kernel (=>2.4.7). This can
      be
      i   discover      2.0.4-5    2.0.4-5    one including the patches on
      Utilities for using ACPI power management



Jouer au démineur

Au cas où vous seriez fatigué d'installer et supprimer des paquets, aptitude
inclut une version du jeu classique « démineur ». Pour le lancer, sélectionner
Actions → Jouer au démineur. Le plateau initial du démineur apparaîtra alors :

Actions  Annuler  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
Démineur                                                10/10 mines  13 secondes





                                   +--------+
                                   |        |
                                   |        |
                                   |        |
                                   |        |
                                   |        |
                                   |        |
                                   |        |
                                   |        |
                                   +--------+





À l'intérieur du rectangle qui apparaît à l'écran sont cachées dix mines. Votre
but est de déterminer, grâce à votre intuition, votre logique et la chance, où
ces mines se trouvent sans en faire exploser une seule ! Pour ce faire, vous
devez découvrir toutes les cases qui ne contiennent pas de mines. Ce faisant,
vous allez obtenir des informations importantes concernant les cases qui
contiennent des mines. Attention tout de même, découvrir une case qui contient
une mine la fera exploser, mettant fin au jeu immédiatement !

Pour découvrir une case (et savoir si une mine y est cachée), sélectionnez la
case avec les flèches et appuyer sur Entrée :

Actions  Annuler  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
Démineur                                                10/10 mines 387 secondes





                                   +--------+
                                   | 2......|
                                   | 2111...|
                                   |    1...|
                                   | 1111...|
                                   |11...111|
                                   |...113  |
                                   |1122    |
                                   |        |
                                   +--------+





Comme vous pouvez le voir, une partie de la zone cachée (vide) du plateau a été
révélée dans cette capture d'écran. Les cases contenant un « . » sont les cases
qui ne sont adjacentes à aucune mine. Les chiffres dans les autres cases
indiquent combien de mines se trouventdans les cases adjacentes.

Si vous pensez savoir où une mine se trouve, vous pouvez placer un drapeau sur
celle-ci. Pour faire cela, sélectionner la case suspecte et appuyer sur f. Par
exemple, dans la capture suivante, j'ai décidé que la case sur la partie gauche
de l'écran avait l'air suspecte...

 Actions  Annuler  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
Démineur                                                9/10 mines 961 secondes





                                   +--------+
                                   | 2......|
                                   | 2111...|
                                   |    1...|
                                   |F1111...|
                                   |11...111|
                                   |...113  |
                                   |1122    |
                                   |        |
                                   +--------+





Comme vous pouvez le voir, un F est apparu sur la case sélectionnée. Il n'est
plus possible de découvrir cette case, même accidentellement, jusqu'à ce que le
drapeau soit enlevé (en appuyant à nouveau sur f). Une fois que vous avez placé
un drapeau sur toutes les mines qui sont à côté d'une case (par exemple, les
cases avec un 1 à côté du drapeau au dessus), pour pouvez « faire le ménage »
autour de la case. Ce n'est qu'une facilité pour découvrir toutes les cases
adjacentes (à l'exception de celles contenant un drapeau, bien sûr). Par
exemple, faisons le ménage autour du 1 ci-dessus :

 Actions  Annuler  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
Démineur                                                9/10 mines 2290 secondes





                                   +--------+
                                   | 2......|
                                   | 2111...|
                                   |221 1...|
                                   |F1111...|
                                   |11...111|
                                   |...113  |
                                   |1122    |
                                   |        |
                                   +--------+





Heureusement, ma supposition sur l'emplacement de cette mine était bon. Si
j'avais eu tort, j'aurais perdu immédiatement :

 Actions  Annuler  Paquet  Rechercher  Options  Vues  Aide
f10 : Menu  ? : Aide  q : Quitter  u : M-à-J  g : Téléch./Inst./Suppr. Pqts
Démineur                                         Démineur Perdu en 3878 secondes






                                   +--------+
                                   |^2......|
                                   |^2111...|
                                   |221^1...|
                                   |^1111...|
                                   |11...111|
                                   |...113^ |
                                   |1122* ^ |
                                   | ^ ^   ^|
                                   +--------+





Quand vous avez perdu, l'emplacement de toutes les mines est révélé : les mines
non explosées sont indiquées par un accent circonflexe (^), et celle sur
laquelle vous avez « marché » est indiquée par une astérisque (*).



--------------------------------------------------------------------------------
[7]J'ai plaisir à dire que le nombre de ces requêtes a fortement diminué juste
après la première parution de ce guide. Espérons qu'il y ait un lien entre ces
deux événements.

[8]Cela est parfois appelé « processus d'installation », même s'il se peut que
vous mettiez à jour ou supprimiez des paquets en plus d'en installer.

[9]Comme indiqué plus haut, cela n'indique pas que les paquets dans l'archive
sont sûrs ou non malveillants ; cela montre simplement qu'ils sont d'origine.

[10] Plus précisément, ils seront supprimés quand il n'y aura plus de chemin de
dépendance Depends, PreDepends ou Recommends pour les atteindre depuis un paquet
installé manuellement. Si Apt::AutoRemove::SuggestsImportant est vraie
(« true »), une relation Suggests est alors suffisante pour qu'un paquet soit
conservé.

[11]Ou quand la résolution immédiate est désactivée.

[12]Le paquet avec la plus haute priorité dpkg, non pas la plus haute priorité
d'épinglage.

[13]La limite a été imposée car des structures de coût plus complexes pourraient
rendre difficile l'optimisation du solveur. Les versions futures du programme
pourraient supprimer certaines des restrictions si elles s'avéraient superflues.

[14] aptitude ne traitera la virgule comme un caractère spécial qu'en cas de
présence d'un deuxième argument, donc (par exemple) « ?name(apt,itude) » cherche
la chaîne « apt,itude » dans le champ du nom (« Name ») des paquets.

Bien que ce comportement soit bien défini, il peut surprendre. Il est recommandé
d'utiliser des chaînes entre guillemets pour tous les motifs qui contiennent des
caractères qui pourraient avoir un sens particulier.

[15] Les caractères avec une signification particulière sont : « + », « - »,
« . », « ( », « ) », « | », « [ », « ] », « ^ », « $ » et « ? ». Remarquez que
certains de ceux-ci sont aussi des caractères spéciaux d'aptitude, donc si vous
voulez, par exemple, taper un « | » littéral, il vous faudra le protéger deux
fois : « ?description(\~|) » fera correspondre les paquets dont la description
contient une barre verticale (« | »).

[16] Les séquences d'échappement \\, \n et \t sont également disponibles.

[17] Le lecteur astucieux aura remarqué qu'il s'agit essentiellement d'une façon
de nommer explicitement la variable avec les λ-termes correspondant au terme. Un
terme typique aurait la forme « λ x . name-equals(x, motif) ». Donner une cible
explicite rend x visible dans le langage de recherche.

[18] Principalement fourni par symétrie avec ?true.

[19]Actuellement l'étiquetage n'est pas pris en charge. Cette commande est
destinée à un usage futur.

[20] Sur certains terminaux, un arrière-plan « yellow » (jaune) s'affichera en
brun.



Chapitre 3. Foire aux questions sur aptitude


  « Quel... est ton nom ? »                                                     

   « Arthur, roi des Anglais. »

   « Quelle... est ta quête ? »

   « Je cherche le Saint Graal ! »

   « Quelle... est la vitesse d'une hirondelle à vide ? »

   « Qu'est-ce que vous voulez dire ? Une hirondelle d'Afrique ou d'Europe ? »

   « Euh ? Je ... je n'sais pa--AAAAAAAS ! »

                                                          -- Monty Python, sacré Graal




  3.1. Comment puis-je trouver un paquet par son nom exact ?

  3.2. Comment puis-je trouver les paquets cassés ?

  3.3. Je veux sélectionner du texte. Pourquoi aptitude ne me laisse-t-il pas
  désactiver la souris ?


3.1. Comment puis-je trouver un paquet par son nom exact ?

     Comme signalé dans la section intitulée « Motifs de recherche », quand vous
     recherchez un paquet par son nom, le texte que vous tapez est en fait une
     expression rationnelle. Donc, le motif de recherche « ^nom$ » correspondra
     uniquement au paquet nommé nom.

     Par exemple, vous pouvez rechercher apt (mais pas aptitude ou synaptic) en tapant
     ^apt$. Vous pouvez rechercher g++ (mais pas g++-2.95 ou g++-3.0) en tapant
     ^g\+\+$.

3.2. Comment puis-je trouver les paquets cassés ?

     Utiliser la commande Rechercher → Rechercher les cassés (b).

3.3. Je veux sélectionner du texte. Pourquoi aptitude ne me laisse-t-il pas désactiver
     la souris ?

     Normalement, vous ne pouvez pas sélectionner du texte dans un xterm alors qu'un
     programme (tel qu'aptitude) en fonctionnement dans le terminal utilise la souris.
     Néanmoins, vous pouvez passer outre ce comportement et faire une sélection en
     gardant la touche Maj (Shift) enfoncée.




Chapitre 4. Crédits


  Personne ne se rappelle du chanteur. La chanson reste.  

                       -- Terry Pratchett, Le dernier héros


Cette section garde le souvenir des personnes qui ont contribué à aptitude un
jour ou l'autre.


IMG.alt.suffix Note
  = \[Note]]
               Cette section est pour le moment plutôt incomplète et sera vraisemblablement
               mise à jour et étendue au fur et à mesure (en particulier, il manque de
               nombreux crédits pour les traducteurs du fait du grand nombre des sources de
               traduction[21]). Si vous pensez que vous devriez être dans cette liste,
               veuillez écrire à <dburrows@debian.org> en expliquant pourquoi.


Traduction et internationalisation



  Traduction brésilienne
      Andre Luis Lopes, Gustavo Silva


  Traduction chinoise
      Carlos Z.F. Liu


  Traduction tchèque
      Miroslav Kure


  Traduction danoise
      Morten Brix Pedersen, Morten Bo Johansen


  Traduction néerlandaise
      Luk Claes


  Traduction finnoise
      Jaakko Kangasharju


  Traduction française
      Martin Quinson, Jean-Luc Coulon


  Traduction allemande
      Sebastian Schaffert, Erich Schubert, Sebastian Kapfe, Jens Seidel


  Traduction italienne
      Danilo Piazzalunga


  Traduction japonaise
      Yasuo Eto, Noritada Kobayashi


  Traduction lituanienne
      Darius Žitkevicius


  Traduction polonaise
      Michal Politowski


  Traduction portugaise
      Nuno Sénica, Miguel Figueiredo


  Traduction norvégienne
      Håvard Korsvoll


  Traduction espagnole
      Jordi Malloch, Ruben Porras


  Traduction suédoise
      Daniel Nylander


  Correctif initial d'internationalisation (i18n)
      Masato Taruishi


  Maintenance et tri de l'i18n
      Christian Perrier


Documentation



  Manuel de l'utilisateur
      Daniel Burrows


Programmation



  Conception et mise en œuvre du programme
      Daniel Burrows


  Gestion du champ Cassé pour dpkg.
      Ian Jackson, Michael Vogt




--------------------------------------------------------------------------------
[21] Il devrait être possible de créer une liste assez complète des
contributeurs de l'internationalisation en se basant sur le ChangeLog, les
références au système de gestion des bogues Debian et les versions de
l'historique d'aptitude, mais cela demanderait un énorme investissement en temps
qui n'est pas possible actuellement.



Référence de l'interface en ligne de commande

--------------------------------------------------------------------------------
Table des matières



  aptitude — interface évoluée pour le gestionnaire de paquets

  aptitude-create-state-bundle — archiver l'état actuel d'aptitude

  aptitude-run-state-bundle — désarchiver une archive d'état d'aptitude et
  appeler aptitude sur celle-ci


Nom

aptitude — interface évoluée pour le gestionnaire de paquets


Synopsis

aptitude [options...] { autoclean | clean | forget-new | keep-all | update }

aptitude [options...] { full-upgrade | safe-upgrade } [paquets...]

aptitude [options...] { build-dep | build-depends | changelog | download |
forbid-version | hold | install | markauto | purge | reinstall | remove | show |
unhold | unmarkauto | versions } paquets...

aptitude extract-cache-subset répertoire-sortie paquets...

aptitude [options...] search motifs...

aptitude [options...] { add-user-tag | remove-user-tag } étiquettes paquets...

aptitude [options...] { why | why-not } [motifs...] paquet

aptitude [-S nom-fonct] [ --autoclean-on-startup | --clean-on-startup | -i | -
u ]

aptitude help


Description 

aptitude est une interface en mode texte pour le gestionnaire de paquets de
Debian GNU/Linux.

Elle permet à l'utilisateur de connaître la liste des paquets et de réaliser des
tâches d'administration comme l'installation, la mise à jour ou la suppression
de paquets. Ces tâches peuvent être réalisées en mode « interactif » ou à partir
de la « ligne de commande ».


Actions en ligne de commande

Le premier argument qui ne commence pas par un tiret (« - ») sera considéré
comme étant la commande que le programme doit réaliser. Si aucune commande n'est
donnée, aptitude démarrera en mode interactif.

Commandes disponibles :



  install
      Installer un ou plusieurs paquets. Les paquets doivent être énumérés après
      la commande « install ». Si le nom d'un paquet contient un tilde (« ~ »)
      ou un point d'interrogation (« ? »), il sera considéré comme un motif de
      recherche, et tout paquet correspondant à ce motif sera installé (voir la
      section « Motifs de recherche » dans le manuel de référence d'aptitude).

      Pour sélectionner une version précise d'un paquet, ajoutez « =version » au
      nom du paquet : par exemple, « aptitude install apt=0.3.1 ». De la même
      façon, pour choisir un paquet d'une archive précise, ajoutez « /archive »
      au nom du paquet : par exemple, « aptitude install apt/experimental ».
      Vous ne pouvez pas préciser simultanément une archive et un numéro de
      version pour le même paquet.

       Tous les paquets listés sur la ligne de commande ne doivent pas
      nécessairement être installé. Vous pouvez dire à aptitude d'agir
      différemment avec un paquet en ajoutant en suffixe un « attribut de
      surcharge » au nom du paquet. Par exemple, aptitude remove wesnoth+
      installera wesnoth au lieu de le supprimer. Les attributs de surcharge
      suivants sont disponibles :



        paquet+
            Installer le paquet.


        paquet+M
            Installer paquet et le marquer comme installé automatiquement (notez
            que si aucun autre paquet ne dépend de paquet, cela entraînera sa
            suppression immédiate).


        paquet-
            Supprimer le paquet.


        paquet_
            Purger le paquet, c'est-à-dire le supprimer ainsi que tous ses
            fichiers de configuration.


        paquet=
            Marquer le paquet comme étant à conserver. Cela annule toute action
            d'installation, de mise à jour ou de suppression, et empêche ce
            paquet d'être mis à jour automatiquement dans le futur.


        paquet:
            Garder le paquet à sa version actuelle. Cela annule toute action
            d'installation, de mise à jour ou de suppression. Contrairement à
            « hold » (voir ci-dessus), cela n'empêche pas ce paquet d'être mis à
            jour automatiquement dans le futur.


        paquet&amp;M
            Marquer le paquet comme ayant été installé automatiquement.


        paquet&amp;m
            Marquer le paquet comme ayant été installé manuellement.


      Cas particulier, « install » sans autre argument résoudra les commandes en
      suspens ou différées.


      IMG.alt.suffix Note
        = \[Note]]
                     Une fois que vous avez appuyé sur Y à l'invite de confirmation finale, la
                     commande « install » modifie les informations enregistrées sur les actions
                     qu'aptitude doit réaliser. De ce fait, si vous lancez la commande « aptitude
                     install toto titi » puis que vous arrêtiez l'installation alors qu'aptitude a
                     déjà commencé à télécharger et installer des paquets, vous devrez lancer
                     « aptitude remove toto titi » pour l'annuler.



  remove, purge, hold, unhold, keep, reinstall
      Ces commandes ont le même comportement que « install », mais appliquent
      l'action à tous les paquets donnés sur la ligne de commande pour lesquels
      il n'y a pas de surcharge. La différence entre hold et keep est qu'avec
      hold un paquet sera ignoré par les prochaines actions safe-upgrade ou
      full-upgrade, alors que keep annulera simplement toutes actions prévues
      sur le paquet. unhold permettra la mise à jour du paquet dès la prochaine
      commande safe-upgrade ou full-upgrade, sans toutefois modifier son état
      actuel.

      Par exemple, « aptitude remove '~ndeity' » supprimera tous les paquets
      dont le nom contient « deity »).


  markauto, unmarkauto
      Indiquer que les paquets ont été respectivement installés automatiquement,
      ou à la main. Vous pouvez choisir les paquets grâce à la syntaxe vue plus
      haut, et même indiquer les commandes à réaliser. Par exemple, « aptitude
      markauto '~slibs' » marquera tous les paquets de la section « libs » comme
      ayant été installés automatiquement.

      Pour plus d'informations sur les paquets installés automatiquement,
      consultez la section « Gérer les paquets automatiquement installés » dans
      le manuel de référence d'aptitude.


  build-depends, build-dep
      Satisfaire les dépendances de construction d'un paquet. Chaque nom de
      paquet peut être un paquet source, auquel cas les dépendances de
      construction de ce paquet source sont installées. Sinon, les paquets
      binaires sont trouvés de la même façon que pour la commande « install »,
      et les dépendances de constuction des paquets source dont sont issus ces
      paquets binaires sont satisfaites.

      Si le paramètre en ligne de commande --arch-only est présent, seules les
      dépendances de construction qui dépendent de l'architecture (c'est-à-dire,
      pas celles indiquées dans les champs Build-Depends-Indep ou Build-
      Conflicts-Indep) seront satisfaites.


  forbid-version
      Empêcher la mise à jour vers une version précise d'un paquet. Cette option
      interdit à aptitude la mise à jour automatique vers cette version, mais
      permettra le passage aux versions suivantes. Par défaut, aptitude choisira
      la version vers laquelle ce paquet aurait normalement dû être mis à jour.
      Vous pouvez modifier ce choix en ajoutant « =version » au nom du paquet :
      par exemple, « aptitude forbid-version vim=1.2.3.broken-4 ».

      Cette commande est pratique pour éviter les versions boguées des paquets
      sans avoir à définir ou supprimer des gels à la main. Si vous décidez
      finalement d'installer la version que vous aviez interdite, la commande
      « aptitude install paquet » mettra fin à l'interdiction.


  update
      Mettre à jour la liste des paquets disponibles depuis les sources apt
      (c'est l'équivalent de « apt-get update »).


  safe-upgrade
      Mettre les paquets installés à jour, avec leur version la plus récente.
      Les paquets installés ne seront pas retirés, sauf s'ils sont inutilisés
      (voir la section « Gérer les paquets automatiquement installés » dans le
      manuel de référence d'aptitude). Les paquets qui ne sont pas actuellement
      présents peuvent être installés pour résoudre des dépendances, sauf si
      l'option en ligne de commande --no-new-installs est fournie.

      Si aucun paquet n'est donné sur la ligne de commande, aptitude essaiera de
      mettre à jour tous les paquets qui le peuvent. Sinon, aptitude n'essaiera
      de mettre à jour que les paquets indiqués. Les paquets peuvent être
      étendus avec des suffixes, de la même manière que les arguments de
      aptitude install, de sorte qu'il est possible de donner des instructions
      supplémentaires à aptitude. Par exemple, aptitude safe-upgrade bash dash-
      essaiera de mettre à jour le paquet bash et de supprimer le paquet dash.

      Il est parfois nécessaire de supprimer ou d'installer un paquet afin de
      pouvoir en mettre un autre à jour. Utilisez la commande full-upgrade pour
      mettre autant de paquets à jour que possible.


  full-upgrade
      Mettre à jour les paquets dans leur version la plus récente, en supprimant
      ou installant autant de paquets que nécessaire. Cette commande est moins
      conservatrice que safe-upgrade et donc a plus de chance de provoquer des
      actions inattendues. Toutefois, elle est capable de mettre à jour des
      paquets dans des situations que safe-upgrade ne peut gérer.

      Si aucun paquet n'est indiqué sur la ligne de commande, aptitude essaiera
      de mettre à jour tous les paquets susceptibles de l'être. Sinon, aptitude
      essaiera uniquement de mettre à jour les paquets indiqués. Le nom des
      paquets peut être prolongé par un suffixe, de la même façon que les
      arguments de la commande aptitude install, afin de pouvoir donner des
      instructions supplémentaires à aptitude. Par exemple, aptitude full-
      upgrade bash dash- essaiera de mettre à jour le paquet bash et de
      supprimer le paquet dash.


      IMG.alt.suffix = \[Note]] Note

                                Cette commande s'appellait dist-upgrade pour des
                                raisons historiques, aptitude la reconnait
                                toujours. dist-upgrade est un synonyme de full-
                                upgrade.



  keep-all
      Annuler toutes les actions prévues sur des paquets. Tout paquet dont
      l'état indique une action prévue d'installation, de suppression ou de mise
      à jour verra son état remis à zéro.


  forget-new
      Ignorer les « nouveaux » paquets (équivalent à la pression de « f » en
      mode interactif).


  search
      Rechercher les paquets qui correspondent à un ou plusieurs motifs donnés
      sur la ligne de commande. Tous les paquets correspondant aux expressions
      demandées seront affichés. Par exemple, « aptitude search '~N' edit »
      affichera tous les « nouveaux » paquets et ceux dont le nom contient
      « edit ». Les expressions de recherche sont expliquées en détail dans
      « Motifs de recherche » dans le manuel de référence d'aptitude.


      IMG.alt.suffix Note
        = \[Note]]
                     Dans l'exemple précédent, « aptitude search '~N' edit » a deux arguments après
                     search et donc cherche la correspondance avec deux motifs : « ~N » et « edit ».
                     Comme il a été décrit dans la référence sur les motifs de recherche, un seul
                     motif composé de deux sous-motifs séparés par un espace (comme « ~N edit »)
                     fera correspondre un paquet seulement si les deux motifs correspondent. Ainsi,
                     la commande « aptitude search '~N edit' » ne montrera que les « nouveaux »
                     paquets dont le nom contient « edit ».


      À moins d'avoir invoqué l'option -F, la sortie de la commande aptitude
      search ressemblera à quelque chose comme ceci :

      i   apt                             - Advanced front-end for dpkg
      pi  apt-build                       - frontend to apt to build, optimize
      and in
      cp  apt-file                        - APT package searching utility -
      - command-
      ihA raptor-utils                    - Raptor RDF Parser utilities

      Les résultats sont présentés ligne par ligne. Le premier caractère de
      chaque ligne indique l'état courant du paquet : les états les plus
      courants sont p qui signifie qu'aucune trace du paquet n'est présente sur
      le système, c qui signifie que le paquet à été supprimé mais que ses
      fichiers de configuration sont toujours présents sur le système, i qui
      signifie que le paquet est installé et v qui signifie que le paquet est
      virtuel. Le second caractère indique l'action prévue (s'il y en a une, un
      espace sinon) sur le paquet. Les actions les plus courantes sont : i pour
      les paquets à installer, d pour ceux à supprimer et p pour ceux à purger
      (c-à-d, à supprimer ainsi que ses fichiers de configuration). Si le
      dernier caractère est un A, le paquet a été installé automatiquement.

      Pour une liste complète des états et actions possibles, consultez la
      section « Accéder aux informations des paquets » dans le manuel de
      référence d'aptitude. Pour personnaliser la sortie de la commande search,
      consultez la documentation des options en ligne de commande -F et --sort.


  show
      Afficher des informations détaillées sur un ou plusieurs paquets dont les
      noms sont indiqués après la commande search. Si un nom de paquet contient
      un caractère tilde (« ~ ») ou un point d'interrogation (« ? »), il sera
      alors traité comme un motif de recherche, et tous les paquets
      correspondants seront affichés (voir la section « Motifs de recherche »
      dans le manuel de référence d'aptitude).

      Si le niveau de verbosité est au moins 1 (c'est-à-dire que l'option -v est
      présente sur la ligne de commande), les informations sur toutes les
      versions du paquets sont affichées. Sinon, seules les informations sur la
      « version installable » sont affichées (la version qui serait téléchargée
      par « aptitude install »).

      Vous pouvez afficher les informations d'une version particulière d'un
      paquet en ajoutant le suffixe =version au nom du paquet ; vous pouvez
      également afficher les informations sur une version d'une archive
      particulière en ajoutant le suffixe /archive au nom du paquet, comme par
      exemple /unstable ou /sid. Si un des ces arguments est présent, seule la
      version demandée sera affichée, quel que soit le niveau de verbosité.

      Si le niveau de verbosité est au moins 1, les champs architecture, taille
      compressée, nom de fichier et somme md5 du paquet sont affichés. Si le
      niveau de verbosité est au moins 2, la ou les versions sélectionnées
      seront affichées une fois pour chacune des archives dans lesquelles elles
      sont trouvées.


  versions
      Afficher les versions disponibles des paquets indiqués sur la ligne de
      commande.

      $ aptitude versions wesnoth
      p   1:1.4.5-
      1                                                             100
      p   1:1.6.5-1                                    unstable
      500
      p   1:1.7.14-1                                   experimental
      1

      Chaque version est indiquée sur une ligne séparée. Les trois caractères
      les plus à gauche indiquent l'état actuel, l'état prévu (si besoin) et si
      le paquet a été installé automatiquement. Pour plus d'informations sur
      leur signification, consultez la documentation d'aptitude search. À droite
      du numéro de version, sont affichées les suites pour lesquelles la version
      est disponible et la priorité d'épinglage de cette version.

      Si un nom de paquet contient un tilde (« ~ ») ou un point d'interrogation
      (« ? »), il sera traité comme un motif de recherche et toutes les versions
      correspondantes seront affichées (consultez la section « Motifs de
      recherche » dans le manuel de référence d'aptitude). Cela signifie que,
      par exemple, aptitude versions '~i' affichera toutes les versions
      actuellement installées sur le système, et rien d'autre, même pas les
      autres versions de ces mêmes paquets.

      $ aptitude versions '~nexim4-daemon-light'
      Paquet exim4-daemon-light :
      i   4.71-
      3                                                                100
      p   4.71-4                                       unstable
      500

      Paquet exim4-daemon-light-dbg :
      p   4.71-4                                       unstable
      500

      Si l'entrée est un motif de recherche, ou si les versions de plus d'un
      paquet doivent être affichées, aptitude regroupera automatiquement la
      sortie par paquet, comme on peut le voir ci-dessus. Vous pouvez désactiver
      ce regroupement en ajoutant l'option --group-by=none. Dans ce cas,
      aptitude affichera une seule liste de toutes les versions qui ont été
      trouvées et inclura automatiquement le nom du paquet dans chaque ligne de
      la sortie :

      $ aptitude versions --group-by=none '~nexim4-daemon-light'
      i   exim4-daemon-light 4.71-
      3                                             100
      p   exim4-daemon-light 4.71-4                    unstable
      500
      p   exim4-daemon-light-dbg 4.71-4                unstable
      500

      Pour désactiver le nom de paquet, utiliser --show-package-names=never :

      $ aptitude versions --show-package-names=never --group-by=none '~nexim4-
      daemon-light'
      i   4.71-
      3                                                                100
      p   4.71-4                                       unstable
      500
      p   4.71-4                                       unstable
      500

      En plus des options ci-dessus, les informations affichées pour chaque
      version peuvent être contrôlées par l'option en ligne de commande -F.
      L'ordre dans lequel les versions sont affichées peut être contrôlé par
      l'option en ligne de commande --sort. Pour empêcher aptitude de formater
      la sortie en colonnes, utilisez --disable-columns.


  add-user-tag, remove-user-tag
      Ajouter ou supprimer une étiquette utilisateur d'un groupe de paquets
      sélectionné. Si un nom de paquet contient un tilde (« ~ ») ou un point
      d'interrogation (« ? »), il sera traité comme un motif de recherche et
      l'étiquette sera ajoutée ou supprimée de tous les paquets qui
      correspondent à ce motif (consultez la section « Motifs de recherche »
      dans le manuel de référence d'aptitude).

      Les étiquettes utilisateur sont des chaînes de caractères arbitraires
      associées à un paquet. Elles peuvent être utilisées avec le motif de
      recherche ?user-tag(étiquette), qui sélectionnera tous les paquets ayant
      une étiquette utilisateur correspondant à l'étiquette.


  why, why-not
      Expliquer pourquoi tel paquet peut ou ne peut pas être installé sur ce
      système.

      Cette commande cherche les paquets qui dépendent ou sont en conflit avec
      ce paquet. Il affiche la suite de dépendances qui s'enchaînent jusqu'au
      paquet visé, et une note indique l'état de chacun des paquets de la suite
      de dépendances.

      $ aptitude why kdepim
      i   nautilus-data Recommends nautilus
      i A nautilus      Recommends desktop-base (>= 0.2)
      i A desktop-base  Suggests   gnome | kde | xfce4 | wmaker
      p   kde           Depends    kdepim (>= 4:3.4.3)

      La commande why cherche la chaîne de dépendances pour l'installation du
      paquet indiqué sur la ligne de commande, comme au-dessus. Sachez que les
      dépendances qu'indique aptitude dans ce cas de figure ne sont que
      suggestions. C'est parce qu'aucun paquet installé sur cet ordinateur ne
      dépend ni ne recommande le paquet kdepim, car si une dépendance plus
      évidente était possible, aptitude l'aurait affichée.

      A contrario, why-not cherche la chaîne de dépendances qui conduit au
      conflit avec le paquet ciblé.

      $ aptitude why-not textopo
      i   ocaml-core          Depends   ocamlweb
      i A ocamlweb            Depends   tetex-extra | texlive-latex-extra
      i A texlive-latex-extra Conflicts textopo

      Si un ou plusieurs motifs sont présents, aptitude commencera sa recherche
      sur ces motifs. C'est à dire que le premier paquet affiché sera un paquet
      qui correspond au motif en question. Les motifs sont considérés comme des
      noms de paquets sauf s'ils contiennent un caractère tilde(« ~ ») ou un
      point d'interrogation (« ? »). Dans ce cas, ils seront alors traités comme
      un motif de recherche (consultez la section « Motifs de recherche » dans
      le manuel de référence d'aptitude).

      Si aucun motif n'est présent, aptitude cherchera une chaîne de dépendances
      commençant par les paquets installés manuellement. Cela affiche de manière
      effective les paquets qui ont causé ou auraient pu avoir causé
      l'installation d'un paquet donné.


      IMG.alt.suffix Note
        = \[Note]]
                     aptitude why ne réalise pas une recherche complète de dépendances. Il
                     n'affiche que les relations directes entre paquets. Par exemple, si A dépend
                     de B, que C dépend de D, et que B et C sont en conflit, « aptitude why-not D »
                     ne trouvera pas la réponse « A dépend de B, B est en conflit avec C, et D
                     dépend de C ».


      Par défaut, aptitude n'affiche que les chaînes de dépendances les plus
      « courtes », les plus « fortes » et les plus « installées ». Dans ce cas,
      il cherche une chaîne qui ne contient que les paquets qui sont installés
      ou qui seront installés. Il recherche les dépendances les plus fortes
      possibles dans ce cadre, et recherche les chaînes qui évitent les
      dépendances avec alternatives et Provides, et il recherche la chaîne de
      dépendance la plus courte qui respecte ces contraintes. Ces règles sont
      appliquées de façon de moins en moins stricte jusqu'à ce qu'une
      correspondance soit trouvée.

      Si le niveau de verbosité est à 1 ou plus, alors toutes les explications
      qu'aptitude trouvera seront affichées, dans l'ordre de pertinence
      décroissante. Si le niveau de mode verbeux est de 2 ou plus, un très
      important niveau d'information de débogage sera affiché sur la sortie
      standard.

      Cette commande renvoie un 0 si elle réussit, 1 si aucune explication n'a
      pu être fournie, et -1 si une erreur est apparue.


  clean
      Supprimer tous les paquets .deb téléchargés et enregistrés dans le
      répertoire cache (normalement /var/cache/apt/archives).


  autoclean
      Supprimer tout paquet enregistré dans le cache et qui n'est plus proposé
      au téléchargement. Cela vous permet d'empêcher que le cache ne grossisse
      démesurément avec le temps, sans avoir à le vider complètement.


  changelog
      Télécharger et afficher le journal des modifications pour les paquets
      source ou binaires indiqués.

      Par défaut, le journal correspondant à la version qui serait installée par
      « aptitude install » est téléchargé. Vous pouvez sélectionner une version
      particulière d'un paquet en ajoutant un suffixe=version au nom du paquet.
      Vous pouvez également sélectionner la version d'une archive particulière
      en ajoutant un suffixe /archive ou suite au nom du paquet (par exemple /
      unstable ou /sid).


  download
      Télécharger le fichier .deb d'un paquet donné dans le répertoire actuel.
      Si un nom de paquet contient un tilde (« ~ ») ou un point d'interrogation
      (« ? »), il sera traité comme un motif de recherche et tous les paquets
      correspondant au motif seront téléchargés (consultez la section « Motifs
      de recherche » dans le manuel de référence d'aptitude).

      Par défaut, la version qui serait installée par « aptitude install » est
      téléchargée. Vous pouvez sélectionner une version particulière d'un paquet
      en ajoutant un suffixe=version au nom du paquet. Vous pouvez également
      sélectionner la version d'une archive particulière en ajoutant un suffixe
      /archive ou suite au nom du paquet (par exemple /unstable ou /sid).


  extract-cache-subset
      Copier le répertoire de configuration d'apt (/etc/apt) et un sous-ensemble
      de la base de données des paquets dans le répertoire indiqué. Si aucun
      paquet n'est indiqué, la base de données des paquets sera copiée en
      entier. Autrement, seules les entrées correspondant aux paquets indiqués
      seront copiées. Chaque nom de paquet peut être un motif de recherche, et
      tous les paquets correspondant à ce motif seront sélectionnés (consultez
      la section « Motifs de recherche » dans le manuel de référence
      d'aptitude). Tous les fichiers de base de données de paquets dans le
      répertoire de sortie seront écrasés.

      Les dépendances dans les paragraphes sur les paquets binaires seront
      réécrites pour supprimer les références aux paquets qui n'ont pas été
      sélectionnés.


  help
      Afficher un bref résumé des commandes et options disponibles.



Options

Les options qui suivent peuvent être utilisées afin de modifier le comportement
des commandes ci-dessus. Remarquez que les commandes ne vont pas toutes réagir à
chaque option (en effet, certaines options n'ont aucun sens pour certaines
commandes).



  --add-user-tag étiquette
      Pour full-upgrade, safe-upgrade, forbid-version, hold, install, keep-all,
      markauto, unmarkauto, purge, reinstall, remove, unhold et unmarkauto :
      ajouter l'étiquette utilisateur étiquette à tous les paquets qui sont
      installés, supprimés ou mis à jour, comme avec la commande add-user-tag.


  --add-user-tag-to étiquette,motif
      Pour full-upgrade, safe-upgrade forbid-version, hold, install, keep-all,
      markauto, unmarkauto, purge, reinstall, remove, unhold et unmarkauto :
      ajouter l'étiquette utilisateur étiquette à tous les paquets correspondant
      au motif comme avec la commande add-user-tag. Le motif est un motif de
      recherche, comme ceux décrits dans la section « Motifs de recherche » du
      manuel de référence d'aptitude.

      Par exemple, aptitude safe-upgrade --add-user-tag-to "nouvelle-
      installation,?action(install)" ajoutera l'étiquette nouvelle-installation
      à tous les paquets installés par la commande safe-upgrade.


  --allow-new-upgrades
      Lorsque le solveur sûr est utilisé (c'est-à-dire --safe-resolver a été
      passée, l'action utilisée est safe-upgrade ou Aptitude::Always-Use-Safe-
      Resolver a la valeur true), permettre au solveur de dépendances
      d'installer des mises à jour pour des paquets indépendamment de la valeur
      de la variable Aptitude::Safe-Resolver::No-New-Upgrades.


  --allow-new-installs
      Permettre à la commande safe-upgrade d'installer des nouveaux paquets.
      Lorsque le solveur sûr est utilisé (c'est-à-dire --safe-resolver a été
      passée, l'action utilisée est safe-upgrade ou Aptitude::Always-Use-Safe-
      Resolver a la valeur true), permettre au solveur de dépendances
      d'installer des nouveaux paquets. Cette option prend effet indépendamment
      de la valeur de la variable Aptitude::Safe-Resolver::No-New-Installs.


  --allow-untrusted
      Installer des paquets de sources non sûres sans demande de confirmation.
      Vous devriez l'utiliser seulement si vous savez ce que vous faites, comme
      cela pourrait facilement compromettre la sécurité de votre système.


  --disable-columns
      Avec cette option, aptitude search et aptitude versions afficheront leurs
      résultats sans formatage particulier. Normalement, aptitude ajoute des
      espaces ou tronque les résultats de la recherche pour faire tenir les
      résultats dans des « colonnes ». Avec cette option, chaque ligne sera
      formée en remplaçant tous les motifs de formatage par le texte
      correspondant. Les largeurs de colonnes seront ignorées.

      Par exemple, les premières lignes de la sortie de la commande « aptitude
      search -F '%p %V' --disable-columns libedataserver » pourraient être :

      libedataserver-1.2-15 3.2.2-3                  libedataserver-1.2-16
      3.4.2-1libedataserver1.2-dev 3.2.2-3libedataserverui-3.0-1 3.2.2-
      3libedataserverui-3.0-dev 3.2.2-3

      Comme dans l'exemple ci-dessus, --disable-columns est souvent utile
      combinée avec un format d'affichage défini en utilisant l'option en ligne
      de commande -F.

      Directive du fichier de configuration : Aptitude::CmdLine::Disable-
      Columns.


  -D, --show-deps
      Pour les commandes qui installent ou suppriment des paquets (install,
      full-upgrade, etc.), afficher un bref résumé sur la raison pour laquelle
      des paquets vont être automatiquement installés ou supprimés.

      Directive du fichier de configuration : Aptitude::CmdLine::Show-Deps.


  -d, --download-only
      N'installer ni ne supprimer aucun paquet. Télécharger simplement les
      paquets nécessaires dans le cache.

      Directive du fichier de configuration : Aptitude::CmdLine::Download-Only.


   -F format, --display-format format
      Préciser le format qui sera utilisé pour afficher les résultats des
      commandes search et versions. Par exemple, « %p %V %v » affichera le nom
      du paquet, suivi du numéro de la version installée, ainsi que les versions
      disponibles. Pour plus d'informations, consultez la section
      « Personnaliser la manière d'afficher les paquets » dans le manuel de
      référence d'aptitude.

      L'option en ligne de commande --disable-columns est souvent utilisée en
      combinaison avec -F.

      Directives du fichier de configuration : Aptitude::CmdLine::Show-Versions
      pour la commande search ; Aptitude::CmdLine::Version-Display-Format pour
      la commande versions.


  -f
      Essayer témérairement de résoudre les dépendances des paquets cassés, même
      si cela implique d'ignorer des actions demandées sur la ligne de commande.

      Directive du fichier de configuration : Aptitude::CmdLine::Fix-Broken.


  --full-resolver
      Lorsque des problèmes de dépendances de paquets sont rencontrés, utiliser
      le solveur « complet » pour les résoudre. Contrairement au solveur « sûr »
      activé par --safe-resolver, le solveur complet supprimera volontiers des
      paquets pour satisfaire des dépendances. Il peut résoudre plus de
      situations que l'algorithme sûr, mais ses solutions peuvent parfois ne pas
      être souhaitables.

      Cette option peut être utilisée pour forcer l'utilisation du solveur
      complet même si la valeur true est attribuée à la variable Aptitude::
      Always-Use-Safe-Resolver. La commande safe-upgrade n'utilise jamais le
      solveur complet et n'accepte pas l'option --full-resolver.


   --group-by mode-regroupement
      Contrôler la manière dont la commande versions regroupe les informations
      affichées. Les valeurs suivantes sont acceptées :


      * archive pour regrouper les paquets par archive à laquelle ils
        appartiennent (« stable », « unstable », etc.). Si un paquet apparaît
        dans plusieurs archives, il sera affiché dans chacune d'elles.

      * auto pour regrouper les versions en fonction du nom de paquet, à moins
        qu'il y ait exactement un argument, et que celui-ci ne soit pas un motif
        de recherche.

      * none pour afficher toutes les versions dans une seule liste sans aucun
        regroupement.

      * package pour regrouper les versions en fonction du nom de paquet.

      * source-package pour regrouper les versions en fonction du paquet source.

      * source-version pour regrouper les versions en fonction du paquet source
        et de la version source.


      Directive du fichier de configuration : Aptitude::CmdLine::Versions-Group-
      By.


  -h, --help
      Afficher un court message d'aide. Identique à l'action help.


   --log-file=fichier
      Si la chaîne fichier est non vide, les messages de journalisation seront
      écrit dans un fichier avec ce nom. Si fichier est égal à « - », les
      messages seront affichés sur la sortie standard. Si cette option apparaît
      plusieurs fois, la dernière occurence est celle qui sera utilisée.

      Cela ne concerne pas la journalisation des installations qu'aptitude a
      effectuées (/var/log/aptitude). La journalisation concernée par cette
      option contient les messages d'événements, d'erreur et de débogage.
      Consultez l'aide pour l'option en ligne de commande --log-level pour un
      meilleur contrôle sur le contenu journalisé.

      Directive du fichier de configuration : Aptitude::Logging::File.


   --log-level=niveau, --log-level=catégorie:niveau
      Avec --log-level=niveau, aptitude n'affiche que les messages de
      journalisation dont le niveau est supérieur ou égal à niveau. Par exemple,
      positionner le niveau de journalisation à error conduira à l'affichage des
      niveaux error et fatal, et tous les autres seront cachés. Les niveaux de
      journalisations acceptés sont (dans l'ordre décroissant) : off, fatal,
      error, warn, info, debug et trace. Le niveau de journalisation par défaut
      est warn.

      --log-level=catégorie:niveau implique la journalisation des messages de la
      catégorie seulement si leur niveau de journalisation est supérieur ou égal
      à niveau.

      --log-level peut apparaître plusieurs fois sur la ligne de commande. Le
      réglage le plus particulier est celui qui aura un effet. Ainsi si --log-
      level=aptitude.resolver:fatal et --log-
      level=aptitude.resolver.hints.match:trace sont indiquées, les messages
      dans aptitude.resolver.hints.parse ne seront affichés que si leur niveau
      est fatal. En revanche, tous les messages dans
      aptitude.resolver.hints.match seront affichés. Si le niveau d'une même
      catégorie est déterminé plus d'une fois, le dernier réglage est celui qui
      aura un effet.

      Cela ne concerne pas la journalisation des installations qu'aptitude a
      effectuées (/var/log/aptitude). La journalisation concernée par cette
      option contient les messages d'événements, d'erreur et de débogage.
      Consultez l'aide pour l'option en ligne de commande --log-file pour
      changer la destination de ces messages de journalisation.

      Directive du fichier de configuration : Aptitude::Logging::Levels.


   --log-resolver
      Déterminer quelques niveaux de journalisation standard liés au solveur
      afin de produire une sortie de journalisation adaptée au traitement par
      des outils automatisés. Équivalent à l'option en ligne de commande --log-
      level=aptitude.resolver.search:trace --log-
      level=aptitude.resolver.search.tiers:info.


   --no-new-installs
      Empêcher safe-upgrade d'installer de nouveaux paquets. Lorsque le solveur
      sûr est utilisé (c'est-à-dire l'option --safe-resolver a été passée sur la
      ligne de commande ou la valeur true a été attribuée à Aptitude::Always-
      Use-Safe-Resolver), interdire au solveur de dépendances d'installer de
      nouveaux paquets. Cette option a un effet indépendamment de la valeur de
      Aptitude::Safe-Resolver::No-New-Installs.

      Cela copie le comportement historique de la commande apt-get upgrade.


  --no-new-upgrades
      Lorsque le solveur sûr est utilisé (c'est-à-dire l'option --safe-resolver
      a été passée sur la ligne de commande ou la valeur true a été attribuée à
      Aptitude::Always-Use-Safe-Resolver), interdire au solveur de dépendances
      d'installer des mises à jour de paquets, indépendamment de la valeur de
      Aptitude::Safe-Resolver::No-New-Upgrades.


  --no-show-resolver-actions
      Ne pas afficher les actions effectuées par le solveur « sûr », en
      surchargeant toute option de configuration ou utilisation antérieure de --
      show-resolver-actions.


  -O ordre, --sort ordre
      Définir l'ordre dans lequel le résultat des commandes search et versions
      doit être affiché. Par exemple, la valeur « installsize » pour l'ordre
      triera les paquets dans l'ordre croissant de la taille de leur
      installation. Pour plus d'informations, consultez le chapitre
      « Personnaliser la manière de trier les paquets » dans le manuel de
      référence d'aptitude.

      L'ordre de tri par défaut est name,version.


  -o clef=valeur
      Définir une option du fichier de configuration à la volée. Utilisez par
      exemple -o Aptitude::Log=/tmp/mes-logs afin de consigner (logs) les
      événements d'aptitude dans le fichier /tmp/mes-logs. Pour plus
      d'informations sur les options du fichier de configuration, consultez le
      chapitre « Référence du fichier de configuration » dans le manuel de
      référence d'aptitude.


  -P, --prompt
      Toujours afficher une invite de commande avant de télécharger, installer
      ou supprimer des paquets, même si aucune autre commande que celles
      explicitement demandées n'est entreprise.

      Directive du fichier de configuration : Aptitude::CmdLine::Always-Prompt.


  --purge-unused
      Si la valeur true est attribuée à Aptitude::Delete-Unused (qui est sa
      valeur par défaut), alors aptitude non seulement supprimera les paquets
      qui ne sont plus utilisés mais aussi les purgera du système, en supprimant
      leurs fichiers de configuration et peut-être des données importantes. Pour
      plus d'informations sur les paquets considérés comme « inutilisés »,
      consultez la section « Gérer les paquets automatiquement installés » dans
      le manuel de références d'aptitude. CETTE OPTION PEUT ENTRAÎNER DES PERTES
      DE DONNÉES ! NE L'ACTIVEZ QUE SI VOUS SAVEZ CE QUE VOUS FAITES !

      Directive du fichier de configuration : Aptitude::Purge-Unused.


  -q[=n], --quiet[=n]
      Enlever tous les indicateurs d'avancement et rendre ainsi la sortie
      journalisable. Cette option peut être passée plusieurs fois pour rendre le
      programme de plus en plus silencieux, mais contrairement à apt-get,
      aptitude n'ajoute pas implicitement -y quand -q est passée plus d'une
      fois.

      Le paramètre optionnel =n peut être utilisé pour configurer directement le
      taux de silence (par exemple, pour surcharger un paramétrage dans /etc/
      apt/apt.conf) ; le programme agit alors comme si -q lui avait été passée
      exactement n fois.


  -R, --without-recommends
      Ne pas gérer les recommandations de dépendances lors de l'installation de
      nouveaux paquets (prioritaire sur les réglages de /etc/apt/apt.conf and
      ~/.aptitude/config). Les paquets installés précédemment pour ces mêmes
      raisons de recommandation ne seront pas supprimés.

      Directives du fichier de configuration : Apt::Install-Recommends et Apt::
      AutoRemove::InstallRecommends.


  -r, --with-recommends
      Traiter les suggestions ou les recommandations comme des dépendances lors
      de l'installation des nouveaux paquets (prioritaire sur les réglages de /
      etc/apt.conf et ~/.aptitude/config).

      Directive du fichier de configuration : Apt::Install-Recommends.


  --remove-user-tag étiquette
      Pour full-upgrade, safe-upgrade, forbid-version, hold, install, keep-all,
      markauto, unmarkauto, purge, reinstall, remove, unhold et unmarkauto :
      supprimer l'étiquette utilisateur étiquette de tous les paquets qui sont
      installés, supprimés ou mis à jour, comme avec la commande add-user-tag.


  --remove-user-tag-from étiquette,motif
      Pour full-upgrade, safe-upgrade forbid-version, hold, install, keep-all,
      markauto, unmarkauto, purge, reinstall, remove, unhold et unmarkauto :
      supprimer l'étiquette utilisateur étiquette de tous les paquets
      correspondant au motif comme avec la commande remove-user-tag. Le motif
      est un motif de recherche, comme ceux décrits dans la section « Motifs de
      recherche » du manuel de référence d'aptitude.

      Par exemple, aptitude safe-upgrade --remove-user-tag-from "pas-mis-à-
      jour,?action(upgrade)" supprimera l'étiquette pas-mis-à-jour de tous les
      paquets que la commande safe-upgrade est capable de mettre à jour.


  -s, --simulate
      En mode ligne de commande, afficher la liste des actions qui seraient
      réalisées, mais ne pas les lancer réellement. Il n'est pas nécessaire
      d'avoir les privilèges d'administration. Dans l'interface visuelle, ouvre
      toujours le cache en mode lecture seule que vous soyez administrateur ou
      non.

      Directive du fichier de configuration : Aptitude::Simulate.


  --safe-resolver
      Lorsque des problèmes de dépendances sont rencontrés, utiliser
      l'algorithme « sûr » pour les résoudre. Ce solveur essaie de préserver le
      maximum de choix de l'utilisateur. Il ne supprimera jamais un paquet ni
      n'installera une version d'un paquet autre que la version candidate. C'est
      le même algorithme que celui utilisé dans la commande safe-upgrade. En
      effet, aptitude --safe-resolver full-upgrade est équivalent à aptitude
      safe-upgrade. Puisque safe-upgrade utilise toujours le solveur sûr, cette
      commande n'accepte pas l'option --sage-resolver.

      Cette option est équivalente à l'attribution de la valeur true à la
      variable Aptitude::Always-Use-Safe-Resolver


  --schedule-only
      Pour les commandes qui modifient l'état des paquets, programmer les
      actions à faire pour plus tard, mais ne pas les effectuer. Vous pouvez
      exécuter les actions programmées en lançant aptitude install sans
      paramètre. Cela revient à faire la sélection correspondante en mode
      visuel, puis à quitter aptitude normalement.

      Par exemple, aptitude --schedule-only install evolution va programmer
      l'installation future du paquet evolution.


  --show-package-names quand
      Contrôler quand la commande versions affiche les noms de paquets. Les
      valeurs suivantes sont autorisées :


      * always : afficher le nom des paquets à chaque fois que la commande
        aptitude versions est exécutée.

      * auto : afficher le nom des paquets lorsqu'aptitude versions est exécuté
        si la sortie n'est pas groupée par paquet, et s'il y a soit un argument
        de correspondance à un motif, soit plus d'un argument.

      * never : ne jamais afficher le nom des paquets dans la sortie d'aptitude
        versions.


      Directive du fichier de configuration : Aptitude::CmdLine::Versions-Show-
      Package-Names.


  --show-resolver-actions
      Afficher les actions effectuées par le solveur « sûr » et par safe-
      upgrade.

      Lorsque la commande safe-upgrade est exécutée ou l'option --safe-resolver
      est présente, aptitude affichera un résumé des actions effectuées par le
      solveur avant d'afficher l'aperçu de l'installation. Directive du fichier
      de configuration : Aptitude::Safe-Resolver::Show-Resolver-Actions.


  --show-summary[=mode]
      Changer le comportement de la commande « aptitude why » pour qu'elle
      résume chaque chaîne de dépendance affichée, plutôt que de l'afficher dans
      sa forme longue. Si cette option est présente et le mode n'est pas « no-
      summary », les chaînes qui contiennent des dépendances suggérées
      (« Suggests: ») ne seront pas affichées. Pour voir un résumé de toutes les
      raisons pour lesquelles le paquet cible est installé, combinez --show-
      summary avec -v.

      mode peut prendre les valeurs suivantes :


        1. no-summary : ne pas afficher de résumé (comportement par défaut si --
           show-summary est absent).

        2. first-package : afficher le premier paquet dans chaque chaîne. C'est
           la valeur par défaut du mode si elle n'est pas précisée.

        3. first-package-and-type : afficher le premier paquet de chaque chaîne,
           ainsi que la force de la dépendance la plus faible dans cette chaîne.

        4. all-packages : afficher brièvement chaque chaîne de dépendances
           conduisant au paquet cible.

        5. all-packages-with-dep-versions : afficher brièvement chaque chaîne de
           dépendances conduisant au paquet cible, en précisant la version
           candidate de chaque dépendance.


      Directive du fichier de configuration : Aptitude::CmdLine::Show-Summary.
      Si l'option --show-summary est présente sur la ligne de commande, elle
      aura la priorité sur Aptitude::CmdLine::Show-Summary.

      Exemple 10. Utilisation de --show-summary

      --show-summary utilisée avec -v pour afficher toutes les raisons pour
      lesquelles un paquet est installé :

      $ aptitude -v --show-summary why foomatic-db
      Paquets dépendants de foomatic-db :
        cupsys-driver-gutenprint
        foomatic-db-engine
        foomatic-db-gutenprint
        foomatic-db-hpijs
        foomatic-filters-ppds
        foomatic-gui
        kde
        printconf
        wine

      $ aptitude -v --show-summary=first-package-and-type why foomatic-db
      Paquets dépendants de foomatic-db :
        [Depends] cupsys-driver-gutenprint
        [Depends] foomatic-db-engine
        [Depends] foomatic-db-gutenprint
        [Depends] foomatic-db-hpijs
        [Depends] foomatic-filters-ppds
        [Depends] foomatic-gui
        [Depends] kde
        [Depends] printconf
        [Depends] wine

      $ aptitude -v --show-summary=all-packages why foomatic-db
      Paquets dépendants de foomatic-db :
        cupsys-driver-gutenprint D: cups-driver-gutenprint D: cups R: foomatic-
      filters R: foomatic-db-engine D: foomatic-db
        foomatic-filters-ppds D: foomatic-filters R: foomatic-db-engine D:
      foomatic-db
        kde D: kdeadmin R: system-config-printer-kde D: system-config-printer R:
      hal-cups-utils D: cups R: foomatic-filters R: foomatic-db-engine D:
      foomatic-db
        wine D: libwine-print D: cups-bsd R: cups R: foomatic-filters R:
      foomatic-db-engine D: foomatic-db
        foomatic-db-engine D: foomatic-db
        foomatic-db-gutenprint D: foomatic-db
        foomatic-db-hpijs D: foomatic-db
        foomatic-gui D: python-foomatic D: foomatic-db-engine D: foomatic-db
        printconf D: foomatic-db

      $ aptitude -v --show-summary=all-packages-with-dep-versions why foomatic-
      db
      Paquets dépendants de foomatic-db :
        cupsys-driver-gutenprint D: cups-driver-gutenprint (>= 5.0.2-4) D: cups
      (>= 1.3.0) R: foomatic-filters (>= 4.0) R: foomatic-db-engine (>= 4.0) D:
      foomatic-db (>= 20090301)
        foomatic-filters-ppds D: foomatic-filters R: foomatic-db-engine (>= 4.0)
      D: foomatic-db (>= 20090301)
        kde D: kdeadmin (>= 4:3.5.5) R: system-config-printer-kde (>= 4:4.2.2-1)
      D: system-config-printer (>= 1.0.0) R: hal-cups-utils D: cups R: foomatic-
      filters (>= 4.0) R: foomatic-db-engine (>= 4.0) D: foomatic-db (>=
      20090301)
        wine D: libwine-print (= 1.1.15-1) D: cups-bsd R: cups R: foomatic-
      filters (>= 4.0) R: foomatic-db-engine (>= 4.0) D: foomatic-db (>=
      20090301)
        foomatic-db-engine D: foomatic-db
        foomatic-db-gutenprint D: foomatic-db
        foomatic-db-hpijs D: foomatic-db
        foomatic-gui D: python-foomatic (>= 0.7.9.2) D: foomatic-db-engine D:
      foomatic-db (>= 20090301)
        printconf D: foomatic-db
      	

      --show-summary utilisé pour afficher une chaîne sur une seule ligne :

      $ aptitude --show-summary=all-packages why aptitude-gtk libglib2.0-data
      Paquets dépendants de libglib2.0-data:
        aptitude-gtk D: libglib2.0-0 R: libglib2.0-data



  -t version, --target-release version
      Définir la version à partir de laquelle les paquets devront être
      installés. Par exemple, « aptitude -t experimental ... » installera les
      paquets de la distribution expérimentale, si rien d'autre n'est précisé.
      Pour les actions de la ligne de commandes « changelog », « download » et
      « show », cela revient à ajouter le suffixe /version au nom de chaque
      paquet cité sur la ligne de commande. Pour les autres commandes, cela
      modifiera la version installée par défaut selon les règles décrites dans
      apt_preferences(5).

      Directive du fichier de configuration : APT::Default-Release.


  -V, --show-versions
      Indiquer quelle version du paquet sera installée.

      Directive du fichier de configuration : Aptitude::CmdLine::Show-Versions.


  -v, --verbose
      Forcer quelques commandes (show par exemple) à afficher des informations
      supplémentaires. Cette option peut être invoquée plusieurs fois afin
      d'obtenir des informations de plus en plus complètes.

      Directive du fichier de configuration : Aptitude::CmdLine::Verbose.


  --version
      Afficher la version et quelques informations sur l'environnement de
      compilation d'aptitude.


  --visual-preview
      Lors de l'installation ou de la suppression de paquets depuis la ligne de
      commande, lancer l'interface visuelle et afficher l'aperçu d'installation,
      plutôt que d'afficher l'habituelle invite de commande en ligne.


  -W, --show-why
      Dans l'aperçu affiché avant que des paquets ne soient installés ou
      supprimés, indiquer, pour chaque paquet installé automatiquement, quel
      paquet manuellement installé en dépend. Par exemple :

      $ aptitude --show-why install mediawiki
      ...
      Les NOUVEAUX paquets suivants vont être installés :
        libapache2-mod-php5{a} (for mediawiki)  mediawiki  php5{a} (for
      mediawiki)
        php5-cli{a} (for mediawiki)  php5-common{a} (for mediawiki)
        php5-mysql{a} (for mediawiki)

      Lorsqu'elle est combinée avec -v ou avec une valeur non nulle de
      Aptitude::CmdLine::Verbose, cette option affiche la chaîne de dépendance
      complète qui conduit à chaque paquet sur le point d'être installé. Par
      exemple :

      $ aptitude -v --show-why install libdb4.2-dev
      Les NOUVEAUX paquets suivants vont être installés :
        libdb4.2{a} (libdb4.2-dev D: libdb4.2)  libdb4.2-dev
      Les paquets suivants seront ENLEVÉS :
        libdb4.4-dev{a} (libdb4.2-dev C: libdb-dev P<- libdb-dev)

      Cette option décrira aussi pourquoi des paquets sont supprimés, comme on
      peut le voir ci-dessus. Dans cet exemple, libdb4.2-dev est en conflit avec
      libdb-dev, qui est fourni par libdb-dev.

      Directive du fichier de configuration : Aptitude::CmdLine::Show-Why. Cette
      option affiche la même information que celle calculée par aptitude why et
      aptitude why-not.


  -w largeur, --width largeur
      Préciser la largeur utilisée pour l'affichage du résultat de la commande
      search (par défaut, c'est la largeur du terminal).

      Directive du fichier de configuration : Aptitude::CmdLine::Package-
      Display-Width.


  -y, --assume-yes
      Répondre « oui » à toute question de type oui/non. En fait, cette option
      supprime l'invite (le prompt) qui apparaît quand on installe, met à jour
      ou supprime des paquets. N'affecte pas les réponses aux questions
      particulièrement dangereuses, telles que la suppression des paquets
      essentiels. Cette option a la priorité sur -P.

      Directive du fichier de configuration : Aptitude::CmdLine::Assume-Yes.


  -Z
      Afficher l'espace disque qui sera utilisé ou libéré par chacun des paquets
      à installer, mettre à jour ou supprimer.

      Directive du fichier de configuration : Aptitude::CmdLine::Show-Size-
      Changes.


Les options suivantes s'appliquent au mode visuel du programme. Toutefois, elles
ne sont utilisées qu'en interne. Normalement, vous n'en aurez pas besoin.



  --autoclean-on-startup
      Effacer les vieux fichiers téléchargés lors du démarrage du programme
      (équivalent à la sélection de Actions → Enlever les fichiers périmés juste
      après le démarrage). Il n'est pas possible d'utiliser cette option en
      conjonction avec « --clean-on-startup », « -i » ou « -u ».


  --clean-on-startup
      Nettoyer le cache des paquets lors du démarrage du programme (équivalent à
      la sélection de Actions → Nettoyer le cache des paquets juste après le
      démarrage). Il n'est pas possible d'utiliser cette option en conjonction
      avec « --autoclean-on-startup », « -i » ou « -u ».


  -i
      Afficher l'écran de téléchargement au démarrage du programme (équivalent
      au lancement du programme, puis à l'appui sur « g »). Il est impossible
      d'utiliser cette option conjointement avec « --autoclean-on-startup », « -
      -clean-on-startup » ou « -u ».


  -S nom-fichier
      Charger les informations supplémentaires à partir de nom-fichier plutôt
      qu'à partir du fichier d'état standard.


  -u
      Lancer la mise à jour de la liste des paquets dès le démarrage du
      programme. Il est impossible d'utiliser cette option conjointement avec
      « --autoclean-on-startup », « --clean-on-startup » ou« -i ».



Variables d'environnement



  HOME
      Si $HOME/.aptitude existe, aptitude stockera son fichier de configuration
      dans $HOME/.aptitude/config. Sinon, il recherchera le répertoire personnel
      de l'utilisateur courant, grâce à getpwuid(2) pour y placer son fichier de
      configuration.


  PAGER
      Quand cette variable d'environnement est paramétrée, aptitude l'utilisera
      pour afficher les journaux de modification à l'invocation de « aptitude
      changelog ». La valeur par défaut est more.


  TMP
      Quand TMPDIR n'est pas paramétrée, aptitude stockera ses fichiers
      temporaires dans TMP si cette dernière variable est paramétrée. Sinon, il
      les stockera dans /tmp.


  TMPDIR
      aptitude stockera ses fichiers temporaires dans le répertoire spécifié par
      cette variable d'environnement. Si TMPDIR n'est pas paramétrée, alors TMP
      est utilisée. Si cette dernière ne l'est pas non plus, alors aptitude
      utilisera /tmp.



Fichiers



  /var/lib/aptitude/pkgstates
      Le fichier dans lequel sont stockés l'état des paquets ainsi que quelques
      indicateurs de paquets.




  /etc/apt/apt.conf, /etc/apt/apt.conf.d/*, ~/.aptitude/config
      Les fichiers de configuration d'aptitude. ~/.aptitude/config a priorité
      sur /etc/apt/apt.conf. Consultez apt.conf(5) pour la documentation du
      format et le contenu de ces fichiers.



Voir aussi

apt-get(8), apt(8), /usr/share/doc/aptitude/html/lang/index.html du paquet
aptitude-doc-lang

--------------------------------------------------------------------------------

Nom

aptitude-create-state-bundle — archiver l'état actuel d'aptitude


Synopsis

aptitude-create-state-bundle [options...] fichier-sortie


Description 

aptitude-create-state-bundle produit une archive compressée contenant les
fichiers nécéssaires à la réplication de l'état actuel de l'archive de paquets.
Les fichiers et répertoires suivants sont inclus dans cette archive :


* $HOME/.aptitude

* /var/lib/aptitude

* /var/lib/apt

* /var/cache/apt/*.bin

* /etc/apt

* /var/lib/dpkg/status


La sortie de ce programme peut être utilisée comme un argument de la commande
aptitude-run-state-bundle(1).


Options



  --force-bzip2
      Surcharger l'auto-détection de l'algorithme de compression à utiliser. Par
      défaut, aptitude-create-state-bundle utilise bunzip2(1) s'il est
      disponible, et gzip(1) sinon. Passer cette option force l'utilisation de
      bzip2 même si la commande semble ne pas être disponible.


  --force-gzip
      Surcharger l'auto-détection de l'algorithme de compression à utiliser. Par
      défaut, aptitude-create-state-bundle utilise bunzip(1) s'il est
      disponible, et gzip(1) sinon. Passer cette option force l'utilisation de
      gzip même si la bzip2 est disponible.


  --help
      Afficher un bref message d'aide, puis quitter


  --print-inputs
      Au lieu de créer une archive, afficher une liste des fichiers et
      répertoires que le programme inclurait s'il créait cette archive.



Format de fichier

Ce fichier d'archive est simplement une archive tar(1) compressée avec bzip2(1)
ou gzip(1), avec chacune des arborescences de répertoires enracinées dans « . ».


Voir aussi

aptitude-run-state-bundle(1), aptitude(8), apt(8)

--------------------------------------------------------------------------------

Nom

aptitude-run-state-bundle — désarchiver une archive d'état d'aptitude et appeler
aptitude sur celle-ci


Synopsis

aptitude-run-state-bundle [options...] fichier-entrée [ programme
[arguments...]]


Description 

aptitude-run-state-bundle décompresse l'archive d'état d'aptitude donnée créée
par aptitude-create-state-bundle(1) dans un répertoire temporaire, et appelle le
programme sur cette archive avec les arguments fournis, puis supprime le
répertoire temporaire. Si le programme n'est pas précisé, c'est aptitude(8) qui
est utilisé par défaut.


Options

Les options suivantes peuvent être utilisées sur la ligne de commande avant le
fichier d'entrée. Les options suivant le fichier d'entrées sont considérées
comme étant des arguments du programme.



  --append-args
      Mettre les options donnant la position de l'archive d'état à la fin de la
      ligne de commande lors de l'appel du programme plutôt qu'au début (le
      comportement par défaut est de la placer au début).


  --help
      Afficher un bref message d'aide.


  --prepend-args
      Mettre les options donnant la position de l'archive d'état au début de la
      ligne de commande lors de l'appel du programme, surchargeant une
      utilisation éventuelle de --append-args (le comportement par défaut est de
      la placer au début).


  --no-clean
      Ne pas supprimer le répertoire d'état après avoir exécuté aptitude. Vous
      pouvez vouloir utiliser cette option si, par exemple, vous déboguez un
      problème apparaissant lorsque le fichier d'état d'aptitude est modifié.
      Lorsque la commande aptitude se termine, le nom du répertoire d'état sera
      affiché pour faciliter son accès après coup.

      Cette option est automatiquement activée par --statedir.


  --really-clean
      Effacer le répertoire d'état après l'exécution d'aptitude, même si les
      options --no-clean ou --statedir avaient été indiquées.


  --statedir
      Au lieu de traiter le fichier d'entrée comme une archive d'état, le
      traiter comme une archive décompressée. Par exemple, vous pouvez utiliser
      cela pour accéder au répertoire d'état créé par une exécution antérieure
      avec l'option --no-clean.


  --unpack
      Décompresser le fichier d'entrée dans un répertoire temporaire, mais ne
      pas exécuter aptitude.



Voir aussi

aptitude-create-state-bundle(1), aptitude(8), apt(8)

