use Test::More;

use JSON::Lines;

my $jsonl = JSON::Lines->new(
	canonical => 1,
);

my @data = (
	[qw/a b c/],
	["one", "two", "three"],
	["four", "five", "six"],
	["seven", "eight", "nine"]
);

my $string = $jsonl->encode(@data);
my $expected = q|["a","b","c"]
["one","two","three"]
["four","five","six"]
["seven","eight","nine"]|;

is($string, $expected);

$string = $jsonl->add_line(["ten", "eleven", "twelve"]);

is($string, $expected . "\n" . '["ten","eleven","twelve"]');

my $data = [
	{
		a => "one",
		b => "two",
		c => "three",
	},
	{
		a => "four",
		b => "five",
		c => "six",
	},
	{
		a => "seven",
		b => "eight",
		c => "nine",
	}
];

$string = $jsonl->encode($data);

$expected = q|{"a":"one","b":"two","c":"three"}
{"a":"four","b":"five","c":"six"}
{"a":"seven","b":"eight","c":"nine"}|;

is($string, $expected);

$string = $jsonl->add_line({ a => "ten", b => "eleven", c => "twelve" });
is($string, $expected . "\n" . '{"a":"ten","b":"eleven","c":"twelve"}');

done_testing();
