package App::InteractivePerlTutorial::Chapter::Scalar::Variables;

use 5.014000;
use strict;
use warnings;
our $VERSION = '0.000_001';

use constant TEXT => 'Variables';
use constant EXERCISES => [
	{ statement => "Write a program which declares a\nscalar variable and sets it to 42", input => '', check => sub { $_[1] eq "42"}, solution => <<'SOL' }
my $x = 42;
SOL
];

1;
__DATA__

=encoding utf-8

=head1 Variables

Variables are containers which hold values. Scalars hold a single scalar value, such as a number or string. Scalar variable names start with a $ followed by a letter or underscore then zero or more letters, digits or underscores, for example:

  $hello
  $world
  $_HELLO
  $h
  $Hello_World
  $a1b

Variables are declared with the B<my> operator.

  my $variable;

=head2 Assignment

The simplest operation you can do on a variable is to change its value. The C<=> operator is normally used for this.

  $name = 'Al' . 'ice';

This sets the value of C<$name> to C<'Alice'>.


=cut
