package Daje::Workflow::GenerateSchema::Create::Database;
use Mojo::Base  -base, -signatures;

has 'context';
has 'pg';
has 'dbname' => 'postgres';

sub create($self){

    $self->_connect($self->dbname());

    $self->_dbname();
    $self->pg->db->query("CREATE DATABASE " . $self->dbname());
    $self->_connect($self->dbname());

    my $default = $self->_get_defaults();
    $self->db->query($default);

    my $sql = $self->context->{context}->{sql};
    my $length = scalar @{$sql};
    for (my $i = 0; $i < $length; $i++) {
        $self->pg->migrations->from_string(@{$sql}[$i]->{data})->migrate->latest();
    }

}

sub drop($self) {

    $self->_connect('postgres');

    $self->pg->db->query("DROP DATABASE " . $self->dbname());

}

sub _connect($self, $dbname) {

    my $dbconn = $self->context->{context}->{dbconn};
    $dbconn =~ s/DB/$dbname/;

    my $pg = Mojo::Pg->new->dsn(
        $dbconn
    );

    $self->pg($pg);
}

sub _dbname($self) {

    my @chars = ('A'..'x');
    my $len = 8;
    my $string;
    while($len--){ $string .= $chars[rand @chars] };
    $string = lc($string);
    $self->dbname($string);

}

sub _get_defaults ($self) {
    return qq{
        CREATE TABLE workflow (
            workflow_pkey BIGINT NOT NULL PRIMARY KEY,
            test VARCHAR
        );
    } ;
}
1;

#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

Daje::Workflow::GenerateSchema::Create::Database


=head1 DESCRIPTION

pod generated by Pod::Autopod - keep this line to make pod updates possible ####################


=head1 REQUIRES

L<Mojo::Base> 


=head1 METHODS

=head2 create($self)

 create($self)();

=head2 drop($self)

 drop($self)();


=cut

