package Locales::DB::Territory::asa;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::asa::VERSION = '0.09';

$Locales::DB::Territory::asa::cldr_version = '2.0';

%Locales::DB::Territory::asa::code_to_name = (
    '001' => 'World',
    '002' => 'Africa',
    '003' => "North\ America",
    '005' => "South\ America",
    '009' => 'Oceania',
    '011' => "Western\ Africa",
    '013' => "Central\ America",
    '014' => "Eastern\ Africa",
    '015' => "Northern\ Africa",
    '017' => "Middle\ Africa",
    '018' => "Southern\ Africa",
    '019' => 'Americas',
    '021' => "Northern\ America",
    '029' => 'Caribbean',
    '030' => "Eastern\ Asia",
    '034' => "Southern\ Asia",
    '035' => "South\-Eastern\ Asia",
    '039' => "Southern\ Europe",
    '053' => "Australia\ and\ New\ Zealand",
    '054' => 'Melanesia',
    '057' => "Micronesian\ Region",
    '061' => 'Polynesia',
    '062' => "South\-Central\ Asia",
    142   => 'Asia',
    143   => "Central\ Asia",
    145   => "Western\ Asia",
    150   => 'Europe',
    151   => "Eastern\ Europe",
    154   => "Northern\ Europe",
    155   => "Western\ Europe",
    172   => "Commonwealth\ of\ Independent\ States",
    200   => 'Czechoslovakia',
    419   => "Latin\ America",
    830   => "Channel\ Islands",
    'ac'  => "Ascension\ Island",
    'ad'  => 'Andora',
    'ae'  => "Falme\ dha\ Kiarabu",
    'af'  => 'Afuganistani',
    'ag'  => "Antigua\ na\ Barbuda",
    'ai'  => 'Anguilla',
    'al'  => 'Albania',
    'am'  => 'Armenia',
    'an'  => "Antili\ za\ Uholandhi",
    'ao'  => 'Angola',
    'aq'  => 'Antarctica',
    'ar'  => 'Ajentina',
    'as'  => "Thamoa\ ya\ Marekani",
    'at'  => 'Authtria',
    'au'  => 'Authtralia',
    'aw'  => 'Aruba',
    'ax'  => "\Ã\land\ Islands",
    'az'  => 'Adhabajani',
    'ba'  => "Bothnia\ na\ Hedhegovina",
    'bb'  => 'Babadothi',
    'bd'  => 'Bangladeshi',
    'be'  => 'Ubelgiji',
    'bf'  => 'Bukinafatho',
    'bg'  => 'Bulgaria',
    'bh'  => 'Bahareni',
    'bi'  => 'Burundi',
    'bj'  => 'Benini',
    'bl'  => "Saint\ Barth\Ã\©lemy",
    'bm'  => 'Bermuda',
    'bn'  => 'Brunei',
    'bo'  => 'Bolivia',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'Brazili',
    'bs'  => 'Bahama',
    'bt'  => 'Butani',
    'bv'  => "Bouvet\ Island",
    'bw'  => 'Botthwana',
    'by'  => 'Belaruthi',
    'bz'  => 'Belidhe',
    'ca'  => 'Kanada',
    'cc'  => "Cocos\ \[Keeling\]\ Islands",
    'cd'  => "Jamhuri\ ya\ Kidemokrathia\ ya\ Kongo",
    'cf'  => "Jamhuri\ ya\ Afrika\ ya\ Kati",
    'cg'  => 'Kongo',
    'ch'  => 'Uthwithi',
    'ci'  => 'Kodivaa',
    'ck'  => "Vithiwa\ vya\ Cook",
    'cl'  => 'Chile',
    'cm'  => 'Kameruni',
    'cn'  => 'China',
    'co'  => 'Kolombia',
    'cp'  => "Clipperton\ Island",
    'cr'  => 'Kothtarika',
    'cs'  => "Therbia\ na\ Montenegro",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'Kuba',
    'cv'  => 'Kepuvede',
    'cx'  => "Christmas\ Island",
    'cy'  => 'Kuprothi',
    'cz'  => "Jamhuri\ ya\ Cheki",
    'dd'  => "East\ Germany",
    'de'  => 'Ujerumani',
    'dg'  => "Diego\ Garcia",
    'dj'  => 'Jibuti',
    'dk'  => 'Denmaki',
    'dm'  => 'Dominika',
    'do'  => "Jamhuri\ ya\ Dominika",
    'dz'  => 'Aljeria',
    'ea'  => "Ceuta\ and\ Melilla",
    'ec'  => 'Ekwado',
    'ee'  => 'Ethtonia',
    'eg'  => 'Mithri',
    'eh'  => "Western\ Sahara",
    'er'  => 'Eritrea',
    'es'  => 'Hithpania',
    'et'  => 'Uhabeshi',
    'eu'  => "European\ Union",
    'fi'  => 'Ufini',
    'fj'  => 'Fiji',
    'fk'  => "Vithiwa\ vya\ Falkland",
    'fm'  => 'Mikronethia',
    'fo'  => "Faroe\ Islands",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'Ufarantha',
    'fx'  => "Metropolitan\ France",
    'ga'  => 'Gaboni',
    'gb'  => 'Uingeredha',
    'gd'  => 'Grenada',
    'ge'  => 'Jojia',
    'gf'  => "Gwiyana\ ya\ Ufarantha",
    'gg'  => 'Guernsey',
    'gh'  => 'Ghana',
    'gi'  => 'Jibralta',
    'gl'  => 'Grinlandi',
    'gm'  => 'Gambia',
    'gn'  => 'Gine',
    'gp'  => 'Gwadelupe',
    'gq'  => 'Ginekweta',
    'gr'  => 'Ugiriki',
    'gs'  => "South\ Georgia\ and\ the\ South\ Sandwich\ Islands",
    'gt'  => 'Gwatemala',
    'gu'  => 'Gwam',
    'gw'  => 'Ginebisau',
    'gy'  => 'Guyana',
    'hk'  => "Hong\ Kong",
    'hm'  => "Heard\ Island\ and\ McDonald\ Islands",
    'hn'  => 'Hondurathi',
    'hr'  => 'Korathia',
    'ht'  => 'Haiti',
    'hu'  => 'Hungaria',
    'ic'  => "Canary\ Islands",
    'id'  => 'Indonethia',
    'ie'  => 'Ayalandi',
    'il'  => 'Ithraeli',
    'im'  => "Isle\ of\ Man",
    'in'  => 'India',
    'io'  => "Ieneo\ la\ Uingeredha\ katika\ Bahari\ Hindi",
    'iq'  => 'Iraki',
    'ir'  => 'Uajemi',
    'is'  => 'Aithlandi',
    'it'  => 'Italia',
    'je'  => 'Jersey',
    'jm'  => 'Jamaika',
    'jo'  => 'Yordani',
    'jp'  => 'Japani',
    'jt'  => "Johnston\ Island",
    'ke'  => 'Kenya',
    'kg'  => 'Kirigizithtani',
    'kh'  => 'Kambodia',
    'ki'  => 'Kiribati',
    'km'  => 'Komoro',
    'kn'  => "Thantakitdhi\ na\ Nevith",
    'kp'  => "Korea\ Kathkazini",
    'kr'  => "Korea\ Kuthini",
    'kw'  => 'Kuwaiti',
    'ky'  => "Vithiwa\ vya\ Kayman",
    'kz'  => 'Kazakithtani',
    'la'  => 'Laothi',
    'lb'  => 'Lebanoni',
    'lc'  => 'Thantaluthia',
    'li'  => 'Lishenteni',
    'lk'  => 'Thirilanka',
    'lr'  => 'Liberia',
    'ls'  => 'Lethoto',
    'lt'  => 'Litwania',
    'lu'  => 'Lathembagi',
    'lv'  => 'Lativia',
    'ly'  => 'Libya',
    'ma'  => 'Moroko',
    'mc'  => 'Monako',
    'md'  => 'Moldova',
    'me'  => 'Montenegro',
    'mf'  => "Saint\ Martin",
    'mg'  => 'Bukini',
    'mh'  => "Vithiwa\ vya\ Marshal",
    'mi'  => "Midway\ Islands",
    'mk'  => 'Mathedonia',
    'ml'  => 'Mali',
    'mm'  => 'Myama',
    'mn'  => 'Mongolia',
    'mo'  => 'Macau',
    'mp'  => "Vithiwa\ vya\ Mariana\ vya\ Kathkazini",
    'mq'  => 'Martiniki',
    'mr'  => 'Moritania',
    'ms'  => 'Monttherrati',
    'mt'  => 'Malta',
    'mu'  => 'Morithi',
    'mv'  => 'Modivu',
    'mw'  => 'Malawi',
    'mx'  => 'Mekthiko',
    'my'  => 'Malethia',
    'mz'  => 'Mthumbiji',
    'na'  => 'Namibia',
    'nc'  => 'Nyukaledonia',
    'ne'  => 'Nijeri',
    'nf'  => "Kithiwa\ cha\ Norfok",
    'ng'  => 'Nijeria',
    'ni'  => 'Nikaragwa',
    'nl'  => 'Uholandhi',
    'no'  => 'Norwe',
    'np'  => 'Nepali',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'Nauru',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'Niue',
    'nz'  => 'Nyudhilandi',
    'om'  => 'Omani',
    'pa'  => 'Panama',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'Peru',
    'pf'  => "Polinesia\ ya\ Ufarantha",
    'pg'  => 'Papua',
    'ph'  => 'Filipino',
    'pk'  => 'Pakithtani',
    'pl'  => 'Polandi',
    'pm'  => "Thantapieri\ na\ Mikeloni",
    'pn'  => 'Pitkairni',
    'pr'  => 'Pwetoriko',
    'ps'  => 'Palestina',
    'pt'  => 'Ureno',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'Palau',
    'py'  => 'Paragwai',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'Katari',
    'qo'  => "Outlying\ Oceania",
    're'  => 'Riyunioni',
    'ro'  => 'Romania',
    'rs'  => 'Serbia',
    'ru'  => 'Uruthi',
    'rw'  => 'Rwanda',
    'sa'  => 'Thaudi',
    'sb'  => "Vithiwa\ vya\ Tholomon",
    'sc'  => 'Shelisheli',
    'sd'  => 'Thudani',
    'se'  => 'Uthwidi',
    'sg'  => 'Thingapoo',
    'sh'  => 'Thantahelena',
    'si'  => 'Thlovenia',
    'sj'  => "Svalbard\ and\ Jan\ Mayen",
    'sk'  => 'Tholvakia',
    'sl'  => "Thiera\ Leoni",
    'sm'  => 'Thamarino',
    'sn'  => 'Thenegali',
    'so'  => 'Thomalia',
    'sr'  => 'Thurinamu',
    'st'  => "Thao\ Tome\ na\ Principe",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => 'Elsavado',
    'sy'  => 'Thiria',
    'sz'  => 'Uthwadhi',
    'ta'  => "Tristan\ da\ Cunha",
    'tc'  => "Vithiwa\ vya\ Turki\ na\ Kaiko",
    'td'  => 'Chadi',
    'tf'  => "French\ Southern\ Territories",
    'tg'  => 'Togo',
    'th'  => 'Tailandi',
    'tj'  => 'Tajikithtani',
    'tk'  => 'Tokelau',
    'tl'  => "Timori\ ya\ Mashariki",
    'tm'  => 'Turukimenithtani',
    'tn'  => 'Tunithia',
    'to'  => 'Tonga',
    'tr'  => 'Uturuki',
    'tt'  => "Trinidad\ na\ Tobago",
    'tv'  => 'Tuvalu',
    'tw'  => 'Taiwani',
    'tz'  => 'Tadhania',
    'ua'  => 'Ukraine',
    'ug'  => 'Uganda',
    'um'  => "U\.S\.\ Minor\ Outlying\ Islands",
    'us'  => 'Marekani',
    'uy'  => 'Urugwai',
    'uz'  => 'Udhibekithtani',
    'va'  => 'Vatikani',
    'vc'  => "Thantavithenti\ na\ Grenadini",
    'vd'  => "North\ Vietnam",
    've'  => 'Venezuela',
    'vg'  => "Vithiwa\ vya\ Virgin\ vya\ Uingeredha",
    'vi'  => "Vithiwa\ vya\ Virgin\ vya\ Marekani",
    'vn'  => 'Vietinamu',
    'vu'  => 'Vanuatu',
    'wf'  => "Walith\ na\ Futuna",
    'wk'  => "Wake\ Island",
    'ws'  => 'Thamoa',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'Yemeni',
    'yt'  => 'Mayotte',
    'za'  => "Afrika\ Kuthini",
    'zm'  => 'Dhambia',
    'zw'  => 'Dhimbabwe',
    'zz'  => "Unknown\ Region",
);

%Locales::DB::Territory::asa::name_to_code = (
    'adhabajani'                                => 'az',
    'africa'                                    => '002',
    'afrikakuthini'                             => 'za',
    'afuganistani'                              => 'af',
    'aithlandi'                                 => 'is',
    'ajentina'                                  => 'ar',
    'albania'                                   => 'al',
    'aljeria'                                   => 'dz',
    'americas'                                  => '019',
    'andora'                                    => 'ad',
    'angola'                                    => 'ao',
    'anguilla'                                  => 'ai',
    'antarctica'                                => 'aq',
    'antiguanabarbuda'                          => 'ag',
    'antilizauholandhi'                         => 'an',
    'armenia'                                   => 'am',
    'aruba'                                     => 'aw',
    'ascensionisland'                           => 'ac',
    'asia'                                      => 142,
    'australiaandnewzealand'                    => '053',
    'authtralia'                                => 'au',
    'authtria'                                  => 'at',
    'ayalandi'                                  => 'ie',
    'babadothi'                                 => 'bb',
    'bahama'                                    => 'bs',
    'bahareni'                                  => 'bh',
    'bangladeshi'                               => 'bd',
    'belaruthi'                                 => 'by',
    'belidhe'                                   => 'bz',
    'benini'                                    => 'bj',
    'bermuda'                                   => 'bm',
    'bolivia'                                   => 'bo',
    'bothnianahedhegovina'                      => 'ba',
    'botthwana'                                 => 'bw',
    'bouvetisland'                              => 'bv',
    'brazili'                                   => 'br',
    'britishantarcticterritory'                 => 'bq',
    'brunei'                                    => 'bn',
    'bukinafatho'                               => 'bf',
    'bukini'                                    => 'mg',
    'bulgaria'                                  => 'bg',
    'burundi'                                   => 'bi',
    'butani'                                    => 'bt',
    'canaryislands'                             => 'ic',
    'cantonandenderburyislands'                 => 'ct',
    'caribbean'                                 => '029',
    'centralamerica'                            => '013',
    'centralasia'                               => 143,
    'ceutaandmelilla'                           => 'ea',
    'chadi'                                     => 'td',
    'channelislands'                            => 830,
    'chile'                                     => 'cl',
    'china'                                     => 'cn',
    'christmasisland'                           => 'cx',
    'clippertonisland'                          => 'cp',
    'cocoskeelingislands'                       => 'cc',
    'commonwealthofindependentstates'           => 172,
    'czechoslovakia'                            => 200,
    'denmaki'                                   => 'dk',
    'dhambia'                                   => 'zm',
    'dhimbabwe'                                 => 'zw',
    'diegogarcia'                               => 'dg',
    'dominika'                                  => 'dm',
    'dronningmaudland'                          => 'nq',
    'easternafrica'                             => '014',
    'easternasia'                               => '030',
    'easterneurope'                             => 151,
    'eastgermany'                               => 'dd',
    'ekwado'                                    => 'ec',
    'elsavado'                                  => 'sv',
    'eritrea'                                   => 'er',
    'ethtonia'                                  => 'ee',
    'europe'                                    => 150,
    'europeanunion'                             => 'eu',
    'falmedhakiarabu'                           => 'ae',
    'faroeislands'                              => 'fo',
    'fiji'                                      => 'fj',
    'filipino'                                  => 'ph',
    'frenchsouthernandantarcticterritories'     => 'fq',
    'frenchsouthernterritories'                 => 'tf',
    'gaboni'                                    => 'ga',
    'gambia'                                    => 'gm',
    'ghana'                                     => 'gh',
    'gine'                                      => 'gn',
    'ginebisau'                                 => 'gw',
    'ginekweta'                                 => 'gq',
    'grenada'                                   => 'gd',
    'grinlandi'                                 => 'gl',
    'guernsey'                                  => 'gg',
    'guyana'                                    => 'gy',
    'gwadelupe'                                 => 'gp',
    'gwam'                                      => 'gu',
    'gwatemala'                                 => 'gt',
    'gwiyanayaufarantha'                        => 'gf',
    'haiti'                                     => 'ht',
    'heardislandandmcdonaldislands'             => 'hm',
    'hithpania'                                 => 'es',
    'hondurathi'                                => 'hn',
    'hongkong'                                  => 'hk',
    'hungaria'                                  => 'hu',
    'ieneolauingeredhakatikabaharihindi'        => 'io',
    'india'                                     => 'in',
    'indonethia'                                => 'id',
    'iraki'                                     => 'iq',
    'isleofman'                                 => 'im',
    'italia'                                    => 'it',
    'ithraeli'                                  => 'il',
    'jamaika'                                   => 'jm',
    'jamhuriyaafrikayakati'                     => 'cf',
    'jamhuriyacheki'                            => 'cz',
    'jamhuriyadominika'                         => 'do',
    'jamhuriyakidemokrathiayakongo'             => 'cd',
    'japani'                                    => 'jp',
    'jersey'                                    => 'je',
    'jibralta'                                  => 'gi',
    'jibuti'                                    => 'dj',
    'johnstonisland'                            => 'jt',
    'jojia'                                     => 'ge',
    'kambodia'                                  => 'kh',
    'kameruni'                                  => 'cm',
    'kanada'                                    => 'ca',
    'katari'                                    => 'qa',
    'kazakithtani'                              => 'kz',
    'kenya'                                     => 'ke',
    'kepuvede'                                  => 'cv',
    'kiribati'                                  => 'ki',
    'kirigizithtani'                            => 'kg',
    'kithiwachanorfok'                          => 'nf',
    'kodivaa'                                   => 'ci',
    'kolombia'                                  => 'co',
    'komoro'                                    => 'km',
    'kongo'                                     => 'cg',
    'korathia'                                  => 'hr',
    'koreakathkazini'                           => 'kp',
    'koreakuthini'                              => 'kr',
    'kothtarika'                                => 'cr',
    'kuba'                                      => 'cu',
    'kuprothi'                                  => 'cy',
    'kuwaiti'                                   => 'kw',
    'laothi'                                    => 'la',
    'lathembagi'                                => 'lu',
    'latinamerica'                              => 419,
    'lativia'                                   => 'lv',
    'lebanoni'                                  => 'lb',
    'lethoto'                                   => 'ls',
    'liberia'                                   => 'lr',
    'libya'                                     => 'ly',
    'lishenteni'                                => 'li',
    'litwania'                                  => 'lt',
    'macau'                                     => 'mo',
    'malawi'                                    => 'mw',
    'malethia'                                  => 'my',
    'mali'                                      => 'ml',
    'malta'                                     => 'mt',
    'marekani'                                  => 'us',
    'martiniki'                                 => 'mq',
    'mathedonia'                                => 'mk',
    'mayotte'                                   => 'yt',
    'mekthiko'                                  => 'mx',
    'melanesia'                                 => '054',
    'metropolitanfrance'                        => 'fx',
    'micronesianregion'                         => '057',
    'middleafrica'                              => '017',
    'midwayislands'                             => 'mi',
    'mikronethia'                               => 'fm',
    'mithri'                                    => 'eg',
    'modivu'                                    => 'mv',
    'moldova'                                   => 'md',
    'monako'                                    => 'mc',
    'mongolia'                                  => 'mn',
    'montenegro'                                => 'me',
    'monttherrati'                              => 'ms',
    'moritania'                                 => 'mr',
    'morithi'                                   => 'mu',
    'moroko'                                    => 'ma',
    'mthumbiji'                                 => 'mz',
    'myama'                                     => 'mm',
    'namibia'                                   => 'na',
    'nauru'                                     => 'nr',
    'nepali'                                    => 'np',
    'neutralzone'                               => 'nt',
    'nijeri'                                    => 'ne',
    'nijeria'                                   => 'ng',
    'nikaragwa'                                 => 'ni',
    'niue'                                      => 'nu',
    'northamerica'                              => '003',
    'northernafrica'                            => '015',
    'northernamerica'                           => '021',
    'northerneurope'                            => 154,
    'northvietnam'                              => 'vd',
    'norwe'                                     => 'no',
    'nyudhilandi'                               => 'nz',
    'nyukaledonia'                              => 'nc',
    'oceania'                                   => '009',
    'omani'                                     => 'om',
    'outlyingoceania'                           => 'qo',
    'pacificislandstrustterritory'              => 'pc',
    'pakithtani'                                => 'pk',
    'palau'                                     => 'pw',
    'palestina'                                 => 'ps',
    'panama'                                    => 'pa',
    'panamacanalzone'                           => 'pz',
    'papua'                                     => 'pg',
    'paragwai'                                  => 'py',
    "people\â\\sdemocraticrepublicofyemen" => 'yd',
    'peru'                                      => 'pe',
    'pitkairni'                                 => 'pn',
    'polandi'                                   => 'pl',
    'polinesiayaufarantha'                      => 'pf',
    'polynesia'                                 => '061',
    'pwetoriko'                                 => 'pr',
    'riyunioni'                                 => 're',
    'romania'                                   => 'ro',
    'rwanda'                                    => 'rw',
    "saintbarth\Ã\©lemy"                      => 'bl',
    'saintmartin'                               => 'mf',
    'serbia'                                    => 'rs',
    'shelisheli'                                => 'sc',
    'southamerica'                              => '005',
    'southcentralasia'                          => '062',
    'southeasternasia'                          => '035',
    'southernafrica'                            => '018',
    'southernasia'                              => '034',
    'southerneurope'                            => '039',
    'southgeorgiaandthesouthsandwichislands'    => 'gs',
    'svalbardandjanmayen'                       => 'sj',
    'tadhania'                                  => 'tz',
    'tailandi'                                  => 'th',
    'taiwani'                                   => 'tw',
    'tajikithtani'                              => 'tj',
    'thamarino'                                 => 'sm',
    'thamoa'                                    => 'ws',
    'thamoayamarekani'                          => 'as',
    'thantahelena'                              => 'sh',
    'thantakitdhinanevith'                      => 'kn',
    'thantaluthia'                              => 'lc',
    'thantapierinamikeloni'                     => 'pm',
    'thantavithentinagrenadini'                 => 'vc',
    'thaotomenaprincipe'                        => 'st',
    'thaudi'                                    => 'sa',
    'thenegali'                                 => 'sn',
    'therbianamontenegro'                       => 'cs',
    'thieraleoni'                               => 'sl',
    'thingapoo'                                 => 'sg',
    'thiria'                                    => 'sy',
    'thirilanka'                                => 'lk',
    'thlovenia'                                 => 'si',
    'tholvakia'                                 => 'sk',
    'thomalia'                                  => 'so',
    'thudani'                                   => 'sd',
    'thurinamu'                                 => 'sr',
    'timoriyamashariki'                         => 'tl',
    'togo'                                      => 'tg',
    'tokelau'                                   => 'tk',
    'tonga'                                     => 'to',
    'trinidadnatobago'                          => 'tt',
    'tristandacunha'                            => 'ta',
    'tunithia'                                  => 'tn',
    'turukimenithtani'                          => 'tm',
    'tuvalu'                                    => 'tv',
    "u\.s\.minoroutlyingislands"                => 'um',
    "u\.s\.miscellaneouspacificislands"         => 'pu',
    'uajemi'                                    => 'ir',
    'ubelgiji'                                  => 'be',
    'udhibekithtani'                            => 'uz',
    'ufarantha'                                 => 'fr',
    'ufini'                                     => 'fi',
    'uganda'                                    => 'ug',
    'ugiriki'                                   => 'gr',
    'uhabeshi'                                  => 'et',
    'uholandhi'                                 => 'nl',
    'uingeredha'                                => 'gb',
    'ujerumani'                                 => 'de',
    'ukraine'                                   => 'ua',
    'unionofsovietsocialistrepublics'           => 'su',
    'unknownregion'                             => 'zz',
    'ureno'                                     => 'pt',
    'urugwai'                                   => 'uy',
    'uruthi'                                    => 'ru',
    'uthwadhi'                                  => 'sz',
    'uthwidi'                                   => 'se',
    'uthwithi'                                  => 'ch',
    'uturuki'                                   => 'tr',
    'vanuatu'                                   => 'vu',
    'vatikani'                                  => 'va',
    'venezuela'                                 => 've',
    'vietinamu'                                 => 'vn',
    'vithiwavyacook'                            => 'ck',
    'vithiwavyafalkland'                        => 'fk',
    'vithiwavyakayman'                          => 'ky',
    'vithiwavyamarianavyakathkazini'            => 'mp',
    'vithiwavyamarshal'                         => 'mh',
    'vithiwavyatholomon'                        => 'sb',
    'vithiwavyaturkinakaiko'                    => 'tc',
    'vithiwavyavirginvyamarekani'               => 'vi',
    'vithiwavyavirginvyauingeredha'             => 'vg',
    'wakeisland'                                => 'wk',
    'walithnafutuna'                            => 'wf',
    'westernafrica'                             => '011',
    'westernasia'                               => 145,
    'westerneurope'                             => 155,
    'westernsahara'                             => 'eh',
    'world'                                     => '001',
    'yemeni'                                    => 'ye',
    'yordani'                                   => 'jo',
    "\Ã\landislands"                         => 'ax',
);

1;

