package App::InteractivePerlTutorial::Chapter::Control::For;

use 5.014000;
use strict;
use warnings;
our $VERSION = '0.000_001';

use constant TEXT => 'For';

1;
__DATA__

=encoding utf-8

=head1 For

The C<for> control structure in Perl works just like the C structure of the same name. Its general form is:

   for (initialisation; test; increment or decrement) {
   ...
   }

The structure above is actually a while loop in disguise:

  initialisation;
  while (test) {
    ...;
    increment;
  }

 We generally use the for loop for making computed iterations:

  for ($i = 1; $i <= 10; $i++){             # this program will print "Hello"
    print "Hello\n";                                  10 times, each time on a new line, until $i reaches 10;
  }

Notice that when $i=11, the program will stop running the block code in the for structure.

We can also use decrement instead of increment in the program above. The output will be exactly the same. The difference is that the test and initialisation will be

  for ($i = 10; $i >= 1; $i--){
    print "Hello\n";
  }


=cut
