package Graphics::ColorNamesCMYK::JohnDecemberCom;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-06'; # DATE
our $DIST = 'Graphics-ColorNamesCMYK-JohnDecemberCom'; # DIST
our $VERSION = '0.001'; # VERSION

our $NAMES_CMYK_TABLE = {
  q(alaska sky) => 0x5137002d, # 81,55,0,45
  q(aliceblue (svg)) => 0x06030000, # 6,3,0,0
  q(aluminum) => 0x0705001d, # 7,5,0,29
  q(amethyst) => 0x00201026, # 0,32,16,38
  q(anjou pear) => 0x0006601b, # 0,6,96,27
  q(antiquewhite1) => 0x00060e00, # 0,6,14,0
  q(antiquewhite4) => 0x00060e2d, # 0,6,14,45
  q(antiquewhite (svg)) => 0x00060e02, # 0,6,14,2
  q(apricot) => 0x00243902, # 0,36,57,2
  q(aquamarine4) => 0x3200112d, # 50,0,17,45
  q(aquamarine) => 0x3100210e, # 49,0,33,14
  q(aquamarine (svg)) => 0x32001100, # 50,0,17,0
  q(aquarium) => 0x48000c21, # 72,0,12,33
  q(ash) => 0x00020916, # 0,2,9,22
  q(avacado) => 0x10003718, # 16,0,55,24
  q(azure3) => 0x06000014, # 6,0,0,20
  q(barney) => 0x004d2211, # 0,77,34,17
  q(bartlett pear) => 0x00114e14, # 0,17,78,20
  q(battleship) => 0x01000712, # 1,0,7,18
  q(beach sand) => 0x000a1a07, # 0,10,26,7
  q(beige (svg)) => 0x00000a04, # 0,0,10,4
  q(bisque3) => 0x000b1714, # 0,11,23,20
  q(blackberry) => 0x0000034d, # 0,0,3,77
  q(black (safe 16 svg hex3)) => 0x00000064, # 0,0,0,100
  q(bloodorange (hex3)) => 0x005c6414, # 0,92,100,20
  q(bloodred (safe hex3)) => 0x0064643c, # 0,100,100,60
  q(blueberry fresh) => 0x31230020, # 49,35,0,32
  q(blue corn chips) => 0x000b0241, # 0,11,2,65
  q(bluegrass) => 0x20000b38, # 32,0,11,56
  q(blue ice) => 0x0b000204, # 11,0,2,4
  q(blue jeans) => 0x2718003a, # 39,24,0,58
  q(blue line) => 0x4d1b000d, # 77,27,0,13
  q(blue ridge mtns) => 0x41250013, # 65,37,0,19
  q(bone (safe hex3)) => 0x00001400, # 0,0,20,0
  q(bordeaux) => 0x00544728, # 0,84,71,40
  q(breadfruit) => 0x0f004b27, # 15,0,75,39
  q(brightgold) => 0x0000580f, # 0,0,88,15
  q(bright red (safe hex3)) => 0x00645000, # 0,100,80,0
  q(bronzeii) => 0x00193f23, # 0,25,63,35
  q(brown2) => 0x004b4b07, # 0,75,75,7
  q(brown4) => 0x004b4b2d, # 0,75,75,45
  q(brownmadder) => 0x0051510e, # 0,81,81,14
  q(brownochre) => 0x00334d2f, # 0,51,77,47
  q(brown (svg)) => 0x004b4b23, # 0,75,75,35
  q(brushed aluminum) => 0x08000417, # 8,0,4,23
  q(bubble gum) => 0x002b1b00, # 0,43,27,0
  q(burlywood (svg)) => 0x0011270d, # 0,17,39,13
  q(buttermilk) => 0x00051d00, # 0,5,29,0
  q(cadetblue3) => 0x28040014, # 40,4,0,20
  q(cadetblue) => 0x28000026, # 40,0,0,38
  q(cadmiumorange) => 0x003e6300, # 0,62,99,0
  q(cadmiumredlight) => 0x00635f00, # 0,99,95,0
  q(cafe americano) => 0x001a364f, # 0,26,54,79
  q(camo2) => 0x10001215, # 16,0,18,21
  q(canvas) => 0x000d3026, # 0,13,48,38
  q(carnation) => 0x0028140d, # 0,40,20,13
  q(cashew) => 0x0016300d, # 0,22,48,13
  q(cat eye) => 0x11003f0a, # 17,0,63,10
  q(cat eye) => 0x2d18000d, # 45,24,0,13
  q(chartreuse3) => 0x32006414, # 50,0,100,20
  q(cherry) => 0x003c3908, # 0,60,57,8
  q(chili) => 0x00424511, # 0,66,69,17
  q(chocolate1) => 0x00325600, # 0,50,86,0
  q(chocolate3) => 0x00325614, # 0,50,86,20
  q(chromeoxidegreen) => 0x14005432, # 20,0,84,50
  q(cichlid) => 0x644c0000, # 100,76,0,0
  q(cinnabargreen) => 0x2e004d1e, # 46,0,77,30
  q(circuit board) => 0x2b003c3c, # 43,0,60,60
  q(clover) => 0x3d002f25, # 61,0,47,37
  q(cobaltgreen) => 0x3a00382b, # 58,0,56,43
  q(cobalt (safe hex3)) => 0x3c3c0000, # 60,60,0,0
  q(cobaltvioletdeep) => 0x084f0026, # 8,79,0,38
  q(coconut) => 0x00011300, # 0,1,19,0
  q(coconut shell) => 0x0025411a, # 0,37,65,26
  q(coffee) => 0x00336221, # 0,51,98,33
  q(concord grape) => 0x21630028, # 33,99,0,40
  q(cooler) => 0x2d000a47, # 45,0,10,71
  q(coral1) => 0x00374200, # 0,55,66,0
  q(cornsilk2) => 0x00030e07, # 0,3,14,7
  q(cornsilk3) => 0x00020e14, # 0,2,14,20
  q(cornsilk4) => 0x00020e2d, # 0,2,14,45
  q(cornsilk (svg)) => 0x00030e00, # 0,3,14,0
  q(cotton candy) => 0x001c0c03, # 0,28,12,3
  q(cranberry) => 0x0049291d, # 0,73,41,29
  q(cream city brick) => 0x0002140b, # 0,2,20,11
  q(crimson (svg)) => 0x005b490e, # 0,91,73,14
  q(cucumber) => 0x35002040, # 53,0,32,64
  q(curacao) => 0x3334001b, # 51,52,0,27
  q(cyan2 (hex3)) => 0x64000007, # 100,0,0,7
  q(darkgoldenrod1) => 0x001b5e00, # 0,27,94,0
  q(darkgoldenrod (svg)) => 0x001b5e1c, # 0,27,94,28
  q(darkgray (svg)) => 0x00000022, # 0,0,0,34
  q(darkgreencopper) => 0x25000736, # 37,0,7,54
  q(darkgrey (svg)) => 0x00000022, # 0,0,0,34
  q(darkkhaki (svg)) => 0x00032b1a, # 0,3,43,26
  q(darkmagenta (svg)) => 0x0064002d, # 0,100,0,45
  q(darkolivegreen) => 0x00002945, # 0,0,41,69
  q(darkolivegreen3) => 0x15003814, # 21,0,56,20
  q(darkorange1) => 0x00326400, # 0,50,100,0
  q(darkorange4) => 0x0032642d, # 0,50,100,45
  q(darkorange (svg)) => 0x002d6400, # 0,45,100,0
  q(darkorchid1) => 0x194c0000, # 25,76,0,0
  q(darkorchid) => 0x194c0014, # 25,76,0,20
  q(darkseagreen2) => 0x18001807, # 24,0,24,7
  q(darkseagreen4) => 0x1800182d, # 24,0,24,45
  q(darkslateblue (svg)) => 0x3038002d, # 48,56,0,45
  q(darkslategray1) => 0x29000000, # 41,0,0,0
  q(darkslategray4) => 0x2900002d, # 41,0,0,45
  q(darktan) => 0x001e3029, # 0,30,48,41
  q(darkviolet (svg)) => 0x1e640011, # 30,100,0,17
  q(dark wheat) => 0x000e2c09, # 0,14,44,9
  q(darkwood) => 0x001d3230, # 0,29,50,48
  q(deeppink3) => 0x005c2a14, # 0,92,42,20
  q(deepskyblue3) => 0x64190014, # 100,25,0,20
  q(deepskyblue (svg)) => 0x64190000, # 100,25,0,0
  q(delft) => 0x4537003a, # 69,55,0,58
  q(denim) => 0x3d210021, # 61,33,0,33
  q(desert sand) => 0x00091000, # 0,9,16,0
  q(diamond blue) => 0x5e120009, # 94,18,0,9
  q(dimgray (svg)) => 0x0000003b, # 0,0,0,59
  q(dimgrey (svg)) => 0x0000003b, # 0,0,0,59
  q(dodgerblue3) => 0x582b0014, # 88,43,0,20
  q(dodgerblue4) => 0x582c002d, # 88,44,0,45
  q(dog tongue) => 0x00210d04, # 0,33,13,4
  q(eggplant) => 0x0418002f, # 4,24,0,47
  q(englishred) => 0x00475811, # 0,71,88,17
  q(eton blue) => 0x19001316, # 25,0,19,22
  q(fenway monster) => 0x27020034, # 39,2,0,52
  q(firebrick4) => 0x0051512d, # 0,81,81,45
  q(fire truck green) => 0x05006210, # 5,0,98,16
  q(flatpink (safe hex3)) => 0x00141400, # 0,20,20,0
  q(floralwhite (svg)) => 0x00020600, # 0,2,6,0
  q(fog) => 0x00000a14, # 0,0,10,20
  q(fraser fir) => 0x1c00193a, # 28,0,25,58
  q(fresh green) => 0x39001c0f, # 57,0,28,15
  q(fuchsia2 (hex3)) => 0x00642100, # 0,100,33,0
  q(gainsboro (svg)) => 0x0000000e, # 0,0,0,14
  q(ganegreen (hex3)) => 0x00003935, # 0,0,57,53
  q(garden hose) => 0x57001a2c, # 87,0,26,44
  q(gold4) => 0x0010642d, # 0,16,100,45
  q(gold5) => 0x00264b14, # 0,38,75,20
  q(goldenrod) => 0x0000310e, # 0,0,49,14
  q(goldenrod2) => 0x00185607, # 0,24,86,7
  q(goldochre) => 0x00285116, # 0,40,81,22
  q(gold (svg)) => 0x00106400, # 0,16,100,0
  q(grapefruit) => 0x00052a05, # 0,5,42,5
  q(grass) => 0x3b00491a, # 59,0,73,26
  q(gray) => 0x00000019, # 0,0,0,25
  q(gray10) => 0x0000005a, # 0,0,0,90
  q(gray1) => 0x00000063, # 0,0,0,99
  q(gray11) => 0x00000059, # 0,0,0,89
  q(gray12) => 0x00000058, # 0,0,0,88
  q(gray13) => 0x00000057, # 0,0,0,87
  q(gray14) => 0x00000056, # 0,0,0,86
  q(gray15) => 0x00000055, # 0,0,0,85
  q(gray16) => 0x00000054, # 0,0,0,84
  q(gray (16 svg)) => 0x00000032, # 0,0,0,50
  q(gray17) => 0x00000053, # 0,0,0,83
  q(gray18) => 0x00000052, # 0,0,0,82
  q(gray19) => 0x00000051, # 0,0,0,81
  q(gray2) => 0x00000062, # 0,0,0,98
  q(gray20 (safe hex3)) => 0x00000050, # 0,0,0,80
  q(gray21) => 0x0000004f, # 0,0,0,79
  q(gray22) => 0x0000004e, # 0,0,0,78
  q(gray23) => 0x0000004d, # 0,0,0,77
  q(gray24) => 0x0000004c, # 0,0,0,76
  q(gray25) => 0x0000004b, # 0,0,0,75
  q(gray26) => 0x0000004a, # 0,0,0,74
  q(gray27) => 0x00000049, # 0,0,0,73
  q(gray28) => 0x00000048, # 0,0,0,72
  q(gray29) => 0x00000047, # 0,0,0,71
  q(gray30) => 0x00000046, # 0,0,0,70
  q(gray3) => 0x00000061, # 0,0,0,97
  q(gray31) => 0x00000045, # 0,0,0,69
  q(gray32) => 0x00000044, # 0,0,0,68
  q(gray33 (hex3)) => 0x00000043, # 0,0,0,67
  q(gray34) => 0x00000042, # 0,0,0,66
  q(gray35) => 0x00000041, # 0,0,0,65
  q(gray36) => 0x00000040, # 0,0,0,64
  q(gray37) => 0x0000003f, # 0,0,0,63
  q(gray38) => 0x0000003e, # 0,0,0,62
  q(gray39) => 0x0000003d, # 0,0,0,61
  q(gray4) => 0x00000060, # 0,0,0,96
  q(gray40 (safe hex3)) => 0x0000003c, # 0,0,0,60
  q(gray42) => 0x0000003a, # 0,0,0,58
  q(gray43) => 0x00000039, # 0,0,0,57
  q(gray44) => 0x00000038, # 0,0,0,56
  q(gray45) => 0x00000037, # 0,0,0,55
  q(gray46) => 0x00000036, # 0,0,0,54
  q(gray47) => 0x00000035, # 0,0,0,53
  q(gray48) => 0x00000034, # 0,0,0,52
  q(gray49) => 0x00000033, # 0,0,0,51
  q(gray50) => 0x00000032, # 0,0,0,50
  q(gray5) => 0x0000005f, # 0,0,0,95
  q(gray51) => 0x00000031, # 0,0,0,49
  q(gray52) => 0x00000030, # 0,0,0,48
  q(gray53) => 0x0000002f, # 0,0,0,47
  q(gray54) => 0x0000002e, # 0,0,0,46
  q(gray55) => 0x0000002d, # 0,0,0,45
  q(gray56) => 0x0000002c, # 0,0,0,44
  q(gray57) => 0x0000002b, # 0,0,0,43
  q(gray58) => 0x0000002a, # 0,0,0,42
  q(gray59) => 0x00000029, # 0,0,0,41
  q(gray6) => 0x0000005e, # 0,0,0,94
  q(gray60 (safe hex3)) => 0x00000028, # 0,0,0,40
  q(gray61) => 0x00000027, # 0,0,0,39
  q(gray62) => 0x00000026, # 0,0,0,38
  q(gray63) => 0x00000025, # 0,0,0,37
  q(gray64) => 0x00000024, # 0,0,0,36
  q(gray65) => 0x00000023, # 0,0,0,35
  q(gray66) => 0x00000022, # 0,0,0,34
  q(gray67) => 0x00000021, # 0,0,0,33
  q(gray68) => 0x00000020, # 0,0,0,32
  q(gray69) => 0x0000001f, # 0,0,0,31
  q(gray70) => 0x0000001e, # 0,0,0,30
  q(gray7) => 0x0000005d, # 0,0,0,93
  q(gray71) => 0x0000001d, # 0,0,0,29
  q(gray72) => 0x0000001c, # 0,0,0,28
  q(gray73) => 0x0000001b, # 0,0,0,27
  q(gray74) => 0x0000001a, # 0,0,0,26
  q(gray75) => 0x00000019, # 0,0,0,25
  q(gray76) => 0x00000018, # 0,0,0,24
  q(gray77) => 0x00000017, # 0,0,0,23
  q(gray78) => 0x00000016, # 0,0,0,22
  q(gray79) => 0x00000015, # 0,0,0,21
  q(gray8) => 0x0000005c, # 0,0,0,92
  q(gray80 (safe hex3)) => 0x00000014, # 0,0,0,20
  q(gray81) => 0x00000013, # 0,0,0,19
  q(gray82) => 0x00000012, # 0,0,0,18
  q(gray83) => 0x00000011, # 0,0,0,17
  q(gray84) => 0x00000010, # 0,0,0,16
  q(gray85) => 0x0000000f, # 0,0,0,15
  q(gray86) => 0x0000000e, # 0,0,0,14
  q(gray87) => 0x0000000d, # 0,0,0,13
  q(gray88) => 0x0000000c, # 0,0,0,12
  q(gray89) => 0x0000000b, # 0,0,0,11
  q(gray90) => 0x0000000a, # 0,0,0,10
  q(gray9) => 0x0000005b, # 0,0,0,91
  q(gray91) => 0x00000009, # 0,0,0,9
  q(gray92) => 0x00000008, # 0,0,0,8
  q(gray93) => 0x00000007, # 0,0,0,7
  q(gray94) => 0x00000006, # 0,0,0,6
  q(gray95) => 0x00000005, # 0,0,0,5
  q(gray97) => 0x00000003, # 0,0,0,3
  q(gray98) => 0x00000002, # 0,0,0,2
  q(gray99) => 0x00000001, # 0,0,0,1
  q(green (16 svg)) => 0x64006432, # 100,0,100,50
  q(green3) => 0x64006414, # 100,0,100,20
  q(green algae) => 0x2a002b21, # 42,0,43,33
  q(green apple) => 0x23004329, # 35,0,67,41
  q(green ash) => 0x1c00062c, # 28,0,6,44
  q(green card) => 0x11000502, # 17,0,5,2
  q(green gables) => 0x2f000836, # 47,0,8,54
  q(green grape) => 0x00015a13, # 0,1,90,19
  q(green lantern) => 0x38003c2d, # 56,0,60,45
  q(green led) => 0x3f006001, # 63,0,96,1
  q(green mist) => 0x15002707, # 21,0,39,7
  q(green pepper) => 0x36006233, # 54,0,98,51
  q(green stamp) => 0x22001c34, # 34,0,28,52
  q(greenyellow) => 0x2100310e, # 33,0,49,14
  q(greenyellow (svg)) => 0x20005200, # 32,0,82,0
  q(grey (16 svg)) => 0x00000032, # 0,0,0,50
  q(guacamole) => 0x17002610, # 23,0,38,16
  q(gummi yellow) => 0x000d5f02, # 0,13,95,2
  q(heather blue) => 0x0c060012, # 12,6,0,18
  q(honeydew2) => 0x06000607, # 6,0,6,7
  q(hotpink (svg)) => 0x003b1d00, # 0,59,29,0
  q(iceberg lettuce) => 0x0a00320b, # 10,0,50,11
  q(indianred1) => 0x003a3a00, # 0,58,58,0
  q(indiglo) => 0x62090000, # 98,9,0,0
  q(indigo dye) => 0x5b2b002d, # 91,43,0,45
  q(indigo (svg)) => 0x2a640031, # 42,100,0,49
  q(ivory2) => 0x00000607, # 0,0,6,7
  q(ivory3) => 0x00000614, # 0,0,6,20
  q(ivory4) => 0x0000062d, # 0,0,6,45
  q(ivory (svg)) => 0x00000600, # 0,0,6,0
  q(jonathan apple) => 0x003f4c1e, # 0,63,76,30
  q(kermit) => 0x0e005a1a, # 14,0,90,26
  q(khaki) => 0x00002826, # 0,0,40,38
  q(khaki1) => 0x00042c00, # 0,4,44,0
  q(khaki2) => 0x00032c07, # 0,3,44,7
  q(khaki3) => 0x00032c14, # 0,3,44,20
  q(khaki4) => 0x00042c2d, # 0,4,44,45
  q(khaki (svg)) => 0x00042a06, # 0,4,42,6
  q(kiwi) => 0x12002228, # 18,0,34,40
  q(kumquat) => 0x0026600e, # 0,38,96,14
  q(lake huron) => 0x2510002a, # 37,16,0,42
  q(lake michigan) => 0x3b0e0018, # 59,14,0,24
  q(lake superior) => 0x2916002f, # 41,22,0,47
  q(la maison bleue) => 0x3e1f0000, # 62,31,0,0
  q(lavenderblush2) => 0x00060407, # 0,6,4,7
  q(lavenderblush3) => 0x00060414, # 0,6,4,20
  q(lavenderblush4) => 0x0006042d, # 0,6,4,45
  q(lavenderblush (svg)) => 0x00060400, # 0,6,4,0
  q(lavender field) => 0x02250035, # 2,37,0,53
  q(lavender (safe hex3)) => 0x00190014, # 0,25,0,20
  q(lemonchiffon2) => 0x00021407, # 0,2,20,7
  q(lemonchiffon3) => 0x00021414, # 0,2,20,20
  q(lemonchiffon4) => 0x0001132d, # 0,1,19,45
  q(lemonchiffon (svg)) => 0x00021400, # 0,2,20,0
  q(lightblue (svg)) => 0x1906000a, # 25,6,0,10
  q(light copper) => 0x00122607, # 0,18,38,7
  q(light cyan3) => 0x0c000014, # 12,0,0,20
  q(lightcyan (svg)) => 0x0c000000, # 12,0,0,0
  q(light goldenrod2) => 0x00082d07, # 0,8,45,7
  q(light goldenrod3) => 0x00072d14, # 0,7,45,20
  q(lightgoldenrodyellow (svg)) => 0x00001002, # 0,0,16,2
  q(lightgray (svg)) => 0x00000011, # 0,0,0,17
  q(light green (svg)) => 0x27002707, # 39,0,39,7
  q(lightgrey (svg)) => 0x00000011, # 0,0,0,17
  q(light pink1) => 0x00201b00, # 0,32,27,0
  q(light pink3) => 0x00201b14, # 0,32,27,20
  q(light salmon2) => 0x00253407, # 0,37,52,7
  q(light skyblue1) => 0x1f0b0000, # 31,11,0,0
  q(light skyblue4) => 0x1f0c002d, # 31,12,0,45
  q(light slateblue) => 0x30380000, # 48,56,0,0
  q(light steelblue1) => 0x150c0000, # 21,12,0,0
  q(light steelblue3) => 0x150c0014, # 21,12,0,20
  q(light wood) => 0x00111d09, # 0,17,29,9
  q(light yellow2) => 0x00000c07, # 0,0,12,7
  q(light yellow3) => 0x00000c14, # 0,0,12,20
  q(light yellow4) => 0x00000c2d, # 0,0,12,45
  q(lightyellow (svg)) => 0x00000c00, # 0,0,12,0
  q(limepulp) => 0x0b002707, # 11,0,39,7
  q(lindsay eyes) => 0x22060028, # 34,6,0,40
  q(linen (svg)) => 0x00040802, # 0,4,8,2
  q(liz eyes) => 0x39150037, # 57,21,0,55
  q(magenta2 (hex3)) => 0x00640007, # 0,100,0,7
  q(mailbox) => 0x47280023, # 71,40,0,35
  q(manatee gray) => 0x0006071f, # 0,6,7,31
  q(mandarianorange) => 0x002f4e0b, # 0,47,78,11
  q(maroon3) => 0x00501e14, # 0,80,30,20
  q(maroon4) => 0x00501d2d, # 0,80,29,45
  q(maroon5) => 0x0046633b, # 0,70,99,59
  q(marsorange) => 0x00365729, # 0,54,87,41
  q(masters jacket) => 0x40000d4b, # 64,0,13,75
  q(medium aquamarine2) => 0x4b001914, # 75,0,25,20
  q(medium aquamarine3) => 0x4c001914, # 76,0,25,20
  q(medium blue) => 0x4b4b0014, # 75,75,0,20
  q(mediumblue (svg)) => 0x64640014, # 100,100,0,20
  q(medium goldenrod) => 0x00001a08, # 0,0,26,8
  q(mediumorchid (svg)) => 0x0c3c0011, # 12,60,0,17
  q(medium purple1) => 0x21310000, # 33,49,0,0
  q(medium purple3) => 0x21310014, # 33,49,0,20
  q(medium seagreen) => 0x29002938, # 41,0,41,56
  q(mediumseagreen (svg)) => 0x4200251e, # 66,0,37,30
  q(medium slateblue2) => 0x32640000, # 50,100,0,0
  q(mediumvioletred (svg)) => 0x00592116, # 0,89,33,22
  q(medium wood) => 0x00172823, # 0,23,40,35
  q(midnightblue) => 0x29290045, # 41,41,0,69
  q(mint blue) => 0x0e000200, # 14,0,2,0
  q(mintcream (svg)) => 0x04000200, # 4,0,2,0
  q(mint ice cream) => 0x0d00100b, # 13,0,16,11
  q(mistyrose3) => 0x000b0c14, # 0,11,12,20
  q(naplesyellowdeep) => 0x00225d00, # 0,34,93,0
  q(natural turquoise) => 0x41000618, # 65,0,6,24
  q(navajowhite2) => 0x000d2007, # 0,13,32,7
  q(navy (16 svg)) => 0x64640032, # 100,100,0,50
  q(neonavocado (safe hex3)) => 0x64003c00, # 100,0,60,0
  q(neonblue) => 0x46460000, # 70,70,0,0
  q(neonpink) => 0x00391600, # 0,57,22,0
  q(newtan) => 0x000f2108, # 0,15,33,8
  q(od green) => 0x0f001b44, # 15,0,27,68
  q(offwhitegreen (safe hex3)) => 0x14001400, # 20,0,20,0
  q(oldlace (svg)) => 0x00030901, # 0,3,9,1
  q(old money) => 0x37002538, # 55,0,37,56
  q(olive (16 svg)) => 0x00006432, # 0,0,100,50
  q(olive3b) => 0x2500363f, # 37,0,54,63
  q(olivedrab (svg)) => 0x19004b2c, # 25,0,75,44
  q(orange4) => 0x0023642d, # 0,35,100,45
  q(orangered) => 0x00566400, # 0,86,100,0
  q(orangered2) => 0x00496407, # 0,73,100,7
  q(orange (svg)) => 0x00236400, # 0,35,100,0
  q(orchid4) => 0x0031012d, # 0,49,1,45
  q(orchid (svg)) => 0x0031020f, # 0,49,2,15
  q(pabst blue) => 0x483c002c, # 72,60,0,44
  q(pacific blue) => 0x3313003a, # 51,19,0,58
  q(packer gold) => 0x001c5c01, # 0,28,92,1
  q(palegoldenrod (svg)) => 0x00031d07, # 0,3,29,7
  q(palegreen3) => 0x28002814, # 40,0,40,20
  q(paleturquoise1 (hex3)) => 0x1b000000, # 27,0,0,0
  q(paleturquoise4) => 0x1b00002d, # 27,0,0,45
  q(palevioletred2) => 0x00312107, # 0,49,33,7
  q(palevioletred4) => 0x0031212d, # 0,49,33,45
  q(papaya) => 0x00003300, # 0,0,51,0
  q(park ranger) => 0x06000946, # 6,0,9,70
  q(parrot) => 0x4c2d000e, # 76,45,0,14
  q(parrotgreen (safe hex3)) => 0x50005000, # 80,0,80,0
  q(pastel blue) => 0x16020004, # 22,2,0,4
  q(peach) => 0x00060e00, # 0,6,14,0
  q(peachpuff (svg)) => 0x000f1b00, # 0,15,27,0
  q(pear) => 0x08004e0b, # 8,0,78,11
  q(permanent redviolet) => 0x0053440e, # 0,83,68,14
  q(peru (svg)) => 0x00234514, # 0,35,69,20
  q(picasso blue) => 0x63350001, # 99,53,0,1
  q(pickle) => 0x00024834, # 0,2,72,52
  q(pinegreen (safe hex3)) => 0x64006450, # 100,0,100,80
  q(pink2) => 0x001d1707, # 0,29,23,7
  q(pink candy) => 0x001a070e, # 0,26,7,14
  q(pink glass) => 0x000a0211, # 0,10,2,17
  q(pistachio shell) => 0x000c1b08, # 0,12,27,8
  q(plum2) => 0x001b0007, # 0,27,0,7
  q(plum pudding) => 0x0045282f, # 0,69,40,47
  q(police strobe) => 0x601d0000, # 96,29,0,0
  q(pool table) => 0x4a003a1b, # 74,0,58,27
  q(popcornyellow (hex3)) => 0x00002100, # 0,0,33,0
  q(powderblue (svg)) => 0x1703000a, # 23,3,0,10
  q(presidential blue) => 0x2b310043, # 43,49,0,67
  q(purple3) => 0x27510014, # 39,81,0,20
  q(purple ink) => 0x001f0327, # 0,31,3,39
  q(purple rose) => 0x163f0035, # 22,63,0,53
  q(ralphyellow (safe hex3)) => 0x00006414, # 0,0,100,20
  q(red3) => 0x00646414, # 0,100,100,20
  q(red roof) => 0x00353d16, # 0,53,61,22
  q(robin's egg) => 0x12040007, # 18,4,0,7
  q(romaine lettuce) => 0x1d003a43, # 29,0,58,67
  q(rosemadder) => 0x004c4b0b, # 0,76,75,11
  q(rosybrown2) => 0x00181807, # 0,24,24,7
  q(rosybrown4) => 0x0018182d, # 0,24,24,45
  q(royalblue2) => 0x48360007, # 72,54,0,7
  q(ruby red) => 0x00514916, # 0,81,73,22
  q(safety cone) => 0x00435000, # 0,67,80,0
  q(salmon1) => 0x002d3b00, # 0,45,59,0
  q(salmon4) => 0x002d3b2d, # 0,45,59,45
  q(sandybrown (svg)) => 0x00213d04, # 0,33,61,4
  q(scotland pound) => 0x24001b38, # 36,0,27,56
  q(seagreen3) => 0x43002614, # 67,0,38,20
  q(seagreen (svg)) => 0x4300252d, # 67,0,37,45
  q(seashell2) => 0x00040707, # 0,4,7,7
  q(seashell3) => 0x00040714, # 0,4,7,20
  q(seashell4) => 0x0004062d, # 0,4,6,45
  q(seashell (svg)) => 0x00040700, # 0,4,7,0
  q(semisweet chocolate1) => 0x0026403a, # 0,38,64,58
  q(sgibrightgray) => 0x00020e17, # 0,2,14,23
  q(sgilight gray (hex3)) => 0x00000021, # 0,0,0,33
  q(sgiolivedrab) => 0x00003d2c, # 0,0,61,44
  q(sienna2) => 0x00314807, # 0,49,72,7
  q(sienna4) => 0x0031492d, # 0,49,73,45
  q(sign orange) => 0x002f640d, # 0,47,100,13
  q(silver (16 svg)) => 0x00000019, # 0,0,0,25
  q(skyblue1) => 0x2f130000, # 47,19,0,0
  q(skyblue4) => 0x2f13002d, # 47,19,0,45
  q(slateblue) => 0x64320000, # 100,50,0,0
  q(slateblue3) => 0x31390014, # 49,57,0,20
  q(slategray3) => 0x160b0014, # 22,11,0,20
  q(slategrey (svg)) => 0x160b002c, # 22,11,0,44
  q(snow2) => 0x00020207, # 0,2,2,7
  q(snow3) => 0x00020214, # 0,2,2,20
  q(snow4) => 0x0001012d, # 0,1,1,45
  q(snow (svg)) => 0x00020200, # 0,2,2,0
  q(springgreen4) => 0x6400322d, # 100,0,50,45
  q(springgreen (safe hex3)) => 0x64005000, # 100,0,80,0
  q(springgreen (svg)) => 0x64003200, # 100,0,50,0
  q(stained glass) => 0x524e0000, # 82,78,0,0
  q(stainless steel) => 0x0000020c, # 0,0,2,12
  q(steelblue3) => 0x3d1c0014, # 61,28,0,20
  q(strawberry) => 0x00505119, # 0,80,81,25
  q(summersky) => 0x4b15000d, # 75,21,0,13
  q(sweet potato vine) => 0x13004715, # 19,0,71,21
  q(tangerine) => 0x00375b00, # 0,55,91,0
  q(tank) => 0x0003233e, # 0,3,35,62
  q(tan (svg)) => 0x000e2112, # 0,14,33,18
  q(teal (16 svg)) => 0x64000032, # 100,0,0,50
  q(terreverte) => 0x2800543f, # 40,0,84,63
  q(thistle1) => 0x000c0000, # 0,12,0,0
  q(thistle3) => 0x000c0014, # 0,12,0,20
  q(titanium) => 0x0004071d, # 0,4,7,29
  q(tomato4) => 0x003d492d, # 0,61,73,45
  q(tomato (svg)) => 0x003d4800, # 0,61,72,0
  q(turquoise2) => 0x64040007, # 100,4,0,7
  q(turquoise) => 0x1a000008, # 26,0,0,8
  q(turquoiseblue) => 0x64001e16, # 100,0,30,22
  q(vandykebrown) => 0x003c5f3f, # 0,60,95,63
  q(venetianred) => 0x00585511, # 0,88,85,17
  q(verylight grey) => 0x00000014, # 0,0,0,20
  q(violet) => 0x00290045, # 0,41,0,69
  q(violet flower) => 0x193f0000, # 25,63,0,0
  q(violetred) => 0x004b1914, # 0,75,25,20
  q(violetred3) => 0x004c2914, # 0,76,41,20
  q(warmgrey) => 0x00001232, # 0,0,18,50
  q(wasabi (safe hex3)) => 0x3c003c00, # 60,0,60,0
  q(wavecrest) => 0x19000214, # 25,0,2,20
  q(wheat) => 0x00000c0f, # 0,0,12,15
  q(wheat1) => 0x00091b00, # 0,9,27,0
  q(wheat3) => 0x00091b14, # 0,9,27,20
  q(white (safe 16 svg hex3)) => 0x00000000, # 0,0,0,0
  q(whitesmoke (svg)) => 0x00000004, # 0,0,0,4
  q(yellow2 (hex3)) => 0x00006407, # 0,0,100,7
  q(yellow3) => 0x00006414, # 0,0,100,20
  q(yellow4) => 0x0000642d, # 0,0,100,45
  q(yellow candy) => 0x00012907, # 0,1,41,7
  q(yellowgreen (svg)) => 0x19004c14, # 25,0,76,20
  q(yellowochre) => 0x002b5a0b, # 0,43,90,11
  q(yellow perch) => 0x0004310c, # 0,4,49,12
  q(yellow (safe 16 svg hex3)) => 0x00006400, # 0,0,100,0
  q(yinmn blue) => 0x442c002c, # 68,44,0,44
};


1;
# ABSTRACT: CMYK color names from johndecember.com

__END__

=pod

=encoding UTF-8

=head1 NAME

Graphics::ColorNamesCMYK::JohnDecemberCom - CMYK color names from johndecember.com

=head1 VERSION

This document describes version 0.001 of Graphics::ColorNamesCMYK::JohnDecemberCom (from Perl distribution Graphics-ColorNamesCMYK-JohnDecemberCom), released on 2024-05-06.

=head1 DESCRIPTION

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Graphics-ColorNamesCMYK-JohnDecemberCom>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Graphics-ColorNamesCMYK-JohnDecemberCom>.

=head1 SEE ALSO

Other C<Graphics::ColorNamesCMYK::*> modules.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Graphics-ColorNamesCMYK-JohnDecemberCom>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
