# Generated by default/object.tt
package Paws::SSMIncidents::Condition;
  use Moose;
  has After => (is => 'ro', isa => 'Str', request_name => 'after', traits => ['NameInRequest']);
  has Before => (is => 'ro', isa => 'Str', request_name => 'before', traits => ['NameInRequest']);
  has Equals => (is => 'ro', isa => 'Paws::SSMIncidents::AttributeValueList', request_name => 'equals', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMIncidents::Condition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMIncidents::Condition object:

  $service_obj->Method(Att1 => { After => $value, ..., Equals => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMIncidents::Condition object:

  $result = $service_obj->Method(...);
  $result->Att1->After

=head1 DESCRIPTION

A conditional statement with which to compare a value, after a
timestamp, before a timestamp, or equal to a string or integer. If
multiple conditions are specified, the conditionals become an C<AND>ed
statement. If multiple values are specified for a conditional, the
values are C<OR>d.

=head1 ATTRIBUTES


=head2 After => Str

After the specified timestamp.


=head2 Before => Str

Before the specified timestamp


=head2 Equals => L<Paws::SSMIncidents::AttributeValueList>

The value is equal to the provided string or integer.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMIncidents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

