# Copyright (C) 2008 Wes Hardaker
# License: Same as perl.  See the LICENSE file for details.
package Ham::Callsign::DB::DX;

use Ham::Callsign::DB;
use Ham::Callsign;

our @ISA = qw(Ham::Callsign::DB);

use strict;

my $dxcc;

sub do_lookup {
    my ($self, $callsign) = @_;

    my @results;

    foreach my $key (keys(%$dxcc)) {
	if ($callsign =~ /^$key/) {
	    push @results, new Ham::Callsign('FromDB' => 'DX',
					     'Prefix' => $key,
					     'thecallsign' => $callsign,
					     'qth' => "$key = $dxcc->{$key}",
					     'prefix' => '$key');
	}
    }
    return \@results;
}

sub init {
    $dxcc = {
          'VZ9Y' => 'Cocos-Keeling',
          'WL7K' => 'United States',
          'K3CQ' => 'United States',
          'GB8AYR' => 'Scotland',
          'RA9M' => 'Asiatic Russia',
          'RC0' => 'Asiatic Russia',
          'AT' => 'India',
          'RE8V' => 'Asiatic Russia',
          '8T' => 'India',
          'RN9T' => 'Asiatic Russia',
          'ZX0S' => 'St. Peter & St. Paul',
          'GB1EPC' => 'Scotland',
          'B6' => 'China',
          'N6MW' => 'United States',
          'AH2AK' => 'United States',
          'CS9' => 'Madeira Is.',
          'RG9I' => 'Asiatic Russia',
          'UC8T' => 'Asiatic Russia',
          'K7TD' => 'United States',
          '7E' => 'Indonesia',
          'RI9M' => 'Asiatic Russia',
          'RV9W' => 'Asiatic Russia',
          'VE2VH' => 'Canada',
          'A9;' => 'Bahrain',
          'W4JSI' => 'United States',
          'HD8;' => 'Galapagos Is.',
          'PP0ZT' => 'Trindade & Martim Vaz',
          'PS0ZF' => 'Fernando de Noronha',
          '7L' => 'Japan',
          'RU7' => 'Asiatic Russia',
          'W8AEF' => 'United States',
          '4K;' => 'Azerbaijan',
          '4Q' => 'Sri Lanka',
          'VE2ZC' => 'Canada',
          'IW0U' => 'Sardinia',
          'II9' => 'Sicily',
          'RV2' => 'Kaliningrad',
          'LU3DOC/D' => 'Argentina',
          'IJ9' => 'Sicily',
          'B9N' => 'China',
          'AA' => 'United States',
          'GB5SI' => 'Scotland',
          'VN9X' => 'Christmas I.',
          'SX9' => 'Crete',
          'GB2WFF' => 'Wales',
          'L6' => 'Argentina',
          'N2WN' => 'United States',
          'RM7' => 'Asiatic Russia',
          'VK9FM' => 'Mellish Reef',
          'EH6;' => 'Balearic Is.',
          'RK7' => 'Asiatic Russia',
          'K4BP' => 'United States',
          'RV8' => 'Asiatic Russia',
          'WH0' => 'Mariana Is.',
          'H6' => 'Nicaragua',
          'VH9' => 'Norfolk I.',
          'LW3DKC/D' => 'Argentina',
          'BD3H' => 'China',
          'RS7' => 'Asiatic Russia',
          'GB0AC' => 'Scotland',
          'UE7' => 'Asiatic Russia',
          'OM;' => 'Slovakia',
          '9M0' => 'Spratly Is.',
          'BX9P;' => 'Pratas Island',
          'PJ0' => 'Netherlands Antilles',
          '6C' => 'Syria',
          'LL' => 'Norway',
          'CC0' => 'Easter Island',
          'LW3DKO/E' => 'Argentina',
          'AZ' => 'Argentina',
          'AF' => 'United States',
          'KH6RW' => 'United States',
          'GB50JSA;' => 'Jersey',
          'OM' => 'Slovakia',
          'GB8CI' => 'Scotland',
          'DZ;' => 'Philippines',
          'TW;' => 'France',
          '6W' => 'Senegal',
          'XV;' => 'Vietnam',
          'V7;' => 'Marshall Is.',
          'TX0C' => 'Chesterfield Is.',
          'RA9T' => 'Asiatic Russia',
          'LX;' => 'Luxembourg',
          'TO7T' => 'Guadeloupe',
          'BT3H' => 'China',
          '9T;' => 'Rep. of Congo',
          'GB4MNH' => 'Isle of Man',
          'VE2/K3FMQ' => 'Canada',
          'KP4' => 'Puerto Rico',
          'RT9M' => 'Asiatic Russia',
          'VE2END' => 'Canada',
          'RV9I' => 'Asiatic Russia',
          'KU8E' => 'United States',
          'VE2EDL' => 'Canada',
          'LU1XAW/X' => 'Argentina',
          '7P;' => 'Lesotho',
          'K4FXN' => 'United States',
          'RI8T' => 'Asiatic Russia',
          '2A' => 'Scotland',
          'RQ9W' => 'Asiatic Russia',
          'RI9T' => 'Asiatic Russia',
          'DO' => 'Germany',
          'TO0P' => 'Martinique',
          '3C' => 'Equatorial Guinea',
          'K4SAC' => 'United States',
          'ZM;' => 'New Zealand',
          'VA2CT' => 'Canada',
          'CV' => 'Uruguay',
          'GD' => 'Isle of Man',
          'JD/o' => 'Ogasawara',
          'WB4ZBI' => 'United States',
          'RQ9I' => 'Asiatic Russia',
          'V4' => 'St. Kitts & Nevis',
          'RD7' => 'Asiatic Russia',
          'BL9S' => 'China',
          'GB2LNP' => 'Wales',
          'LU8ERH/D' => 'Argentina',
          '9C' => 'Iran',
          'R9I' => 'Asiatic Russia',
          'BN9P' => 'Pratas Island',
          'VL9M' => 'Mellish Reef',
          'VK9' => 'Norfolk I.',
          'WA2MNO' => 'United States',
          'D3;' => 'Angola',
          'YW0' => 'Aves I.',
          'NU4BP' => 'United States',
          'VU7;' => 'Laccadive Is.',
          'TS;' => 'Tunisia',
          'PW0ZR' => 'Fernando de Noronha',
          'ZX0ZT' => 'Trindade & Martim Vaz',
          'LZ' => 'Bulgaria',
          'LU6EPR/D' => 'Argentina',
          'N4GK' => 'United States',
          'K1LKR' => 'United States',
          '3K' => 'China',
          '6L' => 'South Korea',
          'U9' => 'Asiatic Russia',
          'GB4CI' => 'Wales',
          'WH7;' => 'Hawaii',
          '8C' => 'Indonesia',
          'VV' => 'India',
          'BG9S' => 'China',
          'HY' => 'France',
          '5W' => 'Samoa',
          'IQ0AL' => 'Sardinia',
          'RJ9S' => 'Asiatic Russia',
          'SC' => 'Sweden',
          'JL' => 'Japan',
          'GB2HI' => 'Scotland',
          'GB1FVT' => 'Scotland',
          'GB0BVC' => 'Northern Ireland',
          'W4TDB' => 'United States',
          'U5' => 'Ukraine',
          'UJ' => 'Uzbekistan',
          'FR/t' => 'Tromelin',
          '9N;' => 'Nepal',
          'RJ0' => 'Asiatic Russia',
          'N4VV' => 'United States',
          'ZP' => 'Paraguay',
          'BY9P' => 'China',
          'W8TN' => 'United States',
          'KA2EYH' => 'United States',
          'BA3L' => 'China',
          'BL3J' => 'China',
          'RG7' => 'Asiatic Russia',
          '3D2CI' => 'Conway Reef',
          'RL0' => 'Asiatic Russia',
          'GM0ILB' => 'Shetland',
          'GB2RB' => 'Scotland',
          '5P' => 'Denmark',
          'LW7DAF/D' => 'Argentina',
          'RI2' => 'Kaliningrad',
          'OZ;' => 'Denmark',
          'VE2GSO' => 'Canada',
          'V3;' => 'Belize',
          'SV2ASP/A;' => 'Mount Athos',
          'CQ3' => 'Madeira Is.',
          'C6;' => 'Bahamas',
          'VK9Y' => 'Cocos-Keeling',
          'A6;' => 'United Arab Emirates',
          'VE2AQS' => 'Canada',
          'RN8' => 'Asiatic Russia',
          'VK0H' => 'Heard I.',
          'VE2DWU' => 'Canada',
          'GB4LNM' => 'Scotland',
          'N2LA' => 'United States',
          'VI9W' => 'Willis I.',
          'GB60VLY' => 'Wales',
          'ZW0S' => 'St. Peter & St. Paul',
          'ED8' => 'Canary Is.',
          'BY3K' => 'China',
          'VER20080318' => 'Canada',
          'OW' => 'Faroe Is.',
          'LU9ESD/V' => 'Argentina',
          'XZ;' => 'Myanmar',
          'HF' => 'Poland',
          'RH0' => 'Asiatic Russia',
          'C3' => 'Andorra',
          'VK0HI' => 'Heard I.',
          'RB9' => 'Asiatic Russia',
          'RN2' => 'Kaliningrad',
          'K4XG' => 'United States',
          'PS0T' => 'Trindade & Martim Vaz',
          'CD' => 'Chile',
          'BW' => 'Taiwan',
          'ZW' => 'Brazil',
          'ED9' => 'Ceuta and Melilla',
          'NH7C' => 'United States',
          'TO5MM' => 'Martinique',
          'TJ' => 'Cameroon',
          '3V' => 'Tunisia',
          'BW9P' => 'Pratas Island',
          'VN9' => 'Norfolk I.',
          'N7IV' => 'United States',
          'OI0;' => 'Aland Is.',
          'WA1UJU' => 'United States',
          'GB100LP' => 'Wales',
          'GB0BNC' => 'Scotland',
          'UN' => 'Kazakhstan',
          'EH9;' => 'Ceuta and Melilla',
          'GB4PMS' => 'Scotland',
          'HB' => 'Switzerland',
          'BP' => 'Taiwan',
          'XK2' => 'Canada',
          'RD9M' => 'Asiatic Russia',
          'T33;' => 'Banaba',
          'KL' => 'Alaska',
          'LQ' => 'Argentina',
          'LU8XW/X' => 'Argentina',
          'ZW0F' => 'Fernando de Noronha',
          'K4IU' => 'United States',
          'E3' => 'Eritrea',
          'YS;' => 'El Salvador',
          'VK9KC' => 'Cocos-Keeling',
          'GB2IAS' => 'Scotland',
          'CM' => 'Cuba',
          'YY0;' => 'Aves I.',
          '7Y;' => 'Algeria',
          'RH9W' => 'Asiatic Russia',
          'MM3VQO' => 'Shetland',
          'VZ0' => 'Antarctica',
          'XP;' => 'Greenland',
          'T5' => 'Somalia',
          'PX0ZS' => 'St. Peter & St. Paul',
          'IW0Z' => 'Sardinia',
          'GM4SWU' => 'Shetland',
          'SQ' => 'Poland',
          'GB0REL' => 'Northern Ireland',
          'TF' => 'Iceland',
          'AL7W' => 'United States',
          'HK0TU;' => 'Malpelo I.',
          'TQ' => 'France',
          'EG6' => 'Balearic Is.',
          'KC4USV' => 'Antarctica',
          'RZ8T' => 'Asiatic Russia',
          'WA4GLH' => 'United States',
          'UC0' => 'Asiatic Russia',
          'SJ' => 'Sweden',
          'VE2DYX' => 'Canada',
          'ZW0ZS' => 'St. Peter & St. Paul',
          'FT2Z' => 'Amsterdam & St. Paul',
          'K4WI' => 'United States',
          'FO/DL1AWI' => 'Austral Is.',
          'NH2' => 'Guam',
          'E4' => 'Palestine',
          '3B6' => 'Agalega & St. Brandon',
          'UD8T' => 'Asiatic Russia',
          'UB9M' => 'Asiatic Russia',
          'RA8' => 'Asiatic Russia',
          'W3CP' => 'United States',
          'RH7' => 'Asiatic Russia',
          '4N' => 'Serbia',
          'YX' => 'Venezuela',
          'RA9W' => 'Asiatic Russia',
          'VN' => 'Australia',
          'YE' => 'Indonesia',
          'RX8T' => 'Asiatic Russia',
          'RQ9' => 'Asiatic Russia',
          'GB2LCL' => 'Scotland',
          'R1AN' => 'Antarctica',
          'UE8V' => 'Asiatic Russia',
          'OR' => 'Belgium',
          'LU1EQ/D' => 'Argentina',
          'RB2' => 'Kaliningrad',
          'LU3DR/D' => 'Argentina',
          'D4;' => 'Cape Verde',
          '6Q' => 'Pakistan',
          '8Y' => 'India',
          'RX9' => 'Asiatic Russia',
          'IF9' => 'Sicily',
          'LU1AF/D' => 'Argentina',
          'N4TZ' => 'United States',
          'K1GU' => 'United States',
          'DV' => 'Philippines',
          'LU8DWR/D' => 'Argentina',
          'GB4GM' => 'Scotland',
          'EC6' => 'Balearic Is.',
          'ZL9' => 'Auckland & Campbell',
          'GB125SR' => 'Isle of Man',
          'K3FMQ/VE2' => 'Canada',
          'FK' => 'New Caledonia',
          'KH6GJV' => 'United States',
          'DE' => 'Germany',
          'UD0' => 'Asiatic Russia',
          'K9JF' => 'United States',
          'UG9I' => 'Asiatic Russia',
          'LU8DCH/D' => 'Argentina',
          'GB4DAS' => 'Scotland',
          'RT7' => 'Asiatic Russia',
          'GB2SKG' => 'Scotland',
          'RM2' => 'Kaliningrad',
          'KI6DY' => 'United States',
          'KH5' => 'Palmyra & Jarvis Is.',
          'WH5K;' => 'Kingman Reef',
          'PS' => 'Brazil',
          'LU6EJJ/D' => 'Argentina',
          'GB0MOL' => 'Scotland',
          '8J1RL' => 'Antarctica',
          'BL9N' => 'China',
          'P2' => 'Papua New Guinea',
          'K' => 'United States',
          'UD9I' => 'Asiatic Russia',
          'KV4FZ;' => 'Virgin Is.',
          'NJ4I' => 'United States',
          'RU9M' => 'Asiatic Russia',
          'RJ8T' => 'Asiatic Russia',
          '5O;' => 'Nigeria',
          'GM/s' => 'Shetland',
          'GB0WOA' => 'Northern Ireland',
          'RO9M' => 'Asiatic Russia',
          '3G0Z' => 'Juan Fernandez Is.',
          'XW;' => 'Laos',
          'OD' => 'Lebanon',
          'UI7' => 'Asiatic Russia',
          'SW' => 'Greece',
          'PU0ZT' => 'Trindade & Martim Vaz',
          'AX9L' => 'Lord Howe I.',
          'KP1' => 'Navassa I.',
          'GB0LCS' => 'Scotland',
          '2S' => 'Scotland',
          'GB2MAD' => 'Isle of Man',
          'EY;' => 'Tajikistan',
          'RN8T' => 'Asiatic Russia',
          'RR8' => 'Asiatic Russia',
          'GM3KLA' => 'Shetland',
          'EM' => 'Ukraine',
          'KN4Q' => 'United States',
          'J8' => 'St. Vincent',
          '5J' => 'Colombia',
          'D6' => 'Comoros',
          'RW9W' => 'Asiatic Russia',
          'RP9' => 'Asiatic Russia',
          'N3ZZ' => 'United States',
          'KC4/K2ARB' => 'Antarctica',
          'KH5K' => 'Kingman Reef',
          'RG0' => 'Asiatic Russia',
          'MD' => 'Isle of Man',
          'VK0' => 'Antarctica',
          'HS;' => 'Thailand',
          'LU1DZ/E' => 'Argentina',
          'AH7' => 'Hawaii',
          'GB0OYT' => 'Scotland',
          'AH0' => 'Mariana Is.',
          'JO' => 'Japan',
          '4G' => 'Philippines',
          'ET' => 'Ethiopia',
          '7W' => 'Algeria',
          'IS' => 'Sardinia',
          'GB2000SET' => 'Wales',
          'DL' => 'Germany',
          'RW8V' => 'Asiatic Russia',
          'RS9T' => 'Asiatic Russia',
          'LW7DAF/W' => 'Argentina',
          'VE2UA' => 'Canada',
          'RQ9T' => 'Asiatic Russia',
          'LU8FOZ/V' => 'Argentina',
          '9J;' => 'Zambia',
          'N9ADG' => 'United States',
          'MH' => 'Jersey',
          'RB9S' => 'Asiatic Russia',
          'P3;' => 'Cyprus',
          'RO9S' => 'Asiatic Russia',
          '4U0ITU' => 'ITU HQ Geneva',
          'YS' => 'El Salvador',
          'GB0GCR' => 'Wales',
          'NU4B' => 'United States',
          'HH;' => 'Haiti',
          'PJ7' => 'Sint Maarten',
          'VE2TVU' => 'Canada',
          'RO8T' => 'Asiatic Russia',
          'MS0ZCG;' => 'Shetland',
          'VP2E;' => 'Anguilla',
          'W4GKM' => 'United States',
          'SV5' => 'Dodecanese',
          'BD9Q' => 'China',
          '2U' => 'Guernsey',
          'PK' => 'Indonesia',
          'YJ' => 'Vanuatu',
          '6E' => 'Mexico',
          'OG0' => 'Aland Is.',
          'GB2NAG' => 'Scotland',
          'RL7' => 'Asiatic Russia',
          'BV9P' => 'Pratas Island',
          'E4;' => 'Palestine',
          'J4' => 'Greece',
          'HP' => 'Panama',
          'BD' => 'China',
          'HL;' => 'South Korea',
          'RP8' => 'Asiatic Russia',
          'GB4SMM' => 'Wales',
          'U8V' => 'Asiatic Russia',
          'PX0F' => 'Fernando de Noronha',
          'ZD9' => 'Tristan da Cunha',
          'CQ' => 'Portugal',
          'UA8V' => 'Asiatic Russia',
          'PR' => 'Brazil',
          'BG9O' => 'China',
          'PX0T' => 'Trindade & Martim Vaz',
          'GB0SPD' => 'Northern Ireland',
          'RH9M' => 'Asiatic Russia',
          'ZX0F' => 'Fernando de Noronha',
          'OQ' => 'Belgium',
          'GB0PPE' => 'Scotland',
          'VP8ROT' => 'Antarctica',
          'LU8EOT/X' => 'Argentina',
          'BT3J' => 'China',
          'LU5EAO/D' => 'Argentina',
          'GB2NEF' => 'Scotland',
          'LU7DZL/E' => 'Argentina',
          'GM8YEC' => 'Shetland',
          'AN8' => 'Canary Is.',
          'UG8' => 'Asiatic Russia',
          '6G4' => 'Revilla Gigedo',
          'RY9S' => 'Asiatic Russia',
          '9M6/N1UR;' => 'Spratly Is.',
          '7I' => 'Indonesia',
          'A2;' => 'Botswana',
          'LR' => 'Argentina',
          'YZ;' => 'Serbia',
          'BL9O' => 'China',
          'CI1' => 'Canada',
          'PW0T' => 'Trindade & Martim Vaz',
          'RK8V' => 'Asiatic Russia',
          'XQ0Z' => 'Juan Fernandez Is.',
          'K7GMF' => 'United States',
          'GB0DGL' => 'Scotland',
          'GB0SDD' => 'Wales',
          'GC' => 'Wales',
          'ZL' => 'New Zealand',
          'UI8' => 'Asiatic Russia',
          'W4KW' => 'United States',
          'FO/a' => 'Austral Is.',
          'RR9M' => 'Asiatic Russia',
          'AH8' => 'American Samoa',
          'CE0Y' => 'Easter Island',
          'R9W' => 'Asiatic Russia',
          'E3;' => 'Eritrea',
          'AE' => 'United States',
          'W5REA' => 'United States',
          'KW1W;' => 'Alaska',
          '4J' => 'Azerbaijan',
          '1Z' => 'Myanmar',
          'V8' => 'Brunei',
          'RU9W' => 'Asiatic Russia',
          'RI7' => 'Asiatic Russia',
          'W0UCE' => 'United States',
          'RO7' => 'Asiatic Russia',
          'VB2R' => 'Canada',
          'WH8;' => 'American Samoa',
          '5V;' => 'Togo',
          'UF9W' => 'Asiatic Russia',
          'K8JQ' => 'United States',
          'EF' => 'Spain',
          '9R' => 'Rep. of Congo',
          'BT3G' => 'China',
          'C9;' => 'Mozambique',
          'SE' => 'Sweden',
          'K9AW' => 'United States',
          'C5' => 'Gambia',
          'H2' => 'Cyprus',
          'KD3RF/VE2' => 'Canada',
          'W4DHE' => 'United States',
          'ZS' => 'South Africa',
          '7R' => 'Algeria',
          '7K' => 'Japan',
          'W6LFB' => 'United States',
          'UB8V' => 'Asiatic Russia',
          '7P' => 'Lesotho',
          '9M8' => 'East Malaysia',
          'UH9S' => 'Asiatic Russia',
          'EJ;' => 'Ireland',
          'LV' => 'Argentina',
          'RH8V' => 'Asiatic Russia',
          'JY;' => 'Jordan',
          'EH8;' => 'Canary Is.',
          'PP0R' => 'Fernando de Noronha',
          'RS8T' => 'Asiatic Russia',
          'GB2GOL' => 'Wales',
          '5C' => 'Morocco',
          'LU1YY/Y' => 'Argentina',
          'B5' => 'China',
          '3G' => 'Chile',
          'LH' => 'Norway',
          '4U3UN' => 'United Nations HQ',
          'LW2DX/P' => 'Argentina',
          'DS' => 'South Korea',
          'GB4MD' => 'Wales',
          'UB9T' => 'Asiatic Russia',
          'TV' => 'France',
          'SN' => 'Poland',
          'GB75STT' => 'Scotland',
          'ES;' => 'Estonia',
          'GB4NFE' => 'Scotland',
          'VK9KL' => 'Lord Howe I.',
          '6J' => 'Mexico',
          '8R;' => 'Guyana',
          'CY9;' => 'St. Paul I.',
          'B9S' => 'China',
          'JE' => 'Japan',
          'K0JJR' => 'United States',
          'K4VUD' => 'United States',
          'GB8OO' => 'Scotland',
          'AL1VE' => 'United States',
          'NH9' => 'Wake I.',
          'VN9C' => 'Cocos-Keeling',
          'K4BXC' => 'United States',
          'LW1EXU/Y' => 'Argentina',
          'VE2ZV' => 'Canada',
          'RX9S' => 'Asiatic Russia',
          'JF' => 'Japan',
          '3W' => 'Vietnam',
          'CH2' => 'Canada',
          'BP9P' => 'Pratas Island',
          'GB50ATC' => 'Scotland',
          'K7RE' => 'United States',
          'VO1' => 'Canada',
          'H8' => 'Panama',
          'ZD7;' => 'Saint Helena',
          'RQ9M' => 'Asiatic Russia',
          'UD9W' => 'Asiatic Russia',
          'RM9M' => 'Asiatic Russia',
          'TO9A' => 'Martinique',
          'PX' => 'Brazil',
          'VR' => 'Hong Kong',
          'CG' => 'Canada',
          'R9' => 'Asiatic Russia',
          'LU4ETN/D' => 'Argentina',
          'BI' => 'China',
          'W7LRD' => 'United States',
          'PW0F' => 'Fernando de Noronha',
          '6W;' => 'Senegal',
          'RZ9T' => 'Asiatic Russia',
          'LU2CRM/XA' => 'Argentina',
          'GB5SPD' => 'Northern Ireland',
          'WH9;' => 'Wake I.',
          'HJ0M' => 'Malpelo I.',
          'RY9M' => 'Asiatic Russia',
          'XJ1' => 'Canada',
          'PV0ZR' => 'Fernando de Noronha',
          'OT;' => 'Belgium',
          'WX4TM' => 'United States',
          'VA' => 'Canada',
          'D5' => 'Liberia',
          'BH3G' => 'China',
          'BZ9S' => 'China',
          'TO1A' => 'Martinique',
          'LD' => 'Norway',
          'LU3DJI/W' => 'Argentina',
          'CA0' => 'Easter Island',
          'ZC4' => 'UK Bases on Cyprus',
          'XK1' => 'Canada',
          'LW2ENB/D' => 'Argentina',
          'VP2V' => 'British Virgin Is.',
          'MU' => 'Guernsey',
          'KM4FO' => 'United States',
          'L80AA/D' => 'Argentina',
          'IQ0AG' => 'Sardinia',
          'GB0CVA' => 'Wales',
          'UC7' => 'Asiatic Russia',
          'T8' => 'Palau',
          'XQ0' => 'Easter Island',
          'YM1;' => 'Turkey (Europe)',
          'ZA;' => 'Albania',
          'RZ0' => 'Asiatic Russia',
          '8G' => 'Indonesia',
          'UC9T' => 'Asiatic Russia',
          'GB5BS/J' => 'Wales',
          'PT0ZR' => 'Fernando de Noronha',
          'LU1DZ/Q' => 'Argentina',
          'ZV0ZT' => 'Trindade & Martim Vaz',
          'VH0' => 'Antarctica',
          'LU9EJS/E' => 'Argentina',
          'LU7VCH/D' => 'Argentina',
          'GM4LBE' => 'Shetland',
          'LU1XY/X' => 'Argentina',
          'LU6DBL/D' => 'Argentina',
          'AD4EB' => 'United States',
          'RO9W' => 'Asiatic Russia',
          'CD0Z' => 'Juan Fernandez Is.',
          'V5' => 'Namibia',
          'LU4WG/W' => 'Argentina',
          'LU7WFM/W' => 'Argentina',
          'YA' => 'Afghanistan',
          '9G' => 'Ghana',
          '6M' => 'South Korea',
          'RW9S' => 'Asiatic Russia',
          'AL7QQ' => 'United States',
          'UB8' => 'Asiatic Russia',
          'V2;' => 'Antigua & Barbuda',
          'TJ;' => 'Cameroon',
          '6F' => 'Mexico',
          'IT' => 'Sicily',
          'UF8V' => 'Asiatic Russia',
          'UG8T' => 'Asiatic Russia',
          '3D2AG/P;' => 'Rotuma',
          'VE2IM' => 'Canada',
          'BT9R' => 'China',
          'TO7C' => 'French Guiana',
          'RU9S' => 'Asiatic Russia',
          'PV0ZF' => 'Fernando de Noronha',
          'RO0' => 'Asiatic Russia',
          'ZA' => 'Albania',
          'TO5D;' => 'French St. Martin',
          'DG' => 'Germany',
          'VJ' => 'Australia',
          'R9M' => 'Asiatic Russia',
          'PY0T' => 'Trindade & Martim Vaz',
          'GB4BPL' => 'Wales',
          'CA' => 'Chile',
          'RE0' => 'Asiatic Russia',
          'PQ' => 'Brazil',
          'AY1ZA' => 'South Orkney',
          'NL7AU' => 'United States',
          'W4LIA' => 'United States',
          'T7;' => 'San Marino',
          'VZ9L;' => 'Lord Howe I.',
          'GB1LSG' => 'Wales',
          'BY3G' => 'China',
          'XF' => 'Mexico',
          'UA0' => 'Asiatic Russia',
          'LM' => 'Norway',
          'RX2' => 'Kaliningrad',
          'RX9W' => 'Asiatic Russia',
          'KJ6BZ;' => 'Johnston I.',
          '1S' => 'Spratly Is.',
          'LW5EE/V' => 'Argentina',
          'GB0SOA' => 'Wales',
          'S6;' => 'Singapore',
          'R9T' => 'Asiatic Russia',
          'KG4' => 'Guantanamo Bay',
          'N7FLT' => 'United States',
          'GB1TDS' => 'Wales',
          'CB0Z' => 'Juan Fernandez Is.',
          'TK;' => 'Corsica',
          'N' => 'United States',
          'FT2W' => 'Crozet',
          'BA3G' => 'China',
          'XR0X;' => 'San Felix I.',
          'ZX0ZF' => 'Fernando de Noronha',
          'WH1;' => 'Baker & Howland Is.',
          'KH1' => 'Baker & Howland Is.',
          'GB2ECG' => 'Guernsey',
          'TO2ANT' => 'Guadeloupe',
          '2Y' => 'Wales',
          'UB9W' => 'Asiatic Russia',
          'WH5;' => 'Palmyra & Jarvis Is.',
          '8K' => 'Japan',
          'HX' => 'France',
          'UD9S' => 'Asiatic Russia',
          'LU9JMG/J' => 'Argentina',
          'GB0CLC' => 'Wales',
          'UB9I' => 'Asiatic Russia',
          'R7C/4;' => 'European Russia',
          'A3' => 'Tonga',
          'UI8T' => 'Asiatic Russia',
          'RO9I' => 'Asiatic Russia',
          'L25E/D' => 'Argentina',
          'GB2GTM' => 'Scotland',
          'AY4EJ/D' => 'Argentina',
          'TR;' => 'Gabon',
          'T9;' => 'Bosnia-Herzegovina',
          'PU0F' => 'Fernando de Noronha',
          'LU1DZ/S' => 'Argentina',
          'GB0CCE' => 'Wales',
          'JZ' => 'Indonesia',
          'B9M' => 'China',
          'BO9P' => 'Pratas Island',
          'HD;' => 'Ecuador',
          'ZL0' => 'Antarctica',
          'GB0GKR' => 'Scotland',
          'LU8EBJ/D' => 'Argentina',
          'GB2HST' => 'Scotland',
          'BY3L' => 'China',
          'RH9S' => 'Asiatic Russia',
          'UX' => 'Ukraine',
          'TO5C' => 'Guadeloupe',
          'FO' => 'French Polynesia',
          'MC' => 'Wales',
          'B3G' => 'China',
          'XR;' => 'Chile',
          'AH3' => 'Johnston I.',
          'TX5NK' => 'Mayotte',
          'UA9W' => 'Asiatic Russia',
          'K4EJQ' => 'United States',
          'RS9I' => 'Asiatic Russia',
          'GM0CXQ' => 'Shetland',
          'FT5Z' => 'Amsterdam & St. Paul',
          'HJ' => 'Colombia',
          'HT' => 'Nicaragua',
          'RU0' => 'Asiatic Russia',
          'GB0JAG' => 'Guernsey',
          'BG3J' => 'China',
          'IW0V' => 'Sardinia',
          'U9S' => 'Asiatic Russia',
          'PY0ZR' => 'Fernando de Noronha',
          'PU0S' => 'St. Peter & St. Paul',
          'NH5' => 'Palmyra & Jarvis Is.',
          'UF9I' => 'Asiatic Russia',
          'BD9P' => 'China',
          '6D4' => 'Revilla Gigedo',
          'K2HTO' => 'United States',
          'N4DD' => 'United States',
          'BY9S' => 'China',
          'RR2' => 'Kaliningrad',
          '9L;' => 'Sierra Leone',
          'MZ' => 'Shetland',
          'ES' => 'Estonia',
          'W6NWS' => 'United States',
          'HO' => 'Panama',
          'GB2TD' => 'Wales',
          'LU8XC/X' => 'Argentina',
          'CA0Z' => 'Juan Fernandez Is.',
          'VE3NE/2' => 'Canada',
          'LU2DT/LH' => 'Argentina',
          'S8' => 'South Africa',
          'VK0IR;' => 'Heard I.',
          'KA8Q' => 'United States',
          'XA' => 'Mexico',
          'KP5' => 'Desecheo I.',
          'RY0' => 'Asiatic Russia',
          'TR' => 'Gabon',
          '3R' => 'China',
          'RZ9M' => 'Asiatic Russia',
          'PT0F' => 'Fernando de Noronha',
          '4C' => 'Mexico',
          'RL9S' => 'Asiatic Russia',
          'U2' => 'Kaliningrad',
          'GB2MOD' => 'Scotland',
          'RV8T' => 'Asiatic Russia',
          'J3' => 'Grenada',
          'GB2OYC' => 'Scotland',
          'N2BJL' => 'United States',
          '4C4' => 'Revilla Gigedo',
          'LU9AUC/D' => 'Argentina',
          'GB0FLA' => 'Scotland',
          'WH6' => 'Hawaii',
          'JW' => 'Svalbard',
          'VK9GL' => 'Lord Howe I.',
          'GB2LGB' => 'Scotland',
          'PD' => 'Netherlands',
          'GB2LP' => 'Scotland',
          'GB200HNT' => 'Wales',
          'VE2AS' => 'Canada',
          'OH' => 'Finland',
          'VE2AE' => 'Canada',
          'PJ3' => 'Netherlands Antilles',
          'W' => 'United States',
          'TO5G' => 'Guadeloupe',
          'KH8' => 'American Samoa',
          'RK9S' => 'Asiatic Russia',
          'LU1EYW/D' => 'Argentina',
          '9W2' => 'West Malaysia',
          '4M0' => 'Aves I.',
          'TN;' => 'Congo',
          'GB2IGB' => 'Scotland',
          'ZZ0S' => 'St. Peter & St. Paul',
          'GB2LSS' => 'Scotland',
          'VE3EY/2' => 'Canada',
          'UD2' => 'Kaliningrad',
          'AH7K' => 'Kure I.',
          'GB2LCP' => 'Scotland',
          'J3;' => 'Grenada',
          'BZ9P' => 'China',
          'PV0T' => 'Trindade & Martim Vaz',
          '2N' => 'Northern Ireland',
          'FO/OH1RX;' => 'Marquesas Is.',
          'PF' => 'Netherlands',
          'YO' => 'Romania',
          'NX9T' => 'United States',
          'GB2GSG' => 'Wales',
          'BX;' => 'Taiwan',
          'DN' => 'Germany',
          'RD9I' => 'Asiatic Russia',
          '8P' => 'Barbados',
          'RD4W' => 'European Russia',
          'LU8DWR/V' => 'Argentina',
          'FT8Z;' => 'Amsterdam & St. Paul',
          'VC2C' => 'Canada',
          'GB0CLR' => 'Jersey',
          '4D' => 'Philippines',
          'VP8DJK;' => 'South Shetland',
          'BA9N' => 'China',
          '4U1ITU' => 'ITU HQ Geneva',
          'EZ' => 'Turkmenistan',
          'CU;' => 'Azores',
          'VE2RB' => 'Canada',
          'RD8V' => 'Asiatic Russia',
          'JM' => 'Japan',
          'KH8/s' => 'Swains Island',
          'RJ9M' => 'Asiatic Russia',
          'GB0SKY' => 'Scotland',
          'ZK3' => 'Tokelau',
          'RB9M' => 'Asiatic Russia',
          'AX9' => 'Norfolk I.',
          'RF8T' => 'Asiatic Russia',
          'WP1;' => 'Navassa I.',
          'FH' => 'Mayotte',
          'PU0ZS' => 'St. Peter & St. Paul',
          'LU4DRH/E' => 'Argentina',
          '3P' => 'China',
          'FR;' => 'Reunion',
          'RT9S' => 'Asiatic Russia',
          'RE9T' => 'Asiatic Russia',
          'CB0' => 'Easter Island',
          'ZK3;' => 'Tokelau',
          'VJ9W' => 'Willis I.',
          'LU7DBL/D' => 'Argentina',
          '5K' => 'Colombia',
          'C2;' => 'Nauru',
          'FT2Y' => 'Antarctica',
          'VP2E' => 'Anguilla',
          'VN9L' => 'Lord Howe I.',
          'AM8' => 'Canary Is.',
          'RD8' => 'Asiatic Russia',
          '5X' => 'Uganda',
          'TK' => 'Corsica',
          'PY0R' => 'Fernando de Noronha',
          'EE' => 'Spain',
          'CK' => 'Canada',
          '8D' => 'Indonesia',
          'RM9T' => 'Asiatic Russia',
          'L2' => 'Argentina',
          'EK' => 'Armenia',
          'LW4EM/E' => 'Argentina',
          'GB5BBS' => 'Scotland',
          '5Z;' => 'Kenya',
          'K2VCO' => 'United States',
          'GB0TCH' => 'Northern Ireland',
          'UF0' => 'Asiatic Russia',
          'ON' => 'Belgium',
          '5D' => 'Morocco',
          'RP8T' => 'Asiatic Russia',
          'W8HGH' => 'United States',
          'U8' => 'Asiatic Russia',
          'BL3I' => 'China',
          '6T' => 'Sudan',
          'N4XM' => 'United States',
          '6X;' => 'Madagascar',
          'GB2MUL' => 'Scotland',
          '9I' => 'Zambia',
          'LU3ES/D' => 'Argentina',
          'A4;' => 'Oman',
          'TB' => 'Turkey',
          'T30' => 'Western Kiribati',
          'RC9T' => 'Asiatic Russia',
          'N6ZO' => 'United States',
          'NH7K' => 'Kure I.',
          'UI9I' => 'Asiatic Russia',
          'RG8' => 'Asiatic Russia',
          'LU5DIT/V' => 'Argentina',
          'LU2DT/D' => 'Argentina',
          'GB5AST' => 'Scotland',
          'J5' => 'Guinea-Bissau',
          'RN9' => 'Asiatic Russia',
          'RD2' => 'Kaliningrad',
          'AG3V' => 'United States',
          '5Q' => 'Denmark',
          'VK9KW' => 'Willis I.',
          '5R' => 'Madagascar',
          'TO2DX' => 'Martinique',
          'LU8DRH/D' => 'Argentina',
          'PO' => 'Indonesia',
          'ET;' => 'Ethiopia',
          'UP' => 'Kazakhstan',
          'KO7X' => 'United States',
          'KY4AA' => 'United States',
          'XO2' => 'Canada',
          'UB9' => 'Asiatic Russia',
          'ER;' => 'Moldova',
          'RH8T' => 'Asiatic Russia',
          '7V' => 'Algeria',
          'NY6DX' => 'United States',
          'ZP;' => 'Paraguay',
          'VI0M' => 'Macquarie I.',
          'CZ2' => 'Canada',
          'BY9Q' => 'China',
          'VE2WDX' => 'Canada',
          'RJ9T' => 'Asiatic Russia',
          'TO7IR' => 'French Guiana',
          'W4NZ' => 'United States',
          'RR9T' => 'Asiatic Russia',
          'FT4W' => 'Crozet',
          'PP0ZS' => 'St. Peter & St. Paul',
          'UB0' => 'Asiatic Russia',
          'TO4T' => 'Guadeloupe',
          'VE2DYW' => 'Canada',
          'GB2GSS' => 'Wales',
          'PA' => 'Netherlands',
          'VM9' => 'Norfolk I.',
          'RC8V' => 'Asiatic Russia',
          'UA8' => 'Asiatic Russia',
          'JC' => 'Japan',
          'UG9W' => 'Asiatic Russia',
          'M;' => 'England',
          'ZZ0F' => 'Fernando de Noronha',
          'VN9Y' => 'Cocos-Keeling',
          'KM6JD' => 'United States',
          'BL' => 'China',
          'PQ0R' => 'Fernando de Noronha',
          'EF8' => 'Canary Is.',
          'AU' => 'India',
          'RV9S' => 'Asiatic Russia',
          'K6EID' => 'United States',
          '9U' => 'Burundi',
          'RR9I' => 'Asiatic Russia',
          'TO7ACR' => 'Guadeloupe',
          'UE8' => 'Asiatic Russia',
          'K1GUG' => 'United States',
          'ZV0R' => 'Fernando de Noronha',
          'VH9X' => 'Christmas I.',
          'UG9M' => 'Asiatic Russia',
          '7O' => 'Yemen',
          'N6KB' => 'Hawaii',
          'GB0WCY' => 'Isle of Man',
          'GB0ON' => 'Guernsey',
          'AG' => 'United States',
          'VH9C' => 'Cocos-Keeling',
          'GZ' => 'Shetland',
          'FR5ZU/T;' => 'Tromelin',
          'GM4ZHL' => 'Shetland',
          'GB50LIB;' => 'Guernsey',
          'XI;' => 'Mexico',
          'AI' => 'United States',
          'GB2WBB' => 'Scotland',
          'XO0' => 'Canada',
          'RV9' => 'Asiatic Russia',
          'AN' => 'Spain',
          'V4;' => 'St. Kitts & Nevis',
          'NH7' => 'Hawaii',
          'UA9M' => 'Asiatic Russia',
          'K0LUZ' => 'United States',
          'LU5DV/D' => 'Argentina',
          'IG9' => 'Italy (Africa)',
          'PR0F' => 'Fernando de Noronha',
          'BD9R' => 'China',
          'TO7X' => 'Martinique',
          'GB0SPS' => 'Wales',
          'H5' => 'South Africa',
          'PJ1' => 'Netherlands Antilles',
          'RF9T' => 'Asiatic Russia',
          'K1TN' => 'United States',
          'BQ9P' => 'Pratas Island',
          'GB2IOM' => 'Isle of Man',
          'LW4EM/LH' => 'Argentina',
          'LW9EVA/D' => 'Argentina',
          'LU9EV/LH' => 'Argentina',
          'KP3' => 'Puerto Rico',
          'K4IE' => 'United States',
          'CP;' => 'Bolivia',
          'EB6' => 'Balearic Is.',
          'CN' => 'Morocco',
          'LU2XX/X' => 'Argentina',
          'H40;' => 'Temotu',
          'WP5;' => 'Desecheo I.',
          'IU9' => 'Sicily',
          'KD3TB/VE2' => 'Canada',
          'RY7' => 'Asiatic Russia',
          'UH8T' => 'Asiatic Russia',
          'VE2ENR' => 'Canada',
          'W1DYH' => 'United States',
          'GB2TTA' => 'Wales',
          'LU4DRC/Y' => 'Argentina',
          'FJ' => 'Saint Barthelemy',
          'MM1FJM' => 'Shetland',
          'BD3G' => 'China',
          'FS' => 'French St. Martin',
          'LW5DR/LH' => 'Argentina',
          'EL;' => 'Liberia',
          'AL7NS' => 'United States',
          'VU7' => 'Laccadive Is.',
          '5K0' => 'San Andres/Providencia',
          'GB2IGS' => 'Scotland',
          '4U3ITU' => 'ITU HQ Geneva',
          'TP' => 'France',
          'VE2EAK' => 'Canada',
          'BH9Q' => 'China',
          'RF0' => 'Asiatic Russia',
          'GB4XXX' => 'Wales',
          'DT' => 'South Korea',
          'LU2DVI/H' => 'Argentina',
          'OA' => 'Peru',
          'KH6QAJ' => 'United States',
          'HC' => 'Ecuador',
          'GB0QWM' => 'Scotland',
          'FJL' => 'Franz Josef Land',
          'B9' => 'China',
          'RG9S' => 'Asiatic Russia',
          '8L' => 'Japan',
          'GB2TCA' => 'Northern Ireland',
          'L3' => 'Argentina',
          'SY' => 'Greece',
          'K2AAW' => 'United States',
          'AX0' => 'Antarctica',
          'RK8T' => 'Asiatic Russia',
          'LU2EE/D' => 'Argentina',
          'RT8V' => 'Asiatic Russia',
          'BZ3K' => 'China',
          'XE4' => 'Revilla Gigedo',
          'N0AX' => 'United States',
          'GB2LL' => 'Northern Ireland',
          'VK9M' => 'Mellish Reef',
          'W4EEH' => 'United States',
          'VC' => 'Canada',
          'R7C' => 'European Russia',
          'W4DAN' => 'United States',
          'RV4W' => 'European Russia',
          'JP' => 'Japan',
          'LU7EPC/D' => 'Argentina',
          'TX1A' => 'New Caledonia',
          'OJ0' => 'Market Reef',
          'EY' => 'Tajikistan',
          'MN' => 'Northern Ireland',
          'KE4OAR' => 'United States',
          'J5;' => 'Guinea-Bissau',
          'LW2DX/E' => 'Argentina',
          '4U4ITU' => 'ITU HQ Geneva',
          'GB5FI' => 'Wales',
          'RX9M' => 'Asiatic Russia',
          '4F' => 'Philippines',
          'VF2' => 'Canada',
          'EL' => 'Liberia',
          'GB0GUC' => 'Guernsey',
          'XE' => 'Mexico',
          'VU3VPX' => 'Andaman & Nicobar',
          'RR9' => 'Asiatic Russia',
          'OX' => 'Greenland',
          'VQ9' => 'Chagos Is.',
          'AH1' => 'Baker & Howland Is.',
          'KE7NO' => 'United States',
          'VE2DS' => 'Canada',
          'AH0AH' => 'United States',
          'BG9M' => 'China',
          'HS' => 'Thailand',
          'RL9M' => 'Asiatic Russia',
          'PJ4' => 'Netherlands Antilles',
          'ZY0S' => 'St. Peter & St. Paul',
          'W8WEJ' => 'United States',
          'VE2CVI' => 'Canada',
          'BM9P' => 'Pratas Island',
          'XI4;' => 'Revilla Gigedo',
          'VJ9M' => 'Mellish Reef',
          'S7' => 'Seychelles',
          'VR;' => 'Hong Kong',
          'KH9' => 'Wake I.',
          'PH' => 'Netherlands',
          'GB5BIG' => 'Northern Ireland',
          'VI9' => 'Norfolk I.',
          'IQ0AK' => 'Sardinia',
          'T5;' => 'Somalia',
          'DM' => 'Germany',
          'AL7LV' => 'United States',
          'GB2LO' => 'Scotland',
          'UE2' => 'Kaliningrad',
          'GS' => 'Scotland',
          'VM9Y' => 'Cocos-Keeling',
          'V5;' => 'Namibia',
          'GM4WXQ' => 'Shetland',
          'RX9I' => 'Asiatic Russia',
          'SW5' => 'Dodecanese',
          'ZZ0ZT;' => 'Trindade & Martim Vaz',
          'TO2OOO' => 'Guadeloupe',
          'ZW0ZT' => 'Trindade & Martim Vaz',
          '5J0M' => 'Malpelo I.',
          'XA4' => 'Revilla Gigedo',
          'OE' => 'Austria',
          'K1NG' => 'United States',
          'LU6JJ/D' => 'Argentina',
          'PR0T' => 'Trindade & Martim Vaz',
          'RU8V' => 'Asiatic Russia',
          'VE8RCS' => 'Canada',
          'WH2' => 'Guam',
          'K5KG' => 'United States',
          'RL9' => 'Asiatic Russia',
          '3B8;' => 'Mauritius',
          'MI' => 'Northern Ireland',
          '2T' => 'Isle of Man',
          '9U;' => 'Burundi',
          'VM0M' => 'Macquarie I.',
          'SB' => 'Sweden',
          'TX5CW;' => 'New Caledonia',
          '4U6ITU' => 'ITU HQ Geneva',
          'FT0Z' => 'Amsterdam & St. Paul',
          'GB2ELH' => 'Shetland',
          'PV0F' => 'Fernando de Noronha',
          'GB2HSW' => 'Scotland',
          'LU4ZS' => 'Antarctica',
          'BH3K' => 'China',
          'K6XT' => 'United States',
          'BH9M' => 'China',
          'GB4IOM' => 'Isle of Man',
          'KY1V' => 'United States',
          'GB0PSG' => 'Wales',
          'RE9' => 'Asiatic Russia',
          'ZD9;' => 'Tristan da Cunha',
          'C2' => 'Nauru',
          'AH5K' => 'Kingman Reef',
          'IM0' => 'Sardinia',
          '9Y' => 'Trinidad & Tobago',
          'K1LT' => 'United States',
          'LU9EI/F' => 'Argentina',
          '4P' => 'Sri Lanka',
          '3B8' => 'Mauritius',
          'FT8Y' => 'Antarctica',
          'E2' => 'Thailand',
          '7D' => 'Indonesia',
          'NH0' => 'Mariana Is.',
          'AX9W' => 'Willis I.',
          '8S' => 'Sweden',
          'RV9T' => 'Asiatic Russia',
          '4U0UN' => 'United Nations HQ',
          'UC9S' => 'Asiatic Russia',
          'IW0Y' => 'Sardinia',
          '4U1WB' => 'United States',
          'TI9;' => 'Cocos I.',
          'GB8OQE;' => 'Wales',
          'W1SRD' => 'United States',
          'CC0Z' => 'Juan Fernandez Is.',
          'GN' => 'Northern Ireland',
          'VK9AL' => 'Lord Howe I.',
          'AP' => 'Pakistan',
          'BA3K' => 'China',
          'RA9' => 'Asiatic Russia',
          'RH8' => 'Asiatic Russia',
          'KN6RO' => 'United States',
          'ID9' => 'Sicily',
          'AQ' => 'Pakistan',
          '3D2/r' => 'Rotuma',
          'P4;' => 'Aruba',
          '3Z' => 'Poland',
          '5U;' => 'Niger',
          'RM8V' => 'Asiatic Russia',
          'PT0R' => 'Fernando de Noronha',
          'RZ7' => 'Asiatic Russia',
          'LU9DKX/X' => 'Argentina',
          'VZ;' => 'Australia',
          'W4NI' => 'United States',
          'GB5BL' => 'Northern Ireland',
          'UU' => 'Ukraine',
          'HI' => 'Dominican Republic',
          'TI' => 'Costa Rica',
          'OS' => 'Belgium',
          'GB0GHD' => 'Scotland',
          'LU6EPR/E' => 'Argentina',
          'JW/b' => 'Bear I.',
          '8J1RF' => 'Antarctica',
          'YD' => 'Indonesia',
          'GB6SA' => 'Scotland',
          'KY4Z' => 'United States',
          'K1TU' => 'United States',
          'UA9I' => 'Asiatic Russia',
          'SZ9' => 'Crete',
          'DY' => 'Philippines',
          'T8;' => 'Palau',
          'SP' => 'Poland',
          'VK9FL' => 'Lord Howe I.',
          'PS0ZT' => 'Trindade & Martim Vaz',
          'W6FC' => 'United States',
          'CY2' => 'Canada',
          'BD9N' => 'China',
          'ZF' => 'Cayman Is.',
          'PU0R' => 'Fernando de Noronha',
          '9L' => 'Sierra Leone',
          'UD9' => 'Asiatic Russia',
          'VA2ZM' => 'Canada',
          'MW' => 'Wales',
          'TO6T' => 'Guadeloupe',
          'VE2FCV' => 'Canada',
          'ZR8' => 'Marion I.',
          'FT0X' => 'Kerguelen',
          'PZ' => 'Suriname',
          'KH6' => 'Hawaii',
          'EA6' => 'Balearic Is.',
          'FO/DL9AWI;' => 'Austral Is.',
          'RB8T' => 'Asiatic Russia',
          'GB2LBN' => 'Scotland',
          'VK9KM' => 'Mellish Reef',
          'RU9T' => 'Asiatic Russia',
          'RW7' => 'Asiatic Russia',
          'GB5RO' => 'Scotland',
          'ANT' => 'Antarctica',
          'VE2GSA' => 'Canada',
          'B9R' => 'China',
          'KK9A' => 'United States',
          'N4IR' => 'United States',
          'RO8V' => 'Asiatic Russia',
          'UF9S' => 'Asiatic Russia',
          'ZW0T' => 'Trindade & Martim Vaz',
          'KN5H' => 'United States',
          'LU7DR/D' => 'Argentina',
          'HK;' => 'Colombia',
          'LU3ES/W' => 'Argentina',
          'Z3' => 'Macedonia',
          'JG' => 'Japan',
          'XX;' => 'Madeira Is.',
          'VY2' => 'Canada',
          'SV' => 'Greece',
          '3D2' => 'Fiji',
          'UE9I' => 'Asiatic Russia',
          'GB100FI' => 'Wales',
          'VU3VPY;' => 'Andaman & Nicobar',
          'VK9X' => 'Christmas I.',
          'BG3I' => 'China',
          'FR/g' => 'Glorioso',
          'S3;' => 'Bangladesh',
          'RB9I' => 'Asiatic Russia',
          'WA0KDS' => 'United States',
          'RM8' => 'Asiatic Russia',
          'BS7;' => 'Scarborough Reef',
          'AM' => 'Spain',
          'LW1EXU/D' => 'Argentina',
          'GB2IL' => 'Northern Ireland',
          'V9' => 'South Africa',
          'AB4GG' => 'United States',
          '9M4' => 'West Malaysia',
          'SV/a' => 'Mount Athos',
          'CF' => 'Canada',
          'D7' => 'South Korea',
          'H40' => 'Temotu',
          'LU6DRN/D' => 'Argentina',
          'LE' => 'Norway',
          'GB5MOB' => 'Isle of Man',
          'GB2NTU' => 'Northern Ireland',
          'RQ2' => 'Kaliningrad',
          'P8' => 'North Korea',
          'LU6UAL/D' => 'Argentina',
          'BD9M' => 'China',
          'EA' => 'Spain',
          'HL8KSJ' => 'South Shetland',
          '4U1WRC' => 'ITU HQ Geneva',
          'NH3' => 'Johnston I.',
          'VJ9L' => 'Lord Howe I.',
          'BY9M' => 'China',
          '9D' => 'Iran',
          '5X;' => 'Uganda',
          'SR;' => 'Poland',
          'XR0Z;' => 'Juan Fernandez Is.',
          'W6YJ' => 'United States',
          'EE8' => 'Canary Is.',
          'UH9I' => 'Asiatic Russia',
          'RC9' => 'Asiatic Russia',
          'NP2' => 'Virgin Is.',
          '7O;' => 'Yemen',
          'S0;' => 'Western Sahara',
          'PR0ZF' => 'Fernando de Noronha',
          'LU5DIT/D' => 'Argentina',
          'RJ9' => 'Asiatic Russia',
          'N8RA' => 'United States',
          '9W6' => 'East Malaysia',
          'H7' => 'Nicaragua',
          '8H' => 'Indonesia',
          'VK9FC' => 'Cocos-Keeling',
          'RA0' => 'Asiatic Russia',
          'LU8EBK/D' => 'Argentina',
          'ND2T' => 'United States',
          'LU8EHQ/E' => 'Argentina',
          'EURO' => 'Cyprus',
          'GB2WB' => 'Isle of Man',
          'W0YK' => 'United States',
          'DP0GVN' => 'Antarctica',
          'PT0ZS' => 'St. Peter & St. Paul',
          'D4' => 'Cape Verde',
          'VI' => 'Australia',
          'T7' => 'San Marino',
          'KL0ET' => 'United States',
          'BZ9M' => 'China',
          'LW8DMK/D' => 'Argentina',
          '5U' => 'Niger',
          'XQ0X' => 'San Felix I.',
          'BQ' => 'Taiwan',
          'GM8MMA' => 'Shetland',
          'LU8EOT/Y' => 'Argentina',
          'FK/c' => 'Chesterfield Is.',
          'K8AC' => 'United States',
          'SY5' => 'Dodecanese',
          'CE0Z' => 'Juan Fernandez Is.',
          'VH9M' => 'Mellish Reef',
          'GB2NL' => 'Scotland',
          'GB0MPA' => 'Wales',
          'WB6BWZ' => 'United States',
          'FW' => 'Wallis & Futuna Is.',
          '2C' => 'Wales',
          'GB2MAS' => 'Scotland',
          'UZ;' => 'Ukraine',
          'PS0S' => 'St. Peter & St. Paul',
          'W7LPF' => 'United States',
          'CI0' => 'Canada',
          'AB' => 'United States',
          'ZU;' => 'South Africa',
          'CI2' => 'Canada',
          'LU8DSJ/D' => 'Argentina',
          '9Z;' => 'Trinidad & Tobago',
          'UT' => 'Ukraine',
          'RG8T' => 'Asiatic Russia',
          'R8T' => 'Asiatic Russia',
          'RV8V' => 'Asiatic Russia',
          'TO1USB' => 'Guadeloupe',
          'VZ9;' => 'Norfolk I.',
          'RY8T' => 'Asiatic Russia',
          'BZ3L' => 'China',
          'TY' => 'Benin',
          'VP8' => 'Falkland Is.',
          'GM0DJI' => 'Shetland',
          'UE9M' => 'Asiatic Russia',
          'ZX0T' => 'Trindade & Martim Vaz',
          'GB0JSA' => 'Jersey',
          'RK4W' => 'European Russia',
          'SV0XAZ;' => 'Crete',
          'PY0S' => 'St. Peter & St. Paul',
          'FG' => 'Guadeloupe',
          'VM9C' => 'Cocos-Keeling',
          'GB2AYR' => 'Scotland',
          'VA2BY' => 'Canada',
          'AN9' => 'Ceuta and Melilla',
          'CS3' => 'Madeira Is.',
          'BL3H' => 'China',
          'DT8A' => 'South Shetland',
          '7U' => 'Algeria',
          'PX0S' => 'St. Peter & St. Paul',
          'RQ9S' => 'Asiatic Russia',
          'HB0' => 'Liechtenstein',
          'TO7DSR' => 'Guadeloupe',
          'VM9X' => 'Christmas I.',
          'ZZ;' => 'Brazil',
          'K7GM' => 'United States',
          'N8II' => 'United States',
          'VJ0M' => 'Macquarie I.',
          'RO8' => 'Asiatic Russia',
          'B4' => 'China',
          'VZ0M;' => 'Macquarie I.',
          'EB9' => 'Ceuta and Melilla',
          'RC9M' => 'Asiatic Russia',
          'CR' => 'Portugal',
          'BL9P' => 'China',
          'ZC4;' => 'UK Bases on Cyprus',
          'R1ANF' => 'South Shetland',
          '3C0;' => 'Annobon',
          '4M' => 'Venezuela',
          'SD' => 'Sweden',
          'CE0' => 'Easter Island',
          'NL7CO' => 'United States',
          'RI8' => 'Asiatic Russia',
          'RT9' => 'Asiatic Russia',
          'PY' => 'Brazil',
          '3Y0X;' => 'Peter I I.',
          'GB0RBS' => 'Scotland',
          'W9NGA' => 'United States',
          'JQ' => 'Japan',
          'XU;' => 'Kampuchea',
          'LI' => 'Norway',
          'C4' => 'Cyprus',
          'BA3H' => 'China',
          'B3L' => 'China',
          'GM3ZNM' => 'Shetland',
          'WH3' => 'Johnston I.',
          'PE' => 'Netherlands',
          'I' => 'Italy',
          'GB2LMG' => 'Scotland',
          'RK2' => 'Kaliningrad',
          'PJ8;' => 'Sint Maarten',
          'N6MWA' => 'United States',
          '3B9' => 'Rodriguez I.',
          'ZZ0ZS;' => 'St. Peter & St. Paul',
          'FT2X' => 'Kerguelen',
          '4L;' => 'Georgia',
          'RU8T' => 'Asiatic Russia',
          '6K' => 'South Korea',
          'ER' => 'Moldova',
          'GB2RFS' => 'Wales',
          'L8' => 'Argentina',
          'LU6DRD/D' => 'Argentina',
          '4I' => 'Philippines',
          'ZS8' => 'Marion I.',
          '5K0M' => 'Malpelo I.',
          'LU5XC/X' => 'Argentina',
          'JA' => 'Japan',
          'ZM9;' => 'Auckland & Campbell',
          'ZY0ZT' => 'Trindade & Martim Vaz',
          'VP2M;' => 'Montserrat',
          '3H' => 'China',
          'YY;' => 'Venezuela',
          'VE2DXY' => 'Canada',
          'UE9W' => 'Asiatic Russia',
          '9Q' => 'Rep. of Congo',
          'K4NO' => 'United States',
          'UG7' => 'Asiatic Russia',
          'AG4W' => 'United States',
          'N4JF' => 'United States',
          'XU' => 'Kampuchea',
          'PG' => 'Netherlands',
          'S0' => 'Western Sahara',
          'VJ9C' => 'Cocos-Keeling',
          'AL7C' => 'United States',
          'PI;' => 'Netherlands',
          'RD9W' => 'Asiatic Russia',
          'ZV0T' => 'Trindade & Martim Vaz',
          '5W;' => 'Samoa',
          '2M' => 'Scotland',
          'VH9W' => 'Willis I.',
          'K9HUY' => 'United States',
          '4U8ITU' => 'ITU HQ Geneva',
          'E7' => 'Bosnia-Herzegovina',
          'UC9W' => 'Asiatic Russia',
          '8O' => 'Botswana',
          'XY' => 'Myanmar',
          '6Y' => 'Jamaica',
          '3S' => 'China',
          '6J4' => 'Revilla Gigedo',
          'GM4IPK' => 'Shetland',
          '4T' => 'Peru',
          'RU9I' => 'Asiatic Russia',
          'PY0ZS' => 'St. Peter & St. Paul',
          'W4DVG' => 'United States',
          'T2' => 'Tuvalu',
          'ZX0ZS' => 'St. Peter & St. Paul',
          'LU5DT/D' => 'Argentina',
          '8P;' => 'Barbados',
          'LU8EXJ/D' => 'Argentina',
          'IQ0SS;' => 'Sardinia',
          '3L' => 'China',
          'RH2' => 'Kaliningrad',
          'NH6' => 'Hawaii',
          'LW' => 'Argentina',
          'LS' => 'Argentina',
          'GB2MLM' => 'Wales',
          'UC8V' => 'Asiatic Russia',
          'KC4AAC' => 'Antarctica',
          'PV0S' => 'St. Peter & St. Paul',
          'RT0' => 'Asiatic Russia',
          'W0ZZQ' => 'United States',
          'PL' => 'Indonesia',
          'RB8' => 'Asiatic Russia',
          'PP0ZR' => 'Fernando de Noronha',
          'TX5T' => 'Mayotte',
          'JD1YAA' => 'Minami Torishima',
          'VZ9C' => 'Cocos-Keeling',
          '4B' => 'Mexico',
          'GU' => 'Guernsey',
          'MM' => 'Scotland',
          'GB2AST' => 'Scotland',
          'RA9S' => 'Asiatic Russia',
          'ZX' => 'Brazil',
          'WG7Y' => 'United States',
          'BZ3G' => 'China',
          'UH9T' => 'Asiatic Russia',
          'ZZ0R' => 'Fernando de Noronha',
          'DB' => 'Germany',
          'K2VV' => 'United States',
          'N1SZ' => 'United States',
          '4U4UN' => 'United Nations HQ',
          'KS7T' => 'United States',
          '3A;' => 'Monaco',
          'VG' => 'Canada',
          'K4TD' => 'United States',
          'RK9W' => 'Asiatic Russia',
          'GB0TTT' => 'Wales',
          'VP8/s' => 'South Sandwich',
          'AX9M' => 'Mellish Reef',
          'CR3' => 'Madeira Is.',
          'N6RFM' => 'United States',
          'YW' => 'Venezuela',
          'ZV0ZS' => 'St. Peter & St. Paul',
          'LW4DRH/D' => 'Argentina',
          'N7DC' => 'United States',
          '6R' => 'Pakistan',
          'GB0CI' => 'Northern Ireland',
          'RW8T' => 'Asiatic Russia',
          'RL9T' => 'Asiatic Russia',
          'AB4EJ' => 'United States',
          'T4;' => 'Cuba',
          'UI9' => 'Asiatic Russia',
          'NH5K' => 'Kingman Reef',
          'R3F/9' => 'Asiatic Russia',
          'ED6' => 'Balearic Is.',
          'PN' => 'Indonesia',
          'RN9S' => 'Asiatic Russia',
          'OI' => 'Finland',
          'RB9W' => 'Asiatic Russia',
          'RI8V' => 'Asiatic Russia',
          'LU5DRV/V' => 'Argentina',
          'A4' => 'Oman',
          'GB4MDI' => 'Wales',
          'GM0EKM' => 'Shetland',
          'HN' => 'Iraq',
          'GB2ANG' => 'Wales',
          'BA9O' => 'China',
          'YN' => 'Nicaragua',
          'DA' => 'Germany',
          'VP8/h' => 'South Shetland',
          'RR8T' => 'Asiatic Russia',
          'ZV0ZF' => 'Fernando de Noronha',
          'GB4HMM' => 'Wales',
          'TU' => 'Cote d\'Ivoire',
          'VA2UA' => 'Canada',
          'LJ' => 'Norway',
          '5F' => 'Morocco',
          'UG0' => 'Asiatic Russia',
          'W4PA' => 'United States',
          '4W;' => 'Timor-Leste',
          'LU1CDP/D' => 'Argentina',
          '3C;' => 'Equatorial Guinea',
          'T33' => 'Banaba',
          'N4DW' => 'United States',
          'TC' => 'Turkey',
          'GB6GW' => 'Wales',
          'GB1SPD' => 'Northern Ireland',
          'KG44;' => 'Guantanamo Bay',
          'VL9W' => 'Willis I.',
          '4U9ITU;' => 'ITU HQ Geneva',
          'MM0LSM' => 'Shetland',
          '9H' => 'Malta',
          'YI' => 'Iraq',
          '3E' => 'Panama',
          '3X;' => 'Guinea',
          'GB2SLH' => 'Scotland',
          '5A;' => 'Libya',
          'ZU8;' => 'Marion I.',
          'TT;' => 'Chad',
          'VK9FW' => 'Willis I.',
          'VE2ELL' => 'Canada',
          'FY' => 'French Guiana',
          'N1LN' => 'United States',
          'JX' => 'Jan Mayen',
          'BV9S' => 'Spratly Is.',
          'OL;' => 'Czech Republic',
          '7H' => 'Indonesia',
          'GB2WSF' => 'Wales',
          'DH' => 'Germany',
          'RD9S' => 'Asiatic Russia',
          'UG9T' => 'Asiatic Russia',
          'LU7DP/D' => 'Argentina',
          'GB1SSL' => 'Wales',
          'VP8DIF' => 'South Georgia',
          'UD9T' => 'Asiatic Russia',
          'RX9T' => 'Asiatic Russia',
          'SI' => 'Sweden',
          'L30EY/V' => 'Argentina',
          'KP2N' => 'United States',
          'K8YC' => 'United States',
          '4S;' => 'Sri Lanka',
          'GB6WW' => 'Scotland',
          'VK9FX' => 'Christmas I.',
          'WP2' => 'Virgin Is.',
          'GB1SL' => 'Wales',
          'I;' => 'Italy',
          'VK' => 'Australia',
          'SM' => 'Sweden',
          '9H;' => 'Malta',
          'RK9I' => 'Asiatic Russia',
          'OJ0;' => 'Market Reef',
          'K0TVD' => 'United States',
          'BT9Q' => 'China',
          'GB0U' => 'Guernsey',
          'K5MA' => 'United States',
          'ST;' => 'Sudan',
          'GB8CO' => 'Scotland',
          'VP8DJB' => 'Antarctica',
          'KH2' => 'Guam',
          'AH4' => 'Midway I.',
          '8X' => 'India',
          'IR9' => 'Sicily',
          'GM0ULK' => 'Shetland',
          'LU6UO/X' => 'Argentina',
          'GB2MGY' => 'Northern Ireland',
          'GB2SSF' => 'Scotland',
          'K2RD' => 'United States',
          'EX;' => 'Kyrgyzstan',
          '9V' => 'Singapore',
          'LU5BOJ/O' => 'Argentina',
          'SZ5;' => 'Dodecanese',
          'C9' => 'Mozambique',
          'UA9' => 'Asiatic Russia',
          'BA9Q' => 'China',
          'BG9P' => 'China',
          'LU8EHQ/W' => 'Argentina',
          'FT4X' => 'Kerguelen',
          'YM;' => 'Turkey',
          'JB' => 'Japan',
          'GM0CYJ' => 'Shetland',
          'TO3T' => 'Martinique',
          '2J' => 'Jersey',
          'GB2LNM' => 'Scotland',
          'UH9M' => 'Asiatic Russia',
          '4U7ITU' => 'ITU HQ Geneva',
          'V2' => 'Antigua & Barbuda',
          'RC2' => 'Kaliningrad',
          'LU7DSY/W' => 'Argentina',
          'VL9' => 'Norfolk I.',
          'JT' => 'Mongolia',
          'UI0' => 'Asiatic Russia',
          'CX;' => 'Uruguay',
          'HM' => 'North Korea',
          'N8PR' => 'United States',
          'UF8T' => 'Asiatic Russia',
          'GM8LNH' => 'Shetland',
          'KH3' => 'Johnston I.',
          'GB2DHS' => 'Scotland',
          'UA4W' => 'European Russia',
          'J2' => 'Djibouti',
          'BN' => 'Taiwan',
          'LU5DRV/D' => 'Argentina',
          'LW5EE/D' => 'Argentina',
          'CE0I' => 'Juan Fernandez Is.',
          'W9MAK' => 'United States',
          'PY0ZF' => 'Fernando de Noronha',
          'U9I' => 'Asiatic Russia',
          'RG8V' => 'Asiatic Russia',
          'C8' => 'Mozambique',
          'K9FY' => 'United States',
          'SH' => 'Sweden',
          '3Y/b' => 'Bouvet',
          '9O' => 'Rep. of Congo',
          'CY1' => 'Canada',
          'VU4' => 'Andaman & Nicobar',
          'VL9X' => 'Christmas I.',
          'GB150NRL' => 'Scotland',
          'N4KG' => 'United States',
          'BD9O' => 'China',
          'GB1CCC' => 'Wales',
          'FT4Y' => 'Antarctica',
          'EG8' => 'Canary Is.',
          'ZW0ZF' => 'Fernando de Noronha',
          'PW' => 'Brazil',
          'PT0S' => 'St. Peter & St. Paul',
          'VE2KK' => 'Canada',
          'UE8T' => 'Asiatic Russia',
          'GB2PS' => 'Scotland',
          'IQ9' => 'Sicily',
          'W9IGJ' => 'United States',
          'UA2' => 'Kaliningrad',
          'LU8ADX/D' => 'Argentina',
          'P9;' => 'North Korea',
          'GM4GPP' => 'Shetland',
          'J8;' => 'St. Vincent',
          'PJ9;' => 'Netherlands Antilles',
          'LO' => 'Argentina',
          'RZ8' => 'Asiatic Russia',
          'HK0/a' => 'San Andres/Providencia',
          'BT' => 'China',
          'GB90SOM;' => 'Northern Ireland',
          'LU4EJ/D' => 'Argentina',
          'GB2IMD' => 'Wales',
          'YL' => 'Latvia',
          'RF9S' => 'Asiatic Russia',
          'RL9W' => 'Asiatic Russia',
          'LU1DK/D' => 'Argentina',
          'CC' => 'Chile',
          'RQ7' => 'Asiatic Russia',
          'UD8V' => 'Asiatic Russia',
          'GB0SRH' => 'Wales',
          'YN;' => 'Nicaragua',
          'GB0SHC' => 'Northern Ireland',
          'LY;' => 'Lithuania',
          'ZL1GO/8' => 'Kermadec Is.',
          'GB2RRL' => 'Scotland',
          'GB0DDF' => 'Northern Ireland',
          'U' => 'European Russia',
          'K7UP' => 'United States',
          'GB0GLV' => 'Wales',
          'GB0RSC' => 'Wales',
          'LU/DH4PB/S' => 'Argentina',
          'LW9EAG/V' => 'Argentina',
          'D6;' => 'Comoros',
          'TO4G;' => 'Glorioso',
          'GM' => 'Scotland',
          'LU8ECF/D' => 'Argentina',
          'VK9CL' => 'Lord Howe I.',
          'BH9S' => 'China',
          'UE9S' => 'Asiatic Russia',
          'W8FJ' => 'United States',
          'NW8U' => 'United States',
          'K4WX' => 'United States',
          '4A' => 'Mexico',
          'TX5C;' => 'Clipperton I.',
          '1A;' => 'Sov Mil Order of Malta',
          'GB2STB' => 'Scotland',
          'UI8V' => 'Asiatic Russia',
          'RY8' => 'Asiatic Russia',
          'W6JV' => 'United States',
          'N4NO' => 'United States',
          '3X' => 'Guinea',
          'RH9' => 'Asiatic Russia',
          'R' => 'European Russia',
          'S9;' => 'Sao Tome & Principe',
          'GB4MUU' => 'Wales',
          'RG2' => 'Kaliningrad',
          'YU' => 'Serbia',
          'LU5DEM/D' => 'Argentina',
          'PU0ZR' => 'Fernando de Noronha',
          'VJ9X' => 'Christmas I.',
          'OB' => 'Peru',
          'PY0ZT' => 'Trindade & Martim Vaz',
          'NP5' => 'Desecheo I.',
          'LU7BTO/D' => 'Argentina',
          'IW0X' => 'Sardinia',
          'VN0' => 'Antarctica',
          'RD0' => 'Asiatic Russia',
          'GB5FHC' => 'Scotland',
          'VQ9;' => 'Chagos Is.',
          'EX' => 'Kyrgyzstan',
          'BZ3H' => 'China',
          'WA1FCN' => 'United States',
          'OF' => 'Finland',
          'SU;' => 'Egypt',
          'BA9M' => 'China',
          'GM3WHT' => 'Shetland',
          'TO1YR' => 'Martinique',
          'GB2LT' => 'Scotland',
          'NW7MT' => 'United States',
          'LU6UO/R' => 'Argentina',
          'R2' => 'Kaliningrad',
          'GB4LSG' => 'Wales',
          'P4' => 'Aruba',
          'DU' => 'Philippines',
          'P2;' => 'Papua New Guinea',
          'LU7DSY/D' => 'Argentina',
          'RA8V' => 'Asiatic Russia',
          'ZY0R' => 'Fernando de Noronha',
          'TX9;' => 'Chesterfield Is.',
          'N4GN' => 'United States',
          'ZK2' => 'Niue',
          'XD' => 'Mexico',
          'CA0X' => 'San Felix I.',
          'EO' => 'Ukraine',
          'RG9T' => 'Asiatic Russia',
          'XH' => 'Mexico',
          'RP9M' => 'Asiatic Russia',
          'GB0RPO' => 'Wales',
          'Z2;' => 'Zimbabwe',
          '5E' => 'Morocco',
          'AH2' => 'Guam',
          'BU9P' => 'Pratas Island',
          'MS' => 'Scotland',
          'KC4USB' => 'Antarctica',
          'EC' => 'Spain',
          'KC7UP' => 'United States',
          'GB4CGW' => 'Scotland',
          'KH6OE' => 'United States',
          'VY0PW' => 'Canada',
          'BT9M' => 'China',
          'EV' => 'Belarus',
          'LU7AC/D' => 'Argentina',
          'LU6UO/D' => 'Argentina',
          'J45' => 'Dodecanese',
          'FO;' => 'French Polynesia',
          'W4RYW' => 'United States',
          'PQ0F' => 'Fernando de Noronha',
          '5I;' => 'Tanzania',
          'US' => 'Ukraine',
          '6E4' => 'Revilla Gigedo',
          'G' => 'England',
          'W4FMS' => 'United States',
          'ZZ0ZF' => 'Fernando de Noronha',
          'RR9S' => 'Asiatic Russia',
          '2E' => 'England',
          'AH9' => 'Wake I.',
          '6G' => 'Mexico',
          '9J' => 'Zambia',
          '4B4' => 'Revilla Gigedo',
          'GT' => 'Isle of Man',
          'LW8EXF/D' => 'Argentina',
          'DF' => 'Germany',
          'GB2MOF' => 'Scotland',
          'BM' => 'Taiwan',
          'RW9I' => 'Asiatic Russia',
          'ZV0F' => 'Fernando de Noronha',
          'FT5W' => 'Crozet',
          'GB0GUD' => 'Jersey',
          'RP7' => 'Asiatic Russia',
          'GB8CN' => 'Scotland',
          '2X' => 'Wales',
          'W0YRN' => 'United States',
          'RE8' => 'Asiatic Russia',
          '9X' => 'Rwanda',
          'TX0A;' => 'French Guiana',
          'GB5TI' => 'Scotland',
          'VM9L' => 'Lord Howe I.',
          '6F4' => 'Revilla Gigedo',
          'XT;' => 'Burkina Faso',
          'BH3J' => 'China',
          'AO' => 'Spain',
          'PQ0S' => 'St. Peter & St. Paul',
          'H4;' => 'Solomon Islands',
          '3I' => 'China',
          'AM9' => 'Ceuta and Melilla',
          'B1' => 'China',
          '4U2UN' => 'United Nations HQ',
          'MM0XAU' => 'Shetland',
          'HE;' => 'Switzerland',
          'W7SE' => 'United States',
          'N4IRR' => 'United States',
          'EF9' => 'Ceuta and Melilla',
          'UC8' => 'Asiatic Russia',
          'SX5' => 'Dodecanese',
          'KL7FDQ' => 'United States',
          'BD3L' => 'China',
          '4H' => 'Philippines',
          'VP6;' => 'Pitcairn I.',
          'K4HAL' => 'United States',
          'KE4MBP' => 'United States',
          'TO4A' => 'Martinique',
          'GB6OQA' => 'Wales',
          '6Y;' => 'Jamaica',
          'CT' => 'Portugal',
          '7J' => 'Japan',
          'FO/DL5XU' => 'Austral Is.',
          'RP9S' => 'Asiatic Russia',
          'TX4B;' => 'Martinique',
          'GB2LAY' => 'Scotland',
          'UG2' => 'Kaliningrad',
          'EQ;' => 'Iran',
          'LN;' => 'Norway',
          '3Q' => 'China',
          '4X' => 'Israel',
          'GB0SH' => 'Wales',
          'B3' => 'China',
          'WL7BPY' => 'United States',
          '8R' => 'Guyana',
          'PT0ZF' => 'Fernando de Noronha',
          'BT9O' => 'China',
          'K7BG' => 'United States',
          'LA' => 'Norway',
          'GB2RTB' => 'Wales',
          'LU2EE/E' => 'Argentina',
          '7A' => 'Indonesia',
          'XM' => 'Canada',
          'TE' => 'Costa Rica',
          'GB2SIP' => 'Wales',
          'TO5J' => 'Martinique',
          'GB8CY' => 'Scotland',
          'VA2VFT' => 'Canada',
          'GB0TD' => 'Wales',
          'VH9L' => 'Lord Howe I.',
          'RV0' => 'Asiatic Russia',
          'T31;' => 'Central Kiribati',
          '9M2' => 'West Malaysia',
          'V6' => 'Micronesia',
          'K3GP' => 'United States',
          'AD' => 'United States',
          'BH9P' => 'China',
          'N4SL' => 'United States',
          'RD8T' => 'Asiatic Russia',
          'KH7K' => 'Kure I.',
          'RS9' => 'Asiatic Russia',
          'AX' => 'Australia',
          'VE2AG' => 'Canada',
          'FT0W' => 'Crozet',
          'GB0MFD' => 'Northern Ireland',
          'RK9' => 'Asiatic Russia',
          'R9S' => 'Asiatic Russia',
          'OC;' => 'Peru',
          'N3BB' => 'United States',
          'W1DY' => 'United States',
          'L4' => 'Argentina',
          'PY0F' => 'Fernando de Noronha',
          'VE2DMG' => 'Canada',
          'GB4ZBS' => 'Scotland',
          'LB' => 'Norway',
          'BD3J' => 'China',
          'GB2RSC' => 'Wales',
          '6N' => 'South Korea',
          'PX0R' => 'Fernando de Noronha',
          'B8' => 'China',
          'LU1Z' => 'Antarctica',
          '7C' => 'Indonesia',
          'GB4SPD' => 'Northern Ireland',
          'LU1DZ/P' => 'Argentina',
          'VD1' => 'Canada',
          'PP0T' => 'Trindade & Martim Vaz',
          'GB100TT' => 'Isle of Man',
          'A6' => 'United Arab Emirates',
          'GI' => 'Northern Ireland',
          'VO2' => 'Canada',
          'CS' => 'Portugal',
          'LX' => 'Luxembourg',
          'RS0' => 'Asiatic Russia',
          '9W8' => 'East Malaysia',
          '5Z' => 'Kenya',
          'FO/c' => 'Clipperton I.',
          'KL1IF' => 'United States',
          'YX0' => 'Aves I.',
          'SX' => 'Greece',
          'GB2KHL' => 'Scotland',
          '5Y' => 'Kenya',
          'MM5PSL' => 'Shetland',
          'IZ9;' => 'Sicily',
          'VN9M' => 'Mellish Reef',
          'RG9' => 'Asiatic Russia',
          'GM7GWW' => 'Shetland',
          'AC4PY' => 'United States',
          'N7DF' => 'United States',
          'ZY0ZR' => 'Fernando de Noronha',
          'AY5E/D' => 'Argentina',
          'R35NP' => 'Asiatic Russia',
          'U9W' => 'Asiatic Russia',
          'E5/n' => 'North Cook Is.',
          'GB2JUNO' => 'Scotland',
          'GB93AM;' => 'Scotland',
          'B3K' => 'China',
          '5L' => 'Liberia',
          'LU4DRH/D' => 'Argentina',
          'IQ0AI' => 'Sardinia',
          'OY' => 'Faroe Is.',
          'WA1MKE' => 'United States',
          'UH8' => 'Asiatic Russia',
          'GB8CF' => 'Scotland',
          'JH' => 'Japan',
          'LF' => 'Norway',
          'AS;' => 'Pakistan',
          '8M' => 'Japan',
          'TB1' => 'Turkey (Europe)',
          'OH0' => 'Aland Is.',
          'VX' => 'Canada',
          'N4KZ' => 'United States',
          'TO9T;' => 'Guadeloupe',
          'UA7' => 'Asiatic Russia',
          'GB0NEW' => 'Wales',
          'VP8/LZ1UQ' => 'South Shetland',
          'HW' => 'France',
          'AY0N/X' => 'Argentina',
          'RJ9W' => 'Asiatic Russia',
          'LW4DRH/E' => 'Argentina',
          'LW8EU/D' => 'Argentina',
          '4U1I' => 'ITU HQ Geneva',
          '8Q;' => 'Maldives',
          'W4NBS' => 'United States',
          'RU4W' => 'European Russia',
          'SM;' => 'Sweden',
          'GB2CPC' => 'Wales',
          '5S' => 'Madagascar',
          'GB0WRC' => 'Wales',
          'KN8J' => 'United States',
          'H4' => 'Solomon Islands',
          'GM1ZNR' => 'Shetland',
          'PP0ZF' => 'Fernando de Noronha',
          'UI2;' => 'Kaliningrad',
          'VK9L' => 'Lord Howe I.',
          'RI0' => 'Asiatic Russia',
          '2M0ZET' => 'Shetland',
          'JW;' => 'Svalbard',
          'RC9W' => 'Asiatic Russia',
          'TX0AT' => 'Chesterfield Is.',
          'RP9I' => 'Asiatic Russia',
          'GB2TDS' => 'Scotland',
          'OK' => 'Czech Republic',
          'RK0' => 'Asiatic Russia',
          'BA3J' => 'China',
          'W4HZD' => 'United States',
          'A8' => 'Liberia',
          'S7;' => 'Seychelles',
          'TX3SAM' => 'New Caledonia',
          'GB2AGG' => 'Scotland',
          'U7' => 'Asiatic Russia',
          'KH8SI;' => 'Swains Island',
          'LW2DX/Q' => 'Argentina',
          'BG' => 'China',
          'R7' => 'Asiatic Russia',
          'VL0M' => 'Macquarie I.',
          'TL' => 'Central African Rep',
          'BT3L' => 'China',
          'CZ1' => 'Canada',
          'RR9W' => 'Asiatic Russia',
          'PW0ZF' => 'Fernando de Noronha',
          'VP9' => 'Bermuda',
          'GB0SHL' => 'Jersey',
          'GB60BBC' => 'Scotland',
          '6U' => 'Sudan',
          'ZT' => 'South Africa',
          'AX9C' => 'Cocos-Keeling',
          'VP6/d' => 'Ducie I.',
          'T6' => 'Afghanistan',
          'AX0M' => 'Macquarie I.',
          'BY9N' => 'China',
          'XR0;' => 'Easter Island',
          'GM7AFE' => 'Shetland',
          'LW7DNS/E' => 'Argentina',
          'DR;' => 'Germany',
          '9E' => 'Ethiopia',
          'W4CID' => 'United States',
          'NH8' => 'American Samoa',
          'VK9KX' => 'Christmas I.',
          'UC9I' => 'Asiatic Russia',
          'ZY0ZF' => 'Fernando de Noronha',
          'UI9M' => 'Asiatic Russia',
          'DJ' => 'Germany',
          'UI9T' => 'Asiatic Russia',
          'KD5MDO' => 'United States',
          'TO4E;' => 'Juan de Nova & Europa',
          'LU8EEM/D' => 'Argentina',
          'TO5A' => 'Martinique',
          'AY' => 'Argentina',
          'VE2MTA' => 'Canada',
          'DI' => 'Germany',
          'DP' => 'Germany',
          'GB2SDD' => 'Wales',
          'XX9;' => 'Macau',
          '6S' => 'Pakistan',
          'XG4' => 'Revilla Gigedo',
          'K3IE' => 'United States',
          '5G' => 'Morocco',
          'PS0R' => 'Fernando de Noronha',
          'Z3;' => 'Macedonia',
          '6H' => 'Mexico',
          'SW9' => 'Crete',
          '7Q;' => 'Malawi',
          '5N' => 'Nigeria',
          'TO6M' => 'Martinique',
          'AH6RI' => 'United States',
          'VB2C' => 'Canada',
          'VP8SSI' => 'South Sandwich',
          'LU3CQ/D' => 'Argentina',
          'CB0X' => 'San Felix I.',
          'BY' => 'China',
          '8I' => 'Indonesia',
          'OJ;' => 'Finland',
          'GB0BTC' => 'Northern Ireland',
          'UG8V' => 'Asiatic Russia',
          'FT8X;' => 'Kerguelen',
          'PB' => 'Netherlands',
          'U9M' => 'Asiatic Russia',
          'GB0ML' => 'Wales',
          'YK;' => 'Syria',
          'SU' => 'Egypt',
          'TH' => 'France',
          'IH9;' => 'Italy (Africa)',
          'VH' => 'Australia',
          'W3HDH' => 'United States',
          'WT5L' => 'United States',
          'NA4K' => 'United States',
          'W2OO' => 'United States',
          'LU5BE/D' => 'Argentina',
          'V3' => 'Belize',
          'VF1' => 'Canada',
          'TI9' => 'Cocos I.',
          '2W' => 'Wales',
          'VK0M' => 'Macquarie I.',
          'LU7DSY/V' => 'Argentina',
          'VL' => 'Australia',
          'AH5' => 'Palmyra & Jarvis Is.',
          'VB2V' => 'Canada',
          '4L' => 'Georgia',
          'PU0ZF' => 'Fernando de Noronha',
          'VM9W' => 'Willis I.',
          'EU' => 'Belarus',
          'AO8' => 'Canary Is.',
          'LU8VCC/D' => 'Argentina',
          'LU6UO/P' => 'Argentina',
          'PR0S' => 'St. Peter & St. Paul',
          'YC' => 'Indonesia',
          '8W' => 'India',
          'HI;' => 'Dominican Republic',
          '3Y/p' => 'Peter I I.',
          'LK' => 'Norway',
          'BA9R' => 'China',
          'A3;' => 'Tonga',
          'RW9M' => 'Asiatic Russia',
          'RM9' => 'Asiatic Russia',
          'FM' => 'Martinique',
          'PX0ZF' => 'Fernando de Noronha',
          'JW5RIA' => 'Bear I.',
          'LU4DQ/D' => 'Argentina',
          'GM4SLV' => 'Shetland',
          'DX' => 'Philippines',
          'LU5FZ/D' => 'Argentina',
          'W1DYJ' => 'United States',
          'GM3ZET' => 'Shetland',
          'KG6SL;' => 'Mariana Is.',
          'LO7E/D' => 'Argentina',
          'XT' => 'Burkina Faso',
          '6H4' => 'Revilla Gigedo',
          'LZ0A' => 'South Shetland',
          'VP2M' => 'Montserrat',
          'K4RO' => 'United States',
          'XN1' => 'Canada',
          'UF2' => 'Kaliningrad',
          'B9Q' => 'China',
          'TO5S' => 'Guadeloupe',
          'LU6DRR/D' => 'Argentina',
          'HH' => 'Haiti',
          'UF7' => 'Asiatic Russia',
          'TO7GAS' => 'Guadeloupe',
          'GB0SK' => 'Scotland',
          'W4TYU' => 'United States',
          'BT9P' => 'China',
          'LW5DWX/D' => 'Argentina',
          'VI0' => 'Antarctica',
          'RM8T' => 'Asiatic Russia',
          'LU/DH4PB/R' => 'Argentina',
          'VE2AOF' => 'Canada',
          'UF9T' => 'Asiatic Russia',
          'TA' => 'Turkey',
          'DC' => 'Germany',
          'L8D/X' => 'Argentina',
          'RQ8' => 'Asiatic Russia',
          'W1AA/MSC' => 'United States',
          '4U1UN' => 'United Nations HQ',
          'U0' => 'Asiatic Russia',
          'P7' => 'North Korea',
          'BG3H' => 'China',
          'TO2FG' => 'Guadeloupe',
          'W7FG' => 'United States',
          'HR' => 'Honduras',
          'N7VMR' => 'United States',
          'N4ZZ' => 'United States',
          'RN8V' => 'Asiatic Russia',
          'GB8FF' => 'Scotland',
          'GB0MST' => 'Isle of Man',
          'PR0ZR' => 'Fernando de Noronha',
          'VP2V;' => 'British Virgin Is.',
          'K7REL' => 'United States',
          'LW8ECQ/D' => 'Argentina',
          'RY2' => 'Kaliningrad',
          'PU' => 'Brazil',
          'RR0' => 'Asiatic Russia',
          '6Z' => 'Liberia',
          'NP1' => 'Navassa I.',
          'FT5X' => 'Kerguelen',
          'W4LC' => 'United States',
          'S5' => 'Slovenia',
          'BY3J' => 'China',
          'D8' => 'South Korea',
          'J49' => 'Crete',
          'VE2Z' => 'Canada',
          'TX0DX' => 'Chesterfield Is.',
          '3N' => 'China',
          'GB0FFS' => 'Scotland',
          'TO5GI' => 'Guadeloupe',
          'GB2WDS' => 'Wales',
          'LU5EWO/D' => 'Argentina',
          'JY' => 'Jordan',
          'KL0LN' => 'United States',
          'LU8EGS/D' => 'Argentina',
          'RM0' => 'Asiatic Russia',
          'LU5DWS/D' => 'Argentina',
          'RA8T' => 'Asiatic Russia',
          'K9ES' => 'United States',
          'XC' => 'Mexico',
          'ZY0ZS' => 'St. Peter & St. Paul',
          'GB0SHP' => 'Scotland',
          'BZ9N' => 'China',
          'PQ0ZS' => 'St. Peter & St. Paul',
          'PJ5' => 'Sint Maarten',
          '4W' => 'Timor-Leste',
          'W4EF' => 'United States',
          'LU9ESD/Y' => 'Argentina',
          'YQ' => 'Romania',
          'VP8;' => 'Falkland Is.',
          'YV' => 'Venezuela',
          'AA3VA' => 'United States',
          'SL' => 'Sweden',
          '7B' => 'Indonesia',
          'BA9P' => 'China',
          'GB2LS' => 'Scotland',
          'VE8PW' => 'Canada',
          'AX9X' => 'Christmas I.',
          '3T' => 'China',
          'FT0Y' => 'Antarctica',
          'LU3DJI/D' => 'Argentina',
          'RD9T' => 'Asiatic Russia',
          'GB0HHW' => 'Scotland',
          'GB4DPS' => 'Wales',
          'PZ;' => 'Suriname',
          'GB2NTS' => 'Scotland',
          'AV' => 'India',
          'RN4W' => 'European Russia',
          'A5' => 'Bhutan',
          'ZK2;' => 'Niue',
          'LT' => 'Argentina',
          'CT9' => 'Madeira Is.',
          'PM' => 'Indonesia',
          'VE2XY' => 'Canada',
          'SG' => 'Sweden',
          'BD9S' => 'China',
          'KG6ASO' => 'Guam',
          'TT' => 'Chad',
          'GB8CSL' => 'Scotland',
          'WH0AI' => 'United States',
          'AC' => 'United States',
          'UW' => 'Ukraine',
          'RK8' => 'Asiatic Russia',
          'IQ0EH' => 'Sardinia',
          'ZY0F' => 'Fernando de Noronha',
          'GB0OS' => 'Scotland',
          'UM;' => 'Uzbekistan',
          'RU9' => 'Asiatic Russia',
          'GB5OL' => 'Scotland',
          'ZV0S' => 'St. Peter & St. Paul',
          'GB0SS' => 'Scotland',
          '9K;' => 'Kuwait',
          'P5' => 'North Korea',
          'WS4Y' => 'United States',
          'GJ' => 'Jersey',
          'TO0O' => 'Martinique',
          'ZM7;' => 'Chatham Is.',
          'LU1VOF/D' => 'Argentina',
          '7G' => 'Indonesia',
          '7N' => 'Japan',
          'PV' => 'Brazil',
          'UE9T' => 'Asiatic Russia',
          'CW' => 'Uruguay',
          'KG6DX;' => 'Guam',
          'ZY0T' => 'Trindade & Martim Vaz',
          'RI9' => 'Asiatic Russia',
          'RF7' => 'Asiatic Russia',
          'N4QS' => 'United States',
          'CE9' => 'Antarctica',
          'SA' => 'Sweden',
          'AJ' => 'United States',
          'T32' => 'Eastern Kiribati',
          'C5;' => 'Gambia',
          'NA4MA' => 'United States',
          'L84VI/D' => 'Argentina',
          'LW5EOL/D' => 'Argentina',
          'CQ9' => 'Madeira Is.',
          '9X;' => 'Rwanda',
          'WA4OSD' => 'United States',
          'MJ' => 'Jersey',
          'RZ2' => 'Kaliningrad',
          'SV9' => 'Crete',
          'GB2MRI' => 'Northern Ireland',
          'ZB' => 'Gibraltar',
          'BG9Q' => 'China',
          'GM4GQM' => 'Shetland',
          'VI9Y' => 'Cocos-Keeling',
          'HK0/m' => 'Malpelo I.',
          'RT8' => 'Asiatic Russia',
          'IO9' => 'Sicily',
          'LU6DRD/E' => 'Argentina',
          'K2HT' => 'United States',
          'ZD8' => 'Ascension I.',
          '6A' => 'Egypt',
          'BL3G' => 'China',
          'XX9' => 'Macau',
          'XQ' => 'Chile',
          'RL2' => 'Kaliningrad',
          'VM9M' => 'Mellish Reef',
          'JV;' => 'Mongolia',
          'U8T' => 'Asiatic Russia',
          'RW2' => 'Kaliningrad',
          'J6;' => 'St. Lucia',
          'OO' => 'Belgium',
          'GB0NHL' => 'Scotland',
          'GB6TAA' => 'Scotland',
          'J6' => 'St. Lucia',
          'XH4' => 'Revilla Gigedo',
          'LU5DEM/V' => 'Argentina',
          'KH6ILR' => 'United States',
          'LO0D/D' => 'Argentina',
          'LU6EC/W' => 'Argentina',
          'GB750CC' => 'Wales',
          'CX' => 'Uruguay',
          'RP2' => 'Kaliningrad',
          'TU;' => 'Cote d\'Ivoire',
          'LW2DX/R' => 'Argentina',
          'W0ZZ' => 'United States',
          'GB8CM' => 'Scotland',
          'LW6DTM/D' => 'Argentina',
          'GB8CA' => 'Scotland',
          'RO9' => 'Asiatic Russia',
          'VN9W' => 'Willis I.',
          'A7;' => 'Qatar',
          'RL8T' => 'Asiatic Russia',
          'L7' => 'Argentina',
          'BS7' => 'Scarborough Reef',
          '9A;' => 'Croatia',
          'BL9Q' => 'China',
          'GB3MNI' => 'Northern Ireland',
          '4O;' => 'Montenegro',
          'PP0F' => 'Fernando de Noronha',
          'GB4RAF' => 'Scotland',
          '9M50' => 'West Malaysia',
          'W0YR' => 'United States',
          'CY0;' => 'Sable I.',
          '3M' => 'China',
          'GB2NCL' => 'Scotland',
          'N3AIU' => 'United States',
          'UG9S' => 'Asiatic Russia',
          'B3I' => 'China',
          'R7C/1' => 'European Russia',
          'K4JA' => 'United States',
          'RC8T' => 'Asiatic Russia',
          'ED' => 'Spain',
          'R0' => 'Asiatic Russia',
          'ZX0ZR' => 'Fernando de Noronha',
          'PV0ZT' => 'Trindade & Martim Vaz',
          'VK9W' => 'Willis I.',
          'YH;' => 'Indonesia',
          'GB2GGM' => 'Wales',
          'GB2VK' => 'Wales',
          'VE2BQB' => 'Canada',
          'RT9T' => 'Asiatic Russia',
          '9P' => 'Rep. of Congo',
          'VY1' => 'Canada',
          'EC9' => 'Ceuta and Melilla',
          'VI9X' => 'Christmas I.',
          'TO3W' => 'Martinique',
          'W2VJN' => 'United States',
          'LU1AEE/D' => 'Argentina',
          'GB2GNL' => 'Scotland',
          'TO5X' => 'Martinique',
          '5J0' => 'San Andres/Providencia',
          'RC8' => 'Asiatic Russia',
          'CJ' => 'Canada',
          '4U1V' => 'Vienna Intl Ctr',
          'UF9' => 'Asiatic Russia',
          'GB2SPD' => 'Scotland',
          'GB2PBF' => 'Scotland',
          'RB7' => 'Asiatic Russia',
          'KC3MR' => 'United States',
          'K7CMZ' => 'United States',
          'ZL7' => 'Chatham Is.',
          'FO/m' => 'Marquesas Is.',
          'VT' => 'India',
          'RW8' => 'Asiatic Russia',
          'B7' => 'China',
          'BL3L' => 'China',
          'W8ZA' => 'United States',
          'UD8' => 'Asiatic Russia',
          'GB0KGS' => 'Scotland',
          'RJ8' => 'Asiatic Russia',
          'LW3DKC/E' => 'Argentina',
          'BH3I' => 'China',
          'GB125BRC' => 'Scotland',
          'GB2FIO' => 'Scotland',
          'HK0;' => 'San Andres/Providencia',
          'BT3I' => 'China',
          'VE2YM' => 'Canada',
          'PT0ZT' => 'Trindade & Martim Vaz',
          'TF;' => 'Iceland',
          'ZY' => 'Brazil',
          'JJ' => 'Japan',
          'CN;' => 'Morocco',
          'TO8CW' => 'Guadeloupe',
          'LU2VC/D' => 'Argentina',
          'RB0' => 'Asiatic Russia',
          '4U5UN' => 'United Nations HQ',
          '8E' => 'Indonesia',
          'RG9M' => 'Asiatic Russia',
          'W6AAN' => 'United States',
          'ZV0ZR' => 'Fernando de Noronha',
          'OF0' => 'Aland Is.',
          'HE0;' => 'Liechtenstein',
          'VN0M' => 'Macquarie I.',
          'TO5RZ;' => 'Saint Barthelemy',
          'VE8AJ' => 'Canada',
          'N2IC' => 'United States',
          'K4LTA' => 'United States',
          'V8;' => 'Brunei',
          'VW;' => 'India',
          'RI9I' => 'Asiatic Russia',
          'VK9DWX;' => 'Willis I.',
          'LU1ZC' => 'South Shetland',
          'GB6SM' => 'Scotland',
          'WH7K;' => 'Kure I.',
          'FP;' => 'St. Pierre & Miquelon',
          'TG;' => 'Guatemala',
          'GM4LER' => 'Shetland',
          'W9GEN' => 'United States',
          'ZD8;' => 'Ascension I.',
          'NH4' => 'Midway I.',
          'IT9' => 'Sicily',
          'WA4JA' => 'United States',
          'JD/m' => 'Minami Torishima',
          'RY9' => 'Asiatic Russia',
          'WJ9B' => 'United States',
          'W1MVY' => 'United States',
          'LU8EBK/E' => 'Argentina',
          'GB60NTS' => 'Scotland',
          'J7;' => 'Dominica',
          'LW4DRV/D' => 'Argentina',
          'GB0SIC' => 'Northern Ireland',
          'WP4JBG' => 'United States',
          '4U6UN;' => 'United Nations HQ',
          'EA9' => 'Ceuta and Melilla',
          'GB50SWL' => 'Scotland',
          'BZ3I' => 'China',
          'RE9M' => 'Asiatic Russia',
          'ZT8' => 'Marion I.',
          'AL7KT' => 'United States',
          'LU1DZ/X' => 'Argentina',
          'GB6AR' => 'Wales',
          'YT' => 'Serbia',
          'JN' => 'Japan',
          'VA2RHJ' => 'Canada',
          'RS9M' => 'Asiatic Russia',
          'JU' => 'Mongolia',
          'OG' => 'Finland',
          'W6DSQ' => 'United States',
          'GB6SPC;' => 'Isle of Man',
          'K8XS' => 'United States',
          'RR7' => 'Asiatic Russia',
          'CZ0' => 'Canada',
          'C3;' => 'Andorra',
          'MP' => 'Guernsey',
          'NQ4U' => 'United States',
          '3J' => 'China',
          'EN' => 'Ukraine',
          'TA1' => 'Turkey (Europe)',
          'GB0MWL' => 'Wales',
          'TO8B' => 'Martinique',
          'AN6' => 'Balearic Is.',
          'YF' => 'Indonesia',
          'S9' => 'Sao Tome & Principe',
          'PQ0ZT' => 'Trindade & Martim Vaz',
          'IQ0AM' => 'Sardinia',
          'AL0F' => 'United States',
          'XS;' => 'China',
          'UD9M' => 'Asiatic Russia',
          'GB4ES' => 'Northern Ireland',
          'GB50UN' => 'Isle of Man',
          'EP' => 'Iran',
          'KD5M' => 'United States',
          'LG' => 'Norway',
          'KB7Q' => 'United States',
          'LU7EGH/V' => 'Argentina',
          'V7' => 'Marshall Is.',
          'TO7AES' => 'Guadeloupe',
          'PW0ZS' => 'St. Peter & St. Paul',
          'WP3' => 'Puerto Rico',
          'LU8EKB/W' => 'Argentina',
          'RT2' => 'Kaliningrad',
          'AY7DSY/D' => 'Argentina',
          'RB9T' => 'Asiatic Russia',
          'LW9EVA/E;' => 'Argentina',
          'VY0AA' => 'Canada',
          'PJ6' => 'Sint Maarten',
          'K4XU' => 'United States',
          'VJ0' => 'Antarctica',
          'E5/s' => 'South Cook Is.',
          'XC4' => 'Revilla Gigedo',
          'N8WXQ' => 'United States',
          'GB400CA' => 'Scotland',
          'HQ' => 'Honduras',
          'L44D/D' => 'Argentina',
          'VI9M' => 'Mellish Reef',
          'FT8W;' => 'Crozet',
          '3DA' => 'Swaziland',
          'OV' => 'Denmark',
          'KN4QS' => 'United States',
          'ZZ0T' => 'Trindade & Martim Vaz',
          'RH9I' => 'Asiatic Russia',
          'IW9' => 'Sicily',
          '2D' => 'Isle of Man',
          'F' => 'France',
          'EB' => 'Spain',
          'EH;' => 'Spain',
          'UH9W' => 'Asiatic Russia',
          'RK9T' => 'Asiatic Russia',
          'JW7FD;' => 'Bear I.',
          'VE2PR' => 'Canada',
          'UA9T' => 'Asiatic Russia',
          '3D2;' => 'Fiji',
          '6D' => 'Mexico',
          'RG9W' => 'Asiatic Russia',
          'HL' => 'South Korea',
          'TY;' => 'Benin',
          'W6TER' => 'United States',
          'VA2DXE' => 'Canada',
          'VF0' => 'Canada',
          'VE2ERU' => 'Canada',
          'EE6' => 'Balearic Is.',
          'VE' => 'Canada',
          'LZ;' => 'Bulgaria',
          'KL7XX' => 'United States',
          '5T;' => 'Mauritania',
          'GB2LTN' => 'Scotland',
          'GB4BHF' => 'Jersey',
          'PT0T' => 'Trindade & Martim Vaz',
          'N6AR' => 'United States',
          'TG' => 'Guatemala',
          'TO5FJ' => 'Saint Barthelemy',
          'HV' => 'Vatican City',
          'TL;' => 'Central African Rep',
          'VA2KCE' => 'Canada',
          'RZ9' => 'Asiatic Russia',
          '4U5ITU' => 'ITU HQ Geneva',
          'GB2KDS' => 'Scotland',
          'CY0' => 'Sable I.',
          'AO9' => 'Ceuta and Melilla',
          'KH4' => 'Midway I.',
          'TO3M' => 'Martinique',
          'LU7DW/D' => 'Argentina',
          'HG;' => 'Hungary',
          'ZG;' => 'Gibraltar',
          '8U' => 'India',
          'DJ4SN/LU/X' => 'Argentina',
          'N2NB' => 'United States',
          'PX0ZT' => 'Trindade & Martim Vaz',
          '7F' => 'Indonesia',
          'UB7' => 'Asiatic Russia',
          'GB0HEL' => 'Wales',
          'BY3H' => 'China',
          'TI;' => 'Costa Rica',
          'K7IA' => 'United States',
          'RL8' => 'Asiatic Russia',
          '4R' => 'Sri Lanka',
          'LU7DJJ/W' => 'Argentina',
          'BG3L' => 'China',
          'BH3H' => 'China',
          'RY9T' => 'Asiatic Russia',
          'R9HQ' => 'Asiatic Russia',
          '6I4' => 'Revilla Gigedo',
          'PS0ZR' => 'Fernando de Noronha',
          'FT4Z' => 'Amsterdam & St. Paul',
          'LU7DID/V' => 'Argentina',
          'GB2GU' => 'Guernsey',
          'KH6QAI' => 'United States',
          'RA2' => 'Kaliningrad',
          '9N' => 'Nepal',
          'RE7' => 'Asiatic Russia',
          'UQ;' => 'Kazakhstan',
          'AX9Y' => 'Cocos-Keeling',
          'K0COP' => 'United States',
          'RO9T' => 'Asiatic Russia',
          'WL' => 'Alaska',
          'ZV' => 'Brazil',
          'EZ;' => 'Turkmenistan',
          'GB5CO' => 'Scotland',
          'AH6HJ' => 'United States',
          'RH9T' => 'Asiatic Russia',
          'VE2NRK' => 'Canada',
          'NL' => 'Alaska',
          'A2' => 'Botswana',
          'UH2' => 'Kaliningrad',
          'VP9;' => 'Bermuda',
          'SZ;' => 'Greece',
          'LU6DKT/D' => 'Argentina',
          'WB8YYY' => 'United States',
          '5H' => 'Tanzania',
          'JI' => 'Japan',
          'LU7EPC/W' => 'Argentina',
          'A5;' => 'Bhutan',
          'PW0R' => 'Fernando de Noronha',
          'RR8V' => 'Asiatic Russia',
          'GB2BYL' => 'Jersey',
          'BU' => 'Taiwan',
          'IW0W' => 'Sardinia',
          'VZ9M;' => 'Mellish Reef',
          '2P' => 'Guernsey',
          'CD0X' => 'San Felix I.',
          'JD1;' => 'Ogasawara',
          'RI9S' => 'Asiatic Russia',
          'MVI' => 'Malyj Vysotskij',
          'BL9M' => 'China',
          'RY9W' => 'Asiatic Russia',
          'VE2III' => 'Canada',
          'TO1C' => 'Martinique',
          'NA4M' => 'United States',
          'TC1' => 'Turkey (Europe)',
          'UI9W' => 'Asiatic Russia',
          'TZ' => 'Mali',
          'TO1T' => 'Guadeloupe',
          'K8IA' => 'United States',
          'N2BJ' => 'United States',
          'TX6A;' => 'Mayotte',
          'RF9M' => 'Asiatic Russia',
          'GB0GEI' => 'Scotland',
          'BT9S' => 'China',
          'K4WW' => 'United States',
          'BV' => 'Taiwan',
          'W6IHG' => 'United States',
          'RS9S' => 'Asiatic Russia',
          'GM0AVR' => 'Shetland',
          'L21ESC/LH' => 'Argentina',
          'BH9R' => 'China',
          'SK' => 'Sweden',
          'GB2JSA' => 'Jersey',
          'DW' => 'Philippines',
          'VE2WT' => 'Canada',
          'R1FJ;' => 'Franz Josef Land',
          'RX8' => 'Asiatic Russia',
          'LU1YU/D' => 'Argentina',
          'K4JNY' => 'United States',
          'UB2' => 'Kaliningrad',
          'RN0' => 'Asiatic Russia',
          'LU6XAH/X' => 'Argentina',
          'VL9Y' => 'Cocos-Keeling',
          'UA8T' => 'Asiatic Russia',
          'N8FF' => 'United States',
          'GB4TSR' => 'Scotland',
          '5T' => 'Mauritania',
          'VP6' => 'Pitcairn I.',
          '5M' => 'Liberia',
          'LC' => 'Norway',
          'FR/j' => 'Juan de Nova & Europa',
          'AA0CY' => 'United States',
          'UH9' => 'Asiatic Russia',
          'BG9R' => 'China',
          '9B' => 'Iran',
          'B3J' => 'China',
          'R8V' => 'Asiatic Russia',
          'KP2' => 'Virgin Is.',
          'RS8' => 'Asiatic Russia',
          'PR0ZT' => 'Trindade & Martim Vaz',
          '8B' => 'Indonesia',
          'LU3DXG/D' => 'Argentina',
          'GB2NIC' => 'Northern Ireland',
          'LU8EXN/D' => 'Argentina',
          'EG9' => 'Ceuta and Melilla',
          'YA;' => 'Afghanistan',
          'RK9M' => 'Asiatic Russia',
          'BG3G' => 'China',
          'GB50AAD' => 'Northern Ireland',
          '1A' => 'Sov Mil Order of Malta',
          'AL4T' => 'United States',
          'UH7' => 'Asiatic Russia',
          'GB50JS' => 'Scotland',
          'K3WT' => 'United States',
          'VP8/g' => 'South Georgia',
          '8N' => 'Japan',
          'GB2MIL' => 'Wales',
          '3DA;' => 'Swaziland',
          'VL9C' => 'Cocos-Keeling',
          'TM' => 'France',
          'LU1OFN/I' => 'Argentina',
          'UB9S' => 'Asiatic Russia',
          'UK' => 'Uzbekistan',
          'LU7DZL/D' => 'Argentina',
          'GB2OWM' => 'Scotland',
          'BA3I' => 'China',
          'HK0M' => 'Malpelo I.',
          'RE9W' => 'Asiatic Russia',
          'PV0ZS' => 'St. Peter & St. Paul',
          'V6;' => 'Micronesia',
          '3A' => 'Monaco',
          'PV0R' => 'Fernando de Noronha',
          'BY9O' => 'China',
          'VE2ZM' => 'Canada',
          '7T' => 'Algeria',
          'IQ0QP' => 'Sardinia',
          'LW7DLY/D' => 'Argentina',
          'L30EY/D' => 'Argentina',
          'VY0' => 'Canada',
          '2I' => 'Northern Ireland',
          '7M' => 'Japan',
          'J2;' => 'Djibouti',
          'LW1DAL/D' => 'Argentina',
          'K4BX' => 'United States',
          'TO7HAM' => 'Martinique',
          '3B9;' => 'Rodriguez I.',
          'LW9EAG/D' => 'Argentina',
          'NY4N' => 'United States',
          'RP8V' => 'Asiatic Russia',
          'GB2IOT' => 'Scotland',
          'VE2XAA/2' => 'Canada',
          'VJ9' => 'Norfolk I.',
          'EC8' => 'Canary Is.',
          'LU4DA/D' => 'Argentina',
          'VY2MGY/3' => 'Canada',
          'RF9W' => 'Asiatic Russia',
          'BD3K' => 'China',
          'GB60CRB' => 'Scotland',
          '9K' => 'Kuwait',
          'RZ9W' => 'Asiatic Russia',
          'YK' => 'Syria',
          'WB8YQJ' => 'United States',
          'LU7DIR/D' => 'Argentina',
          'VK9KY' => 'Cocos-Keeling',
          'A9' => 'Bahrain',
          'R7C/3' => 'European Russia',
          'K4BEV' => 'United States',
          'RY8V' => 'Asiatic Russia',
          'BD3I' => 'China',
          'AL7O' => 'United States',
          'PQ0T' => 'Trindade & Martim Vaz',
          'BT9N' => 'China',
          'HR;' => 'Honduras',
          'GB3GM' => 'Scotland',
          'LW2DX/Y' => 'Argentina',
          'GB6MI' => 'Scotland',
          'ZS7' => 'Antarctica',
          'W4YOK' => 'United States',
          'GB4SLH' => 'Scotland',
          'PS0F' => 'Fernando de Noronha',
          'CE' => 'Chile',
          'PC' => 'Netherlands',
          'VE3RHJ/2' => 'Canada',
          'RN9W' => 'Asiatic Russia',
          'LU5EFX/Y' => 'Argentina',
          'GB100BD' => 'Wales',
          'L9' => 'Argentina',
          'HF0POL' => 'South Shetland',
          'VI9L' => 'Lord Howe I.',
          'BO' => 'Taiwan',
          '4O' => 'Montenegro',
          'UR' => 'Ukraine',
          'RP9T' => 'Asiatic Russia',
          'BZ9Q' => 'China',
          'R1MV' => 'Malyj Vysotskij',
          'AL' => 'Alaska',
          'XL' => 'Canada',
          '9S' => 'Rep. of Congo',
          'VM0' => 'Antarctica',
          'W9GE' => 'United States',
          'PX0ZR' => 'Fernando de Noronha',
          'AE9F' => 'United States',
          'Z2' => 'Zimbabwe',
          'UO' => 'Kazakhstan',
          'CY9' => 'St. Paul I.',
          'B9O' => 'China',
          'WB4YDL' => 'United States',
          'GB0GIW' => 'Wales',
          'GB2LHI' => 'Scotland',
          'GB4CSC' => 'Northern Ireland',
          'RS8V' => 'Asiatic Russia',
          'GB4SA' => 'Wales',
          'RN7' => 'Asiatic Russia',
          'TO5AA' => 'Martinique',
          'CU' => 'Azores',
          'CL' => 'Cuba',
          'JD1YBJ;' => 'Minami Torishima',
          'N1WI' => 'United States',
          'LW3DKO/D' => 'Argentina',
          'VE2QRZ' => 'Canada',
          'R1FJ' => 'Franz Josef Land',
          'RD9' => 'Asiatic Russia',
          'NP3' => 'Puerto Rico',
          'UA9S' => 'Asiatic Russia',
          'NH1' => 'Baker & Howland Is.',
          'LU2EJB/X' => 'Argentina',
          'VL9L' => 'Lord Howe I.',
          'WA5VGI' => 'United States',
          'VP8SGK;' => 'South Georgia',
          'S5;' => 'Slovenia',
          'LU9ARB/D' => 'Argentina',
          'K0JJM' => 'United States',
          'HA' => 'Hungary',
          'RN9I' => 'Asiatic Russia',
          'WO5D' => 'United States',
          'TO5ROM' => 'Guadeloupe',
          'EE9' => 'Ceuta and Melilla',
          'K9VV' => 'United States',
          'BH9O' => 'China',
          'PP0S' => 'St. Peter & St. Paul',
          'K1NT' => 'United States',
          '6O' => 'Somalia',
          'K0TV' => 'United States',
          'L5' => 'Argentina',
          '5B' => 'Cyprus',
          'LU1ZA;' => 'South Orkney',
          'RM9S' => 'Asiatic Russia',
          'KL7WP' => 'United States',
          'TZ;' => 'Mali',
          'RC9I' => 'Asiatic Russia',
          'TX5M' => 'Mayotte',
          'VA3NA/2' => 'Canada',
          'B2' => 'China',
          'K7CS' => 'United States',
          'A7' => 'Qatar',
          'ZL8' => 'Kermadec Is.',
          'VP8DKF' => 'Antarctica',
          'HP;' => 'Panama',
          'UH8V' => 'Asiatic Russia',
          'LU8ECF/E' => 'Argentina',
          'ZW0ZR' => 'Fernando de Noronha',
          'GB2CHG' => 'Scotland',
          'T32;' => 'Eastern Kiribati',
          'TD' => 'Guatemala',
          'SO' => 'Poland',
          'GB0GPF' => 'Northern Ireland',
          'TX8' => 'New Caledonia',
          'VP8PJ' => 'Antarctica',
          '6B' => 'Egypt',
          'TX0P' => 'Mayotte',
          'GB2TI' => 'Scotland',
          'WO4O' => 'United States',
          'GB200A' => 'Wales',
          'RQ8V' => 'Asiatic Russia',
          'GB4AAS' => 'Scotland',
          'UF9M' => 'Asiatic Russia',
          'XB4' => 'Revilla Gigedo',
          'XG' => 'Mexico',
          'RZ8V' => 'Asiatic Russia',
          'IE9' => 'Sicily',
          'VI9C' => 'Cocos-Keeling',
          'H3' => 'Panama',
          'VP5' => 'Turks & Caicos',
          'MT' => 'Isle of Man',
          'RX8V' => 'Asiatic Russia',
          'CH1' => 'Canada',
          'JR' => 'Japan',
          'FT5Y' => 'Antarctica',
          'BY3I' => 'China',
          'LU3DR/V' => 'Argentina',
          'TN' => 'Congo',
          'PU0T' => 'Trindade & Martim Vaz',
          'GB5SIP' => 'Wales',
          'WP4;' => 'Puerto Rico',
          'XW' => 'Laos',
          'K3PA' => 'United States',
          '4U1VIC;' => 'Austria',
          'PQ0ZR' => 'Fernando de Noronha',
          'S4' => 'South Africa',
          'UC9' => 'Asiatic Russia',
          'DD' => 'Germany',
          'LU8EBJ/E' => 'Argentina',
          'LU9ESD/D' => 'Argentina',
          '4U1U' => 'United Nations HQ',
          'BH3L' => 'China',
          'K7ABV' => 'United States',
          'LU6EYK/X' => 'Argentina',
          'BA' => 'China',
          'YR;' => 'Romania',
          'K4OAQ' => 'United States',
          'K5ZD' => 'United States',
          '3U' => 'China',
          'XB' => 'Mexico',
          'UL' => 'Uzbekistan',
          'KC4AAA' => 'Antarctica',
          '8A' => 'Indonesia',
          'XK0' => 'Canada',
          'LU7DID/Y' => 'Argentina',
          '8Q' => 'Maldives',
          '4E' => 'Philippines',
          'LU1DZ/R' => 'Argentina',
          'JX;' => 'Jan Mayen',
          'JD1BMM' => 'Minami Torishima',
          'RE2' => 'Kaliningrad',
          'GB2HDG' => 'Wales',
          '4V' => 'Haiti',
          'RX0' => 'Asiatic Russia',
          'BH9N' => 'China',
          'CC0X' => 'San Felix I.',
          'GB100MER' => 'Isle of Man',
          'RQ8T' => 'Asiatic Russia',
          'WN4M' => 'United States',
          'MM0ZAL' => 'Shetland',
          'GB100MAS' => 'Scotland',
          'VE2ACP' => 'Canada',
          'R245GS' => 'European Russia',
          'LU7WW/W' => 'Argentina',
          'XF4' => 'Revilla Gigedo',
          'BZ9R' => 'China',
          'W4NTI' => 'United States',
          '9W4;' => 'West Malaysia',
          'LU7EGY/D' => 'Argentina',
          'VP6DX;' => 'Ducie I.',
          'JD1BME' => 'Minami Torishima',
          'VH0M' => 'Macquarie I.',
          'GB4HMD' => 'Wales',
          'LU8EHQ/D' => 'Argentina',
          'LU8EKC/D' => 'Argentina',
          'L20ARC/D' => 'Argentina',
          'YP' => 'Romania',
          'RS2' => 'Kaliningrad',
          'JS;' => 'Japan',
          'LU' => 'Argentina',
          'E5;' => 'South Cook Is.',
          'PR0R' => 'Fernando de Noronha',
          'N4OGW' => 'United States',
          'K8OSF' => 'United States',
          'HU' => 'El Salvador',
          'NP4' => 'Puerto Rico',
          'RT9W' => 'Asiatic Russia',
          '6P' => 'Pakistan',
          'RS9W' => 'Asiatic Russia',
          '7X' => 'Algeria',
          'AD8J' => 'United States',
          'RW9T' => 'Asiatic Russia',
          'GB0KTC' => 'Scotland',
          'VE2EDX' => 'Canada',
          'DK' => 'Germany',
          'RW0' => 'Asiatic Russia',
          '5A' => 'Libya',
          'AH6' => 'Hawaii',
          'VK9AA;' => 'Cocos-Keeling',
          'AO6' => 'Balearic Is.',
          'JW2FL' => 'Bear I.',
          'K4VU' => 'United States',
          'L40E/D' => 'Argentina',
          '2H' => 'Jersey',
          'YB' => 'Indonesia',
          'YJ;' => 'Vanuatu',
          'DQ' => 'Germany',
          'ZM8;' => 'Kermadec Is.',
          'LP' => 'Argentina',
          'UI9S' => 'Asiatic Russia',
          'VD2' => 'Canada',
          'SY9' => 'Crete',
          'N8NA' => 'United States',
          'EK;' => 'Armenia',
          'XD4' => 'Revilla Gigedo',
          'ST' => 'Sudan',
          'RX7' => 'Asiatic Russia',
          'AH8M' => 'United States',
          'RB8V' => 'Asiatic Russia',
          'LU2WV/O' => 'Argentina',
          'W4BCG' => 'United States',
          'VP8THU;' => 'South Sandwich',
          '3D2/c' => 'Conway Reef',
          'VB' => 'Canada',
          'EI' => 'Ireland',
          'YL;' => 'Latvia',
          'VE2MTB' => 'Canada',
          'ZK' => 'New Zealand',
          'ED3RKL' => 'South Shetland',
          'GW' => 'Wales',
          'UE9' => 'Asiatic Russia',
          'RF9I' => 'Asiatic Russia',
          'K4ZGB' => 'United States',
          'PP' => 'Brazil',
          'K7SV' => 'United States',
          'W5KI' => 'United States',
          'GM4SSA' => 'Shetland',
          'UA' => 'European Russia',
          'GB2MOP' => 'Wales',
          'W1RH' => 'United States',
          'RA9I' => 'Asiatic Russia',
          'EW;' => 'Belarus',
          'VM' => 'Australia',
          'T30;' => 'Western Kiribati',
          'HK' => 'Colombia',
          'FW;' => 'Wallis & Futuna Is.',
          'TO7R' => 'French Guiana',
          'GB2HRH' => 'Scotland',
          'GB0SSF' => 'Scotland',
          '3O' => 'China',
          'LU1DMA/E' => 'Argentina',
          'UY' => 'Ukraine',
          'RE9I' => 'Asiatic Russia',
          'LU4AAO/D' => 'Argentina',
          'VP8/o' => 'South Orkney',
          'GH' => 'Jersey',
          'BA9S' => 'China',
          'OP' => 'Belgium',
          'IQ0HO' => 'Sardinia',
          'K8OQL' => 'United States',
          'BG9N' => 'China',
          '8Z' => 'Saudi Arabia',
          'K2BA' => 'United States',
          'XO1' => 'Canada',
          'S2' => 'Bangladesh',
          'R1MV;' => 'Malyj Vysotskij',
          'UH0' => 'Asiatic Russia',
          'RA7' => 'Asiatic Russia',
          'LY' => 'Lithuania',
          'UF8' => 'Asiatic Russia',
          'HC8' => 'Galapagos Is.',
          'T2;' => 'Tuvalu',
          '3B7;' => 'Agalega & St. Brandon',
          'CT3' => 'Madeira Is.',
          'PQ0ZF' => 'Fernando de Noronha',
          'VH9Y' => 'Cocos-Keeling',
          'RI9W' => 'Asiatic Russia',
          'XN2' => 'Canada',
          'TO5T' => 'Martinique',
          'LW3HAQ/D' => 'Argentina',
          'VK9N' => 'Norfolk I.',
          'B9P' => 'China',
          'LW2DX/S' => 'Argentina',
          'RP0' => 'Asiatic Russia',
          'RW9' => 'Asiatic Russia',
          'GB0BWT' => 'Scotland',
          'WA8WV' => 'United States',
          'B3H' => 'China',
          'BY9R' => 'China',
          'UD7' => 'Asiatic Russia',
          'HJ0' => 'San Andres/Providencia',
          'RZ9I' => 'Asiatic Russia',
          'H9' => 'Panama',
          'U9T' => 'Asiatic Russia',
          'TO8MZ' => 'Mayotte',
          '4S' => 'Sri Lanka',
          'RY9I' => 'Asiatic Russia',
          'VU' => 'India',
          'RT8T' => 'Asiatic Russia',
          'PS0ZS' => 'St. Peter & St. Paul',
          'BL3K' => 'China',
          'BG3K' => 'China',
          'VA2DO' => 'Canada',
          'FR' => 'Reunion',
          'EG' => 'Spain',
          'HZ;' => 'Saudi Arabia',
          'NL7XM' => 'United States',
          'GB0HMT' => 'Wales',
          'ND9M' => 'United States',
          'YI;' => 'Iraq',
          'VE2CSI' => 'Canada',
          'RQ0' => 'Asiatic Russia',
          'RZ9S' => 'Asiatic Russia',
          'K1NTR' => 'United States',
          'LW9DCF/Y' => 'Argentina',
          'PT' => 'Brazil',
          '8V' => 'India',
          'LU8DCH/Q' => 'Argentina',
          'RV9M' => 'Asiatic Russia',
          '4Z;' => 'Israel',
          'RM4W' => 'European Russia',
          'ZR' => 'South Africa',
          'XZ' => 'Myanmar',
          'W7LR' => 'United States',
          'GB700BSB' => 'Scotland',
          'KH6DX' => 'United States',
          'ZL5' => 'Antarctica',
          'K5RR' => 'United States',
          'EA8' => 'Canary Is.',
          'R8' => 'Asiatic Russia',
          'IB9' => 'Sicily',
          'XJ2' => 'Canada',
          'RF8V' => 'Asiatic Russia',
          'VZ9W' => 'Willis I.',
          'CB' => 'Chile',
          'CD0' => 'Easter Island',
          'CT;' => 'Portugal',
          'VZ9X;' => 'Christmas I.',
          'GB2NBC' => 'Scotland',
          'GB4WXM/P' => 'Isle of Man',
          '5V' => 'Togo',
          'JK' => 'Japan',
          'KH2D' => 'United States',
          'W6XR' => 'United States',
          'NP3D' => 'United States',
          'W6UB' => 'United States',
          'RL9I' => 'Asiatic Russia',
          'CR9' => 'Madeira Is.',
          'IQ0AH' => 'Sardinia',
          'W0RLI' => 'United States',
          'UB8T' => 'Asiatic Russia',
          'VE2NN' => 'Canada',
          'KH7' => 'Hawaii',
          'LU7EO/D' => 'Argentina',
          'WD4K' => 'United States',
          '7Z' => 'Saudi Arabia',
          'ZW0R' => 'Fernando de Noronha',
          'K7VU' => 'United States',
          'GB75SCP' => 'Scotland',
          'LU1EJ/W' => 'Argentina',
          'GB2FBM' => 'Scotland',
          '9M6' => 'East Malaysia',
          'UE0' => 'Asiatic Russia',
          'KH0' => 'Mariana Is.',
          'VQ5;' => 'Turks & Caicos',
          'RV7' => 'Asiatic Russia',
          'D2' => 'Angola',
          'GB4NDG' => 'Wales',
          'VE2ENB' => 'Canada',
          'VL0' => 'Antarctica',
          'BZ3J' => 'China',
          'RM9I' => 'Asiatic Russia',
          'PR0ZS' => 'St. Peter & St. Paul',
          'UC9M' => 'Asiatic Russia',
          'RE9S' => 'Asiatic Russia',
          'PJ2' => 'Netherlands Antilles',
          'WH6ASW/M' => 'United States',
          '8F' => 'Indonesia',
          'AM6' => 'Balearic Is.',
          'GB0GNE' => 'Scotland',
          'KU1CW' => 'United States',
          'BH' => 'China',
          'KH6HHS' => 'United States',
          'K4AMC' => 'United States',
          'GP' => 'Guernsey',
          'AR' => 'Pakistan',
          'AW' => 'India',
          'RN9M' => 'Asiatic Russia',
          '3G0X' => 'San Felix I.',
          'N7NG' => 'United States',
          '3D2CY;' => 'Conway Reef',
          'ZF;' => 'Cayman Is.',
          'GB8RU' => 'Scotland',
          'BZ9O' => 'China',
          'YG' => 'Indonesia',
          'GB0CSC' => 'Northern Ireland',
          'OD;' => 'Lebanon',
          '6I' => 'Mexico',
          'RL8V' => 'Asiatic Russia',
          'GB2LSA' => 'Wales',
          '3F' => 'Panama',
          'ZZ0ZR;' => 'Fernando de Noronha',
          '9F' => 'Ethiopia',
          'LU1VZ/V' => 'Argentina',
          'UC2' => 'Kaliningrad',
          'GB2IOC' => 'Scotland',
          'WB2ORD' => 'United States',
          '7Q' => 'Malawi',
          'GB2GLS' => 'Wales',
          'OZ' => 'Denmark',
          'SS' => 'Egypt',
          'RO2' => 'Kaliningrad',
          'EF6' => 'Balearic Is.',
          'GB3GD' => 'Isle of Man',
          'AY3DR/D' => 'Argentina',
          'YV0' => 'Aves I.',
          'RJ9I' => 'Asiatic Russia',
          'CP' => 'Bolivia',
          'SF' => 'Sweden',
          'TO5BG' => 'Guadeloupe',
          'HV;' => 'Vatican City',
          'W7QF' => 'United States',
          'RT9I' => 'Asiatic Russia',
          'RF9' => 'Asiatic Russia',
          'TE9' => 'Cocos I.',
          'RF8' => 'Asiatic Russia',
          'RJ7' => 'Asiatic Russia',
          'P6' => 'North Korea',
          'N4TN' => 'United States',
          'BT3K' => 'China',
          'UV' => 'Ukraine',
          'T31' => 'Central Kiribati',
          'GB2FSM' => 'Scotland',
          '9A' => 'Croatia',
          '3G0' => 'Easter Island',
          'CO' => 'Cuba',
          'PW0S' => 'St. Peter & St. Paul',
          'GB0PSM' => 'Northern Ireland',
          '7S' => 'Sweden',
          'RF2' => 'Kaliningrad',
          '4U2ITU' => 'ITU HQ Geneva',
          'K0JJ' => 'United States',
          '9M50MS;' => 'East Malaysia',
          'ZM5' => 'Antarctica',
          'AK' => 'United States',
          'LU9DBK/X' => 'Argentina',
          'RJ8V' => 'Asiatic Russia',
          'RP9W' => 'Asiatic Russia',
          'RJ2' => 'Kaliningrad',
          '8J' => 'Japan',
          'GB75GD' => 'Scotland',
          'K5RC' => 'United States',
          'C6' => 'Bahamas',
          '4A4' => 'Revilla Gigedo',
          'RM9W' => 'Asiatic Russia',
          'BL9R' => 'China',
          'VK9C' => 'Cocos-Keeling',
          'ZX0R' => 'Fernando de Noronha',
          'D9' => 'South Korea',
          'EB8' => 'Canary Is.',
          'CE0X' => 'San Felix I.',
          'TO8RR' => 'Guadeloupe',
          'RE8T' => 'Asiatic Russia',
          'ZD7' => 'Saint Helena',
          'PW0ZT' => 'Trindade & Martim Vaz',
          'N6ZZ' => 'United States',
          'E51WL;' => 'North Cook Is.',
          'OY;' => 'Faroe Is.',
          'GB2MSL' => 'Scotland',
          'GB0MLM' => 'Scotland',
          'FP' => 'St. Pierre & Miquelon',
          'BZ' => 'China',
          'VJ9Y' => 'Cocos-Keeling',
          'WH4;' => 'Midway I.',
          'LU6UO/Q' => 'Argentina',
          'LU6UO/S' => 'Argentina',
          '9G;' => 'Ghana',
          'VK9CN' => 'Norfolk I.',
          'N4UW' => 'United States',
          'WD4OHD' => 'United States',
          'RW4W' => 'European Russia',
          'N1ZP' => 'United States',
          'RU8' => 'Asiatic Russia',
          'OU' => 'Denmark',
          'RC9S' => 'Asiatic Russia',
          'N4CVO' => 'United States',
          'K5ZDG' => 'United States',
          'UG9' => 'Asiatic Russia',
          'RC7' => 'Asiatic Russia',
          '6V' => 'Senegal',
          '3C0' => 'Annobon',
          'GB2IOG' => 'Scotland',
          'GB0GDS' => 'Scotland',
          'GB4SNF' => 'Wales',
          'LU9DPD/XA' => 'Argentina',
          '3Y;' => 'Bouvet',
          'J7' => 'Dominica',
          'RU2' => 'Kaliningrad',
          'K9OM' => 'United States',
          'HZ' => 'Saudi Arabia',
          'GB2WHO' => 'Wales'
        };
}

1;
