/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.openqa.selenium.server.DefaultRemoteCommand;
import org.openqa.selenium.server.FrameAddress;
import org.openqa.selenium.server.InjectionHelper;
import org.openqa.selenium.server.RemoteCommand;
import org.openqa.selenium.server.SeleniumCommandTimedOutException;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.SingleEntryAsyncQueue;
import org.openqa.selenium.server.SingleEntryAsyncQueueOverflow;

public class CommandQueue {
    private SingleEntryAsyncQueue commandHolder;
    private SingleEntryAsyncQueue commandResultHolder;
    private String sessionId;
    private String uniqueId;
    private FrameAddress frameAddress = null;
    private boolean resultExpected = false;
    private final Lock dataLock;
    private Condition resultArrived;
    private Condition commandReady;
    private ConcurrentHashMap<String, Boolean> cachedJsVariableNamesPointingAtThisWindow = new ConcurrentHashMap();
    private static int millisecondDelayBetweenOperations;

    public CommandQueue(String sessionId, FrameAddress frameAddress, Lock dataLock) {
        this.sessionId = sessionId;
        this.frameAddress = frameAddress;
        this.dataLock = dataLock;
        this.resultArrived = dataLock.newCondition();
        this.commandReady = dataLock.newCondition();
        this.commandHolder = new SingleEntryAsyncQueue("commandHolder/" + frameAddress, dataLock, this.commandReady);
        this.commandResultHolder = new SingleEntryAsyncQueue("resultHolder/" + frameAddress, dataLock, this.resultArrived);
        this.commandHolder.setTimeout(Integer.MAX_VALUE);
        millisecondDelayBetweenOperations = System.getProperty("selenium.slowMode") == null ? 0 : Integer.parseInt(System.getProperty("selenium.slowMode"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doCommand(String command, String field, String value) {
        this.dataLock.lock();
        try {
            this.resultExpected = true;
            this.doCommandWithoutWaitingForAResponse(command, field, value);
            String string = this.queueGetResult("doCommand");
            return string;
        }
        finally {
            this.resultExpected = false;
            this.dataLock.unlock();
        }
    }

    private String queueGetResult(String comment) {
        try {
            String result = (String)this.queueGet(comment, this.commandResultHolder, this.resultArrived);
            if (result == null) {
                result = "ERROR: got a null result";
            }
            return result;
        }
        catch (SeleniumCommandTimedOutException e) {
            return "ERROR: Command timed out";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCommandWithoutWaitingForAResponse(String command, String field, String value) {
        if (millisecondDelayBetweenOperations > 0) {
            SeleniumServer.log("    Slow mode in effect: sleep " + millisecondDelayBetweenOperations + " milliseconds...");
            try {
                Thread.sleep(millisecondDelayBetweenOperations);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            SeleniumServer.log("    ...done");
        }
        SingleEntryAsyncQueue singleEntryAsyncQueue = this.commandResultHolder;
        synchronized (singleEntryAsyncQueue) {
            if (this.commandResultHolder.isEmpty()) {
                this.commandResultHolder.clear();
            } else if (SeleniumServer.isProxyInjectionMode() && "OK".equals(this.commandResultHolder.peek())) {
                if (command.startsWith("wait")) {
                    if (SeleniumServer.isDebugMode()) {
                        SeleniumServer.log("Page load beat the wait command.  Leave the result to be picked up below");
                    }
                } else {
                    if (SeleniumServer.isDebugMode()) {
                        SeleniumServer.log("Apparently a page load result preceded the command; will ignore it...");
                    }
                    this.commandResultHolder.put(null);
                }
            } else {
                throw new RuntimeException("unexpected result " + this.commandResultHolder.peek());
            }
        }
        singleEntryAsyncQueue = this.commandHolder;
        synchronized (singleEntryAsyncQueue) {
            if (!this.commandHolder.isEmpty()) {
                throw new RuntimeException("unexpected command " + this.commandHolder.peek() + " in place before new command " + command + " could be added.");
            }
        }
        this.queuePut("commandHolder", this.commandHolder, new DefaultRemoteCommand(command, field, value, this.makeJavaScript()), this.commandReady);
    }

    private String makeJavaScript() {
        StringBuffer sb = new StringBuffer(InjectionHelper.restoreJsStateInitializer(this.sessionId, this.uniqueId));
        if (this.frameAddress != null && !this.frameAddress.getWindowName().equals("")) {
            sb.append("setSeleniumWindowName(unescape('");
            try {
                sb.append(URLEncoder.encode(this.frameAddress.getWindowName(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("URLEncoder failed: " + e);
            }
            sb.append("'));");
        }
        return sb.toString();
    }

    private Object queueGet(String caller, SingleEntryAsyncQueue q, Condition condition) {
        boolean clearedEarlierThread = false;
        String hdr = "\t" + this.getIdentification(caller) + " queueGet() ";
        if (SeleniumServer.isDebugMode()) {
            SeleniumServer.log(hdr + "called" + (clearedEarlierThread ? " (superceding other blocked thread)" : ""));
        }
        Object object = q.get();
        if (SeleniumServer.isDebugMode()) {
            SeleniumServer.log(hdr + "-> " + object);
        }
        return object;
    }

    private void queuePut(String caller, SingleEntryAsyncQueue q, Object thing, Condition condition) {
        String hdr = "\t" + this.getIdentification(caller) + " queuePut";
        if (SeleniumServer.isDebugMode()) {
            SeleniumServer.log(hdr + "(" + thing + ")");
        }
        try {
            q.put(thing);
        }
        catch (SingleEntryAsyncQueueOverflow e) {
            SeleniumServer.log(hdr + " caused " + e);
            throw e;
        }
        condition.signalAll();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("{ commandHolder=");
        sb.append(this.commandHolder.toString()).append(", ").append(" commandResultHolder=").append(this.commandResultHolder.toString()).append(" }");
        return sb.toString();
    }

    public RemoteCommand handleCommandResult(String commandResult) {
        if (commandResult == null) {
            throw new RuntimeException("null command result");
        }
        if (!this.resultExpected) {
            if (this.commandResultHolder.hasBlockedGetter()) {
                throw new RuntimeException("blocked getter for " + this + " but !resultExpected");
            }
            if (commandResult.equals("OK")) {
                if (SeleniumServer.isDebugMode()) {
                    SeleniumServer.log("Saw page load no one was waiting for.");
                }
                this.queuePutResult(commandResult);
            } else if (commandResult.startsWith("OK")) {
                throw new RuntimeException(this.getIdentification("commandResultHolder") + " unexpected value " + commandResult);
            }
        } else {
            this.queuePutResult(commandResult);
        }
        RemoteCommand sc = (RemoteCommand)this.queueGet("commandHolder", this.commandHolder, this.commandReady);
        return sc;
    }

    private void queuePutResult(String commandResult) {
        if (SeleniumServer.isProxyInjectionMode() && !this.commandResultHolder.isEmpty()) {
            this.commandHolder.clear();
            SeleniumServer.log("clearing out old window thread(s?) for " + this + "; replaced result with " + commandResult);
        }
        this.queuePut("commandResultHolder", this.commandResultHolder, commandResult, this.resultArrived);
    }

    private String getIdentification(String caller) {
        StringBuffer sb = new StringBuffer();
        if (this.frameAddress != null) {
            sb.append(this.frameAddress).append(' ');
        }
        sb.append(caller).append(' ').append(this.uniqueId);
        String s = sb.toString();
        if (s.endsWith("null") && SeleniumServer.isDebugMode()) {
            SeleniumServer.log("caller identification came in ending with null");
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardCommandResult() {
        this.dataLock.lock();
        try {
            this.queueGetResult("commandResultHolder discard");
        }
        finally {
            this.dataLock.unlock();
        }
    }

    public void endOfLife() {
        this.commandResultHolder.clear();
        this.commandResultHolder = null;
        this.commandHolder.clear();
        this.commandHolder = null;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public SingleEntryAsyncQueue getCommandResultHolder() {
        return this.commandResultHolder;
    }

    public void setResultExpected(boolean resultExpected) {
        this.resultExpected = resultExpected;
    }

    public static void setSpeed(int i) {
        millisecondDelayBetweenOperations = i;
    }

    public static int getSpeed() {
        return millisecondDelayBetweenOperations;
    }

    public boolean isWindowPointedToByJsVariable(String jsVariableName) {
        Boolean isPointingAtThisWindow = this.cachedJsVariableNamesPointingAtThisWindow.get(jsVariableName);
        if (isPointingAtThisWindow == null) {
            isPointingAtThisWindow = false;
            this.cachedJsVariableNamesPointingAtThisWindow.put(jsVariableName, isPointingAtThisWindow);
        }
        return isPointingAtThisWindow;
    }

    public boolean doBooleanCommand(String command, String arg1, String arg2) {
        boolean result;
        String booleanResult = this.doCommand(command, arg1, arg2);
        if ("OK,true".equals(booleanResult)) {
            result = true;
        } else if ("OK,false".equals(booleanResult)) {
            result = false;
        } else {
            throw new RuntimeException("unexpected return " + booleanResult + " from boolean command " + command);
        }
        SeleniumServer.log("doBooleancommand(" + command + "(" + arg1 + ", " + arg2 + ") -> " + result);
        return result;
    }

    public boolean matchesFrameAddress(String currentLocalFrameAddress, String newFrameAddressExpression) {
        return this.doBooleanCommand("getWhetherThisFrameMatchFrameExpression", currentLocalFrameAddress, newFrameAddressExpression);
    }

    public void addJsWindowNameVar(String jsWindowNameVar) {
        this.cachedJsVariableNamesPointingAtThisWindow.put(jsWindowNameVar, true);
    }
}

