
use Test::More tests => 2;

my $data = <<'END_DATA';
01005e2a2501003048770072080045000110000040000111cccc53a6443fef2a25017
d5a7d5a00fc7d37050000f40000010ff30f804100160000000022482ac57077827dd9
0000010ff30f804100076b65737472616c00067379736d6f6e000a4469736b4672656
52e2f6d000773000c70657263656e742d757365646640fef86073000b7061636b6574
2d74797065690000000073000b6465736372697074696f6e7300154469736b2053706
16365207374617469737469637373000d7570646174652d706572696f647100000000
000493e073000a62797465732d66726565710000002248a1800073000e726573756c7
42d6d6573736167657300077375636365737373000e6d65676162797465732d667265
6571000000000002248a
END_DATA

$data =~ s/\s+//g;    # remove all spaces

my $datagram = join "", map { chr hex } $data =~ /(..)/g;

use NetPacket::Ethernet;
use NetPacket::IP;
use NetPacket::UDP;

my $pkt = NetPacket::Ethernet->decode($datagram);

my $ip_pkt = NetPacket::IP->decode( $pkt->{data} );
$pkt = NetPacket::UDP->decode( $ip_pkt->{data} );

is $pkt->{cksum} => 32055, 'original checksum';

$pkt->checksum($ip_pkt);

is $pkt->{cksum} => 32055, 're-computed checksum';

