/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.io.IOException;
import java.util.Collection;
import org.apache.sis.internal.netcdf.DataType;
import org.apache.sis.internal.netcdf.NamedElement;
import org.apache.sis.math.Vector;
import org.apache.sis.storage.DataStoreException;

public abstract class Variable
extends NamedElement {
    public static final int MIN_DIMENSION = 2;

    protected Variable() {
    }

    @Override
    public abstract String getName();

    public abstract String getDescription();

    public abstract String getUnitsString();

    public abstract DataType getDataType();

    public final String getDataTypeName() {
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append(this.getDataType().name().toLowerCase());
        int[] nArray = this.getGridEnvelope();
        int n = nArray.length;
        while (--n >= 0) {
            stringBuilder.append('[').append((long)nArray[n] & 0xFFFFFFFFL).append(']');
        }
        return stringBuilder.toString();
    }

    public final boolean isCoverage(int n) {
        int n2 = 0;
        for (int n3 : this.getGridEnvelope()) {
            if (((long)n3 & 0xFFFFFFFFL) < (long)n) continue;
            ++n2;
        }
        if (n2 >= 2) {
            DataType dataType = this.getDataType();
            if (dataType.rasterDataType != 32) {
                return !this.isCoordinateSystemAxis();
            }
        }
        return false;
    }

    public abstract boolean isCoordinateSystemAxis();

    public abstract String[] getGridDimensionNames();

    public abstract int[] getGridEnvelope();

    public abstract Collection<String> getAttributeNames();

    public abstract Object[] getAttributeValues(String var1, boolean var2);

    public abstract Vector read() throws IOException, DataStoreException;

    public abstract Vector read(int[] var1, int[] var2, int[] var3) throws IOException, DataStoreException;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getName()).append(" : ").append((Object)this.getDataType());
        int[] nArray = this.getGridEnvelope();
        int n = nArray.length;
        while (--n >= 0) {
            stringBuilder.append('[').append((long)nArray[n] & 0xFFFFFFFFL).append(']');
        }
        return stringBuilder.toString();
    }
}

