use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME         => 'LNATION',
    DISTNAME     => 'LNATION',
    VERSION      => '0.01',
    ABSTRACT     => 'TMTOWTDI',
    AUTHOR       => 'LNATION <email@lnation.org>',
    LICENSE      => 'perl_5',
    macro        => { TARFLAGS => "--format=ustar -c -v -f" },
    DIR          => [qw(xs/slot xs/util xs/noop)],
    META_MERGE   => {
        'meta-spec' => { version => 2 },
        provides => {
            'slot' => {
                file    => 'lib/slot.pm',
                version => '0.01',
            },
            'util' => {
                file    => 'lib/util.pm',
                version => '0.01',
            },
            'noop' => {
                file    => 'lib/noop.pm',
                version => '0.01',
            },
        },
    },
);
