#!/usr/bin/perl

package eBay::API::XML::Call::GetFeedback::GetFeedbackRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetFeedbackRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetFeedback::GetFeedbackRequestType

=head1 DESCRIPTION

Retrieves summary feedback data if Transaction ID or Item ID are specified. Retrieves the accumulation of feedback left for the specified user by other users if a User ID is specified. Retrieves the accumulation of feedback left for the requesting user if no ID value
is entered. 
<br>
If a detail level value of ReturnAll is specified, the data for each 
feedback record is returned.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetFeedback::GetFeedbackRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::PaginationType;
use eBay::API::XML::DataType::UserIDType;
use eBay::API::XML::DataType::Enum::CommentTypeCodeType;


my @gaProperties = ( [ 'CommentType', 'ns:CommentTypeCodeType', '1'
	     ,'eBay::API::XML::DataType::Enum::CommentTypeCodeType', '' ]
	, [ 'FeedbackID', 'xs:string', '', '', '' ]
	, [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'Pagination', 'ns:PaginationType', ''
	     ,'eBay::API::XML::DataType::PaginationType', '1' ]
	, [ 'TransactionID', 'xs:string', '', '', '' ]
	, [ 'UserID', 'ns:UserIDType', ''
	     ,'eBay::API::XML::DataType::UserIDType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCommentType()

Returns feedback of a specified type (positive, negative, or neutral) 
in a FeedbackDetailArray. You can include two CommentTypes in your call
if you want to exclude the third type from your results. If no CommentType is specified, all of the feedback details will be returned.

  RequiredInput: No
#    Argument: reference to an array  
                      of 'ns:CommentTypeCodeType'

=cut

sub setCommentType {
  my $self = shift;
  $self->{'CommentType'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getCommentType()

#    Returns: reference to an array  
                      of 'ns:CommentTypeCodeType'

=cut

sub getCommentType {
  my $self = shift;
  return $self->_getDataTypeArray('CommentType');
}


=head2 setFeedbackID()

An ID that uniquely identifies a feedback record to be retrieved.
Used by the Feedback notification only.

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setFeedbackID {
  my $self = shift;
  $self->{'FeedbackID'} = shift
}

=head2 getFeedbackID()

#    Returns: 'xs:string'

=cut

sub getFeedbackID {
  my $self = shift;
  return $self->{'FeedbackID'};
}


=head2 setItemID()

Specifies the item ID whose feedback data is to be returned. If not specified, then the feedback for all items is returned. When an 
Item ID is specified, the maximum number of feedback records returned
is 100 and Pagination is ignored.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: No
#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}


=head2 setPagination()

Controls the pagination of the result set. Child elements, EntriesPerPage
and PageNumber, specify the maximum number of individual feedback records to return per call and which page of data to return. Only applicable if a
detail level value of ReturnAll is specified and the UserID or no ID (requester option) is specified. Feedback summary data is not paginated (but is still returned when
pagination is used).
<br>
Valid Pagination.EntriesPerPage input for GetFeedback is limited to 25,
50, 100, and 200. Other values will be treated as the closest valid input
less than the value specified or 25. If a value of zero or less or a
value greater than 200 is specified, the call fails with an error.
When pagination is used and feedback detail entries are being returned,
the summary data is returned after the last feedback detail entry on the
last page of data.

  RequiredInput: No
  OnlyTheseValues: 25, 50, 100, 200
#    Argument: 'ns:PaginationType'

=cut

sub setPagination {
  my $self = shift;
  $self->{'Pagination'} = shift
}

=head2 getPagination()

#    Returns: 'ns:PaginationType'

=cut

sub getPagination {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Pagination'
		,'eBay::API::XML::DataType::PaginationType');
}


=head2 setTransactionID()

Transaction ID whose feedback record should be returned. If not specified, 
then the feedback for all transactions will be returned. When a Transaction ID is specified, since only one record is returned, 
Pagination is ignored.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, transaction IDs are usually 9 to 12 digits.)

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setTransactionID {
  my $self = shift;
  $self->{'TransactionID'} = shift
}

=head2 getTransactionID()

#    Returns: 'xs:string'

=cut

sub getTransactionID {
  my $self = shift;
  return $self->{'TransactionID'};
}


=head2 setUserID()

Specifies the user whose feedback data is to be returned. If not specified, then the feedback returned is for the requesting user.

  RequiredInput: No
#    Argument: 'ns:UserIDType'

=cut

sub setUserID {
  my $self = shift;
  $self->{'UserID'} = shift
}

=head2 getUserID()

#    Returns: 'ns:UserIDType'

=cut

sub getUserID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'UserID'
		,'eBay::API::XML::DataType::UserIDType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
