# Generated by default/object.tt
package Paws::MediaConvert::H264Settings;
  use Moose;
  has AdaptiveQuantization => (is => 'ro', isa => 'Str', request_name => 'adaptiveQuantization', traits => ['NameInRequest']);
  has Bitrate => (is => 'ro', isa => 'Int', request_name => 'bitrate', traits => ['NameInRequest']);
  has CodecLevel => (is => 'ro', isa => 'Str', request_name => 'codecLevel', traits => ['NameInRequest']);
  has CodecProfile => (is => 'ro', isa => 'Str', request_name => 'codecProfile', traits => ['NameInRequest']);
  has DynamicSubGop => (is => 'ro', isa => 'Str', request_name => 'dynamicSubGop', traits => ['NameInRequest']);
  has EntropyEncoding => (is => 'ro', isa => 'Str', request_name => 'entropyEncoding', traits => ['NameInRequest']);
  has FieldEncoding => (is => 'ro', isa => 'Str', request_name => 'fieldEncoding', traits => ['NameInRequest']);
  has FlickerAdaptiveQuantization => (is => 'ro', isa => 'Str', request_name => 'flickerAdaptiveQuantization', traits => ['NameInRequest']);
  has FramerateControl => (is => 'ro', isa => 'Str', request_name => 'framerateControl', traits => ['NameInRequest']);
  has FramerateConversionAlgorithm => (is => 'ro', isa => 'Str', request_name => 'framerateConversionAlgorithm', traits => ['NameInRequest']);
  has FramerateDenominator => (is => 'ro', isa => 'Int', request_name => 'framerateDenominator', traits => ['NameInRequest']);
  has FramerateNumerator => (is => 'ro', isa => 'Int', request_name => 'framerateNumerator', traits => ['NameInRequest']);
  has GopBReference => (is => 'ro', isa => 'Str', request_name => 'gopBReference', traits => ['NameInRequest']);
  has GopClosedCadence => (is => 'ro', isa => 'Int', request_name => 'gopClosedCadence', traits => ['NameInRequest']);
  has GopSize => (is => 'ro', isa => 'Num', request_name => 'gopSize', traits => ['NameInRequest']);
  has GopSizeUnits => (is => 'ro', isa => 'Str', request_name => 'gopSizeUnits', traits => ['NameInRequest']);
  has HrdBufferInitialFillPercentage => (is => 'ro', isa => 'Int', request_name => 'hrdBufferInitialFillPercentage', traits => ['NameInRequest']);
  has HrdBufferSize => (is => 'ro', isa => 'Int', request_name => 'hrdBufferSize', traits => ['NameInRequest']);
  has InterlaceMode => (is => 'ro', isa => 'Str', request_name => 'interlaceMode', traits => ['NameInRequest']);
  has MaxBitrate => (is => 'ro', isa => 'Int', request_name => 'maxBitrate', traits => ['NameInRequest']);
  has MinIInterval => (is => 'ro', isa => 'Int', request_name => 'minIInterval', traits => ['NameInRequest']);
  has NumberBFramesBetweenReferenceFrames => (is => 'ro', isa => 'Int', request_name => 'numberBFramesBetweenReferenceFrames', traits => ['NameInRequest']);
  has NumberReferenceFrames => (is => 'ro', isa => 'Int', request_name => 'numberReferenceFrames', traits => ['NameInRequest']);
  has ParControl => (is => 'ro', isa => 'Str', request_name => 'parControl', traits => ['NameInRequest']);
  has ParDenominator => (is => 'ro', isa => 'Int', request_name => 'parDenominator', traits => ['NameInRequest']);
  has ParNumerator => (is => 'ro', isa => 'Int', request_name => 'parNumerator', traits => ['NameInRequest']);
  has QualityTuningLevel => (is => 'ro', isa => 'Str', request_name => 'qualityTuningLevel', traits => ['NameInRequest']);
  has QvbrSettings => (is => 'ro', isa => 'Paws::MediaConvert::H264QvbrSettings', request_name => 'qvbrSettings', traits => ['NameInRequest']);
  has RateControlMode => (is => 'ro', isa => 'Str', request_name => 'rateControlMode', traits => ['NameInRequest']);
  has RepeatPps => (is => 'ro', isa => 'Str', request_name => 'repeatPps', traits => ['NameInRequest']);
  has ScanTypeConversionMode => (is => 'ro', isa => 'Str', request_name => 'scanTypeConversionMode', traits => ['NameInRequest']);
  has SceneChangeDetect => (is => 'ro', isa => 'Str', request_name => 'sceneChangeDetect', traits => ['NameInRequest']);
  has Slices => (is => 'ro', isa => 'Int', request_name => 'slices', traits => ['NameInRequest']);
  has SlowPal => (is => 'ro', isa => 'Str', request_name => 'slowPal', traits => ['NameInRequest']);
  has Softness => (is => 'ro', isa => 'Int', request_name => 'softness', traits => ['NameInRequest']);
  has SpatialAdaptiveQuantization => (is => 'ro', isa => 'Str', request_name => 'spatialAdaptiveQuantization', traits => ['NameInRequest']);
  has Syntax => (is => 'ro', isa => 'Str', request_name => 'syntax', traits => ['NameInRequest']);
  has Telecine => (is => 'ro', isa => 'Str', request_name => 'telecine', traits => ['NameInRequest']);
  has TemporalAdaptiveQuantization => (is => 'ro', isa => 'Str', request_name => 'temporalAdaptiveQuantization', traits => ['NameInRequest']);
  has UnregisteredSeiTimecode => (is => 'ro', isa => 'Str', request_name => 'unregisteredSeiTimecode', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConvert::H264Settings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConvert::H264Settings object:

  $service_obj->Method(Att1 => { AdaptiveQuantization => $value, ..., UnregisteredSeiTimecode => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConvert::H264Settings object:

  $result = $service_obj->Method(...);
  $result->Att1->AdaptiveQuantization

=head1 DESCRIPTION

Required when you set (Codec) under
(VideoDescription)E<gt>(CodecSettings) to the value H_264.

=head1 ATTRIBUTES


=head2 AdaptiveQuantization => Str

Keep the default value, Auto (AUTO), for this setting to have
MediaConvert automatically apply the best types of quantization for
your video content. When you want to apply your quantization settings
manually, you must set H264AdaptiveQuantization to a value other than
Auto (AUTO). Use this setting to specify the strength of any adaptive
quantization filters that you enable. If you don't want MediaConvert to
do any adaptive quantization in this transcode, set Adaptive
quantization (H264AdaptiveQuantization) to Off (OFF). Related settings:
The value that you choose here applies to the following settings:
H264FlickerAdaptiveQuantization, H264SpatialAdaptiveQuantization, and
H264TemporalAdaptiveQuantization.


=head2 Bitrate => Int

Specify the average bitrate in bits per second. Required for VBR and
CBR. For MS Smooth outputs, bitrates must be unique when rounded down
to the nearest multiple of 1000.


=head2 CodecLevel => Str

Specify an H.264 level that is consistent with your output video
settings. If you aren't sure what level to specify, choose Auto (AUTO).


=head2 CodecProfile => Str

H.264 Profile. High 4:2:2 and 10-bit profiles are only available with
the AVC-I License.


=head2 DynamicSubGop => Str

Choose Adaptive to improve subjective video quality for high-motion
content. This will cause the service to use fewer B-frames (which infer
information based on other frames) for high-motion portions of the
video and more B-frames for low-motion portions. The maximum number of
B-frames is limited by the value you provide for the setting B frames
between reference frames (numberBFramesBetweenReferenceFrames).


=head2 EntropyEncoding => Str

Entropy encoding mode. Use CABAC (must be in Main or High profile) or
CAVLC.


=head2 FieldEncoding => Str

Keep the default value, PAFF, to have MediaConvert use PAFF encoding
for interlaced outputs. Choose Force field (FORCE_FIELD) to disable
PAFF encoding and create separate interlaced fields.


=head2 FlickerAdaptiveQuantization => Str

Only use this setting when you change the default value, AUTO, for the
setting H264AdaptiveQuantization. When you keep all defaults, excluding
H264AdaptiveQuantization and all other adaptive quantization from your
JSON job specification, MediaConvert automatically applies the best
types of quantization for your video content. When you set
H264AdaptiveQuantization to a value other than AUTO, the default value
for H264FlickerAdaptiveQuantization is Disabled (DISABLED). Change this
value to Enabled (ENABLED) to reduce I-frame pop. I-frame pop appears
as a visual flicker that can arise when the encoder saves bits by
copying some macroblocks many times from frame to frame, and then
refreshes them at the I-frame. When you enable this setting, the
encoder updates these macroblocks slightly more often to smooth out the
flicker. To manually enable or disable H264FlickerAdaptiveQuantization,
you must set Adaptive quantization (H264AdaptiveQuantization) to a
value other than AUTO.


=head2 FramerateControl => Str

If you are using the console, use the Framerate setting to specify the
frame rate for this output. If you want to keep the same frame rate as
the input video, choose Follow source. If you want to do frame rate
conversion, choose a frame rate from the dropdown list or choose
Custom. The framerates shown in the dropdown list are decimal
approximations of fractions. If you choose Custom, specify your frame
rate as a fraction. If you are creating your transcoding job
specification as a JSON file without the console, use FramerateControl
to specify which value the service uses for the frame rate for this
output. Choose INITIALIZE_FROM_SOURCE if you want the service to use
the frame rate from the input. Choose SPECIFIED if you want the service
to use the frame rate you specify in the settings FramerateNumerator
and FramerateDenominator.


=head2 FramerateConversionAlgorithm => Str

Choose the method that you want MediaConvert to use when increasing or
decreasing the frame rate. We recommend using drop duplicate
(DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to
30 fps. For numerically complex conversions, you can use interpolate
(INTERPOLATE) to avoid stutter. This results in a smooth picture, but
might introduce undesirable video artifacts. For complex frame rate
conversions, especially if your source video has already been converted
from its original cadence, use FrameFormer (FRAMEFORMER) to do
motion-compensated interpolation. FrameFormer chooses the best
conversion method frame by frame. Note that using FrameFormer increases
the transcoding time and incurs a significant add-on cost.


=head2 FramerateDenominator => Int

When you use the API for transcode jobs that use frame rate conversion,
specify the frame rate as a fraction. For example, 24000 / 1001 =
23.976 fps. Use FramerateDenominator to specify the denominator of this
fraction. In this example, use 1001 for the value of
FramerateDenominator. When you use the console for transcode jobs that
use frame rate conversion, provide the value as a decimal number for
Framerate. In this example, specify 23.976.


=head2 FramerateNumerator => Int

When you use the API for transcode jobs that use frame rate conversion,
specify the frame rate as a fraction. For example, 24000 / 1001 =
23.976 fps. Use FramerateNumerator to specify the numerator of this
fraction. In this example, use 24000 for the value of
FramerateNumerator. When you use the console for transcode jobs that
use frame rate conversion, provide the value as a decimal number for
Framerate. In this example, specify 23.976.


=head2 GopBReference => Str

If enable, use reference B frames for GOP structures that have B frames
E<gt> 1.


=head2 GopClosedCadence => Int

Frequency of closed GOPs. In streaming applications, it is recommended
that this be set to 1 so a decoder joining mid-stream will receive an
IDR frame as quickly as possible. Setting this value to 0 will break
output segmenting.


=head2 GopSize => Num

GOP Length (keyframe interval) in frames or seconds. Must be greater
than zero.


=head2 GopSizeUnits => Str

Indicates if the GOP Size in H264 is specified in frames or seconds. If
seconds the system will convert the GOP Size into a frame count at run
time.


=head2 HrdBufferInitialFillPercentage => Int

Percentage of the buffer that should initially be filled (HRD buffer
model).


=head2 HrdBufferSize => Int

Size of buffer (HRD buffer model) in bits. For example, enter five
megabits as 5000000.


=head2 InterlaceMode => Str

Choose the scan line type for the output. Keep the default value,
Progressive (PROGRESSIVE) to create a progressive output, regardless of
the scan type of your input. Use Top field first (TOP_FIELD) or Bottom
field first (BOTTOM_FIELD) to create an output that's interlaced with
the same field polarity throughout. Use Follow, default top
(FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to
produce outputs with the same field polarity as the source. For jobs
that have multiple inputs, the output field polarity might change over
the course of the output. Follow behavior depends on the input scan
type. If the source is interlaced, the output will be interlaced with
the same polarity as the source. If the source is progressive, the
output will be interlaced with top field bottom field first, depending
on which of the Follow options you choose.


=head2 MaxBitrate => Int

Maximum bitrate in bits/second. For example, enter five megabits per
second as 5000000. Required when Rate control mode is QVBR.


=head2 MinIInterval => Int

Enforces separation between repeated (cadence) I-frames and I-frames
inserted by Scene Change Detection. If a scene change I-frame is within
I-interval frames of a cadence I-frame, the GOP is shrunk and/or
stretched to the scene change I-frame. GOP stretch requires enabling
lookahead as well as setting I-interval. The normal cadence resumes for
the next GOP. This setting is only used when Scene Change Detect is
enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1


=head2 NumberBFramesBetweenReferenceFrames => Int

Number of B-frames between reference frames.


=head2 NumberReferenceFrames => Int

Number of reference frames to use. The encoder may use more than
requested if using B-frames and/or interlaced encoding.


=head2 ParControl => Str

Optional. Specify how the service determines the pixel aspect ratio
(PAR) for this output. The default behavior, Follow source
(INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your
output. To specify a different PAR in the console, choose any value
other than Follow source. To specify a different PAR by editing the
JSON job specification, choose SPECIFIED. When you choose SPECIFIED for
this setting, you must also specify values for the parNumerator and
parDenominator settings.


=head2 ParDenominator => Int

Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On
the console, this corresponds to any value other than Follow source.
When you specify an output pixel aspect ratio (PAR) that is different
from your input video PAR, provide your output PAR as a ratio. For
example, for D1/DV NTSC widescreen, you would specify the ratio 40:33.
In this example, the value for parDenominator is 33.


=head2 ParNumerator => Int

Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On
the console, this corresponds to any value other than Follow source.
When you specify an output pixel aspect ratio (PAR) that is different
from your input video PAR, provide your output PAR as a ratio. For
example, for D1/DV NTSC widescreen, you would specify the ratio 40:33.
In this example, the value for parNumerator is 40.


=head2 QualityTuningLevel => Str

Optional. Use Quality tuning level (qualityTuningLevel) to choose how
you want to trade off encoding speed for output video quality. The
default behavior is faster, lower quality, single-pass encoding.


=head2 QvbrSettings => L<Paws::MediaConvert::H264QvbrSettings>

Settings for quality-defined variable bitrate encoding with the H.264
codec. Required when you set Rate control mode to QVBR. Not valid when
you set Rate control mode to a value other than QVBR, or when you don't
define Rate control mode.


=head2 RateControlMode => Str

Use this setting to specify whether this output has a variable bitrate
(VBR), constant bitrate (CBR) or quality-defined variable bitrate
(QVBR).


=head2 RepeatPps => Str

Places a PPS header on each encoded picture, even if repeated.


=head2 ScanTypeConversionMode => Str

Use this setting for interlaced outputs, when your output frame rate is
half of your input frame rate. In this situation, choose Optimized
interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced
output. In this case, each progressive frame from the input corresponds
to an interlaced field in the output. Keep the default value, Basic
interlacing (INTERLACED), for all other output frame rates. With basic
interlacing, MediaConvert performs any frame rate conversion first and
then interlaces the frames. When you choose Optimized interlacing and
you set your output frame rate to a value that isn't suitable for
optimized interlacing, MediaConvert automatically falls back to basic
interlacing. Required settings: To use optimized interlacing, you must
set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use
optimized interlacing for hard telecine outputs. You must also set
Interlace mode (interlaceMode) to a value other than Progressive
(PROGRESSIVE).


=head2 SceneChangeDetect => Str

Enable this setting to insert I-frames at scene changes that the
service automatically detects. This improves video quality and is
enabled by default. If this output uses QVBR, choose Transition
detection (TRANSITION_DETECTION) for further video quality improvement.
For more information about QVBR, see
https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.


=head2 Slices => Int

Number of slices per picture. Must be less than or equal to the number
of macroblock rows for progressive pictures, and less than or equal to
half the number of macroblock rows for interlaced pictures.


=head2 SlowPal => Str

Ignore this setting unless your input frame rate is 23.976 or 24 frames
per second (fps). Enable slow PAL to create a 25 fps output. When you
enable slow PAL, MediaConvert relabels the video frames to 25 fps and
resamples your audio to keep it synchronized with the video. Note that
enabling this setting will slightly reduce the duration of your video.
Required settings: You must also set Framerate to 25. In your JSON job
specification, set (framerateControl) to (SPECIFIED),
(framerateNumerator) to 25 and (framerateDenominator) to 1.


=head2 Softness => Int

Ignore this setting unless you need to comply with a specification that
requires a specific value. If you don't have a specification
requirement, we recommend that you adjust the softness of your output
by using a lower value for the setting Sharpness (sharpness) or by
enabling a noise reducer filter (noiseReducerFilter). The Softness
(softness) setting specifies the quantization matrices that the encoder
uses. Keep the default value, 0, for flat quantization. Choose the
value 1 or 16 to use the default JVT softening quantization matricies
from the H.264 specification. Choose a value from 17 to 128 to use
planar interpolation. Increasing values from 17 to 128 result in
increasing reduction of high-frequency data. The value 128 results in
the softest video.


=head2 SpatialAdaptiveQuantization => Str

Only use this setting when you change the default value, Auto (AUTO),
for the setting H264AdaptiveQuantization. When you keep all defaults,
excluding H264AdaptiveQuantization and all other adaptive quantization
from your JSON job specification, MediaConvert automatically applies
the best types of quantization for your video content. When you set
H264AdaptiveQuantization to a value other than AUTO, the default value
for H264SpatialAdaptiveQuantization is Enabled (ENABLED). Keep this
default value to adjust quantization within each frame based on spatial
variation of content complexity. When you enable this feature, the
encoder uses fewer bits on areas that can sustain more distortion with
no noticeable visual degradation and uses more bits on areas where any
small distortion will be noticeable. For example, complex textured
blocks are encoded with fewer bits and smooth textured blocks are
encoded with more bits. Enabling this feature will almost always
improve your video quality. Note, though, that this feature doesn't
take into account where the viewer's attention is likely to be. If
viewers are likely to be focusing their attention on a part of the
screen with a lot of complex texture, you might choose to set
H264SpatialAdaptiveQuantization to Disabled (DISABLED). Related
setting: When you enable spatial adaptive quantization, set the value
for Adaptive quantization (H264AdaptiveQuantization) depending on your
content. For homogeneous content, such as cartoons and video games, set
it to Low. For content with a wider variety of textures, set it to High
or Higher. To manually enable or disable
H264SpatialAdaptiveQuantization, you must set Adaptive quantization
(H264AdaptiveQuantization) to a value other than AUTO.


=head2 Syntax => Str

Produces a bitstream compliant with SMPTE RP-2027.


=head2 Telecine => Str

When you do frame rate conversion from 23.976 frames per second (fps)
to 29.97 fps, and your output scan type is interlaced, you can
optionally enable hard or soft telecine to create a smoother picture.
Hard telecine (HARD) produces a 29.97i output. Soft telecine (SOFT)
produces an output with a 23.976 output that signals to the video
player device to do the conversion during play back. When you keep the
default value, None (NONE), MediaConvert does a standard frame rate
conversion to 29.97 without doing anything with the field polarity to
create a smoother picture.


=head2 TemporalAdaptiveQuantization => Str

Only use this setting when you change the default value, AUTO, for the
setting H264AdaptiveQuantization. When you keep all defaults, excluding
H264AdaptiveQuantization and all other adaptive quantization from your
JSON job specification, MediaConvert automatically applies the best
types of quantization for your video content. When you set
H264AdaptiveQuantization to a value other than AUTO, the default value
for H264TemporalAdaptiveQuantization is Enabled (ENABLED). Keep this
default value to adjust quantization within each frame based on
temporal variation of content complexity. When you enable this feature,
the encoder uses fewer bits on areas of the frame that aren't moving
and uses more bits on complex objects with sharp edges that move a lot.
For example, this feature improves the readability of text tickers on
newscasts and scoreboards on sports matches. Enabling this feature will
almost always improve your video quality. Note, though, that this
feature doesn't take into account where the viewer's attention is
likely to be. If viewers are likely to be focusing their attention on a
part of the screen that doesn't have moving objects with sharp edges,
such as sports athletes' faces, you might choose to set
H264TemporalAdaptiveQuantization to Disabled (DISABLED). Related
setting: When you enable temporal quantization, adjust the strength of
the filter with the setting Adaptive quantization
(adaptiveQuantization). To manually enable or disable
H264TemporalAdaptiveQuantization, you must set Adaptive quantization
(H264AdaptiveQuantization) to a value other than AUTO.


=head2 UnregisteredSeiTimecode => Str

Inserts timecode for each frame as 4 bytes of an unregistered SEI
message.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConvert>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

