package LNATION;
use strict;
use warnings;
our $VERSION = '0.02';

1;

__END__

=head1 NAME

LNATION - XS accelerated Perl utilities

=head1 DESCRIPTION

This distribution provides three independent XS modules:

=over 4

=item * L<slot> - Global reactive state slots with optional watchers

=item * L<util> - Functional programming utilities with XS acceleration

=item * L<noop> - No-operation functions for benchmarking and testing

=back

=head1 MODULES

=head2 slot

    use slot qw(app_name debug);
    
    app_name("MyApp");
    print app_name();

Global reactive state slots shared across packages with optional
watchers for reactive programming. All slot:: functions are optimized
to custom ops when called with constant names.

See L<slot> for full documentation.

=head2 util

    use util qw(is_array is_hash memo pipeline trim ...);

Fast functional programming utilities including type predicates,
memoization, pipelines, lazy evaluation, and more. Many functions
use custom ops for compile-time optimization.

See L<util> for full documentation.

=head2 noop

    use noop;
    
    noop::pp();   # Pure Perl no-op
    noop::xs();   # XS no-op

Minimal no-operation functions for benchmarking overhead and
baseline performance testing.

See L<noop> for full documentation.

=head1 AUTHOR

LNATION <email@lnation.org>

=head1 LICENSE

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut
