// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/ChargedFinalState.hh"

namespace Rivet {


  /// @brief Average multiplcity at a range of energies
  class JADE_1983_I190818 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(JADE_1983_I190818);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      const ChargedFinalState cfs;
      declare(cfs, "CFS");
      book(_mult, 1, 1, 1);
      for (int en : _mult.binning().edges<0>()) {
        if (isCompatibleWithSqrtS(double(en))) {
          _sqs = en; break;
        }
      }
      raiseBeamErrorIf(_sqs < 0);
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& cfs = apply<FinalState>(event, "CFS");
      MSG_DEBUG("Total charged multiplicity = " << cfs.size());
      _mult->fill(_sqs, cfs.size());
    }

    /// @}

  private:

    // Histogram
    BinnedProfilePtr<int> _mult;
    int _sqs = -1;

  };

  RIVET_DECLARE_PLUGIN(JADE_1983_I190818);
}
