/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.text.similarity.IntersectionResult;
import org.apache.commons.text.similarity.IntersectionSimilarity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IntersectionSimilarityTest {
    private static <T> void assertIntersection(IntersectionSimilarity<T> similarity, CharSequence cs1, CharSequence cs2, int sizeA, int sizeB, int intersection) {
        IntersectionResult result = similarity.apply(cs1, cs2);
        Assertions.assertEquals((int)sizeA, (int)result.getSizeA(), (String)"Size A error");
        Assertions.assertEquals((int)sizeB, (int)result.getSizeB(), (String)"Size B error");
        Assertions.assertEquals((int)intersection, (int)result.getIntersection(), (String)"Intersection error");
    }

    private static List<Integer> toBigramList(CharSequence sequence) {
        int length = sequence.length();
        ArrayList<Integer> list = new ArrayList<Integer>(length);
        if (length > 1) {
            char ch2 = sequence.charAt(0);
            for (int i = 1; i < length; ++i) {
                char ch1 = ch2;
                ch2 = sequence.charAt(i);
                list.add(ch1 << 16 | ch2);
            }
        }
        return list;
    }

    private static Set<Integer> toBigramSet(CharSequence sequence) {
        int length = sequence.length();
        HashSet<Integer> set = new HashSet<Integer>(length);
        if (length > 1) {
            char ch2 = sequence.charAt(0);
            for (int i = 1; i < length; ++i) {
                char ch1 = ch2;
                ch2 = sequence.charAt(i);
                set.add(ch1 << 16 | ch2);
            }
        }
        return set;
    }

    private static List<Character> toCharacterList(CharSequence sequence) {
        int length = sequence.length();
        ArrayList<Character> list = new ArrayList<Character>(length);
        for (int i = 0; i < length; ++i) {
            list.add(Character.valueOf(sequence.charAt(i)));
        }
        return list;
    }

    private static Set<Character> toCharacterSet(CharSequence sequence) {
        int length = sequence.length();
        HashSet<Character> set = new HashSet<Character>(length);
        for (int i = 0; i < length; ++i) {
            set.add(Character.valueOf(sequence.charAt(i)));
        }
        return set;
    }

    private static int toF1ScorePercent(IntersectionResult result) {
        double value = 2.0 * (double)result.getIntersection() / (double)(result.getSizeA() + result.getSizeB());
        return (int)Math.round(value * 100.0);
    }

    @Test
    public void testApplyNullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new IntersectionSimilarity(cs -> new HashSet<CharSequence>(Collections.singletonList(cs))).apply(null, null));
    }

    @Test
    public void testApplyNullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new IntersectionSimilarity(cs -> new HashSet<CharSequence>(Collections.singletonList(cs))).apply(null, (CharSequence)"right"));
    }

    @Test
    public void testApplyStringNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new IntersectionSimilarity(cs -> new HashSet<CharSequence>(Collections.singletonList(cs))).apply((CharSequence)"left", null));
    }

    @Test
    public void testConstructorWithNullConverterThrows() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new IntersectionSimilarity(null));
    }

    @Test
    public void testF1ScoreUsingListWordBigrams() {
        Pattern pattern = Pattern.compile("\\s+");
        Function<CharSequence, Collection> converter = cs -> {
            ArrayList<Integer> set = new ArrayList<Integer>();
            for (String word : pattern.split((CharSequence)cs)) {
                if (word.length() <= 1) continue;
                char ch2 = Character.toUpperCase(word.charAt(0));
                for (int i = 1; i < word.length(); ++i) {
                    char ch1 = ch2;
                    ch2 = Character.toUpperCase(word.charAt(i));
                    set.add(ch1 << 16 | ch2);
                }
            }
            return set;
        };
        IntersectionSimilarity similarity = new IntersectionSimilarity(converter);
        String search1 = "Web Database Applications";
        String search2 = "PHP Web Applications";
        String search3 = "Web Aplications";
        String bookTitle = "Web Database Applications with PHP & MySQL";
        Assertions.assertEquals((int)82, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"Web Database Applications")));
        Assertions.assertEquals((int)68, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"PHP Web Applications")));
        Assertions.assertEquals((int)59, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"Web Aplications")));
        bookTitle = "Creating Database Web Applications with PHP and ASP";
        Assertions.assertEquals((int)71, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"Web Database Applications")));
        Assertions.assertEquals((int)59, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"PHP Web Applications")));
        Assertions.assertEquals((int)50, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"Web Aplications")));
        bookTitle = "Building Database Applications on the Web Using PHP3";
        Assertions.assertEquals((int)70, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"Web Database Applications")));
        Assertions.assertEquals((int)58, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"PHP Web Applications")));
        Assertions.assertEquals((int)49, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"Web Aplications")));
        bookTitle = "Building Web Database Applications with Visual Studio 6";
        Assertions.assertEquals((int)67, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"Web Database Applications")));
        Assertions.assertEquals((int)47, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"PHP Web Applications")));
        Assertions.assertEquals((int)46, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"Web Aplications")));
        bookTitle = "Web Application Development With PHP";
        Assertions.assertEquals((int)51, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"Web Database Applications")));
        Assertions.assertEquals((int)67, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"PHP Web Applications")));
        Assertions.assertEquals((int)56, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"Web Aplications")));
        bookTitle = "WebRAD: Building Database Applications on the Web with Visual FoxPro and Web Connection";
        Assertions.assertEquals((int)49, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"Web Database Applications")));
        Assertions.assertEquals((int)34, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"PHP Web Applications")));
        Assertions.assertEquals((int)32, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"Web Aplications")));
        bookTitle = "Structural Assessment: The Role of Large and Full-Scale Testing";
        Assertions.assertEquals((int)12, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"Web Database Applications")));
        Assertions.assertEquals((int)7, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"PHP Web Applications")));
        Assertions.assertEquals((int)7, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"Web Aplications")));
        bookTitle = "How to Find a Scholarship Online";
        Assertions.assertEquals((int)10, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"Web Database Applications")));
        Assertions.assertEquals((int)11, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"PHP Web Applications")));
        Assertions.assertEquals((int)12, (int)IntersectionSimilarityTest.toF1ScorePercent(similarity.apply((CharSequence)bookTitle, (CharSequence)"Web Aplications")));
    }

    @Test
    public void testIntersectionUsingListBigrams() {
        IntersectionSimilarity similarity = new IntersectionSimilarity(IntersectionSimilarityTest::toBigramList);
        IntersectionSimilarityTest.assertIntersection(similarity, "", "", 0, 0, 0);
        IntersectionSimilarityTest.assertIntersection(similarity, "a", "", 0, 0, 0);
        IntersectionSimilarityTest.assertIntersection(similarity, "a", "a", 0, 0, 0);
        IntersectionSimilarityTest.assertIntersection(similarity, "a", "b", 0, 0, 0);
        IntersectionSimilarityTest.assertIntersection(similarity, "aa", "ab", 1, 1, 0);
        IntersectionSimilarityTest.assertIntersection(similarity, "ab", "ab", 1, 1, 1);
        IntersectionSimilarityTest.assertIntersection(similarity, "aaba", "abaa", 3, 3, 3);
        IntersectionSimilarityTest.assertIntersection(similarity, "aaaa", "aa", 3, 1, 1);
        IntersectionSimilarityTest.assertIntersection(similarity, "aa", "aaaa", 1, 3, 1);
        IntersectionSimilarityTest.assertIntersection(similarity, "aaaa", "aaa", 3, 2, 2);
        IntersectionSimilarityTest.assertIntersection(similarity, "aabab", "ababa", 4, 4, 3);
        IntersectionSimilarityTest.assertIntersection(similarity, "the same", "the same", 7, 7, 7);
        IntersectionSimilarityTest.assertIntersection(similarity, "abcdefghijklm", "ab_defg ijklm", 12, 12, 8);
    }

    @Test
    public void testIntersectionUsingListCharacter() {
        IntersectionSimilarity similarity = new IntersectionSimilarity(IntersectionSimilarityTest::toCharacterList);
        IntersectionSimilarityTest.assertIntersection(similarity, "", "", 0, 0, 0);
        IntersectionSimilarityTest.assertIntersection(similarity, "a", "", 1, 0, 0);
        IntersectionSimilarityTest.assertIntersection(similarity, "a", "a", 1, 1, 1);
        IntersectionSimilarityTest.assertIntersection(similarity, "a", "b", 1, 1, 0);
        IntersectionSimilarityTest.assertIntersection(similarity, "aa", "ab", 2, 2, 1);
        IntersectionSimilarityTest.assertIntersection(similarity, "ab", "ab", 2, 2, 2);
        IntersectionSimilarityTest.assertIntersection(similarity, "aaba", "abaa", 4, 4, 4);
        IntersectionSimilarityTest.assertIntersection(similarity, "aaaa", "aa", 4, 2, 2);
        IntersectionSimilarityTest.assertIntersection(similarity, "aa", "aaaa", 2, 4, 2);
        IntersectionSimilarityTest.assertIntersection(similarity, "aaaa", "aaa", 4, 3, 3);
        IntersectionSimilarityTest.assertIntersection(similarity, "aabab", "ababa", 5, 5, 5);
        IntersectionSimilarityTest.assertIntersection(similarity, "the same", "the same", 8, 8, 8);
        IntersectionSimilarityTest.assertIntersection(similarity, "abcdefghijklm", "ab_defg ijklm", 13, 13, 11);
    }

    @Test
    public void testIntersectionUsingSetBigrams() {
        IntersectionSimilarity similarity = new IntersectionSimilarity(IntersectionSimilarityTest::toBigramSet);
        IntersectionSimilarityTest.assertIntersection(similarity, "", "", 0, 0, 0);
        IntersectionSimilarityTest.assertIntersection(similarity, "a", "", 0, 0, 0);
        IntersectionSimilarityTest.assertIntersection(similarity, "a", "a", 0, 0, 0);
        IntersectionSimilarityTest.assertIntersection(similarity, "a", "b", 0, 0, 0);
        IntersectionSimilarityTest.assertIntersection(similarity, "aa", "ab", 1, 1, 0);
        IntersectionSimilarityTest.assertIntersection(similarity, "ab", "ab", 1, 1, 1);
        IntersectionSimilarityTest.assertIntersection(similarity, "aaba", "abaa", 3, 3, 3);
        IntersectionSimilarityTest.assertIntersection(similarity, "aaaa", "aa", 1, 1, 1);
        IntersectionSimilarityTest.assertIntersection(similarity, "aa", "aaaa", 1, 1, 1);
        IntersectionSimilarityTest.assertIntersection(similarity, "aaaa", "aaa", 1, 1, 1);
        IntersectionSimilarityTest.assertIntersection(similarity, "aabab", "ababa", 3, 2, 2);
        IntersectionSimilarityTest.assertIntersection(similarity, "the same", "the same", 7, 7, 7);
        IntersectionSimilarityTest.assertIntersection(similarity, "abcdefghijklm", "ab_defg ijklm", 12, 12, 8);
    }

    @Test
    public void testIntersectionUsingSetCharacter() {
        IntersectionSimilarity similarity = new IntersectionSimilarity(IntersectionSimilarityTest::toCharacterSet);
        IntersectionSimilarityTest.assertIntersection(similarity, "", "", 0, 0, 0);
        IntersectionSimilarityTest.assertIntersection(similarity, "a", "", 1, 0, 0);
        IntersectionSimilarityTest.assertIntersection(similarity, "a", "a", 1, 1, 1);
        IntersectionSimilarityTest.assertIntersection(similarity, "a", "b", 1, 1, 0);
        IntersectionSimilarityTest.assertIntersection(similarity, "aa", "ab", 1, 2, 1);
        IntersectionSimilarityTest.assertIntersection(similarity, "ab", "ab", 2, 2, 2);
        IntersectionSimilarityTest.assertIntersection(similarity, "aaba", "abaa", 2, 2, 2);
        IntersectionSimilarityTest.assertIntersection(similarity, "aaaa", "aa", 1, 1, 1);
        IntersectionSimilarityTest.assertIntersection(similarity, "aa", "aaaa", 1, 1, 1);
        IntersectionSimilarityTest.assertIntersection(similarity, "aaaa", "aaa", 1, 1, 1);
        IntersectionSimilarityTest.assertIntersection(similarity, "aabab", "ababa", 2, 2, 2);
        IntersectionSimilarityTest.assertIntersection(similarity, "the same", "the same", 7, 7, 7);
        IntersectionSimilarityTest.assertIntersection(similarity, "abcdefghijklm", "ab_defg ijklm", 13, 13, 11);
    }

    @Test
    public void testIntersectionUsingSetCharacterListCharacter() {
        HashMap<String, Collection<Character>> converter = new HashMap<String, Collection<Character>>();
        String sequence1 = "aabbccdd";
        String sequence2 = "aaaaaabbbfffff";
        converter.put("aabbccdd", IntersectionSimilarityTest.toCharacterSet("aabbccdd"));
        converter.put("aaaaaabbbfffff", IntersectionSimilarityTest.toCharacterList("aaaaaabbbfffff"));
        IntersectionSimilarity similarity = new IntersectionSimilarity(converter::get);
        IntersectionSimilarityTest.assertIntersection(similarity, "aabbccdd", "aaaaaabbbfffff", 4, "aaaaaabbbfffff".length(), 2);
        IntersectionSimilarityTest.assertIntersection(similarity, "aaaaaabbbfffff", "aabbccdd", "aaaaaabbbfffff".length(), 4, 2);
    }
}

