/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.events;

import org.gradle.internal.logging.events.PromptOutputEvent;

public class IntQuestionPromptEvent
extends PromptOutputEvent {
    private final String question;
    private final int minValue;
    private final int defaultValue;

    public IntQuestionPromptEvent(long timestamp, String question, int minValue, int defaultValue) {
        super(timestamp);
        this.question = question;
        this.minValue = minValue;
        this.defaultValue = defaultValue;
    }

    public String getQuestion() {
        return this.question;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getPrompt() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.question);
        builder.append(" (min: ");
        builder.append(this.minValue);
        builder.append(", default: ");
        builder.append(this.defaultValue);
        builder.append("): ");
        return builder.toString();
    }

    public PromptOutputEvent.PromptResult<Integer> convert(String text) {
        if (text.isEmpty()) {
            return PromptOutputEvent.PromptResult.response(this.defaultValue);
        }
        String trimmed = text.trim();
        try {
            int result = Integer.parseInt(trimmed);
            if (result >= this.minValue) {
                return PromptOutputEvent.PromptResult.response(result);
            }
            return PromptOutputEvent.PromptResult.newPrompt("Please enter an integer value >= " + this.minValue + " (default: " + this.defaultValue + "): ");
        }
        catch (NumberFormatException e) {
            return PromptOutputEvent.PromptResult.newPrompt("Please enter an integer value (min: " + this.minValue + ", default: " + this.defaultValue + "): ");
        }
    }
}

