/* bam_consensus_tab.h -- constant lookup tables for the consensus algorithm

    Copyright (C) 2024 Genome Research Ltd.
    Author: James Bonfield <jkb@sanger.ac.uk>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notices and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.  */



/*
 * Tables created with this code:
 *
 *    for (int i = 0; i <= 100; i++)
 *        q2p[i] = pow(10, -i/10.0);
 *
 *    for (int i = 0; i < 255; i++)
 *        mqual_pow_1m[i] = pow(10, -(i*.9)/10.0);
 *
 *    // unknown mqual
 *    mqual_pow_1m[255] = mqual_pow_1m[10];
 *
 * We use static tables to avoid initialising from within a thread and having
 * to use pthread_once calls or locks.
 */

static double q2p[101] = {
    1,
    0.7943282347242814900312,
    0.6309573444801932495807,
    0.5011872336272722439077,
    0.3981071705534972027252,
    0.3162277660168379411765,
    0.251188643150958013095,
    0.1995262314968879735488,
    0.1584893192461113431424,
    0.1258925411794167281698,
    0.1000000000000000055511,
    0.07943282347242813790089,
    0.06309573444801933050918,
    0.05011872336272722022743,
    0.0398107170553497341503,
    0.03162277660168379134209,
    0.0251188643150957943706,
    0.01995262314968879874266,
    0.01584893192461113431424,
    0.01258925411794167489865,
    0.01000000000000000020817,
    0.007943282347242813790089,
    0.006309573444801930275361,
    0.005011872336272724624828,
    0.00398107170553497341503,
    0.003162277660168379394418,
    0.00251188643150957943706,
    0.001995262314968878920168,
    0.001584893192461114081945,
    0.001258925411794167489865,
    0.001000000000000000020817,
    0.0007943282347242813139568,
    0.000630957344480192984168,
    0.000501187233627272527535,
    0.0003981071705534973523451,
    0.0003162277660168379394418,
    0.000251188643150957954548,
    0.0001995262314968878757538,
    0.0001584893192461114190366,
    0.0001258925411794167435655,
    0.0001000000000000000047922,
    7.943282347242822084236e-05,
    6.309573444801929299579e-05,
    5.011872336272725139824e-05,
    3.981071705534969457693e-05,
    3.162277660168379529943e-05,
    2.511886431509582188223e-05,
    1.995262314968878622013e-05,
    1.584893192461114122603e-05,
    1.258925411794166114284e-05,
    1.000000000000000081803e-05,
    7.943282347242821745423e-06,
    6.309573444801929638392e-06,
    5.011872336272724970418e-06,
    3.981071705534969118879e-06,
    3.16227766016837919113e-06,
    2.511886431509582272927e-06,
    1.995262314968878706716e-06,
    1.584893192461114080251e-06,
    1.258925411794166114284e-06,
    9.999999999999999547481e-07,
    7.943282347242821957181e-07,
    6.309573444801929638392e-07,
    5.011872336272724970418e-07,
    3.981071705534969224758e-07,
    3.16227766016837919113e-07,
    2.511886431509582272927e-07,
    1.995262314968878706716e-07,
    1.584893192461114080251e-07,
    1.258925411794166167223e-07,
    9.999999999999999547481e-08,
    7.943282347242821957181e-08,
    6.309573444801929638392e-08,
    5.011872336272724970418e-08,
    3.981071705534968960061e-08,
    3.16227766016837919113e-08,
    2.511886431509582074403e-08,
    1.995262314968878640542e-08,
    1.584893192461114278775e-08,
    1.258925411794166101049e-08,
    1.000000000000000020923e-08,
    7.943282347242821957181e-09,
    6.309573444801942873282e-09,
    5.011872336272714713378e-09,
    3.981071705534968960061e-09,
    3.162277660168379522002e-09,
    2.511886431509581991685e-09,
    1.995262314968882776445e-09,
    1.584893192461110928693e-09,
    1.258925411794166266485e-09,
    1.000000000000000062282e-09,
    7.943282347242821750386e-10,
    6.309573444801942459691e-10,
    5.011872336272714299788e-10,
    3.981071705534969373651e-10,
    3.162277660168379522002e-10,
    2.511886431509581991685e-10,
    1.995262314968882828143e-10,
    1.584893192461110876994e-10,
    1.258925411794166163087e-10,
    1.000000000000000036432e-10,
};

// 1-mqual_pow() in old code, for improved numerical stability
static double mqual_pow_1m[256] = {
    1,
    0.8128305161640992926309,
    0.6606934480075959958967,
    0.5370317963702526675718,
    0.4365158322401659907186,
    0.3548133892335754713265,
    0.2884031503126605611165,
    0.2344228815319921999105,
    0.1905460717963247396778,
    0.1548816618912481624104,
    0.1258925411794167281698,
    0.1023292992280754182266,
    0.08317637711026708291495,
    0.06760829753919815610086,
    0.05495408738576245538665,
    0.04466835921509629964143,
    0.03630780547701013827311,
    0.02951209226666385437854,
    0.02398832919019491111134,
    0.01949844599758044499938,
    0.01584893192461113431424,
    0.01288249551693133529429,
    0.01047128548050899575494,
    0.008511380382023767468547,
    0.00691830970918936270786,
    0.005623413251903490971129,
    0.004570881896148746952047,
    0.003715352290971724036339,
    0.003019951720402016138306,
    0.002454708915685028559894,
    0.001995262314968878920168,
    0.001621810097358929734015,
    0.001318256738556407509436,
    0.00107151930523760705212,
    0.0008709635899560805045311,
    0.0007079457843841380172353,
    0.0005754399373371571826952,
    0.0004677351412871976464071,
    0.0003801893963205608571385,
    0.0003090295432513588810494,
    0.000251188643150957954548,
    0.0002041737944669529570153,
    0.0001659586907437559614043,
    0.0001348962882591653344218,
    0.0001096478196143185149941,
    8.912509381337458780163e-05,
    7.244359600749906166837e-05,
    5.888436553555884004144e-05,
    4.786300923226380360119e-05,
    3.890451449942804569787e-05,
    3.162277660168379529943e-05,
    2.570395782768864487763e-05,
    2.08929613085403650377e-05,
    1.698243652461742535286e-05,
    1.380384264602883870635e-05,
    1.122018454301963009219e-05,
    9.12010839355909637069e-06,
    7.4131024130091619111e-06,
    6.025595860743568906272e-06,
    4.897788193684456601576e-06,
    3.981071705534969118879e-06,
    3.235936569296280900269e-06,
    2.630267991895381665999e-06,
    2.137962089502232643917e-06,
    1.737800828749376344341e-06,
    1.412537544622755410526e-06,
    1.148153621496884006233e-06,
    9.332543007969905085716e-07,
    7.585775750291835657364e-07,
    6.165950018614821914709e-07,
    5.011872336272724970418e-07,
    4.073802778041130314065e-07,
    3.311311214825914277902e-07,
    2.691534803926913785907e-07,
    2.187761623949547394535e-07,
    1.778279410038922689111e-07,
    1.445439770745924971116e-07,
    1.174897554939530334775e-07,
    9.549925860214348974899e-08,
    7.762471166286895849136e-08,
    6.309573444801929638392e-08,
    5.128613839913637503499e-08,
    4.16869383470335490351e-08,
    3.388441561392020662586e-08,
    2.754228703338163286523e-08,
    2.238721138568337809819e-08,
    1.819700858609982555977e-08,
    1.479108388168207227345e-08,
    1.202264434617413033159e-08,
    9.772372209558071266503e-09,
    7.943282347242821957181e-09,
    6.456542290346535928048e-09,
    5.24807460249773376564e-09,
    4.265795188015916487035e-09,
    3.467368504525309635778e-09,
    2.818382931264449340833e-09,
    2.290867652767769951333e-09,
    1.862087136662865556652e-09,
    1.513561248436207274854e-09,
    1.230268770812381144727e-09,
    1.000000000000000062282e-09,
    8.128305161640995407296e-10,
    6.606934480075964084586e-10,
    5.370317963702532108845e-10,
    4.365158322401647369267e-10,
    3.548133892335760548437e-10,
    2.884031503126599798765e-10,
    2.344228815319927378371e-10,
    1.905460717963244402743e-10,
    1.548816618912479562773e-10,
    1.258925411794166163087e-10,
    1.02329299228075369211e-10,
    8.317637711026709156723e-11,
    6.760829753919819170079e-11,
    5.495408738576225939084e-11,
    4.466835921509634552494e-11,
    3.630780547701002543629e-11,
    2.951209226666390341713e-11,
    2.398832919019485080354e-11,
    1.949844599758041441061e-11,
    1.584893192461110747747e-11,
    1.288249551693132197657e-11,
    1.047128548050898584033e-11,
    8.51138038202375965546e-12,
    6.91830970918936233983e-12,
    5.623413251903490440623e-12,
    4.57088189614875156966e-12,
    3.715352290971727542496e-12,
    3.019951720402019283787e-12,
    2.454708915685023331606e-12,
    1.995262314968882747364e-12,
    1.621810097358926597075e-12,
    1.318256738556410024608e-12,
    1.071519305237604909644e-12,
    8.709635899560796872095e-13,
    7.079457843841373745556e-13,
    5.754399373371566766933e-13,
    4.677351412871980722804e-13,
    3.801893963205612663477e-13,
    3.090295432513579532869e-13,
    2.51188643150958201188e-13,
    2.041737944669523298356e-13,
    1.659586907437563152957e-13,
    1.348962882591650639904e-13,
    1.096478196143187403169e-13,
    8.912509381337441182976e-14,
    7.244359600749891290308e-14,
    5.888436553555884286751e-14,
    4.786300923226360800767e-14,
    3.890451449942804581978e-14,
    3.16227766016837956946e-14,
    2.570395782768864629488e-14,
    2.089296130854032171409e-14,
    1.698243652461738958356e-14,
    1.380384264602886572573e-14,
    1.122018454301965225833e-14,
    9.120108393559077808785e-15,
    7.41310241300916204595e-15,
    6.025595860743543893752e-15,
    4.89778819368447641006e-15,
    3.981071705534969483965e-15,
    3.235936569296280957472e-15,
    2.630267991895370861998e-15,
    2.137962089502223792495e-15,
    1.737800828749376410924e-15,
    1.412537544622755396163e-15,
    1.148153621496879413097e-15,
    9.332543007969886808596e-16,
    7.585775750291820704083e-16,
    6.16595001861483473253e-16,
    5.011872336272714560554e-16,
    4.073802778041122139769e-16,
    3.311311214825907705381e-16,
    2.691534803926902844989e-16,
    2.187761623949551861095e-16,
    1.778279410038922824675e-16,
    1.445439770745928054799e-16,
    1.174897554939525594999e-16,
    9.549925860214290967941e-17,
    7.762471166286926954938e-17,
    6.309573444801942677654e-17,
    5.128613839913658731403e-17,
    4.168693834703329160522e-17,
    3.388441561392006804112e-17,
    2.754228703338174659151e-17,
    2.238721138568347026224e-17,
    1.819700858609975128112e-17,
    1.479108388168200988561e-17,
    1.202264434617408187405e-17,
    9.772372209558151065569e-18,
    7.943282347242789549202e-18,
    6.456542290346536037433e-18,
    5.248074602497711949195e-18,
    4.265795188015916572965e-18,
    3.467368504525309543749e-18,
    2.818382931264449082965e-18,
    2.290867652767769905885e-18,
    1.862087136662865733356e-18,
    1.513561248436207116967e-18,
    1.23026877081238105721e-18,
    1.000000000000000071542e-18,
    8.128305161640995455277e-19,
    6.606934480075964466392e-19,
    5.370317963702488787674e-19,
    4.365158322401665295207e-19,
    3.548133892335760584637e-19,
    2.884031503126611635381e-19,
    2.34422881531990820968e-19,
    1.905460717963236485458e-19,
    1.548816618912485883656e-19,
    1.258925411794171323845e-19,
    1.023292992280749404264e-19,
    8.317637711026674950186e-20,
    6.760829753919791474259e-20,
    5.495408738576271148274e-20,
    4.466835921509616402226e-20,
    3.630780547701002879554e-20,
    2.951209226666377752396e-20,
    2.398832919019485115055e-20,
    1.949844599758041376456e-20,
    1.584893192461110764057e-20,
    1.288249551693132282107e-20,
    1.047128548050898507945e-20,
    8.511380382023758413114e-21,
    6.918309709189362127144e-21,
    5.623413251903490551057e-21,
    4.570881896148751551493e-21,
    3.715352290971727550311e-21,
    3.019951720401994286355e-21,
    2.454708915685033408223e-21,
    1.995262314968882699746e-21,
    1.621810097358933154088e-21,
    1.318256738556399319099e-21,
    1.071519305237600521042e-21,
    8.709635899560831951348e-22,
    7.079457843841402028864e-22,
    5.754399373371542511646e-22,
    4.677351412871961918683e-22,
    3.801893963205596893242e-22,
    3.090295432513604871118e-22,
    2.511886431509571816516e-22,
    2.041737944669523411158e-22,
    1.659586907437556324857e-22,
    1.348962882591650593016e-22,
    1.096478196143182849571e-22,
    8.912509381337440520642e-23,
    7.244359600749890755459e-23,
    5.888436553555883904271e-23,
    4.786300923226380123649e-23,
    3.890451449942804910175e-23,
    3.162277660168379311786e-23,
    2.570395782768864541526e-23,
    2.089296130854040880659e-23,
    1.698243652461732031437e-23,
    1.380384264602886699006e-23,
    0.1258925411794167281698,
};
