"use strict";
/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] = self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] || []).push([["vendors-node_modules_jupyterlab_filebrowser_lib_index_js"],{

/***/ "../node_modules/@jupyterlab/filebrowser/lib/browser.js":
/*!**************************************************************!*\
  !*** ../node_modules/@jupyterlab/filebrowser/lib/browser.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   FileBrowser: () => (/* binding */ FileBrowser)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/coreutils */ \"webpack/sharing/consume/default/@jupyterlab/coreutils/@jupyterlab/coreutils\");\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/services */ \"webpack/sharing/consume/default/@jupyterlab/services/@jupyterlab/services\");\n/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @lumino/widgets */ \"webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets\");\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_5__);\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ \"webpack/sharing/consume/default/react/react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);\n/* harmony import */ var _crumbs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./crumbs */ \"../node_modules/@jupyterlab/filebrowser/lib/crumbs.js\");\n/* harmony import */ var _listing__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./listing */ \"../node_modules/@jupyterlab/filebrowser/lib/listing.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n\n\n\n\n/**\n * The class name added to file browsers.\n */\nconst FILE_BROWSER_CLASS = 'jp-FileBrowser';\n/**\n * The class name added to file browser panel (gather filter, breadcrumbs and listing).\n */\nconst FILE_BROWSER_PANEL_CLASS = 'jp-FileBrowser-Panel';\n/**\n * The class name added to the filebrowser crumbs node.\n */\nconst CRUMBS_CLASS = 'jp-FileBrowser-crumbs';\n/**\n * The class name added to the filebrowser toolbar node.\n */\nconst TOOLBAR_CLASS = 'jp-FileBrowser-toolbar';\n/**\n * The class name added to the filebrowser filter toolbar node.\n */\nconst FILTER_TOOLBAR_CLASS = 'jp-FileBrowser-filterToolbar';\n/**\n * The class name added to the filebrowser listing node.\n */\nconst LISTING_CLASS = 'jp-FileBrowser-listing';\n/**\n * The class name added to the filebrowser filterbox node.\n */\nconst FILTERBOX_CLASS = 'jp-FileBrowser-filterBox';\n/**\n * A widget which hosts a file browser.\n *\n * The widget uses the Jupyter Contents API to retrieve contents,\n * and presents itself as a flat list of files and directories with\n * breadcrumbs.\n */\nclass FileBrowser extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.SidePanel {\n    /**\n     * Construct a new file browser.\n     *\n     * @param options - The file browser options.\n     */\n    constructor(options) {\n        var _a;\n        super({ content: new _lumino_widgets__WEBPACK_IMPORTED_MODULE_5__.Panel(), translator: options.translator });\n        this._directoryPending = null;\n        this._filePending = null;\n        this._fileFilterRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.createRef)();\n        this._allowSingleClick = false;\n        this._showFileCheckboxes = false;\n        this._showFileFilter = false;\n        this._showFileSizeColumn = false;\n        this._showHiddenFiles = false;\n        this._showLastModifiedColumn = true;\n        this._sortNotebooksFirst = false;\n        this.addClass(FILE_BROWSER_CLASS);\n        this.toolbar.addClass(TOOLBAR_CLASS);\n        this.id = options.id;\n        const translator = (this.translator = (_a = options.translator) !== null && _a !== void 0 ? _a : _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3__.nullTranslator);\n        const model = (this.model = options.model);\n        const renderer = options.renderer;\n        model.connectionFailure.connect(this._onConnectionFailure, this);\n        this._manager = model.manager;\n        this.toolbar.node.setAttribute('aria-label', this._trans.__('file browser'));\n        // File browser widgets container\n        this.mainPanel = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_5__.Panel();\n        this.mainPanel.addClass(FILE_BROWSER_PANEL_CLASS);\n        this.mainPanel.title.label = this._trans.__('File Browser');\n        this.crumbs = new _crumbs__WEBPACK_IMPORTED_MODULE_7__.BreadCrumbs({ model, translator });\n        this.crumbs.addClass(CRUMBS_CLASS);\n        // The filter toolbar appears immediately below the breadcrumbs and above the directory listing.\n        const searcher = (0,_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.FilenameSearcher)({\n            updateFilter: (filterFn, query) => {\n                this.model.setFilter(value => {\n                    return filterFn(value.name.toLowerCase());\n                });\n            },\n            useFuzzyFilter: this.model.useFuzzyFilter,\n            placeholder: this._trans.__('Filter files by name'),\n            forceRefresh: false,\n            showIcon: false,\n            inputRef: this._fileFilterRef,\n            filterSettingsChanged: this.model.filterSettingsChanged\n        });\n        searcher.addClass(FILTERBOX_CLASS);\n        this.filterToolbar = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.Toolbar();\n        this.filterToolbar.addClass(FILTER_TOOLBAR_CLASS);\n        this.filterToolbar.addItem('fileNameSearcher', searcher);\n        this.filterToolbar.setHidden(!this.showFileFilter);\n        this.listing = this.createDirListing({\n            model,\n            renderer,\n            translator,\n            state: options.state\n        });\n        this.listing.addClass(LISTING_CLASS);\n        this.mainPanel.addWidget(this.crumbs);\n        this.mainPanel.addWidget(this.filterToolbar);\n        this.mainPanel.addWidget(this.listing);\n        this.addWidget(this.mainPanel);\n        if (options.restore !== false) {\n            void model.restore(this.id);\n        }\n        // restore listing regardless of the restore option\n        void this.listing.restore(this.id);\n    }\n    /**\n     * Whether to show active file in file browser\n     */\n    get navigateToCurrentDirectory() {\n        return this._navigateToCurrentDirectory;\n    }\n    set navigateToCurrentDirectory(value) {\n        this._navigateToCurrentDirectory = value;\n    }\n    /**\n     * Whether to show the last modified column\n     */\n    get showLastModifiedColumn() {\n        return this._showLastModifiedColumn;\n    }\n    set showLastModifiedColumn(value) {\n        if (this.listing.setColumnVisibility) {\n            this.listing.setColumnVisibility('last_modified', value);\n            this._showLastModifiedColumn = value;\n        }\n        else {\n            console.warn('Listing does not support toggling column visibility');\n        }\n    }\n    /**\n     * Whether to show the full path in the breadcrumbs\n     */\n    get showFullPath() {\n        return this.crumbs.fullPath;\n    }\n    set showFullPath(value) {\n        this.crumbs.fullPath = value;\n    }\n    /**\n     * Whether to show the file size column\n     */\n    get showFileSizeColumn() {\n        return this._showFileSizeColumn;\n    }\n    set showFileSizeColumn(value) {\n        if (this.listing.setColumnVisibility) {\n            this.listing.setColumnVisibility('file_size', value);\n            this._showFileSizeColumn = value;\n        }\n        else {\n            console.warn('Listing does not support toggling column visibility');\n        }\n    }\n    /**\n     * Whether to show hidden files\n     */\n    get showHiddenFiles() {\n        return this._showHiddenFiles;\n    }\n    set showHiddenFiles(value) {\n        this.model.showHiddenFiles(value);\n        this._showHiddenFiles = value;\n    }\n    /**\n     * Whether to show checkboxes next to files and folders\n     */\n    get showFileCheckboxes() {\n        return this._showFileCheckboxes;\n    }\n    set showFileCheckboxes(value) {\n        if (this.listing.setColumnVisibility) {\n            this.listing.setColumnVisibility('is_selected', value);\n            this._showFileCheckboxes = value;\n        }\n        else {\n            console.warn('Listing does not support toggling column visibility');\n        }\n    }\n    /**\n     * Whether to show a text box to filter files by name.\n     */\n    get showFileFilter() {\n        return this._showFileFilter;\n    }\n    set showFileFilter(value) {\n        var _a;\n        // If the old value was true and the new value is false, clear the filter\n        const oldValue = this.showFileFilter;\n        if (oldValue && !value) {\n            // Clear the search box input\n            if (this._fileFilterRef.current) {\n                this._fileFilterRef.current.value = '';\n            }\n            // Set a filter that doesn't exclude anything.\n            this.model.setFilter(value => {\n                return {};\n            });\n            this.model.refresh().catch(console.warn);\n        }\n        this._showFileFilter = value;\n        // Update widget visibility\n        this.filterToolbar.setHidden(!this.showFileFilter);\n        if (this.showFileFilter) {\n            (_a = this._fileFilterRef.current) === null || _a === void 0 ? void 0 : _a.focus();\n        }\n    }\n    /**\n     * Whether to sort notebooks above other files\n     */\n    get sortNotebooksFirst() {\n        return this._sortNotebooksFirst;\n    }\n    set sortNotebooksFirst(value) {\n        if (this.listing.setNotebooksFirstSorting) {\n            this.listing.setNotebooksFirstSorting(value);\n            this._sortNotebooksFirst = value;\n        }\n        else {\n            console.warn('Listing does not support sorting notebooks first');\n        }\n    }\n    /**\n     * Whether to allow single click files and directories\n     */\n    get singleClickNavigation() {\n        return this._allowSingleClick;\n    }\n    set singleClickNavigation(value) {\n        if (this.listing.setAllowSingleClickNavigation) {\n            this.listing.setAllowSingleClickNavigation(value);\n            this._allowSingleClick = value;\n        }\n        else {\n            console.warn('Listing does not support single click navigation');\n        }\n    }\n    /**\n     * Create an iterator over the listing's selected items.\n     *\n     * @returns A new iterator over the listing's selected items.\n     */\n    selectedItems() {\n        return this.listing.selectedItems();\n    }\n    /**\n     * Select an item by name.\n     *\n     * @param name - The name of the item to select.\n     */\n    async selectItemByName(name) {\n        await this.listing.selectItemByName(name);\n    }\n    clearSelectedItems() {\n        this.listing.clearSelectedItems();\n    }\n    /**\n     * Rename the first currently selected item.\n     *\n     * @returns A promise that resolves with the new name of the item.\n     */\n    rename() {\n        return this.listing.rename();\n    }\n    /**\n     * Cut the selected items.\n     */\n    cut() {\n        this.listing.cut();\n    }\n    /**\n     * Copy the selected items.\n     */\n    copy() {\n        this.listing.copy();\n    }\n    /**\n     * Paste the items from the clipboard.\n     *\n     * @returns A promise that resolves when the operation is complete.\n     */\n    paste() {\n        return this.listing.paste();\n    }\n    async _createNew(options) {\n        // normalize the path if the file is created from a custom drive\n        if (options.path) {\n            const localPath = this._manager.services.contents.localPath(options.path);\n            options.path = this._toDrivePath(this.model.driveName, localPath);\n        }\n        try {\n            const model = await this._manager.newUntitled(options);\n            await this.listing.selectItemByName(model.name, true);\n            await this.rename();\n            return model;\n        }\n        catch (err) {\n            void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans.__('Error'), err);\n            throw err;\n        }\n    }\n    /**\n     * Create a new directory\n     */\n    async createNewDirectory() {\n        if (this._directoryPending) {\n            return this._directoryPending;\n        }\n        this._directoryPending = this._createNew({\n            path: this.model.path,\n            type: 'directory'\n        });\n        try {\n            return await this._directoryPending;\n        }\n        finally {\n            this._directoryPending = null;\n        }\n    }\n    /**\n     * Create a new file\n     */\n    async createNewFile(options) {\n        if (this._filePending) {\n            return this._filePending;\n        }\n        this._filePending = this._createNew({\n            path: this.model.path,\n            type: 'file',\n            ext: options.ext\n        });\n        try {\n            return await this._filePending;\n        }\n        finally {\n            this._filePending = null;\n        }\n    }\n    /**\n     * Delete the currently selected item(s).\n     *\n     * @returns A promise that resolves when the operation is complete.\n     */\n    delete() {\n        return this.listing.delete();\n    }\n    /**\n     * Duplicate the currently selected item(s).\n     *\n     * @returns A promise that resolves when the operation is complete.\n     */\n    duplicate() {\n        return this.listing.duplicate();\n    }\n    /**\n     * Download the currently selected item(s).\n     */\n    download() {\n        return this.listing.download();\n    }\n    /**\n     * cd ..\n     *\n     * Go up one level in the directory tree.\n     */\n    async goUp() {\n        return this.listing.goUp();\n    }\n    /**\n     * Shut down kernels on the applicable currently selected items.\n     *\n     * @returns A promise that resolves when the operation is complete.\n     */\n    shutdownKernels() {\n        return this.listing.shutdownKernels();\n    }\n    /**\n     * Select next item.\n     */\n    selectNext() {\n        this.listing.selectNext();\n    }\n    /**\n     * Select previous item.\n     */\n    selectPrevious() {\n        this.listing.selectPrevious();\n    }\n    /**\n     * Find a model given a click.\n     *\n     * @param event - The mouse event.\n     *\n     * @returns The model for the selected file.\n     */\n    modelForClick(event) {\n        return this.listing.modelForClick(event);\n    }\n    /**\n     * Create the underlying DirListing instance.\n     *\n     * @param options - The DirListing constructor options.\n     *\n     * @returns The created DirListing instance.\n     */\n    createDirListing(options) {\n        return new _listing__WEBPACK_IMPORTED_MODULE_8__.DirListing(options);\n    }\n    /**\n     * Handle a connection lost signal from the model.\n     */\n    _onConnectionFailure(sender, args) {\n        if (args instanceof _jupyterlab_services__WEBPACK_IMPORTED_MODULE_2__.ServerConnection.ResponseError &&\n            args.response.status === 404) {\n            const title = this._trans.__('Directory not found');\n            args.message = this._trans.__('Directory not found: \"%1\"', this.model.path);\n            void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(title, args);\n        }\n    }\n    /**\n     * Given a drive name and a local path, return the full\n     * drive path which includes the drive name and the local path.\n     *\n     * @param driveName the name of the drive\n     * @param localPath the local path on the drive.\n     *\n     * @returns the full drive path\n     */\n    _toDrivePath(driveName, localPath) {\n        if (driveName === '') {\n            return localPath;\n        }\n        else {\n            return `${driveName}:${_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.removeSlash(localPath)}`;\n        }\n    }\n}\n//# sourceMappingURL=browser.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/filebrowser/lib/browser.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/filebrowser/lib/crumbs.js":
/*!*************************************************************!*\
  !*** ../node_modules/@jupyterlab/filebrowser/lib/crumbs.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BreadCrumbs: () => (/* binding */ BreadCrumbs)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/coreutils */ \"webpack/sharing/consume/default/@jupyterlab/coreutils/@jupyterlab/coreutils\");\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/docmanager */ \"webpack/sharing/consume/default/@jupyterlab/docmanager/@jupyterlab/docmanager\");\n/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @lumino/algorithm */ \"webpack/sharing/consume/default/@lumino/algorithm/@lumino/algorithm\");\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__);\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @lumino/coreutils */ \"webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils\");\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_6__);\n/* harmony import */ var _lumino_domutils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @lumino/domutils */ \"webpack/sharing/consume/default/@lumino/domutils/@lumino/domutils\");\n/* harmony import */ var _lumino_domutils__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_lumino_domutils__WEBPACK_IMPORTED_MODULE_7__);\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @lumino/widgets */ \"webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets\");\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_8__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n\n\n\n\n/**\n * The class name added to the breadcrumb node.\n */\nconst BREADCRUMB_CLASS = 'jp-BreadCrumbs';\n/**\n * The class name for the breadcrumbs home node\n */\nconst BREADCRUMB_ROOT_CLASS = 'jp-BreadCrumbs-home';\n/**\n * The class name for the breadcrumbs preferred node\n */\nconst BREADCRUMB_PREFERRED_CLASS = 'jp-BreadCrumbs-preferred';\n/**\n * The class name added to the breadcrumb node.\n */\nconst BREADCRUMB_ITEM_CLASS = 'jp-BreadCrumbs-item';\n/**\n * Bread crumb paths.\n */\nconst BREAD_CRUMB_PATHS = ['/', '../../', '../', ''];\n/**\n * The mime type for a contents drag object.\n */\nconst CONTENTS_MIME = 'application/x-jupyter-icontents';\n/**\n * The class name added to drop targets.\n */\nconst DROP_TARGET_CLASS = 'jp-mod-dropTarget';\n/**\n * A class which hosts folder breadcrumbs.\n */\nclass BreadCrumbs extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_8__.Widget {\n    /**\n     * Construct a new file browser crumb widget.\n     *\n     * @param options Constructor options.\n     */\n    constructor(options) {\n        super();\n        this._previousState = null;\n        this.translator = options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3__.nullTranslator;\n        this._trans = this.translator.load('jupyterlab');\n        this._model = options.model;\n        this._fullPath = options.fullPath || false;\n        this.addClass(BREADCRUMB_CLASS);\n        this._crumbs = Private.createCrumbs();\n        this._crumbSeps = Private.createCrumbSeparators();\n        const hasPreferred = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PageConfig.getOption('preferredPath');\n        this._hasPreferred = hasPreferred && hasPreferred !== '/' ? true : false;\n        if (this._hasPreferred) {\n            this.node.appendChild(this._crumbs[Private.Crumb.Preferred]);\n        }\n        this.node.appendChild(this._crumbs[Private.Crumb.Home]);\n        this._model.refreshed.connect(this.update, this);\n    }\n    /**\n     * Handle the DOM events for the bread crumbs.\n     *\n     * @param event - The DOM event sent to the widget.\n     *\n     * #### Notes\n     * This method implements the DOM `EventListener` interface and is\n     * called in response to events on the panel's DOM node. It should\n     * not be called directly by user code.\n     */\n    handleEvent(event) {\n        switch (event.type) {\n            case 'click':\n                this._evtClick(event);\n                break;\n            case 'lm-dragenter':\n                this._evtDragEnter(event);\n                break;\n            case 'lm-dragleave':\n                this._evtDragLeave(event);\n                break;\n            case 'lm-dragover':\n                this._evtDragOver(event);\n                break;\n            case 'lm-drop':\n                this._evtDrop(event);\n                break;\n            default:\n                return;\n        }\n    }\n    /**\n     * Whether to show the full path in the breadcrumbs\n     */\n    get fullPath() {\n        return this._fullPath;\n    }\n    set fullPath(value) {\n        this._fullPath = value;\n    }\n    /**\n     * A message handler invoked on an `'after-attach'` message.\n     */\n    onAfterAttach(msg) {\n        super.onAfterAttach(msg);\n        this.update();\n        const node = this.node;\n        node.addEventListener('click', this);\n        node.addEventListener('lm-dragenter', this);\n        node.addEventListener('lm-dragleave', this);\n        node.addEventListener('lm-dragover', this);\n        node.addEventListener('lm-drop', this);\n    }\n    /**\n     * A message handler invoked on a `'before-detach'` message.\n     */\n    onBeforeDetach(msg) {\n        super.onBeforeDetach(msg);\n        const node = this.node;\n        node.removeEventListener('click', this);\n        node.removeEventListener('lm-dragenter', this);\n        node.removeEventListener('lm-dragleave', this);\n        node.removeEventListener('lm-dragover', this);\n        node.removeEventListener('lm-drop', this);\n    }\n    /**\n     * A handler invoked on an `'update-request'` message.\n     */\n    onUpdateRequest(msg) {\n        // Update the breadcrumb list.\n        const contents = this._model.manager.services.contents;\n        const localPath = contents.localPath(this._model.path);\n        const state = {\n            path: localPath,\n            hasPreferred: this._hasPreferred,\n            fullPath: this._fullPath\n        };\n        if (this._previousState && _lumino_coreutils__WEBPACK_IMPORTED_MODULE_6__.JSONExt.deepEqual(state, this._previousState)) {\n            return;\n        }\n        this._previousState = state;\n        Private.updateCrumbs(this._crumbs, this._crumbSeps, state);\n    }\n    /**\n     * Handle the `'click'` event for the widget.\n     */\n    _evtClick(event) {\n        // Do nothing if it's not a left mouse press.\n        if (event.button !== 0) {\n            return;\n        }\n        // Find a valid click target.\n        let node = event.target;\n        while (node && node !== this.node) {\n            if (node.classList.contains(BREADCRUMB_PREFERRED_CLASS)) {\n                this._model\n                    .cd(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PageConfig.getOption('preferredPath'))\n                    .catch(error => (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans.__('Open Error'), error));\n                // Stop the event propagation.\n                event.preventDefault();\n                event.stopPropagation();\n                return;\n            }\n            if (node.classList.contains(BREADCRUMB_ITEM_CLASS) ||\n                node.classList.contains(BREADCRUMB_ROOT_CLASS)) {\n                let index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.ArrayExt.findFirstIndex(this._crumbs, value => value === node);\n                let destination = BREAD_CRUMB_PATHS[index];\n                if (this._fullPath &&\n                    index < 0 &&\n                    !node.classList.contains(BREADCRUMB_ROOT_CLASS)) {\n                    destination = node.title;\n                }\n                this._model\n                    .cd(destination)\n                    .catch(error => (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans.__('Open Error'), error));\n                // Stop the event propagation.\n                event.preventDefault();\n                event.stopPropagation();\n                return;\n            }\n            node = node.parentElement;\n        }\n    }\n    /**\n     * Handle the `'lm-dragenter'` event for the widget.\n     */\n    _evtDragEnter(event) {\n        if (event.mimeData.hasData(CONTENTS_MIME)) {\n            const index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.ArrayExt.findFirstIndex(this._crumbs, node => _lumino_domutils__WEBPACK_IMPORTED_MODULE_7__.ElementExt.hitTest(node, event.clientX, event.clientY));\n            if (index !== -1) {\n                if (index !== Private.Crumb.Current) {\n                    this._crumbs[index].classList.add(DROP_TARGET_CLASS);\n                    event.preventDefault();\n                    event.stopPropagation();\n                }\n            }\n        }\n    }\n    /**\n     * Handle the `'lm-dragleave'` event for the widget.\n     */\n    _evtDragLeave(event) {\n        event.preventDefault();\n        event.stopPropagation();\n        const dropTarget = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(this.node, DROP_TARGET_CLASS);\n        if (dropTarget) {\n            dropTarget.classList.remove(DROP_TARGET_CLASS);\n        }\n    }\n    /**\n     * Handle the `'lm-dragover'` event for the widget.\n     */\n    _evtDragOver(event) {\n        event.preventDefault();\n        event.stopPropagation();\n        event.dropAction = event.proposedAction;\n        const dropTarget = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(this.node, DROP_TARGET_CLASS);\n        if (dropTarget) {\n            dropTarget.classList.remove(DROP_TARGET_CLASS);\n        }\n        const index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.ArrayExt.findFirstIndex(this._crumbs, node => _lumino_domutils__WEBPACK_IMPORTED_MODULE_7__.ElementExt.hitTest(node, event.clientX, event.clientY));\n        if (index !== -1) {\n            this._crumbs[index].classList.add(DROP_TARGET_CLASS);\n        }\n    }\n    /**\n     * Handle the `'lm-drop'` event for the widget.\n     */\n    _evtDrop(event) {\n        event.preventDefault();\n        event.stopPropagation();\n        if (event.proposedAction === 'none') {\n            event.dropAction = 'none';\n            return;\n        }\n        if (!event.mimeData.hasData(CONTENTS_MIME)) {\n            return;\n        }\n        event.dropAction = event.proposedAction;\n        let target = event.target;\n        while (target && target.parentElement) {\n            if (target.classList.contains(DROP_TARGET_CLASS)) {\n                target.classList.remove(DROP_TARGET_CLASS);\n                break;\n            }\n            target = target.parentElement;\n        }\n        // Get the path based on the target node.\n        const index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.ArrayExt.findFirstIndex(this._crumbs, node => node === target);\n        if (index === -1) {\n            return;\n        }\n        const model = this._model;\n        const path = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.resolve(model.path, BREAD_CRUMB_PATHS[index]);\n        const manager = model.manager;\n        // Move all of the items.\n        const promises = [];\n        const oldPaths = event.mimeData.getData(CONTENTS_MIME);\n        for (const oldPath of oldPaths) {\n            const localOldPath = manager.services.contents.localPath(oldPath);\n            const name = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.basename(localOldPath);\n            const newPath = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.join(path, name);\n            promises.push((0,_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__.renameFile)(manager, oldPath, newPath));\n        }\n        void Promise.all(promises).catch(err => {\n            return (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans.__('Move Error'), err);\n        });\n    }\n}\n/**\n * The namespace for the crumbs private data.\n */\nvar Private;\n(function (Private) {\n    /**\n     * Breadcrumb item list enum.\n     */\n    let Crumb;\n    (function (Crumb) {\n        Crumb[Crumb[\"Home\"] = 0] = \"Home\";\n        Crumb[Crumb[\"Ellipsis\"] = 1] = \"Ellipsis\";\n        Crumb[Crumb[\"Parent\"] = 2] = \"Parent\";\n        Crumb[Crumb[\"Current\"] = 3] = \"Current\";\n        Crumb[Crumb[\"Preferred\"] = 4] = \"Preferred\";\n    })(Crumb = Private.Crumb || (Private.Crumb = {}));\n    /**\n     * Populate the breadcrumb node.\n     */\n    function updateCrumbs(breadcrumbs, separators, state) {\n        const node = breadcrumbs[0].parentNode;\n        // Remove all but the home or preferred node.\n        const firstChild = node.firstChild;\n        while (firstChild && firstChild.nextSibling) {\n            node.removeChild(firstChild.nextSibling);\n        }\n        if (state.hasPreferred) {\n            node.appendChild(breadcrumbs[Crumb.Home]);\n            node.appendChild(separators[0]);\n        }\n        else {\n            node.appendChild(separators[0]);\n        }\n        const parts = state.path.split('/');\n        if (!state.fullPath && parts.length > 2) {\n            node.appendChild(breadcrumbs[Crumb.Ellipsis]);\n            const grandParent = parts.slice(0, parts.length - 2).join('/');\n            breadcrumbs[Crumb.Ellipsis].title = grandParent;\n            node.appendChild(separators[1]);\n        }\n        if (state.path) {\n            if (!state.fullPath) {\n                if (parts.length >= 2) {\n                    breadcrumbs[Crumb.Parent].textContent = parts[parts.length - 2];\n                    node.appendChild(breadcrumbs[Crumb.Parent]);\n                    const parent = parts.slice(0, parts.length - 1).join('/');\n                    breadcrumbs[Crumb.Parent].title = parent;\n                    node.appendChild(separators[2]);\n                }\n                breadcrumbs[Crumb.Current].textContent = parts[parts.length - 1];\n                node.appendChild(breadcrumbs[Crumb.Current]);\n                breadcrumbs[Crumb.Current].title = state.path;\n                node.appendChild(separators[3]);\n            }\n            else {\n                for (let i = 0; i < parts.length; i++) {\n                    const elem = document.createElement('span');\n                    elem.className = BREADCRUMB_ITEM_CLASS;\n                    elem.textContent = parts[i];\n                    const elemPath = `/${parts.slice(0, i + 1).join('/')}`;\n                    elem.title = elemPath;\n                    node.appendChild(elem);\n                    const separator = document.createElement('span');\n                    separator.textContent = '/';\n                    node.appendChild(separator);\n                }\n            }\n        }\n    }\n    Private.updateCrumbs = updateCrumbs;\n    /**\n     * Create the breadcrumb nodes.\n     */\n    function createCrumbs() {\n        const home = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.folderIcon.element({\n            className: BREADCRUMB_ROOT_CLASS,\n            tag: 'span',\n            title: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PageConfig.getOption('serverRoot') || 'Jupyter Server Root',\n            stylesheet: 'breadCrumb'\n        });\n        const ellipsis = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.ellipsesIcon.element({\n            className: BREADCRUMB_ITEM_CLASS,\n            tag: 'span',\n            stylesheet: 'breadCrumb'\n        });\n        const parent = document.createElement('span');\n        parent.className = BREADCRUMB_ITEM_CLASS;\n        const current = document.createElement('span');\n        current.className = BREADCRUMB_ITEM_CLASS;\n        const preferred = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.homeIcon.element({\n            className: BREADCRUMB_PREFERRED_CLASS,\n            tag: 'span',\n            title: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PageConfig.getOption('preferredPath') || 'Jupyter Preferred Path',\n            stylesheet: 'breadCrumb'\n        });\n        return [home, ellipsis, parent, current, preferred];\n    }\n    Private.createCrumbs = createCrumbs;\n    /**\n     * Create the breadcrumb separator nodes.\n     */\n    function createCrumbSeparators() {\n        const items = [];\n        // The maximum number of directories that will be shown in the crumbs\n        const MAX_DIRECTORIES = 2;\n        // Make separators for after each directory, one at the beginning, and one\n        // after a possible ellipsis.\n        for (let i = 0; i < MAX_DIRECTORIES + 2; i++) {\n            const item = document.createElement('span');\n            item.textContent = '/';\n            items.push(item);\n        }\n        return items;\n    }\n    Private.createCrumbSeparators = createCrumbSeparators;\n})(Private || (Private = {}));\n//# sourceMappingURL=crumbs.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/filebrowser/lib/crumbs.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/filebrowser/lib/index.js":
/*!************************************************************!*\
  !*** ../node_modules/@jupyterlab/filebrowser/lib/index.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BreadCrumbs: () => (/* reexport safe */ _crumbs__WEBPACK_IMPORTED_MODULE_1__.BreadCrumbs),\n/* harmony export */   CHUNK_SIZE: () => (/* reexport safe */ _model__WEBPACK_IMPORTED_MODULE_3__.CHUNK_SIZE),\n/* harmony export */   DirListing: () => (/* reexport safe */ _listing__WEBPACK_IMPORTED_MODULE_2__.DirListing),\n/* harmony export */   FileBrowser: () => (/* reexport safe */ _browser__WEBPACK_IMPORTED_MODULE_0__.FileBrowser),\n/* harmony export */   FileBrowserModel: () => (/* reexport safe */ _model__WEBPACK_IMPORTED_MODULE_3__.FileBrowserModel),\n/* harmony export */   FileDialog: () => (/* reexport safe */ _opendialog__WEBPACK_IMPORTED_MODULE_4__.FileDialog),\n/* harmony export */   FileUploadStatus: () => (/* reexport safe */ _uploadstatus__WEBPACK_IMPORTED_MODULE_7__.FileUploadStatus),\n/* harmony export */   FilterFileBrowserModel: () => (/* reexport safe */ _model__WEBPACK_IMPORTED_MODULE_3__.FilterFileBrowserModel),\n/* harmony export */   IDefaultFileBrowser: () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_5__.IDefaultFileBrowser),\n/* harmony export */   IFileBrowserCommands: () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_5__.IFileBrowserCommands),\n/* harmony export */   IFileBrowserFactory: () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_5__.IFileBrowserFactory),\n/* harmony export */   LARGE_FILE_SIZE: () => (/* reexport safe */ _model__WEBPACK_IMPORTED_MODULE_3__.LARGE_FILE_SIZE),\n/* harmony export */   TogglableHiddenFileBrowserModel: () => (/* reexport safe */ _model__WEBPACK_IMPORTED_MODULE_3__.TogglableHiddenFileBrowserModel),\n/* harmony export */   Uploader: () => (/* reexport safe */ _upload__WEBPACK_IMPORTED_MODULE_6__.Uploader)\n/* harmony export */ });\n/* harmony import */ var _browser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./browser */ \"../node_modules/@jupyterlab/filebrowser/lib/browser.js\");\n/* harmony import */ var _crumbs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./crumbs */ \"../node_modules/@jupyterlab/filebrowser/lib/crumbs.js\");\n/* harmony import */ var _listing__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./listing */ \"../node_modules/@jupyterlab/filebrowser/lib/listing.js\");\n/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./model */ \"../node_modules/@jupyterlab/filebrowser/lib/model.js\");\n/* harmony import */ var _opendialog__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./opendialog */ \"../node_modules/@jupyterlab/filebrowser/lib/opendialog.js\");\n/* harmony import */ var _tokens__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./tokens */ \"../node_modules/@jupyterlab/filebrowser/lib/tokens.js\");\n/* harmony import */ var _upload__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./upload */ \"../node_modules/@jupyterlab/filebrowser/lib/upload.js\");\n/* harmony import */ var _uploadstatus__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./uploadstatus */ \"../node_modules/@jupyterlab/filebrowser/lib/uploadstatus.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/**\n * @packageDocumentation\n * @module filebrowser\n */\n\n\n\n\n\n\n\n\n//# sourceMappingURL=index.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/filebrowser/lib/index.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/filebrowser/lib/listing.js":
/*!**************************************************************!*\
  !*** ../node_modules/@jupyterlab/filebrowser/lib/listing.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DirListing: () => (/* binding */ DirListing)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/coreutils */ \"webpack/sharing/consume/default/@jupyterlab/coreutils/@jupyterlab/coreutils\");\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/docmanager */ \"webpack/sharing/consume/default/@jupyterlab/docmanager/@jupyterlab/docmanager\");\n/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/docregistry */ \"webpack/sharing/consume/default/@jupyterlab/docregistry/@jupyterlab/docregistry\");\n/* harmony import */ var _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_5__);\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @lumino/algorithm */ \"webpack/sharing/consume/default/@lumino/algorithm/@lumino/algorithm\");\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_lumino_algorithm__WEBPACK_IMPORTED_MODULE_6__);\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @lumino/coreutils */ \"webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils\");\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_7__);\n/* harmony import */ var _lumino_domutils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @lumino/domutils */ \"webpack/sharing/consume/default/@lumino/domutils/@lumino/domutils\");\n/* harmony import */ var _lumino_domutils__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_lumino_domutils__WEBPACK_IMPORTED_MODULE_8__);\n/* harmony import */ var _lumino_disposable__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @lumino/disposable */ \"webpack/sharing/consume/default/@lumino/disposable/@lumino/disposable\");\n/* harmony import */ var _lumino_disposable__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_lumino_disposable__WEBPACK_IMPORTED_MODULE_9__);\n/* harmony import */ var _lumino_dragdrop__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @lumino/dragdrop */ \"webpack/sharing/consume/default/@lumino/dragdrop/@lumino/dragdrop\");\n/* harmony import */ var _lumino_dragdrop__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_lumino_dragdrop__WEBPACK_IMPORTED_MODULE_10__);\n/* harmony import */ var _lumino_messaging__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @lumino/messaging */ \"webpack/sharing/consume/default/@lumino/messaging/@lumino/messaging\");\n/* harmony import */ var _lumino_messaging__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_lumino_messaging__WEBPACK_IMPORTED_MODULE_11__);\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_12__);\n/* harmony import */ var _lumino_virtualdom__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @lumino/virtualdom */ \"webpack/sharing/consume/default/@lumino/virtualdom/@lumino/virtualdom\");\n/* harmony import */ var _lumino_virtualdom__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_lumino_virtualdom__WEBPACK_IMPORTED_MODULE_13__);\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @lumino/widgets */ \"webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets\");\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_14__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * The class name added to DirListing widget.\n */\nconst DIR_LISTING_CLASS = 'jp-DirListing';\n/**\n * The class name added to a dir listing header node.\n */\nconst HEADER_CLASS = 'jp-DirListing-header';\n/**\n * The class name added to a dir listing list header cell.\n */\nconst HEADER_ITEM_CLASS = 'jp-DirListing-headerItem';\n/**\n * The class name added to a header cell text node.\n */\nconst HEADER_ITEM_TEXT_CLASS = 'jp-DirListing-headerItemText';\n/**\n * The class name added to a header cell icon node.\n */\nconst HEADER_ITEM_ICON_CLASS = 'jp-DirListing-headerItemIcon';\n/**\n * The class name added to the dir listing content node.\n */\nconst CONTENT_CLASS = 'jp-DirListing-content';\n/**\n * The class name added to dir listing content item.\n */\nconst ITEM_CLASS = 'jp-DirListing-item';\n/**\n * The class name added to the listing item text cell.\n */\nconst ITEM_TEXT_CLASS = 'jp-DirListing-itemText';\n/**\n * The class name added to the listing item text cell.\n */\nconst ITEM_NAME_COLUMN_CLASS = 'jp-DirListing-itemName';\n/**\n * The class name added to the listing item icon cell.\n */\nconst ITEM_ICON_CLASS = 'jp-DirListing-itemIcon';\n/**\n * The class name added to the listing item modified cell.\n */\nconst ITEM_MODIFIED_CLASS = 'jp-DirListing-itemModified';\n/**\n * The class name added to the listing item file size cell.\n */\nconst ITEM_FILE_SIZE_CLASS = 'jp-DirListing-itemFileSize';\n/**\n * The class name added to the label element that wraps each item's checkbox and\n * the header's check-all checkbox.\n */\nconst CHECKBOX_WRAPPER_CLASS = 'jp-DirListing-checkboxWrapper';\n/**\n * The class name added to the dir listing editor node.\n */\nconst EDITOR_CLASS = 'jp-DirListing-editor';\n/**\n * The class name added to the name column header cell.\n */\nconst NAME_ID_CLASS = 'jp-id-name';\n/**\n * The class name added to the modified column header cell.\n */\nconst MODIFIED_ID_CLASS = 'jp-id-modified';\n/**\n * The class name added to the file size column header cell.\n */\nconst FILE_SIZE_ID_CLASS = 'jp-id-filesize';\n/**\n * The mime type for a contents drag object.\n */\nconst CONTENTS_MIME = 'application/x-jupyter-icontents';\n/**\n * The mime type for a rich contents drag object.\n */\nconst CONTENTS_MIME_RICH = 'application/x-jupyter-icontentsrich';\n/**\n * The class name added to drop targets.\n */\nconst DROP_TARGET_CLASS = 'jp-mod-dropTarget';\n/**\n * The class name added to selected rows.\n */\nconst SELECTED_CLASS = 'jp-mod-selected';\n/**\n * The class name added to drag state icons to add space between the icon and the file name\n */\nconst DRAG_ICON_CLASS = 'jp-DragIcon';\n/**\n * The class name added to column resize handle.\n */\nconst RESIZE_HANDLE_CLASS = 'jp-DirListing-resizeHandle';\n/**\n * The class name added to the widget when there are items on the clipboard.\n */\nconst CLIPBOARD_CLASS = 'jp-mod-clipboard';\n/**\n * The class name added to cut rows.\n */\nconst CUT_CLASS = 'jp-mod-cut';\n/**\n * The class name added when there are more than one selected rows.\n */\nconst MULTI_SELECTED_CLASS = 'jp-mod-multiSelected';\n/**\n * The class name added to indicate running notebook.\n */\nconst RUNNING_CLASS = 'jp-mod-running';\n/**\n * The class name added to indicate the active element.\n */\nconst ACTIVE_CLASS = 'jp-mod-active';\n/**\n * The class name added for a descending sort.\n */\nconst DESCENDING_CLASS = 'jp-mod-descending';\n/**\n * The maximum duration between two key presses when selecting files by prefix.\n */\nconst PREFIX_APPEND_DURATION = 1000;\n/**\n * The default width of the resize handle.\n */\nconst DEFAULT_HANDLE_WIDTH = 5;\n/**\n * The threshold in pixels to start a drag event.\n */\nconst DRAG_THRESHOLD = 5;\n/**\n * A boolean indicating whether the platform is Mac.\n */\nconst IS_MAC = !!navigator.platform.match(/Mac/i);\n/**\n * The factory MIME type supported by lumino dock panels.\n */\nconst FACTORY_MIME = 'application/vnd.lumino.widget-factory';\n/**\n * A widget which hosts a file list area.\n */\nclass DirListing extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_14__.Widget {\n    /**\n     * Construct a new file browser directory listing widget.\n     *\n     * @param options The constructor options\n     */\n    constructor(options) {\n        super({\n            node: (options.renderer || DirListing.defaultRenderer).createNode()\n        });\n        this._items = [];\n        this._sortedItems = [];\n        this._sortState = {\n            direction: 'ascending',\n            key: 'name'\n        };\n        this._onItemOpened = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_12__.Signal(this);\n        this._drag = null;\n        this._dragData = null;\n        this._resizeData = null;\n        this._selectTimer = -1;\n        this._isCut = false;\n        this._prevPath = '';\n        this._clipboard = [];\n        this._softSelection = '';\n        this.selection = Object.create(null);\n        this._searchPrefix = '';\n        this._searchPrefixTimer = -1;\n        this._inRename = false;\n        this._isDirty = false;\n        this._hiddenColumns = new Set();\n        this._columnSizes = {\n            name: null,\n            file_size: null,\n            is_selected: null,\n            last_modified: null\n        };\n        this._sortNotebooksFirst = false;\n        this._allowSingleClick = false;\n        // _focusIndex should never be set outside the range [0, this._items.length - 1]\n        this._focusIndex = 0;\n        this._allUploaded = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_12__.Signal(this);\n        this._width = null;\n        this._state = null;\n        this._contentScrollbarWidth = 0;\n        this._contentSizeObserver = new ResizeObserver(this._onContentResize.bind(this));\n        this._paddingWidth = 0;\n        this._handleWidth = DEFAULT_HANDLE_WIDTH;\n        this.addClass(DIR_LISTING_CLASS);\n        this.translator = options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_4__.nullTranslator;\n        this._trans = this.translator.load('jupyterlab');\n        this._model = options.model;\n        this._model.fileChanged.connect(this._onFileChanged, this);\n        this._model.refreshed.connect(this._onModelRefreshed, this);\n        this._model.pathChanged.connect(this._onPathChanged, this);\n        this._editNode = document.createElement('input');\n        this._editNode.className = EDITOR_CLASS;\n        this._manager = this._model.manager;\n        this._renderer = options.renderer || DirListing.defaultRenderer;\n        this._state = options.state || null;\n        // Get the width of the \"modified\" column\n        this._updateModifiedSize(this.node);\n        const headerNode = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(this.node, HEADER_CLASS);\n        // hide the file size column by default\n        this._hiddenColumns.add('file_size');\n        this._renderer.populateHeaderNode(headerNode, this.translator, this._hiddenColumns, this._columnSizes);\n        this._manager.activateRequested.connect(this._onActivateRequested, this);\n    }\n    /**\n     * Dispose of the resources held by the directory listing.\n     */\n    dispose() {\n        this._items.length = 0;\n        this._sortedItems.length = 0;\n        this._clipboard.length = 0;\n        super.dispose();\n    }\n    /**\n     * Get the model used by the listing.\n     */\n    get model() {\n        return this._model;\n    }\n    /**\n     * Get the dir listing header node.\n     *\n     * #### Notes\n     * This is the node which holds the header cells.\n     *\n     * Modifying this node directly can lead to undefined behavior.\n     */\n    get headerNode() {\n        return _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(this.node, HEADER_CLASS);\n    }\n    /**\n     * Get the dir listing content node.\n     *\n     * #### Notes\n     * This is the node which holds the item nodes.\n     *\n     * Modifying this node directly can lead to undefined behavior.\n     */\n    get contentNode() {\n        return _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(this.node, CONTENT_CLASS);\n    }\n    /**\n     * The renderer instance used by the directory listing.\n     */\n    get renderer() {\n        return this._renderer;\n    }\n    /**\n     * The current sort state.\n     */\n    get sortState() {\n        return this._sortState;\n    }\n    /**\n     * A signal fired when an item is opened.\n     */\n    get onItemOpened() {\n        return this._onItemOpened;\n    }\n    /**\n     * Create an iterator over the listing's selected items.\n     *\n     * @returns A new iterator over the listing's selected items.\n     */\n    selectedItems() {\n        const items = this._sortedItems;\n        return (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_6__.filter)(items, item => this.selection[item.path]);\n    }\n    /**\n     * Create an iterator over the listing's sorted items.\n     *\n     * @returns A new iterator over the listing's sorted items.\n     */\n    sortedItems() {\n        return this._sortedItems[Symbol.iterator]();\n    }\n    /**\n     * Sort the items using a sort condition.\n     */\n    sort(state) {\n        this._sortedItems = Private.sort(this.model.items(), state, this._sortNotebooksFirst, this.translator);\n        this._sortState = state;\n        this.update();\n    }\n    /**\n     * Rename the first currently selected item.\n     *\n     * @returns A promise that resolves with the new name of the item.\n     */\n    rename() {\n        return this._doRename();\n    }\n    /**\n     * Cut the selected items.\n     */\n    cut() {\n        this._isCut = true;\n        this._copy();\n        this.update();\n    }\n    /**\n     * Copy the selected items.\n     */\n    copy() {\n        this._copy();\n    }\n    /**\n     * Paste the items from the clipboard.\n     *\n     * @returns A promise that resolves when the operation is complete.\n     */\n    paste() {\n        if (!this._clipboard.length) {\n            this._isCut = false;\n            return Promise.resolve(undefined);\n        }\n        const basePath = this._model.path;\n        const promises = [];\n        for (const path of this._clipboard) {\n            if (this._isCut) {\n                const localPath = this._manager.services.contents.localPath(path);\n                const parts = localPath.split('/');\n                const name = parts[parts.length - 1];\n                const newPath = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.join(basePath, name);\n                promises.push(this._model.manager.rename(path, newPath));\n            }\n            else {\n                promises.push(this._model.manager.copy(path, basePath));\n            }\n        }\n        // Remove any cut modifiers.\n        for (const item of this._items) {\n            item.classList.remove(CUT_CLASS);\n        }\n        this._clipboard.length = 0;\n        this._isCut = false;\n        this.removeClass(CLIPBOARD_CLASS);\n        return Promise.all(promises)\n            .then(() => {\n            return undefined;\n        })\n            .catch(error => {\n            void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans._p('showErrorMessage', 'Paste Error'), error);\n        });\n    }\n    /**\n     * Delete the currently selected item(s).\n     *\n     * @returns A promise that resolves when the operation is complete.\n     */\n    async delete() {\n        const items = this._sortedItems.filter(item => this.selection[item.path]);\n        if (!items.length) {\n            return;\n        }\n        const message = items.length === 1\n            ? this._trans.__('Are you sure you want to permanently delete: %1?', items[0].name)\n            : this._trans._n('Are you sure you want to permanently delete the %1 selected item?', 'Are you sure you want to permanently delete the %1 selected items?', items.length);\n        const result = await (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showDialog)({\n            title: this._trans.__('Delete'),\n            body: message,\n            buttons: [\n                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.cancelButton({ label: this._trans.__('Cancel') }),\n                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.warnButton({ label: this._trans.__('Delete') })\n            ],\n            // By default focus on \"Cancel\" to protect from accidental deletion\n            // (\"delete\" and \"Enter\" are next to each other on many keyboards).\n            defaultButton: 0\n        });\n        if (!this.isDisposed && result.button.accept) {\n            await this._delete(items.map(item => item.path));\n        }\n        // Re-focus\n        let focusIndex = this._focusIndex;\n        const lastIndexAfterDelete = this._sortedItems.length - items.length - 1;\n        if (focusIndex > lastIndexAfterDelete) {\n            // If the focus index after deleting items is out of bounds, set it to the\n            // last item.\n            focusIndex = Math.max(0, lastIndexAfterDelete);\n        }\n        this._focusItem(focusIndex);\n    }\n    /**\n     * Duplicate the currently selected item(s).\n     *\n     * @returns A promise that resolves when the operation is complete.\n     */\n    duplicate() {\n        const basePath = this._model.path;\n        const promises = [];\n        for (const item of this.selectedItems()) {\n            if (item.type !== 'directory') {\n                promises.push(this._model.manager.copy(item.path, basePath));\n            }\n        }\n        return Promise.all(promises)\n            .then(() => {\n            return undefined;\n        })\n            .catch(error => {\n            void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans._p('showErrorMessage', 'Duplicate file'), error);\n        });\n    }\n    /**\n     * Download the currently selected item(s).\n     */\n    async download() {\n        await Promise.all(Array.from(this.selectedItems())\n            .filter(item => item.type !== 'directory')\n            .map(item => this._model.download(item.path)));\n    }\n    /**\n     * Restore the state of the file browser listing.\n     *\n     * @param id - The unique ID that is used to construct a state database key.\n     *\n     */\n    async restore(id) {\n        const key = `file-browser-${id}:columns`;\n        const state = this._state;\n        this._stateColumnsKey = key;\n        if (!state) {\n            return;\n        }\n        try {\n            const columns = await state.fetch(key);\n            if (!columns) {\n                return;\n            }\n            const sizes = columns['sizes'];\n            if (!sizes) {\n                return;\n            }\n            for (const [key, size] of Object.entries(sizes)) {\n                this._columnSizes[key] = size;\n            }\n            this._updateColumnSizes();\n        }\n        catch (error) {\n            await state.remove(key);\n        }\n    }\n    /**\n     * Shut down kernels on the applicable currently selected items.\n     *\n     * @returns A promise that resolves when the operation is complete.\n     */\n    shutdownKernels() {\n        const model = this._model;\n        const items = this._sortedItems;\n        const paths = items.map(item => item.path);\n        const promises = Array.from(this._model.sessions())\n            .filter(session => {\n            const index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_6__.ArrayExt.firstIndexOf(paths, session.path);\n            return this.selection[items[index].path];\n        })\n            .map(session => model.manager.services.sessions.shutdown(session.id));\n        return Promise.all(promises)\n            .then(() => {\n            return undefined;\n        })\n            .catch(error => {\n            void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans._p('showErrorMessage', 'Shut down kernel'), error);\n        });\n    }\n    /**\n     * Select next item.\n     *\n     * @param keepExisting - Whether to keep the current selection and add to it.\n     */\n    selectNext(keepExisting = false) {\n        let index = -1;\n        const selected = Object.keys(this.selection);\n        const items = this._sortedItems;\n        if (selected.length === 1 || keepExisting) {\n            // Select the next item.\n            const path = selected[selected.length - 1];\n            index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_6__.ArrayExt.findFirstIndex(items, value => value.path === path);\n            index += 1;\n            if (index === this._items.length) {\n                index = 0;\n            }\n        }\n        else if (selected.length === 0) {\n            // Select the first item.\n            index = 0;\n        }\n        else {\n            // Select the last selected item.\n            const path = selected[selected.length - 1];\n            index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_6__.ArrayExt.findFirstIndex(items, value => value.path === path);\n        }\n        if (index !== -1) {\n            this._selectItem(index, keepExisting);\n            _lumino_domutils__WEBPACK_IMPORTED_MODULE_8__.ElementExt.scrollIntoViewIfNeeded(this.contentNode, this._items[index]);\n        }\n    }\n    /**\n     * Select previous item.\n     *\n     * @param keepExisting - Whether to keep the current selection and add to it.\n     */\n    selectPrevious(keepExisting = false) {\n        let index = -1;\n        const selected = Object.keys(this.selection);\n        const items = this._sortedItems;\n        if (selected.length === 1 || keepExisting) {\n            // Select the previous item.\n            const path = selected[0];\n            index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_6__.ArrayExt.findFirstIndex(items, value => value.path === path);\n            index -= 1;\n            if (index === -1) {\n                index = this._items.length - 1;\n            }\n        }\n        else if (selected.length === 0) {\n            // Select the last item.\n            index = this._items.length - 1;\n        }\n        else {\n            // Select the first selected item.\n            const path = selected[0];\n            index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_6__.ArrayExt.findFirstIndex(items, value => value.path === path);\n        }\n        if (index !== -1) {\n            this._selectItem(index, keepExisting);\n            _lumino_domutils__WEBPACK_IMPORTED_MODULE_8__.ElementExt.scrollIntoViewIfNeeded(this.contentNode, this._items[index]);\n        }\n    }\n    /**\n     * Select the first item that starts with prefix being typed.\n     */\n    selectByPrefix() {\n        const prefix = this._searchPrefix.toLowerCase();\n        const items = this._sortedItems;\n        const index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_6__.ArrayExt.findFirstIndex(items, value => {\n            return value.name.toLowerCase().substr(0, prefix.length) === prefix;\n        });\n        if (index !== -1) {\n            this._selectItem(index, false);\n            _lumino_domutils__WEBPACK_IMPORTED_MODULE_8__.ElementExt.scrollIntoViewIfNeeded(this.contentNode, this._items[index]);\n        }\n    }\n    /**\n     * Get whether an item is selected by name.\n     *\n     * @param name - The name of of the item.\n     *\n     * @returns Whether the item is selected.\n     */\n    isSelected(name) {\n        const items = this._sortedItems;\n        return (Array.from((0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_6__.filter)(items, item => item.name === name && this.selection[item.path])).length !== 0);\n    }\n    /**\n     * Find a model given a click.\n     *\n     * @param event - The mouse event.\n     *\n     * @returns The model for the selected file.\n     */\n    modelForClick(event) {\n        const items = this._sortedItems;\n        const index = Private.hitTestNodes(this._items, event);\n        if (index !== -1) {\n            return items[index];\n        }\n        return undefined;\n    }\n    /**\n     * Clear the selected items.\n     */\n    clearSelectedItems() {\n        this.selection = Object.create(null);\n    }\n    /**\n     * Select an item by name.\n     *\n     * @param name - The name of the item to select.\n     * @param focus - Whether to move focus to the selected item.\n     *\n     * @returns A promise that resolves when the name is selected.\n     */\n    async selectItemByName(name, focus = false) {\n        return this._selectItemByName(name, focus);\n    }\n    /**\n     * Select an item by name.\n     *\n     * @param name - The name of the item to select.\n     * @param focus - Whether to move focus to the selected item.\n     * @param force - Whether to proceed with selection even if the file was already selected.\n     *\n     * @returns A promise that resolves when the name is selected.\n     */\n    async _selectItemByName(name, focus = false, force = false) {\n        if (!force && this.isSelected(name)) {\n            // Avoid API polling and DOM updates if already selected\n            return;\n        }\n        // Make sure the file is available.\n        await this.model.refresh();\n        if (this.isDisposed) {\n            throw new Error('File browser is disposed.');\n        }\n        const items = this._sortedItems;\n        const index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_6__.ArrayExt.findFirstIndex(items, value => value.name === name);\n        if (index === -1) {\n            throw new Error('Item does not exist.');\n        }\n        this._selectItem(index, false, focus);\n        _lumino_messaging__WEBPACK_IMPORTED_MODULE_11__.MessageLoop.sendMessage(this, _lumino_widgets__WEBPACK_IMPORTED_MODULE_14__.Widget.Msg.UpdateRequest);\n        _lumino_domutils__WEBPACK_IMPORTED_MODULE_8__.ElementExt.scrollIntoViewIfNeeded(this.contentNode, this._items[index]);\n    }\n    /**\n     * Handle the DOM events for the directory listing.\n     *\n     * @param event - The DOM event sent to the widget.\n     *\n     * #### Notes\n     * This method implements the DOM `EventListener` interface and is\n     * called in response to events on the panel's DOM node. It should\n     * not be called directly by user code.\n     */\n    handleEvent(event) {\n        switch (event.type) {\n            case 'mousedown':\n                this._evtMousedown(event);\n                break;\n            case 'mouseup':\n                this._evtMouseup(event);\n                break;\n            case 'mousemove':\n                this._evtMousemove(event);\n                break;\n            case 'keydown':\n                this.evtKeydown(event);\n                break;\n            case 'click':\n                this._evtClick(event);\n                break;\n            case 'dblclick':\n                this.evtDblClick(event);\n                break;\n            case 'dragenter':\n            case 'dragover':\n                this.addClass('jp-mod-native-drop');\n                event.preventDefault();\n                break;\n            case 'dragleave':\n            case 'dragend':\n                this.removeClass('jp-mod-native-drop');\n                break;\n            case 'drop':\n                this.removeClass('jp-mod-native-drop');\n                this.evtNativeDrop(event);\n                break;\n            case 'scroll':\n                this._evtScroll(event);\n                break;\n            case 'lm-dragenter':\n                this.evtDragEnter(event);\n                break;\n            case 'lm-dragleave':\n                this.evtDragLeave(event);\n                break;\n            case 'lm-dragover':\n                this.evtDragOver(event);\n                break;\n            case 'lm-drop':\n                this.evtDrop(event);\n                break;\n            default:\n                break;\n        }\n    }\n    /**\n     * A message handler invoked on an `'after-attach'` message.\n     */\n    onAfterAttach(msg) {\n        super.onAfterAttach(msg);\n        const node = this.node;\n        this._width = this._computeContentWidth();\n        const content = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, CONTENT_CLASS);\n        node.addEventListener('mousedown', this);\n        node.addEventListener('keydown', this);\n        node.addEventListener('click', this);\n        node.addEventListener('dblclick', this);\n        this._contentSizeObserver.observe(content);\n        content.addEventListener('dragenter', this);\n        content.addEventListener('dragover', this);\n        content.addEventListener('dragleave', this);\n        content.addEventListener('dragend', this);\n        content.addEventListener('drop', this);\n        content.addEventListener('scroll', this);\n        content.addEventListener('lm-dragenter', this);\n        content.addEventListener('lm-dragleave', this);\n        content.addEventListener('lm-dragover', this);\n        content.addEventListener('lm-drop', this);\n    }\n    /**\n     * A message handler invoked on a `'before-detach'` message.\n     */\n    onBeforeDetach(msg) {\n        super.onBeforeDetach(msg);\n        const node = this.node;\n        const content = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, CONTENT_CLASS);\n        node.removeEventListener('mousedown', this);\n        node.removeEventListener('keydown', this);\n        node.removeEventListener('click', this);\n        node.removeEventListener('dblclick', this);\n        this._contentSizeObserver.disconnect();\n        content.removeEventListener('scroll', this);\n        content.removeEventListener('dragover', this);\n        content.removeEventListener('dragover', this);\n        content.removeEventListener('dragleave', this);\n        content.removeEventListener('dragend', this);\n        content.removeEventListener('drop', this);\n        content.removeEventListener('lm-dragenter', this);\n        content.removeEventListener('lm-dragleave', this);\n        content.removeEventListener('lm-dragover', this);\n        content.removeEventListener('lm-drop', this);\n        document.removeEventListener('mousemove', this, true);\n        document.removeEventListener('mouseup', this, true);\n    }\n    /**\n     * A message handler invoked on an `'after-show'` message.\n     */\n    onAfterShow(msg) {\n        if (this._isDirty) {\n            // Update the sorted items.\n            this.sort(this.sortState);\n            this.update();\n        }\n    }\n    _onContentResize() {\n        const content = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(this.node, CONTENT_CLASS);\n        const scrollbarWidth = content.offsetWidth - content.clientWidth;\n        if (scrollbarWidth != this._contentScrollbarWidth) {\n            this._contentScrollbarWidth = scrollbarWidth;\n            this._width = this._computeContentWidth();\n            this._updateColumnSizes();\n        }\n    }\n    _computeContentWidth(width = null) {\n        if (!width) {\n            width = this.node.getBoundingClientRect().width;\n        }\n        this._paddingWidth = parseFloat(window\n            .getComputedStyle(this.node)\n            .getPropertyValue('--jp-dirlisting-padding-width'));\n        const handle = this.node.querySelector(`.${RESIZE_HANDLE_CLASS}`);\n        this._handleWidth = handle\n            ? handle.getBoundingClientRect().width\n            : DEFAULT_HANDLE_WIDTH;\n        return width - this._paddingWidth * 2 - this._contentScrollbarWidth;\n    }\n    /**\n     * Update the modified column's size\n     */\n    _updateModifiedSize(node) {\n        var _a, _b;\n        // Look for the modified column's header\n        const modified = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, MODIFIED_ID_CLASS);\n        this._modifiedWidth =\n            (_b = (_a = this._columnSizes['last_modified']) !== null && _a !== void 0 ? _a : modified === null || modified === void 0 ? void 0 : modified.getBoundingClientRect().width) !== null && _b !== void 0 ? _b : 83;\n        this._modifiedStyle =\n            this._modifiedWidth < 100\n                ? 'narrow'\n                : this._modifiedWidth > 120\n                    ? 'long'\n                    : 'short';\n    }\n    /**\n     * Rerender item nodes' modified dates, if the modified style has changed.\n     */\n    _updateModifiedStyleAndSize() {\n        const oldModifiedStyle = this._modifiedStyle;\n        // Update both size and style\n        this._updateModifiedSize(this.node);\n        if (oldModifiedStyle !== this._modifiedStyle) {\n            this.updateModified(this._sortedItems, this._items);\n        }\n    }\n    /**\n     * Update only the modified dates.\n     */\n    updateModified(items, nodes) {\n        items.forEach((item, i) => {\n            const node = nodes[i];\n            if (node && item.last_modified) {\n                const modified = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, ITEM_MODIFIED_CLASS);\n                if (this.renderer.updateItemModified !== undefined) {\n                    this.renderer.updateItemModified(modified, item.last_modified, this._modifiedStyle);\n                }\n                else {\n                    DirListing.defaultRenderer.updateItemModified(modified, item.last_modified, this._modifiedStyle);\n                }\n            }\n        });\n    }\n    // Update item nodes based on widget state.\n    updateNodes(items, nodes, sizeOnly = false) {\n        var _a;\n        items.forEach((item, i) => {\n            const node = nodes[i];\n            if (sizeOnly && this.renderer.updateItemSize) {\n                if (!node) {\n                    // short-circuit in case if node is not yet ready\n                    return;\n                }\n                return this.renderer.updateItemSize(node, item, this._modifiedStyle, this._columnSizes);\n            }\n            const ft = this._manager.registry.getFileTypeForModel(item);\n            this.renderer.updateItemNode(node, item, ft, this.translator, this._hiddenColumns, this.selection[item.path], this._modifiedStyle, this._columnSizes);\n            if (this.selection[item.path] &&\n                this._isCut &&\n                this._model.path === this._prevPath) {\n                node.classList.add(CUT_CLASS);\n            }\n            // add metadata to the node\n            node.setAttribute('data-isdir', item.type === 'directory' ? 'true' : 'false');\n        });\n        // Handle the selectors on the widget node.\n        const selected = Object.keys(this.selection).length;\n        if (selected) {\n            this.addClass(SELECTED_CLASS);\n            if (selected > 1) {\n                this.addClass(MULTI_SELECTED_CLASS);\n            }\n        }\n        // Handle file session statuses.\n        const paths = items.map(item => item.path);\n        for (const session of this._model.sessions()) {\n            const index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_6__.ArrayExt.firstIndexOf(paths, session.path);\n            const node = nodes[index];\n            // Node may have been filtered out.\n            if (node) {\n                let name = (_a = session.kernel) === null || _a === void 0 ? void 0 : _a.name;\n                const specs = this._model.specs;\n                node.classList.add(RUNNING_CLASS);\n                if (specs && name) {\n                    const spec = specs.kernelspecs[name];\n                    name = spec ? spec.display_name : this._trans.__('unknown');\n                }\n                node.title = this._trans.__('%1\\nKernel: %2', node.title, name);\n            }\n        }\n    }\n    /**\n     * A handler invoked on an `'update-request'` message.\n     */\n    onUpdateRequest(msg) {\n        this._isDirty = false;\n        // Fetch common variables.\n        const items = this._sortedItems;\n        const nodes = this._items;\n        const content = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(this.node, CONTENT_CLASS);\n        const renderer = this._renderer;\n        this.removeClass(MULTI_SELECTED_CLASS);\n        this.removeClass(SELECTED_CLASS);\n        // Remove any excess item nodes.\n        while (nodes.length > items.length) {\n            content.removeChild(nodes.pop());\n        }\n        // Add any missing item nodes.\n        while (nodes.length < items.length) {\n            const node = renderer.createItemNode(this._hiddenColumns, this._columnSizes);\n            node.classList.add(ITEM_CLASS);\n            nodes.push(node);\n            content.appendChild(node);\n        }\n        nodes.forEach((node, i) => {\n            // Remove extra classes from the nodes.\n            node.classList.remove(SELECTED_CLASS);\n            node.classList.remove(RUNNING_CLASS);\n            node.classList.remove(CUT_CLASS);\n            // Uncheck each file checkbox\n            const checkbox = renderer.getCheckboxNode(node);\n            if (checkbox) {\n                checkbox.checked = false;\n            }\n            // Handle `tabIndex`\n            const nameNode = renderer.getNameNode(node);\n            if (nameNode) {\n                // Must check if the name node is there because it gets replaced by the\n                // edit node when editing the name of the file or directory.\n                nameNode.tabIndex = i === this._focusIndex ? 0 : -1;\n            }\n        });\n        // Put the check-all checkbox in the header into the correct state\n        const checkAllCheckbox = renderer.getCheckboxNode(this.headerNode);\n        if (checkAllCheckbox) {\n            const totalSelected = Object.keys(this.selection).length;\n            const allSelected = items.length > 0 && totalSelected === items.length;\n            const someSelected = !allSelected && totalSelected > 0;\n            checkAllCheckbox.checked = allSelected;\n            checkAllCheckbox.indeterminate = someSelected;\n            // Stash the state in data attributes so we can access them in the click\n            // handler (because in the click handler, checkbox.checked and\n            // checkbox.indeterminate do not hold the previous value; they hold the\n            // next value).\n            checkAllCheckbox.dataset.checked = String(allSelected);\n            checkAllCheckbox.dataset.indeterminate = String(someSelected);\n            const trans = this.translator.load('jupyterlab');\n            checkAllCheckbox === null || checkAllCheckbox === void 0 ? void 0 : checkAllCheckbox.setAttribute('aria-label', allSelected || someSelected\n                ? trans.__('Deselect all files and directories')\n                : trans.__('Select all files and directories'));\n        }\n        this.updateNodes(items, nodes);\n        this._prevPath = this._model.path;\n    }\n    onResize(msg) {\n        const { width } = msg.width === -1 ? this.node.getBoundingClientRect() : msg;\n        this._width = this._computeContentWidth(width);\n        this._updateColumnSizes();\n    }\n    setColumnVisibility(name, visible) {\n        if (visible) {\n            this._hiddenColumns.delete(name);\n        }\n        else {\n            this._hiddenColumns.add(name);\n        }\n        this.headerNode.innerHTML = '';\n        this._renderer.populateHeaderNode(this.headerNode, this.translator, this._hiddenColumns, this._columnSizes);\n        this._updateColumnSizes();\n    }\n    _updateColumnSizes(doNotGrowBeforeInclusive = null) {\n        // Adjust column sizes so that they add up to the total width available, preserving ratios\n        const visibleColumns = this._visibleColumns\n            .map(column => ({\n            ...column,\n            element: _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(this.node, column.className)\n        }))\n            .filter(column => {\n            // While all visible column will have an element, some extensions like jupyter-unfold\n            // do not render columns even if user requests them to be visible; this filter exists\n            // to ensure backward compatibility with such extensions and may be removed in the future.\n            return column.element;\n        });\n        // read from DOM\n        let total = 0;\n        for (const column of visibleColumns) {\n            let size = this._columnSizes[column.id];\n            if (size === null) {\n                size = column.element.getBoundingClientRect().width;\n            }\n            // restrict the minimum and maximum width\n            size = Math.max(size, column.minWidth);\n            if (this._width) {\n                let reservedForOtherColumns = 0;\n                for (const other of visibleColumns) {\n                    if (other.id === column.id) {\n                        continue;\n                    }\n                    reservedForOtherColumns += other.minWidth;\n                }\n                size = Math.min(size, this._width - reservedForOtherColumns);\n            }\n            this._columnSizes[column.id] = size;\n            total += size;\n        }\n        // Ensure that total fits\n        if (this._width) {\n            // Distribute the excess/shortfall over the columns which should stretch.\n            const excess = this._width - total;\n            let growAllowed = doNotGrowBeforeInclusive === null;\n            const growColumns = visibleColumns.filter(c => {\n                if (growAllowed) {\n                    return true;\n                }\n                if (c.id === doNotGrowBeforeInclusive) {\n                    growAllowed = true;\n                }\n                return false;\n            });\n            const totalWeight = growColumns\n                .map(c => c.grow)\n                .reduce((a, b) => a + b, 0);\n            for (const column of growColumns) {\n                // The value of `growBy` will be negative when the down-sizing\n                const growBy = (excess * column.grow) / totalWeight;\n                this._columnSizes[column.id] = this._columnSizes[column.id] + growBy;\n            }\n        }\n        const resizeHandles = this.node.getElementsByClassName(RESIZE_HANDLE_CLASS);\n        const resizableColumns = visibleColumns.map(column => Private.isResizable(column));\n        // Write to DOM\n        let i = 0;\n        for (const column of visibleColumns) {\n            let size = this._columnSizes[column.id];\n            if (Private.isResizable(column) && size) {\n                size -=\n                    (this._handleWidth * resizeHandles.length) / resizableColumns.length;\n                // if this is first resizable or last resizable column\n                if (i === 0 || i === resizableColumns.length - 1) {\n                    size += this._paddingWidth;\n                }\n                i += 1;\n            }\n            column.element.style.width = size === null ? '' : size + 'px';\n        }\n        this._updateModifiedStyleAndSize();\n        // Refresh sizes on the per item widths\n        if (this.isVisible) {\n            const items = this._items;\n            if (items.length !== 0) {\n                this.updateNodes(this._sortedItems, this._items, true);\n            }\n        }\n        if (this._state && this._stateColumnsKey) {\n            void this._state.save(this._stateColumnsKey, {\n                sizes: this._columnSizes\n            });\n        }\n    }\n    get _visibleColumns() {\n        return DirListing.columns.filter(column => { var _a; return column.id === 'name' || !((_a = this._hiddenColumns) === null || _a === void 0 ? void 0 : _a.has(column.id)); });\n    }\n    _setColumnSize(name, size) {\n        var _a;\n        const previousSize = this._columnSizes[name];\n        if (previousSize && size && size > previousSize) {\n            // check if we can resize up\n            let total = 0;\n            let before = true;\n            for (const column of this._visibleColumns) {\n                if (column.id === name) {\n                    // add proposed size for the current columns\n                    total += size;\n                    before = false;\n                    continue;\n                }\n                if (before) {\n                    // add size as-is for columns before\n                    const element = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(this.node, column.className);\n                    total +=\n                        (_a = this._columnSizes[column.id]) !== null && _a !== void 0 ? _a : element.getBoundingClientRect().width;\n                }\n                else {\n                    // add minimum acceptable size for columns after\n                    total += column.minWidth;\n                }\n            }\n            if (this._width && total > this._width) {\n                // up sizing is no longer possible\n                return;\n            }\n        }\n        this._columnSizes[name] = size;\n        this._updateColumnSizes(name);\n    }\n    /**\n     * Update the setting to sort notebooks above files.\n     * This sorts the items again if the internal value is modified.\n     */\n    setNotebooksFirstSorting(isEnabled) {\n        let previousValue = this._sortNotebooksFirst;\n        this._sortNotebooksFirst = isEnabled;\n        if (this._sortNotebooksFirst !== previousValue) {\n            this.sort(this._sortState);\n        }\n    }\n    /**\n     * Update the setting to allow single click navigation.\n     * This enables opening files/directories with a single click.\n     */\n    setAllowSingleClickNavigation(isEnabled) {\n        this._allowSingleClick = isEnabled;\n    }\n    /**\n     * Would this click (or other event type) hit the checkbox by default?\n     */\n    isWithinCheckboxHitArea(event) {\n        let element = event.target;\n        while (element) {\n            if (element.classList.contains(CHECKBOX_WRAPPER_CLASS)) {\n                return true;\n            }\n            element = element.parentElement;\n        }\n        return false;\n    }\n    /**\n     * Handle the `'click'` event for the widget.\n     */\n    _evtClick(event) {\n        const target = event.target;\n        const header = this.headerNode;\n        const renderer = this._renderer;\n        if (header.contains(target)) {\n            const checkbox = renderer.getCheckboxNode(header);\n            if (checkbox && this.isWithinCheckboxHitArea(event)) {\n                const previouslyUnchecked = checkbox.dataset.indeterminate === 'false' &&\n                    checkbox.dataset.checked === 'false';\n                // The only time a click on the check-all checkbox should check all is\n                // when it was previously unchecked; otherwise, if the checkbox was\n                // either checked (all selected) or indeterminate (some selected), the\n                // click should clear all.\n                if (previouslyUnchecked) {\n                    // Select all items\n                    this._sortedItems.forEach((item) => (this.selection[item.path] = true));\n                }\n                else {\n                    // Unselect all items\n                    this.clearSelectedItems();\n                }\n                this.update();\n            }\n            else {\n                const state = this.renderer.handleHeaderClick(header, event);\n                if (state) {\n                    this.sort(state);\n                }\n            }\n            return;\n        }\n        else {\n            // Focus the selected file on click to ensure a couple of things:\n            // 1. If a user clicks on the item node, its name node will receive focus.\n            // 2. If a user clicks on blank space in the directory listing, the\n            //    previously focussed item will be focussed.\n            this._focusItem(this._focusIndex);\n        }\n    }\n    /**\n     * Handle the `'scroll'` event for the widget.\n     */\n    _evtScroll(event) {\n        this.headerNode.scrollLeft = this.contentNode.scrollLeft;\n    }\n    /**\n     * Handle the `'mousedown'` event for the widget.\n     */\n    _evtMousedown(event) {\n        // Bail if clicking within the edit node\n        if (event.target === this._editNode) {\n            return;\n        }\n        // Blur the edit node if necessary.\n        if (this._editNode.parentNode) {\n            if (this._editNode !== event.target) {\n                this._editNode.focus();\n                this._editNode.blur();\n                clearTimeout(this._selectTimer);\n            }\n            else {\n                return;\n            }\n        }\n        let index = Private.hitTestNodes(this._items, event);\n        if (index === -1) {\n            // Left mouse press for drag or resize start.\n            if (event.button === 0) {\n                const resizeHandle = event.target;\n                if (resizeHandle instanceof HTMLElement &&\n                    resizeHandle.classList.contains(RESIZE_HANDLE_CLASS)) {\n                    const columnId = resizeHandle.dataset.column;\n                    if (!columnId) {\n                        throw Error('Column resize handle is missing data-column attribute');\n                    }\n                    const column = DirListing.columns.find(c => c.id === columnId);\n                    if (!column) {\n                        throw Error(`Column with identifier ${columnId} not found`);\n                    }\n                    const element = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(this.node, column.className);\n                    resizeHandle.classList.add(ACTIVE_CLASS);\n                    const cursorOverride = _lumino_dragdrop__WEBPACK_IMPORTED_MODULE_10__.Drag.overrideCursor('col-resize');\n                    this._resizeData = {\n                        pressX: event.clientX,\n                        column: columnId,\n                        initialSize: element.getBoundingClientRect().width,\n                        overrides: new _lumino_disposable__WEBPACK_IMPORTED_MODULE_9__.DisposableDelegate(() => {\n                            cursorOverride.dispose();\n                            resizeHandle.classList.remove(ACTIVE_CLASS);\n                        })\n                    };\n                    document.addEventListener('mouseup', this, true);\n                    document.addEventListener('mousemove', this, true);\n                    return;\n                }\n            }\n            return;\n        }\n        this.handleFileSelect(event);\n        if (event.button !== 0) {\n            clearTimeout(this._selectTimer);\n        }\n        // Check for clearing a context menu.\n        const newContext = (IS_MAC && event.ctrlKey) || event.button === 2;\n        if (newContext) {\n            return;\n        }\n        // Left mouse press for drag or resize start.\n        if (event.button === 0) {\n            this._dragData = {\n                pressX: event.clientX,\n                pressY: event.clientY,\n                index: index\n            };\n            document.addEventListener('mouseup', this, true);\n            document.addEventListener('mousemove', this, true);\n        }\n        if (this._allowSingleClick) {\n            this.evtDblClick(event);\n        }\n    }\n    /**\n     * Handle the `'mouseup'` event for the widget.\n     */\n    _evtMouseup(event) {\n        // Handle any soft selection from the previous mouse down.\n        if (this._softSelection) {\n            const altered = event.metaKey || event.shiftKey || event.ctrlKey;\n            // See if we need to clear the other selection.\n            if (!altered && event.button === 0) {\n                this.clearSelectedItems();\n                this.selection[this._softSelection] = true;\n                this.update();\n            }\n            this._softSelection = '';\n        }\n        // Re-focus. This is needed because nodes corresponding to files selected in\n        // mousedown handler will not retain the focus as mousedown event is always\n        // followed by a blur/focus event.\n        if (event.button === 0) {\n            this._focusItem(this._focusIndex);\n        }\n        // Remove the resize listeners if necessary.\n        if (this._resizeData) {\n            this._resizeData.overrides.dispose();\n            this._resizeData = null;\n            document.removeEventListener('mousemove', this, true);\n            document.removeEventListener('mouseup', this, true);\n            return;\n        }\n        // Remove the drag listeners if necessary.\n        if (event.button !== 0 || !this._drag) {\n            document.removeEventListener('mousemove', this, true);\n            document.removeEventListener('mouseup', this, true);\n            return;\n        }\n        event.preventDefault();\n        event.stopPropagation();\n    }\n    /**\n     * Handle the `'mousemove'` event for the widget.\n     */\n    _evtMousemove(event) {\n        event.preventDefault();\n        event.stopPropagation();\n        if (this._resizeData) {\n            const { initialSize, column, pressX } = this._resizeData;\n            this._setColumnSize(column, initialSize + event.clientX - pressX);\n            return;\n        }\n        // Bail if we are the one dragging.\n        if (this._drag || !this._dragData) {\n            return;\n        }\n        // Check for a drag initialization.\n        const data = this._dragData;\n        const dx = Math.abs(event.clientX - data.pressX);\n        const dy = Math.abs(event.clientY - data.pressY);\n        if (dx < DRAG_THRESHOLD && dy < DRAG_THRESHOLD) {\n            return;\n        }\n        this._startDrag(data.index, event.clientX, event.clientY);\n    }\n    /**\n     * Handle the opening of an item.\n     */\n    handleOpen(item) {\n        this._onItemOpened.emit(item);\n        if (item.type === 'directory') {\n            const localPath = this._manager.services.contents.localPath(item.path);\n            this._model\n                .cd(`/${localPath}`)\n                .catch(error => (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans._p('showErrorMessage', 'Open directory'), error));\n        }\n        else {\n            const path = item.path;\n            this._manager.openOrReveal(path);\n        }\n    }\n    /**\n     * Calculate the next focus index, given the current focus index and a\n     * direction, keeping within the bounds of the directory listing.\n     *\n     * @param index Current focus index\n     * @param direction -1 (up) or 1 (down)\n     * @returns The next focus index, which could be the same as the current focus\n     * index if at the boundary.\n     */\n    _getNextFocusIndex(index, direction) {\n        const nextIndex = index + direction;\n        if (nextIndex === -1 || nextIndex === this._items.length) {\n            // keep focus index within bounds\n            return index;\n        }\n        else {\n            return nextIndex;\n        }\n    }\n    /**\n     * Handle the up or down arrow key.\n     *\n     * @param event The keyboard event\n     * @param direction -1 (up) or 1 (down)\n     */\n    _handleArrowY(event, direction) {\n        // We only handle the `ctrl` and `shift` modifiers. If other modifiers are\n        // present, then do nothing.\n        if (event.altKey || event.metaKey) {\n            return;\n        }\n        // If folder is empty, there's nothing to do with the up/down key.\n        if (!this._items.length) {\n            return;\n        }\n        // Don't handle the arrow key press if it's not on directory item. This\n        // avoids a confusing user experience that can result from when the user\n        // moves the selection and focus index apart (via ctrl + up/down). The last\n        // selected item remains highlighted but the last focussed item loses its\n        // focus ring if it's not actively focussed.  This forces the user to\n        // visibly reveal the last focussed item before moving the focus.\n        if (!event.target.classList.contains(ITEM_TEXT_CLASS)) {\n            return;\n        }\n        event.stopPropagation();\n        event.preventDefault();\n        const focusIndex = this._focusIndex;\n        let nextFocusIndex = this._getNextFocusIndex(focusIndex, direction);\n        // The following if-block allows the first press of the down arrow to select\n        // the first (rather than the second) file/directory in the list. This is\n        // the situation when the page first loads or when a user changes directory.\n        if (direction > 0 &&\n            focusIndex === 0 &&\n            !event.ctrlKey &&\n            Object.keys(this.selection).length === 0) {\n            nextFocusIndex = 0;\n        }\n        // Shift key indicates multi-selection. Either the user is trying to grow\n        // the selection, or shrink it.\n        if (event.shiftKey) {\n            this._handleMultiSelect(nextFocusIndex);\n        }\n        else if (!event.ctrlKey) {\n            // If neither the shift nor ctrl keys were used with the up/down arrow,\n            // then we treat it as a normal, unmodified key press and select the\n            // next item.\n            this._selectItem(nextFocusIndex, event.shiftKey, false /* focus = false because we call focus method directly following this */);\n        }\n        this._focusItem(nextFocusIndex);\n        this.update();\n    }\n    /**\n     * cd ..\n     *\n     * Go up one level in the directory tree.\n     */\n    async goUp() {\n        const model = this.model;\n        if (model.path === model.rootPath) {\n            return;\n        }\n        try {\n            await model.cd('..');\n        }\n        catch (reason) {\n            console.warn(`Failed to go to parent directory of ${model.path}`, reason);\n        }\n    }\n    /**\n     * Handle the `'keydown'` event for the widget.\n     */\n    evtKeydown(event) {\n        // Do not handle any keydown events here if in the middle of a file rename.\n        if (this._inRename) {\n            return;\n        }\n        switch (event.keyCode) {\n            case 13: {\n                // Enter\n                // Do nothing if any modifier keys are pressed.\n                if (event.ctrlKey || event.shiftKey || event.altKey || event.metaKey) {\n                    return;\n                }\n                event.preventDefault();\n                event.stopPropagation();\n                for (const item of this.selectedItems()) {\n                    this.handleOpen(item);\n                }\n                return;\n            }\n            case 38:\n                // Up arrow\n                this._handleArrowY(event, -1);\n                return;\n            case 40:\n                // Down arrow\n                this._handleArrowY(event, 1);\n                return;\n            case 32: {\n                // Space\n                if (event.ctrlKey) {\n                    // Follow the Windows and Ubuntu convention: you must press `ctrl` +\n                    // `space` in order to toggle whether an item is selected.\n                    // However, do not handle if any other modifiers were pressed.\n                    if (event.metaKey || event.shiftKey || event.altKey) {\n                        return;\n                    }\n                    // Make sure the ctrl+space key stroke was on a valid, focussed target.\n                    const node = this._items[this._focusIndex];\n                    if (!(\n                    // Event must have occurred within a node whose item can be toggled.\n                    (node.contains(event.target) &&\n                        // That node must also contain the currently focussed element.\n                        node.contains(document.activeElement)))) {\n                        return;\n                    }\n                    event.stopPropagation();\n                    // Prevent default, otherwise the container will scroll.\n                    event.preventDefault();\n                    // Toggle item selected\n                    const { path } = this._sortedItems[this._focusIndex];\n                    if (this.selection[path]) {\n                        delete this.selection[path];\n                    }\n                    else {\n                        this.selection[path] = true;\n                    }\n                    this.update();\n                    // Key was handled, so return.\n                    return;\n                }\n                break;\n            }\n        }\n        // Detects printable characters typed by the user.\n        // Not all browsers support .key, but it discharges us from reconstructing\n        // characters from key codes.\n        if (event.key !== undefined &&\n            event.key.length === 1 &&\n            // Don't gobble up the space key on the check-all checkbox (which the\n            // browser treats as a click event).\n            !((event.key === ' ' || event.keyCode === 32) &&\n                event.target.type === 'checkbox')) {\n            if (event.ctrlKey || event.shiftKey || event.altKey || event.metaKey) {\n                return;\n            }\n            this._searchPrefix += event.key;\n            clearTimeout(this._searchPrefixTimer);\n            this._searchPrefixTimer = window.setTimeout(() => {\n                this._searchPrefix = '';\n            }, PREFIX_APPEND_DURATION);\n            this.selectByPrefix();\n            event.stopPropagation();\n            event.preventDefault();\n        }\n    }\n    /**\n     * Handle the `'dblclick'` event for the widget.\n     */\n    evtDblClick(event) {\n        // Do nothing if it's not a left mouse press.\n        if (event.button !== 0) {\n            return;\n        }\n        // Do nothing if any modifier keys are pressed.\n        if (event.ctrlKey || event.shiftKey || event.altKey || event.metaKey) {\n            return;\n        }\n        // Do nothing if the double click is on a checkbox. (Otherwise a rapid\n        // check-uncheck on the checkbox will cause the adjacent file/folder to\n        // open, which is probably not what the user intended.)\n        if (this.isWithinCheckboxHitArea(event)) {\n            return;\n        }\n        // Stop the event propagation.\n        event.preventDefault();\n        event.stopPropagation();\n        clearTimeout(this._selectTimer);\n        this._editNode.blur();\n        // Find a valid double click target.\n        const target = event.target;\n        const i = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_6__.ArrayExt.findFirstIndex(this._items, node => node.contains(target));\n        if (i === -1) {\n            return;\n        }\n        const item = this._sortedItems[i];\n        this.handleOpen(item);\n    }\n    /**\n     * Handle the `drop` event for the widget.\n     */\n    evtNativeDrop(event) {\n        var _a, _b, _c;\n        // Prevent navigation\n        event.preventDefault();\n        const items = (_a = event.dataTransfer) === null || _a === void 0 ? void 0 : _a.items;\n        if (!items) {\n            // Fallback to simple upload of files (if any)\n            const files = (_b = event.dataTransfer) === null || _b === void 0 ? void 0 : _b.files;\n            if (!files || files.length === 0) {\n                return;\n            }\n            const promises = [];\n            for (const file of files) {\n                const promise = this._model.upload(file);\n                promises.push(promise);\n            }\n            Promise.all(promises)\n                .then(() => this._allUploaded.emit())\n                .catch(err => {\n                console.error('Error while uploading files: ', err);\n            });\n            return;\n        }\n        const uploadEntry = async (entry, path) => {\n            if (Private.isDirectoryEntry(entry)) {\n                const dirPath = await Private.createDirectory(this._model.manager, path, entry.name);\n                const directoryReader = entry.createReader();\n                const allEntries = await Private.collectEntries(directoryReader);\n                for (const childEntry of allEntries) {\n                    await uploadEntry(childEntry, dirPath);\n                }\n            }\n            else if (Private.isFileEntry(entry)) {\n                const file = await Private.readFile(entry);\n                await this._model.upload(file, path);\n            }\n        };\n        const promises = [];\n        for (const item of items) {\n            const entry = Private.defensiveGetAsEntry(item);\n            if (!entry) {\n                continue;\n            }\n            const promise = uploadEntry(entry, (_c = this._model.path) !== null && _c !== void 0 ? _c : '/');\n            promises.push(promise);\n        }\n        Promise.all(promises)\n            .then(() => this._allUploaded.emit())\n            .catch(err => {\n            console.error('Error while uploading files: ', err);\n        });\n    }\n    /**\n     * Signal emitted on when all files were uploaded after native drag.\n     */\n    get allUploaded() {\n        return this._allUploaded;\n    }\n    /**\n     * Handle the `'lm-dragenter'` event for the widget.\n     */\n    evtDragEnter(event) {\n        if (event.mimeData.hasData(CONTENTS_MIME)) {\n            const index = Private.hitTestNodes(this._items, event);\n            if (index === -1) {\n                return;\n            }\n            const item = this._sortedItems[index];\n            if (item.type !== 'directory' || this.selection[item.path]) {\n                return;\n            }\n            const target = event.target;\n            target.classList.add(DROP_TARGET_CLASS);\n            event.preventDefault();\n            event.stopPropagation();\n        }\n    }\n    /**\n     * Handle the `'lm-dragleave'` event for the widget.\n     */\n    evtDragLeave(event) {\n        event.preventDefault();\n        event.stopPropagation();\n        const dropTarget = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(this.node, DROP_TARGET_CLASS);\n        if (dropTarget) {\n            dropTarget.classList.remove(DROP_TARGET_CLASS);\n        }\n    }\n    /**\n     * Handle the `'lm-dragover'` event for the widget.\n     */\n    evtDragOver(event) {\n        event.preventDefault();\n        event.stopPropagation();\n        event.dropAction = event.proposedAction;\n        const dropTarget = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(this.node, DROP_TARGET_CLASS);\n        if (dropTarget) {\n            dropTarget.classList.remove(DROP_TARGET_CLASS);\n        }\n        const index = Private.hitTestNodes(this._items, event);\n        this._items[index].classList.add(DROP_TARGET_CLASS);\n    }\n    /**\n     * Handle the `'lm-drop'` event for the widget.\n     */\n    evtDrop(event) {\n        event.preventDefault();\n        event.stopPropagation();\n        clearTimeout(this._selectTimer);\n        if (event.proposedAction === 'none') {\n            event.dropAction = 'none';\n            return;\n        }\n        if (!event.mimeData.hasData(CONTENTS_MIME)) {\n            return;\n        }\n        let target = event.target;\n        while (target && target.parentElement) {\n            if (target.classList.contains(DROP_TARGET_CLASS)) {\n                target.classList.remove(DROP_TARGET_CLASS);\n                break;\n            }\n            target = target.parentElement;\n        }\n        // Get the path based on the target node.\n        const index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_6__.ArrayExt.firstIndexOf(this._items, target);\n        const items = this._sortedItems;\n        let basePath = this._model.path;\n        if (items[index].type === 'directory') {\n            basePath = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.join(basePath, items[index].name);\n        }\n        const manager = this._manager;\n        // Handle the items.\n        const promises = [];\n        const paths = event.mimeData.getData(CONTENTS_MIME);\n        if (event.ctrlKey && event.proposedAction === 'move') {\n            event.dropAction = 'copy';\n        }\n        else {\n            event.dropAction = event.proposedAction;\n        }\n        for (const path of paths) {\n            const localPath = manager.services.contents.localPath(path);\n            const name = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.basename(localPath);\n            const newPath = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.join(basePath, name);\n            // Skip files that are not moving.\n            if (newPath === path) {\n                continue;\n            }\n            if (event.dropAction === 'copy') {\n                promises.push(manager.copy(path, basePath));\n            }\n            else {\n                promises.push((0,_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__.renameFile)(manager, path, newPath));\n            }\n        }\n        Promise.all(promises).catch(error => {\n            void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans._p('showErrorMessage', 'Error while copying/moving files'), error);\n        });\n    }\n    /**\n     * Start a drag event.\n     */\n    _startDrag(index, clientX, clientY) {\n        let selectedPaths = Object.keys(this.selection);\n        const source = this._items[index];\n        const items = this._sortedItems;\n        let selectedItems;\n        let item;\n        // If the source node is not selected, use just that node.\n        if (!source.classList.contains(SELECTED_CLASS)) {\n            item = items[index];\n            selectedPaths = [item.path];\n            selectedItems = [item];\n        }\n        else {\n            const path = selectedPaths[0];\n            item = items.find(value => value.path === path);\n            selectedItems = this.selectedItems();\n        }\n        if (!item) {\n            return;\n        }\n        // Create the drag image.\n        const ft = this._manager.registry.getFileTypeForModel(item);\n        const dragImage = this.renderer.createDragImage(source, selectedPaths.length, this._trans, ft);\n        // Set up the drag event.\n        this._drag = new _lumino_dragdrop__WEBPACK_IMPORTED_MODULE_10__.Drag({\n            dragImage,\n            mimeData: new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_7__.MimeData(),\n            supportedActions: 'move',\n            proposedAction: 'move'\n        });\n        this._drag.mimeData.setData(CONTENTS_MIME, selectedPaths);\n        // Add thunks for getting mime data content.\n        // We thunk the content so we don't try to make a network call\n        // when it's not needed. E.g. just moving files around\n        // in a filebrowser\n        const services = this.model.manager.services;\n        for (const item of selectedItems) {\n            this._drag.mimeData.setData(CONTENTS_MIME_RICH, {\n                model: item,\n                withContent: async () => {\n                    return await services.contents.get(item.path);\n                }\n            });\n        }\n        if (item && item.type !== 'directory') {\n            const otherPaths = selectedPaths.slice(1).reverse();\n            this._drag.mimeData.setData(FACTORY_MIME, () => {\n                if (!item) {\n                    return;\n                }\n                const path = item.path;\n                let widget = this._manager.findWidget(path);\n                if (!widget) {\n                    widget = this._manager.open(item.path);\n                }\n                if (otherPaths.length) {\n                    const firstWidgetPlaced = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_7__.PromiseDelegate();\n                    void firstWidgetPlaced.promise.then(() => {\n                        let prevWidget = widget;\n                        otherPaths.forEach(path => {\n                            const options = {\n                                ref: prevWidget === null || prevWidget === void 0 ? void 0 : prevWidget.id,\n                                mode: 'tab-after'\n                            };\n                            prevWidget = this._manager.openOrReveal(path, void 0, void 0, options);\n                            this._manager.openOrReveal(item.path);\n                        });\n                    });\n                    firstWidgetPlaced.resolve(void 0);\n                }\n                return widget;\n            });\n        }\n        // Start the drag and remove the mousemove and mouseup listeners.\n        document.removeEventListener('mousemove', this, true);\n        document.removeEventListener('mouseup', this, true);\n        clearTimeout(this._selectTimer);\n        void this._drag.start(clientX, clientY).then(action => {\n            this._drag = null;\n            clearTimeout(this._selectTimer);\n        });\n    }\n    /**\n     * Handle selection on a file node.\n     */\n    handleFileSelect(event) {\n        // Fetch common variables.\n        const items = this._sortedItems;\n        const index = Private.hitTestNodes(this._items, event);\n        clearTimeout(this._selectTimer);\n        if (index === -1) {\n            return;\n        }\n        // Clear any existing soft selection.\n        this._softSelection = '';\n        const path = items[index].path;\n        const selected = Object.keys(this.selection);\n        const isLeftClickOnCheckbox = event.button === 0 &&\n            // On Mac, a left-click with the ctrlKey is treated as a right-click.\n            !(IS_MAC && event.ctrlKey) &&\n            this.isWithinCheckboxHitArea(event);\n        // Handle toggling.\n        if ((IS_MAC && event.metaKey) ||\n            (!IS_MAC && event.ctrlKey) ||\n            isLeftClickOnCheckbox) {\n            if (this.selection[path]) {\n                delete this.selection[path];\n            }\n            else {\n                this.selection[path] = true;\n            }\n            this._focusItem(index);\n            // Handle multiple select.\n        }\n        else if (event.shiftKey) {\n            this._handleMultiSelect(index);\n            this._focusItem(index);\n            // Handle a 'soft' selection\n        }\n        else if (path in this.selection && selected.length > 1) {\n            this._softSelection = path;\n            // Default to selecting the only the item.\n        }\n        else {\n            // Select only the given item.\n            return this._selectItem(index, false, true);\n        }\n        this.update();\n    }\n    /**\n     * (Re-)focus an item in the directory listing.\n     *\n     * @param index The index of the item node to focus\n     */\n    _focusItem(index) {\n        const items = this._items;\n        if (items.length === 0) {\n            // Focus the top node if the folder is empty and therefore there are no\n            // items inside the folder to focus.\n            this._focusIndex = 0;\n            this.node.focus();\n            return;\n        }\n        this._focusIndex = index;\n        const node = items[index];\n        const nameNode = this.renderer.getNameNode(node);\n        if (nameNode) {\n            // Make the filename text node focusable so that it receives keyboard\n            // events; text node was specifically chosen to receive shortcuts because\n            // it gets substituted with input element during file name edits which\n            // conveniently deactivates irrelevant shortcuts.\n            nameNode.tabIndex = 0;\n            nameNode.focus();\n        }\n    }\n    /**\n     * Are all of the items between two provided indices selected?\n     *\n     * The items at the indices are not considered.\n     *\n     * @param j Index of one item.\n     * @param k Index of another item. Note: may be less or greater than first\n     *          index.\n     * @returns True if and only if all items between the j and k are selected.\n     *          Returns undefined if j and k are the same.\n     */\n    _allSelectedBetween(j, k) {\n        if (j === k) {\n            return;\n        }\n        const [start, end] = j < k ? [j + 1, k] : [k + 1, j];\n        return this._sortedItems\n            .slice(start, end)\n            .reduce((result, item) => result && this.selection[item.path], true);\n    }\n    /**\n     * Handle a multiple select on a file item node.\n     */\n    _handleMultiSelect(index) {\n        const items = this._sortedItems;\n        const fromIndex = this._focusIndex;\n        const target = items[index];\n        let shouldAdd = true;\n        if (index === fromIndex) {\n            // This follows the convention in Ubuntu and Windows, which is to allow\n            // the focussed item to gain but not lose selected status on shift-click.\n            // (MacOS is irrelevant here because MacOS Finder has no notion of a\n            // focused-but-not-selected state.)\n            this.selection[target.path] = true;\n            return;\n        }\n        // If the target and all items in-between are selected, then we assume that\n        // the user is trying to shrink rather than grow the group of selected\n        // items.\n        if (this.selection[target.path]) {\n            // However, there is a special case when the distance between the from-\n            // and to- index is just one (for example, when the user is pressing the\n            // shift key plus arrow-up/down). If and only if the situation looks like\n            // the following when going down (or reverse when going up) ...\n            //\n            // - [ante-anchor / previous item] unselected (or boundary)\n            // - [anchor / currently focussed item / item at from-index] selected\n            // - [target / next item / item at to-index] selected\n            //\n            // ... then we shrink the selection / unselect the currently focussed\n            // item.\n            if (Math.abs(index - fromIndex) === 1) {\n                const anchor = items[fromIndex];\n                const anteAnchor = items[fromIndex + (index < fromIndex ? 1 : -1)];\n                if (\n                // Currently focussed item is selected\n                this.selection[anchor.path] &&\n                    // Item on other side of focussed item (away from target) is either a\n                    // boundary or unselected\n                    (!anteAnchor || !this.selection[anteAnchor.path])) {\n                    delete this.selection[anchor.path];\n                }\n            }\n            else if (this._allSelectedBetween(fromIndex, index)) {\n                shouldAdd = false;\n            }\n        }\n        // Select (or unselect) the rows between chosen index (target) and the last\n        // focussed.\n        const step = fromIndex < index ? 1 : -1;\n        for (let i = fromIndex; i !== index + step; i += step) {\n            if (shouldAdd) {\n                if (i === fromIndex) {\n                    // Do not change the selection state of the starting (fromIndex) item.\n                    continue;\n                }\n                this.selection[items[i].path] = true;\n            }\n            else {\n                if (i === index) {\n                    // Do not unselect the target item.\n                    continue;\n                }\n                delete this.selection[items[i].path];\n            }\n        }\n    }\n    /**\n     * Copy the selected items, and optionally cut as well.\n     */\n    _copy() {\n        this._clipboard.length = 0;\n        for (const item of this.selectedItems()) {\n            this._clipboard.push(item.path);\n        }\n    }\n    /**\n     * Delete the files with the given paths.\n     */\n    async _delete(paths) {\n        await Promise.all(paths.map(path => this._model.manager.deleteFile(path).catch(err => {\n            void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans._p('showErrorMessage', 'Delete Failed'), err);\n        })));\n    }\n    /**\n     * Allow the user to rename item on a given row.\n     */\n    async _doRename() {\n        this._inRename = true;\n        const selectedPaths = Object.keys(this.selection);\n        // Bail out if nothing has been selected.\n        if (selectedPaths.length === 0) {\n            this._inRename = false;\n            return Promise.resolve('');\n        }\n        // Figure out which selected path to use for the rename.\n        const items = this._sortedItems;\n        let { path } = items[this._focusIndex];\n        if (!this.selection[path]) {\n            // If the currently focused item is not selected, then choose the last\n            // selected item.\n            path = selectedPaths.slice(-1)[0];\n        }\n        // Get the corresponding model, nodes, and file name.\n        const index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_6__.ArrayExt.findFirstIndex(items, value => value.path === path);\n        const row = this._items[index];\n        const item = items[index];\n        const nameNode = this.renderer.getNameNode(row);\n        const original = item.name;\n        // Seed the text input with current file name, and select and focus it.\n        this._editNode.value = original;\n        this._selectItem(index, false, true);\n        // Wait for user input\n        const newName = await Private.userInputForRename(nameNode, this._editNode, original);\n        // Check if the widget was disposed during the `await`.\n        if (this.isDisposed) {\n            this._inRename = false;\n            throw new Error('File browser is disposed.');\n        }\n        let finalFilename = newName;\n        if (!newName || newName === original) {\n            finalFilename = original;\n        }\n        else if (!(0,_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__.isValidFileName)(newName)) {\n            void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans.__('Rename Error'), Error(this._trans._p('showErrorMessage', '\"%1\" is not a valid name for a file. Names must have nonzero length, and cannot include \"/\", \"\\\\\", or \":\"', newName)));\n            finalFilename = original;\n        }\n        else {\n            // Attempt rename at the file system level.\n            const manager = this._manager;\n            const oldPath = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.join(this._model.path, original);\n            const newPath = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.join(this._model.path, newName);\n            try {\n                await (0,_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__.renameFile)(manager, oldPath, newPath);\n            }\n            catch (error) {\n                if (error !== 'File not renamed') {\n                    void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans._p('showErrorMessage', 'Rename Error'), error);\n                }\n                finalFilename = original;\n            }\n            // Check if the widget was disposed during the `await`.\n            if (this.isDisposed) {\n                this._inRename = false;\n                throw new Error('File browser is disposed.');\n            }\n        }\n        // If nothing else has been selected, then select the renamed file. In\n        // other words, don't select the renamed file if the user has clicked\n        // away to some other file.\n        if (!this.isDisposed &&\n            Object.keys(this.selection).length === 1 &&\n            // We haven't updated the instance yet to reflect the rename, so unless\n            // the user or something else has updated the selection, the original file\n            // path and not the new file path will be in `this.selection`.\n            this.selection[item.path]) {\n            try {\n                await this._selectItemByName(finalFilename, true, true);\n            }\n            catch (_a) {\n                // do nothing\n                console.warn('After rename, failed to select file', finalFilename);\n            }\n        }\n        this._inRename = false;\n        return finalFilename;\n    }\n    /**\n     * Select a given item.\n     */\n    _selectItem(index, keepExisting, focus = true) {\n        // Selected the given row(s)\n        const items = this._sortedItems;\n        if (!keepExisting) {\n            this.clearSelectedItems();\n        }\n        const path = items[index].path;\n        this.selection[path] = true;\n        if (focus) {\n            this._focusItem(index);\n        }\n        this.update();\n    }\n    /**\n     * Handle the `refreshed` signal from the model.\n     */\n    _onModelRefreshed() {\n        // Update the selection.\n        const existing = Object.keys(this.selection);\n        this.clearSelectedItems();\n        for (const item of this._model.items()) {\n            const path = item.path;\n            if (existing.indexOf(path) !== -1) {\n                this.selection[path] = true;\n            }\n        }\n        if (this.isVisible) {\n            // Update the sorted items.\n            this.sort(this.sortState);\n        }\n        else {\n            this._isDirty = true;\n        }\n    }\n    /**\n     * Handle a `pathChanged` signal from the model.\n     */\n    _onPathChanged() {\n        // Reset the selection.\n        this.clearSelectedItems();\n        // Update the sorted items.\n        this.sort(this.sortState);\n        // Reset focus. But wait until the DOM has been updated (hence\n        // `requestAnimationFrame`).\n        requestAnimationFrame(() => {\n            this._focusItem(0);\n        });\n    }\n    /**\n     * Handle a `fileChanged` signal from the model.\n     */\n    _onFileChanged(sender, args) {\n        const newValue = args.newValue;\n        if (!newValue) {\n            return;\n        }\n        const name = newValue.name;\n        if (args.type !== 'new' || !name) {\n            return;\n        }\n        void this.selectItemByName(name).catch(() => {\n            /* Ignore if file does not exist. */\n        });\n    }\n    /**\n     * Handle an `activateRequested` signal from the manager.\n     */\n    _onActivateRequested(sender, args) {\n        const dirname = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.dirname(args);\n        if (dirname !== this._model.path) {\n            return;\n        }\n        const basename = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.basename(args);\n        this.selectItemByName(basename).catch(() => {\n            /* Ignore if file does not exist. */\n        });\n    }\n}\n/**\n * The namespace for the `DirListing` class statics.\n */\n(function (DirListing) {\n    /**\n     * Column definitions.\n     */\n    DirListing.columns = [\n        {\n            id: 'is_selected',\n            className: CHECKBOX_WRAPPER_CLASS,\n            itemClassName: CHECKBOX_WRAPPER_CLASS,\n            minWidth: 18,\n            resizable: false,\n            sortable: false,\n            grow: 0\n        },\n        {\n            id: 'name',\n            className: NAME_ID_CLASS,\n            itemClassName: ITEM_NAME_COLUMN_CLASS,\n            minWidth: 60,\n            resizable: true,\n            sortable: true,\n            caretSide: 'right',\n            grow: 3\n        },\n        {\n            id: 'last_modified',\n            className: MODIFIED_ID_CLASS,\n            itemClassName: ITEM_MODIFIED_CLASS,\n            minWidth: 60,\n            resizable: true,\n            sortable: true,\n            caretSide: 'left',\n            grow: 1\n        },\n        {\n            id: 'file_size',\n            className: FILE_SIZE_ID_CLASS,\n            itemClassName: ITEM_FILE_SIZE_CLASS,\n            minWidth: 60,\n            resizable: true,\n            sortable: true,\n            caretSide: 'left',\n            grow: 0.5\n        }\n    ];\n    /**\n     * The default implementation of an `IRenderer`.\n     */\n    class Renderer {\n        constructor() {\n            /**\n             * Factories for individual parts of the item.\n             */\n            this.itemFactories = {\n                name: () => {\n                    const name = document.createElement('span');\n                    const icon = document.createElement('span');\n                    const text = document.createElement('span');\n                    icon.className = ITEM_ICON_CLASS;\n                    text.className = ITEM_TEXT_CLASS;\n                    name.className = ITEM_NAME_COLUMN_CLASS;\n                    name.appendChild(icon);\n                    name.appendChild(text);\n                    return name;\n                },\n                last_modified: () => {\n                    const modified = document.createElement('span');\n                    modified.className = ITEM_MODIFIED_CLASS;\n                    return modified;\n                },\n                file_size: () => {\n                    const fileSize = document.createElement('span');\n                    fileSize.className = ITEM_FILE_SIZE_CLASS;\n                    return fileSize;\n                },\n                is_selected: () => this.createCheckboxWrapperNode()\n            };\n            /**\n             * Register of most recent arguments for last modified column update.\n             */\n            this._modifiedColumnLastUpdate = new WeakMap();\n        }\n        /**\n         * Create the DOM node for a dir listing.\n         */\n        createNode() {\n            const node = document.createElement('div');\n            const header = document.createElement('div');\n            const content = document.createElement('ul');\n            // Allow the node to scroll while dragging items.\n            content.setAttribute('data-lm-dragscroll', 'true');\n            content.className = CONTENT_CLASS;\n            header.className = HEADER_CLASS;\n            node.appendChild(header);\n            node.appendChild(content);\n            // Set to -1 to allow calling this.node.focus().\n            node.tabIndex = -1;\n            return node;\n        }\n        /**\n         * Populate and empty header node for a dir listing.\n         *\n         * @param node - The header node to populate.\n         */\n        populateHeaderNode(node, translator, hiddenColumns, columnsSizes) {\n            translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_4__.nullTranslator;\n            const trans = translator.load('jupyterlab');\n            const elementCreators = {\n                name: () => this.createHeaderItemNode(trans.__('Name')),\n                last_modified: () => this._createHeaderItemNodeWithSizes({\n                    small: trans.__('Modified'),\n                    large: trans.__('Last Modified')\n                }),\n                file_size: () => this._createHeaderItemNodeWithSizes({\n                    small: trans.__('Size'),\n                    large: trans.__('File Size')\n                }),\n                is_selected: () => this.createCheckboxWrapperNode({\n                    alwaysVisible: true,\n                    headerNode: true\n                })\n            };\n            const visibleColumns = DirListing.columns.filter(column => column.id === 'name' || !(hiddenColumns === null || hiddenColumns === void 0 ? void 0 : hiddenColumns.has(column.id)));\n            for (const column of visibleColumns) {\n                const createElement = elementCreators[column.id];\n                const element = createElement();\n                element.classList.add(column.className);\n                const isLastVisible = column.id === visibleColumns[visibleColumns.length - 1].id;\n                if (columnsSizes) {\n                    const size = columnsSizes[column.id];\n                    if (!isLastVisible) {\n                        element.style.width = size + 'px';\n                    }\n                }\n                node.appendChild(element);\n                if (Private.isResizable(column) && !isLastVisible) {\n                    const resizer = document.createElement('div');\n                    resizer.classList.add(RESIZE_HANDLE_CLASS);\n                    resizer.dataset.column = column.id;\n                    node.appendChild(resizer);\n                }\n            }\n            const name = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, NAME_ID_CLASS);\n            name.classList.add(SELECTED_CLASS);\n            // set the initial caret icon\n            Private.updateCaret(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(name, HEADER_ITEM_ICON_CLASS), 'right', 'up');\n        }\n        /**\n         * Handle a header click.\n         *\n         * @param node - A node populated by [[populateHeaderNode]].\n         *\n         * @param event - A click event on the node.\n         *\n         * @returns The sort state of the header after the click event.\n         */\n        handleHeaderClick(node, event) {\n            const state = { direction: 'ascending', key: 'name' };\n            const target = event.target;\n            const sortableColumns = DirListing.columns.filter(Private.isSortable);\n            for (const column of sortableColumns) {\n                const header = node.querySelector(`.${column.className}`);\n                if (!header) {\n                    // skip if the column is hidden\n                    continue;\n                }\n                if (header.contains(target)) {\n                    state.key = column.id;\n                    const headerIcon = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(header, HEADER_ITEM_ICON_CLASS);\n                    if (header.classList.contains(SELECTED_CLASS)) {\n                        if (!header.classList.contains(DESCENDING_CLASS)) {\n                            state.direction = 'descending';\n                            header.classList.add(DESCENDING_CLASS);\n                            Private.updateCaret(headerIcon, column.caretSide, 'down');\n                        }\n                        else {\n                            header.classList.remove(DESCENDING_CLASS);\n                            Private.updateCaret(headerIcon, column.caretSide, 'up');\n                        }\n                    }\n                    else {\n                        header.classList.remove(DESCENDING_CLASS);\n                        Private.updateCaret(headerIcon, column.caretSide, 'up');\n                    }\n                    header.classList.add(SELECTED_CLASS);\n                    for (const otherColumn of sortableColumns) {\n                        if (otherColumn.id === column.id) {\n                            continue;\n                        }\n                        const otherHeader = node.querySelector(`.${otherColumn.className}`);\n                        if (!otherHeader) {\n                            // skip if hidden\n                            continue;\n                        }\n                        otherHeader.classList.remove(SELECTED_CLASS);\n                        otherHeader.classList.remove(DESCENDING_CLASS);\n                        const otherHeaderIcon = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(otherHeader, HEADER_ITEM_ICON_CLASS);\n                        Private.updateCaret(otherHeaderIcon, otherColumn.caretSide);\n                    }\n                    return state;\n                }\n            }\n            return state;\n        }\n        /**\n         * Create a new item node for a dir listing.\n         *\n         * @returns A new DOM node to use as a content item.\n         */\n        createItemNode(hiddenColumns, columnsSizes) {\n            const node = document.createElement('li');\n            for (const column of DirListing.columns) {\n                if (column.id != 'name' && (hiddenColumns === null || hiddenColumns === void 0 ? void 0 : hiddenColumns.has(column.id))) {\n                    continue;\n                }\n                const createElement = this.itemFactories[column.id];\n                const element = createElement();\n                node.appendChild(element);\n                if (columnsSizes) {\n                    const size = columnsSizes[column.id];\n                    element.style.width = size + 'px';\n                }\n            }\n            return node;\n        }\n        /**\n         * Creates a node containing a checkbox.\n         *\n         * We wrap the checkbox in a label element in order to increase its hit\n         * area. This is because the padding of the checkbox itself cannot be\n         * increased via CSS, as the CSS/form compatibility table at the following\n         * url from MDN shows:\n         * https://developer.mozilla.org/en-US/docs/Learn/Forms/Property_compatibility_table_for_form_controls#check_boxes_and_radio_buttons\n         *\n         * @param [options]\n         * @params options.alwaysVisible Should the checkbox be visible even when\n         * not hovered?\n         * @returns A new DOM node that contains a checkbox.\n         */\n        createCheckboxWrapperNode(options) {\n            // Wrap the checkbox in a label element in order to increase its hit area.\n            const labelWrapper = document.createElement('label');\n            labelWrapper.classList.add(CHECKBOX_WRAPPER_CLASS);\n            const checkbox = document.createElement('input');\n            checkbox.type = 'checkbox';\n            // Prevent the user from clicking (via mouse, keyboard, or touch) the\n            // checkbox since other code handles the mouse and keyboard events and\n            // controls the checked state of the checkbox.\n            if (!(options === null || options === void 0 ? void 0 : options.headerNode)) {\n                checkbox.addEventListener('click', event => {\n                    event.preventDefault();\n                });\n            }\n            // The individual file checkboxes are visible on hover, but the header\n            // check-all checkbox is always visible.\n            if (options === null || options === void 0 ? void 0 : options.alwaysVisible) {\n                labelWrapper.classList.add('jp-mod-visible');\n            }\n            else {\n                // Disable tabbing to all other checkboxes.\n                checkbox.tabIndex = -1;\n            }\n            labelWrapper.appendChild(checkbox);\n            return labelWrapper;\n        }\n        /**\n         * Update an item's last modified date.\n         *\n         * @param modified - Element containing the file's last modified date.\n         *\n         * @param modifiedDate - String representation of the last modified date.\n         *\n         * @param modifiedStyle - The date style for the modified column: narrow, short, or long\n         */\n        updateItemModified(modified, modifiedDate, modifiedStyle) {\n            // Formatting dates is expensive (0.1-0.2ms per call,\n            // so over 150 files can easily already choke the renderer),\n            // let's do the bare minimum check of comparing if an update\n            // is needed using a last update cache:\n            const previousUpdate = this._modifiedColumnLastUpdate.get(modified);\n            if ((previousUpdate === null || previousUpdate === void 0 ? void 0 : previousUpdate.date) === modifiedDate &&\n                (previousUpdate === null || previousUpdate === void 0 ? void 0 : previousUpdate.style) === modifiedStyle) {\n                return;\n            }\n            const parsedDate = new Date(modifiedDate);\n            // Render the date in one of multiple formats, depending on the container's size\n            const modText = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.Time.formatHuman(parsedDate, modifiedStyle);\n            const modTitle = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.Time.format(parsedDate);\n            modified.textContent = modText;\n            modified.title = modTitle;\n            this._modifiedColumnLastUpdate.set(modified, {\n                date: modifiedDate,\n                style: modifiedStyle\n            });\n        }\n        /**\n         * Update an item node to reflect the current state of a model.\n         *\n         * @param node - A node created by [[createItemNode]].\n         *\n         * @param model - The model object to use for the item state.\n         *\n         * @param fileType - The file type of the item, if applicable.\n         *\n         */\n        updateItemNode(node, model, fileType, translator, hiddenColumns, selected, modifiedStyle, columnsSizes) {\n            if (selected) {\n                node.classList.add(SELECTED_CLASS);\n            }\n            fileType =\n                fileType || _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_3__.DocumentRegistry.getDefaultTextFileType(translator);\n            const { icon, iconClass, name } = fileType;\n            translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_4__.nullTranslator;\n            const trans = translator.load('jupyterlab');\n            const iconContainer = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, ITEM_ICON_CLASS);\n            const text = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, ITEM_TEXT_CLASS);\n            const nameColumn = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, ITEM_NAME_COLUMN_CLASS);\n            let modified = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, ITEM_MODIFIED_CLASS);\n            let fileSize = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, ITEM_FILE_SIZE_CLASS);\n            const checkboxWrapper = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, CHECKBOX_WRAPPER_CLASS);\n            const showFileCheckboxes = !(hiddenColumns === null || hiddenColumns === void 0 ? void 0 : hiddenColumns.has('is_selected'));\n            if (checkboxWrapper && !showFileCheckboxes) {\n                node.removeChild(checkboxWrapper);\n            }\n            else if (showFileCheckboxes && !checkboxWrapper) {\n                const checkboxWrapper = this.createCheckboxWrapperNode();\n                nameColumn.insertAdjacentElement('beforebegin', checkboxWrapper);\n            }\n            const showModified = !(hiddenColumns === null || hiddenColumns === void 0 ? void 0 : hiddenColumns.has('last_modified'));\n            if (modified && !showModified) {\n                node.removeChild(modified);\n            }\n            else if (showModified && !modified) {\n                modified = this.itemFactories.last_modified();\n                nameColumn.insertAdjacentElement('afterend', modified);\n            }\n            const showFileSize = !(hiddenColumns === null || hiddenColumns === void 0 ? void 0 : hiddenColumns.has('file_size'));\n            if (fileSize && !showFileSize) {\n                node.removeChild(fileSize);\n            }\n            else if (showFileSize && !fileSize) {\n                fileSize = this.itemFactories.file_size();\n                (modified !== null && modified !== void 0 ? modified : nameColumn).insertAdjacentElement('afterend', fileSize);\n            }\n            // render the file item's icon\n            _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_5__.LabIcon.resolveElement({\n                icon,\n                iconClass: (0,_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_5__.classes)(iconClass, 'jp-Icon'),\n                container: iconContainer,\n                className: ITEM_ICON_CLASS,\n                stylesheet: 'listing'\n            });\n            let hoverText = trans.__('Name: %1', model.name);\n            // add file size to pop up if its available\n            if (model.size !== null && model.size !== undefined) {\n                const fileSizeText = Private.formatFileSize(model.size, 1, 1024);\n                if (fileSize) {\n                    fileSize.textContent = fileSizeText;\n                }\n                hoverText += trans.__('\\nSize: %1', Private.formatFileSize(model.size, 1, 1024));\n            }\n            else if (fileSize) {\n                fileSize.textContent = '';\n            }\n            if (model.path) {\n                const dirname = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.dirname(model.path);\n                if (dirname) {\n                    hoverText += trans.__('\\nPath: %1', dirname.substr(0, 50));\n                    if (dirname.length > 50) {\n                        hoverText += '...';\n                    }\n                }\n            }\n            if (model.created) {\n                hoverText += trans.__('\\nCreated: %1', _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.Time.format(new Date(model.created)));\n            }\n            if (model.last_modified) {\n                hoverText += trans.__('\\nModified: %1', _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.Time.format(new Date(model.last_modified)));\n            }\n            hoverText += trans.__('\\nWritable: %1', model.writable);\n            node.title = hoverText;\n            node.setAttribute('data-file-type', name);\n            if (model.name.startsWith('.')) {\n                node.setAttribute('data-is-dot', 'true');\n            }\n            else {\n                node.removeAttribute('data-is-dot');\n            }\n            // If an item is being edited currently, its text node is unavailable.\n            const indices = !model.indices ? [] : model.indices;\n            let highlightedName = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_6__.StringExt.highlight(model.name, indices, _lumino_virtualdom__WEBPACK_IMPORTED_MODULE_13__.h.mark);\n            if (text) {\n                _lumino_virtualdom__WEBPACK_IMPORTED_MODULE_13__.VirtualDOM.render(_lumino_virtualdom__WEBPACK_IMPORTED_MODULE_13__.h.span(highlightedName), text);\n            }\n            // Adds an aria-label to the checkbox element.\n            const checkbox = checkboxWrapper === null || checkboxWrapper === void 0 ? void 0 : checkboxWrapper.querySelector('input[type=\"checkbox\"]');\n            if (checkbox) {\n                let ariaLabel;\n                if (fileType.contentType === 'directory') {\n                    ariaLabel = selected\n                        ? trans.__('Deselect directory \"%1\"', highlightedName)\n                        : trans.__('Select directory \"%1\"', highlightedName);\n                }\n                else {\n                    ariaLabel = selected\n                        ? trans.__('Deselect file \"%1\"', highlightedName)\n                        : trans.__('Select file \"%1\"', highlightedName);\n                }\n                checkbox.setAttribute('aria-label', ariaLabel);\n                checkbox.checked = selected !== null && selected !== void 0 ? selected : false;\n            }\n            this.updateItemSize(node, model, modifiedStyle, columnsSizes);\n        }\n        /**\n         * Update size of item nodes, assuming that model has not changed.\n         */\n        updateItemSize(node, model, modifiedStyle, columnsSizes) {\n            if (columnsSizes) {\n                for (const column of DirListing.columns) {\n                    const element = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, column.itemClassName);\n                    if (!element) {\n                        continue;\n                    }\n                    const sizeSpec = columnsSizes[column.id];\n                    const newWidth = sizeSpec === null ? '' : sizeSpec + 'px';\n                    if (newWidth !== element.style.width) {\n                        element.style.width = newWidth;\n                    }\n                }\n            }\n            let modified = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, ITEM_MODIFIED_CLASS);\n            if (model.last_modified && modified) {\n                this.updateItemModified(modified, model.last_modified, modifiedStyle !== null && modifiedStyle !== void 0 ? modifiedStyle : 'short');\n            }\n        }\n        /**\n         * Get the node containing the file name.\n         *\n         * @param node - A node created by [[createItemNode]].\n         *\n         * @returns The node containing the file name.\n         */\n        getNameNode(node) {\n            return _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, ITEM_TEXT_CLASS);\n        }\n        /**\n         * Get the checkbox input element node.\n         *\n         * @param node A node created by [[createItemNode]] or\n         * [[createHeaderItemNode]]\n         *\n         * @returns The checkbox node.\n         */\n        getCheckboxNode(node) {\n            return node.querySelector(`.${CHECKBOX_WRAPPER_CLASS} input[type=checkbox]`);\n        }\n        /**\n         * Create a drag image for an item.\n         *\n         * @param node - A node created by [[createItemNode]].\n         *\n         * @param count - The number of items being dragged.\n         *\n         * @param fileType - The file type of the item, if applicable.\n         *\n         * @returns An element to use as the drag image.\n         */\n        createDragImage(node, count, trans, fileType) {\n            const dragImage = node.cloneNode(true);\n            const icon = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(dragImage, ITEM_ICON_CLASS);\n            // Hide additional columns from the drag image to keep it unobtrusive.\n            const extraColumns = DirListing.columns.filter(column => column.id !== 'name');\n            for (const extraColumn of extraColumns) {\n                const columnElement = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(dragImage, extraColumn.itemClassName);\n                if (!columnElement) {\n                    // We can only remove columns which are rendered.\n                    continue;\n                }\n                dragImage.removeChild(columnElement);\n            }\n            if (!fileType) {\n                icon.textContent = '';\n                icon.className = '';\n            }\n            else {\n                icon.textContent = fileType.iconLabel || '';\n                icon.className = fileType.iconClass || '';\n            }\n            icon.classList.add(DRAG_ICON_CLASS);\n            if (count > 1) {\n                const nameNode = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(dragImage, ITEM_TEXT_CLASS);\n                nameNode.textContent = trans._n('%1 Item', '%1 Items', count);\n            }\n            return dragImage;\n        }\n        /**\n         * Create a node for a header item.\n         */\n        createHeaderItemNode(label) {\n            const node = document.createElement('div');\n            const text = document.createElement('span');\n            const icon = document.createElement('span');\n            node.className = HEADER_ITEM_CLASS;\n            text.className = HEADER_ITEM_TEXT_CLASS;\n            icon.className = HEADER_ITEM_ICON_CLASS;\n            text.textContent = label;\n            node.appendChild(text);\n            node.appendChild(icon);\n            return node;\n        }\n        /**\n         * Create a node for a header item with multiple sizes.\n         */\n        _createHeaderItemNodeWithSizes(labels) {\n            const node = document.createElement('div');\n            node.className = HEADER_ITEM_CLASS;\n            const icon = document.createElement('span');\n            icon.className = HEADER_ITEM_ICON_CLASS;\n            for (let k of Object.keys(labels)) {\n                const text = document.createElement('span');\n                text.classList.add(HEADER_ITEM_TEXT_CLASS, HEADER_ITEM_TEXT_CLASS + '-' + k);\n                text.textContent = labels[k];\n                node.appendChild(text);\n            }\n            node.appendChild(icon);\n            return node;\n        }\n    }\n    DirListing.Renderer = Renderer;\n    /**\n     * The default `IRenderer` instance.\n     */\n    DirListing.defaultRenderer = new Renderer();\n})(DirListing || (DirListing = {}));\n/**\n * The namespace for the listing private data.\n */\nvar Private;\n(function (Private) {\n    /**\n     * Handle editing text on a node.\n     *\n     * @returns Boolean indicating whether the name changed.\n     */\n    function userInputForRename(text, edit, original) {\n        const parent = text.parentElement;\n        parent.replaceChild(edit, text);\n        edit.focus();\n        const index = edit.value.lastIndexOf('.');\n        if (index === -1) {\n            edit.setSelectionRange(0, edit.value.length);\n        }\n        else {\n            edit.setSelectionRange(0, index);\n        }\n        return new Promise(resolve => {\n            edit.onblur = () => {\n                parent.replaceChild(text, edit);\n                resolve(edit.value);\n            };\n            edit.onkeydown = (event) => {\n                switch (event.keyCode) {\n                    case 13: // Enter\n                        event.stopPropagation();\n                        event.preventDefault();\n                        edit.blur();\n                        break;\n                    case 27: // Escape\n                        event.stopPropagation();\n                        event.preventDefault();\n                        edit.value = original;\n                        edit.blur();\n                        // Put focus back on the text node. That way the user can, for\n                        // example, press the keyboard shortcut to go back into edit mode,\n                        // and it will work.\n                        text.focus();\n                        break;\n                    default:\n                        break;\n                }\n            };\n        });\n    }\n    Private.userInputForRename = userInputForRename;\n    /**\n     * Sort a list of items by sort state as a new array.\n     */\n    function sort(items, state, sortNotebooksFirst = false, translator) {\n        const copy = Array.from(items);\n        const reverse = state.direction === 'descending' ? 1 : -1;\n        /**\n         * Compares two items and returns whether they should have a fixed priority.\n         * The fixed priority enables to always sort the directories above the other files. And to sort the notebook above other files if the `sortNotebooksFirst` is true.\n         */\n        function isPriorityOverridden(a, b) {\n            if (sortNotebooksFirst) {\n                return a.type !== b.type;\n            }\n            return (a.type === 'directory') !== (b.type === 'directory');\n        }\n        /**\n         * Returns the priority of a file.\n         */\n        function getPriority(item) {\n            if (item.type === 'directory') {\n                return 2;\n            }\n            if (item.type === 'notebook' && sortNotebooksFirst) {\n                return 1;\n            }\n            return 0;\n        }\n        /**\n         * Compare two items by their name using `translator.languageCode`, with fallback to `navigator.language`.\n         */\n        function compareByName(a, b) {\n            var _a;\n            // Wokaround for Chromium invalid language code on CI, see\n            // https://github.com/jupyterlab/jupyterlab/issues/17079\n            const navigatorLanguage = navigator.language.split('@')[0];\n            const languageCode = ((_a = translator.languageCode) !== null && _a !== void 0 ? _a : navigatorLanguage).replace('_', '-');\n            try {\n                return a.name.localeCompare(b.name, languageCode, {\n                    numeric: true,\n                    sensitivity: 'base'\n                });\n            }\n            catch (e) {\n                console.warn(`localeCompare failed to compare ${a.name} and ${b.name} under languageCode: ${languageCode}`);\n                return a.name.localeCompare(b.name, navigatorLanguage, {\n                    numeric: true,\n                    sensitivity: 'base'\n                });\n            }\n        }\n        function compare(compare) {\n            return (a, b) => {\n                // Group directory first, then notebooks, then files\n                if (isPriorityOverridden(a, b)) {\n                    return getPriority(b) - getPriority(a);\n                }\n                const compared = compare(a, b);\n                if (compared !== 0) {\n                    return compared * reverse;\n                }\n                // Default sorting is alphabetical ascending\n                return compareByName(a, b);\n            };\n        }\n        if (state.key === 'last_modified') {\n            // Sort by last modified\n            copy.sort(compare((a, b) => {\n                return (new Date(a.last_modified).getTime() -\n                    new Date(b.last_modified).getTime());\n            }));\n        }\n        else if (state.key === 'file_size') {\n            // Sort by size\n            copy.sort(compare((a, b) => {\n                var _a, _b;\n                return ((_a = b.size) !== null && _a !== void 0 ? _a : 0) - ((_b = a.size) !== null && _b !== void 0 ? _b : 0);\n            }));\n        }\n        else {\n            // Sort by name\n            copy.sort(compare((a, b) => {\n                return compareByName(b, a);\n            }));\n        }\n        return copy;\n    }\n    Private.sort = sort;\n    /**\n     * Check if the column is resizable.\n     */\n    Private.isResizable = (column) => {\n        return 'resizable' in column && column.resizable;\n    };\n    /**\n     * Check if the column is sortable.\n     */\n    Private.isSortable = (column) => {\n        return 'sortable' in column && column.sortable;\n    };\n    /**\n     * Get the index of the node at a client position, or `-1`.\n     */\n    function hitTestNodes(nodes, event) {\n        return _lumino_algorithm__WEBPACK_IMPORTED_MODULE_6__.ArrayExt.findFirstIndex(nodes, node => _lumino_domutils__WEBPACK_IMPORTED_MODULE_8__.ElementExt.hitTest(node, event.clientX, event.clientY) ||\n            event.target === node);\n    }\n    Private.hitTestNodes = hitTestNodes;\n    /**\n     * Format bytes to human readable string.\n     */\n    function formatFileSize(bytes, decimalPoint, k) {\n        // https://www.codexworld.com/how-to/convert-file-size-bytes-kb-mb-gb-javascript/\n        if (bytes === 0) {\n            return '0 B';\n        }\n        const dm = decimalPoint || 2;\n        const sizes = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];\n        const i = Math.floor(Math.log(bytes) / Math.log(k));\n        if (i >= 0 && i < sizes.length) {\n            return parseFloat((bytes / Math.pow(k, i)).toFixed(dm)) + ' ' + sizes[i];\n        }\n        else {\n            return String(bytes);\n        }\n    }\n    Private.formatFileSize = formatFileSize;\n    /**\n     * Update an inline svg caret icon in a node.\n     */\n    function updateCaret(container, float, state) {\n        if (state) {\n            (state === 'down' ? _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_5__.caretDownIcon : _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_5__.caretUpIcon).element({\n                container,\n                tag: 'span',\n                stylesheet: 'listingHeaderItem'\n            });\n            if (float === 'left') {\n                container.style.order = '-1';\n            }\n            else {\n                container.style.order = '';\n            }\n        }\n        else {\n            _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_5__.LabIcon.remove(container);\n            container.className = HEADER_ITEM_ICON_CLASS;\n        }\n    }\n    Private.updateCaret = updateCaret;\n    async function createDirectory(manager, path, name) {\n        const model = await manager.newUntitled({\n            path: path,\n            type: 'directory'\n        });\n        const tmpDirPath = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.join(path, model.name);\n        const dirPath = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.join(path, name);\n        try {\n            await manager.rename(tmpDirPath, dirPath);\n        }\n        catch (e) {\n            // The `dirPath` already exists, remove the temporary new directory\n            await manager.deleteFile(tmpDirPath);\n        }\n        return dirPath;\n    }\n    Private.createDirectory = createDirectory;\n    function isDirectoryEntry(entry) {\n        return entry.isDirectory;\n    }\n    Private.isDirectoryEntry = isDirectoryEntry;\n    function isFileEntry(entry) {\n        return entry.isFile;\n    }\n    Private.isFileEntry = isFileEntry;\n    function defensiveGetAsEntry(item) {\n        if (item.webkitGetAsEntry) {\n            return item.webkitGetAsEntry();\n        }\n        if ('getAsEntry' in item) {\n            // See https://developer.mozilla.org/en-US/docs/Web/API/DataTransferItem/webkitGetAsEntry\n            return item['getAsEntry']();\n        }\n        return null;\n    }\n    Private.defensiveGetAsEntry = defensiveGetAsEntry;\n    function readEntries(reader) {\n        return new Promise((resolve, reject) => reader.readEntries(resolve, reject));\n    }\n    function readFile(entry) {\n        return new Promise((resolve, reject) => entry.file(resolve, reject));\n    }\n    Private.readFile = readFile;\n    async function collectEntries(reader) {\n        // Spec requires calling `readEntries` until these are exhausted;\n        // in practice this is only required in Chromium-based browsers for >100 files.\n        // https://issues.chromium.org/issues/41110876\n        const allEntries = [];\n        let done = false;\n        while (!done) {\n            const entries = await readEntries(reader);\n            if (entries.length === 0) {\n                done = true;\n            }\n            else {\n                allEntries.push(...entries);\n            }\n        }\n        return allEntries;\n    }\n    Private.collectEntries = collectEntries;\n})(Private || (Private = {}));\n//# sourceMappingURL=listing.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/filebrowser/lib/listing.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/filebrowser/lib/model.js":
/*!************************************************************!*\
  !*** ../node_modules/@jupyterlab/filebrowser/lib/model.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   CHUNK_SIZE: () => (/* binding */ CHUNK_SIZE),\n/* harmony export */   FileBrowserModel: () => (/* binding */ FileBrowserModel),\n/* harmony export */   FilterFileBrowserModel: () => (/* binding */ FilterFileBrowserModel),\n/* harmony export */   LARGE_FILE_SIZE: () => (/* binding */ LARGE_FILE_SIZE),\n/* harmony export */   TogglableHiddenFileBrowserModel: () => (/* binding */ TogglableHiddenFileBrowserModel)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/coreutils */ \"webpack/sharing/consume/default/@jupyterlab/coreutils/@jupyterlab/coreutils\");\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/docmanager */ \"webpack/sharing/consume/default/@jupyterlab/docmanager/@jupyterlab/docmanager\");\n/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @lumino/algorithm */ \"webpack/sharing/consume/default/@lumino/algorithm/@lumino/algorithm\");\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_lumino_algorithm__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @lumino/coreutils */ \"webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils\");\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__);\n/* harmony import */ var _lumino_polling__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @lumino/polling */ \"webpack/sharing/consume/default/@lumino/polling/@lumino/polling\");\n/* harmony import */ var _lumino_polling__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_lumino_polling__WEBPACK_IMPORTED_MODULE_6__);\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_7__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n\n\n\n/**\n * The default duration of the auto-refresh in ms\n */\nconst DEFAULT_REFRESH_INTERVAL = 10000;\n/**\n * The maximum upload size (in bytes) for notebook version < 5.1.0\n */\nconst LARGE_FILE_SIZE = 15 * 1024 * 1024;\n/**\n * The size (in bytes) of the biggest chunk we should upload at once.\n */\nconst CHUNK_SIZE = 1024 * 1024;\n/**\n * An implementation of a file browser model.\n *\n * #### Notes\n * All paths parameters without a leading `'/'` are interpreted as relative to\n * the current directory.  Supports `'../'` syntax.\n */\nclass FileBrowserModel {\n    /**\n     * Construct a new file browser model.\n     */\n    constructor(options) {\n        var _a;\n        this._connectionFailure = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_7__.Signal(this);\n        this._fileChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_7__.Signal(this);\n        this._items = [];\n        this._key = '';\n        this._pathChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_7__.Signal(this);\n        this._paths = new Set();\n        this._pending = null;\n        this._pendingPath = null;\n        this._refreshed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_7__.Signal(this);\n        this._sessions = [];\n        this._state = null;\n        this._isDisposed = false;\n        this._restored = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__.PromiseDelegate();\n        this._uploads = [];\n        this._uploadChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_7__.Signal(this);\n        this.manager = options.manager;\n        this.translator = options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_3__.nullTranslator;\n        this._trans = this.translator.load('jupyterlab');\n        this._driveName = options.driveName || '';\n        this._model = {\n            path: this.rootPath,\n            name: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.basename(this.rootPath),\n            type: 'directory',\n            content: undefined,\n            writable: false,\n            created: 'unknown',\n            last_modified: 'unknown',\n            mimetype: 'text/plain',\n            format: 'text'\n        };\n        this._state = options.state || null;\n        const refreshInterval = options.refreshInterval || DEFAULT_REFRESH_INTERVAL;\n        const { services } = options.manager;\n        services.contents.fileChanged.connect(this.onFileChanged, this);\n        services.sessions.runningChanged.connect(this.onRunningChanged, this);\n        this._unloadEventListener = (e) => {\n            if (this._uploads.length > 0) {\n                const confirmationMessage = this._trans.__('Files still uploading');\n                e.returnValue = confirmationMessage;\n                return confirmationMessage;\n            }\n        };\n        window.addEventListener('beforeunload', this._unloadEventListener);\n        this._poll = new _lumino_polling__WEBPACK_IMPORTED_MODULE_6__.Poll({\n            auto: (_a = options.auto) !== null && _a !== void 0 ? _a : true,\n            name: '@jupyterlab/filebrowser:Model',\n            factory: () => this.cd('.'),\n            frequency: {\n                interval: refreshInterval,\n                backoff: true,\n                max: 300 * 1000\n            },\n            standby: options.refreshStandby || 'when-hidden'\n        });\n    }\n    /**\n     * A signal emitted when the file browser model loses connection.\n     */\n    get connectionFailure() {\n        return this._connectionFailure;\n    }\n    /**\n     * The drive name that gets prepended to the path.\n     */\n    get driveName() {\n        return this._driveName;\n    }\n    /**\n     * A promise that resolves when the model is first restored.\n     */\n    get restored() {\n        return this._restored.promise;\n    }\n    /**\n     * Get the file path changed signal.\n     */\n    get fileChanged() {\n        return this._fileChanged;\n    }\n    /**\n     * Get the current path.\n     */\n    get path() {\n        return this._model ? this._model.path : '';\n    }\n    /**\n     * Get the root path\n     */\n    get rootPath() {\n        return this._driveName ? this._driveName + ':' : '';\n    }\n    /**\n     * A signal emitted when the path changes.\n     */\n    get pathChanged() {\n        return this._pathChanged;\n    }\n    /**\n     * A signal emitted when the directory listing is refreshed.\n     */\n    get refreshed() {\n        return this._refreshed;\n    }\n    /**\n     * Get the kernel spec models.\n     */\n    get specs() {\n        return this.manager.services.kernelspecs.specs;\n    }\n    /**\n     * Get whether the model is disposed.\n     */\n    get isDisposed() {\n        return this._isDisposed;\n    }\n    /**\n     * A signal emitted when an upload progresses.\n     */\n    get uploadChanged() {\n        return this._uploadChanged;\n    }\n    /**\n     * Create an iterator over the status of all in progress uploads.\n     */\n    uploads() {\n        return this._uploads[Symbol.iterator]();\n    }\n    /**\n     * Dispose of the resources held by the model.\n     */\n    dispose() {\n        if (this.isDisposed) {\n            return;\n        }\n        window.removeEventListener('beforeunload', this._unloadEventListener);\n        this._isDisposed = true;\n        this._poll.dispose();\n        this._sessions.length = 0;\n        this._items.length = 0;\n        _lumino_signaling__WEBPACK_IMPORTED_MODULE_7__.Signal.clearData(this);\n    }\n    /**\n     * Create an iterator over the model's items.\n     *\n     * @returns A new iterator over the model's items.\n     */\n    items() {\n        return this._items[Symbol.iterator]();\n    }\n    /**\n     * Create an iterator over the active sessions in the directory.\n     *\n     * @returns A new iterator over the model's active sessions.\n     */\n    sessions() {\n        return this._sessions[Symbol.iterator]();\n    }\n    /**\n     * Force a refresh of the directory contents.\n     */\n    async refresh() {\n        await this._poll.refresh();\n        await this._poll.tick;\n        this._refreshed.emit(void 0);\n    }\n    /**\n     * Change directory.\n     *\n     * @param path The path to the file or directory.\n     *\n     * @returns A promise with the contents of the directory.\n     */\n    async cd(path = '.') {\n        if (path !== '.') {\n            path = this.manager.services.contents.resolvePath(this._model.path, path);\n        }\n        else {\n            path = this._pendingPath || this._model.path;\n        }\n        if (this._pending) {\n            // Collapse requests to the same directory.\n            if (path === this._pendingPath) {\n                return this._pending;\n            }\n            // Otherwise wait for the pending request to complete before continuing.\n            await this._pending;\n        }\n        const oldValue = this.path;\n        const options = { content: true };\n        this._pendingPath = path;\n        if (oldValue !== path) {\n            this._sessions.length = 0;\n        }\n        const services = this.manager.services;\n        this._pending = services.contents\n            .get(path, options)\n            .then(contents => {\n            if (this.isDisposed) {\n                return;\n            }\n            this.handleContents(contents);\n            this._pendingPath = null;\n            this._pending = null;\n            if (oldValue !== path) {\n                // If there is a state database and a unique key, save the new path.\n                // We don't need to wait on the save to continue.\n                if (this._state && this._key) {\n                    void this._state.save(this._key, { path });\n                }\n                this._pathChanged.emit({\n                    name: 'path',\n                    oldValue,\n                    newValue: path\n                });\n            }\n            this.onRunningChanged(services.sessions, services.sessions.running());\n            this._refreshed.emit(void 0);\n        })\n            .catch(error => {\n            this._pendingPath = null;\n            this._pending = null;\n            if (error.response && error.response.status === 404 && path !== '/') {\n                error.message = this._trans.__('Directory not found: \"%1\"', this._model.path);\n                console.error(error);\n                this._connectionFailure.emit(error);\n                return this.cd('/');\n            }\n            else {\n                this._connectionFailure.emit(error);\n            }\n        });\n        return this._pending;\n    }\n    /**\n     * Download a file.\n     *\n     * @param path - The path of the file to be downloaded.\n     *\n     * @returns A promise which resolves when the file has begun\n     *   downloading.\n     */\n    async download(path) {\n        const url = await this.manager.services.contents.getDownloadUrl(path);\n        const element = document.createElement('a');\n        element.href = url;\n        element.download = '';\n        document.body.appendChild(element);\n        element.click();\n        document.body.removeChild(element);\n        return void 0;\n    }\n    /**\n     * Restore the state of the file browser.\n     *\n     * @param id - The unique ID that is used to construct a state database key.\n     *\n     * @param populate - If `false`, the restoration ID will be set but the file\n     * browser state will not be fetched from the state database.\n     *\n     * @returns A promise when restoration is complete.\n     *\n     * #### Notes\n     * This function will only restore the model *once*. If it is called multiple\n     * times, all subsequent invocations are no-ops.\n     */\n    async restore(id, populate = true) {\n        const { manager } = this;\n        const key = `file-browser-${id}:cwd`;\n        const state = this._state;\n        const restored = !!this._key;\n        if (restored) {\n            return;\n        }\n        // Set the file browser key for state database fetch/save.\n        this._key = key;\n        if (!populate || !state) {\n            this._restored.resolve(undefined);\n            return;\n        }\n        await manager.services.ready;\n        try {\n            const value = await state.fetch(key);\n            if (!value) {\n                this._restored.resolve(undefined);\n                return;\n            }\n            const path = value['path'];\n            // need to return to root path if preferred dir is set\n            if (path) {\n                await this.cd('/');\n            }\n            const localPath = manager.services.contents.localPath(path);\n            await manager.services.contents.get(path);\n            await this.cd(localPath);\n        }\n        catch (error) {\n            await state.remove(key);\n        }\n        this._restored.resolve(undefined);\n    }\n    /**\n     * Upload a `File` object.\n     *\n     * @param file - The `File` object to upload.\n     * @param path - The directory into which the file should be uploaded; defaults to current directory.\n     *\n     * @returns A promise containing the new file contents model.\n     *\n     * #### Notes\n     * On Notebook version < 5.1.0, this will fail to upload files that are too\n     * big to be sent in one request to the server. On newer versions, or on\n     * Jupyter Server, it will ask for confirmation then upload the file in 1 MB\n     * chunks.\n     */\n    async upload(file, path) {\n        // We do not support Jupyter Notebook version less than 4, and Jupyter\n        // Server advertises itself as version 1 and supports chunked\n        // uploading. We assume any version less than 4.0.0 to be Jupyter Server\n        // instead of Jupyter Notebook.\n        const serverVersion = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PageConfig.getNotebookVersion();\n        const supportsChunked = serverVersion < [4, 0, 0] /* Jupyter Server */ ||\n            serverVersion >= [5, 1, 0]; /* Jupyter Notebook >= 5.1.0 */\n        const largeFile = file.size > LARGE_FILE_SIZE;\n        if (largeFile && !supportsChunked) {\n            const msg = this._trans.__('Cannot upload file (>%1 MB). %2', LARGE_FILE_SIZE / (1024 * 1024), file.name);\n            console.warn(msg);\n            throw msg;\n        }\n        const err = 'File not uploaded';\n        if (largeFile && !(await this._shouldUploadLarge(file))) {\n            throw 'Cancelled large file upload';\n        }\n        await this._uploadCheckDisposed();\n        await this.refresh();\n        await this._uploadCheckDisposed();\n        if (this._items.find(i => i.name === file.name) &&\n            !(await (0,_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__.shouldOverwrite)(file.name))) {\n            throw err;\n        }\n        await this._uploadCheckDisposed();\n        const chunkedUpload = supportsChunked && file.size > CHUNK_SIZE;\n        return await this._upload(file, chunkedUpload, path);\n    }\n    async _shouldUploadLarge(file) {\n        const { button } = await (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showDialog)({\n            title: this._trans.__('Large file size warning'),\n            body: this._trans.__('The file size is %1 MB. Do you still want to upload it?', Math.round(file.size / (1024 * 1024))),\n            buttons: [\n                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.cancelButton({ label: this._trans.__('Cancel') }),\n                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.warnButton({ label: this._trans.__('Upload') })\n            ]\n        });\n        return button.accept;\n    }\n    /**\n     * Perform the actual upload.\n     */\n    async _upload(file, chunked, uploadPath) {\n        // Gather the file model parameters.\n        let path = typeof uploadPath === 'undefined' ? this._model.path : uploadPath;\n        path = path ? path + '/' + file.name : file.name;\n        const name = file.name;\n        const type = 'file';\n        const format = 'base64';\n        const uploadInner = async (blob, chunk) => {\n            await this._uploadCheckDisposed();\n            const reader = new FileReader();\n            reader.readAsDataURL(blob);\n            await new Promise((resolve, reject) => {\n                reader.onload = resolve;\n                reader.onerror = event => reject(`Failed to upload \"${file.name}\":` + event);\n            });\n            await this._uploadCheckDisposed();\n            // remove header https://stackoverflow.com/a/24289420/907060\n            const content = reader.result.split(',')[1];\n            const model = {\n                type,\n                format,\n                name,\n                chunk,\n                content\n            };\n            return await this.manager.services.contents.save(path, model);\n        };\n        if (!chunked) {\n            try {\n                return await uploadInner(file);\n            }\n            catch (err) {\n                _lumino_algorithm__WEBPACK_IMPORTED_MODULE_4__.ArrayExt.removeFirstWhere(this._uploads, uploadIndex => {\n                    return file.name === uploadIndex.path;\n                });\n                throw err;\n            }\n        }\n        let finalModel;\n        let upload = { path, progress: 0 };\n        this._uploadChanged.emit({\n            name: 'start',\n            newValue: upload,\n            oldValue: null\n        });\n        for (let start = 0; !finalModel; start += CHUNK_SIZE) {\n            const end = start + CHUNK_SIZE;\n            const lastChunk = end >= file.size;\n            const chunk = lastChunk ? -1 : end / CHUNK_SIZE;\n            const newUpload = { path, progress: start / file.size };\n            this._uploads.splice(this._uploads.indexOf(upload));\n            this._uploads.push(newUpload);\n            this._uploadChanged.emit({\n                name: 'update',\n                newValue: newUpload,\n                oldValue: upload\n            });\n            upload = newUpload;\n            let currentModel;\n            try {\n                currentModel = await uploadInner(file.slice(start, end), chunk);\n            }\n            catch (err) {\n                _lumino_algorithm__WEBPACK_IMPORTED_MODULE_4__.ArrayExt.removeFirstWhere(this._uploads, uploadIndex => {\n                    return file.name === uploadIndex.path;\n                });\n                this._uploadChanged.emit({\n                    name: 'failure',\n                    newValue: upload,\n                    oldValue: null\n                });\n                throw err;\n            }\n            if (lastChunk) {\n                finalModel = currentModel;\n            }\n        }\n        this._uploads.splice(this._uploads.indexOf(upload));\n        this._uploadChanged.emit({\n            name: 'finish',\n            newValue: null,\n            oldValue: upload\n        });\n        return finalModel;\n    }\n    _uploadCheckDisposed() {\n        if (this.isDisposed) {\n            return Promise.reject('Filemanager disposed. File upload canceled');\n        }\n        return Promise.resolve();\n    }\n    /**\n     * Handle an updated contents model.\n     */\n    handleContents(contents) {\n        // Update our internal data.\n        this._model = {\n            name: contents.name,\n            path: contents.path,\n            type: contents.type,\n            content: undefined,\n            writable: contents.writable,\n            created: contents.created,\n            last_modified: contents.last_modified,\n            size: contents.size,\n            mimetype: contents.mimetype,\n            format: contents.format\n        };\n        this._items = contents.content;\n        this._paths.clear();\n        contents.content.forEach((model) => {\n            this._paths.add(model.path);\n        });\n    }\n    /**\n     * Handle a change to the running sessions.\n     */\n    onRunningChanged(sender, models) {\n        this._populateSessions(models);\n        this._refreshed.emit(void 0);\n    }\n    /**\n     * Handle a change on the contents manager.\n     */\n    onFileChanged(sender, change) {\n        const path = this._model.path;\n        const { sessions } = this.manager.services;\n        const { oldValue, newValue } = change;\n        const prefix = this.driveName.length > 0 ? this.driveName + ':' : '';\n        const value = oldValue &&\n            oldValue.path &&\n            prefix + _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.dirname(oldValue.path) === path\n            ? oldValue\n            : newValue &&\n                newValue.path &&\n                prefix + _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.dirname(newValue.path) === path\n                ? newValue\n                : undefined;\n        // If either the old value or the new value is in the current path, update.\n        if (value) {\n            void this._poll.refresh();\n            this._populateSessions(sessions.running());\n            this._fileChanged.emit(change);\n            return;\n        }\n    }\n    /**\n     * Populate the model's sessions collection.\n     */\n    _populateSessions(models) {\n        this._sessions.length = 0;\n        for (const model of models) {\n            if (this._paths.has(model.path)) {\n                this._sessions.push(model);\n            }\n        }\n    }\n}\n/**\n * File browser model where hidden files inclusion can be toggled on/off.\n */\nclass TogglableHiddenFileBrowserModel extends FileBrowserModel {\n    constructor(options) {\n        super(options);\n        this._includeHiddenFiles = options.includeHiddenFiles || false;\n    }\n    /**\n     * Create an iterator over the model's items filtering hidden files out if necessary.\n     *\n     * @returns A new iterator over the model's items.\n     */\n    items() {\n        return this._includeHiddenFiles\n            ? super.items()\n            : (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_4__.filter)(super.items(), value => !value.name.startsWith('.'));\n    }\n    /**\n     * Set the inclusion of hidden files. Triggers a model refresh.\n     */\n    showHiddenFiles(value) {\n        this._includeHiddenFiles = value;\n        void this.refresh();\n    }\n}\n/**\n * File browser model with optional filter on element.\n */\nclass FilterFileBrowserModel extends TogglableHiddenFileBrowserModel {\n    constructor(options) {\n        var _a, _b, _c;\n        super(options);\n        this._filterSettingsChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_7__.Signal(this);\n        this._filter =\n            (_a = options.filter) !== null && _a !== void 0 ? _a : (model => {\n                return {};\n            });\n        this._filterDirectories = (_b = options.filterDirectories) !== null && _b !== void 0 ? _b : true;\n        this._useFuzzyFilter = (_c = options.useFuzzyFilter) !== null && _c !== void 0 ? _c : true;\n    }\n    /**\n     * Whether to filter directories.\n     */\n    get filterDirectories() {\n        return this._filterDirectories;\n    }\n    set filterDirectories(value) {\n        this._filterDirectories = value;\n    }\n    /**\n     * Whether to apply fuzzy filter.\n     */\n    get useFuzzyFilter() {\n        return this._useFuzzyFilter;\n    }\n    set useFuzzyFilter(value) {\n        if (this._useFuzzyFilter === value) {\n            return;\n        }\n        this._useFuzzyFilter = value;\n        this._filterSettingsChanged.emit({ useFuzzyFilter: value });\n    }\n    /**\n     * Signal for settings changed\n     */\n    get filterSettingsChanged() {\n        return this._filterSettingsChanged;\n    }\n    /**\n     * Create an iterator over the filtered model's items.\n     *\n     * @returns A new iterator over the model's items.\n     */\n    items() {\n        return (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_4__.filter)(super.items(), value => {\n            if (!this._filterDirectories && value.type === 'directory') {\n                return true;\n            }\n            else {\n                const filtered = this._filter(value);\n                value.indices = filtered === null || filtered === void 0 ? void 0 : filtered.indices;\n                return !!filtered;\n            }\n        });\n    }\n    setFilter(filter) {\n        this._filter = filter;\n        void this.refresh();\n    }\n}\n//# sourceMappingURL=model.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/filebrowser/lib/model.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/filebrowser/lib/opendialog.js":
/*!*****************************************************************!*\
  !*** ../node_modules/@jupyterlab/filebrowser/lib/opendialog.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   FileDialog: () => (/* binding */ FileDialog)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/coreutils */ \"webpack/sharing/consume/default/@jupyterlab/coreutils/@jupyterlab/coreutils\");\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @lumino/widgets */ \"webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets\");\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var _browser__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./browser */ \"../node_modules/@jupyterlab/filebrowser/lib/browser.js\");\n/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./model */ \"../node_modules/@jupyterlab/filebrowser/lib/model.js\");\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @lumino/coreutils */ \"webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils\");\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n\n\n\n/**\n * The class name added to open file dialog\n */\nconst OPEN_DIALOG_CLASS = 'jp-Open-Dialog';\n/**\n * The class name added to (optional) label in the file dialog\n */\nconst OPEN_DIALOG_LABEL_CLASS = 'jp-Open-Dialog-label';\n/**\n * Namespace for file dialog\n */\nvar FileDialog;\n(function (FileDialog) {\n    /**\n     * Create and show a open files dialog.\n     *\n     * Note: if nothing is selected when `getValue` will return the browser\n     * model current path.\n     *\n     * @param options - The dialog setup options.\n     *\n     * @returns A promise that resolves with whether the dialog was accepted.\n     */\n    async function getOpenFiles(options) {\n        const translator = options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_2__.nullTranslator;\n        const trans = translator.load('jupyterlab');\n        const openDialog = new OpenDialog(options.manager, options.filter, translator, options.defaultPath, options.label);\n        const dialogOptions = {\n            title: options.title,\n            buttons: [\n                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.cancelButton(),\n                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.okButton({\n                    label: trans.__('Select')\n                })\n            ],\n            focusNodeSelector: options.focusNodeSelector,\n            host: options.host,\n            renderer: options.renderer,\n            body: openDialog\n        };\n        await openDialog.ready;\n        const dialog = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog(dialogOptions);\n        return dialog.launch();\n    }\n    FileDialog.getOpenFiles = getOpenFiles;\n    /**\n     * Create and show a open directory dialog.\n     *\n     * Note: if nothing is selected when `getValue` will return the browser\n     * model current path.\n     *\n     * @param options - The dialog setup options.\n     *\n     * @returns A promise that resolves with whether the dialog was accepted.\n     */\n    function getExistingDirectory(options) {\n        return getOpenFiles({\n            ...options,\n            filter: model => {\n                return model.type === 'directory' ? {} : null;\n            }\n        });\n    }\n    FileDialog.getExistingDirectory = getExistingDirectory;\n})(FileDialog || (FileDialog = {}));\n/**\n * Open dialog widget\n */\nclass OpenDialog extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__.Widget {\n    constructor(manager, filter, translator, defaultPath, label, filterDirectories) {\n        super();\n        this._ready = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__.PromiseDelegate();\n        translator = translator !== null && translator !== void 0 ? translator : _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_2__.nullTranslator;\n        const trans = translator.load('jupyterlab');\n        this.addClass(OPEN_DIALOG_CLASS);\n        Private.createFilteredFileBrowser('filtered-file-browser-dialog', manager, filter, {}, translator, defaultPath, filterDirectories)\n            .then(browser => {\n            this._browser = browser;\n            // Add toolbar items\n            (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.setToolbar)(this._browser, (browser) => [\n                {\n                    name: 'new-folder',\n                    widget: new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.ToolbarButton({\n                        icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.newFolderIcon,\n                        onClick: () => {\n                            void browser.createNewDirectory();\n                        },\n                        tooltip: trans.__('New Folder')\n                    })\n                },\n                {\n                    name: 'refresher',\n                    widget: new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.ToolbarButton({\n                        icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.refreshIcon,\n                        onClick: () => {\n                            browser.model.refresh().catch(reason => {\n                                console.error('Failed to refresh file browser in open dialog.', reason);\n                            });\n                        },\n                        tooltip: trans.__('Refresh File List')\n                    })\n                }\n            ]);\n            // Build the sub widgets\n            const layout = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__.PanelLayout();\n            if (label) {\n                const labelWidget = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__.Widget();\n                labelWidget.addClass(OPEN_DIALOG_LABEL_CLASS);\n                labelWidget.node.textContent = label;\n                layout.addWidget(labelWidget);\n            }\n            layout.addWidget(this._browser);\n            /**\n             * Dispose browser model when OpenDialog\n             * is disposed.\n             */\n            this.dispose = () => {\n                if (this.isDisposed) {\n                    return;\n                }\n                this._browser.model.dispose();\n                super.dispose();\n            };\n            // Set Widget content\n            this.layout = layout;\n            this._ready.resolve();\n        })\n            .catch(reason => {\n            console.error('Error while creating file browser in open dialog', reason);\n            this._ready.reject(void 0);\n        });\n    }\n    /**\n     * Get the selected items.\n     */\n    getValue() {\n        const selection = Array.from(this._browser.selectedItems());\n        if (selection.length === 0) {\n            // Return current path\n            return [\n                {\n                    path: this._browser.model.path,\n                    name: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.basename(this._browser.model.path),\n                    type: 'directory',\n                    content: undefined,\n                    writable: false,\n                    created: 'unknown',\n                    last_modified: 'unknown',\n                    mimetype: 'text/plain',\n                    format: 'text'\n                }\n            ];\n        }\n        else {\n            return selection;\n        }\n    }\n    /**\n     * A promise that resolves when openDialog is successfully created.\n     */\n    get ready() {\n        return this._ready.promise;\n    }\n}\nvar Private;\n(function (Private) {\n    /**\n     * Create a new file browser instance.\n     *\n     * @param id - The widget/DOM id of the file browser.\n     *\n     * @param manager - A document manager instance.\n     *\n     * @param filter - function to filter file browser item.\n     *\n     * @param options - The optional file browser configuration object.\n     *\n     * #### Notes\n     * The ID parameter is used to set the widget ID. It is also used as part of\n     * the unique key necessary to store the file browser's restoration data in\n     * the state database if that functionality is enabled.\n     *\n     * If, after the file browser has been generated by the factory, the ID of the\n     * resulting widget is changed by client code, the restoration functionality\n     * will not be disrupted as long as there are no ID collisions, i.e., as long\n     * as the initial ID passed into the factory is used for only one file browser\n     * instance.\n     */\n    Private.createFilteredFileBrowser = async (id, manager, filter, options = {}, translator, defaultPath, filterDirectories) => {\n        translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_2__.nullTranslator;\n        const model = new _model__WEBPACK_IMPORTED_MODULE_6__.FilterFileBrowserModel({\n            manager,\n            filter,\n            translator,\n            driveName: options.driveName,\n            refreshInterval: options.refreshInterval,\n            filterDirectories\n        });\n        const widget = new _browser__WEBPACK_IMPORTED_MODULE_7__.FileBrowser({\n            id,\n            model,\n            translator\n        });\n        if (defaultPath) {\n            await widget.model.cd(defaultPath);\n        }\n        return widget;\n    };\n})(Private || (Private = {}));\n//# sourceMappingURL=opendialog.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/filebrowser/lib/opendialog.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/filebrowser/lib/tokens.js":
/*!*************************************************************!*\
  !*** ../node_modules/@jupyterlab/filebrowser/lib/tokens.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   IDefaultFileBrowser: () => (/* binding */ IDefaultFileBrowser),\n/* harmony export */   IFileBrowserCommands: () => (/* binding */ IFileBrowserCommands),\n/* harmony export */   IFileBrowserFactory: () => (/* binding */ IFileBrowserFactory)\n/* harmony export */ });\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ \"webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils\");\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n/**\n * The file browser factory token.\n */\nconst IFileBrowserFactory = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/filebrowser:IFileBrowserFactory', `A factory object that creates file browsers.\n  Use this if you want to create your own file browser (e.g., for a custom storage backend),\n  or to interact with other file browsers that have been created by extensions.`);\n/**\n * The default file browser token.\n */\nconst IDefaultFileBrowser = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/filebrowser:IDefaultFileBrowser', 'A service for the default file browser.');\n/**\n * The token that indicates the default file browser commands are loaded.\n */\nconst IFileBrowserCommands = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/filebrowser:IFileBrowserCommands', 'A token to ensure file browser commands are loaded.');\n//# sourceMappingURL=tokens.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/filebrowser/lib/tokens.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/filebrowser/lib/upload.js":
/*!*************************************************************!*\
  !*** ../node_modules/@jupyterlab/filebrowser/lib/upload.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Uploader: () => (/* binding */ Uploader)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n/**\n * A widget which provides an upload button.\n */\nclass Uploader extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.ToolbarButton {\n    /**\n     * Construct a new file browser buttons widget.\n     */\n    constructor(options) {\n        super({\n            icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.fileUploadIcon,\n            label: options.label,\n            onClick: () => {\n                this._input.click();\n            },\n            tooltip: Private.translateToolTip(options.translator)\n        });\n        /**\n         * The 'change' handler for the input field.\n         */\n        this._onInputChanged = () => {\n            const files = Array.prototype.slice.call(this._input.files);\n            const pending = files.map(file => this.fileBrowserModel.upload(file));\n            void Promise.all(pending).catch(error => {\n                void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans._p('showErrorMessage', 'Upload Error'), error);\n            });\n        };\n        /**\n         * The 'click' handler for the input field.\n         */\n        this._onInputClicked = () => {\n            // In order to allow repeated uploads of the same file (with delete in between),\n            // we need to clear the input value to trigger a change event.\n            this._input.value = '';\n        };\n        this._input = Private.createUploadInput();\n        this.fileBrowserModel = options.model;\n        this.translator = options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__.nullTranslator;\n        this._trans = this.translator.load('jupyterlab');\n        this._input.onclick = this._onInputClicked;\n        this._input.onchange = this._onInputChanged;\n        this.addClass('jp-id-upload');\n    }\n}\n/**\n * The namespace for module private data.\n */\nvar Private;\n(function (Private) {\n    /**\n     * Create the upload input node for a file buttons widget.\n     */\n    function createUploadInput() {\n        const input = document.createElement('input');\n        input.type = 'file';\n        input.multiple = true;\n        return input;\n    }\n    Private.createUploadInput = createUploadInput;\n    /**\n     * Translate upload tooltip.\n     */\n    function translateToolTip(translator) {\n        translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__.nullTranslator;\n        const trans = translator.load('jupyterlab');\n        return trans.__('Upload Files');\n    }\n    Private.translateToolTip = translateToolTip;\n})(Private || (Private = {}));\n//# sourceMappingURL=upload.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/filebrowser/lib/upload.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/filebrowser/lib/uploadstatus.js":
/*!*******************************************************************!*\
  !*** ../node_modules/@jupyterlab/filebrowser/lib/uploadstatus.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   FileUploadStatus: () => (/* binding */ FileUploadStatus)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/statusbar */ \"webpack/sharing/consume/default/@jupyterlab/statusbar/@jupyterlab/statusbar\");\n/* harmony import */ var _jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/algorithm */ \"webpack/sharing/consume/default/@lumino/algorithm/@lumino/algorithm\");\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ \"webpack/sharing/consume/default/react/react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n//\n\n\n\n\n\n/**\n * Half-spacing between items in the overall status item.\n */\nconst HALF_SPACING = 4;\n/**\n * A pure function component for a FileUpload status item.\n *\n * @param props the props for the component.\n *\n * @returns a tsx component for the file upload status.\n */\nfunction FileUploadComponent(props) {\n    const translator = props.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__.nullTranslator;\n    const trans = translator.load('jupyterlab');\n    return (react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_0__.GroupItem, { spacing: HALF_SPACING },\n        react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_0__.TextItem, { source: trans.__('Uploading…') }),\n        react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_0__.ProgressBar, { percentage: props.upload })));\n}\n/**\n * The time for which to show the \"Complete!\" message after uploading.\n */\nconst UPLOAD_COMPLETE_MESSAGE_MILLIS = 2000;\n/**\n * Status bar item to display file upload progress.\n */\nclass FileUploadStatus extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.VDomRenderer {\n    /**\n     * Construct a new FileUpload status item.\n     */\n    constructor(opts) {\n        super(new FileUploadStatus.Model(opts.tracker.currentWidget && opts.tracker.currentWidget.model));\n        this._onBrowserChange = (tracker, browser) => {\n            if (browser === null) {\n                this.model.browserModel = null;\n            }\n            else {\n                this.model.browserModel = browser.model;\n            }\n        };\n        this.translator = opts.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__.nullTranslator;\n        this._trans = this.translator.load('jupyterlab');\n        this._tracker = opts.tracker;\n        this._tracker.currentChanged.connect(this._onBrowserChange);\n    }\n    /**\n     * Render the FileUpload status.\n     */\n    render() {\n        const uploadPaths = this.model.items;\n        if (uploadPaths.length > 0) {\n            const item = this.model.items[0];\n            if (item.complete) {\n                return react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_0__.TextItem, { source: this._trans.__('Complete!') });\n            }\n            else {\n                return (react__WEBPACK_IMPORTED_MODULE_4___default().createElement(FileUploadComponent, { upload: this.model.items[0].progress, translator: this.translator }));\n            }\n        }\n        else {\n            return react__WEBPACK_IMPORTED_MODULE_4___default().createElement(FileUploadComponent, { upload: 100, translator: this.translator });\n        }\n    }\n    dispose() {\n        super.dispose();\n        this._tracker.currentChanged.disconnect(this._onBrowserChange);\n    }\n}\n/**\n * A namespace for FileUpload class statics.\n */\n(function (FileUploadStatus) {\n    /**\n     * The VDomModel for the FileUpload renderer.\n     */\n    class Model extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.VDomModel {\n        /**\n         * Construct a new model.\n         */\n        constructor(browserModel) {\n            super();\n            /**\n             * Handle an uploadChanged event in the filebrowser model.\n             */\n            this._uploadChanged = (browse, uploads) => {\n                if (uploads.name === 'start') {\n                    this._items.push({\n                        path: uploads.newValue.path,\n                        progress: uploads.newValue.progress * 100,\n                        complete: false\n                    });\n                }\n                else if (uploads.name === 'update') {\n                    const idx = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayExt.findFirstIndex(this._items, val => val.path === uploads.oldValue.path);\n                    if (idx !== -1) {\n                        this._items[idx].progress = uploads.newValue.progress * 100;\n                    }\n                }\n                else if (uploads.name === 'finish') {\n                    const finishedItem = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayExt.findFirstValue(this._items, val => val.path === uploads.oldValue.path);\n                    if (finishedItem) {\n                        finishedItem.complete = true;\n                        setTimeout(() => {\n                            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayExt.removeFirstOf(this._items, finishedItem);\n                            this.stateChanged.emit(void 0);\n                        }, UPLOAD_COMPLETE_MESSAGE_MILLIS);\n                    }\n                }\n                else if (uploads.name === 'failure') {\n                    _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayExt.removeFirstWhere(this._items, val => val.path === uploads.newValue.path);\n                }\n                this.stateChanged.emit(void 0);\n            };\n            this._items = [];\n            this._browserModel = null;\n            this.browserModel = browserModel;\n        }\n        /**\n         * The currently uploading items.\n         */\n        get items() {\n            return this._items;\n        }\n        /**\n         * The current file browser model.\n         */\n        get browserModel() {\n            return this._browserModel;\n        }\n        set browserModel(browserModel) {\n            const oldBrowserModel = this._browserModel;\n            if (oldBrowserModel) {\n                oldBrowserModel.uploadChanged.disconnect(this._uploadChanged);\n            }\n            this._browserModel = browserModel;\n            this._items = [];\n            if (this._browserModel !== null) {\n                this._browserModel.uploadChanged.connect(this._uploadChanged);\n            }\n            this.stateChanged.emit(void 0);\n        }\n    }\n    FileUploadStatus.Model = Model;\n})(FileUploadStatus || (FileUploadStatus = {}));\n//# sourceMappingURL=uploadstatus.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/filebrowser/lib/uploadstatus.js?");

/***/ })

}]);