// <auto-generated>
//  automatically generated by the FlatBuffers compiler, do not modify
// </auto-generated>

namespace Apache.Arrow.Flatbuf
{

using global::System;
using global::System.Collections.Generic;
using global::Google.FlatBuffers;

/// ----------------------------------------------------------------------
/// EXPERIMENTAL: Data structures for sparse tensors
/// Coordinate (COO) format of sparse tensor index.
///
/// COO's index list are represented as a NxM matrix,
/// where N is the number of non-zero values,
/// and M is the number of dimensions of a sparse tensor.
///
/// indicesBuffer stores the location and size of the data of this indices
/// matrix.  The value type and the stride of the indices matrix is
/// specified in indicesType and indicesStrides fields.
///
/// For example, let X be a 2x3x4x5 tensor, and it has the following
/// 6 non-zero values:
/// ```text
///   X[0, 1, 2, 0] := 1
///   X[1, 1, 2, 3] := 2
///   X[0, 2, 1, 0] := 3
///   X[0, 1, 3, 0] := 4
///   X[0, 1, 2, 1] := 5
///   X[1, 2, 0, 4] := 6
/// ```
/// In COO format, the index matrix of X is the following 4x6 matrix:
/// ```text
///   [[0, 0, 0, 0, 1, 1],
///    [1, 1, 1, 2, 1, 2],
///    [2, 2, 3, 1, 2, 0],
///    [0, 1, 0, 0, 3, 4]]
/// ```
/// When isCanonical is true, the indices is sorted in lexicographical order
/// (row-major order), and it does not have duplicated entries.  Otherwise,
/// the indices may not be sorted, or may have duplicated entries.
internal struct SparseTensorIndexCOO : IFlatbufferObject
{
  private Table __p;
  public ByteBuffer ByteBuffer { get { return __p.bb; } }
  public static void ValidateVersion() { FlatBufferConstants.FLATBUFFERS_23_5_9(); }
  public static SparseTensorIndexCOO GetRootAsSparseTensorIndexCOO(ByteBuffer _bb) { return GetRootAsSparseTensorIndexCOO(_bb, new SparseTensorIndexCOO()); }
  public static SparseTensorIndexCOO GetRootAsSparseTensorIndexCOO(ByteBuffer _bb, SparseTensorIndexCOO obj) { return (obj.__assign(_bb.GetInt(_bb.Position) + _bb.Position, _bb)); }
  public void __init(int _i, ByteBuffer _bb) { __p = new Table(_i, _bb); }
  public SparseTensorIndexCOO __assign(int _i, ByteBuffer _bb) { __init(_i, _bb); return this; }

  /// The type of values in indicesBuffer
  public Int? IndicesType { get { int o = __p.__offset(4); return o != 0 ? (Int?)(new Int()).__assign(__p.__indirect(o + __p.bb_pos), __p.bb) : null; } }
  /// Non-negative byte offsets to advance one value cell along each dimension
  /// If omitted, default to row-major order (C-like).
  public long IndicesStrides(int j) { int o = __p.__offset(6); return o != 0 ? __p.bb.GetLong(__p.__vector(o) + j * 8) : (long)0; }
  public int IndicesStridesLength { get { int o = __p.__offset(6); return o != 0 ? __p.__vector_len(o) : 0; } }
#if ENABLE_SPAN_T
  public Span<long> GetIndicesStridesBytes() { return __p.__vector_as_span<long>(6, 8); }
#else
  public ArraySegment<byte>? GetIndicesStridesBytes() { return __p.__vector_as_arraysegment(6); }
#endif
  public long[] GetIndicesStridesArray() { return __p.__vector_as_array<long>(6); }
  /// The location and size of the indices matrix's data
  public Buffer? IndicesBuffer { get { int o = __p.__offset(8); return o != 0 ? (Buffer?)(new Buffer()).__assign(o + __p.bb_pos, __p.bb) : null; } }
  /// This flag is true if and only if the indices matrix is sorted in
  /// row-major order, and does not have duplicated entries.
  /// This sort order is the same as of Tensorflow's SparseTensor,
  /// but it is inverse order of SciPy's canonical coo_matrix
  /// (SciPy employs column-major order for its coo_matrix).
  public bool IsCanonical { get { int o = __p.__offset(10); return o != 0 ? 0!=__p.bb.Get(o + __p.bb_pos) : (bool)false; } }

  public static void StartSparseTensorIndexCOO(FlatBufferBuilder builder) { builder.StartTable(4); }
  public static void AddIndicesType(FlatBufferBuilder builder, Offset<Int> indicesTypeOffset) { builder.AddOffset(0, indicesTypeOffset.Value, 0); }
  public static void AddIndicesStrides(FlatBufferBuilder builder, VectorOffset indicesStridesOffset) { builder.AddOffset(1, indicesStridesOffset.Value, 0); }
  public static VectorOffset CreateIndicesStridesVector(FlatBufferBuilder builder, long[] data) { builder.StartVector(8, data.Length, 8); for (int i = data.Length - 1; i >= 0; i--) builder.AddLong(data[i]); return builder.EndVector(); }
  public static VectorOffset CreateIndicesStridesVectorBlock(FlatBufferBuilder builder, long[] data) { builder.StartVector(8, data.Length, 8); builder.Add(data); return builder.EndVector(); }
  public static VectorOffset CreateIndicesStridesVectorBlock(FlatBufferBuilder builder, ArraySegment<long> data) { builder.StartVector(8, data.Count, 8); builder.Add(data); return builder.EndVector(); }
  public static VectorOffset CreateIndicesStridesVectorBlock(FlatBufferBuilder builder, IntPtr dataPtr, int sizeInBytes) { builder.StartVector(1, sizeInBytes, 1); builder.Add<long>(dataPtr, sizeInBytes); return builder.EndVector(); }
  public static void StartIndicesStridesVector(FlatBufferBuilder builder, int numElems) { builder.StartVector(8, numElems, 8); }
  public static void AddIndicesBuffer(FlatBufferBuilder builder, Offset<Buffer> indicesBufferOffset) { builder.AddStruct(2, indicesBufferOffset.Value, 0); }
  public static void AddIsCanonical(FlatBufferBuilder builder, bool isCanonical) { builder.AddBool(3, isCanonical, false); }
  public static Offset<SparseTensorIndexCOO> EndSparseTensorIndexCOO(FlatBufferBuilder builder) {
    int o = builder.EndTable();
    builder.Required(o, 4);  // indicesType
    builder.Required(o, 8);  // indicesBuffer
    return new Offset<SparseTensorIndexCOO>(o);
  }
}


static internal class SparseTensorIndexCOOVerify
{
  static public bool Verify(Google.FlatBuffers.Verifier verifier, uint tablePos)
  {
    return verifier.VerifyTableStart(tablePos)
      && verifier.VerifyTable(tablePos, 4 /*IndicesType*/, IntVerify.Verify, true)
      && verifier.VerifyVectorOfData(tablePos, 6 /*IndicesStrides*/, 8 /*long*/, false)
      && verifier.VerifyField(tablePos, 8 /*IndicesBuffer*/, 16 /*Buffer*/, 8, true)
      && verifier.VerifyField(tablePos, 10 /*IsCanonical*/, 1 /*bool*/, 1, false)
      && verifier.VerifyTableEnd(tablePos);
  }
}

}
