/**
 * Error thrown during translation parsing
 */
export class TranslationParserError extends Error {
  /**
   * @param {string} message - Error message
   * @param {number} [position] - Position in the translation string where the error occurred
   * @param {string} [translationString] - The full translation string being parsed
   */
  constructor(message, position, translationString) {
    super(message);

    this.name = 'TranslationParserError';

    this.position = position;

    this.translationString = translationString;

    // Maintains proper stack trace for where our error was thrown (only available on V8)
    if (Error.captureStackTrace) {
      Error.captureStackTrace(this, TranslationParserError);
    }
  }
}
