/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.ClassSpecification;
import proguard.MemberSpecification;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;

public class AssumeNoSideEffectsChecker {
    private final WarningPrinter notePrinter;

    public AssumeNoSideEffectsChecker(WarningPrinter notePrinter) {
        this.notePrinter = notePrinter;
    }

    public void checkClassSpecifications(List classSpecifications) {
        if (classSpecifications != null) {
            for (int classSpecificationIndex = 0; classSpecificationIndex < classSpecifications.size(); ++classSpecificationIndex) {
                List methodSpecifications;
                ClassSpecification classSpecification = (ClassSpecification)classSpecifications.get(classSpecificationIndex);
                String className = classSpecification.className;
                if (className == null) {
                    className = classSpecification.extendsClassName;
                }
                if (className != null && !this.notePrinter.accepts(className) || (methodSpecifications = classSpecification.methodSpecifications) == null) continue;
                for (int methodSpecificationIndex = 0; methodSpecificationIndex < methodSpecifications.size(); ++methodSpecificationIndex) {
                    MemberSpecification methodSpecification = (MemberSpecification)methodSpecifications.get(methodSpecificationIndex);
                    if (methodSpecification.name != null || methodSpecification.descriptor != null) continue;
                    this.notePrinter.print(className == null ? "*" : className, "Note: the configuration specifies that none of the methods of class '" + (className == null ? "*" : ClassUtil.externalClassName(className)) + "' have any side effects");
                }
            }
        }
    }
}

