/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.transfer;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.Precision;
import proguard.analysis.cpa.interfaces.ProgramLocationDependentTransferRelation;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCallCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmInstructionCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.util.ConstantLookupVisitor;
import proguard.analysis.cpa.jvm.util.InstructionClassifier;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.MethodSignature;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionUtil;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.ClassConstantValueFactory;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ParticularValueFactory;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;

public abstract class JvmTransferRelation<StateT extends LatticeAbstractState<StateT>>
implements ProgramLocationDependentTransferRelation<JvmCfaNode, JvmCfaEdge, MethodSignature> {
    @Override
    public AbstractState getEdgeAbstractSuccessor(AbstractState abstractState, JvmCfaEdge edge, Precision precision) {
        if (!(abstractState instanceof JvmAbstractState)) {
            throw new IllegalArgumentException(this.getClass().getName() + " does not support " + abstractState.getClass().getName());
        }
        JvmAbstractState state = (JvmAbstractState)abstractState;
        JvmAbstractState<StateT> successor = state.copy();
        if (edge instanceof JvmCallCfaEdge) {
            successor.setProgramLocation(edge.getSource().getLeavingEdges().stream().filter(JvmInstructionCfaEdge.class::isInstance).findFirst().get().getTarget());
            this.processCall(successor, ((JvmCallCfaEdge)edge).getCall());
        } else {
            successor.setProgramLocation(edge.getTarget());
            if (edge instanceof JvmInstructionCfaEdge) {
                Instruction instruction = ((JvmInstructionCfaEdge)edge).getInstruction();
                if (InstructionClassifier.isInvoke(instruction.opcode)) {
                    return null;
                }
                successor = this.getAbstractSuccessorForInstruction(successor, ((JvmInstructionCfaEdge)edge).getInstruction(), state.getProgramLocation().getClazz(), precision);
            }
        }
        return successor;
    }

    protected JvmAbstractState<StateT> getAbstractSuccessorForInstruction(JvmAbstractState<StateT> abstractState, Instruction instruction, Clazz clazz, Precision precision) {
        instruction.accept(clazz, null, null, 0, new InstructionAbstractInterpreter(abstractState));
        return abstractState;
    }

    protected List<StateT> applyInstruction(Instruction instruction, List<StateT> operands, int resultCount) {
        ArrayList<LatticeAbstractState> answer = new ArrayList<LatticeAbstractState>(resultCount);
        LatticeAbstractState answerContent = (LatticeAbstractState)operands.stream().reduce(this.getAbstractDefault(), LatticeAbstractState::join);
        for (int i = 0; i < resultCount; ++i) {
            answer.add(answerContent);
        }
        return answer;
    }

    public StateT getAbstractByteConstant(byte b) {
        return this.getAbstractDefault();
    }

    public abstract StateT getAbstractDefault();

    public List<StateT> getAbstractDoubleConstant(double d) {
        return Arrays.asList(this.getAbstractDefault(), this.getAbstractDefault());
    }

    public StateT getAbstractFloatConstant(float f) {
        return this.getAbstractDefault();
    }

    public StateT getAbstractIntegerConstant(int i) {
        return this.getAbstractDefault();
    }

    public List<StateT> getAbstractLongConstant(long l) {
        return Arrays.asList(this.getAbstractDefault(), this.getAbstractDefault());
    }

    public StateT getAbstractNull() {
        return this.getAbstractDefault();
    }

    public StateT getAbstractShortConstant(short s) {
        return this.getAbstractDefault();
    }

    protected void processCall(JvmAbstractState<StateT> state, Call call) {
        boolean isStatic = call.invocationOpcode == -72 || call.invocationOpcode == -70;
        ArrayList<StateT> operands = new ArrayList<StateT>();
        if (call.getTarget().descriptor.argumentTypes != null) {
            List<String> argumentTypes = call.getTarget().descriptor.argumentTypes;
            for (int i = argumentTypes.size() - 1; i >= 0; --i) {
                boolean isCategory2 = ClassUtil.isInternalCategory2Type(argumentTypes.get(i));
                if (isCategory2) {
                    StateT higherByte = state.pop();
                    operands.add(state.pop());
                    operands.add(higherByte);
                    continue;
                }
                operands.add(state.pop());
            }
        }
        if (!isStatic) {
            operands.add(state.pop());
        }
        Collections.reverse(operands);
        this.invokeMethod(state, call, operands);
    }

    public void invokeMethod(JvmAbstractState<StateT> state, Call call, List<StateT> operands) {
        int pushCount = ClassUtil.internalTypeSize(call.getTarget().descriptor.returnType == null ? "?" : call.getTarget().descriptor.returnType);
        LatticeAbstractState answerContent = (LatticeAbstractState)operands.stream().reduce(this.getAbstractDefault(), LatticeAbstractState::join);
        for (int i = 0; i < pushCount; ++i) {
            state.push(answerContent);
        }
    }

    protected StateT isInstanceOf(StateT state, String type) {
        return this.getAbstractDefault();
    }

    private class InstructionAbstractInterpreter
    implements InstructionVisitor {
        private final JvmAbstractState<StateT> abstractState;
        private final ClassConstantValueFactory classConstantValueFactory = new ClassConstantValueFactory(new ParticularValueFactory());
        private final ConstantLookupVisitor constantLookupVisitor = new ConstantLookupVisitor();

        public InstructionAbstractInterpreter(JvmAbstractState<StateT> abstractState) {
            this.abstractState = abstractState;
        }

        @Override
        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            switch (simpleInstruction.opcode) {
                case 1: {
                    this.abstractState.push(JvmTransferRelation.this.getAbstractNull());
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.abstractState.push(JvmTransferRelation.this.getAbstractIntegerConstant(simpleInstruction.constant));
                    break;
                }
                case 9: 
                case 10: {
                    this.abstractState.pushAll(JvmTransferRelation.this.getAbstractLongConstant(simpleInstruction.constant));
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    this.abstractState.push(JvmTransferRelation.this.getAbstractFloatConstant(simpleInstruction.constant));
                    break;
                }
                case 14: 
                case 15: {
                    this.abstractState.pushAll(JvmTransferRelation.this.getAbstractDoubleConstant(simpleInstruction.constant));
                    break;
                }
                case 46: 
                case 48: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    Object index = this.abstractState.pop();
                    this.abstractState.push(this.abstractState.getArrayElementOrDefault(this.abstractState.pop(), index, JvmTransferRelation.this.getAbstractDefault()));
                    break;
                }
                case 47: 
                case 49: {
                    Object index = this.abstractState.pop();
                    Object array = this.abstractState.pop();
                    this.abstractState.push(JvmTransferRelation.this.getAbstractDefault());
                    this.abstractState.push(this.abstractState.getArrayElementOrDefault(array, index, JvmTransferRelation.this.getAbstractDefault()));
                    break;
                }
                case 79: 
                case 81: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    Object value = this.abstractState.pop();
                    Object index = this.abstractState.pop();
                    this.abstractState.setArrayElement(this.abstractState.pop(), index, value);
                    break;
                }
                case 80: 
                case 82: {
                    Object value = this.abstractState.pop();
                    this.abstractState.pop();
                    Object index = this.abstractState.pop();
                    this.abstractState.setArrayElement(this.abstractState.pop(), index, value);
                    break;
                }
                case 16: {
                    this.abstractState.push(JvmTransferRelation.this.getAbstractByteConstant((byte)simpleInstruction.constant));
                    break;
                }
                case 17: {
                    this.abstractState.push(JvmTransferRelation.this.getAbstractShortConstant((short)simpleInstruction.constant));
                    break;
                }
                case -62: 
                case -61: 
                case 87: {
                    this.abstractState.pop();
                    break;
                }
                case 88: {
                    this.abstractState.pop();
                    this.abstractState.pop();
                    break;
                }
                case 89: {
                    this.abstractState.push(this.abstractState.peek());
                    break;
                }
                case 90: {
                    Object state1 = this.abstractState.pop();
                    Object state2 = this.abstractState.pop();
                    this.abstractState.push(state1);
                    this.abstractState.push(state2);
                    this.abstractState.push(state1);
                    break;
                }
                case 91: {
                    Object state1 = this.abstractState.pop();
                    Object state2 = this.abstractState.pop();
                    Object state3 = this.abstractState.pop();
                    this.abstractState.push(state1);
                    this.abstractState.push(state3);
                    this.abstractState.push(state2);
                    this.abstractState.push(state1);
                    break;
                }
                case 92: {
                    Object state1 = this.abstractState.peek();
                    Object state2 = this.abstractState.peek(1);
                    this.abstractState.push(state2);
                    this.abstractState.push(state1);
                    break;
                }
                case 93: {
                    Object state1 = this.abstractState.pop();
                    Object state2 = this.abstractState.pop();
                    Object state3 = this.abstractState.pop();
                    this.abstractState.push(state2);
                    this.abstractState.push(state1);
                    this.abstractState.push(state3);
                    this.abstractState.push(state2);
                    this.abstractState.push(state1);
                    break;
                }
                case 94: {
                    Object state1 = this.abstractState.pop();
                    Object state2 = this.abstractState.pop();
                    Object state3 = this.abstractState.pop();
                    Object state4 = this.abstractState.pop();
                    this.abstractState.push(state2);
                    this.abstractState.push(state1);
                    this.abstractState.push(state4);
                    this.abstractState.push(state3);
                    this.abstractState.push(state2);
                    this.abstractState.push(state1);
                    break;
                }
                case 95: {
                    Object state1 = this.abstractState.pop();
                    Object state2 = this.abstractState.pop();
                    this.abstractState.push(state1);
                    this.abstractState.push(state2);
                    break;
                }
                case -84: 
                case -83: 
                case -82: 
                case -81: 
                case -80: 
                case -79: {
                    break;
                }
                case -65: {
                    Object exceptionState = this.abstractState.pop();
                    this.abstractState.clearOperandStack();
                    this.abstractState.push(exceptionState);
                    break;
                }
                default: {
                    ArrayList operands = new ArrayList(simpleInstruction.stackPopCount(clazz));
                    if (InstructionClassifier.isLongShift(simpleInstruction.opcode)) {
                        operands.add(this.abstractState.pop());
                        Object higherByte = this.abstractState.pop();
                        operands.add(this.abstractState.pop());
                        operands.add(higherByte);
                    } else {
                        for (int i = 0; i < simpleInstruction.stackPopCount(clazz) / (simpleInstruction.isCategory2() ? 2 : 1); ++i) {
                            if (simpleInstruction.isCategory2()) {
                                Object higherByte = this.abstractState.pop();
                                operands.add(this.abstractState.pop());
                                operands.add(higherByte);
                                continue;
                            }
                            operands.add(this.abstractState.pop());
                        }
                    }
                    Collections.reverse(operands);
                    this.abstractState.pushAll(JvmTransferRelation.this.applyInstruction(simpleInstruction, operands, simpleInstruction.stackPushCount(clazz)));
                }
            }
        }

        @Override
        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
            if (variableInstruction.opcode == -124) {
                ArrayList operands = new ArrayList(2);
                operands.add(this.abstractState.getVariableOrDefault(variableInstruction.variableIndex, JvmTransferRelation.this.getAbstractDefault()));
                operands.add(JvmTransferRelation.this.getAbstractIntegerConstant(variableInstruction.constant));
                List res = JvmTransferRelation.this.applyInstruction(variableInstruction, operands, 1);
                if (res.size() != 1) {
                    throw new IllegalStateException("applyInstruction should return a list of size 1");
                }
                this.abstractState.setVariable(variableInstruction.variableIndex, (LatticeAbstractState)res.get(0), (LatticeAbstractState)JvmTransferRelation.this.getAbstractDefault());
            } else if (variableInstruction.isLoad()) {
                if (variableInstruction.isCategory2()) {
                    this.abstractState.push(this.abstractState.getVariableOrDefault(variableInstruction.variableIndex + 1, JvmTransferRelation.this.getAbstractDefault()));
                }
                this.abstractState.push(this.abstractState.getVariableOrDefault(variableInstruction.variableIndex, JvmTransferRelation.this.getAbstractDefault()));
            } else if (variableInstruction.isStore()) {
                this.abstractState.setVariable(variableInstruction.variableIndex, this.abstractState.pop(), JvmTransferRelation.this.getAbstractDefault());
                if (variableInstruction.isCategory2()) {
                    this.abstractState.setVariable(variableInstruction.variableIndex + 1, this.abstractState.pop(), JvmTransferRelation.this.getAbstractDefault());
                }
            }
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            this.constantLookupVisitor.resetResult();
            switch (constantInstruction.opcode) {
                case 18: 
                case 19: 
                case 20: {
                    this.abstractState.pushAll(this.getAbstactValue(this.classConstantValueFactory.constantValue(clazz, constantInstruction.constantIndex)));
                    break;
                }
                case -78: {
                    this.constantLookupVisitor.isStatic = true;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    if (this.constantLookupVisitor.resultSize > 1) {
                        this.abstractState.push(JvmTransferRelation.this.getAbstractDefault());
                    }
                    this.abstractState.push(this.abstractState.getStaticOrDefault(this.constantLookupVisitor.result, JvmTransferRelation.this.getAbstractDefault()));
                    break;
                }
                case -77: {
                    this.constantLookupVisitor.isStatic = true;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    Object value = this.abstractState.pop();
                    if (this.constantLookupVisitor.resultSize > 1) {
                        this.abstractState.pop();
                    }
                    this.abstractState.setStatic(this.constantLookupVisitor.result, value);
                    break;
                }
                case -76: {
                    this.constantLookupVisitor.isStatic = false;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    Object result = this.abstractState.getFieldOrDefault(this.abstractState.pop(), this.constantLookupVisitor.result, JvmTransferRelation.this.getAbstractDefault());
                    if (this.constantLookupVisitor.resultSize > 1) {
                        this.abstractState.push(JvmTransferRelation.this.getAbstractDefault());
                    }
                    this.abstractState.push(result);
                    break;
                }
                case -75: {
                    this.constantLookupVisitor.isStatic = false;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    Object value = this.abstractState.pop();
                    if (this.constantLookupVisitor.resultSize > 1) {
                        this.abstractState.pop();
                    }
                    this.abstractState.setField(this.abstractState.pop(), this.constantLookupVisitor.result, value);
                    break;
                }
                case -74: 
                case -73: 
                case -72: 
                case -71: 
                case -70: {
                    throw new IllegalStateException(this.getClass().getName() + " encountered an unexpected call instruction");
                }
                case -63: {
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    this.abstractState.push(JvmTransferRelation.this.isInstanceOf(this.abstractState.pop(), this.constantLookupVisitor.result));
                    break;
                }
                case -69: {
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    this.abstractState.push(this.abstractState.newObject(this.constantLookupVisitor.result));
                    break;
                }
                case -68: {
                    this.abstractState.push(this.abstractState.newArray(String.valueOf(InstructionUtil.internalTypeFromArrayType((byte)constantInstruction.constant)), Collections.singletonList(this.abstractState.pop())));
                    break;
                }
                case -67: {
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    this.abstractState.push(this.abstractState.newArray(this.constantLookupVisitor.result, Collections.singletonList(this.abstractState.pop())));
                    break;
                }
                case -59: {
                    ArrayList dimensions = new ArrayList(constantInstruction.constant);
                    for (int i = 0; i < constantInstruction.stackPopCount(clazz); ++i) {
                        dimensions.add(this.abstractState.pop());
                    }
                    Collections.reverse(dimensions);
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    this.abstractState.push(this.abstractState.newArray(this.constantLookupVisitor.result, dimensions));
                    break;
                }
                case -64: {
                    break;
                }
                default: {
                    throw new InvalidParameterException("The opcode " + constantInstruction.opcode + " is not supported by the constant instruction visitor");
                }
            }
        }

        @Override
        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
            int i;
            for (i = 0; i < branchInstruction.stackPopCount(clazz); ++i) {
                this.abstractState.pop();
            }
            for (i = 0; i < branchInstruction.stackPushCount(clazz); ++i) {
                this.abstractState.push(JvmTransferRelation.this.getAbstractDefault());
            }
        }

        @Override
        public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction switchInstruction) {
            for (int i = 0; i < switchInstruction.stackPopCount(clazz); ++i) {
                this.abstractState.pop();
            }
        }

        private List<StateT> getAbstactValue(Value value) {
            if (value instanceof IntegerValue) {
                return Collections.singletonList(JvmTransferRelation.this.getAbstractIntegerConstant(((IntegerValue)value).value()));
            }
            if (value instanceof LongValue) {
                return JvmTransferRelation.this.getAbstractLongConstant(((LongValue)value).value());
            }
            if (value instanceof FloatValue) {
                return Collections.singletonList(JvmTransferRelation.this.getAbstractFloatConstant(((FloatValue)value).value()));
            }
            if (value instanceof DoubleValue) {
                return JvmTransferRelation.this.getAbstractDoubleConstant(((DoubleValue)value).value());
            }
            if (value instanceof ReferenceValue) {
                return Collections.singletonList(JvmTransferRelation.this.getAbstractDefault());
            }
            return Collections.singletonList(JvmTransferRelation.this.getAbstractDefault());
        }
    }
}

