/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.AppView;
import proguard.Configuration;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVersionSetter;
import proguard.pass.Pass;

public class Targeter
implements Pass {
    private static final Logger logger = LogManager.getLogger(Targeter.class);
    private final Configuration configuration;

    public Targeter(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void execute(AppView appView) throws IOException {
        logger.info("Setting target versions...");
        HashSet<Integer> newerClassVersions = this.configuration.warn != null ? null : new HashSet<Integer>();
        appView.programClassPool.classesAccept(new ClassVersionSetter(this.configuration.targetClassVersion, newerClassVersions));
        if (newerClassVersions != null && newerClassVersions.size() > 0) {
            logger.error("Warning: some classes have more recent versions (");
            Iterator iterator2 = newerClassVersions.iterator();
            while (iterator2.hasNext()) {
                Integer classVersion = (Integer)iterator2.next();
                logger.error(ClassUtil.externalClassVersion(classVersion));
                if (!iterator2.hasNext()) continue;
                logger.error(",");
            }
            logger.error(")");
            logger.error("         than the target version ({}).", (Object)ClassUtil.externalClassVersion(this.configuration.targetClassVersion));
            if (!this.configuration.ignoreWarnings) {
                logger.error("         If you are sure this is not a problem,");
                logger.error("         you could try your luck using the '-ignorewarnings' option.");
                throw new IOException("Please correct the above warnings first.");
            }
        }
    }
}

