/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import proguard.util.StringMatcher;

public class ListUtil {
    public static List concatenate(List list1, List list2) {
        if (list1 != null) {
            if (list2 != null) {
                ArrayList list = new ArrayList(list1);
                list.addAll(list2);
                return list;
            }
            return list1;
        }
        return list2;
    }

    public static List<String> filter(Collection<String> list, StringMatcher filter) {
        ArrayList<String> filteredList = new ArrayList<String>();
        for (String string : list) {
            if (!filter.matches(string)) continue;
            filteredList.add(string);
        }
        return filteredList;
    }

    public static String commaSeparatedString(List list, boolean quoteStrings) {
        if (list == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < list.size(); ++index) {
            if (index > 0) {
                buffer.append(',');
            }
            String string = (String)list.get(index);
            if (quoteStrings) {
                string = ListUtil.quotedString(string);
            }
            buffer.append(string);
        }
        return buffer.toString();
    }

    public static List commaSeparatedList(String string) {
        if (string == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int index = 0;
        while ((index = ListUtil.skipWhitespace(string, index)) < string.length()) {
            int nextIndex;
            if (string.charAt(index) == '\'') {
                nextIndex = string.indexOf(39, index + 1);
                if (nextIndex < 0) {
                    nextIndex = string.length();
                }
                list.add(string.substring(index + 1, nextIndex));
            } else {
                String substring;
                nextIndex = string.indexOf(44, index);
                if (nextIndex < 0) {
                    nextIndex = string.length();
                }
                if ((substring = string.substring(index, nextIndex).trim()).length() > 0) {
                    list.add(substring);
                }
            }
            index = nextIndex + 1;
        }
        return list;
    }

    public static int[] toIntArray(List<Integer> integerList) {
        int[] intArray = new int[integerList.size()];
        for (int i = 0; i < intArray.length; ++i) {
            intArray[i] = integerList.get(i);
        }
        return intArray;
    }

    private static int skipWhitespace(String string, int index) {
        while (index < string.length() && Character.isWhitespace(string.charAt(index))) {
            ++index;
        }
        return index;
    }

    private static String quotedString(String string) {
        return string.length() == 0 || string.indexOf(32) >= 0 || string.indexOf(64) >= 0 || string.indexOf(123) >= 0 || string.indexOf(125) >= 0 || string.indexOf(40) >= 0 || string.indexOf(41) >= 0 || string.indexOf(58) >= 0 || string.indexOf(59) >= 0 || string.indexOf(44) >= 0 ? "'" + string + "'" : string;
    }

    public static void main(String[] args2) {
        if (args2.length == 1) {
            System.out.println("Input string: [" + args2[0] + "]");
            List list = ListUtil.commaSeparatedList(args2[0]);
            System.out.println("Resulting list:");
            for (int index = 0; index < list.size(); ++index) {
                System.out.println("[" + list.get(index) + "]");
            }
        } else {
            List<String> list = Arrays.asList(args2);
            System.out.println("Input list:");
            for (int index = 0; index < list.size(); ++index) {
                System.out.println("[" + list.get(index) + "]");
            }
            String string = ListUtil.commaSeparatedString(list, true);
            System.out.println("Resulting string: [" + string + "]");
        }
    }
}

