/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.transparency;

import com.android.tools.build.bundletool.transparency.AutoValue_TransparencyCheckResult;
import com.google.auto.value.AutoValue;
import java.util.Optional;

@AutoValue
public abstract class TransparencyCheckResult {
    abstract boolean transparencySignatureVerified();

    abstract boolean fileContentsVerified();

    public abstract Optional<String> transparencyKeyCertificateFingerprint();

    public abstract Optional<String> apkSigningKeyCertificateFingerprint();

    public abstract Optional<String> errorMessage();

    public boolean verified() {
        return this.transparencySignatureVerified() && this.fileContentsVerified();
    }

    public String getTransparencyKeyCertificateFingerprint() {
        return this.transparencyKeyCertificateFingerprint().orElse("");
    }

    public String getApkSigningKeyCertificateFingerprint() {
        return this.apkSigningKeyCertificateFingerprint().orElse("");
    }

    public String getErrorMessage() {
        return this.errorMessage().orElse("");
    }

    public static Builder builder() {
        return new AutoValue_TransparencyCheckResult.Builder().transparencySignatureVerified(false).fileContentsVerified(false);
    }

    public static TransparencyCheckResult empty() {
        return TransparencyCheckResult.builder().build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder transparencySignatureVerified(boolean var1);

        public abstract Builder fileContentsVerified(boolean var1);

        public abstract Builder transparencyKeyCertificateFingerprint(String var1);

        public abstract Builder apkSigningKeyCertificateFingerprint(String var1);

        public abstract Builder errorMessage(String var1);

        public abstract TransparencyCheckResult build();
    }
}

