/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.keys.resolvers;

import java.security.Key;
import java.util.List;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;
import org.jose4j.lang.UnresolvableKeyException;

public class EmbeddedJwkVerificationKeyResolver
implements VerificationKeyResolver {
    private PublicJsonWebKey jwk;

    @Override
    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        try {
            this.jwk = jws.getJwkHeader();
        }
        catch (JoseException e11) {
            throw new UnresolvableKeyException("Problem processing jwk from JWS header", e11);
        }
        if (this.jwk == null) {
            throw new UnresolvableKeyException("No jwk in JWS header");
        }
        return this.jwk.getKey();
    }

    public PublicJsonWebKey getJwk() {
        return this.jwk;
    }
}

