"""Fake DBus Information."""

import dbus

FAKE_RESOURCES = (
    dbus.UInt32(4),
    dbus.Array(
        [
            dbus.Struct(
                (
                    dbus.UInt32(0),
                    dbus.Int64(440),
                    dbus.Int32(0),
                    dbus.Int32(0),
                    dbus.Int32(2560),
                    dbus.Int32(1440),
                    dbus.Int32(0),
                    dbus.UInt32(0),
                    dbus.Array(
                        [
                            dbus.UInt32(0),
                            dbus.UInt32(1),
                            dbus.UInt32(2),
                            dbus.UInt32(3),
                            dbus.UInt32(4),
                            dbus.UInt32(5),
                            dbus.UInt32(6),
                            dbus.UInt32(7),
                        ],
                        signature=dbus.Signature("u"),
                    ),
                    dbus.Dictionary({}, signature=dbus.Signature("sv")),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(1),
                    dbus.Int64(441),
                    dbus.Int32(0),
                    dbus.Int32(0),
                    dbus.Int32(0),
                    dbus.Int32(0),
                    dbus.Int32(-1),
                    dbus.UInt32(0),
                    dbus.Array(
                        [
                            dbus.UInt32(0),
                            dbus.UInt32(1),
                            dbus.UInt32(2),
                            dbus.UInt32(3),
                            dbus.UInt32(4),
                            dbus.UInt32(5),
                            dbus.UInt32(6),
                            dbus.UInt32(7),
                        ],
                        signature=dbus.Signature("u"),
                    ),
                    dbus.Dictionary({}, signature=dbus.Signature("sv")),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(2),
                    dbus.Int64(442),
                    dbus.Int32(0),
                    dbus.Int32(0),
                    dbus.Int32(0),
                    dbus.Int32(0),
                    dbus.Int32(-1),
                    dbus.UInt32(0),
                    dbus.Array(
                        [
                            dbus.UInt32(0),
                            dbus.UInt32(1),
                            dbus.UInt32(2),
                            dbus.UInt32(3),
                            dbus.UInt32(4),
                            dbus.UInt32(5),
                            dbus.UInt32(6),
                            dbus.UInt32(7),
                        ],
                        signature=dbus.Signature("u"),
                    ),
                    dbus.Dictionary({}, signature=dbus.Signature("sv")),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(3),
                    dbus.Int64(443),
                    dbus.Int32(0),
                    dbus.Int32(0),
                    dbus.Int32(0),
                    dbus.Int32(0),
                    dbus.Int32(-1),
                    dbus.UInt32(0),
                    dbus.Array(
                        [
                            dbus.UInt32(0),
                            dbus.UInt32(1),
                            dbus.UInt32(2),
                            dbus.UInt32(3),
                            dbus.UInt32(4),
                            dbus.UInt32(5),
                            dbus.UInt32(6),
                            dbus.UInt32(7),
                        ],
                        signature=dbus.Signature("u"),
                    ),
                    dbus.Dictionary({}, signature=dbus.Signature("sv")),
                ),
                signature=None,
            ),
        ],
        signature=dbus.Signature("(uxiiiiiuaua{sv})"),
    ),
    dbus.Array(
        [
            dbus.Struct(
                (
                    dbus.UInt32(0),
                    dbus.Int64(449),
                    dbus.Int32(0),
                    dbus.Array(
                        [
                            dbus.UInt32(0),
                            dbus.UInt32(1),
                            dbus.UInt32(2),
                            dbus.UInt32(3),
                        ],
                        signature=dbus.Signature("u"),
                    ),
                    dbus.String("DP-2"),
                    dbus.Array(
                        [
                            dbus.UInt32(0),
                            dbus.UInt32(1),
                            dbus.UInt32(2),
                            dbus.UInt32(3),
                            dbus.UInt32(4),
                            dbus.UInt32(5),
                            dbus.UInt32(6),
                            dbus.UInt32(7),
                            dbus.UInt32(8),
                            dbus.UInt32(9),
                            dbus.UInt32(10),
                            dbus.UInt32(11),
                            dbus.UInt32(12),
                            dbus.UInt32(13),
                            dbus.UInt32(14),
                            dbus.UInt32(15),
                            dbus.UInt32(16),
                            dbus.UInt32(17),
                            dbus.UInt32(18),
                            dbus.UInt32(19),
                            dbus.UInt32(20),
                            dbus.UInt32(21),
                            dbus.UInt32(22),
                            dbus.UInt32(23),
                            dbus.UInt32(24),
                            dbus.UInt32(25),
                            dbus.UInt32(26),
                            dbus.UInt32(27),
                            dbus.UInt32(28),
                            dbus.UInt32(29),
                            dbus.UInt32(30),
                            dbus.UInt32(31),
                        ],
                        signature=dbus.Signature("u"),
                    ),
                    dbus.Array([], signature=dbus.Signature("u")),
                    dbus.Dictionary(
                        {
                            dbus.String("vendor"): dbus.String("VSC", variant_level=1),
                            dbus.String("product"): dbus.String(
                                "VP2768a", variant_level=1
                            ),
                            dbus.String("serial"): dbus.String(
                                "W000000000000", variant_level=1
                            ),
                            dbus.String("width-mm"): dbus.Int32(597, variant_level=1),
                            dbus.String("height-mm"): dbus.Int32(336, variant_level=1),
                            dbus.String("display-name"): dbus.String(
                                "DP-2", variant_level=1
                            ),
                            dbus.String("backlight"): dbus.Int32(-1, variant_level=1),
                            dbus.String("min-backlight-step"): dbus.Int32(
                                -1, variant_level=1
                            ),
                            dbus.String("primary"): dbus.Boolean(True, variant_level=1),
                            dbus.String("presentation"): dbus.Boolean(
                                False, variant_level=1
                            ),
                            dbus.String("connector-type"): dbus.String(
                                "DisplayPort", variant_level=1
                            ),
                            dbus.String("underscanning"): dbus.Boolean(
                                False, variant_level=1
                            ),
                            dbus.String("supports-underscanning"): dbus.Boolean(
                                False, variant_level=1
                            ),
                            dbus.String("supports-color-transform"): dbus.Boolean(
                                True, variant_level=1
                            ),
                            dbus.String("edid"): dbus.Array(
                                [
                                    dbus.Byte(0),
                                    dbus.Byte(255),
                                    dbus.Byte(255),
                                    dbus.Byte(255),
                                    dbus.Byte(255),
                                    dbus.Byte(255),
                                    dbus.Byte(255),
                                    dbus.Byte(0),
                                    dbus.Byte(90),
                                    dbus.Byte(99),
                                    dbus.Byte(58),
                                    dbus.Byte(122),
                                    dbus.Byte(15),
                                    dbus.Byte(1),
                                    dbus.Byte(1),
                                    dbus.Byte(1),
                                    dbus.Byte(49),
                                    dbus.Byte(30),
                                    dbus.Byte(1),
                                    dbus.Byte(4),
                                    dbus.Byte(181),
                                    dbus.Byte(60),
                                    dbus.Byte(34),
                                    dbus.Byte(120),
                                    dbus.Byte(59),
                                    dbus.Byte(176),
                                    dbus.Byte(145),
                                    dbus.Byte(171),
                                    dbus.Byte(82),
                                    dbus.Byte(78),
                                    dbus.Byte(160),
                                    dbus.Byte(38),
                                    dbus.Byte(15),
                                    dbus.Byte(80),
                                    dbus.Byte(84),
                                    dbus.Byte(191),
                                    dbus.Byte(239),
                                    dbus.Byte(128),
                                    dbus.Byte(225),
                                    dbus.Byte(192),
                                    dbus.Byte(209),
                                    dbus.Byte(0),
                                    dbus.Byte(209),
                                    dbus.Byte(192),
                                    dbus.Byte(179),
                                    dbus.Byte(0),
                                    dbus.Byte(169),
                                    dbus.Byte(64),
                                    dbus.Byte(129),
                                    dbus.Byte(128),
                                    dbus.Byte(129),
                                    dbus.Byte(0),
                                    dbus.Byte(129),
                                    dbus.Byte(192),
                                    dbus.Byte(86),
                                    dbus.Byte(94),
                                    dbus.Byte(0),
                                    dbus.Byte(160),
                                    dbus.Byte(160),
                                    dbus.Byte(160),
                                    dbus.Byte(41),
                                    dbus.Byte(80),
                                    dbus.Byte(48),
                                    dbus.Byte(32),
                                    dbus.Byte(53),
                                    dbus.Byte(0),
                                    dbus.Byte(85),
                                    dbus.Byte(80),
                                    dbus.Byte(33),
                                    dbus.Byte(0),
                                    dbus.Byte(0),
                                    dbus.Byte(26),
                                    dbus.Byte(0),
                                    dbus.Byte(0),
                                    dbus.Byte(0),
                                    dbus.Byte(255),
                                    dbus.Byte(0),
                                    dbus.Byte(87),
                                    dbus.Byte(56),
                                    dbus.Byte(85),
                                    dbus.Byte(50),
                                    dbus.Byte(48),
                                    dbus.Byte(52),
                                    dbus.Byte(57),
                                    dbus.Byte(48),
                                    dbus.Byte(48),
                                    dbus.Byte(49),
                                    dbus.Byte(48),
                                    dbus.Byte(52),
                                    dbus.Byte(10),
                                    dbus.Byte(0),
                                    dbus.Byte(0),
                                    dbus.Byte(0),
                                    dbus.Byte(253),
                                    dbus.Byte(0),
                                    dbus.Byte(24),
                                    dbus.Byte(75),
                                    dbus.Byte(15),
                                    dbus.Byte(90),
                                    dbus.Byte(30),
                                    dbus.Byte(0),
                                    dbus.Byte(10),
                                    dbus.Byte(32),
                                    dbus.Byte(32),
                                    dbus.Byte(32),
                                    dbus.Byte(32),
                                    dbus.Byte(32),
                                    dbus.Byte(32),
                                    dbus.Byte(0),
                                    dbus.Byte(0),
                                    dbus.Byte(0),
                                    dbus.Byte(252),
                                    dbus.Byte(0),
                                    dbus.Byte(86),
                                    dbus.Byte(80),
                                    dbus.Byte(50),
                                    dbus.Byte(55),
                                    dbus.Byte(54),
                                    dbus.Byte(56),
                                    dbus.Byte(97),
                                    dbus.Byte(10),
                                    dbus.Byte(32),
                                    dbus.Byte(32),
                                    dbus.Byte(32),
                                    dbus.Byte(32),
                                    dbus.Byte(32),
                                    dbus.Byte(1),
                                    dbus.Byte(123),
                                    dbus.Byte(2),
                                    dbus.Byte(3),
                                    dbus.Byte(34),
                                    dbus.Byte(241),
                                    dbus.Byte(85),
                                    dbus.Byte(144),
                                    dbus.Byte(31),
                                    dbus.Byte(5),
                                    dbus.Byte(20),
                                    dbus.Byte(90),
                                    dbus.Byte(89),
                                    dbus.Byte(4),
                                    dbus.Byte(19),
                                    dbus.Byte(30),
                                    dbus.Byte(29),
                                    dbus.Byte(15),
                                    dbus.Byte(14),
                                    dbus.Byte(7),
                                    dbus.Byte(6),
                                    dbus.Byte(18),
                                    dbus.Byte(17),
                                    dbus.Byte(22),
                                    dbus.Byte(21),
                                    dbus.Byte(3),
                                    dbus.Byte(2),
                                    dbus.Byte(1),
                                    dbus.Byte(35),
                                    dbus.Byte(9),
                                    dbus.Byte(127),
                                    dbus.Byte(7),
                                    dbus.Byte(131),
                                    dbus.Byte(1),
                                    dbus.Byte(0),
                                    dbus.Byte(0),
                                    dbus.Byte(2),
                                    dbus.Byte(58),
                                    dbus.Byte(128),
                                    dbus.Byte(24),
                                    dbus.Byte(113),
                                    dbus.Byte(56),
                                    dbus.Byte(45),
                                    dbus.Byte(64),
                                    dbus.Byte(88),
                                    dbus.Byte(44),
                                    dbus.Byte(69),
                                    dbus.Byte(0),
                                    dbus.Byte(85),
                                    dbus.Byte(80),
                                    dbus.Byte(33),
                                    dbus.Byte(0),
                                    dbus.Byte(0),
                                    dbus.Byte(30),
                                    dbus.Byte(1),
                                    dbus.Byte(29),
                                    dbus.Byte(128),
                                    dbus.Byte(24),
                                    dbus.Byte(113),
                                    dbus.Byte(28),
                                    dbus.Byte(22),
                                    dbus.Byte(32),
                                    dbus.Byte(88),
                                    dbus.Byte(44),
                                    dbus.Byte(37),
                                    dbus.Byte(0),
                                    dbus.Byte(85),
                                    dbus.Byte(80),
                                    dbus.Byte(33),
                                    dbus.Byte(0),
                                    dbus.Byte(0),
                                    dbus.Byte(158),
                                    dbus.Byte(2),
                                    dbus.Byte(58),
                                    dbus.Byte(128),
                                    dbus.Byte(208),
                                    dbus.Byte(114),
                                    dbus.Byte(56),
                                    dbus.Byte(45),
                                    dbus.Byte(64),
                                    dbus.Byte(16),
                                    dbus.Byte(44),
                                    dbus.Byte(69),
                                    dbus.Byte(128),
                                    dbus.Byte(85),
                                    dbus.Byte(80),
                                    dbus.Byte(33),
                                    dbus.Byte(0),
                                    dbus.Byte(0),
                                    dbus.Byte(30),
                                    dbus.Byte(1),
                                    dbus.Byte(29),
                                    dbus.Byte(0),
                                    dbus.Byte(114),
                                    dbus.Byte(81),
                                    dbus.Byte(208),
                                    dbus.Byte(30),
                                    dbus.Byte(32),
                                    dbus.Byte(110),
                                    dbus.Byte(40),
                                    dbus.Byte(85),
                                    dbus.Byte(0),
                                    dbus.Byte(85),
                                    dbus.Byte(80),
                                    dbus.Byte(33),
                                    dbus.Byte(0),
                                    dbus.Byte(0),
                                    dbus.Byte(30),
                                    dbus.Byte(88),
                                    dbus.Byte(77),
                                    dbus.Byte(0),
                                    dbus.Byte(184),
                                    dbus.Byte(161),
                                    dbus.Byte(56),
                                    dbus.Byte(20),
                                    dbus.Byte(64),
                                    dbus.Byte(248),
                                    dbus.Byte(44),
                                    dbus.Byte(75),
                                    dbus.Byte(0),
                                    dbus.Byte(85),
                                    dbus.Byte(80),
                                    dbus.Byte(33),
                                    dbus.Byte(0),
                                    dbus.Byte(0),
                                    dbus.Byte(30),
                                    dbus.Byte(0),
                                    dbus.Byte(0),
                                    dbus.Byte(0),
                                    dbus.Byte(210),
                                ],
                                signature=dbus.Signature("y"),
                                variant_level=1,
                            ),
                        },
                        signature=dbus.Signature("sv"),
                    ),
                ),
                signature=None,
            )
        ],
        signature=dbus.Signature("(uxiausauaua{sv})"),
    ),
    dbus.Array(
        [
            dbus.Struct(
                (
                    dbus.UInt32(0),
                    dbus.Int64(450),
                    dbus.UInt32(2560),
                    dbus.UInt32(1440),
                    dbus.Double(59.9505500793457),
                    dbus.UInt32(9),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(1),
                    dbus.Int64(451),
                    dbus.UInt32(2560),
                    dbus.UInt32(1080),
                    dbus.Double(60.0),
                    dbus.UInt32(5),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(2),
                    dbus.Int64(452),
                    dbus.UInt32(2560),
                    dbus.UInt32(1080),
                    dbus.Double(59.93939208984375),
                    dbus.UInt32(5),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(3),
                    dbus.Int64(453),
                    dbus.UInt32(2560),
                    dbus.UInt32(1080),
                    dbus.Double(50.001346588134766),
                    dbus.UInt32(5),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(4),
                    dbus.Int64(454),
                    dbus.UInt32(2048),
                    dbus.UInt32(1152),
                    dbus.Double(60.0),
                    dbus.UInt32(5),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(5),
                    dbus.Int64(455),
                    dbus.UInt32(1920),
                    dbus.UInt32(1200),
                    dbus.Double(59.88460159301758),
                    dbus.UInt32(6),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(6),
                    dbus.Int64(456),
                    dbus.UInt32(1920),
                    dbus.UInt32(1080),
                    dbus.Double(60.0),
                    dbus.UInt32(5),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(7),
                    dbus.Int64(457),
                    dbus.UInt32(1920),
                    dbus.UInt32(1080),
                    dbus.Double(59.93939208984375),
                    dbus.UInt32(5),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(8),
                    dbus.Int64(458),
                    dbus.UInt32(1920),
                    dbus.UInt32(1080),
                    dbus.Double(50.0),
                    dbus.UInt32(5),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(9),
                    dbus.Int64(459),
                    dbus.UInt32(1680),
                    dbus.UInt32(1050),
                    dbus.Double(59.95425033569336),
                    dbus.UInt32(6),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(10),
                    dbus.Int64(460),
                    dbus.UInt32(1600),
                    dbus.UInt32(1200),
                    dbus.Double(60.0),
                    dbus.UInt32(5),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(11),
                    dbus.Int64(461),
                    dbus.UInt32(1440),
                    dbus.UInt32(576),
                    dbus.Double(50.0),
                    dbus.UInt32(6),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(12),
                    dbus.Int64(462),
                    dbus.UInt32(1440),
                    dbus.UInt32(480),
                    dbus.Double(59.940059661865234),
                    dbus.UInt32(10),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(13),
                    dbus.Int64(463),
                    dbus.UInt32(1280),
                    dbus.UInt32(1024),
                    dbus.Double(75.02467346191406),
                    dbus.UInt32(5),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(14),
                    dbus.Int64(464),
                    dbus.UInt32(1280),
                    dbus.UInt32(1024),
                    dbus.Double(60.01974105834961),
                    dbus.UInt32(5),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(15),
                    dbus.Int64(465),
                    dbus.UInt32(1280),
                    dbus.UInt32(800),
                    dbus.Double(59.810325622558594),
                    dbus.UInt32(6),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(16),
                    dbus.Int64(466),
                    dbus.UInt32(1280),
                    dbus.UInt32(720),
                    dbus.Double(60.0),
                    dbus.UInt32(5),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(17),
                    dbus.Int64(467),
                    dbus.UInt32(1280),
                    dbus.UInt32(720),
                    dbus.Double(59.94343566894531),
                    dbus.UInt32(5),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(18),
                    dbus.Int64(468),
                    dbus.UInt32(1280),
                    dbus.UInt32(720),
                    dbus.Double(50.0),
                    dbus.UInt32(5),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(19),
                    dbus.Int64(469),
                    dbus.UInt32(1024),
                    dbus.UInt32(768),
                    dbus.Double(75.02857971191406),
                    dbus.UInt32(5),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(20),
                    dbus.Int64(470),
                    dbus.UInt32(1024),
                    dbus.UInt32(768),
                    dbus.Double(70.0693588256836),
                    dbus.UInt32(10),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(21),
                    dbus.Int64(471),
                    dbus.UInt32(1024),
                    dbus.UInt32(768),
                    dbus.Double(60.003841400146484),
                    dbus.UInt32(10),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(22),
                    dbus.Int64(472),
                    dbus.UInt32(800),
                    dbus.UInt32(600),
                    dbus.Double(75.0),
                    dbus.UInt32(5),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(23),
                    dbus.Int64(473),
                    dbus.UInt32(800),
                    dbus.UInt32(600),
                    dbus.Double(72.18756866455078),
                    dbus.UInt32(5),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(24),
                    dbus.Int64(474),
                    dbus.UInt32(800),
                    dbus.UInt32(600),
                    dbus.Double(60.3165397644043),
                    dbus.UInt32(5),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(25),
                    dbus.Int64(475),
                    dbus.UInt32(800),
                    dbus.UInt32(600),
                    dbus.Double(56.25),
                    dbus.UInt32(5),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(26),
                    dbus.Int64(476),
                    dbus.UInt32(720),
                    dbus.UInt32(576),
                    dbus.Double(50.0),
                    dbus.UInt32(10),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(27),
                    dbus.Int64(477),
                    dbus.UInt32(720),
                    dbus.UInt32(480),
                    dbus.Double(59.940059661865234),
                    dbus.UInt32(10),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(28),
                    dbus.Int64(478),
                    dbus.UInt32(640),
                    dbus.UInt32(480),
                    dbus.Double(75.0),
                    dbus.UInt32(10),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(29),
                    dbus.Int64(479),
                    dbus.UInt32(640),
                    dbus.UInt32(480),
                    dbus.Double(72.80879974365234),
                    dbus.UInt32(10),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(30),
                    dbus.Int64(480),
                    dbus.UInt32(640),
                    dbus.UInt32(480),
                    dbus.Double(59.94047546386719),
                    dbus.UInt32(10),
                ),
                signature=None,
            ),
            dbus.Struct(
                (
                    dbus.UInt32(31),
                    dbus.Int64(481),
                    dbus.UInt32(640),
                    dbus.UInt32(480),
                    dbus.Double(59.92856979370117),
                    dbus.UInt32(10),
                ),
                signature=None,
            ),
        ],
        signature=dbus.Signature("(uxuudu)"),
    ),
    dbus.Int32(32767),
    dbus.Int32(32767),
)


class FakeDBusObject:
    """DBus class for mocking DBusObject."""

    def __init__(self, _, __, ___) -> None:
        """Fake init to catch arguments."""

    @staticmethod
    def get_resources():
        """Return DBus information."""
        return FAKE_RESOURCES
