/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Segment;
import kotlinx.io.SegmentKt;
import kotlinx.io._UtilKt;
import kotlinx.io.unsafe.BufferIterationContext;
import kotlinx.io.unsafe.SegmentReadContext;
import kotlinx.io.unsafe.UnsafeBufferOperations;
import kotlinx.io.unsafe.UnsafeBufferOperationsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001a\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a$\u0010\u0004\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001c\u0010\n\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a&\u0010\r\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u0006\u001a\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0013\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0001\u00a8\u0006\u0017"}, d2={"transferFrom", "Lkotlinx/io/Buffer;", "input", "Ljava/io/InputStream;", "write", "byteCount", "", "", "forever", "", "readTo", "out", "Ljava/io/OutputStream;", "copyTo", "startIndex", "endIndex", "readAtMostTo", "", "sink", "Ljava/nio/ByteBuffer;", "source", "asByteChannel", "Ljava/nio/channels/ByteChannel;", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nBuffersJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuffersJvm.kt\nkotlinx/io/BuffersJvmKt\n+ 2 -Util.kt\nkotlinx/io/_UtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n+ 5 Buffer.kt\nkotlinx/io/BufferKt\n+ 6 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperationsKt\n*L\n1#1,207:1\n52#2:208\n53#2:210\n109#2:217\n109#2:242\n112#2:260\n1#3:209\n1#3:239\n1#3:250\n1#3:286\n195#4,6:211\n203#4,20:218\n99#4:238\n100#4,2:240\n102#4,6:243\n347#4:249\n348#4,5:251\n353#4:258\n354#4:262\n355#4:284\n99#4:285\n100#4,8:287\n195#4,28:295\n651#5,2:256\n655#5,21:263\n434#6:259\n435#6:261\n*S KotlinDebug\n*F\n+ 1 BuffersJvm.kt\nkotlinx/io/BuffersJvmKt\n*L\n57#1:208\n57#1:210\n68#1:217\n101#1:242\n138#1:260\n57#1:209\n100#1:239\n133#1:250\n160#1:286\n67#1:211,6\n67#1:218,20\n100#1:238\n100#1:240,2\n100#1:243,6\n133#1:249\n133#1:251,5\n133#1:258\n133#1:262\n133#1:284\n160#1:285\n160#1:287,8\n180#1:295,28\n133#1:256,2\n133#1:263,21\n137#1:259\n137#1:261\n*E\n"})
public final class BuffersJvmKt {
    @NotNull
    public static final Buffer transferFrom(@NotNull Buffer $this$transferFrom, @NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)$this$transferFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        BuffersJvmKt.write($this$transferFrom, input, Long.MAX_VALUE, true);
        return $this$transferFrom;
    }

    @NotNull
    public static final Buffer write(@NotNull Buffer $this$write, @NotNull InputStream input, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        boolean $i$f$checkByteCount = false;
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount (" + byteCount + ") < 0";
            throw new IllegalArgumentException(string.toString());
        }
        BuffersJvmKt.write($this$write, input, byteCount, false);
        return $this$write;
    }

    /*
     * WARNING - void declaration
     */
    private static final void write(Buffer $this$write, InputStream input, long byteCount, boolean forever) {
        long remainingByteCount = 0L;
        remainingByteCount = byteCount;
        boolean exchaused = false;
        while (!exchaused && (remainingByteCount > 0L || forever)) {
            int bytesWritten$iv;
            int n;
            void a$iv;
            void pos;
            void limit;
            UnsafeBufferOperations unsafeBufferOperations = UnsafeBufferOperations.INSTANCE;
            int minimumCapacity$iv = 1;
            boolean $i$f$writeToTail = false;
            Segment tail$iv = $this$write.writableSegment(minimumCapacity$iv);
            byte[] data$iv = tail$iv.dataAsByteArray(false);
            int n2 = data$iv.length;
            int n3 = tail$iv.getLimit();
            byte[] data = data$iv;
            boolean bl = false;
            long l = remainingByteCount;
            void b$iv = limit - pos;
            boolean $i$f$minOf = false;
            int maxToCopy = (int)Math.min((long)a$iv, (long)b$iv);
            int bytesRead = input.read(data, (int)pos, maxToCopy);
            if (bytesRead == -1) {
                if (!forever) {
                    throw new EOFException("Stream exhausted before " + byteCount + " bytes were read.");
                }
                exchaused = true;
                n = 0;
            } else {
                remainingByteCount -= (long)bytesRead;
                n = bytesRead;
            }
            if ((bytesWritten$iv = n) == minimumCapacity$iv) {
                tail$iv.writeBackData(data$iv, bytesWritten$iv);
                tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                $this$write.setSizeMut($this$write.getSizeMut() + (long)bytesWritten$iv);
                continue;
            }
            if (!(0 <= bytesWritten$iv ? bytesWritten$iv <= tail$iv.getRemainingCapacity() : false)) {
                boolean bl2 = false;
                String string = "Invalid number of bytes written: " + bytesWritten$iv + ". Should be in 0.." + tail$iv.getRemainingCapacity();
                throw new IllegalStateException(string.toString());
            }
            if (bytesWritten$iv != 0) {
                tail$iv.writeBackData(data$iv, bytesWritten$iv);
                tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                $this$write.setSizeMut($this$write.getSizeMut() + (long)bytesWritten$iv);
                continue;
            }
            if (!SegmentKt.isEmpty(tail$iv)) continue;
            $this$write.recycleTail();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void readTo(@NotNull Buffer $this$readTo, @NotNull OutputStream out, long byteCount) {
        int toCopy;
        Intrinsics.checkNotNullParameter((Object)$this$readTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        _UtilKt.checkOffsetAndCount($this$readTo.getSize(), 0L, byteCount);
        long remainingByteCount = 0L;
        for (remainingByteCount = byteCount; remainingByteCount > 0L; remainingByteCount -= (long)toCopy) {
            void a$iv;
            void pos;
            void limit;
            Segment head$iv;
            UnsafeBufferOperations this_$iv = UnsafeBufferOperations.INSTANCE;
            boolean $i$f$readFromHead = false;
            if (!(!$this$readTo.exhausted())) {
                boolean $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = false;
                String $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = "Buffer is empty";
                throw new IllegalArgumentException($i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22.toString());
            }
            Intrinsics.checkNotNull((Object)$this$readTo.getHead());
            int n = head$iv.getLimit();
            int n2 = head$iv.getPos();
            byte[] data = head$iv.dataAsByteArray(true);
            boolean bl = false;
            long l = remainingByteCount;
            void b$iv = limit - pos;
            boolean $i$f$minOf = false;
            toCopy = (int)Math.min((long)a$iv, (long)b$iv);
            out.write(data, (int)pos, toCopy);
            int bytesRead$iv = toCopy;
            if (bytesRead$iv == 0) continue;
            if (bytesRead$iv < 0) {
                throw new IllegalStateException("Returned negative read bytes count");
            }
            if (bytesRead$iv > head$iv.getSize()) {
                throw new IllegalStateException("Returned too many bytes");
            }
            $this$readTo.skip(bytesRead$iv);
        }
    }

    public static /* synthetic */ void readTo$default(Buffer buffer, OutputStream outputStream, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = buffer.getSize();
        }
        BuffersJvmKt.readTo(buffer, outputStream, l);
    }

    /*
     * WARNING - void declaration
     */
    public static final void copyTo(@NotNull Buffer $this$copyTo, @NotNull OutputStream out, long startIndex, long endIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$copyTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        _UtilKt.checkBounds($this$copyTo.getSize(), startIndex, endIndex);
        if (startIndex == endIndex) {
            return;
        }
        long remainingByteCount = 0L;
        UnsafeBufferOperations this_$iv = UnsafeBufferOperations.INSTANCE;
        boolean $i$f$iterate = false;
        if (!(startIndex >= 0L)) {
            boolean $i$a$-require-UnsafeBufferOperations$iterate$1$iv22 = false;
            String $i$a$-require-UnsafeBufferOperations$iterate$1$iv22 = "Offset must be non-negative: " + startIndex;
            throw new IllegalArgumentException($i$a$-require-UnsafeBufferOperations$iterate$1$iv22.toString());
        }
        if (startIndex >= $this$copyTo.getSize()) {
            throw new IndexOutOfBoundsException("Offset should be less than buffer's size (" + $this$copyTo.getSize() + "): " + startIndex);
        }
        Buffer $this$seek$iv$iv = $this$copyTo;
        boolean $i$f$seek = false;
        if ($this$seek$iv$iv.getHead() == null) {
            int toCopy;
            void segOffset;
            void seg;
            void o$iv;
            long l = -1L;
            Object s$iv = null;
            boolean bl = false;
            void var14_14 = o$iv;
            Object var16_17 = s$iv;
            BufferIterationContext ctx = UnsafeBufferOperationsKt.getBufferIterationContextImpl();
            boolean bl2 = false;
            void v0 = seg;
            Intrinsics.checkNotNull((Object)v0);
            Segment curr = v0;
            int currentOffset = 0;
            currentOffset = (int)(startIndex - segOffset);
            for (remainingByteCount = endIndex - startIndex; remainingByteCount > 0L; remainingByteCount -= (long)toCopy) {
                void a$iv;
                void pos;
                void limit;
                SegmentReadContext $this$withData$iv = ctx;
                boolean $i$f$withData = false;
                int n = curr.getLimit();
                int n2 = curr.getPos();
                byte[] data = curr.dataAsByteArray(true);
                boolean bl3 = false;
                void var27_50 = limit - pos - currentOffset;
                long b$iv = remainingByteCount;
                boolean $i$f$minOf = false;
                toCopy = (int)Math.min((long)a$iv, b$iv);
                out.write(data, (int)(pos + currentOffset), toCopy);
                if (ctx.next(curr) != null) {
                    currentOffset = 0;
                    continue;
                }
                break;
            }
        } else if ($this$seek$iv$iv.getSize() - startIndex < startIndex) {
            void o$iv;
            Segment s$iv$iv;
            long offset$iv$iv = $this$seek$iv$iv.getSize();
            for (s$iv$iv = $this$seek$iv$iv.getTail(); s$iv$iv != null && offset$iv$iv > startIndex && (offset$iv$iv -= (long)(s$iv$iv.getLimit() - s$iv$iv.getPos())) > startIndex; s$iv$iv = s$iv$iv.getPrev()) {
            }
            long l = offset$iv$iv;
            Segment s$iv = s$iv$iv;
            boolean bl = false;
            void segOffset = o$iv;
            Segment seg = s$iv;
            BufferIterationContext ctx = UnsafeBufferOperationsKt.getBufferIterationContextImpl();
            boolean bl4 = false;
            Segment segment = seg;
            Intrinsics.checkNotNull((Object)segment);
            Segment curr = segment;
            int currentOffset = 0;
            currentOffset = (int)(startIndex - segOffset);
            while (remainingByteCount > 0L) {
                SegmentReadContext $this$withData$iv = ctx;
                boolean $i$f$withData = false;
                int limit = curr.getLimit();
                int pos = curr.getPos();
                byte[] data = curr.dataAsByteArray(true);
                boolean bl5 = false;
                int a$iv = limit - pos - currentOffset;
                long b$iv = remainingByteCount;
                boolean $i$f$minOf = false;
                int toCopy = (int)Math.min((long)a$iv, b$iv);
                out.write(data, pos + currentOffset, toCopy);
                remainingByteCount -= (long)toCopy;
                if (ctx.next(curr) != null) {
                    currentOffset = 0;
                    continue;
                }
                break;
            }
        } else {
            void o$iv;
            long nextOffset$iv$iv;
            Segment s$iv$iv;
            long offset$iv$iv = 0L;
            for (s$iv$iv = $this$seek$iv$iv.getHead(); s$iv$iv != null && (nextOffset$iv$iv = offset$iv$iv + (long)(s$iv$iv.getLimit() - s$iv$iv.getPos())) <= startIndex; s$iv$iv = s$iv$iv.getNext()) {
                offset$iv$iv = nextOffset$iv$iv;
            }
            long l = offset$iv$iv;
            Segment s$iv = s$iv$iv;
            boolean bl = false;
            void segOffset = o$iv;
            Segment seg = s$iv;
            BufferIterationContext ctx = UnsafeBufferOperationsKt.getBufferIterationContextImpl();
            boolean bl6 = false;
            Segment segment = seg;
            Intrinsics.checkNotNull((Object)segment);
            Segment curr = segment;
            int currentOffset = 0;
            currentOffset = (int)(startIndex - segOffset);
            while (remainingByteCount > 0L) {
                SegmentReadContext $this$withData$iv = ctx;
                boolean $i$f$withData = false;
                int limit = curr.getLimit();
                int pos = curr.getPos();
                byte[] data = curr.dataAsByteArray(true);
                boolean bl7 = false;
                int a$iv = limit - pos - currentOffset;
                long b$iv = remainingByteCount;
                boolean $i$f$minOf = false;
                int toCopy = (int)Math.min((long)a$iv, b$iv);
                out.write(data, pos + currentOffset, toCopy);
                remainingByteCount -= (long)toCopy;
                if (ctx.next(curr) != null) {
                    currentOffset = 0;
                    continue;
                }
                break;
            }
        }
    }

    public static /* synthetic */ void copyTo$default(Buffer buffer, OutputStream outputStream, long l, long l2, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            l2 = buffer.getSize();
        }
        BuffersJvmKt.copyTo(buffer, outputStream, l, l2);
    }

    /*
     * WARNING - void declaration
     */
    public static final int readAtMostTo(@NotNull Buffer $this$readAtMostTo, @NotNull ByteBuffer sink) {
        void pos;
        void limit;
        Intrinsics.checkNotNullParameter((Object)$this$readAtMostTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if ($this$readAtMostTo.exhausted()) {
            return -1;
        }
        int toCopy = 0;
        UnsafeBufferOperations this_$iv = UnsafeBufferOperations.INSTANCE;
        boolean $i$f$readFromHead = false;
        if (!(!$this$readAtMostTo.exhausted())) {
            boolean $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = false;
            String $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = "Buffer is empty";
            throw new IllegalArgumentException($i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22.toString());
        }
        Segment segment = $this$readAtMostTo.getHead();
        Intrinsics.checkNotNull((Object)segment);
        Segment head$iv = segment;
        int n = head$iv.getLimit();
        int n2 = head$iv.getPos();
        byte[] data = head$iv.dataAsByteArray(true);
        boolean bl = false;
        toCopy = Math.min(sink.remaining(), (int)(limit - pos));
        sink.put(data, (int)pos, toCopy);
        int bytesRead$iv = toCopy;
        if (bytesRead$iv != 0) {
            if (bytesRead$iv < 0) {
                throw new IllegalStateException("Returned negative read bytes count");
            }
            if (bytesRead$iv > head$iv.getSize()) {
                throw new IllegalStateException("Returned too many bytes");
            }
            $this$readAtMostTo.skip(bytesRead$iv);
        }
        return toCopy;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Buffer transferFrom(@NotNull Buffer $this$transferFrom, @NotNull ByteBuffer source) {
        Intrinsics.checkNotNullParameter((Object)$this$transferFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        int byteCount = source.remaining();
        int remaining = 0;
        remaining = byteCount;
        while (remaining > 0) {
            void pos;
            void limit;
            UnsafeBufferOperations unsafeBufferOperations = UnsafeBufferOperations.INSTANCE;
            int minimumCapacity$iv = 1;
            boolean $i$f$writeToTail = false;
            Segment tail$iv = $this$transferFrom.writableSegment(minimumCapacity$iv);
            byte[] data$iv = tail$iv.dataAsByteArray(false);
            int n = data$iv.length;
            int n2 = tail$iv.getLimit();
            byte[] data = data$iv;
            boolean bl = false;
            int toCopy = Math.min(remaining, (int)(limit - pos));
            source.get(data, (int)pos, toCopy);
            remaining -= toCopy;
            int bytesWritten$iv = toCopy;
            if (bytesWritten$iv == minimumCapacity$iv) {
                tail$iv.writeBackData(data$iv, bytesWritten$iv);
                tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                $this$transferFrom.setSizeMut($this$transferFrom.getSizeMut() + (long)bytesWritten$iv);
                continue;
            }
            if (!(0 <= bytesWritten$iv ? bytesWritten$iv <= tail$iv.getRemainingCapacity() : false)) {
                boolean bl2 = false;
                String string = "Invalid number of bytes written: " + bytesWritten$iv + ". Should be in 0.." + tail$iv.getRemainingCapacity();
                throw new IllegalStateException(string.toString());
            }
            if (bytesWritten$iv != 0) {
                tail$iv.writeBackData(data$iv, bytesWritten$iv);
                tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                $this$transferFrom.setSizeMut($this$transferFrom.getSizeMut() + (long)bytesWritten$iv);
                continue;
            }
            if (!SegmentKt.isEmpty(tail$iv)) continue;
            $this$transferFrom.recycleTail();
        }
        return $this$transferFrom;
    }

    @NotNull
    public static final ByteChannel asByteChannel(@NotNull Buffer $this$asByteChannel) {
        Intrinsics.checkNotNullParameter((Object)$this$asByteChannel, (String)"<this>");
        return new ByteChannel($this$asByteChannel){
            final /* synthetic */ Buffer $this_asByteChannel;
            {
                this.$this_asByteChannel = $receiver;
            }

            public int read(ByteBuffer sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                return BuffersJvmKt.readAtMostTo(this.$this_asByteChannel, sink);
            }

            public int write(ByteBuffer source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                long sizeBefore = this.$this_asByteChannel.getSize();
                BuffersJvmKt.transferFrom(this.$this_asByteChannel, source);
                return (int)(this.$this_asByteChannel.getSize() - sizeBefore);
            }

            public void close() {
            }

            public boolean isOpen() {
                return true;
            }
        };
    }
}

