/*
 * Decompiled with CFR 0.152.
 */
package com.madgag.git.bfg.cleaner;

import com.madgag.git.bfg.Timing$;
import com.madgag.git.bfg.cleaner.CLIReporter;
import com.madgag.git.bfg.cleaner.ObjectIdCleaner;
import com.madgag.git.bfg.cleaner.Reporter;
import com.madgag.git.package$;
import java.io.Serializable;
import java.util.Collection;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.parallel.CollectionConverters$ImmutableSeqIsParallelizable$;
import scala.concurrent.ExecutionContext$Implicits$;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class RepoRewriter$ {
    public static final RepoRewriter$ MODULE$ = new RepoRewriter$();

    public Map<ObjectId, ObjectId> rewrite(Repository repo, ObjectIdCleaner.Config objectIdCleanerConfig) {
        Predef$.MODULE$.assert(!repo.getAllRefs().isEmpty(), (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(31).append("Can't find any refs in repo at ").append(repo.getDirectory().getAbsolutePath()).toString());
        RefDatabase refDatabase = repo.getRefDatabase();
        CLIReporter reporter = new CLIReporter(repo);
        ProgressMonitor progressMonitor = reporter.progressMonitor();
        Collection<Ref> allRefs = repo.getAllRefs().values();
        RevWalk revWalk = RepoRewriter$.createRevWalk$1(repo, allRefs, refDatabase);
        ObjectReader reader = revWalk.getObjectReader();
        reporter.reportRefsForScan(CollectionConverters$.MODULE$.CollectionHasAsScala(allRefs).asScala(), reader);
        reporter.reportObjectProtection(objectIdCleanerConfig, repo.getObjectDatabase(), revWalk);
        ObjectIdCleaner objectIdCleaner = new ObjectIdCleaner(objectIdCleanerConfig, repo.getObjectDatabase(), revWalk);
        Seq commits = CollectionConverters$.MODULE$.IterableHasAsScala(revWalk).asScala().toSeq();
        RepoRewriter$.clean$1(commits, reporter, objectIdCleaner, progressMonitor);
        RepoRewriter$.updateRefsWithCleanedIds$1(repo, objectIdCleaner, reporter, revWalk, refDatabase, progressMonitor, commits);
        objectIdCleaner.stats();
        return objectIdCleaner.cleanedObjectMap();
    }

    /*
     * WARNING - void declaration
     */
    private static final RevWalk createRevWalk$1(Repository repo$1, Collection allRefs$1, RefDatabase refDatabase$1) {
        void var3_3;
        RevWalk revWalk = new RevWalk(repo$1);
        revWalk.sort(RevSort.TOPO);
        revWalk.sort(RevSort.REVERSE, true);
        Iterable startCommits = (Iterable)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(allRefs$1).asScala().map((Function1<Ref, RevObject> & Serializable)x$1 -> package$.MODULE$.RichObjectId(package$.MODULE$.RichRef((Ref)x$1).targetObjectId(refDatabase$1)).asRevObject(revWalk))).collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends RevObject, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                RevCommit revCommit;
                A1 A1 = x1;
                RevCommit revCommit2 = A1 instanceof RevCommit ? (revCommit = (RevCommit)A1) : function1.apply(x1);
                return (B1)revCommit2;
            }

            public final boolean isDefinedAt(RevObject x1) {
                RevObject revObject = x1;
                boolean bl = revObject instanceof RevCommit;
                return bl;
            }
        });
        revWalk.markStart(CollectionConverters$.MODULE$.IterableHasAsJava(startCommits).asJavaCollection());
        return var3_3;
    }

    public static final /* synthetic */ void $anonfun$rewrite$6(ObjectIdCleaner objectIdCleaner$1, ProgressMonitor progressMonitor$1, RevCommit commit) {
        objectIdCleaner$1.apply(commit);
        progressMonitor$1.update(1);
    }

    private static final void clean$1(Seq commits, Reporter reporter$1, ObjectIdCleaner objectIdCleaner$1, ProgressMonitor progressMonitor$1) {
        reporter$1.reportCleaningStart(commits);
        Timing$.MODULE$.measureTask("Cleaning commits", commits.size(), () -> {
            Future$.MODULE$.apply(() -> CollectionConverters$ImmutableSeqIsParallelizable$.MODULE$.par$extension(scala.collection.parallel.CollectionConverters$.MODULE$.ImmutableSeqIsParallelizable(commits)).foreach((Function1<RevCommit, ObjectId> & Serializable)commit -> objectIdCleaner$1.apply(commit.getTree())), ExecutionContext$Implicits$.MODULE$.global());
            commits.foreach((Function1<RevCommit, Object> & Serializable)commit -> {
                RepoRewriter$.$anonfun$rewrite$6(objectIdCleaner$1, progressMonitor$1, commit);
                return BoxedUnit.UNIT;
            });
        }, progressMonitor$1);
    }

    public static final /* synthetic */ boolean $anonfun$rewrite$8(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private static final void updateRefsWithCleanedIds$1(Repository repo$1, ObjectIdCleaner objectIdCleaner$1, Reporter reporter$1, RevWalk revWalk$2, RefDatabase refDatabase$1, ProgressMonitor progressMonitor$1, Seq commits$2) {
        Iterable refUpdateCommands = (Iterable)package$.MODULE$.RichRepo(repo$1).nonSymbolicRefs().flatMap((Function1<Ref, Option> & Serializable)ref -> objectIdCleaner$1.substitution(ref.getObjectId()).withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(RepoRewriter$.$anonfun$rewrite$8(check$ifrefutable$1))).map((Function1<Tuple2, ReceiveCommand> & Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            ObjectId oldId = (ObjectId)tuple2._1();
            ObjectId newId = (ObjectId)tuple2._2();
            ReceiveCommand receiveCommand = new ReceiveCommand(oldId, newId, ref.getName());
            return receiveCommand;
        }));
        if (refUpdateCommands.isEmpty()) {
            Predef$.MODULE$.println("\nBFG aborting: No refs to update - no dirty commits found??\n");
        } else {
            reporter$1.reportRefUpdateStart(refUpdateCommands);
            Timing$.MODULE$.measureTask("...Ref update", refUpdateCommands.size(), () -> {
                RevWalk quickMergeCalcRevWalk = new RevWalk(revWalk$2, objectIdCleaner$1){
                    private final ObjectIdCleaner objectIdCleaner$1;

                    public boolean isMergedInto(RevCommit base, RevCommit tip) {
                        RevCommit revCommit = tip;
                        ObjectId objectId = this.objectIdCleaner$1.apply(base);
                        return !(revCommit != null ? !((Object)revCommit).equals(objectId) : objectId != null) ? false : super.isMergedInto(base, tip);
                    }
                    {
                        this.objectIdCleaner$1 = objectIdCleaner$1;
                        super(revWalk$2.getObjectReader());
                    }
                };
                refDatabase$1.newBatchUpdate().setAllowNonFastForwards(true).addCommand(CollectionConverters$.MODULE$.IterableHasAsJava(refUpdateCommands).asJavaCollection()).execute(quickMergeCalcRevWalk, progressMonitor$1);
            }, progressMonitor$1);
            reporter$1.reportResults(commits$2, objectIdCleaner$1);
        }
    }

    private RepoRewriter$() {
    }
}

