/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.specialized;

import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.specialized.RubyArrayOneObject;
import org.jruby.specialized.RubyArraySpecialized;
import org.jruby.util.ByteList;
import org.jruby.util.io.EncodingUtils;

public class RubyArrayTwoObject
extends RubyArraySpecialized {
    private IRubyObject car;
    private IRubyObject cdr;

    public RubyArrayTwoObject(Ruby runtime2, IRubyObject car, IRubyObject cdr) {
        super(runtime2, false);
        this.car = car;
        this.cdr = cdr;
        this.realLength = 2;
    }

    public RubyArrayTwoObject(RubyClass otherClass, IRubyObject car, IRubyObject cdr) {
        super(otherClass, false);
        this.car = car;
        this.cdr = cdr;
        this.realLength = 2;
    }

    RubyArrayTwoObject(RubyArrayTwoObject other) {
        this(other.getMetaClass(), other.car, other.cdr);
    }

    RubyArrayTwoObject(RubyClass metaClass, RubyArrayTwoObject other) {
        this(metaClass, other.car, other.cdr);
    }

    public final IRubyObject eltInternal(int index2) {
        if (!this.packed()) {
            return super.eltInternal(index2);
        }
        if (index2 == 0) {
            return this.car;
        }
        if (index2 == 1) {
            return this.cdr;
        }
        throw new ArrayIndexOutOfBoundsException(index2);
    }

    public final IRubyObject eltInternalSet(int index2, IRubyObject value2) {
        if (!this.packed()) {
            return super.eltInternalSet(index2, value2);
        }
        if (index2 == 0) {
            this.car = value2;
            return this.car;
        }
        if (index2 == 1) {
            this.cdr = value2;
            return this.cdr;
        }
        throw new ArrayIndexOutOfBoundsException(index2);
    }

    @Override
    protected void finishUnpack(IRubyObject nil) {
        this.car = this.cdr = nil;
    }

    @Override
    public RubyArray aryDup() {
        if (!this.packed()) {
            return super.aryDup();
        }
        return new RubyArrayTwoObject(this.getRuntime().getArray(), this);
    }

    @Override
    public IRubyObject rb_clear() {
        IRubyObject nil;
        if (!this.packed()) {
            return super.rb_clear();
        }
        this.modifyCheck();
        this.car = this.cdr = (nil = this.getRuntime().getNil());
        this.values = IRubyObject.NULL_ARRAY;
        this.realLength = 0;
        return this;
    }

    @Override
    public void copyInto(IRubyObject[] target2, int start2) {
        if (!this.packed()) {
            super.copyInto(target2, start2);
            return;
        }
        target2[start2] = this.car;
        target2[start2 + 1] = this.cdr;
    }

    @Override
    public void copyInto(IRubyObject[] target2, int start2, int len) {
        if (!this.packed()) {
            super.copyInto(target2, start2, len);
            return;
        }
        if (len != 2) {
            this.unpack();
            super.copyInto(target2, start2, len);
            return;
        }
        target2[start2] = this.car;
        target2[start2 + 1] = this.cdr;
    }

    @Override
    protected RubyArray dupImpl(Ruby runtime2, RubyClass metaClass) {
        if (!this.packed()) {
            return super.dupImpl(runtime2, metaClass);
        }
        return new RubyArrayTwoObject(metaClass, this);
    }

    @Override
    public boolean includes(ThreadContext context, IRubyObject item) {
        if (!this.packed()) {
            return super.includes(context, item);
        }
        if (RubyArrayTwoObject.equalInternal(context, this.car, item)) {
            return true;
        }
        return RubyArrayTwoObject.equalInternal(context, this.cdr, item);
    }

    @Override
    public int indexOf(Object element) {
        if (!this.packed()) {
            return super.indexOf(element);
        }
        if (element != null) {
            IRubyObject convertedElement = JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), element);
            if (convertedElement.equals(this.car)) {
                return 0;
            }
            if (convertedElement.equals(this.cdr)) {
                return 1;
            }
        }
        return -1;
    }

    @Override
    protected IRubyObject inspectAry(ThreadContext context) {
        if (!this.packed()) {
            return super.inspectAry(context);
        }
        Ruby runtime2 = context.runtime;
        RubyString str = RubyString.newStringLight(runtime2, 10, USASCIIEncoding.INSTANCE);
        str.cat((byte)91);
        RubyString s1 = RubyArrayTwoObject.inspect(context, this.car);
        RubyString s2 = RubyArrayTwoObject.inspect(context, this.cdr);
        EncodingUtils.encAssociateIndex(str, s1.getEncoding());
        str.catWithCodeRange(s1);
        ByteList bytes2 = str.getByteList();
        bytes2.append((byte)44).append((byte)32);
        str.catWithCodeRange(s2);
        str.cat((byte)93);
        return str;
    }

    @Override
    protected IRubyObject internalRotate(ThreadContext context, int cnt) {
        if (!this.packed()) {
            return super.internalRotate(context, cnt);
        }
        if (cnt % 2 == 1) {
            return new RubyArrayTwoObject(context.runtime, this.cdr, this.car);
        }
        return new RubyArrayTwoObject(context.runtime, this.car, this.cdr);
    }

    @Override
    protected IRubyObject internalRotateBang(ThreadContext context, int cnt) {
        if (!this.packed()) {
            return super.internalRotateBang(context, cnt);
        }
        this.modifyCheck();
        if (cnt % 2 == 1) {
            IRubyObject tmp = this.car;
            this.car = this.cdr;
            this.cdr = tmp;
        }
        return context.nil;
    }

    @Override
    public IRubyObject op_plus(IRubyObject obj) {
        if (!this.packed()) {
            return super.op_plus(obj);
        }
        RubyArray y = obj.convertToArray();
        if (y.size() == 0) {
            return new RubyArrayTwoObject(this);
        }
        return super.op_plus(y);
    }

    @Override
    public IRubyObject replace(IRubyObject orig) {
        if (!this.packed()) {
            return super.replace(orig);
        }
        this.modifyCheck();
        RubyArray origArr = orig.convertToArray();
        if (this == orig) {
            return this;
        }
        if (origArr.size() == 2) {
            this.car = origArr.eltInternal(0);
            this.cdr = origArr.eltInternal(1);
            return this;
        }
        this.unpack();
        return super.replace(origArr);
    }

    @Override
    public IRubyObject reverse_bang() {
        if (!this.packed()) {
            return super.reverse_bang();
        }
        IRubyObject tmp = this.car;
        this.car = this.cdr;
        this.cdr = tmp;
        return this;
    }

    @Override
    protected RubyArray safeReverse() {
        if (!this.packed()) {
            return super.safeReverse();
        }
        return new RubyArrayTwoObject(this.getMetaClass(), this.cdr, this.car);
    }

    @Override
    protected IRubyObject sortInternal(ThreadContext context, Block block) {
        if (!this.packed()) {
            return super.sortInternal(context, block);
        }
        IRubyObject car = this.car;
        IRubyObject cdr = this.cdr;
        IRubyObject ret = block.yieldArray(context, RubyArrayTwoObject.newArray(context.runtime, car, cdr), null);
        int compare = RubyComparable.cmpint(context, ret, car, cdr);
        if (compare > 0) {
            this.reverse_bang();
        }
        return this;
    }

    @Override
    protected IRubyObject sortInternal(ThreadContext context, boolean honorOverride) {
        if (!this.packed()) {
            return super.sortInternal(context, honorOverride);
        }
        Ruby runtime2 = context.runtime;
        JavaSites.Array2Sites sites = RubyArrayTwoObject.sites(context);
        IRubyObject o1 = this.car;
        IRubyObject o2 = this.cdr;
        int compare = this.isFixnumBypass(runtime2, sites, honorOverride) && o1 instanceof RubyFixnum && o2 instanceof RubyFixnum ? RubyArrayTwoObject.compareFixnums((RubyFixnum)o1, (RubyFixnum)o2) : (this.isStringBypass(runtime2, sites, honorOverride) && o1 instanceof RubyString && o2 instanceof RubyString ? ((RubyString)o1).op_cmp((RubyString)o2) : RubyArrayTwoObject.compareOthers(context, o1, o2));
        if (compare > 0) {
            this.reverse_bang();
        }
        return this;
    }

    private boolean isStringBypass(Ruby runtime2, JavaSites.Array2Sites sites, boolean honorOverride) {
        return !honorOverride || sites.op_cmp_string.isBuiltin(runtime2.getString());
    }

    private boolean isFixnumBypass(Ruby runtime2, JavaSites.Array2Sites sites, boolean honorOverride) {
        return !honorOverride || sites.op_cmp_fixnum.isBuiltin(runtime2.getFixnum());
    }

    @Override
    protected void storeInternal(int index2, IRubyObject value2) {
        if (this.packed()) {
            switch (index2) {
                case 0: {
                    this.car = value2;
                    return;
                }
                case 1: {
                    this.cdr = value2;
                    return;
                }
            }
            this.unpack();
        }
        super.storeInternal(index2, value2);
    }

    @Override
    public IRubyObject subseq(RubyClass metaClass, long beg, long len, boolean light) {
        if (!this.packed()) {
            return super.subseq(metaClass, beg, len, light);
        }
        Ruby runtime2 = this.getRuntime();
        if (beg > 2L || beg < 0L || len < 0L) {
            return runtime2.getNil();
        }
        if (len == 0L || beg == 2L) {
            return new RubyArray(runtime2, metaClass, IRubyObject.NULL_ARRAY);
        }
        if (beg == 0L) {
            if (len == 1L) {
                return new RubyArrayOneObject(metaClass, this.car);
            }
            return new RubyArrayTwoObject(metaClass, this);
        }
        return new RubyArrayOneObject(metaClass, this.cdr);
    }

    @Override
    public IRubyObject[] toJavaArray() {
        if (!this.packed()) {
            return super.toJavaArray();
        }
        return Helpers.arrayOf(this.car, this.cdr);
    }

    @Override
    public IRubyObject uniq(ThreadContext context) {
        if (!this.packed()) {
            return super.uniq(context);
        }
        IRubyObject car = this.car;
        IRubyObject cdr = this.cdr;
        if (Helpers.invokedynamic(context, car, MethodNames.HASH).equals(Helpers.invokedynamic(context, cdr, MethodNames.HASH)) && (car == cdr || Helpers.invokedynamic(context, car, MethodNames.EQL, cdr).isTrue())) {
            return new RubyArrayOneObject(this.getMetaClass(), cdr);
        }
        return new RubyArrayTwoObject(this);
    }

    @Override
    public RubyArray collectArray(ThreadContext context, Block block) {
        int i2;
        if (!this.packed()) {
            return super.collectArray(context, block);
        }
        if (!block.isGiven()) {
            return this.makeShared();
        }
        Ruby runtime2 = context.runtime;
        IRubyObject newCar = block.yieldNonArray(context, this.car, null);
        if (this.realLength == 2) {
            return new RubyArrayTwoObject(runtime2, newCar, block.yieldNonArray(context, this.cdr, null));
        }
        this.unpack();
        int currentLength = this.realLength;
        IRubyObject[] arr = IRubyObject.array(currentLength);
        if (currentLength == 0) {
            return runtime2.newEmptyArray();
        }
        arr[0] = newCar;
        for (i2 = 1; i2 < this.realLength; ++i2) {
            RubyArrayTwoObject.safeArraySet(runtime2, arr, i2, block.yieldNonArray(context, (IRubyObject)this.eltOk(i2), null));
        }
        return RubyArrayTwoObject.newArrayMayCopy(context.runtime, arr, 0, i2);
    }

    @Override
    protected RubyArray makeShared() {
        if (!this.packed()) {
            return super.makeShared();
        }
        return new RubyArrayTwoObject(this);
    }

    private static final JavaSites.Array2Sites sites(ThreadContext context) {
        return context.sites.Array2;
    }
}

