﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock/Bedrock_EXPORTS.h>
#include <aws/bedrock/model/AutomatedReasoningPolicyGeneratedTestCase.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Bedrock {
namespace Model {

/**
 * <p>Contains a comprehensive test suite generated by the build workflow,
 * providing validation capabilities for automated reasoning
 * policies.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/AutomatedReasoningPolicyGeneratedTestCases">AWS
 * API Reference</a></p>
 */
class AutomatedReasoningPolicyGeneratedTestCases {
 public:
  AWS_BEDROCK_API AutomatedReasoningPolicyGeneratedTestCases() = default;
  AWS_BEDROCK_API AutomatedReasoningPolicyGeneratedTestCases(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCK_API AutomatedReasoningPolicyGeneratedTestCases& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCK_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Represents a collection of generated test cases.</p>
   */
  inline const Aws::Vector<AutomatedReasoningPolicyGeneratedTestCase>& GetGeneratedTestCases() const { return m_generatedTestCases; }
  inline bool GeneratedTestCasesHasBeenSet() const { return m_generatedTestCasesHasBeenSet; }
  template <typename GeneratedTestCasesT = Aws::Vector<AutomatedReasoningPolicyGeneratedTestCase>>
  void SetGeneratedTestCases(GeneratedTestCasesT&& value) {
    m_generatedTestCasesHasBeenSet = true;
    m_generatedTestCases = std::forward<GeneratedTestCasesT>(value);
  }
  template <typename GeneratedTestCasesT = Aws::Vector<AutomatedReasoningPolicyGeneratedTestCase>>
  AutomatedReasoningPolicyGeneratedTestCases& WithGeneratedTestCases(GeneratedTestCasesT&& value) {
    SetGeneratedTestCases(std::forward<GeneratedTestCasesT>(value));
    return *this;
  }
  template <typename GeneratedTestCasesT = AutomatedReasoningPolicyGeneratedTestCase>
  AutomatedReasoningPolicyGeneratedTestCases& AddGeneratedTestCases(GeneratedTestCasesT&& value) {
    m_generatedTestCasesHasBeenSet = true;
    m_generatedTestCases.emplace_back(std::forward<GeneratedTestCasesT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<AutomatedReasoningPolicyGeneratedTestCase> m_generatedTestCases;
  bool m_generatedTestCasesHasBeenSet = false;
};

}  // namespace Model
}  // namespace Bedrock
}  // namespace Aws
