﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/chime-sdk-media-pipelines/model/KeywordMatchConfiguration.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace ChimeSDKMediaPipelines {
namespace Model {

KeywordMatchConfiguration::KeywordMatchConfiguration(JsonView jsonValue) { *this = jsonValue; }

KeywordMatchConfiguration& KeywordMatchConfiguration::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("RuleName")) {
    m_ruleName = jsonValue.GetString("RuleName");
    m_ruleNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Keywords")) {
    Aws::Utils::Array<JsonView> keywordsJsonList = jsonValue.GetArray("Keywords");
    for (unsigned keywordsIndex = 0; keywordsIndex < keywordsJsonList.GetLength(); ++keywordsIndex) {
      m_keywords.push_back(keywordsJsonList[keywordsIndex].AsString());
    }
    m_keywordsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Negate")) {
    m_negate = jsonValue.GetBool("Negate");
    m_negateHasBeenSet = true;
  }
  return *this;
}

JsonValue KeywordMatchConfiguration::Jsonize() const {
  JsonValue payload;

  if (m_ruleNameHasBeenSet) {
    payload.WithString("RuleName", m_ruleName);
  }

  if (m_keywordsHasBeenSet) {
    Aws::Utils::Array<JsonValue> keywordsJsonList(m_keywords.size());
    for (unsigned keywordsIndex = 0; keywordsIndex < keywordsJsonList.GetLength(); ++keywordsIndex) {
      keywordsJsonList[keywordsIndex].AsString(m_keywords[keywordsIndex]);
    }
    payload.WithArray("Keywords", std::move(keywordsJsonList));
  }

  if (m_negateHasBeenSet) {
    payload.WithBool("Negate", m_negate);
  }

  return payload;
}

}  // namespace Model
}  // namespace ChimeSDKMediaPipelines
}  // namespace Aws
