﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cleanrooms/model/IdNamespaceAssociation.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace CleanRooms {
namespace Model {

IdNamespaceAssociation::IdNamespaceAssociation(JsonView jsonValue) { *this = jsonValue; }

IdNamespaceAssociation& IdNamespaceAssociation::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("id")) {
    m_id = jsonValue.GetString("id");
    m_idHasBeenSet = true;
  }
  if (jsonValue.ValueExists("arn")) {
    m_arn = jsonValue.GetString("arn");
    m_arnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("membershipId")) {
    m_membershipId = jsonValue.GetString("membershipId");
    m_membershipIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("membershipArn")) {
    m_membershipArn = jsonValue.GetString("membershipArn");
    m_membershipArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("collaborationId")) {
    m_collaborationId = jsonValue.GetString("collaborationId");
    m_collaborationIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("collaborationArn")) {
    m_collaborationArn = jsonValue.GetString("collaborationArn");
    m_collaborationArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("name")) {
    m_name = jsonValue.GetString("name");
    m_nameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("description")) {
    m_description = jsonValue.GetString("description");
    m_descriptionHasBeenSet = true;
  }
  if (jsonValue.ValueExists("createTime")) {
    m_createTime = jsonValue.GetDouble("createTime");
    m_createTimeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("updateTime")) {
    m_updateTime = jsonValue.GetDouble("updateTime");
    m_updateTimeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("inputReferenceConfig")) {
    m_inputReferenceConfig = jsonValue.GetObject("inputReferenceConfig");
    m_inputReferenceConfigHasBeenSet = true;
  }
  if (jsonValue.ValueExists("inputReferenceProperties")) {
    m_inputReferenceProperties = jsonValue.GetObject("inputReferenceProperties");
    m_inputReferencePropertiesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("idMappingConfig")) {
    m_idMappingConfig = jsonValue.GetObject("idMappingConfig");
    m_idMappingConfigHasBeenSet = true;
  }
  return *this;
}

JsonValue IdNamespaceAssociation::Jsonize() const {
  JsonValue payload;

  if (m_idHasBeenSet) {
    payload.WithString("id", m_id);
  }

  if (m_arnHasBeenSet) {
    payload.WithString("arn", m_arn);
  }

  if (m_membershipIdHasBeenSet) {
    payload.WithString("membershipId", m_membershipId);
  }

  if (m_membershipArnHasBeenSet) {
    payload.WithString("membershipArn", m_membershipArn);
  }

  if (m_collaborationIdHasBeenSet) {
    payload.WithString("collaborationId", m_collaborationId);
  }

  if (m_collaborationArnHasBeenSet) {
    payload.WithString("collaborationArn", m_collaborationArn);
  }

  if (m_nameHasBeenSet) {
    payload.WithString("name", m_name);
  }

  if (m_descriptionHasBeenSet) {
    payload.WithString("description", m_description);
  }

  if (m_createTimeHasBeenSet) {
    payload.WithDouble("createTime", m_createTime.SecondsWithMSPrecision());
  }

  if (m_updateTimeHasBeenSet) {
    payload.WithDouble("updateTime", m_updateTime.SecondsWithMSPrecision());
  }

  if (m_inputReferenceConfigHasBeenSet) {
    payload.WithObject("inputReferenceConfig", m_inputReferenceConfig.Jsonize());
  }

  if (m_inputReferencePropertiesHasBeenSet) {
    payload.WithObject("inputReferenceProperties", m_inputReferenceProperties.Jsonize());
  }

  if (m_idMappingConfigHasBeenSet) {
    payload.WithObject("idMappingConfig", m_idMappingConfig.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace CleanRooms
}  // namespace Aws
