# Geant4 examples {#mainpage}

This module collects three sets of user examples aimed to demonstrate to
the user how to make correct use of the GEANT4 toolkit by implementing
in a correct way those user-classes which the user is supposed to
customize in order to define his/her own simulation setup.

The **"basic"** set of examples is oriented to novice users and covering 
the most typical use-cases of a Geant4 application with keeping simplicity 
and ease of use.

An **"extended"** set of examples may require some additional libraries besides 
of Geant4. This set covers many specific use cases for actual detector 
simulation. 

An **"advanced"** set of examples covers the use-cases typical of a 
"toolkit"-oriented kind of development, where real complete applications 
for different simulation studies are provided; may require additional third 
party products to be built.

Most of the examples can be run both in interactive and batch mode, and 
input macro files (*.in) and reference output files (*.out) are provided.
Basic and most of the extended examples are considered part of the
system testing suite for validation of the official releases of the
GEANT4 toolkit. Basic and some of the extended and advanced
examples are also used as "acceptance"-tests for the release process.

See more on each examples category pages:
- [Basic examples](\ref README_basic)
- [Extended examples](\ref README_extended)
- <a href="https://www.geant4.org/docs/advanced_examples_doc/index">
  <b>Advanced Examples </b></a>

And more on what is common for all examples:
- [How to build and run an example](\ref README_HowToRun)
- [Tips how to run an example in multi-threading mode](\ref README_HowToRunMT)
- [How to navigate in the examples documentation](\ref README_HowToNavigate)

Web: https://geant4-userdoc.web.cern.ch/Doxygen/examples_doc/html/index.html
