//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
/// \file DetectorConstruction.hh
/// \brief Definition of the DetectorConstruction class

#ifndef DetectorConstruction_h
#define DetectorConstruction_h 1

#include "G4VUserDetectorConstruction.hh"
#include "globals.hh"

#include <vector>

class G4VPhysicalVolume;
class G4LogicalVolume;
class G4Sphere;
class G4Material;
class DetectorMessenger;

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

class DetectorConstruction : public G4VUserDetectorConstruction
{
  public:
    DetectorConstruction();
    ~DetectorConstruction() override;

  public:
    void SetRadius(G4double);
    void SetMaterial(G4String);
    void SetNbOfLayers(G4int nb);

    G4VPhysicalVolume* Construct() override;

  public:
    G4double GetAbsorRadius() { return fAbsorRadius; };
    G4Material* GetAbsorMaterial() { return fAbsorMaterial; };
    G4int GetNbOfLayers() { return fNbOfLayers; };

    void PrintParameters();
    void DefineMaterials();

  private:
    G4double fAbsorRadius = 0.;
    G4Material* fAbsorMaterial = nullptr;
    G4int fNbOfLayers = 0;
    G4double fLayerThickness = 0.;
    G4VPhysicalVolume* fAbsor = nullptr;

    DetectorMessenger* fDetectorMessenger = nullptr;

    std::vector<G4LogicalVolume*> fLVolumes;
    std::vector<G4Sphere*> fSpheres;
};

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

#endif
