---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

# `glab mr update`

Update a merge request.

```plaintext
glab mr update [<id> | <branch>] [flags]
```

## Examples

```console
Mark a merge request as ready
- glab mr update 23 --ready

Mark a merge request as draft
- glab mr update 23 --draft

Updates the merge request for the current branch
- glab mr update --draft

```

## Options

```plaintext
  -a, --assignee strings       Assign users via username. Prefix with '!' or '-' to remove from existing assignees, '+' to add. Otherwise, replace existing assignees with given users.
  -d, --description string     Merge request description. Set to "-" to open an editor.
      --draft                  Mark merge request as a draft.
  -l, --label strings          Add labels.
      --lock-discussion        Lock discussion on merge request.
  -m, --milestone string       Title of the milestone to assign. Set to "" or 0 to unassign.
  -r, --ready                  Mark merge request as ready to be reviewed and merged.
      --remove-source-branch   Toggles the removal of the source branch on merge.
      --reviewer strings       Request review from users by their usernames. Prefix with '!' or '-' to remove from existing reviewers, '+' to add. Otherwise, replace existing reviewers with given users.
      --squash-before-merge    Toggles the option to squash commits into a single commit when merging.
      --target-branch string   Set target branch.
  -t, --title string           Title of merge request.
      --unassign               Unassign all users.
  -u, --unlabel strings        Remove labels.
      --unlock-discussion      Unlock discussion on merge request.
      --wip                    Mark merge request as a work in progress. Alternative to --draft.
```

## Options inherited from parent commands

```plaintext
      --help              Show help for this command.
  -R, --repo OWNER/REPO   Select another repository. Can use either OWNER/REPO or `GROUP/NAMESPACE/REPO` format. Also accepts full URL or Git URL.
```
