﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/apigateway/APIGateway_EXPORTS.h>
#include <aws/apigateway/model/DocumentationPartLocation.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace APIGateway {
namespace Model {
/**
 * <p>A documentation part for a targeted API entity.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/apigateway-2015-07-09/DocumentationPart">AWS
 * API Reference</a></p>
 */
class CreateDocumentationPartResult {
 public:
  AWS_APIGATEWAY_API CreateDocumentationPartResult() = default;
  AWS_APIGATEWAY_API CreateDocumentationPartResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_APIGATEWAY_API CreateDocumentationPartResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The DocumentationPart identifier, generated by API Gateway when the
   * <code>DocumentationPart</code> is created.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  CreateDocumentationPartResult& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The location of the API entity to which the documentation applies. Valid
   * fields depend on the targeted API entity type. All the valid location fields are
   * not required. If not explicitly specified, a valid location field is treated as
   * a wildcard and associated documentation content may be inherited by matching
   * entities, unless overridden.</p>
   */
  inline const DocumentationPartLocation& GetLocation() const { return m_location; }
  template <typename LocationT = DocumentationPartLocation>
  void SetLocation(LocationT&& value) {
    m_locationHasBeenSet = true;
    m_location = std::forward<LocationT>(value);
  }
  template <typename LocationT = DocumentationPartLocation>
  CreateDocumentationPartResult& WithLocation(LocationT&& value) {
    SetLocation(std::forward<LocationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A content map of API-specific key-value pairs describing the targeted API
   * entity. The map must be encoded as a JSON string, e.g., <code>"{
   * \"description\": \"The API does ...\" }"</code>. Only OpenAPI-compliant
   * documentation-related fields from the properties map are exported and, hence,
   * published as part of the API entity definitions, while the original
   * documentation parts are exported in a OpenAPI extension of
   * <code>x-amazon-apigateway-documentation</code>.</p>
   */
  inline const Aws::String& GetProperties() const { return m_properties; }
  template <typename PropertiesT = Aws::String>
  void SetProperties(PropertiesT&& value) {
    m_propertiesHasBeenSet = true;
    m_properties = std::forward<PropertiesT>(value);
  }
  template <typename PropertiesT = Aws::String>
  CreateDocumentationPartResult& WithProperties(PropertiesT&& value) {
    SetProperties(std::forward<PropertiesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateDocumentationPartResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;
  bool m_idHasBeenSet = false;

  DocumentationPartLocation m_location;
  bool m_locationHasBeenSet = false;

  Aws::String m_properties;
  bool m_propertiesHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace APIGateway
}  // namespace Aws
