﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/appintegrations/model/EventFilter.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace AppIntegrationsService {
namespace Model {

EventFilter::EventFilter(JsonView jsonValue) { *this = jsonValue; }

EventFilter& EventFilter::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Source")) {
    m_source = jsonValue.GetString("Source");
    m_sourceHasBeenSet = true;
  }
  return *this;
}

JsonValue EventFilter::Jsonize() const {
  JsonValue payload;

  if (m_sourceHasBeenSet) {
    payload.WithString("Source", m_source);
  }

  return payload;
}

}  // namespace Model
}  // namespace AppIntegrationsService
}  // namespace Aws
