//
// libsemigroups - C++ library for semigroups and monoids
// Copyright (C) 2019-2025 James D. Mitchell
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

// This file includes all the headers in libsemigroups, for convenience.

// WARNING THIS FILE IS AUTO-GENERATED USING THE SCRIPT:
//
//   etc/generate-libsemigroups-hpp.py
//
// DO NOT EDIT THIS FILE, INSTEAD RE-GENERATE IT!

#ifndef LIBSEMIGROUPS_LIBSEMIGROUPS_HPP_
#define LIBSEMIGROUPS_LIBSEMIGROUPS_HPP_

#include "action.hpp"
#include "adapters.hpp"
#include "aho-corasick.hpp"
#include "bipart.hpp"
#include "bitset.hpp"
#include "bmat-adapters.hpp"
#include "bmat-fastest.hpp"
#include "bmat8.hpp"
#include "config.hpp"
#include "cong-class.hpp"
#include "cong-common-helpers.hpp"
#include "cong-helpers.hpp"
#include "cong.hpp"
#include "constants.hpp"
#include "debug.hpp"
#include "deprecated.hpp"
#include "dot.hpp"
#include "exception.hpp"
#include "forest.hpp"
#include "freeband.hpp"
#include "froidure-pin-base.hpp"
#include "froidure-pin.hpp"
#include "gabow.hpp"
#include "hpcombi.hpp"
#include "kambites-class.hpp"
#include "kambites-helpers.hpp"
#include "kambites.hpp"
#include "knuth-bendix-class.hpp"
#include "knuth-bendix-helpers.hpp"
#include "knuth-bendix.hpp"
#include "konieczny.hpp"
#include "matrix.hpp"
#include "obvinf.hpp"
#include "order.hpp"
#include "paths.hpp"
#include "pbr.hpp"
#include "presentation-examples.hpp"
#include "presentation.hpp"
#include "ranges.hpp"
#include "runner.hpp"
#include "schreier-sims.hpp"
#include "sims.hpp"
#include "stephen.hpp"
#include "to-cong.hpp"
#include "to-froidure-pin.hpp"
#include "to-knuth-bendix.hpp"
#include "to-presentation.hpp"
#include "to-todd-coxeter.hpp"
#include "todd-coxeter-class.hpp"
#include "todd-coxeter-helpers.hpp"
#include "todd-coxeter.hpp"
#include "transf.hpp"
#include "types.hpp"
#include "ukkonen.hpp"
#include "word-graph.hpp"
#include "word-range.hpp"

#include "detail/bruidhinn-traits.hpp"
#include "detail/citow.hpp"
#include "detail/cong-common-class.hpp"
#include "detail/containers.hpp"
#include "detail/eigen.hpp"
#include "detail/felsch-graph.hpp"
#include "detail/felsch-tree.hpp"
#include "detail/fmt.hpp"
#include "detail/formatters.hpp"
#include "detail/function-ref.hpp"
#include "detail/int-range.hpp"
#include "detail/iterator.hpp"
#include "detail/kambites-nf.hpp"
#include "detail/kbe.hpp"
#include "detail/ke.hpp"
#include "detail/knuth-bendix-impl.hpp"
#include "detail/knuth-bendix-nf.hpp"
#include "detail/multi-string-view.hpp"
#include "detail/node-managed-graph.hpp"
#include "detail/node-manager.hpp"
#include "detail/path-iterators.hpp"
#include "detail/pool.hpp"
#include "detail/race.hpp"
#include "detail/report.hpp"
#include "detail/rewriters.hpp"
#include "detail/stl.hpp"
#include "detail/string.hpp"
#include "detail/tce.hpp"
#include "detail/timer.hpp"
#include "detail/todd-coxeter-impl.hpp"
#include "detail/uf.hpp"
#include "detail/word-graph-with-sources.hpp"
#include "detail/word-iterators.hpp"

#endif  // LIBSEMIGROUPS_LIBSEMIGROUPS_HPP_
