// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DebugOptions debug options
//
// swagger:model debug_options
type DebugOptions struct {
	// anonkey
	// Maximum: 4.294967295e+09
	// Minimum: 0
	// +kubebuilder:validation:Maximum=4.294967295e+09
	// +kubebuilder:validation:Minimum=0
	Anonkey *int64 `json:"anonkey,omitempty"`

	// quiet
	Quiet bool `json:"quiet,omitempty"`

	// zero warning
	ZeroWarning bool `json:"zero_warning,omitempty"`
}

// Validate validates this debug options
func (m *DebugOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAnonkey(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DebugOptions) validateAnonkey(formats strfmt.Registry) error {
	if swag.IsZero(m.Anonkey) { // not required
		return nil
	}

	if err := validate.MinimumInt("anonkey", "body", *m.Anonkey, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("anonkey", "body", *m.Anonkey, 4.294967295e+09, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this debug options based on context it is used
func (m *DebugOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DebugOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DebugOptions) UnmarshalBinary(b []byte) error {
	var res DebugOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
