// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Forwardfor forwardfor
//
// swagger:model forwardfor
type Forwardfor struct {
	// enabled
	// Required: true
	// Enum: ["enabled"]
	// +kubebuilder:validation:Enum=enabled;
	Enabled *string `json:"enabled"`

	// except
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Except string `json:"except,omitempty"`

	// header
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Header string `json:"header,omitempty"`

	// ifnone
	Ifnone bool `json:"ifnone,omitempty"`
}

// Validate validates this forwardfor
func (m *Forwardfor) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEnabled(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExcept(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHeader(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var forwardforTypeEnabledPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		forwardforTypeEnabledPropEnum = append(forwardforTypeEnabledPropEnum, v)
	}
}

const (

	// ForwardforEnabledEnabled captures enum value "enabled"
	ForwardforEnabledEnabled string = "enabled"
)

// prop value enum
func (m *Forwardfor) validateEnabledEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, forwardforTypeEnabledPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Forwardfor) validateEnabled(formats strfmt.Registry) error {

	if err := validate.Required("enabled", "body", m.Enabled); err != nil {
		return err
	}

	// value enum
	if err := m.validateEnabledEnum("enabled", "body", *m.Enabled); err != nil {
		return err
	}

	return nil
}

func (m *Forwardfor) validateExcept(formats strfmt.Registry) error {
	if swag.IsZero(m.Except) { // not required
		return nil
	}

	if err := validate.Pattern("except", "body", m.Except, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *Forwardfor) validateHeader(formats strfmt.Registry) error {
	if swag.IsZero(m.Header) { // not required
		return nil
	}

	if err := validate.Pattern("header", "body", m.Header, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this forwardfor based on context it is used
func (m *Forwardfor) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *Forwardfor) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Forwardfor) UnmarshalBinary(b []byte) error {
	var res Forwardfor
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
