/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.NullArgumentException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.PreemptiveHttpClient;
import org.jfrog.build.client.artifactoryXrayResponse.ArtifactoryXrayResponse;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBaseClient;

public class ArtifactoryXrayClient
extends ArtifactoryBaseClient {
    private static final String SCAN_BUILD_URL = "/api/xray/scanBuild";
    private static final int XRAY_SCAN_RETRY_CONSECUTIVE_RETRIES = 5;
    private static final int XRAY_SCAN_CONNECTION_TIMEOUT_SECS = 90;
    private static final int XRAY_SCAN_SLEEP_BETWEEN_RETRIES_MILLIS = 30000;
    private static final String XRAY_FATAL_FAIL_STATUS = "-1";
    private static final int HTTP_CLIENT_RETRIES = 0;

    public ArtifactoryXrayClient(String artifactoryUrl, String username, String password, Log logger) {
        super(artifactoryUrl, username, password, "", logger);
        this.setConnectionRetries(0);
    }

    public ArtifactoryXrayResponse xrayScanBuild(String buildName, String buildNumber, String context) throws IOException, InterruptedException {
        StringEntity entity = new StringEntity("{\"buildName\":\"" + buildName + "\",\"buildNumber\":\"" + buildNumber + "\",\"context\":\"" + context + "\"}");
        entity.setContentType("application/json");
        String scanUrl = this.artifactoryUrl + SCAN_BUILD_URL;
        HttpPost httpPost = new HttpPost(scanUrl);
        httpPost.addHeader("X-Accel-Buffering", "no");
        httpPost.setEntity(entity);
        return this.execute(httpPost);
    }

    private boolean isStableConnection(long lastConnectionAttemptMillis) {
        long stableConnectionMillis = 100000L;
        return lastConnectionAttemptMillis + 100000L < System.currentTimeMillis();
    }

    private ArtifactoryXrayResponse parseXrayScanResponse(HttpResponse response) throws IOException {
        JsonNode result;
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException("Artifactory response: " + response.getStatusLine().getReasonPhrase());
        }
        ObjectMapper mapper = new ObjectMapper();
        String content = IOUtils.toString(response.getEntity().getContent(), "UTF-8");
        try {
            result = mapper.readTree(content);
            if (result == null) {
                throw new NullArgumentException("Received empty content from Artifactory");
            }
        }
        catch (Exception ex) {
            throw new XrayErrorException(String.format("Failed processing scan response: %s\n%s", ex.toString(), content));
        }
        if (result.get("errors") != null) {
            String resultStr = result.get("errors").toString();
            for (JsonNode error : result.get("errors")) {
                if (!error.get("status").toString().equals(XRAY_FATAL_FAIL_STATUS)) continue;
                throw new RuntimeException("Artifactory response: " + resultStr);
            }
            throw new XrayErrorException("Artifactory response: " + resultStr);
        }
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper.treeToValue(result, ArtifactoryXrayResponse.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ArtifactoryXrayResponse execute(HttpRequestBase httpRequest) throws InterruptedException, IOException {
        PreemptiveHttpClient client = this.httpClient.getHttpClient(90);
        int retryNum = 0;
        long lastConnectionAttemptMillis = 0L;
        HttpResponse response = null;
        while (true) {
            try {
                lastConnectionAttemptMillis = System.currentTimeMillis();
                ++retryNum;
                response = client.execute(httpRequest);
                ArtifactoryXrayResponse artifactoryXrayResponse = this.parseXrayScanResponse(response);
                this.releaseResponse(httpRequest, response);
                return artifactoryXrayResponse;
            }
            catch (XrayErrorException e) {
                this.handleException(retryNum, e);
                this.releaseResponse(httpRequest, response);
                continue;
            }
            catch (IOException e2) {
                block9: {
                    if (!this.isStableConnection(lastConnectionAttemptMillis)) break block9;
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException("Operation interrupted.");
                    }
                    retryNum = 0;
                    this.releaseResponse(httpRequest, response);
                    continue;
                    {
                        catch (Throwable throwable) {
                            this.releaseResponse(httpRequest, response);
                            throw throwable;
                        }
                    }
                }
                this.handleException(retryNum, e2);
                this.releaseResponse(httpRequest, response);
                continue;
            }
            break;
        }
    }

    private void releaseResponse(HttpRequestBase httpRequest, HttpResponse response) {
        if (response != null) {
            try {
                EntityUtils.consume(response.getEntity());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        httpRequest.releaseConnection();
    }

    private void handleException(int retryNum, IOException e) throws InterruptedException, IOException {
        if (5 <= retryNum) {
            throw e;
        }
        this.log.warn("Xray scan connection lost: " + e.getMessage() + ", attempting to reconnect...");
        Thread.sleep(30000L);
    }

    private class XrayErrorException
    extends IOException {
        private XrayErrorException(String message) {
            super(message);
        }
    }
}

