"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useStyleMarshal;
exports.getDragHandleRuleString = getDragHandleRuleString;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _useIsomorphicLayoutEffect = require("../../hooks/use-isomorphic-layout-effect");
var _attributes = require("../../utils/attributes");
/**
 * This is a vastly simplified version of the style marshal in `react-beautiful-dnd`.
 *
 * Most of the styles have been removed, as they are not required for native dragging.
 * They were only required in `react-beautiful-dnd` because it emulated dragging.
 */

// eslint-disable-next-line import/no-extraneous-dependencies

/**
 * Used to uniquely identify the style element.
 */
var styleContextIdAttribute = 'data-rbd-style-context-id';

/**
 * Returns the CSS string for the rule with the given selector and style
 * declarations.
 */
function getRuleString(_ref) {
  var selector = _ref.selector,
    styles = _ref.styles;
  var concatString = Object.entries(styles).map(function (_ref2) {
    var _ref3 = (0, _slicedToArray2.default)(_ref2, 2),
      property = _ref3[0],
      value = _ref3[1];
    return "".concat(property, ": ").concat(value, ";");
  }).join(' ');
  return "".concat(selector, " { ").concat(concatString, " }");
}

/**
 * Returns the rule string for drag handle styles.
 */
function getDragHandleRuleString(contextId) {
  var selector = "[".concat(_attributes.attributes.dragHandle.contextId, "=\"").concat(contextId, "\"]");
  var styles = {
    /**
     * Indicates the element is draggable.
     *
     * Although this is always applied, it will not be visible during drags
     * because the browser will override the cursor.
     */
    cursor: 'grab',
    /**
     * Improves the UX when dragging links on iOS.
     *
     * Without this a preview of the link will open. Although it is still
     * draggable, it is inconsistent with `react-beautiful-dnd`.
     */
    '-webkit-touch-callout': 'none'
  };
  return getRuleString({
    selector: selector,
    styles: styles
  });
}
function createStyleEl(_ref4) {
  var contextId = _ref4.contextId,
    nonce = _ref4.nonce;
  var el = document.createElement('style');
  if (nonce) {
    el.setAttribute('nonce', nonce);
  }
  el.setAttribute(styleContextIdAttribute, contextId);
  document.head.appendChild(el);
  return el;
}
function createStyleManager(_ref5) {
  var contextId = _ref5.contextId,
    nonce = _ref5.nonce;
  var el = createStyleEl({
    contextId: contextId,
    nonce: nonce
  });

  /**
   * Inject the style content.
   */
  el.textContent = getDragHandleRuleString(contextId);
  return function cleanup() {
    el.remove();
  };
}
function useStyleMarshal(_ref6) {
  var contextId = _ref6.contextId,
    nonce = _ref6.nonce;
  (0, _useIsomorphicLayoutEffect.useLayoutEffect)(function () {
    return createStyleManager({
      contextId: contextId,
      nonce: nonce
    });
  }, [contextId, nonce]);
}